/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.OrgUnitUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BgOrgUnitUtils {
    private static Color COLOR_DEFAULT = Color.BLACK;
    private static Color COLOR_SELECT = new Color(88, 195, 249, 200);
    public static final String NUMBER = "number";
    public static final String NAME = "name";

    public static Color getCOLOR_DEFAULT() {
        return COLOR_DEFAULT;
    }

    public static Color getCOLOR_SELECT() {
        return COLOR_SELECT;
    }

    public static SelectorItemCollection getBgOrgViewSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(NUMBER);
        sic.add(NAME);
        return sic;
    }

    public static BgOrgUnitInfo caseToBgOrgUnit(OrgUnitInfo orgUnit) {
        if (orgUnit == null) {
            return null;
        }
        BgOrgUnitInfo bgOrgUnit = new BgOrgUnitInfo();
        bgOrgUnit.setOrgUnitID(orgUnit.getId().toString());
        bgOrgUnit.setName(orgUnit.getName());
        bgOrgUnit.setNumber(orgUnit.getNumber());
        bgOrgUnit.setLongNumber(orgUnit.getLongNumber());
        bgOrgUnit.setLevel(orgUnit.getLevel());
        bgOrgUnit.setIsLeaf(orgUnit.isIsLeaf());
        return bgOrgUnit;
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId, String bgOrgViewId, boolean isPerimessionFilter) throws Exception {
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgViewId is null!!!");
        }
        boolean checkHasOrg = BgOrgUnitUtils.getBgOrgViewInterface().checkHasOrg(BOSUuid.read((String)bgOrgViewId));
        if (checkHasOrg) {
            return BgOrgUnitUtils.getBgOrgTreeMode(kdTree, orgUnitId, null, bgOrgViewId, isPerimessionFilter, null);
        }
        return OrgUnitUtils.getOrgTreeModel((KDTree)kdTree, (String)orgUnitId);
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId, String bgOrgViewId, boolean isPerimessionFilter, boolean isNeedAddSealUp) throws Exception {
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgViewId is null!!!");
        }
        boolean checkHasOrg = BgOrgUnitUtils.getBgOrgViewInterface().checkHasOrg(BOSUuid.read((String)bgOrgViewId));
        if (checkHasOrg) {
            return BgOrgUnitUtils.getBgOrgTreeMode(kdTree, orgUnitId, null, bgOrgViewId, isPerimessionFilter, null, isNeedAddSealUp);
        }
        return OrgUnitUtils.getOrgTreeModel((KDTree)kdTree, (String)orgUnitId);
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId) throws Exception {
        return BgOrgUnitUtils.getBgOrgTreeMode(kdTree, orgUnitId, listener, bgOrgViewId, true, null);
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId, boolean isVirtual, boolean isOnlyNoLeaf) throws Exception {
        return BgOrgUnitUtils.getBgOrgTreeMode2(kdTree, orgUnitId, listener, bgOrgViewId, true, null, isVirtual, isOnlyNoLeaf);
    }

    public static List<BOSUuid> getSelectOrgUnitInfo(KDTree kdTree) {
        if (kdTree == null) {
            return null;
        }
        ArrayList<BOSUuid> orgUnits = new ArrayList<BOSUuid>();
        return BgOrgUnitUtils.getSelectOrgUnitInfo((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), orgUnits);
    }

    private static List<BOSUuid> getSelectOrgUnitInfo(DefaultKingdeeTreeNode root, List<BOSUuid> orgUnits) {
        if (root == null || orgUnits == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo osi = null;
        OrgUnitInfo tmpUnit = null;
        BgOrgUnitInfo bgOrgUnit = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node.isChecked()) {
                if (node.getUserObject() instanceof BgOrgUnitInfo) {
                    bgOrgUnit = (BgOrgUnitInfo)node.getUserObject();
                    orgUnits.add(BOSUuid.read((String)bgOrgUnit.getOrgUnitID()));
                } else if (node.getUserObject() instanceof OrgStructureInfo) {
                    osi = (OrgStructureInfo)node.getUserObject();
                    orgUnits.add(osi.getUnit().getId());
                } else if (node.getUserObject() instanceof OrgUnitInfo) {
                    tmpUnit = (OrgUnitInfo)node.getUserObject();
                    orgUnits.add(tmpUnit.getId());
                }
            }
            if (node.isLeaf()) continue;
            orgUnits = BgOrgUnitUtils.getSelectOrgUnitInfo(node, orgUnits);
        }
        return orgUnits;
    }

    public static List<String> getSelectOrgUnitIds(KDTree kdTree) {
        if (kdTree == null || kdTree.getModel() == null) {
            return null;
        }
        ArrayList<String> orgUnits = new ArrayList<String>();
        return BgOrgUnitUtils.getSelectOrgUnitIds((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), orgUnits);
    }

    private static List<String> getSelectOrgUnitIds(DefaultKingdeeTreeNode root, List<String> orgUnitIds) {
        if (root == null || orgUnitIds == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = null;
        BgOrgUnitUtils.addNodeToList(orgUnitIds, root);
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            BgOrgUnitUtils.addNodeToList(orgUnitIds, node);
            if (node.isLeaf()) continue;
            orgUnitIds = BgOrgUnitUtils.getSelectOrgUnitIds(node, orgUnitIds);
        }
        return orgUnitIds;
    }

    protected static void addNodeToList(List<String> orgUnitIds, DefaultKingdeeTreeNode node) {
        if (node != null && node.isChecked()) {
            String orgUnitId = null;
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                BgOrgUnitInfo bgOrgUnit = (BgOrgUnitInfo)node.getUserObject();
                orgUnitId = bgOrgUnit.getOrgUnitID();
            } else if (node.getUserObject() instanceof OrgStructureInfo) {
                OrgStructureInfo os = (OrgStructureInfo)node.getUserObject();
                orgUnitId = os.getUnit().getId().toString();
            } else if (node.getUserObject() instanceof OrgUnitInfo) {
                orgUnitId = ((OrgUnitInfo)node.getUserObject()).getId().toString();
            }
            if (!StringUtils.isEmpty((String)orgUnitId) && !orgUnitIds.contains(orgUnitId)) {
                orgUnitIds.add(orgUnitId);
            }
        }
    }

    public static void selectOrgUnit(TreeModel ccTreeModel, boolean selected) {
        if (ccTreeModel == null) {
            return;
        }
        BgOrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)ccTreeModel.getRoot(), selected);
    }

    public static void selectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        if (BgOrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (BgOrgUnitUtils.canTheNodeBeSelected(node)) {
                node.setChecked(selected);
            }
            if (node == null || node.isLeaf()) continue;
            BgOrgUnitUtils.selectOrgUnit(node, selected);
        }
    }

    public static void selectLeafOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        if (BgOrgUnitUtils.canTheNodeBeSelected(root) && root.isLeaf()) {
            root.setChecked(selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (BgOrgUnitUtils.canTheNodeBeSelected(node) && node.isLeaf()) {
                node.setChecked(selected);
            }
            if (node == null || node.isLeaf()) continue;
            BgOrgUnitUtils.selectLeafOrgUnit(node, selected);
        }
    }

    public static void selectOrgUnit(KDTree kdTree, Set<String> selOrgUnitIds) {
        if (kdTree == null || selOrgUnitIds == null) {
            return;
        }
        BgOrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), selOrgUnitIds);
    }

    public static void selectOrgUnit(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) {
        if (root == null) {
            return;
        }
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        BgOrgUnitInfo bgOrgUnit = null;
        if (root.getUserObject() instanceof BgOrgUnitInfo) {
            bgOrgUnit = (BgOrgUnitInfo)root.getUserObject();
            if (selOrgUnitIds.contains(bgOrgUnit.getOrgUnitID())) {
                root.setChecked(true);
            }
        } else if (root.getUserObject() instanceof OrgStructureInfo) {
            oui = (OrgStructureInfo)root.getUserObject();
            if (oui.getUnit() != null && selOrgUnitIds.contains(oui.getUnit().getId().toString())) {
                root.setChecked(true);
            }
        } else if (root.getUserObject() instanceof OrgUnitInfo && selOrgUnitIds.contains((tmpUnit = (OrgUnitInfo)root.getUserObject()).getId().toString())) {
            root.setChecked(true);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            BgOrgUnitUtils.selectOrgUnit(node, selOrgUnitIds);
        }
    }

    public static void selectOrgUnitByIds(KDTree kdTree, Set<BOSUuid> selOrgUnitIds) {
        if (kdTree == null || selOrgUnitIds == null) {
            return;
        }
        BgOrgUnitUtils.selectOrgUnitByIds((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), selOrgUnitIds);
    }

    public static void selectOrgUnitByIds(DefaultKingdeeTreeNode root, Set<BOSUuid> selOrgUnitIds) {
        if (root == null && selOrgUnitIds == null) {
            return;
        }
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        BgOrgUnitInfo bgOrgUnit = null;
        if (root.getUserObject() instanceof BgOrgUnitInfo) {
            bgOrgUnit = (BgOrgUnitInfo)root.getUserObject();
            if (selOrgUnitIds.contains(BOSUuid.read((String)bgOrgUnit.getOrgUnitID())) && BgOrgUnitUtils.canTheNodeBeSelected(root)) {
                root.setChecked(true);
            }
        } else if (root.getUserObject() instanceof OrgStructureInfo) {
            oui = (OrgStructureInfo)root.getUserObject();
            if (oui.getUnit() != null && selOrgUnitIds.contains(oui.getUnit().getId()) && BgOrgUnitUtils.canTheNodeBeSelected(root)) {
                root.setChecked(true);
            }
        } else if (root.getUserObject() instanceof OrgUnitInfo && selOrgUnitIds.contains((tmpUnit = (OrgUnitInfo)root.getUserObject()).getId()) && BgOrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(true);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            BgOrgUnitUtils.selectOrgUnitByIds(node, selOrgUnitIds);
        }
    }

    public static void selectOrgUnitIds(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) {
        if (root == null || selOrgUnitIds == null) {
            return;
        }
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        BgOrgUnitInfo bgOrgUnit = null;
        if (root.getUserObject() instanceof BgOrgUnitInfo) {
            bgOrgUnit = (BgOrgUnitInfo)root.getUserObject();
            if (selOrgUnitIds.contains(bgOrgUnit.getOrgUnitID()) && BgOrgUnitUtils.canTheNodeBeSelected(root)) {
                root.setChecked(true);
            }
        } else if (root.getUserObject() instanceof OrgStructureInfo) {
            oui = (OrgStructureInfo)root.getUserObject();
            if (oui.getUnit() != null && selOrgUnitIds.contains(oui.getUnit().getId().toString()) && BgOrgUnitUtils.canTheNodeBeSelected(root)) {
                root.setChecked(true);
            }
        } else if (root.getUserObject() instanceof OrgUnitInfo && selOrgUnitIds.contains((tmpUnit = (OrgUnitInfo)root.getUserObject()).getId().toString()) && BgOrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(true);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            BgOrgUnitUtils.selectOrgUnitIds(node, selOrgUnitIds);
        }
    }

    public static void selectDirectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        if (BgOrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (!BgOrgUnitUtils.canTheNodeBeSelected(node)) continue;
            node.setChecked(selected);
        }
    }

    public static void selectBrotherOrgUnit(DefaultKingdeeTreeNode node, boolean selected) {
        if (node == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)node.getParent();
        if (root != null) {
            int count = root.getChildCount();
            for (int index = 0; index < count; ++index) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(index);
                node.setChecked(selected);
            }
        }
    }

    public static TreeModel getBgOrgTreeMode(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId, boolean isPermissionFilter, Set canDisplayOrgNumbers) throws Exception {
        if (kdTree == null) {
            return null;
        }
        String orgViewId = bgOrgViewId;
        TreeModel model = BgOrgTreeHelper.buildMultiTreeModel(kdTree, orgViewId, orgUnitId, isPermissionFilter, false, true);
        if (model != null) {
            if (canDisplayOrgNumbers != null) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
                for (int i = root.getChildCount() - 1; i >= 0; --i) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    if (child.getUserObject() == null || canDisplayOrgNumbers.contains(((DataBaseInfo)child.getUserObject()).getNumber())) continue;
                    root.remove(i);
                }
            }
            if (listener != null) {
                kdTree.addTreeWillExpandListener(listener);
            }
        }
        return model;
    }

    public static TreeModel getBgOrgTreeMode2(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId, final boolean isPermissionFilter, final Set canDisplayOrgNumbers, final boolean isVirtual, final boolean isOnlyNoLeaf) throws Exception {
        if (kdTree == null) {
            return null;
        }
        final String orgViewId = bgOrgViewId;
        TreeModel model = BgOrgTreeHelper.buildMultiTreeModelNoListener(kdTree, bgOrgViewId, orgUnitId, isPermissionFilter, false, isVirtual, isOnlyNoLeaf);
        if (model != null) {
            if (canDisplayOrgNumbers != null) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
                for (int i = root.getChildCount() - 1; i >= 0; --i) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    if (child.getUserObject() == null || canDisplayOrgNumbers.contains(((DataBaseInfo)child.getUserObject()).getNumber())) continue;
                    root.remove(i);
                }
            }
            if (listener == null) {
                kdTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                    @Override
                    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                        if (node == null) {
                            return;
                        }
                        try {
                            CoreBaseInfo orgInfo = (CoreBaseInfo)node.getUserObject();
                            if (orgInfo == null) {
                                return;
                            }
                            if (orgInfo.getBoolean("isChildLoaded")) {
                                return;
                            }
                            BgOrgUnitUtils.addChildNode(node, orgViewId, canDisplayOrgNumbers, isPermissionFilter, false, isVirtual, isOnlyNoLeaf);
                            orgInfo.setBoolean("isChildLoaded", true);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle((String)"", (Throwable)ex);
                        }
                    }

                    @Override
                    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                    }
                });
            } else {
                kdTree.addTreeWillExpandListener(listener);
            }
        }
        return model;
    }

    public static TreeModel getBgOrgTreeMode(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId, Boolean isPermissionFilter, Set canDisplayOrgNumbers, final boolean isNeedAddSealUp) throws Exception {
        if (kdTree == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        final String orgViewId = bgOrgViewId;
        TreeModel model = BgOrgUnitUtils.buildTreeModel(null, orgUnitId, bgOrgViewId, isPermissionFilter, isNeedAddSealUp);
        if (model != null) {
            if (canDisplayOrgNumbers != null) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
                for (int i = root.getChildCount() - 1; i >= 0; --i) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    if (child.getUserObject() == null || canDisplayOrgNumbers.contains(((DataBaseInfo)child.getUserObject()).getNumber())) continue;
                    root.remove(i);
                }
            }
            if (listener == null) {
                kdTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                    @Override
                    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                        if (node == null) {
                            return;
                        }
                        try {
                            CoreBaseInfo orgInfo = (CoreBaseInfo)node.getUserObject();
                            if (orgInfo == null) {
                                return;
                            }
                            if (orgInfo.getBoolean("isChildLoaded")) {
                                return;
                            }
                            BgOrgUnitUtils.addChildNode(node, orgViewId, isNeedAddSealUp);
                            BgOrgUnitUtils.setLoadChild(node);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle((String)"", (Throwable)ex);
                        }
                    }

                    @Override
                    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                    }
                });
            } else {
                kdTree.addTreeWillExpandListener(listener);
            }
        }
        return model;
    }

    private static TreeModel buildTreeModel(DefaultKingdeeTreeNode selectedNode, String orgUnitId, String bgOrgViewId, Boolean isPermissionFilter) throws Exception {
        com.kingdee.bos.workflow.biz.trans.TreeNode node = new com.kingdee.bos.workflow.biz.trans.TreeNode();
        selectedNode = BgOrgUnitUtils.getDirectChildNodes(selectedNode, orgUnitId, bgOrgViewId, isPermissionFilter);
        DefaultTreeModel model = null;
        if (selectedNode != null) {
            selectedNode.setTextColor(Color.BLACK);
            BgOrgUnitUtils.dealBgNode(selectedNode);
            model = new DefaultTreeModel((TreeNode)selectedNode);
        }
        return model;
    }

    private static TreeModel buildTreeModel(DefaultKingdeeTreeNode selectedNode, String orgUnitId, String bgOrgViewId, Boolean isPermissionFilter, Boolean isVirtual) throws Exception {
        com.kingdee.bos.workflow.biz.trans.TreeNode node = new com.kingdee.bos.workflow.biz.trans.TreeNode();
        selectedNode = BgOrgUnitUtils.getDirectChildNodes(selectedNode, orgUnitId, bgOrgViewId, isPermissionFilter, isVirtual);
        DefaultTreeModel model = null;
        if (selectedNode != null) {
            selectedNode.setTextColor(Color.BLACK);
            BgOrgUnitUtils.dealBgNode(selectedNode);
            model = new DefaultTreeModel((TreeNode)selectedNode);
        }
        return model;
    }

    private static TreeModel buildTreeModel(DefaultKingdeeTreeNode selectedNode, String orgUnitId, String bgOrgViewId, Boolean isPermissionFilter, boolean isNeedAddSealUp) throws Exception {
        selectedNode = BgOrgUnitUtils.getDirectChildNodes(selectedNode, orgUnitId, bgOrgViewId, isPermissionFilter, isNeedAddSealUp);
        DefaultTreeModel model = null;
        if (selectedNode != null) {
            selectedNode.setTextColor(Color.BLACK);
            BgOrgUnitUtils.dealBgNode(selectedNode);
            model = new DefaultTreeModel((TreeNode)selectedNode);
        }
        return model;
    }

    private static TreeModel buildTreeModel(DefaultKingdeeTreeNode selectedNode, String orgUnitId, String bgOrgViewId, Boolean isPermissionFilter, boolean isNeedAddSealUp, boolean isVirtual) throws Exception {
        selectedNode = BgOrgUnitUtils.getDirectChildNodes(selectedNode, orgUnitId, bgOrgViewId, isPermissionFilter, isNeedAddSealUp, isVirtual, false);
        DefaultTreeModel model = null;
        if (selectedNode != null) {
            selectedNode.setTextColor(Color.BLACK);
            BgOrgUnitUtils.dealBgNode(selectedNode);
            model = new DefaultTreeModel((TreeNode)selectedNode);
        }
        return model;
    }

    private static DefaultKingdeeTreeNode getDirectChildNodes(DefaultKingdeeTreeNode selectNode, String orgUnitId, String bgOrgViewId, boolean isUserPermissionFilter) throws BOSException, EASBizException {
        boolean isFirstLoad;
        CoreBaseInfo userObject = null;
        String parentID = null;
        boolean bl = isFirstLoad = selectNode == null;
        if (selectNode == null) {
            parentID = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId(orgUnitId, bgOrgViewId);
        } else {
            userObject = (CoreBaseInfo)selectNode.getUserObject();
            parentID = userObject.getId().toString();
        }
        BgOrgUnitCollection orgUnitColl = null;
        orgUnitColl = selectNode == null ? (BgOrgUnitCollection)BgOrgUnitUtils.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, parentID, false, true, isUserPermissionFilter, false) : (BgOrgUnitCollection)BgOrgUnitUtils.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, parentID, false, false, isUserPermissionFilter, false);
        ArrayList<BgOrgUnitInfo> childNodes = new ArrayList<BgOrgUnitInfo>();
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            childNodes.add(orgUnitColl.get(i));
        }
        if ((selectNode = NewOrgViewHelper.buildTreeByList((DefaultKingdeeTreeNode)selectNode, childNodes)) != null && selectNode.getChildCount() > 0) {
            DefaultKingdeeTreeNode node = null;
            BgOrgUnitInfo bgOrgUnit = null;
            int in = selectNode.getChildCount();
            for (int i = 0; i < in; ++i) {
                node = (DefaultKingdeeTreeNode)selectNode.getChildAt(i);
                if (!(node.getUserObject() instanceof BgOrgUnitInfo) || !(bgOrgUnit = (BgOrgUnitInfo)node.getUserObject()).isIsVirtual()) continue;
                node.setText(bgOrgUnit.getName() + "(s)");
            }
        }
        if (selectNode != null && selectNode.getUserObject() != null) {
            BgOrgUnitInfo rootOrg = (BgOrgUnitInfo)selectNode.getUserObject();
            if (isFirstLoad && !rootOrg.isIsLeaf() && selectNode.getChildCount() == 0) {
                selectNode.add((MutableTreeNode)new DefaultKingdeeTreeNode());
                BgOrgUnitUtils.addChildNode(selectNode, bgOrgViewId, isUserPermissionFilter);
            }
            BgOrgUnitUtils.setLoadChild(selectNode);
        }
        return selectNode;
    }

    private static DefaultKingdeeTreeNode getDirectChildNodes(DefaultKingdeeTreeNode selectNode, String orgUnitId, String bgOrgViewId, Boolean isUserPermissionFilter, boolean isNeedAddSealUp) throws BOSException, EASBizException {
        boolean isFirstLoad;
        CoreBaseInfo userObject = null;
        String parentID = null;
        boolean bl = isFirstLoad = selectNode == null;
        if (selectNode == null) {
            parentID = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId(orgUnitId, bgOrgViewId);
        } else {
            userObject = (CoreBaseInfo)selectNode.getUserObject();
            parentID = userObject.getId().toString();
        }
        BgOrgUnitCollection orgUnitColl = null;
        orgUnitColl = selectNode == null ? (BgOrgUnitCollection)BgOrgUnitUtils.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, parentID, isNeedAddSealUp, true, isUserPermissionFilter, false) : (BgOrgUnitCollection)BgOrgUnitUtils.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, parentID, isNeedAddSealUp, false, isUserPermissionFilter, false);
        ArrayList<BgOrgUnitInfo> childNodes = new ArrayList<BgOrgUnitInfo>();
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            childNodes.add(orgUnitColl.get(i));
        }
        if ((selectNode = NewOrgViewHelper.buildTreeByList((DefaultKingdeeTreeNode)selectNode, childNodes)) != null && selectNode.getUserObject() != null) {
            BgOrgUnitInfo rootOrg = (BgOrgUnitInfo)selectNode.getUserObject();
            if (isFirstLoad && !rootOrg.isIsLeaf() && selectNode.getChildCount() == 0) {
                selectNode.add((MutableTreeNode)new DefaultKingdeeTreeNode());
                BgOrgUnitUtils.addChildNode(selectNode, bgOrgViewId, isNeedAddSealUp);
            }
            BgOrgUnitUtils.setLoadChild(selectNode);
        }
        return selectNode;
    }

    private static DefaultKingdeeTreeNode getDirectChildNodes(DefaultKingdeeTreeNode selectNode, String orgUnitId, String bgOrgViewId, Boolean isUserPermissionFilter, boolean isNeedAddSealUp, boolean isVirtual, boolean isOnlyNoLeaf) throws BOSException, EASBizException {
        boolean isFirstLoad;
        CoreBaseInfo userObject = null;
        String parentID = null;
        boolean bl = isFirstLoad = selectNode == null;
        if (selectNode == null) {
            parentID = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId(orgUnitId, bgOrgViewId, isVirtual);
        } else {
            userObject = (CoreBaseInfo)selectNode.getUserObject();
            parentID = userObject.getId().toString();
        }
        BgOrgUnitCollection orgUnitColl = null;
        orgUnitColl = selectNode == null ? (BgOrgUnitCollection)BgOrgUnitUtils.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, parentID, isNeedAddSealUp, true, isUserPermissionFilter, isVirtual, isOnlyNoLeaf) : (BgOrgUnitCollection)BgOrgUnitUtils.getBgOrgViewInterface().getDirectOrgUnits(bgOrgViewId, parentID, isNeedAddSealUp, false, isUserPermissionFilter, isVirtual, isOnlyNoLeaf);
        ArrayList<BgOrgUnitInfo> childNodes = new ArrayList<BgOrgUnitInfo>();
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            childNodes.add(orgUnitColl.get(i));
        }
        if ((selectNode = NewOrgViewHelper.buildTreeByList((DefaultKingdeeTreeNode)selectNode, childNodes)) != null && selectNode.getUserObject() != null) {
            BgOrgUnitInfo rootOrg = (BgOrgUnitInfo)selectNode.getUserObject();
            if (isFirstLoad && !rootOrg.isIsLeaf() && selectNode.getChildCount() == 0) {
                selectNode.add((MutableTreeNode)new DefaultKingdeeTreeNode());
                BgOrgUnitUtils.addChildNode(selectNode, bgOrgViewId, isNeedAddSealUp);
            }
            BgOrgUnitUtils.setLoadChild(selectNode);
        }
        return selectNode;
    }

    public static String getBgOrgUnitIdByOrgUnitId(String orgUnitId, String bgOrgViewId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (orgUnitId != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId));
        evi.setFilter(filter);
        evi.getSelector().add("id");
        BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        String id = null;
        if (!colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getId() == null) continue;
                id = colls.get(i).getId().toString();
            }
        }
        return id;
    }

    public static String getBgOrgUnitIdByOrgUnitId(String orgUnitId, String bgOrgViewId, boolean isVirtual) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (orgUnitId != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId));
        filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)isVirtual));
        evi.setFilter(filter);
        evi.getSelector().add("id");
        BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        String id = null;
        if (!colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getId() == null) continue;
                id = colls.get(i).getId().toString();
            }
        }
        return id;
    }

    public static SelectorItemCollection getBgOrgUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgUnitID"));
        sic.add(new SelectorItemInfo("viewID"));
        sic.add(new SelectorItemInfo(NUMBER));
        sic.add(new SelectorItemInfo(NAME));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("polAlgorithm"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isOUSealUp"));
        sic.add(new SelectorItemInfo("isVirtual"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.orgUnitID"));
        sic.add(new SelectorItemInfo("parent.viewID"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.level"));
        sic.add(new SelectorItemInfo("parent.isLeaf"));
        sic.add(new SelectorItemInfo("parent.longNumber"));
        sic.add(new SelectorItemInfo("parent.isOUSealUp"));
        sic.add(new SelectorItemInfo("periodName"));
        return sic;
    }

    public static BgOrgUnitInfo getParentByOrgId(String orgUnitId, String bgOrgViewId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = BgOrgUnitUtils.getBgOrgUnitSelector();
        evi.getSelector().addObjectCollection((IObjectCollection)sic);
        if (orgUnitId != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId));
        evi.setFilter(filter);
        BgOrgUnitInfo info = null;
        BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        Object id = null;
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getId() == null) continue;
                info = colls.get(i).getParent() == null ? colls.get(i) : colls.get(i).getParent();
            }
        }
        return info;
    }

    public static DefaultKingdeeTreeNode getDefaultKingdeeTreeNode(DefaultKingdeeTreeNode root, String bgOrgViewId) throws EASBizException, BOSException {
        return BgOrgUnitUtils.getDirectChildNodes(root, null, bgOrgViewId, true);
    }

    protected static IBgOrgUnit getBgOrgUnitInterface() throws BOSException {
        return BgOrgUnitFactory.getRemoteInstance();
    }

    protected static IBgOrgView getBgOrgViewInterface() throws BOSException {
        return BgOrgViewFactory.getRemoteInstance();
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, String bgOrgViewId, boolean isPermissionFilter) throws EASBizException, BOSException {
        BgOrgUnitUtils.addChildNode(root, bgOrgViewId, null, isPermissionFilter);
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, String bgOrgViewId, boolean isPermissionFilter, boolean isNeedAddSealUp) throws EASBizException, BOSException {
        BgOrgUnitUtils.addChildNode(root, bgOrgViewId, null, isPermissionFilter, isNeedAddSealUp, true, false);
    }

    public static void setLoadChild(DefaultKingdeeTreeNode selectNode) {
        ((CoreBaseInfo)selectNode.getUserObject()).setBoolean("isChildLoaded", true);
    }

    public static boolean isLoadedChild(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode tempNode;
        int childCount = node.getChildCount();
        if (childCount == 1 && (tempNode = (DefaultKingdeeTreeNode)node.getChildAt(0)).getUserObject() != null) {
            return true;
        }
        return node.getUserObject() != null && node.getUserObject() instanceof CoreBaseInfo && ((CoreBaseInfo)node.getUserObject()).get("isChildLoaded") != null && Boolean.parseBoolean(((CoreBaseInfo)node.getUserObject()).get("isChildLoaded").toString());
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, String bgOrgViewId, Set canDisplayNumbers, boolean isPermissionFilter) throws EASBizException, BOSException {
        int index;
        if (root == null) {
            return;
        }
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgUnitUtils.addChildNode error : BgOrgViewId is Null !!!!!");
        }
        if (BgOrgUnitUtils.isLoadedChild(root)) {
            return;
        }
        root.removeAllChildren();
        DefaultKingdeeTreeNode _root = BgOrgUnitUtils.getDirectChildNodes(root, null, bgOrgViewId, isPermissionFilter);
        BgOrgUnitUtils.dealBgNode(_root);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (index = _root.getChildCount(); index > 0; --index) {
            list.add(_root.getChildAt(index - 1));
        }
        root.removeAllChildren();
        if (!list.isEmpty()) {
            for (index = list.size(); index > 0; --index) {
                _root = (DefaultKingdeeTreeNode)list.get(index - 1);
                if (canDisplayNumbers != null && !canDisplayNumbers.contains(((DataBaseInfo)_root.getUserObject()).getNumber())) continue;
                root.add((MutableTreeNode)_root);
            }
        }
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, String bgOrgViewId, Set canDisplayNumbers, boolean isPermissionFilter, boolean isNeedAddSealUp, boolean isVirtual, boolean isOnlyNoLeaf) throws EASBizException, BOSException {
        int index;
        if (root == null) {
            return;
        }
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgUnitUtils.addChildNode error : BgOrgViewId is Null !!!!!");
        }
        if (BgOrgUnitUtils.isLoadedChild(root)) {
            return;
        }
        root.removeAllChildren();
        DefaultKingdeeTreeNode _root = BgOrgUnitUtils.getDirectChildNodes(root, null, bgOrgViewId, isPermissionFilter, isNeedAddSealUp, isVirtual, isOnlyNoLeaf);
        BgOrgUnitUtils.dealBgNode(_root);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (index = _root.getChildCount(); index > 0; --index) {
            list.add(_root.getChildAt(index - 1));
        }
        root.removeAllChildren();
        if (!list.isEmpty()) {
            for (index = list.size(); index > 0; --index) {
                _root = (DefaultKingdeeTreeNode)list.get(index - 1);
                if (canDisplayNumbers != null && !canDisplayNumbers.contains(((DataBaseInfo)_root.getUserObject()).getNumber())) continue;
                root.add((MutableTreeNode)_root);
            }
        }
    }

    public static void dealBgNode(DefaultKingdeeTreeNode root) {
        BgOrgUnitUtils.dealBgNode(root, true);
    }

    public static void dealBgNode(DefaultKingdeeTreeNode root, boolean isAddChild) {
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        BgOrgUnitInfo unitInfo = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            unitInfo = (BgOrgUnitInfo)node.getUserObject();
            if (unitInfo == null || unitInfo.isIsVirtual()) {
                node.setCheckBoxVisible(false);
            }
            node.setTextColor(BgOrgUnitUtils.getCOLOR_DEFAULT());
            if (!isAddChild || node.getChildCount() != 0 || unitInfo == null || unitInfo.isIsLeaf()) continue;
            node.add((MutableTreeNode)new DefaultKingdeeTreeNode());
        }
    }

    public static TreeModel clipAndCloneTreeModel(TreeModel model, String[] fields, String value, boolean isBlured) {
        if (fields == null || fields.length == 0) {
            return model;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)BgOrgUnitUtils.deepCloneTreeModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            BgOrgUnitUtils.disableTreeNodeByFilterCondition(root, fields, value, isBlured);
            OrgF7InnerUtils.clipTreeNodeByColor((DefaultKingdeeTreeNode)root);
        }
        return treeModel;
    }

    public static TreeModel clipAndCloneTreeModel(TreeModel model, String[] fields, String value, boolean isBlured, Set orgSets) {
        if (fields == null || fields.length == 0) {
            return model;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)BgOrgUnitUtils.deepCloneTreeModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            BgOrgUnitUtils.disableTreeNodeByFilterCondition(root, fields, value, isBlured, orgSets);
            OrgF7InnerUtils.clipTreeNodeByColor((DefaultKingdeeTreeNode)root);
        }
        return treeModel;
    }

    public static TreeModel deepCloneTreeModel(TreeModel model) {
        if (model.getRoot() != null) {
            DefaultKingdeeTreeNode newRoot = BgOrgUnitUtils.cloneTreeNode((DefaultKingdeeTreeNode)model.getRoot());
            return new DefaultTreeModel((TreeNode)newRoot);
        }
        return new DefaultTreeModel(null);
    }

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, String[] fields, String value, boolean isBlured) {
        BgOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            unitInfo = (BgOrgUnitInfo)node.getUserObject();
            if (unitInfo == null) continue;
            if (unitInfo.isIsVirtual()) {
                node.setCheckBoxVisible(false);
            }
            if (value == null || value.trim().length() == 0) continue;
            boolean isShow = false;
            for (int i = 0; i < fields.length; ++i) {
                String numberOrName = null;
                if (NUMBER.equalsIgnoreCase(fields[i])) {
                    numberOrName = unitInfo.getNumber();
                } else if (NAME.equalsIgnoreCase(fields[i])) {
                    numberOrName = unitInfo.getName();
                }
                if (numberOrName == null) continue;
                if (isBlured) {
                    if (numberOrName.indexOf(value) < 0) continue;
                    isShow = true;
                    break;
                }
                if (!numberOrName.equals(value)) continue;
                isShow = true;
                break;
            }
            if (isShow) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, String[] fields, String value, boolean isBlured, Set orgSets) {
        BgOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (node.getUserObject() instanceof OrgStructureInfo) {
                OrgStructureInfo orginfo = (OrgStructureInfo)node.getUserObject();
                unitInfo = new BgOrgUnitInfo();
                unitInfo.setOrgUnitID(orginfo.getUnit().getId().toString());
                unitInfo.setName(orginfo.getUnit().getName());
                unitInfo.setNumber(orginfo.getUnit().getNumber());
            } else {
                unitInfo = (BgOrgUnitInfo)node.getUserObject();
            }
            if (unitInfo.isIsVirtual()) {
                node.setCheckBoxVisible(false);
            }
            if (value == null || value.trim().length() == 0) continue;
            boolean isShow = false;
            for (int i = 0; i < fields.length; ++i) {
                String numberOrName = null;
                if (NUMBER.equalsIgnoreCase(fields[i])) {
                    numberOrName = unitInfo.getNumber();
                } else if (NAME.equalsIgnoreCase(fields[i])) {
                    numberOrName = unitInfo.getName();
                }
                if (numberOrName == null) continue;
                if (isBlured) {
                    if (numberOrName.indexOf(value) < 0) continue;
                    isShow = true;
                    if (orgSets == null || !orgSets.contains(BOSUuid.read((String)unitInfo.getOrgUnitID()))) break;
                    node.setTextColor(Color.RED);
                    break;
                }
                if (!numberOrName.equals(value)) continue;
                isShow = true;
                if (orgSets == null || !orgSets.contains(BOSUuid.read((String)unitInfo.getOrgUnitID()))) break;
                node.setTextColor(Color.RED);
                break;
            }
            if (isShow) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    private static DefaultKingdeeTreeNode cloneTreeNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode(node.getUserObject());
        newNode.setText(node.getText());
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            DefaultKingdeeTreeNode newChildNode = BgOrgUnitUtils.cloneTreeNode(childNode);
            newNode.add((MutableTreeNode)newChildNode);
        }
        return newNode;
    }

    public static boolean checkBgOrgUnitIsOUSealUp(BOSUuid bgOrgViewId, BOSUuid orgUnitId) throws BOSException {
        if (bgOrgViewId == null || orgUnitId == null) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitId", (Object)orgUnitId.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isOUSealUp");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
        if (colls != null && !colls.isEmpty()) {
            return colls.get(0).isIsOUSealUp();
        }
        return false;
    }

    public static boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Set<String> getBgOrgViewIds(Context ctx, BOSUuid orgUnitId) throws BOSException, EASBizException {
        HashSet<String> orgViewIds = new HashSet<String>();
        if (ctx == null || orgUnitId == null) {
            return orgViewIds;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FViewId from T_MBG_BgOrgUnit where FOrgUnitID = ?", (Object[])new Object[]{orgUnitId.toString()});
            while (rst.next()) {
                orgViewIds.add(rst.getString("FViewId"));
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(rst, null, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return orgViewIds;
    }

    public static void removeTreeWillExpandListeners(KDTree treeOrgUnit) {
        if (treeOrgUnit == null || treeOrgUnit.getTreeWillExpandListeners() == null || treeOrgUnit.getTreeWillExpandListeners().length <= 0) {
            return;
        }
        for (int index = treeOrgUnit.getTreeWillExpandListeners().length - 1; index >= 0; --index) {
            treeOrgUnit.removeTreeWillExpandListener(treeOrgUnit.getTreeWillExpandListeners()[index]);
        }
    }

    public static DefaultKingdeeTreeNode getDefaultKingdeeTreeNoVirtualNode(DefaultKingdeeTreeNode root, String bgOrgViewId) throws EASBizException, BOSException {
        return BgOrgUnitUtils.getDirectChildNodes(root, null, bgOrgViewId, true, false, false, false);
    }

    public static TreeModel getBgOrgTreeModel(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId, Boolean isPermissionFilter, Set<String> canDisplayOrgNumbers, boolean isShowVirtualNode) throws Exception {
        TreeModel treeModel = null;
        return treeModel;
    }

    public static TreeModel loadBgOrgTreeModel(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId, Boolean isPermissionFilter, Set<String> canDisplayOrgNumbers, boolean isShowVirtualNode) throws Exception {
        TreeModel treeModel = BgOrgUnitFactory.getRemoteInstance().getFullBgOrgModel(bgOrgViewId, orgUnitId, false, false, isPermissionFilter, isShowVirtualNode, false);
        return treeModel;
    }

    public static TreeModel loadBgOrgTreeModel(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener, String bgOrgViewId, Boolean isPermissionFilter, Set<String> canDisplayOrgNumbers, boolean isShowVirtualNode, boolean isContainSealUp) throws Exception {
        TreeModel treeModel = BgOrgUnitFactory.getRemoteInstance().getFullBgOrgModel(bgOrgViewId, orgUnitId, isContainSealUp, false, isPermissionFilter, isShowVirtualNode, false);
        return treeModel;
    }

    private static void getAllOrgUnits(BgOrgUnitInfo bgOrgUnit, List<BgOrgUnitInfo> orgUnits) {
        if (bgOrgUnit == null || orgUnits == null) {
            return;
        }
        orgUnits.add(bgOrgUnit);
        List<BgOrgUnitInfo> children = bgOrgUnit.getChildren();
        if (children != null && !children.isEmpty()) {
            BgOrgUnitInfo subOrgUnit = null;
            int in = children.size();
            for (int i = 0; i < in; ++i) {
                subOrgUnit = children.get(i);
                BgOrgUnitUtils.getAllOrgUnits(subOrgUnit, orgUnits);
            }
        }
    }

    public static List<BgOrgUnitInfo> getAllOrgUnits(List<BgOrgUnitInfo> orgUnits) {
        ArrayList<BgOrgUnitInfo> allOrgUnits = new ArrayList<BgOrgUnitInfo>();
        if (orgUnits == null || orgUnits.isEmpty()) {
            return allOrgUnits;
        }
        BgOrgUnitInfo bgOrgUnit = null;
        int in = orgUnits.size();
        for (int i = 0; i < in; ++i) {
            bgOrgUnit = orgUnits.get(i);
            BgOrgUnitUtils.getAllOrgUnits(bgOrgUnit, allOrgUnits);
        }
        return allOrgUnits;
    }

    public static Map<String, List<BgOrgUnitInfo>> getParentOrgUnits(List<BgOrgUnitInfo> allOrgUnits, boolean isAllOrg) {
        HashMap<String, List<BgOrgUnitInfo>> parentOrgUnitsMap = new HashMap<String, List<BgOrgUnitInfo>>();
        if (allOrgUnits == null || allOrgUnits.isEmpty()) {
            return parentOrgUnitsMap;
        }
        ArrayList<BgOrgUnitInfo> parentOrgUnitsList = null;
        BgOrgUnitInfo bgOrgUnit = null;
        int in = allOrgUnits.size();
        for (int i = 0; i < in; ++i) {
            bgOrgUnit = allOrgUnits.get(i);
            if (!(isAllOrg ? isAllOrg : bgOrgUnit.isIsLeaf() && !bgOrgUnit.isIsVirtual())) continue;
            if (parentOrgUnitsMap.containsKey(bgOrgUnit.getOrgUnitID())) {
                parentOrgUnitsList = (List)parentOrgUnitsMap.get(bgOrgUnit.getOrgUnitID());
            } else {
                parentOrgUnitsList = new ArrayList();
                parentOrgUnitsMap.put(bgOrgUnit.getOrgUnitID(), parentOrgUnitsList);
            }
            BgOrgUnitUtils.getParentOrgUnits(bgOrgUnit, parentOrgUnitsList);
        }
        return parentOrgUnitsMap;
    }

    private static void getParentOrgUnits(BgOrgUnitInfo bgOrgUnit, List<BgOrgUnitInfo> parentOrgUnitsList) {
        if (bgOrgUnit == null || parentOrgUnitsList == null) {
            return;
        }
        BgOrgUnitInfo parOrgUnit = bgOrgUnit.getParent();
        if (parOrgUnit != null) {
            parentOrgUnitsList.add(parOrgUnit);
            BgOrgUnitUtils.getParentOrgUnits(parOrgUnit, parentOrgUnitsList);
        }
    }
}

