/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.AbstractBgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsCollection;
import com.kingdee.eas.ma.mbg.BgSpecialItemsFactory;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgSpecialItems;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.IMBGViewListFormFacade;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgSpecialInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgSpecialBudgetHelper {
    public static final String BG_SPECIAL_ITEMS = "bgSpecialItems";
    public static Map<String, Set<String>> dimSrcMap = null;

    public static Map<String, Set<String>> getDimSrcMap() {
        if (dimSrcMap == null) {
            dimSrcMap = new HashMap<String, Set<String>>();
        }
        return dimSrcMap;
    }

    public static void clearSrcMap() {
        dimSrcMap = null;
    }

    public static boolean checkIsSpecialBudget(BgTemplateInfo bgTemplateInfo) {
        boolean isSpecialBudget = false;
        if (bgTemplateInfo != null) {
            if (bgTemplateInfo.getBgSpecialItems() != null && !bgTemplateInfo.getBgSpecialItems().isEmpty()) {
                isSpecialBudget = true;
            }
            if (bgTemplateInfo.getFormType().getValue() == 8) {
                isSpecialBudget = true;
            }
        }
        return isSpecialBudget;
    }

    public static boolean checkIsSpecialBudget(IBgSpecialInfo bgFormInfo) {
        return bgFormInfo != null && bgFormInfo.isSpecial();
    }

    public static String getBgCslExpressionBySpecialItem(IBgSpecialInfo bgFormInfo, String expression, String srcNumber) {
        if (!BgSpecialBudgetHelper.checkIsSpecialBudget(bgFormInfo)) {
            return expression;
        }
        String dimensionNumber = bgFormInfo.getSpecialItemNumber();
        if (!StringUtils.isEmpty((String)dimensionNumber) && dimensionNumber.contains(",")) {
            String[] expre;
            for (String dimNumber : expre = dimensionNumber.split(",")) {
                if (!srcNumber.equals(dimNumber.split(":")[0])) continue;
                return dimNumber.split(":")[1];
            }
        }
        return expression;
    }

    public static String getBgExpressionBySpecialItem(String eBgSchemeNumber, IBgSpecialInfo bgFormInfo, String expression) {
        if (!BgSpecialBudgetHelper.checkIsSpecialBudget(bgFormInfo)) {
            return expression;
        }
        if (StringUtils.isEmpty((String)eBgSchemeNumber) && !StringUtils.isEmpty((String)bgFormInfo.getBgScheme().getNumber())) {
            eBgSchemeNumber = bgFormInfo.getBgScheme().getNumber();
        }
        Set<String> srcNumbers = null;
        if (BgSpecialBudgetHelper.getDimSrcMap().containsKey(eBgSchemeNumber)) {
            srcNumbers = BgSpecialBudgetHelper.getDimSrcMap().get(eBgSchemeNumber);
        } else {
            try {
                Context ctx;
                Context context = ctx = ConfigMDUtil.isClient() ? null : ConfigMDUtil.getContext();
                if (!StringUtils.isEmpty((String)eBgSchemeNumber)) {
                    BgSchemeDimensionHelper schemeHelper = null;
                    schemeHelper = new BgSchemeDimensionHelper(ctx, eBgSchemeNumber, true);
                    srcNumbers = schemeHelper.getSrcNumbers();
                    BgSpecialBudgetHelper.getDimSrcMap().put(eBgSchemeNumber, srcNumbers);
                }
            }
            catch (Exception ctx) {
                // empty catch block
            }
        }
        String dimensionNumber = bgFormInfo.getSpecialItemNumber();
        if (!StringUtils.isEmpty((String)expression) && expression.contains(",")) {
            String[] expre = expression.split(",");
            Set<String> expSet = BgSpecialBudgetHelper.arrayToSet(expre);
            Set<String> expSrcSet = BgSpecialBudgetHelper.getSrcSet(expre);
            if (!StringUtils.isEmpty((String)dimensionNumber) && dimensionNumber.contains(",")) {
                String[] dimNum = dimensionNumber.split(",");
                Set<String> dimNumSet = BgSpecialBudgetHelper.arrayToSet(dimNum);
                String nu2 = null;
                boolean isExist = false;
                for (String nu2 : dimNumSet) {
                    if (expSet.contains(nu2) || expSrcSet != null && nu2.contains(":") && expSrcSet.contains(nu2.split(":")[0]) || srcNumbers != null && !srcNumbers.contains(nu2.split(":")[0])) continue;
                    expression = expression + "," + nu2;
                    isExist = true;
                }
                if (isExist && expression.endsWith(",")) {
                    expression = expression.substring(0, expression.length());
                }
            } else if (!StringUtils.isEmpty((String)dimensionNumber) && expression.indexOf(dimensionNumber) < 0) {
                String[] dimNum = null;
                dimNum = dimensionNumber.contains(",") ? dimensionNumber.split(",") : new String[]{dimensionNumber};
                Set<String> dimNumSet = BgSpecialBudgetHelper.arrayToSet(dimNum);
                String nu3 = null;
                for (String nu3 : dimNumSet) {
                    if (srcNumbers == null || !srcNumbers.contains(nu3.split(":")[0]) || expSrcSet.contains(nu3.split(":")[0])) continue;
                    expression = expression + "," + nu3;
                }
                if (expression.endsWith(",")) {
                    expression = expression.substring(0, expression.length());
                }
            }
        } else if (!StringUtils.isEmpty((String)dimensionNumber) && expression.indexOf(dimensionNumber) < 0) {
            String[] dimNum = null;
            dimNum = dimensionNumber.contains(",") ? dimensionNumber.split(",") : new String[]{dimensionNumber};
            Set<String> dimNumSet = BgSpecialBudgetHelper.arrayToSet(dimNum);
            String nu4 = null;
            for (String nu4 : dimNumSet) {
                if (srcNumbers == null || !srcNumbers.contains(nu4.split(":")[0])) continue;
                expression = expression + "," + nu4;
            }
            if (expression.endsWith(",")) {
                expression = expression.substring(0, expression.length());
            }
        }
        return expression;
    }

    public static Set<String> arrayToSet(String[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int index = 0; index < arr.length; ++index) {
            set.add(arr[index]);
        }
        return set;
    }

    private static Set<String> getSrcSet(String[] dimNums) {
        if (dimNums == null || dimNums.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int index = 0; index < dimNums.length; ++index) {
            if (!dimNums[index].contains(":")) continue;
            set.add(dimNums[index].split(":")[0]);
        }
        return set;
    }

    public static BgSpecialItemsInfo getBgSpecialItemByTemplate(Context ctx, BgTemplateInfo bgTemplateInfo) throws BOSException {
        if (bgTemplateInfo == null) {
            return null;
        }
        AbstractBgSpecialItemsInfo itemsInfo = null;
        if (bgTemplateInfo.getBgSpecialItems() != null && !bgTemplateInfo.getBgSpecialItems().isEmpty()) {
            itemsInfo = bgTemplateInfo.getBgSpecialItems().get(0);
        }
        if (itemsInfo == null || itemsInfo != null && StringUtils.isEmpty((String)itemsInfo.getDimensionNumber())) {
            IBgSpecialItems ibs = null;
            ibs = ctx == null ? BgSpecialItemsFactory.getRemoteInstance() : BgSpecialItemsFactory.getLocalInstance(ctx);
            BgSpecialItemsCollection colls = ibs.getBgSpecialItemsCollection("select id, dimensionNumber, dimensionName, memberName, canAddMember, dimensionAlias, hide where bgTemplate = '" + bgTemplateInfo.getId().toString() + "'");
            if (colls != null && !colls.isEmpty()) {
                itemsInfo = colls.get(0);
            }
        }
        return itemsInfo;
    }

    public static BgSpecialItemsInfo getBgSpecialItemByForm(Context ctx, BgFormInfo bgFormInfo) throws BOSException {
        if (bgFormInfo == null) {
            return null;
        }
        BgSpecialItemsInfo itemsInfo = null;
        if (bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty()) {
            itemsInfo = bgFormInfo.getBgSpecialItems().get(0);
        } else {
            IBgSpecialItems ibs = null;
            ibs = ctx == null ? BgSpecialItemsFactory.getRemoteInstance() : BgSpecialItemsFactory.getLocalInstance(ctx);
            BgSpecialItemsCollection colls = ibs.getBgSpecialItemsCollection("select id, dimensionNumber, dimensionName, memberName, memberDisplayName, dimensionAlias where bgTemplate = '" + bgFormInfo.getId().toString() + "'");
            if (colls != null && !colls.isEmpty()) {
                itemsInfo = colls.get(0);
            }
        }
        return itemsInfo;
    }

    public static boolean updateBgSpecialItem(Context ctx, BgFormInfo bgFormInfo, BgTemplateInfo bgTemplate, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        if (bgFormInfo == null || bgTemplate == null) {
            return false;
        }
        BgSpecialItemsInfo templateSpecialItem = null;
        if (bgTemplate.getBgSpecialItems() != null && !bgTemplate.isEmpty()) {
            templateSpecialItem = BgSpecialBudgetHelper.getBgSpecialItemByTemplate(ctx, bgTemplate);
        }
        BgSpecialItemsInfo formSpecialItem = null;
        if (bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.isEmpty()) {
            formSpecialItem = BgSpecialBudgetHelper.getBgSpecialItemByForm(ctx, bgFormInfo);
        }
        if (templateSpecialItem == null) {
            if (formSpecialItem == null) {
                return true;
            }
            if (formSpecialItem != null) {
                bgFormInfo.getBgSpecialItems().clear();
                return true;
            }
        } else {
            if (formSpecialItem == null) {
                return false;
            }
            Map<String, List<BgDimensionMember>> templateDim = BgSpecialBudgetHelper.getDimMemberFromTemplate(ctx, templateSpecialItem, bgFormInfo.getOrgUnit().getId().toString(), schemeHelper);
            Map<String, BgDimensionMember> formDim = BgSpecialBudgetHelper.getDimMember(formSpecialItem);
            StringBuffer number = new StringBuffer();
            StringBuffer name = new StringBuffer();
            StringBuffer dimName = new StringBuffer();
            StringBuffer displayName = new StringBuffer();
            StringBuffer hide = new StringBuffer();
            boolean hasHide = false;
            BgDimensionMember member = null;
            BgDimensionMember tempMember = null;
            for (String srcNumber : templateDim.keySet()) {
                member = templateDim.get(srcNumber) == null || templateDim.get(srcNumber).size() != 1 ? null : templateDim.get(srcNumber).get(0);
                tempMember = member;
                if (number.length() > 0) {
                    hide.append(",");
                    number.append(",");
                    name.append(DimensionConstants.TICK_SEPARATOR);
                    displayName.append(",");
                    dimName.append(",");
                }
                if (member == null) {
                    if (formDim.get(srcNumber) == null) {
                        return false;
                    }
                    member = formDim.get(srcNumber);
                }
                number.append(DimensionFormulaHelper.getCombination(srcNumber, member.getNumber()));
                name.append(member.getName());
                displayName.append(DimensionFormulaHelper.getCombination(schemeHelper.getDimensionBySrcNumber().get(srcNumber).getAlias(), member.getName()));
                dimName.append(schemeHelper.getDimensionBySrcNumber().get(srcNumber).getAlias());
                if (formDim.get(srcNumber) != null && formDim.get(srcNumber).getAttribute() != null) {
                    hasHide = true;
                    hide.append(formDim.get(srcNumber).getAttribute());
                    continue;
                }
                if (tempMember != null && tempMember.getAttribute() != null) {
                    hasHide = true;
                    hide.append(tempMember.getAttribute());
                    continue;
                }
                hide.append(Boolean.FALSE.toString());
            }
            formSpecialItem.setDimensionName(dimName.toString());
            formSpecialItem.setDimensionNumber(number.toString());
            formSpecialItem.setMemberDisplayName(displayName.toString());
            formSpecialItem.setMemberName(name.toString());
            if (hasHide) {
                formSpecialItem.setHide(hide.toString());
            } else {
                formSpecialItem.setHide(null);
            }
            formSpecialItem.getDimRelaGroupRef().clear();
            formSpecialItem.getDimRelaGroupRef().addCollection(templateSpecialItem.getDimRelaGroupRef());
            for (int i = 0; i < formSpecialItem.getDimRelaGroupRef().size(); ++i) {
                formSpecialItem.getDimRelaGroupRef().get(i).setId(BOSUuid.create((BOSObjectType)formSpecialItem.getDimRelaGroupRef().get(i).getBOSType()));
                formSpecialItem.getDimRelaGroupRef().get(i).setBgSpecialItems(formSpecialItem);
            }
        }
        return true;
    }

    public static boolean checkSpecilRepeat(Context ctx, BgFormInfo bgFormInfo, BgTemplateInfo bgTemplate, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        if (bgFormInfo == null || bgTemplate == null) {
            return false;
        }
        BgSpecialItemsInfo templateSpecialItem = null;
        if (bgTemplate.getBgSpecialItems() != null && !bgTemplate.isEmpty()) {
            templateSpecialItem = BgSpecialBudgetHelper.getBgSpecialItemByTemplate(ctx, bgTemplate);
        }
        BgSpecialItemsInfo formSpecialItem = null;
        if (bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.isEmpty()) {
            formSpecialItem = BgSpecialBudgetHelper.getBgSpecialItemByForm(ctx, bgFormInfo);
        }
        if (templateSpecialItem != null && formSpecialItem != null) {
            Map<String, List<BgDimensionMember>> templateDim = BgSpecialBudgetHelper.getDimMemberFromTemplate(ctx, templateSpecialItem, bgFormInfo.getOrgUnit().getId().toString(), schemeHelper);
            Map<String, BgDimensionMember> formDim = BgSpecialBudgetHelper.getDimMember(formSpecialItem);
            Map formSpecilsMembers = BgSpecialItemsFactory.getLocalInstance(ctx).queryFormSpecials(bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme() != null ? bgFormInfo.getBgScheme().getId() : BOSUuid.read((String)schemeHelper.getBgSchemeId()), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getBgPeriod().getId(), bgFormInfo.getCurrency().getId(), bgFormInfo.getBgVersion().getId(), bgFormInfo.getProcessType());
            for (String srcNumber : templateDim.keySet()) {
                if (templateDim.get(srcNumber).size() != 1 || !formSpecilsMembers.containsKey(srcNumber) || ((Set)formSpecilsMembers.get(srcNumber)).size() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, List<BgDimensionMember>> getDimMemberFromTemplate(Context ctx, BgSpecialItemsInfo templateSpecialItem, String orgUnitId, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        IMBGViewListFormFacade facade = null;
        facade = ctx == null ? MBGViewListFormFacadeFactory.getRemoteInstance() : MBGViewListFormFacadeFactory.getLocalInstance(ctx);
        Map specialDimensions = facade.reParseSpecialCanAddMembers(templateSpecialItem, orgUnitId, schemeHelper);
        LinkedHashMap<String, List<BgDimensionMember>> result = new LinkedHashMap<String, List<BgDimensionMember>>();
        String srcNumber = null;
        for (MbgViewListDimensionInfo dimension : specialDimensions.values()) {
            srcNumber = schemeHelper.getSrcNumber(dimension.getNumber());
            result.put(srcNumber, dimension.getCanAddMember());
        }
        return result;
    }

    private static Map<String, BgDimensionMember> getDimMember(BgSpecialItemsInfo specialItem) {
        LinkedHashMap<String, BgDimensionMember> result = new LinkedHashMap<String, BgDimensionMember>();
        if (specialItem == null || StringUtils.isEmpty((String)specialItem.getDimensionNumber())) {
            return result;
        }
        String[] numberCombins = DimensionFormulaHelper.splitCombinations(specialItem.getDimensionNumber());
        String[] nameCombins = DimensionFormulaHelper.split(specialItem.getMemberName(), DimensionConstants.TICK_SEPARATOR);
        String[] hides = null;
        if (!StringUtils.isEmpty((String)specialItem.getHide())) {
            hides = DimensionFormulaHelper.splitCombinations(specialItem.getHide());
        }
        String srcNumber = null;
        String number = null;
        for (int i = 0; i < numberCombins.length; ++i) {
            srcNumber = DimensionFormulaHelper.getSrcNumber(numberCombins[i]);
            number = DimensionFormulaHelper.getMemberNumber(numberCombins[i]);
            if ("#".equals(number)) {
                result.put(srcNumber, null);
                continue;
            }
            result.put(srcNumber, new BgDimensionMember(srcNumber, hides == null ? null : hides[i], nameCombins[i], number));
        }
        return result;
    }

    public static Map<String, Set<String>> getFilterMapByBgForm(Context ctx, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws BOSException {
        if (schemeHelper == null || bgFormInfo == null || bgFormInfo.getBgSpecialItems() == null || bgFormInfo.getBgSpecialItems().isEmpty()) {
            return null;
        }
        List<? extends BgDimensionBaseInfo> bgDimensions = BgSpecialBudgetHelper.getBgDimensionsByBgForm(ctx, bgFormInfo, schemeHelper);
        return BgSpecialBudgetHelper.getFilterMapByDimensions(bgDimensions, schemeHelper);
    }

    public static List<? extends BgDimensionBaseInfo> getBgDimensionsByTemplate(Context ctx, BgTemplateInfo bgTemplateInfo, BgSchemeDimensionHelper schemeHelper) throws BOSException {
        if (bgTemplateInfo.getBgSpecialItems() != null && !bgTemplateInfo.getBgSpecialItems().isEmpty()) {
            BgSpecialItemsInfo bgSpecialItemsInfo = bgTemplateInfo.getBgSpecialItems().get(0);
            return BgSpecialBudgetHelper.getBgDimensionsBySpecialItems(bgSpecialItemsInfo, schemeHelper);
        }
        return new ArrayList();
    }

    public static List<? extends BgDimensionBaseInfo> getBgDimensionsBySpecialItems(BgSpecialItemsInfo bgSpecialItemsInfo, BgSchemeDimensionHelper schemeHelper) throws BOSException {
        ArrayList<MbgViewListDimensionInfo> bgDimensions = new ArrayList<MbgViewListDimensionInfo>();
        if (bgSpecialItemsInfo == null || schemeHelper == null) {
            return bgDimensions;
        }
        Map<String, MbgViewListDimensionInfo> specialDimensions = bgSpecialItemsInfo.getSpecialDimensions(schemeHelper);
        bgDimensions.addAll(specialDimensions.values());
        return bgDimensions;
    }

    public static String[] splitName(String name, String split) {
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)split)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        int start = 0;
        int pos = 0;
        while (start < name.length()) {
            pos = name.indexOf(split, start);
            if (start == pos) {
                resultList.add("");
            } else if (pos > 0) {
                resultList.add(name.substring(start, pos));
            } else {
                pos = name.length();
                resultList.add(name.substring(start, pos));
            }
            start = pos + 1;
        }
        if (name.endsWith(split)) {
            resultList.add("");
        }
        return resultList.toArray(new String[0]);
    }

    public static List<? extends BgDimensionBaseInfo> getBgDimensionsByBgForm(Context ctx, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws BOSException {
        if (bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty()) {
            BgSpecialItemsInfo bgSpecialItemsInfo = bgFormInfo.getBgSpecialItems().get(0);
            return BgSpecialBudgetHelper.getBgDimensionsBySpecialItems(bgSpecialItemsInfo, schemeHelper);
        }
        try {
            BgFormInfo _bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo("select bgSpecialItems.* where id = '" + bgFormInfo.getId() + "'");
            if (_bgFormInfo != null && !_bgFormInfo.getBgSpecialItems().isEmpty()) {
                BgSpecialItemsInfo bgSpecialItemsInfo = _bgFormInfo.getBgSpecialItems().get(0);
                bgFormInfo.getBgSpecialItems().add(bgSpecialItemsInfo);
                return BgSpecialBudgetHelper.getBgDimensionsBySpecialItems(bgSpecialItemsInfo, schemeHelper);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return new ArrayList();
    }

    public static Map<String, Set<String>> getFilterMapByBgTemplate(Context ctx, BgTemplateInfo bgTemplateInfo, BgSchemeDimensionHelper schemeHelper) throws BOSException {
        if (schemeHelper == null || bgTemplateInfo == null || bgTemplateInfo.getBgSpecialItems() == null || bgTemplateInfo.getBgSpecialItems().isEmpty()) {
            return null;
        }
        List<? extends BgDimensionBaseInfo> bgDimensions = BgSpecialBudgetHelper.getBgDimensionsByTemplate(ctx, bgTemplateInfo, schemeHelper);
        return BgSpecialBudgetHelper.getFilterMapByDimensions(bgDimensions, schemeHelper);
    }

    public static Map<String, Set<String>> getFilterMapByDimensions(List<? extends BgDimensionBaseInfo> bgDimensions, BgSchemeDimensionHelper schemeHelper) {
        if (bgDimensions == null || bgDimensions.isEmpty() || schemeHelper == null) {
            return null;
        }
        HashMap filterValueMap = null;
        ArrayList<String> specialNumbers = new ArrayList<String>();
        BgDimensionBaseInfo bgDimensionInfo = null;
        List<String> accAndOtherDimNumbers = schemeHelper.getAccAndOtherDim(false);
        if (bgDimensions != null && !bgDimensions.isEmpty()) {
            for (int index = 0; index < bgDimensions.size(); ++index) {
                bgDimensionInfo = bgDimensions.get(index);
                specialNumbers.add(bgDimensionInfo.getNumber());
            }
            if (accAndOtherDimNumbers != null && !accAndOtherDimNumbers.isEmpty()) {
                filterValueMap = new HashMap();
                String number = null;
                for (int index = 0; index < accAndOtherDimNumbers.size(); ++index) {
                    number = accAndOtherDimNumbers.get(index);
                    if (specialNumbers.contains(number)) continue;
                    filterValueMap.put(schemeHelper.getSrcNumber(number), new HashSet());
                }
            }
        }
        return filterValueMap;
    }

    public static void fillAndbuildFormula(Context ctx, Book book, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        if (book == null || bgFormInfo == null || bgFormInfo.getBgSpecialItems().isEmpty() || schemeHelper == null) {
            return;
        }
        BgSpecialItemsInfo bgSpecialItem = BgSpecialBudgetHelper.getBgSpecialItemByForm(schemeHelper.getContext(), bgFormInfo);
        Sheet sheet = null;
        int sheetCount = book.getSheetCount();
        boolean needReDo = false;
        String specialNumber = BgSpecialBudgetHelper.getSortSpecialNumber(ctx, bgSpecialItem);
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            BgSpecialBudgetHelper.buildFormula(bgFormInfo, sheet, specialNumber);
            needReDo = true;
        }
        if (needReDo && bgFormInfo.getOrgUnit() != null && schemeHelper != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("FIXEDFORM", "false");
            BgNTemplateHelper.dealWith(book, bgFormInfo.getOrgUnit().getId().toString(), map, false, false, false, false, schemeHelper.getContext(), schemeHelper, false, BgSpecialBudgetHelper.getFilterMapByBgForm(schemeHelper.getContext(), bgFormInfo, schemeHelper));
        }
    }

    private static String getSortSpecialNumber(Context ctx, BgSpecialItemsInfo bgSpecialItem) throws BOSException, EASBizException {
        String specialNumber = null;
        if (bgSpecialItem != null && !StringUtils.isEmpty((String)bgSpecialItem.getDimensionNumber())) {
            Object object;
            String dimensionNumber = bgSpecialItem.getDimensionNumber();
            HashMap bgItemCombinMap = new HashMap();
            bgItemCombinMap.put(dimensionNumber, null);
            IDimensionFormulaFacade iBgF = null;
            iBgF = ctx == null ? DimensionFormulaFacadeFactory.getRemoteInstance() : DimensionFormulaFacadeFactory.getLocalInstance(ctx);
            bgItemCombinMap = (HashMap)iBgF.batchParseItemCombination(bgItemCombinMap, null);
            if (bgItemCombinMap != null && bgItemCombinMap.containsKey(dimensionNumber) && ((Object[])bgItemCombinMap.get(dimensionNumber)).length > 0 && (object = ((Object[])bgItemCombinMap.get(dimensionNumber))[0]) instanceof String) {
                specialNumber = (String)((Object[])bgItemCombinMap.get(dimensionNumber))[0];
            }
            return specialNumber != null ? specialNumber : dimensionNumber;
        }
        return specialNumber;
    }

    private static void buildFormula(BgFormInfo bgFormInfo, Sheet sheet, String itemNumber) throws EASBizException {
        if (sheet == null) {
            return;
        }
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        String formulaString = null;
        String newFormula = null;
        String[] parameter = null;
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                Object obj;
                Cell cell = sheet.getCell(rowIndex, colIndex, false);
                if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                    formulaString = BgNFSHelper.getFormulaOfCell(cell);
                } else if (cell != null && cell.getUserObjectValue("ITEM") instanceof String && (obj = cell.getUserObjectValue("ITEM")) != null && obj instanceof String && ((String)obj).toLowerCase().indexOf("=bgitem") >= 0) {
                    formulaString = (String)obj;
                    BgNFSHelper.setFormulaOfCell(cell, formulaString, true);
                }
                if (StringUtils.isEmpty((String)formulaString) || (parameter = BgNFSHelper.parseFormulaPara(null, formulaString)) == null || parameter[0].indexOf(itemNumber + ",") >= 0 || parameter[0].endsWith(itemNumber)) continue;
                parameter[0] = itemNumber + "," + parameter[0];
                if (parameter.length == 6) {
                    newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\"," + StringUtils.cnulls((String)parameter[4]) + ",\"" + StringUtils.cnulls((String)parameter[5]) + "\")").toString();
                } else if (parameter.length == 5) {
                    newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\",true,\"" + StringUtils.cnulls((String)parameter[4]) + "\")").toString();
                }
                if (bgFormInfo != null && !StringUtils.isEmpty(newFormula)) {
                    newFormula = BgNFSHelper.checkFormula(null, newFormula, (IObjectValue)bgFormInfo);
                }
                BgNFSHelper.setFormulaOfCell(cell, newFormula);
            }
        }
    }

    public static void buildFormula(Range range, BgSpecialItemsInfo bgSpecialItemsInfo) {
        if (range == null || range.isEmpty()) {
            return;
        }
        CellBlock block = null;
        Sheet sheet = range.getRangeSheets().getSheet(0);
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        String formulaString = null;
        String newFormula = null;
        String itemNumber = bgSpecialItemsInfo.getDimensionNumber();
        String[] parameter = null;
        HashSet<String> hasSrcs = new HashSet<String>();
        String[] combins = null;
        for (int bIndex = 0; bIndex < range.size(); ++bIndex) {
            block = range.getBlock(bIndex);
            for (int rowIndex = block.getRow(); rowIndex <= Math.min(block.getRow2(), rowCount); ++rowIndex) {
                for (int colIndex = block.getCol(); colIndex <= Math.min(block.getCol2(), colCount); ++colIndex) {
                    int c;
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || (parameter = BgNFSHelper.parseFormulaPara(null, formulaString = BgNFSHelper.getFormulaOfCell(cell))) == null) continue;
                    hasSrcs.clear();
                    combins = DimensionFormulaHelper.splitCombinations(parameter[0]);
                    for (c = 0; c < combins.length; ++c) {
                        hasSrcs.add(DimensionFormulaHelper.getSrcNumber(combins[c]));
                    }
                    combins = DimensionFormulaHelper.splitCombinations(itemNumber);
                    for (c = combins.length - 1; c >= 0; --c) {
                        if (hasSrcs.contains(DimensionFormulaHelper.getSrcNumber(combins[c]))) continue;
                        parameter[0] = combins[c] + "," + parameter[0];
                    }
                    if (parameter.length == 6) {
                        newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\"," + StringUtils.cnulls((String)parameter[4]) + ",\"" + StringUtils.cnulls((String)parameter[5]) + "\")").toString();
                    } else if (parameter.length == 5) {
                        newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\",true,\"" + StringUtils.cnulls((String)parameter[4]) + "\")").toString();
                    }
                    BgNFSHelper.setFormulaOfCell(cell, newFormula);
                }
            }
        }
    }
}

