/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.IGetBgSchemeNumber;
import com.kingdee.util.PropertyContainer;
import org.apache.log4j.Logger;

public class BgTempRptReportPropertyAdapter
implements IReportPropertyAdapter,
IGetBgSchemeNumber {
    private static final long serialVersionUID = -7203517671208809620L;
    private static final Logger logger = CoreUIObject.getLogger(BgTempRptReportPropertyAdapter.class);
    public static final String Scheme_Name = "Scheme.Name";
    public static final String Scheme_Id = "Scheme.Id";
    public static final String Scheme_Number = "Scheme_Number";
    private PropertyContainer p;

    public BgTempRptReportPropertyAdapter(BgTemplateInfo report) {
        this.setProperties(report);
    }

    private void setProperties(BgTemplateInfo report) {
        OrgUnitInfo orgUnitInfo;
        if (this.p == null) {
            this.p = new PropertyContainer();
        }
        if (report.getBgScheme() != null && report.getBgScheme().getId() != null) {
            this.p.setString(Scheme_Name, report.getBgScheme().getName());
            this.p.setString(Scheme_Id, report.getBgScheme().getId().toString());
            this.p.setString(Scheme_Number, report.getBgScheme().getNumber());
        }
        if (report.getOrgUnit() != null && report.getOrgUnit().getId() != null && (orgUnitInfo = this.getCompanyOfTemplateInfo(report)) != null) {
            this.p.setString("Company.Name", orgUnitInfo.getName());
            this.p.setString("Company.Number", orgUnitInfo.getNumber());
            this.p.setString("Company.ID", orgUnitInfo.getId().toString());
        }
    }

    private OrgUnitInfo getCompanyOfTemplateInfo(BgTemplateInfo report) {
        FullOrgUnitInfo orginfo = null;
        OrgUnitInfo info = null;
        Context ctx = ConfigMDUtil.isClient() ? null : ConfigMDUtil.getContext();
        try {
            orginfo = ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(report.getOrgUnit().getId())) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(report.getOrgUnit().getId()));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (orginfo != null) {
            info = BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(ctx, orginfo);
        }
        return info;
    }

    public Object getReportProperty(String name) {
        return this.p.get(name);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        if (vo instanceof BgTemplateInfo) {
            this.setProperties((BgTemplateInfo)vo);
        }
    }

    @Override
    public String getBgSchemeNumber() {
        return this.p.getString(Scheme_Number);
    }
}

