/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MemberProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgVariateUtils {
    public static Map<String, String> queryVariate(Connection conn, BOSUuid bgSchemeId) throws EASBizException {
        HashMap<String, String> variateMap = new HashMap<String, String>();
        if (conn == null || bgSchemeId == null) {
            return variateMap;
        }
        String dimNumber = null;
        String srcNumber = null;
        String memberNumber = null;
        String varNumber = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select var.FNumber, var.FDimNumber, var.FMemberNumber, dim.FSrcNumber,var.FBgVariateClass from T_MBG_BgVariate var left join T_MBG_MbgDim dim on var.FDimNumber = dim.FNumber where var.FBgSchemeId = ?", (Object[])new Object[]{bgSchemeId.toString()});
            while (rst.next()) {
                dimNumber = rst.getString("FDimNumber");
                srcNumber = rst.getString("FSrcNumber");
                varNumber = rst.getString("FNumber");
                memberNumber = rst.getString("FMemberNumber");
                int bgVariateClz = rst.getInt("FBgVariateClass");
                if (0 == bgVariateClz) {
                    if (srcNumber == null) {
                        srcNumber = DimensionFormulaHelper.getDefaultSrcNumber(dimNumber);
                    }
                    variateMap.put(rst.getString("FNumber"), srcNumber + ":" + rst.getString("FMemberNumber"));
                    continue;
                }
                if (1 != bgVariateClz) continue;
                variateMap.put(varNumber, memberNumber);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return variateMap;
    }

    public static void transVariate(BizCalcInfo calc, Map<String, String> variateMap) throws ParseException {
        if (variateMap == null || variateMap.isEmpty()) {
            return;
        }
        List express = null;
        BizCalcSubsetInfo subCalc = null;
        int in = calc.getBizCalcSubset().size();
        for (int i = 0; i < in; ++i) {
            subCalc = calc.getBizCalcSubset().get(i);
            express = subCalc.getExpres();
            if (express == null) continue;
            int jn = express.size();
            for (int j = 0; j < jn; ++j) {
                BgVariateUtils.checkVarMember((IExpress)express.get(j), variateMap);
            }
        }
    }

    public static void checkVarMember(IExpress expr, Map<String, String> variateMap) throws ParseException {
        if (expr == null || variateMap == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            BgVariateUtils.checkVarMember((BinaryExpr)expr, variateMap);
        } else if (expr instanceof ConditionExpr) {
            BgVariateUtils.checkVarMember((ConditionExpr)expr, variateMap);
        } else if (expr instanceof FunctionExpr) {
            BgVariateUtils.checkVarMember((FunctionExpr)expr, variateMap);
        } else if (expr instanceof VariateExpr) {
            BgVariateUtils.checkVarMember((VariateExpr)expr, variateMap);
        }
    }

    public static void checkVarMember(BinaryExpr expr, Map<String, String> variateMap) throws ParseException {
        NameExpr nameExpr;
        String[] tmpStrs;
        String varName;
        if (expr == null || variateMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            BgVariateUtils.checkVarMember((BinaryExpr)expr.left, variateMap);
        } else if (expr.left instanceof VariateExpr) {
            varName = ((VariateExpr)expr.left).name;
            tmpStrs = (varName = variateMap.get(varName)).split(":");
            if (tmpStrs != null && tmpStrs.length == 2) {
                BgVariateUtils.checkVarMember((VariateExpr)expr.left, variateMap);
            } else {
                nameExpr = new NameExpr();
                nameExpr.name = varName;
                nameExpr.setOriginalExpr(expr.left.getOriginalExpr());
                expr.left = nameExpr;
            }
        } else if (expr.left instanceof FunctionExpr) {
            BgVariateUtils.checkVarMember((FunctionExpr)expr.left, variateMap);
        } else if (expr.left instanceof ConditionExpr) {
            BgVariateUtils.checkVarMember((ConditionExpr)expr.left, variateMap);
        }
        if (expr.right instanceof BinaryExpr) {
            BgVariateUtils.checkVarMember((BinaryExpr)expr.right, variateMap);
        } else if (expr.right instanceof VariateExpr) {
            varName = ((VariateExpr)expr.right).name;
            String[] stringArray = tmpStrs = (varName = variateMap.get(varName)) == null ? null : varName.split(":");
            if (tmpStrs != null && tmpStrs.length == 2) {
                BgVariateUtils.checkVarMember((VariateExpr)expr.right, variateMap);
            } else {
                nameExpr = new NameExpr();
                nameExpr.name = varName;
                nameExpr.setOriginalExpr(expr.right.getOriginalExpr());
                expr.right = nameExpr;
            }
        } else if (expr.right instanceof FunctionExpr) {
            BgVariateUtils.checkVarMember((FunctionExpr)expr.right, variateMap);
        } else if (expr.right instanceof ConditionExpr) {
            BgVariateUtils.checkVarMember((ConditionExpr)expr.right, variateMap);
        }
    }

    public static void checkVarMember(ConditionExpr expr, Map<String, String> variateMap) throws ParseException {
        if (expr == null || variateMap == null) {
            return;
        }
        if (expr.conditions != null) {
            for (IExpress _expr : expr.conditions) {
                if (_expr instanceof BinaryExpr) {
                    BgVariateUtils.checkVarMember((BinaryExpr)_expr, variateMap);
                    continue;
                }
                if (_expr instanceof ConditionExpr) {
                    BgVariateUtils.checkVarMember((ConditionExpr)_expr, variateMap);
                    continue;
                }
                if (!(_expr instanceof VariateExpr)) continue;
                BgVariateUtils.checkVarMember((IExpress)((MdxMemberExpr)_expr), variateMap);
            }
        }
        if (expr.results != null) {
            for (IExpress _expr : expr.results) {
                if (_expr instanceof BinaryExpr) {
                    BgVariateUtils.checkVarMember((BinaryExpr)_expr, variateMap);
                    continue;
                }
                if (_expr instanceof ConditionExpr) {
                    BgVariateUtils.checkVarMember((ConditionExpr)_expr, variateMap);
                    continue;
                }
                if (!(_expr instanceof VariateExpr)) continue;
                BgVariateUtils.checkVarMember((IExpress)((MdxMemberExpr)_expr), variateMap);
            }
        }
    }

    public static void checkVarMember(FunctionExpr expr, Map<String, String> variateMap) throws ParseException {
        if (expr == null || variateMap == null) {
            return;
        }
        List paramList = expr.params;
        ArrayList<Object> tmpParamList = new ArrayList<Object>();
        if (paramList != null && paramList.size() != 0) {
            for (Object expresion : paramList) {
                if (expresion == null || variateMap == null) {
                    return;
                }
                if (expresion instanceof BinaryExpr) {
                    BgVariateUtils.checkVarMember((BinaryExpr)expresion, variateMap);
                    continue;
                }
                if (expresion instanceof ConditionExpr) {
                    BgVariateUtils.checkVarMember((ConditionExpr)expresion, variateMap);
                    continue;
                }
                if (expresion instanceof FunctionExpr) {
                    BgVariateUtils.checkVarMember((FunctionExpr)expresion, variateMap);
                    continue;
                }
                if (expresion instanceof VariateExpr) {
                    BgVariateUtils.checkVarMember((VariateExpr)expresion, variateMap);
                    continue;
                }
                if (!(expresion instanceof String) || StringUtils.isEmpty((String)expresion.toString().replace("\"", ""))) continue;
                String memNum = expresion.toString();
                if (memNum.indexOf("VAR") == -1) {
                    String srcNumber = "";
                    srcNumber = memNum.contains("[") && memNum.contains("]") ? memNum.substring(memNum.indexOf("[") + 1, memNum.indexOf("]")) : memNum;
                    String[] numbers = srcNumber.split(":");
                    String variateNum = null;
                    variateNum = numbers.length == 2 ? DimUtils.getNumber(numbers[1]) : DimUtils.getNumber(numbers[0]);
                    String varNum = null;
                    if (!variateMap.containsKey(variateNum)) continue;
                    varNum = variateMap.get(variateNum);
                    String[] varArr = varNum.split(":");
                    if (varArr.length == 2) {
                        MdxMemberExpr mdxExpr = MemberProxy.parseDimNum((String)varNum);
                        tmpParamList.add(mdxExpr);
                        continue;
                    }
                    NameExpr nameExpr = new NameExpr();
                    nameExpr.name = varNum;
                    tmpParamList.add(nameExpr);
                    continue;
                }
                String[] numbers = memNum.split(":");
                String varNum = numbers[1];
                if (!variateMap.containsKey(varNum)) continue;
                String[] varArr = (varNum = variateMap.get(varNum)).split(":");
                if (varArr.length == 2) {
                    MdxMemberExpr mdxExpr = MemberProxy.parseDimNum((String)varNum);
                    tmpParamList.add(mdxExpr);
                    continue;
                }
                NameExpr nameExpr = new NameExpr();
                nameExpr.name = varNum;
                tmpParamList.add(nameExpr);
            }
            if (!tmpParamList.isEmpty()) {
                expr.params = tmpParamList;
            }
        }
    }

    public static void checkVarMember(VariateExpr expr, Map<String, String> variateMap) throws ParseException {
        if (expr == null || variateMap == null) {
            return;
        }
        String variateNum = DimUtils.getNumber(expr.name);
        if (variateMap.containsKey(variateNum)) {
            MdxMemberExpr mdxExpr;
            expr.expr = mdxExpr = MemberProxy.parseDimNum((String)variateMap.get(variateNum));
        }
    }
}

