/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewListStyle;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConditionalFormatHelper {
    public static void setConditional(Sheet sheet, List<IMbgViewListStyle> styleObjects, boolean isCol) {
        if (styleObjects == null || styleObjects.isEmpty()) {
            return;
        }
        Range thisRange = null;
        IMbgViewListStyle style = null;
        ConditionalFormat condFormat = null;
        block0: for (int i = 0; i < styleObjects.size(); ++i) {
            style = styleObjects.get(i);
            thisRange = ConditionalFormatHelper.getRange(sheet, style, isCol);
            style.setConditionaFormt(null);
            for (int c = 0; c < sheet.getConditionalFormats().size(); ++c) {
                condFormat = sheet.getConditionalFormats().getConditionalFormat(c);
                for (int b = 0; b < condFormat.getBlocks().size(); ++b) {
                    if (!condFormat.getBlocks().get(b).equals(thisRange.getBounds())) continue;
                    style.setConditionaFormt(new ConditionalFormat(condFormat.getConditions(), condFormat.getSSAs(), (SortedCellBlockArray)thisRange));
                    continue block0;
                }
            }
        }
    }

    public static void initConditional(Sheet sheet, List<IMbgViewListStyle> styleObjects, boolean isCol) {
        ConditionalFormatHelper.initConditional(sheet, styleObjects, isCol, false, false);
    }

    public static void initConditional(Sheet sheet, List<IMbgViewListStyle> styleObjects, boolean isCol, boolean isMerge, boolean isShowCellDefault) {
        if (styleObjects == null || styleObjects.isEmpty()) {
            return;
        }
        IMbgViewListStyle style = null;
        Range selectRange = null;
        Range thisRange = null;
        ConditionalFormat condFormat = null;
        for (int i = 0; i < styleObjects.size(); ++i) {
            style = styleObjects.get(i);
            thisRange = ConditionalFormatHelper.getRange(sheet, style, isCol);
            if (thisRange == null) continue;
            if (selectRange == null) {
                selectRange = new Range(sheet.getBook(), sheet, thisRange.getBlock(0));
            } else {
                selectRange.addAll((SortedCellBlockArray)thisRange);
            }
            if (isShowCellDefault && style instanceof MbgViewListCell) {
                style = ((MbgViewListCell)style).getCondiionaFormatObject();
            }
            if (style.getConditionaFormat() == null) continue;
            if (!isMerge) {
                style.getConditionaFormat().setBlocks((SortedCellBlockArray)thisRange);
                sheet.getConditionalFormats().addConditionalFormat(style.getConditionaFormat());
                continue;
            }
            if (condFormat != null && ConditionalFormatHelper.equalsCondFormat(condFormat, style.getConditionaFormat())) {
                condFormat.getBlocks().addAll((SortedCellBlockArray)thisRange);
                continue;
            }
            condFormat = ConditionalFormatHelper.getCopyCond(style.getConditionaFormat());
            condFormat.setBlocks((SortedCellBlockArray)thisRange);
            sheet.getConditionalFormats().addConditionalFormat(condFormat);
        }
        if (selectRange != null) {
            selectRange.select();
        }
    }

    public static boolean equalsCondFormat(ConditionalFormat condFormat, ConditionalFormat condFormat1) {
        if (condFormat == null && condFormat1 == null) {
            return true;
        }
        if (condFormat == null || condFormat1 == null) {
            return false;
        }
        return Arrays.equals(condFormat.getConditions(), condFormat1.getConditions()) && Arrays.equals(condFormat.getSSAs(), condFormat1.getSSAs());
    }

    private static Range getRange(Sheet sheet, IMbgViewListStyle style, boolean isCol) {
        if (style instanceof MbgViewListCell) {
            MbgViewListCell cell = (MbgViewListCell)style;
            if (cell.getRow() != null && cell.getCol() != null) {
                return sheet.getRange(cell.getRow().getIndex(), cell.getCol().getIndex());
            }
        } else if (style instanceof IMbgViewListObject) {
            IMbgViewListObject object = (IMbgViewListObject)((Object)style);
            if (!isCol) {
                return sheet.getRowRange(object.getIndex(), object.getIndex());
            }
            return sheet.getColRange(object.getIndex(), object.getIndex());
        }
        return null;
    }

    public static void parseTemplateConditionaFormat(MbgViewListDimensionManager dimensionManager, String condStr) throws Exception {
        if (dimensionManager == null || StringUtils.isEmpty((String)condStr)) {
            return;
        }
        Sheet sheet = ConditionalFormatHelper.unpackSheet(condStr);
        if (sheet.getConditionalFormats().size() == 0) {
            return;
        }
        ConditionalFormatHelper.setConditional(sheet, dimensionManager.getRows(), false);
        ConditionalFormatHelper.setConditional(sheet, dimensionManager.getColumns(), true);
        ConditionalFormatHelper.setConditional(sheet, dimensionManager.getCells(), false);
    }

    public static void parseFormConditionaFormat(MbgViewListDimensionManager dimensionManager, String condStr) throws Exception {
        if (dimensionManager == null || StringUtils.isEmpty((String)condStr)) {
            return;
        }
        Sheet sheet = ConditionalFormatHelper.unpackSheet(condStr);
        if (sheet == null || sheet.getConditionalFormats().size() == 0) {
            return;
        }
        for (int i = 0; i < sheet.getConditionalFormats().size(); ++i) {
            dimensionManager.getFormConditionalFormats().add(sheet.getConditionalFormats().getConditionalFormat(i));
        }
    }

    protected static Sheet unpackSheet(String condStr) throws Exception {
        Book book = IOHelper.unpackBook((byte[])BgAnalyseHelper.decode(condStr));
        Sheet sheet = book.getSheet(0);
        return sheet;
    }

    public static String getFormConditionaFormat(MbgViewListDimensionManager dimensionManager) {
        if (dimensionManager == null || dimensionManager.getFormConditionalFormats().isEmpty()) {
            return null;
        }
        Sheet sheet = ConditionalFormatHelper.createNewSheet(dimensionManager);
        for (int i = 0; i < dimensionManager.getFormConditionalFormats().size(); ++i) {
            sheet.getConditionalFormats().addConditionalFormat(dimensionManager.getFormConditionalFormats().get(i));
        }
        return ConditionalFormatHelper.buildString(sheet);
    }

    public static String getTemplateConditionaFormat(MbgViewListDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return null;
        }
        Sheet sheet = ConditionalFormatHelper.createNewSheet(dimensionManager);
        ConditionalFormatHelper.initConditional(sheet, dimensionManager.getRows(), false);
        ConditionalFormatHelper.initConditional(sheet, dimensionManager.getColumns(), true);
        ConditionalFormatHelper.initConditional(sheet, dimensionManager.getCells(), false);
        return ConditionalFormatHelper.buildString(sheet);
    }

    private static String buildString(Sheet sheet) {
        if (sheet.getConditionalFormats().size() > 0) {
            try {
                return BgAnalyseHelper.encode(IOHelper.packBook((Book)sheet.getBook()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Sheet createNewSheet(MbgViewListDimensionManager dimensionManager) {
        Book book = Book.Manager.getNewBook((String)"Book", (int)1);
        Sheet sheet = book.getSheet(0);
        sheet.setName(dimensionManager.getSheet().getSheetName());
        return sheet;
    }

    public static Map<IMbgViewListStyle, ConditionalFormat> copyCondFormat(List<IMbgViewListStyle> selectObject) {
        if (selectObject == null) {
            return null;
        }
        HashMap<IMbgViewListStyle, ConditionalFormat> result = new HashMap<IMbgViewListStyle, ConditionalFormat>();
        for (int i = 0; i < selectObject.size(); ++i) {
            if (selectObject.get(i).getConditionaFormat() == null) continue;
            result.put(selectObject.get(i), ConditionalFormatHelper.getCopyCond(selectObject.get(i).getConditionaFormat()));
        }
        return result;
    }

    public static ConditionalFormat getCopyCond(ConditionalFormat source) {
        return new ConditionalFormat(source.getConditions(), source.getSSAs(), source.getBlocks());
    }
}

