/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.IOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionGroupOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.IBgScenario;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IDimensionRelationshipGroup;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionCacheHelper
implements Serializable {
    private static final long serialVersionUID = -7649095864937379463L;
    private static final Logger logger = Logger.getLogger((String)DimensionCacheHelper.class.getName());
    public static final String SOURCES = "SOURCES";
    public static final String RELATIONG_GROUP = "RELATIONG_GROUP";
    private Set<String> budgetScens = null;
    private Set<String> actualScens = null;
    private Map<String, Boolean> showAliasMap = new HashMap<String, Boolean>();
    private Map<String, String> bgPeriodAliasMap = new HashMap<String, String>();
    protected Context ctx = null;
    private Map<String, DimensionRelationshipGroupInfo> groups = new HashMap<String, DimensionRelationshipGroupInfo>();
    private transient ViewListMemberCacheHelper memberCacheHelper = null;
    private Map orgUnitMap = new HashMap();
    private Map<String, String> budgetScenMap = new HashMap<String, String>();
    private Map<String, String> actualScenMap = new HashMap<String, String>();
    private Map<String, OrgTreeInfo> treeInfo = new HashMap<String, OrgTreeInfo>();
    private Map<String, Boolean> orgLeafMap = null;

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Map<String, DimensionRelationshipGroupInfo> getGroups() {
        return this.groups;
    }

    public void setMemberCacheHelper(ViewListMemberCacheHelper memberCacheHelper) {
        this.memberCacheHelper = memberCacheHelper;
    }

    public ViewListMemberCacheHelper getMemberCacheHelper() {
        return this.memberCacheHelper;
    }

    public DimensionCacheHelper(Context ctx) {
        this.ctx = ctx;
    }

    public void addAllOrgUnit(Map orgMap) {
        if (orgMap != null && !orgMap.isEmpty()) {
            this.orgUnitMap.putAll(orgMap);
        }
    }

    public void initCache(IMbgViewManager view) {
    }

    public DimensionRelationshipGroupInfo getRelationGroup(String groupId) {
        if (StringUtils.isEmpty((String)groupId)) {
            return null;
        }
        if (!this.groups.containsKey(groupId)) {
            try {
                this.groups.put(groupId, DimensionCacheHelper.queryRelationGroup(this.ctx, groupId, this));
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.groups.get(groupId);
    }

    public void addGroup(DimensionRelationshipGroupInfo group) {
        this.groups.put(group.getId().toString(), group);
    }

    private static DimensionRelationshipGroupInfo queryRelationGroup(Context ctx, String groupId, DimensionCacheHelper cacheHelper) throws BOSException {
        if (cacheHelper == null) {
            cacheHelper = new DimensionCacheHelper(ctx);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)groupId, CompareType.EQUALS));
        evi.setSelector(DimensionCacheHelper.getRelationGroupSelector());
        IDimensionRelationshipGroup idrg = null;
        idrg = ctx == null ? DimensionRelationshipGroupFactory.getRemoteInstance() : DimensionRelationshipGroupFactory.getLocalInstance(ctx);
        DimensionRelationshipGroupCollection col = idrg.getDimensionRelationshipGroupCollection(evi);
        DimensionRelationshipGroupInfo info = null;
        if (col != null && !col.isEmpty()) {
            info = col.get(0);
            cacheHelper.groups.put(groupId, info);
        }
        return info;
    }

    public static SelectorItemCollection getRelationGroupSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isCsl");
        sic.add("orgTreeId");
        sic.add("number");
        sic.add("name");
        sic.add("bgScheme.id");
        sic.add("isLowerShow");
        sic.add("entries.id");
        sic.add("entries.dimNumber");
        sic.add("entries.dimName");
        return sic;
    }

    public OrgUnitInfo getOrgUnitByNumber(String orgNumber) throws EASBizException, BOSException {
        if (!this.orgUnitMap.containsKey(orgNumber)) {
            IOrgUnit ccou = this.getOrgBizInteface(false);
            OrgUnitInfo org = ccou.getOrgUnitInfo("Select id, number, name where number = '" + orgNumber + "'");
            this.orgUnitMap.put(orgNumber, org);
        }
        return (OrgUnitInfo)this.orgUnitMap.get(orgNumber);
    }

    protected IOrgUnit getOrgBizInteface(boolean isCsl) throws BOSException {
        if (this.ctx == null) {
            if (isCsl) {
                return UnionGroupOrgUnitFactory.getRemoteInstance();
            }
            return CostCenterOrgUnitFactory.getRemoteInstance();
        }
        if (isCsl) {
            return UnionGroupOrgUnitFactory.getLocalInstance((Context)this.ctx);
        }
        return CostCenterOrgUnitFactory.getLocalInstance((Context)this.ctx);
    }

    public OrgUnitInfo getOrgUnitById(String orgId) throws EASBizException, BOSException {
        return this.getOrgUnitById(orgId, false);
    }

    public OrgUnitInfo getOrgUnitById(String orgId, boolean isCsl) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        OrgUnitInfo org2 = null;
        for (OrgUnitInfo org2 : this.orgUnitMap.values()) {
            if (!org2.getId().toString().equals(orgId)) continue;
            return org2;
        }
        IOrgUnit ccou = this.getOrgBizInteface(isCsl);
        org2 = ccou.getOrgUnitInfo("Select id, number, longNumber where id = '" + orgId + "'");
        this.orgUnitMap.put(org2.getNumber(), org2);
        return org2;
    }

    public Set<String> getBudgetScens() throws EASBizException, BOSException {
        if (this.budgetScens == null) {
            this.initScens();
        }
        return this.budgetScens;
    }

    public Set<String> getActualScens() throws EASBizException, BOSException {
        if (this.actualScens == null) {
            this.initScens();
        }
        return this.actualScens;
    }

    private void initScens() throws EASBizException, BOSException {
        this.actualScens = new HashSet<String>();
        this.budgetScens = new HashSet<String>();
        IBgScenario scen = null;
        scen = this.ctx == null ? BgScenarioFactory.getRemoteInstance() : BgScenarioFactory.getLocalInstance((Context)this.ctx);
        BgScenarioCollection col = scen.getBgScenarioCollection("select number, type");
        if (col != null && !col.isEmpty()) {
            for (int c = 0; c < col.size(); ++c) {
                if (BgScenarioType.ActualData.equals((Object)col.get(c).getType())) {
                    this.actualScens.add(col.get(c).getNumber());
                    continue;
                }
                this.budgetScens.add(col.get(c).getNumber());
            }
        }
    }

    protected String getEditScen(String editScen, BgScenarioType scenType) throws EASBizException, BOSException {
        boolean isActual = BgScenarioType.ActualData.equals((Object)scenType);
        HashSet<String> numbers = new HashSet<String>();
        if (isActual) {
            if (this.actualScenMap.containsKey(editScen)) {
                return this.actualScenMap.get(editScen);
            }
            numbers.addAll(this.getActualScens());
        } else {
            if (this.budgetScenMap.containsKey(editScen)) {
                return this.budgetScenMap.get(editScen);
            }
            numbers.addAll(this.getBudgetScens());
        }
        if (editScen != null && !StringUtils.isEmpty((String)editScen)) {
            numbers.retainAll(Arrays.asList(editScen.split(",")));
        }
        StringBuffer scen = new StringBuffer();
        for (String s : numbers) {
            if (scen.length() > 0) {
                scen.append(",");
            }
            scen.append(s);
        }
        if (isActual) {
            this.actualScenMap.put(editScen, scen.toString());
        } else {
            this.budgetScenMap.put(editScen, scen.toString());
        }
        return scen.toString();
    }

    public Set<String> getEditScenSet(String editScen, BgScenarioType scenType) throws EASBizException, BOSException {
        HashSet<String> result = new HashSet<String>();
        String scens = this.getEditScen(editScen, scenType);
        if (!StringUtils.isEmpty((String)scens)) {
            result.addAll(Arrays.asList(scens.split(",")));
        }
        return result;
    }

    public Map<String, Boolean> isShowAlias(String orgViewId, Set<String> orgUnitIds) throws EASBizException, BOSException {
        String key;
        if (orgUnitIds == null || StringUtils.isEmpty((String)orgViewId)) {
            return this.showAliasMap;
        }
        HashSet<String> _oSet = new HashSet<String>(orgUnitIds);
        Iterator it = _oSet.iterator();
        while (it.hasNext()) {
            String orgId = (String)it.next();
            key = this.getShowAliasKey(orgViewId, orgId);
            if (this.showAliasMap.containsKey(key)) {
                it.remove();
                continue;
            }
            this.showAliasMap.put(key, Boolean.FALSE);
        }
        if (_oSet.isEmpty()) {
            return this.showAliasMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)orgViewId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", _oSet, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("periodName", (Object)1));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("orgUnitID");
        IBgOrgUnit orgIntance = null;
        orgIntance = this.ctx == null ? BgOrgUnitFactory.getRemoteInstance() : BgOrgUnitFactory.getLocalInstance(this.ctx);
        BgOrgUnitCollection col = orgIntance.getBgOrgUnitCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                key = this.getShowAliasKey(orgViewId, col.get(i).getOrgUnitID());
                this.showAliasMap.put(key, Boolean.TRUE);
            }
        }
        return this.showAliasMap;
    }

    public Map<String, Boolean> removeViewKey(String orgViewId, Map<String, Boolean> isShowAliasMap) {
        if (StringUtils.isEmpty((String)orgViewId) || isShowAliasMap == null || isShowAliasMap.isEmpty()) {
            return isShowAliasMap;
        }
        HashMap<String, Boolean> newMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> entry : isShowAliasMap.entrySet()) {
            if (!entry.getKey().startsWith(orgViewId)) {
                newMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            newMap.put(entry.getKey().substring(orgViewId.length() + 1), entry.getValue());
        }
        return newMap;
    }

    public boolean isShowAlias(String orgViewId, String orgUnitId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)orgViewId)) {
            return false;
        }
        String key = this.getShowAliasKey(orgViewId, orgUnitId);
        HashSet<String> orgUnitIds = new HashSet<String>();
        orgUnitIds.add(orgUnitId);
        Map<String, Boolean> map = this.isShowAlias(orgViewId, orgUnitIds);
        return map.get(key);
    }

    public String getShowAliasKey(String orgViewId, String orgUnitId) {
        return orgViewId + "_" + orgUnitId;
    }

    public Map<String, String> getAliasMap(Set<String> bgPeriodIds) throws EASBizException, BOSException {
        if (bgPeriodIds == null) {
            return this.bgPeriodAliasMap;
        }
        bgPeriodIds.removeAll(this.bgPeriodAliasMap.keySet());
        if (bgPeriodIds.isEmpty()) {
            return this.bgPeriodAliasMap;
        }
        Iterator<String> it = bgPeriodIds.iterator();
        while (it.hasNext()) {
            this.bgPeriodAliasMap.put(it.next(), null);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("bgPeriod.id");
        evi.getSelector().add("alias");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", bgPeriodIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("type.fiscalYear", (Object)2));
        IBgPeriodDisp disp = null;
        disp = this.ctx == null ? BgPeriodDispFactory.getRemoteInstance() : BgPeriodDispFactory.getLocalInstance((Context)this.ctx);
        BgPeriodDispCollection col = disp.getBgPeriodDispCollection(evi);
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                BgPeriodDispInfo info = col.get(i);
                if (info.getAlias() == null || info.getAlias().equals(info.getName())) continue;
                this.bgPeriodAliasMap.put(info.getBgPeriod().getId().toString(), info.getAlias());
            }
        }
        return this.bgPeriodAliasMap;
    }

    public static String getBgPeriodShowName(String orgUnitId, String bgPeriodId, Map<String, Boolean> isShowAliasMap, Map<String, String> aliasMap, String name) {
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgPeriodId) || isShowAliasMap == null || isShowAliasMap.isEmpty() || aliasMap == null || aliasMap.isEmpty()) {
            return name;
        }
        if (!Boolean.TRUE.equals(isShowAliasMap.get(orgUnitId))) {
            return name;
        }
        String alias = aliasMap.get(bgPeriodId);
        if (alias != null) {
            return alias;
        }
        return name;
    }

    public void clearCtx() {
        this.ctx = null;
    }

    public OrgTreeInfo getOrgTreeInfoByNumber(Context ctx, String orgTreeNumber) throws ParseException {
        if (StringUtils.isEmpty((String)orgTreeNumber)) {
            return null;
        }
        if (this.treeInfo.containsKey(orgTreeNumber)) {
            return this.treeInfo.get(orgTreeNumber);
        }
        Timestamp start = null;
        Timestamp end = null;
        if (orgTreeNumber.matches("\\S*_\\d{4}-\\d{2}-\\d{2}")) {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(orgTreeNumber.substring(orgTreeNumber.length() - 10, orgTreeNumber.length()));
            start = new Timestamp(BgNPeriodHelper.getDayEnd((Date)date).getTime());
            end = new Timestamp(BgNPeriodHelper.getDayBegin((Date)date).getTime());
            orgTreeNumber = orgTreeNumber.substring(0, orgTreeNumber.length() - 11);
        }
        EntityViewInfo evi = DimensionCacheHelper.getOrgTreeEntity();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)orgTreeNumber));
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(1);
        status.add(2);
        evi.getFilter().getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
        if (start != null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("startDate", (Object)start, CompareType.LESS_EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)end, CompareType.GREATER_EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", null, CompareType.EQUALS));
            evi.getFilter().setMaskString("#0 AND #1 AND #2 AND (#3 OR #4)");
        } else {
            evi.getFilter().setMaskString("#0 AND #1");
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo sort = new SorterItemInfo("startDate");
            sort.setSortType(SortType.ASCEND);
            evi.getSorter().add(sort);
        }
        try {
            OrgTreeCollection col = DimensionCacheHelper.getOrgTreeIntance(ctx).getOrgTreeCollection(evi);
            if (col != null && !col.isEmpty()) {
                this.treeInfo.put(orgTreeNumber, col.get(0));
                return col.get(0);
            }
            this.treeInfo.put(orgTreeNumber, null);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public OrgTreeInfo getOrgTreeInfoById(Context ctx, String orgTreeId) {
        if (ctx == null || StringUtils.isEmpty((String)orgTreeId)) {
            return null;
        }
        EntityViewInfo evi = DimensionCacheHelper.getOrgTreeEntity();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)orgTreeId));
        try {
            OrgTreeCollection col = DimensionCacheHelper.getOrgTreeIntance(ctx).getOrgTreeCollection(evi);
            if (col != null && !col.isEmpty()) {
                return col.get(0);
            }
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EntityViewInfo getOrgTreeEntity() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(DimensionCacheHelper.getOrgTreeSelector());
        evi.setFilter(new FilterInfo());
        return evi;
    }

    public static SelectorItemCollection getOrgTreeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("startDate");
        return sic;
    }

    public static IOrgTree getOrgTreeIntance(Context ctx) throws BOSException {
        if (ctx == null) {
            return OrgTreeFactory.getRemoteInstance();
        }
        return OrgTreeFactory.getLocalInstance((Context)ctx);
    }

    public void setOrgLeafMap(Map<String, Boolean> orgLeafMap) {
        this.orgLeafMap = orgLeafMap;
    }

    public Map<String, Boolean> getOrgLeafMap() {
        return this.orgLeafMap;
    }
}

