/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IMbgDim;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionSourceFactory;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgSheetManagerImpl;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class DimensionFormulaHelper {
    private static Logger logger = Logger.getLogger((String)DimensionFormulaHelper.class.getName());
    public static final String MEMBER_SPLIT = ":";
    public static final String COMBINATE_SPLITER = ",";
    public static final String COMBINATE_SPLITER_TABLE = "_";

    public static BgDimensionMember convertToMember(Object object) {
        if (object instanceof BgDimensionMember) {
            return (BgDimensionMember)object;
        }
        if (object instanceof BgPeriodInfo) {
            return DimensionFormulaHelper.convertPeriod((BgPeriodInfo)object);
        }
        if (object instanceof BgElementInfo) {
            return DimensionFormulaHelper.convertElement((BgElementInfo)object);
        }
        if (object instanceof CurrencyInfo) {
            return DimensionFormulaHelper.convertCurrency((CurrencyInfo)object);
        }
        return null;
    }

    public static BgDimensionMember convertPeriod(BgPeriodInfo period) {
        if (period == null) {
            return null;
        }
        BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, String.valueOf(period.getPeriodType().getValue()), period.getName(), period.getNumber());
        member.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
        return member;
    }

    public static BgDimensionMember convertElement(BgElementInfo element) {
        if (element == null) {
            return null;
        }
        BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ELEMENT_NUMBER, String.valueOf(element.getDataType().getValue()), element.getName(), element.getNumber());
        member.setSrcNumber(DimensionConstants.DEF_ELEMENT_SRCNUMBER);
        return member;
    }

    public static BgDimensionMember convertCurrency(CurrencyInfo currency) {
        if (currency == null) {
            return null;
        }
        BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_CURRENCY_NUMBER, String.valueOf(currency.getPrecision()), currency.getName(), currency.getNumber());
        member.setSrcNumber(DimensionConstants.DEF_CURRENCY_SRCNUMBER);
        return member;
    }

    public static String convertToFormulaString(Context ctx, Object dimensionMember) {
        if (dimensionMember instanceof BgDimensionMember) {
            BgDimensionMember member = (BgDimensionMember)dimensionMember;
            String[] srcNumbers = member.getSrcNumber().split(COMBINATE_SPLITER);
            String[] numbers = member.getNumber().split(COMBINATE_SPLITER);
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < numbers.length; ++i) {
                DimensionFormulaHelper.addItem(result, srcNumbers[i], numbers[i]);
            }
            return result.toString();
        }
        if (dimensionMember instanceof String) {
            return (String)dimensionMember;
        }
        return "";
    }

    public static String getCombination(String srcNumber, String memberNumber) {
        StringBuffer target = new StringBuffer();
        DimensionFormulaHelper.addItem(target, srcNumber, memberNumber);
        return target.toString();
    }

    public static void addItem(StringBuffer target, String srcNumber, String memberNumber) {
        if (target.length() > 0) {
            target.append(COMBINATE_SPLITER);
        }
        target.append(srcNumber);
        if (memberNumber != null) {
            target.append(MEMBER_SPLIT);
            target.append(memberNumber);
        }
    }

    public static void addItem(StringBuffer target, String memberNumber) {
        if (target.length() > 0) {
            target.append(COMBINATE_SPLITER);
        }
        target.append(memberNumber);
    }

    public static String[] splitCombinations(String dimKey) {
        if (StringUtils.isEmpty((String)dimKey)) {
            return null;
        }
        return dimKey.split(COMBINATE_SPLITER, -1);
    }

    public static Map querySrcNumber(Context ctx, Map srcIdMap) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (srcIdMap.isEmpty()) {
            return map;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("srcId");
        evi.getSelector().add("srcNumber");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("srcId", new HashSet(srcIdMap.keySet()), CompareType.INCLUDE));
        CoreBaseCollection col = null;
        col = ctx == null ? DimensionSourceFactory.getRemoteInstance().getCollection(evi) : DimensionSourceFactory.getLocalInstance(ctx).getCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            DimensionSourceInfo source = (DimensionSourceInfo)col.get(i);
            map.put(source.getSrcID(), source.getSrcNumber());
        }
        return map;
    }

    public static String getSrcNumber(Context ctx, Map cache, String srcId) throws BOSException {
        if (cache == null) {
            cache = new HashMap();
        }
        if (cache.get(srcId) == null) {
            Map<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put(srcId, null);
            queryMap = DimensionFormulaHelper.querySrcNumber(ctx, queryMap);
            cache.putAll(queryMap);
        }
        return (String)cache.get(srcId);
    }

    public static String getSrcNumber(String onItemMember) {
        if (onItemMember.indexOf(MEMBER_SPLIT) >= 0) {
            return onItemMember.substring(0, onItemMember.indexOf(MEMBER_SPLIT));
        }
        return onItemMember;
    }

    public static Map<String, String> getMemberMap(String itemNumbers) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)itemNumbers)) {
            String[] combins = DimensionFormulaHelper.splitCombinations(itemNumbers);
            for (int i = 0; i < combins.length; ++i) {
                map.put(DimensionFormulaHelper.getSrcNumber(combins[i]), DimensionFormulaHelper.getMemberNumber(combins[i]));
            }
        }
        return map;
    }

    public static String getMemberNumber(String onItemMember) {
        if (onItemMember.indexOf(MEMBER_SPLIT) >= 0) {
            return onItemMember.substring(onItemMember.indexOf(MEMBER_SPLIT) + 1);
        }
        return null;
    }

    public static String getMemberNumberCombin(String itemCombin) {
        if (itemCombin == null) {
            return "";
        }
        String[] combs = DimensionFormulaHelper.splitCombinations(itemCombin);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < combs.length; ++i) {
            if (i > 0) {
                result.append(COMBINATE_SPLITER);
            }
            result.append(DimensionFormulaHelper.getMemberNumber(combs[i]));
        }
        return result.toString();
    }

    public static Object[] getFailCombinResult() {
        return new Object[]{null, Boolean.TRUE, null};
    }

    public static Object[] getSuccessCombinResult(String key, String dimKey) {
        return new Object[]{key, Boolean.FALSE, dimKey};
    }

    public static String getKey(Object[] combResult) {
        return (String)combResult[0];
    }

    public static String getDimKey(Object[] combResult) {
        return (String)combResult[2];
    }

    public static boolean isSuccess(Object[] combResult) {
        return Boolean.FALSE.equals(combResult[1]);
    }

    public static void getItemFormulaMap(String orgUnitId, String formulaLine, Map formulaMap, Map formualParamMap) throws EASBizException, BOSException {
        if (formulaMap.containsKey(formulaLine)) {
            return;
        }
        if (formulaLine.toLowerCase().indexOf("=bgitem") < 0) {
            return;
        }
        String[] params = BgNFSHelper.parseFormulaPara(formualParamMap, formulaLine);
        if (params == null) {
            return;
        }
        String strItemCombi = params[0];
        String _strItemCombi = "";
        String[] paramsNew = new String[6];
        if (!StringUtils.isEmpty((String)strItemCombi) && strItemCombi.indexOf(COMBINATE_SPLITER) > 0) {
            Map queryMap = new HashMap<String, Object>();
            queryMap.put(strItemCombi, null);
            queryMap = DimensionFormulaFacadeFactory.getRemoteInstance().batchParseItemCombination(queryMap, orgUnitId);
            if (queryMap.get(strItemCombi) instanceof Object[]) {
                _strItemCombi = StringUtils.cnulls((Object)((Object[])queryMap.get(strItemCombi))[0]);
            }
        } else {
            _strItemCombi = strItemCombi;
        }
        params[0] = _strItemCombi;
        if (params.length == 5) {
            paramsNew[0] = params[0];
            paramsNew[1] = params[1];
            paramsNew[2] = params[2];
            paramsNew[3] = params[3];
            paramsNew[4] = "true";
            paramsNew[5] = params[4];
        } else if (params.length == 6) {
            paramsNew = params;
        }
        String formula = BgNFSHelper.getFormulaFromParam(paramsNew);
        formulaMap.put(formulaLine, formula);
        if (!formula.equalsIgnoreCase(formulaLine)) {
            formulaMap.put(formula, formula);
            formualParamMap.put(formula, paramsNew);
        }
    }

    public static String getCombinKey(String combinStr) {
        if (combinStr == null) {
            return "";
        }
        return combinStr.replaceAll(COMBINATE_SPLITER, COMBINATE_SPLITER_TABLE);
    }

    public static String getCombinNumber(String combinStr) {
        if (combinStr == null) {
            return "";
        }
        return combinStr.replaceAll(COMBINATE_SPLITER_TABLE, COMBINATE_SPLITER);
    }

    public static void checkDimensionMemberExist(Context ctx, String orgUnitId, List checkList) throws EASBizException {
    }

    public static MbgViewManagerImpl buildViewMamager(Context ctx, Collection<String> formulas, Set<String> versionNumber) throws BOSException, EASBizException {
        MbgDimInfo mbgDim;
        String[] itemNumbers;
        String itemNumber;
        String[] formulaParam;
        WeakHashMap cacheMap = new WeakHashMap();
        HashMap<String, MbgDimInfo> srcNumbers = new HashMap<String, MbgDimInfo>();
        Iterator<String> it = formulas.iterator();
        while (it.hasNext()) {
            formulaParam = BgNFSHelper.parseFormulaPara(cacheMap, it.next());
            if (formulaParam == null) continue;
            itemNumber = formulaParam[0];
            itemNumbers = itemNumber.split(COMBINATE_SPLITER);
            for (int i = 0; i < itemNumbers.length; ++i) {
                srcNumbers.put(DimensionFormulaHelper.getSrcNumber(itemNumbers[i]), null);
            }
        }
        if (!srcNumbers.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("srcNumber");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("refField");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("srcNumber", new HashSet(srcNumbers.keySet()), CompareType.INCLUDE));
            IMbgDim ds = ctx == null ? MbgDimFactory.getRemoteInstance() : MbgDimFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection col = ds.getCollection(evi);
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    mbgDim = (MbgDimInfo)col.get(i);
                    srcNumbers.put(mbgDim.getSrcNumber(), mbgDim);
                }
            }
        }
        LinkedHashMap comMap = new LinkedHashMap();
        HashMap memberMap = new HashMap();
        StringBuffer key = new StringBuffer();
        Iterator<String> it2 = formulas.iterator();
        block5: while (it2.hasNext()) {
            String srcNumber;
            int i;
            key.setLength(0);
            formulaParam = BgNFSHelper.parseFormulaPara(cacheMap, it2.next());
            if (formulaParam == null) continue;
            if (formulaParam.length != 6) {
                throw new BgTemplateException(BgTemplateException.PARSEBGITEMFORMULAERROR);
            }
            itemNumber = formulaParam[0];
            String currNumber = formulaParam[5];
            String elementNumber = formulaParam[2];
            String periodNumber = formulaParam[1];
            String scenNumber = formulaParam[3];
            itemNumbers = itemNumber.split(COMBINATE_SPLITER);
            for (i = 0; i < itemNumbers.length; ++i) {
                srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
                if (srcNumber.equals(DimensionConstants.DEF_INDEX_SRCNUMBER)) {
                    key.append(DimensionConstants.DEF_ACCOUNT_NUMBER).append(COMBINATE_SPLITER_TABLE);
                    continue;
                }
                mbgDim = (MbgDimInfo)srcNumbers.get(srcNumber);
                if (mbgDim == null) continue block5;
                key.append(mbgDim.getNumber()).append(COMBINATE_SPLITER_TABLE);
            }
            key.append(StringUtils.isEmpty((String)currNumber)).append(COMBINATE_SPLITER_TABLE);
            key.append(StringUtils.isEmpty((String)periodNumber)).append(COMBINATE_SPLITER_TABLE);
            key.append(StringUtils.isEmpty((String)scenNumber)).append(COMBINATE_SPLITER_TABLE);
            String keyStr = key.toString();
            LinkedHashMap dimMap = (LinkedHashMap)comMap.get(keyStr);
            HashMap subMemberMap = (HashMap)memberMap.get(keyStr);
            if (dimMap == null) {
                dimMap = new LinkedHashMap();
                comMap.put(keyStr, dimMap);
            }
            if (subMemberMap == null) {
                subMemberMap = new HashMap();
                memberMap.put(keyStr, subMemberMap);
            }
            DimensionFormulaHelper.processDimensionMember(dimMap, subMemberMap, DimensionConstants.DEF_ELEMENT_NUMBER, null, DimensionFormulaHelper.getCombination(DimensionConstants.DEF_ELEMENT_SRCNUMBER, elementNumber));
            DimensionFormulaHelper.processDimensionMember(dimMap, subMemberMap, DimensionConstants.DEF_PERIOD_NUMBER, null, DimensionFormulaHelper.getCombination(DimensionConstants.DEF_PERIOD_SRCNUMBER, periodNumber));
            DimensionFormulaHelper.processDimensionMember(dimMap, subMemberMap, DimensionConstants.DEF_CURRENCY_NUMBER, null, DimensionFormulaHelper.getCombination(DimensionConstants.DEF_CURRENCY_SRCNUMBER, currNumber));
            DimensionFormulaHelper.processDimensionMember(dimMap, subMemberMap, DimensionConstants.DEF_SCENARIO_NUMBER, null, DimensionFormulaHelper.getCombination(DimensionConstants.DEF_SCENARIO_SRCNUMBER, scenNumber));
            for (i = 0; i < itemNumbers.length; ++i) {
                srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
                if (srcNumber.equals(DimensionConstants.DEF_INDEX_SRCNUMBER)) {
                    DimensionFormulaHelper.processDimensionMember(dimMap, subMemberMap, DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, itemNumbers[i]);
                    continue;
                }
                mbgDim = (MbgDimInfo)srcNumbers.get(srcNumber);
                DimensionFormulaHelper.processDimensionMember(dimMap, subMemberMap, mbgDim.getNumber(), mbgDim.getRefField(), itemNumbers[i]);
            }
        }
        int sheetIndex = 0;
        MbgViewManagerImpl view = new MbgViewManagerImpl();
        for (Map dimMap : comMap.values()) {
            MbgSheetManagerImpl sheet = new MbgSheetManagerImpl(view, sheetIndex++, "Sheet" + sheetIndex);
            view.addSheetManager(sheet);
            BgDimensionManagerImpl dimensionManager = new BgDimensionManagerImpl(ctx, sheet);
            sheet.setDimensionManager(dimensionManager);
            BgDimensionInfo dimension2 = new BgDimensionInfo(dimensionManager);
            dimension2.setLayout("page");
            dimension2.setMemberValueType(DimensionMemberValueModeEnum.Null);
            dimension2.setType(DimensionConstants.DEF_ORGUNIT_NUMBER);
            dimension2.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
            dimensionManager.addDimensionInfo(dimension2);
            dimension2 = new BgDimensionInfo(dimensionManager);
            dimension2.setLayout("page");
            dimension2.setMemberValueType(DimensionMemberValueModeEnum.Null);
            dimension2.setType(DimensionConstants.DEF_VERSION_NUMBER);
            dimension2.setNumber(DimensionConstants.DEF_VERSION_NUMBER);
            if (versionNumber != null) {
                for (String versionNum : versionNumber) {
                    DimensionFormulaHelper.addDefaultVersion(dimension2, versionNum, versionNum);
                }
            }
            dimensionManager.addDimensionInfo(dimension2);
            for (BgDimensionInfo dimension2 : dimMap.values()) {
                dimension2.setDimensionManager(dimensionManager);
                dimension2.sortMember();
                try {
                    if (!dimension2.getMember().isEmpty()) {
                        dimension2.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
                        dimension2.setValue(dimension2.unParseMember());
                    }
                }
                catch (DimensionException e) {
                    logger.error((Object)"", (Throwable)((Object)e));
                }
                dimensionManager.addDimensionInfo(dimension2);
            }
            dimensionManager.reloadDefaultDisplayDimension();
        }
        view.setSheetSequence(view.getSheetManagers().size());
        return view;
    }

    public static final void addDefaultVersion(IMbgViewBase view, String versionNumber, String versionName) {
        block3: {
            block2: {
                if (!(view instanceof IMbgViewManager)) break block2;
                for (int s = 0; s < ((IMbgViewManager)view).getSheetManagers().size(); ++s) {
                    BgDimensionInfo dimension = ((IMbgViewManager)view).getSheetManagers().get(s).getDimensionManager().searchDimension(DimensionConstants.DEF_VERSION_NUMBER);
                    DimensionFormulaHelper.addDefaultVersion(dimension, versionNumber, versionName);
                }
                break block3;
            }
            if (!(view instanceof MbgViewListManager)) break block3;
            for (int s = 0; s < ((IMbgViewManager)view).getSheetManagers().size(); ++s) {
                BgDimensionBaseInfo dimension = ((MbgViewListSheetManager)((MbgViewListManager)view).getSheetManagers().get(s)).getDimensionManager().searchDimension(DimensionConstants.DEF_VERSION_NUMBER);
                DimensionFormulaHelper.addDefaultVersion(dimension, versionNumber, versionName);
            }
        }
    }

    public static final void addDefaultVersion(BgDimensionBaseInfo dimension, String versionNumber, String versionName) {
        if (!StringUtils.isEmpty((String)versionNumber) && dimension != null && DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType()) && dimension.getMember().isEmpty()) {
            BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_VERSION_NUMBER, DimensionConstants.DEF_VERSION_NUMBER, versionNumber, versionNumber);
            member.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
            dimension.getMember().add(member);
            dimension.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
        }
    }

    private static void processDimensionMember(Map dimMap, Map memberMap, String dimNumber, String attribute, String memberNumber) {
        BgDimensionInfo dimension;
        if (memberMap.containsKey(memberNumber)) {
            return;
        }
        memberMap.put(memberNumber, null);
        String number = DimensionFormulaHelper.getMemberNumber(memberNumber);
        String srcNumber = DimensionFormulaHelper.getSrcNumber(memberNumber);
        if (dimMap.containsKey(dimNumber)) {
            dimension = (BgDimensionInfo)dimMap.get(dimNumber);
        } else {
            dimension = new BgDimensionInfo(null);
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber) || DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimNumber) || DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber) || DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimNumber)) {
                dimension.setLayout("col");
            } else {
                dimension.setLayout("row");
            }
            dimension.setNumber(dimNumber);
            dimension.setType(dimNumber);
            dimension.setAttribute(attribute);
            if (StringUtils.isEmpty((String)number)) {
                dimension.setMemberValueType(DimensionMemberValueModeEnum.Null);
            } else {
                dimension.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            }
            dimMap.put(dimension.getType(), dimension);
        }
        if (!StringUtils.isEmpty((String)number)) {
            BgDimensionMember member = new BgDimensionMember(dimNumber, attribute, memberNumber, memberNumber);
            if (memberNumber.indexOf(MEMBER_SPLIT) > 0) {
                member.setSrcNumber(srcNumber);
                member.setNumber(number);
                member.setName(member.getNumber());
            }
            dimension.getMember().add(member);
        }
    }

    public static String getDefaultSrcNumber(String dimNumber) {
        if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_CURRENCY_SRCNUMBER;
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_ORGUNIT_SRCNUMBER;
        }
        if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_ELEMENT_SRCNUMBER;
        }
        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_PERIOD_SRCNUMBER;
        }
        if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_SCENARIO_SRCNUMBER;
        }
        if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_VERSION_SRCNUMBER;
        }
        if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber) || DimensionConstants.DEF_INDEX_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_INDEX_SRCNUMBER;
        }
        return null;
    }

    public static String getDefaultSrcNumberByField(String field) {
        if (DimensionConstants.DEF_CURRENCY_FIELD.equals(field)) {
            return DimensionConstants.DEF_CURRENCY_SRCNUMBER;
        }
        if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(field)) {
            return DimensionConstants.DEF_ORGUNIT_SRCNUMBER;
        }
        if (DimensionConstants.DEF_ELEMENT_FIELD.equals(field)) {
            return DimensionConstants.DEF_ELEMENT_SRCNUMBER;
        }
        if (DimensionConstants.DEF_PERIOD_FIELD.equals(field)) {
            return DimensionConstants.DEF_PERIOD_SRCNUMBER;
        }
        if (DimensionConstants.DEF_SCENARIO_FIELD.equals(field)) {
            return DimensionConstants.DEF_SCENARIO_SRCNUMBER;
        }
        if (DimensionConstants.DEF_VERSION_FIELD.equals(field)) {
            return DimensionConstants.DEF_VERSION_SRCNUMBER;
        }
        if (DimensionConstants.DEF_BGINDEX_FIELD.equals(field)) {
            return DimensionConstants.DEF_INDEX_SRCNUMBER;
        }
        return null;
    }

    public static String getDefaultDimNumberByField(String field) {
        if (DimensionConstants.DEF_CURRENCY_FIELD.equals(field)) {
            return DimensionConstants.DEF_CURRENCY_NUMBER;
        }
        if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(field)) {
            return DimensionConstants.DEF_ORGUNIT_NUMBER;
        }
        if (DimensionConstants.DEF_ELEMENT_FIELD.equals(field)) {
            return DimensionConstants.DEF_ELEMENT_NUMBER;
        }
        if (DimensionConstants.DEF_PERIOD_FIELD.equals(field)) {
            return DimensionConstants.DEF_PERIOD_NUMBER;
        }
        if (DimensionConstants.DEF_SCENARIO_FIELD.equals(field)) {
            return DimensionConstants.DEF_SCENARIO_NUMBER;
        }
        if (DimensionConstants.DEF_VERSION_FIELD.equals(field)) {
            return DimensionConstants.DEF_VERSION_NUMBER;
        }
        if (DimensionConstants.DEF_BGINDEX_FIELD.equals(field)) {
            return DimensionConstants.DEF_INDEX_NUMBER;
        }
        return null;
    }

    public static String getDefaultRefField(String dimNumber) {
        if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_CURRENCY_FIELD;
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_ORGUNIT_FIELD;
        }
        if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_ELEMENT_FIELD;
        }
        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_PERIOD_FIELD;
        }
        if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_SCENARIO_FIELD;
        }
        if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_VERSION_FIELD;
        }
        if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber) || DimensionConstants.DEF_INDEX_NUMBER.equals(dimNumber)) {
            return DimensionConstants.DEF_BGINDEX_FIELD;
        }
        return null;
    }

    public static String[] split(String string, String split) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return string.split(split);
    }

    public static Map<String, Map<String, String>> queryCombinNames(Context ctx, IBudgetBalance balance) throws BOSException, EASBizException {
        if (balance == null || balance.getBalance().isEmpty()) {
            return new HashMap<String, Map<String, String>>();
        }
        return DimensionFormulaHelper.queryCombinNames(ctx, balance.getBalance(), true);
    }

    public static Map<String, Map<String, String>> queryCombinNames(Context ctx, IBudgetBalance balance, boolean isSegregationRuleFilter) throws BOSException, EASBizException {
        if (balance == null || balance.getBalance().isEmpty()) {
            return new HashMap<String, Map<String, String>>();
        }
        return DimensionFormulaHelper.queryCombinNames(ctx, balance.getBalance(), isSegregationRuleFilter);
    }

    public static Map<String, Map<String, String>> queryCombinNames(Context ctx, List<BgControlParam> balance, boolean isSegregationRuleFilter) throws BOSException, EASBizException {
        HashMap<String, Map<String, String>> combinNames = new HashMap<String, Map<String, String>>();
        String bgSchemeId = null;
        String orgUnitId = null;
        orgUnitId = ctx != null ? ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString() : SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        HashMap queryNums = new HashMap();
        Set<String> combins = null;
        BgControlParam param = null;
        for (int i = 0; i < balance.size(); ++i) {
            String[] tmpStrs;
            param = balance.get(i);
            bgSchemeId = param.getBgSchemeInfo().getId().toString();
            if (queryNums.containsKey(bgSchemeId)) {
                combins = (Set)queryNums.get(bgSchemeId);
            } else {
                combins = new HashSet();
                queryNums.put(bgSchemeId, combins);
            }
            combins.add(param.getBgIndexNumber());
            if (StringUtils.isEmpty((String)param.getDimItemNumber()) || (tmpStrs = param.getDimItemNumber().split(COMBINATE_SPLITER)) == null) continue;
            int jn = tmpStrs.length;
            for (int j = 0; j < jn; ++j) {
                combins.add(tmpStrs[j]);
            }
        }
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : queryNums.entrySet()) {
            bgSchemeId = (String)entry2.getKey();
            combins = (Set)entry2.getValue();
            if (combins.isEmpty()) continue;
            IDimensionFormulaFacade facade = null;
            facade = ctx == null ? DimensionFormulaFacadeFactory.getRemoteInstance() : DimensionFormulaFacadeFactory.getLocalInstance(ctx);
            Map tmpMap = facade.getDimensionCombName(bgSchemeId, combins, orgUnitId, true, isSegregationRuleFilter);
            if (tmpMap == null) continue;
            combinNames.put(bgSchemeId, tmpMap);
        }
        return combinNames;
    }

    public static Map<String, String> parseFormula(String formula) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)formula)) {
            return result;
        }
        String[] formulas = BgNFSHelper.parseFormulaPara(formula);
        if (!StringUtils.isEmpty((String)formulas[5])) {
            result.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, formulas[5]);
        }
        if (!StringUtils.isEmpty((String)formulas[2])) {
            result.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, formulas[2]);
        }
        if (!StringUtils.isEmpty((String)formulas[1])) {
            result.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, formulas[1]);
        }
        if (!StringUtils.isEmpty((String)formulas[3])) {
            result.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, formulas[3]);
        }
        String[] combins = DimensionFormulaHelper.splitCombinations(formulas[0]);
        for (int i = 0; i < combins.length; ++i) {
            result.put(DimensionFormulaHelper.getSrcNumber(combins[i]), DimensionFormulaHelper.getMemberNumber(combins[i]));
        }
        return result;
    }
}

