/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationGroupShowEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.IDimensionRelationship;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGRowData;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DimensionMemberRelationShipHelper
implements Serializable {
    private static final long serialVersionUID = -8884780342174389044L;
    public static final String ADD_RES = "com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource";
    private DimensionRelationshipGroupInfo group = null;
    private DimensionRelationshipCollection col = new DimensionRelationshipCollection();
    private Map<String, BgDimensionMember> members = new HashMap<String, BgDimensionMember>();
    private BgSchemeDimensionHelper schemeHelper = null;

    private DimensionMemberRelationShipHelper() {
    }

    public DimensionRelationshipGroupInfo getGroup() {
        return this.group;
    }

    public DimensionRelationshipCollection getCol() {
        return this.col;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.schemeHelper;
    }

    public Map<String, BgDimensionMember> getMembers(BgDimensionInfo dimension, Map<String, Set<String>> hasMember) {
        HashMap<String, BgDimensionMember> result = new HashMap<String, BgDimensionMember>();
        String currSrcNumber = null;
        for (int e = 0; e < this.group.getEntries().size(); ++e) {
            if (!this.group.getEntries().get(e).getDimNumber().equals(dimension.getNumber())) continue;
            currSrcNumber = this.getSchemeHelper().getSrcNumber(dimension.getNumber());
        }
        if (currSrcNumber == null) {
            return result;
        }
        block1: for (int c = 0; c < this.col.size(); ++c) {
            String onCombin = this.col.get(c).getDimensionNumber();
            String[] combinas = DimensionFormulaHelper.splitCombinations(onCombin);
            String currNumber = null;
            for (int i = 0; i < combinas.length; ++i) {
                if (result.containsKey(combinas[i])) continue block1;
                String srcNumber = DimensionFormulaHelper.getSrcNumber(combinas[i]);
                String number = DimensionFormulaHelper.getMemberNumber(combinas[i]);
                if (srcNumber.equals(currSrcNumber)) {
                    currNumber = DimensionFormulaHelper.getCombination(currSrcNumber, number);
                }
                if (hasMember.containsKey(srcNumber) && !hasMember.get(srcNumber).contains(number)) continue block1;
            }
            if (currNumber == null || !this.members.containsKey(currNumber)) continue;
            result.put(currNumber, this.members.get(currNumber));
        }
        return result;
    }

    public static DimensionMemberRelationShipHelper buildHelper(Context ctx, DimensionCacheHelper cacheHelper, String relationGroupId, String orgUnitId, List<MbgRelationMap> relationMaps) throws BOSException, EASBizException {
        if (ctx == null) {
            return DimensionFormulaFacadeFactory.getRemoteInstance().buildRelationHelper(relationGroupId, orgUnitId, relationMaps);
        }
        return DimensionFormulaFacadeFactory.getLocalInstance(ctx).buildRelationHelper(relationGroupId, orgUnitId, relationMaps);
    }

    public static DimensionMemberRelationShipHelper initForLocaleHost(Context ctx, DimensionCacheHelper cacheHelper, String relationGroupId, String orgUnitId, List<MbgRelationMap> relationMaps) throws BOSException, EASBizException {
        String[] combinas;
        String oneCombin;
        DimensionMemberRelationShipHelper helper = new DimensionMemberRelationShipHelper();
        helper.group = cacheHelper.getRelationGroup(relationGroupId);
        if (helper.group == null) {
            return null;
        }
        boolean isAllCsl = false;
        if (!helper.group.isIsCsl()) {
            helper.schemeHelper = new BgSchemeDimensionHelper(ctx, helper.group.getBgScheme().getId().toString());
        } else {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(helper.group.getOrgTreeId());
            helper.schemeHelper = BgSchemeDimensionHelper.getCslInstance(ctx, helper.group.getBgScheme().getId().toString(), orgTree);
            IOrgStructure ios = null;
            ios = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
            if (!ios.exists("where tree.id = '" + helper.group.getOrgTreeId() + "' and unit.id = '" + orgUnitId + "'")) {
                isAllCsl = true;
            }
        }
        CoreBaseCollection col = null;
        if (relationMaps != null && !relationMaps.isEmpty()) {
            col = DimensionMemberRelationShipHelper.queryAllRelationByMap(ctx, helper.getGroup(), relationMaps, isAllCsl ? null : DimensionMemberRelationShipHelper.getOrgUnitInfo(cacheHelper, orgUnitId, helper.group.isIsCsl()));
            if (col != null && !col.isEmpty() && ((DimensionRelationshipInfo)col.get(0)).getDimensionNumber().indexOf(":") < 0) {
                col = DimensionMemberRelationShipHelper.queryAllRelationByGroupId(ctx, helper.getGroup(), isAllCsl ? null : DimensionMemberRelationShipHelper.getOrgUnitInfo(cacheHelper, orgUnitId, helper.group.isIsCsl()));
            }
        } else {
            col = DimensionMemberRelationShipHelper.queryAllRelationByGroupId(ctx, helper.getGroup(), isAllCsl ? null : DimensionMemberRelationShipHelper.getOrgUnitInfo(cacheHelper, orgUnitId, helper.group.isIsCsl()));
        }
        if (col == null || col.isEmpty()) {
            return helper;
        }
        HashSet<String> numbers = new HashSet<String>();
        DimensionRelationshipInfo info = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            info = (DimensionRelationshipInfo)it.next();
            if (!numbers.contains(info.getDimensionNumber())) {
                numbers.add(info.getDimensionNumber());
                continue;
            }
            it.remove();
        }
        helper.col.addObjectCollection((IObjectCollection)col);
        HashMap members = new HashMap();
        for (int i = 0; i < col.size(); ++i) {
            oneCombin = ((DimensionRelationshipInfo)col.get(i)).getDimensionNumber();
            combinas = DimensionFormulaHelper.splitCombinations(oneCombin);
            for (int c = 0; c < combinas.length; ++c) {
                String srcNumber = DimensionFormulaHelper.getSrcNumber(combinas[c]);
                String number = DimensionFormulaHelper.getMemberNumber(combinas[c]);
                if (!members.containsKey(srcNumber)) {
                    members.put(srcNumber, new HashSet());
                }
                ((Set)members.get(srcNumber)).add(number);
            }
        }
        IDimensionFormulaFacade facade = null;
        facade = ctx == null ? DimensionFormulaFacadeFactory.getRemoteInstance() : DimensionFormulaFacadeFactory.getLocalInstance(ctx);
        Map<String, BgDimensionInfo> dimensions = helper.getSchemeHelper().getDimensionBySrcNumber();
        for (String srcNumber : members.keySet()) {
            if (!dimensions.containsKey(srcNumber)) {
                throw new DimensionException(DimensionException.NOFOUNDSOURCE, new Object[]{srcNumber});
            }
            Map existMembers = facade.queryMembers(orgUnitId, helper.getSchemeHelper(), dimensions.get(srcNumber).getNumber(), (Set)members.get(srcNumber), false, null);
            if (existMembers == null) continue;
            for (BgDimensionMember member : existMembers.values()) {
                helper.members.put(DimensionFormulaHelper.getCombination(srcNumber, member.getNumber()), member);
            }
        }
        if (members.containsKey(DimensionConstants.DEF_PERIOD_SRCNUMBER)) {
            Set pNumbers = (Set)members.get(DimensionConstants.DEF_PERIOD_SRCNUMBER);
            String pNumber2 = "";
            if (pNumbers != null && !pNumbers.isEmpty()) {
                for (String pNumber2 : pNumbers) {
                    BgDimensionMember member;
                    if (helper.members.containsKey(DimensionConstants.DEF_PERIOD_SRCNUMBER + ":" + pNumber2) || !BgPeriodNVariableHelper.checkCanConvert((String)pNumber2)) continue;
                    member = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, pNumber2, pNumber2);
                    helper.members.put(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_PERIOD_SRCNUMBER, pNumber2), member);
                }
            }
        }
        block6: for (int i = col.size() - 1; i >= 0; --i) {
            oneCombin = ((DimensionRelationshipInfo)col.get(i)).getDimensionNumber();
            combinas = DimensionFormulaHelper.splitCombinations(oneCombin);
            for (int c = 0; c < combinas.length; ++c) {
                if (helper.members.containsKey(combinas[c])) continue;
                helper.getCol().removeObject(col.getObject(i));
                col.removeObject(i);
                continue block6;
            }
        }
        return helper;
    }

    private static OrgUnitInfo getOrgUnitInfo(DimensionCacheHelper cacheHelper, String orgUnitId, boolean isCsl) throws EASBizException, BOSException {
        return cacheHelper.getOrgUnitById(orgUnitId, isCsl);
    }

    private static CoreBaseCollection queryAllRelationByMap(Context ctx, DimensionRelationshipGroupInfo group, List<MbgRelationMap> relationMaps, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        if (group == null) {
            return null;
        }
        CoreBaseCollection col = new CoreBaseCollection();
        MbgRelationMap map = null;
        for (int i = 0; i < relationMaps.size(); ++i) {
            if (!relationMaps.get(i).getGroup().getId().toString().equals(group.getId().toString())) continue;
            map = relationMaps.get(i);
            break;
        }
        if (map != null) {
            if (map.getRelationShips().isEmpty() && !map.isSelectRelation()) {
                return DimensionMemberRelationShipHelper.queryAllRelationByGroupId(ctx, group, orgUnit);
            }
            col.addObjectCollection((IObjectCollection)map.getRelationShips());
        }
        return col;
    }

    public static CoreBaseCollection queryAllRelationByGroupId(Context ctx, DimensionRelationshipGroupInfo group, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        IDimensionRelationship drs = null;
        IBgOrgUnit iBgOrgUnit = null;
        if (ctx == null) {
            drs = DimensionRelationshipFactory.getRemoteInstance();
            iBgOrgUnit = BgOrgUnitFactory.getRemoteInstance();
        } else {
            drs = DimensionRelationshipFactory.getLocalInstance(ctx);
            iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("dimensionNumber");
        evi.getSelector().add("dimensionName");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("dimensionGroup.id", (Object)group.getId().toString()));
        if (orgUnit != null) {
            BgSchemeDimensionHelper schemeDimensionHelper;
            if (group.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.childQuarantine)) {
                evi.getFilter().getFilterItems().add(DimensionMemberRelationShipHelper.getLowerShowFilter(ctx, group.getBgScheme().getId().toString(), orgUnit.getId().toString()));
            } else if (group.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.equalQuarantine)) {
                schemeDimensionHelper = new BgSchemeDimensionHelper(ctx, group.getBgScheme().getId().toString());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("filterUnit.id", (Object)iBgOrgUnit.getParentAndChildrenOrgUnitIds(orgUnit.getId().toString(), schemeDimensionHelper.getBgOrgViewId()), CompareType.INCLUDE));
            } else if (group.getIsLowerShow().equals((Object)DimensionRelationGroupShowEnum.allQuarantine)) {
                schemeDimensionHelper = new BgSchemeDimensionHelper(ctx, group.getBgScheme().getId().toString());
                HashSet<String> orgSet = new HashSet<String>();
                BgOrgUnitCollection colls = iBgOrgUnit.getBgOrgUnitCollection("Select orgUnitID  Where viewID = '" + schemeDimensionHelper.getBgOrgViewId() + "'");
                for (int i = 0; i < colls.size(); ++i) {
                    orgSet.add(colls.get(i).getOrgUnitID().toString());
                }
                evi.getFilter().getFilterItems().add(new FilterItemInfo("filterUnit.id", orgSet, CompareType.INCLUDE));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("filterUnit.id", (Object)orgUnit.getId().toString()));
            }
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isEnabled", (Object)Boolean.TRUE));
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo("dimensionNumber"));
        CoreBaseCollection col = drs.getCollection(evi);
        return col;
    }

    public static FilterItemInfo getLowerShowFilter(Context ctx, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        if (orgUnitId == null) {
            return new FilterItemInfo("id", (Object)"000000000000000000000000000=");
        }
        String longNumber = null;
        boolean isCsl = false;
        IOrgStructure ios = null;
        ios = ctx != null ? OrgStructureFactory.getLocalInstance((Context)ctx) : OrgStructureFactory.getRemoteInstance();
        OrgStructureCollection col = ios.getOrgStructureCollection("select longNumber, isLeaf, tree.id where unit.id = '" + orgUnitId + "' and unit.isGrouping = 1");
        if (col != null && !col.isEmpty()) {
            longNumber = col.get(0).getLongNumber();
            isCsl = true;
        } else {
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            String orgViewId = schemeHelper.getBgOrgViewId();
            IBgOrgUnit ibo = null;
            ibo = ctx != null ? BgOrgUnitFactory.getLocalInstance(ctx) : BgOrgUnitFactory.getRemoteInstance();
            BgOrgUnitCollection col1 = ibo.getBgOrgUnitCollection("select longNumber where orgUnitId = '" + orgUnitId + "' and viewID = '" + orgViewId + "' and isVirtual = 0");
            if (col1 != null && !col1.isEmpty()) {
                longNumber = col1.get(0).getLongNumber();
            }
        }
        return DimensionMemberRelationShipHelper.getLowerShowFilter(isCsl, longNumber);
    }

    public static Set<String> getLowerShowNumber(Context ctx, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        if (orgUnitId == null) {
            return new HashSet<String>();
        }
        String longNumber = null;
        boolean isCsl = false;
        IOrgStructure ios = null;
        ios = ctx != null ? OrgStructureFactory.getLocalInstance((Context)ctx) : OrgStructureFactory.getRemoteInstance();
        OrgStructureCollection col = ios.getOrgStructureCollection("select longNumber, isLeaf, tree.id where unit.id = '" + orgUnitId + "' and unit.isGrouping = 1");
        if (col != null && !col.isEmpty()) {
            longNumber = col.get(0).getLongNumber();
            isCsl = true;
        } else {
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            String orgViewId = schemeHelper.getBgOrgViewId();
            IBgOrgUnit ibo = null;
            ibo = ctx != null ? BgOrgUnitFactory.getLocalInstance(ctx) : BgOrgUnitFactory.getRemoteInstance();
            BgOrgUnitCollection col1 = ibo.getBgOrgUnitCollection("select longNumber where orgUnitId = '" + orgUnitId + "' and viewID = '" + orgViewId + "' and isVirtual = 0");
            if (col1 != null && !col1.isEmpty()) {
                longNumber = col1.get(0).getLongNumber();
            }
        }
        if (longNumber != null) {
            return new HashSet<String>(Arrays.asList(longNumber.split("!")));
        }
        return new HashSet<String>();
    }

    public static FilterItemInfo getLowerShowFilter(boolean isCsl, String longNumber) {
        if (longNumber == null) {
            return new FilterItemInfo("id", (Object)"000000000000000000000000000=");
        }
        String filterField = DimensionMemberRelationShipHelper.getFilterField(isCsl);
        FilterItemInfo itemInfo = new FilterItemInfo(filterField + ".number", new HashSet<String>(Arrays.asList(longNumber.split("!"))), CompareType.INCLUDE);
        return itemInfo;
    }

    public static String getFilterField(boolean isCsl) {
        String filterField = isCsl ? "filterUnit" : "costUnit";
        return filterField;
    }

    public static MbgRelationMap buildRelationMap(DimensionMemberRelationShipHelper shipHelper, IMbgViewManager view) {
        if (shipHelper == null) {
            return null;
        }
        MbgRelationMap result = new MbgRelationMap(view);
        result.setGroup(shipHelper.group);
        result.setRelationShips(shipHelper.col);
        return result;
    }

    public static void loadEffectiveItemCombin(String orgNumber, MbgViewListSheetManager sheetManager, BgSchemeDimensionHelper schemeHelper, Map<String, MBGRowData> mbgRowDatas, boolean isLoadPage, boolean isMergeDim, boolean isShowDefaultMember) {
        if (sheetManager == null) {
            return;
        }
        if (isLoadPage && sheetManager.getDimensionManager().getPageRelationMaps() != null && !sheetManager.getDimensionManager().getPageRelationMaps().isEmpty()) {
            MBGRowData mbgRowData = new MBGRowData(sheetManager.getDimensionManager().getPageDimension(), isShowDefaultMember, schemeHelper);
            mbgRowData.setHasRelation(true);
            mbgRowDatas.put(DimensionMemberRelationShipHelper.getKey(orgNumber, "page", -1), mbgRowData);
            DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, mbgRowData, sheetManager.getDimensionManager().getPageRelationMaps(), sheetManager.getDimensionManager().getPageDimension(), schemeHelper, isMergeDim, "page", isShowDefaultMember);
        }
        DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, sheetManager.getDimensionManager().getRows(), "row", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
        DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, sheetManager.getDimensionManager().getColumns(), "col", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
    }

    public static void loadEffectiveItemCombin(String orgNumber, List<IMbgViewListObject> rows, String layout, BgSchemeDimensionHelper schemeHelper, Map<String, MBGRowData> mbgRowDatas, boolean isMergeDim, boolean isShowDefaultMember) {
        MbgViewListRowCol rowObject = null;
        for (int i = 0; i < rows.size(); ++i) {
            if (!(rows.get(i) instanceof MbgViewListRowCol) || (rowObject = (MbgViewListRowCol)rows.get(i)).getRelationMaps() == null || rowObject.getRelationMaps().isEmpty()) continue;
            List<BgDimensionBaseInfo> dimensions = rowObject.getDimensions();
            MBGRowData mbgRowData = new MBGRowData(dimensions, isShowDefaultMember, schemeHelper);
            mbgRowDatas.put(DimensionMemberRelationShipHelper.getKey(orgNumber, layout, rowObject.getIndex()), mbgRowData);
            mbgRowData.setHasRelation(true);
            DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, mbgRowData, rowObject.getRelationMaps(), dimensions, schemeHelper, isMergeDim, layout, isShowDefaultMember);
        }
    }

    public static void loadEffectiveItemCombin(String orgNumber, MBGRowData mbgRowData, List<MbgRelationMap> relationMaps, List dimensions, BgSchemeDimensionHelper schemeHelper, boolean isMergeDim, String layout, boolean isShowDefaultMember) {
        RelationUtils utils = RelationUtils.getInstance(schemeHelper);
        utils.setShowDefaultMember(isShowDefaultMember);
        List<String[]> combinas = utils.queryRelation(relationMaps, utils.transDimension(dimensions, new HashSet<String>()), isMergeDim, layout);
        if (combinas != null && !combinas.isEmpty() && combinas.size() < 2) {
            MbgRelationMap relationMap = new MbgRelationMap(null);
            relationMap.setGroup(relationMaps.get(0).getGroup());
            relationMap.setRelationShips(new DimensionRelationshipCollection());
            ArrayList<MbgRelationMap> relations = new ArrayList<MbgRelationMap>();
            relations.add(relationMap);
            combinas = utils.queryRelation(relations, utils.transDimension(dimensions, new HashSet<String>()), isMergeDim, layout);
        }
        if (combinas != null && !combinas.isEmpty()) {
            String[] oneComb = combinas.get(0);
            mbgRowData.setRefFieldSort(oneComb);
            for (int i = 1; i < combinas.size(); ++i) {
                oneComb = combinas.get(i);
                mbgRowData.addEffectiveItemCombin(oneComb);
            }
        }
        mbgRowData.afterLoadData();
    }

    public static String getKey(String orgNumber, String layout, int index) {
        if ("page".equals(layout)) {
            return orgNumber + "_" + layout;
        }
        return orgNumber + "_" + layout + "_" + index;
    }

    public static boolean isInFilter(String dimensionNumber, Map<String, Set<String>> filterValueMap) {
        if (filterValueMap == null || filterValueMap.isEmpty()) {
            return true;
        }
        String[] combins = DimensionFormulaHelper.splitCombinations(dimensionNumber);
        for (int c = 0; c < combins.length; ++c) {
            String srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
            String number = DimensionFormulaHelper.getMemberNumber(combins[c]);
            if (!filterValueMap.containsKey(srcNumber) || filterValueMap.get(srcNumber).contains(number)) continue;
            return false;
        }
        return true;
    }
}

