/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MBgCheckHelper {
    public static Set<String> checkInProInst(Context ctx, Collection<String> billIds) throws BOSException {
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        ProcessInstInfo[] procInsts = null;
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        for (String billId : billIds) {
            procInsts = service.getProcessInstanceByHoldedObjectId(billId);
            if (procInsts == null) continue;
            for (int i = 0; i < procInsts.length; ++i) {
                if (!procInsts[i].getState().startsWith("open")) continue;
                result.add(billId);
            }
        }
        return result;
    }

    public static Set<String> requestMutex(Context ctx, List<String> billIds) throws BOSException {
        if (billIds == null || billIds.isEmpty()) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        Map reMap = MBgCheckHelper.getMutexInstance(ctx).batchRequestBizObjIDForUpdate(billIds);
        if (reMap != null) {
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : reMap.entrySet()) {
                if (((Boolean)entry2.getValue()).booleanValue()) continue;
                result.add((String)entry2.getKey());
            }
        }
        return result;
    }

    public static Set<String> requestMutex(Context ctx, List<String> billIds, boolean check) throws BOSException {
        Set<Object> result;
        block7: {
            if (billIds == null || billIds.isEmpty()) {
                return null;
            }
            result = new LinkedHashSet();
            if (check) {
                Object lock = null;
                Class<?> _class = null;
                Method _method = null;
                try {
                    _class = Class.forName("com.kingdee.eas.base.netctrl.IMutexServiceControl");
                    if (_class == null) break block7;
                    _method = _class.getMethod("getObjectUpdateLock", String.class);
                    if (_method != null) {
                        for (String billId : billIds) {
                            lock = _method.invoke((Object)MBgCheckHelper.getMutexInstance(ctx), billId);
                            if (lock == null) continue;
                            result.add(billId);
                        }
                        break block7;
                    }
                    result = MBgCheckHelper.requestMutex(ctx, billIds);
                }
                catch (Exception ex) {
                    result = MBgCheckHelper.requestMutex(ctx, billIds);
                }
            } else {
                result = MBgCheckHelper.requestMutex(ctx, billIds);
            }
        }
        return result;
    }

    public static void releaseMutex(Context ctx, List<String> billIds) throws BOSException {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MBgCheckHelper.getMutexInstance(ctx).batchReleaseObjIDForUpdate(billIds);
    }

    public static void releaseMutex(Context ctx, String billId) throws BOSException {
        if (billId == null || StringUtils.isEmpty((String)billId)) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        MBgCheckHelper.getMutexInstance(ctx).batchReleaseObjIDForUpdate(ids);
    }

    public static IMutexServiceControl getMutexInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return MutexServiceControlFactory.getRemoteInstance();
        }
        return MutexServiceControlFactory.getLocalInstance((Context)ctx);
    }
}

