/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.OperandExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.mbg.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgExamineDataCheckResult;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineNoPassEnum;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgScopeCollection;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.app.BgExamineFacadeControllerBean;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.cube.dimension.Dimension;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BizCalcObj;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBgExamineUtils {
    private static Logger logger = Logger.getLogger((String)MBgExamineUtils.class.getName());
    public static final String DEFAULT_ORGUNIT_NUMBER = "DEFAULT_ORGUNIT_NUMBER";
    public static final int INDEX_NUMBER = 0;
    public static final int INDEX_NAME = 1;
    public static final int INDEX_ID = 2;

    public static boolean check(List<BgExamineResult> results) {
        if (results == null) {
            return false;
        }
        Boolean check = null;
        for (int index = 0; index < results.size(); ++index) {
            if (results.get(index) == null || results.get((int)index).result) continue;
            check = false;
        }
        if (check == null) {
            check = true;
        }
        return check;
    }

    public static Map<String, List<Map<String, String>>> queryBgAdjustMemberMap(Connection conn, List<BgAdjustBillInfo> bgAdjusts) throws BOSException, EASBizException {
        HashMap<String, List<Map<String, String>>> schemaDataMap = new HashMap<String, List<Map<String, String>>>();
        if (conn == null || bgAdjusts == null || bgAdjusts.isEmpty()) {
            return schemaDataMap;
        }
        List mbgDatas = null;
        HashMap<String, String> mbgDataMap = null;
        String schemaNum = null;
        String[] tmpStrs = null;
        String[] tmpFields = null;
        BgAdjustBillInfo bgAdjust = null;
        BgAdjustBillEntryInfo entry = null;
        int in = bgAdjusts.size();
        for (int i = 0; i < in; ++i) {
            bgAdjust = bgAdjusts.get(i);
            schemaNum = bgAdjust.getBgScheme().getNumber();
            if (schemaDataMap.containsKey(schemaNum)) {
                mbgDatas = (List)schemaDataMap.get(schemaNum);
            } else {
                mbgDatas = new ArrayList();
                schemaDataMap.put(schemaNum, mbgDatas);
            }
            int jn = bgAdjust.getEntity().size();
            for (int j = 0; j < jn; ++j) {
                entry = bgAdjust.getEntity().get(j);
                mbgDataMap = new HashMap<String, String>();
                mbgDataMap.put(DimensionBaseConstants.DEF_SCENARIO_FIELD, entry.getBgScenario() != null ? entry.getBgScenario().getNumber() : bgAdjust.getBgScenario().getNumber());
                mbgDataMap.put(DimensionBaseConstants.DEF_VERSION_FIELD, bgAdjust.getBgVersion().getNumber());
                mbgDataMap.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, bgAdjust.getCurrency().getNumber());
                mbgDataMap.put(DimensionBaseConstants.DEF_ELEMENT_FIELD, entry.getBgElement() != null ? entry.getBgElement().getNumber() : bgAdjust.getElement().getNumber());
                mbgDataMap.put(DimensionBaseConstants.DEF_BGINDEX_FIELD, DimUtils.getNumber(entry.getIndexMemberNumber()));
                if (!StringUtils.isEmpty((String)entry.getMemberCombinNumber())) {
                    tmpStrs = entry.getMemberCombinNumber().split(",");
                    tmpFields = entry.getMemberCombinRef().split(",");
                    if (tmpStrs != null && tmpFields != null && tmpStrs.length == tmpFields.length) {
                        int xn = tmpFields.length;
                        for (int x = 0; x < xn; ++x) {
                            mbgDataMap.put(tmpFields[x], DimUtils.getNumber(tmpStrs[x]));
                        }
                    }
                }
                if (entry.getOrgUnit() != null && !StringUtils.isEmpty((String)entry.getOrgUnit().getNumber())) {
                    mbgDataMap.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, entry.getOrgUnit().getNumber());
                }
                mbgDataMap.put(DimensionBaseConstants.DEF_PERIOD_FIELD, entry.getPeriod().getNumber());
                mbgDatas.add(mbgDataMap);
            }
        }
        return schemaDataMap;
    }

    public static Map<String, Map<String, Map<String, Set<String>>>> parseAdjustBillDimData(List<BgAdjustBillInfo> bgAdjusts) throws BOSException, EASBizException {
        HashMap<String, Map<String, Map<String, Set<String>>>> schemaDataMap = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        if (bgAdjusts == null || bgAdjusts.isEmpty()) {
            return schemaDataMap;
        }
        Map<String, Map<String, Set<String>>> orgDataMap = null;
        Map<String, Set<String>> mbgDataMap = null;
        Set<String> mbgDataSet = null;
        String schemaNum = null;
        String[] tmpStrs = null;
        String[] tmpFields = null;
        BgAdjustBillInfo bgAdjust = null;
        BgAdjustBillEntryInfo entry = null;
        int in = bgAdjusts.size();
        for (int i = 0; i < in; ++i) {
            bgAdjust = bgAdjusts.get(i);
            schemaNum = bgAdjust.getBgScheme().getNumber();
            if (schemaDataMap.containsKey(schemaNum)) {
                orgDataMap = (Map)schemaDataMap.get(schemaNum);
            } else {
                orgDataMap = new HashMap();
                schemaDataMap.put(schemaNum, orgDataMap);
            }
            int jn = bgAdjust.getEntity().size();
            for (int j = 0; j < jn; ++j) {
                entry = bgAdjust.getEntity().get(j);
                if (orgDataMap.containsKey(entry.getOrgUnit().getNumber())) {
                    mbgDataMap = (Map)orgDataMap.get(entry.getOrgUnit().getNumber());
                } else {
                    mbgDataMap = new HashMap();
                    orgDataMap.put(entry.getOrgUnit().getNumber(), mbgDataMap);
                }
                if (mbgDataMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD)) {
                    mbgDataSet = (Set)mbgDataMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD);
                } else {
                    mbgDataSet = new HashSet();
                    mbgDataMap.put(DimensionBaseConstants.DEF_SCENARIO_FIELD, mbgDataSet);
                }
                if (bgAdjust.getBgScenario() != null) {
                    mbgDataSet.add(bgAdjust.getBgScenario().getNumber());
                } else if (entry.getBgScenario() != null && !StringUtils.isEmpty((String)entry.getBgScenario().getNumber())) {
                    mbgDataSet.add(entry.getBgScenario().getNumber());
                }
                if (mbgDataMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                    mbgDataSet = (Set)mbgDataMap.get(DimensionBaseConstants.DEF_VERSION_FIELD);
                } else {
                    mbgDataSet = new HashSet();
                    mbgDataMap.put(DimensionBaseConstants.DEF_VERSION_FIELD, mbgDataSet);
                }
                mbgDataSet.add(bgAdjust.getBgVersion().getNumber());
                if (mbgDataMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                    mbgDataSet = (Set)mbgDataMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD);
                } else {
                    mbgDataSet = new HashSet();
                    mbgDataMap.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, mbgDataSet);
                }
                mbgDataSet.add(bgAdjust.getCurrency().getNumber());
                if (mbgDataMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD)) {
                    mbgDataSet = (Set)mbgDataMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD);
                } else {
                    mbgDataSet = new HashSet();
                    mbgDataMap.put(DimensionBaseConstants.DEF_ELEMENT_FIELD, mbgDataSet);
                }
                if (bgAdjust.getElement() != null) {
                    mbgDataSet.add(bgAdjust.getElement().getNumber());
                } else if (entry.getBgElement() != null && !StringUtils.isEmpty((String)entry.getBgElement().getNumber())) {
                    mbgDataSet.add(entry.getBgElement().getNumber());
                }
                if (mbgDataMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                    mbgDataSet = (Set)mbgDataMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                } else {
                    mbgDataSet = new HashSet();
                    mbgDataMap.put(DimensionBaseConstants.DEF_BGINDEX_FIELD, mbgDataSet);
                }
                mbgDataSet.add(entry.getIndexMemberNumber());
                if (!StringUtils.isEmpty((String)entry.getMemberCombinNumber()) && !StringUtils.isEmpty((String)entry.getMemberCombinRef())) {
                    tmpStrs = entry.getMemberCombinNumber().split(",");
                    tmpFields = entry.getMemberCombinRef().split(",");
                    if (tmpStrs != null && tmpFields != null && tmpStrs.length == tmpFields.length) {
                        int xn = tmpFields.length;
                        for (int x = 0; x < xn; ++x) {
                            if (mbgDataMap.containsKey(tmpFields[x])) {
                                mbgDataSet = (Set)mbgDataMap.get(tmpFields[x]);
                            } else {
                                mbgDataSet = new HashSet();
                                mbgDataMap.put(tmpFields[x], mbgDataSet);
                            }
                            mbgDataSet.add(tmpStrs[x]);
                        }
                    }
                }
                if (mbgDataMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                    mbgDataSet = (Set)mbgDataMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                } else {
                    mbgDataSet = new HashSet();
                    mbgDataMap.put(DimensionBaseConstants.DEF_PERIOD_FIELD, mbgDataSet);
                }
                mbgDataSet.add(entry.getPeriod().getNumber());
            }
        }
        return schemaDataMap;
    }

    public static Map<String, Map<String, Map<String, ICalcData>>> queryAdjustBillValue(Connection conn, Map<String, Map<String, Map<String, Set<String>>>> adjustSchemeMap, int processType) throws BOSException, EASBizException {
        HashMap<String, Map<String, Map<String, ICalcData>>> schemaTmpData = new HashMap<String, Map<String, Map<String, ICalcData>>>();
        if (conn == null || adjustSchemeMap == null) {
            return schemaTmpData;
        }
        String schemeNum = null;
        String orgUnitNum = null;
        Map<String, Map<String, Set<String>>> orgDataMap = null;
        Map orgTmpData = null;
        Map<String, BizCalcData> tmpData = null;
        BizCalcData calcData = null;
        Map.Entry<String, Map<String, Map<String, Set<String>>>> entry2 = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FNumber, t.FFormula, v.FNumber, t.FValue from T_MBG_BgTmpData t left join T_ORG_CostCenter c on t.FOrgUnitId = c.FID left join T_MBG_BgVersion v on t.FVersion = v.FVersionId where t.FProcessType = " + processType + " and t.FBgSchemeRootId IN (select FID from T_MBG_BgScheme where FNumber = ?) and c.FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
        ArrayList<String> firstParams = new ArrayList<String>();
        ArrayList<String> sqlParams = new ArrayList<String>();
        List result = null;
        for (Map.Entry<String, Map<String, Map<String, Set<String>>>> entry2 : adjustSchemeMap.entrySet()) {
            schemeNum = entry2.getKey();
            orgDataMap = entry2.getValue();
            firstParams.clear();
            sqlParams.clear();
            firstParams.add(schemeNum);
            sqlParams.addAll(orgDataMap.keySet());
            if (schemaTmpData.containsKey(schemeNum)) {
                orgTmpData = (Map)schemaTmpData.get(schemeNum);
            } else {
                orgTmpData = new HashMap();
                schemaTmpData.put(schemeNum, orgTmpData);
            }
            try {
                result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), firstParams, sqlParams);
                for (Object[] rst : result) {
                    orgUnitNum = (String)rst[0];
                    calcData = new BizCalcData();
                    calcData.setFormula((String)rst[1]);
                    calcData.setBgVersionNumber((String)rst[2]);
                    calcData.setValue((BigDecimal)rst[3]);
                    if (orgTmpData.containsKey(orgUnitNum)) {
                        tmpData = (Map)orgTmpData.get(orgUnitNum);
                    } else {
                        tmpData = new HashMap();
                        orgTmpData.put(orgUnitNum, tmpData);
                    }
                    tmpData.put(calcData.getDimDataKey1(), calcData);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"query TmpData Error:", (Throwable)ex);
            }
        }
        return schemaTmpData;
    }

    public static void mergeDimData(Map<String, Set<String>> dimNumMap, Map<String, IDimension> mbgDimMap) {
        if (dimNumMap == null || mbgDimMap == null) {
            return;
        }
        IDimension dimension = null;
        Map.Entry<String, IDimension> entry2 = null;
        HashSet<String> dimNumSet = null;
        for (Map.Entry<String, IDimension> entry2 : mbgDimMap.entrySet()) {
            int i;
            int in;
            if (dimNumMap.containsKey(entry2.getKey())) continue;
            dimension = entry2.getValue();
            dimNumSet = new HashSet<String>();
            if (DimUtils.checkBaseDimensionByField(dimension.getField())) {
                in = dimension.getMembers().size();
                for (i = 0; i < in; ++i) {
                    dimNumSet.add(dimension.getMembers().get(i).getNumber());
                }
            } else {
                in = dimension.getMembers().size();
                for (i = 0; i < in; ++i) {
                    dimNumSet.add(dimension.getMembers().get(i).getDimNumber());
                }
            }
            dimNumMap.put(entry2.getKey(), dimNumSet);
        }
    }

    public static void mergeSchemeDimData(Map<String, Map<String, Map<String, ICalcData>>> schemeDimMap, Map<String, Map<String, Map<String, ICalcData>>> mergeDimMap) {
        if (schemeDimMap == null || mergeDimMap == null) {
            return;
        }
        String schemeNum = null;
        String orgUnitNum = null;
        String mbgKey = null;
        Map.Entry<String, Map<String, Map<String, ICalcData>>> entry2 = null;
        Map.Entry<String, Map<String, ICalcData>> oEntry2 = null;
        Map.Entry<String, ICalcData> dEntry2 = null;
        Map<Object, Object> orgDataMap = null;
        Map<String, Map<String, ICalcData>> mergeOrgDataMap = null;
        Map<String, ICalcData> mbgDataMap = null;
        Map<String, ICalcData> mergeMbgDataMap = null;
        ICalcData mbgData = null;
        ICalcData mergeData = null;
        for (Map.Entry<String, Map<String, Map<String, ICalcData>>> entry2 : mergeDimMap.entrySet()) {
            schemeNum = entry2.getKey();
            mergeOrgDataMap = entry2.getValue();
            if (schemeDimMap.containsKey(schemeNum)) {
                orgDataMap = schemeDimMap.get(schemeNum);
            } else {
                orgDataMap = new HashMap();
                schemeDimMap.put(schemeNum, orgDataMap);
            }
            for (Map.Entry<String, Map<String, ICalcData>> oEntry2 : mergeOrgDataMap.entrySet()) {
                orgUnitNum = oEntry2.getKey();
                mergeMbgDataMap = oEntry2.getValue();
                if (orgDataMap.containsKey(orgUnitNum)) {
                    mbgDataMap = (Map)orgDataMap.get(orgUnitNum);
                } else {
                    mbgDataMap = new HashMap();
                    orgDataMap.put(orgUnitNum, mbgDataMap);
                }
                for (Map.Entry<String, ICalcData> dEntry2 : mergeMbgDataMap.entrySet()) {
                    mbgKey = dEntry2.getKey();
                    mergeData = dEntry2.getValue();
                    if (mbgDataMap.containsKey(mbgKey)) {
                        mbgData = (ICalcData)mbgDataMap.get(mbgKey);
                        mbgData.setValue(mergeData.getValue());
                        continue;
                    }
                    mbgDataMap.put(mbgKey, mergeData);
                }
            }
        }
    }

    public static Map<String, Set<String>> getParentMemberMap(Connection conn, BgSchemeInfo bgScheme, Map<String, Set<String>> queryMemberMap, Map<String, MbgDimInfo> mbgDimMap) throws EASBizException {
        HashMap<String, Set<String>> pMbgDataMap = new HashMap<String, Set<String>>();
        if (conn == null || queryMemberMap == null || queryMemberMap.isEmpty()) {
            return pMbgDataMap;
        }
        HashSet<String> querySet = null;
        Set<String> memberSet = null;
        Set<String> values = null;
        Map tmpMap = null;
        Object entry = null;
        Map.Entry<String, Set<String>> qEntry2 = null;
        String field = null;
        String number2 = null;
        String longNumber = null;
        String[] tmpStrs = null;
        for (Map.Entry<String, Set<String>> qEntry2 : queryMemberMap.entrySet()) {
            field = qEntry2.getKey();
            values = qEntry2.getValue();
            querySet = new HashSet<String>();
            for (String num : values) {
                if (num.indexOf(":") > 0) {
                    querySet.add(num.split(":")[1]);
                    continue;
                }
                querySet.add(num);
            }
            if (pMbgDataMap.containsKey(field)) {
                memberSet = (Set)pMbgDataMap.get(field);
            } else {
                memberSet = new HashSet();
                pMbgDataMap.put(field, memberSet);
            }
            tmpMap = BizMemberQuery.querySuperiorMember((Connection)conn, (BgSchemeInfo)bgScheme, (String)field, querySet, mbgDimMap);
            for (String number2 : querySet) {
                if (!tmpMap.containsKey(number2)) continue;
                longNumber = (String)tmpMap.get(number2);
                tmpStrs = longNumber.split("!");
                int in = tmpStrs.length;
                for (int i = 0; i < in; ++i) {
                    memberSet.add(tmpStrs[i]);
                }
            }
        }
        return pMbgDataMap;
    }

    public static Map<String, Set<String>> getParentMemberMap(Connection conn, BgSchemeInfo bgScheme, List<Map<String, String>> mbgDatas, Map<String, MbgDimInfo> mbgDimMap) throws EASBizException {
        HashMap<String, Set<String>> pMbgDataMap = new HashMap<String, Set<String>>();
        if (conn == null || mbgDatas == null || mbgDatas.isEmpty()) {
            return pMbgDataMap;
        }
        HashMap queryMemberMap = new HashMap();
        Set<String> querySet = null;
        Set<String> memberSet = null;
        Map tmpMap = null;
        Map.Entry<String, String> entry2 = null;
        Map.Entry qEntry2 = null;
        String field = null;
        String number2 = null;
        String longNumber = null;
        String[] tmpStrs = null;
        int in = mbgDatas.size();
        for (int i = 0; i < in; ++i) {
            tmpMap = mbgDatas.get(i);
            for (Map.Entry<String, String> entry2 : tmpMap.entrySet()) {
                field = entry2.getKey();
                number2 = DimUtils.getNumber(entry2.getValue());
                if (queryMemberMap.containsKey(field)) {
                    querySet = (Set)queryMemberMap.get(field);
                } else {
                    querySet = new HashSet();
                    queryMemberMap.put(field, querySet);
                }
                querySet.add(number2);
            }
        }
        for (Map.Entry qEntry2 : queryMemberMap.entrySet()) {
            field = (String)qEntry2.getKey();
            querySet = (HashSet)qEntry2.getValue();
            if (pMbgDataMap.containsKey(field)) {
                memberSet = (Set)pMbgDataMap.get(field);
            } else {
                memberSet = new HashSet();
                pMbgDataMap.put(field, memberSet);
            }
            tmpMap = BizMemberQuery.querySuperiorMember((Connection)conn, (BgSchemeInfo)bgScheme, (String)field, querySet, mbgDimMap);
            for (String number2 : querySet) {
                if (!tmpMap.containsKey(number2)) continue;
                longNumber = (String)tmpMap.get(number2);
                tmpStrs = longNumber.split("!");
                int in2 = tmpStrs.length;
                for (int i = 0; i < in2; ++i) {
                    memberSet.add(tmpStrs[i]);
                }
            }
        }
        return pMbgDataMap;
    }

    public static List<String> queryAllExamine(Connection conn, String bgSchemeId, String orgTreeId) throws BOSException, EASBizException {
        ArrayList<String> examineIds = new ArrayList<String>();
        if (conn == null || StringUtils.isEmpty((String)bgSchemeId)) {
            return examineIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_MBG_BgExamine where FBgSchemeId = ? and FState = 1");
        if (orgTreeId != null) {
            sql.append(" and FOrgTreeID  = ?");
        } else {
            sql.append(" and FOrgTreeID  IS NULL");
        }
        IRowSet rst = null;
        try {
            rst = orgTreeId != null ? BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId, orgTreeId}) : BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId});
            while (rst.next()) {
                examineIds.add(rst.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryAllExamine sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return examineIds;
    }

    public static List<BgExamineInfo> queryExamine(Context ctx, Connection conn, TempTablePool pool, Map<String, Set<String>> examineMap) throws BOSException, EASBizException {
        ArrayList<BgExamineInfo> examines = new ArrayList<BgExamineInfo>();
        if (conn == null || pool == null || examineMap == null || examineMap.isEmpty()) {
            return examines;
        }
        HashSet<String> _examineIds = new HashSet<String>();
        Iterator<Set<String>> iter = examineMap.values().iterator();
        while (iter.hasNext()) {
            _examineIds.addAll((Collection)iter.next());
        }
        return MBgExamineUtils.queryExamine(ctx, conn, pool, _examineIds, null);
    }

    public static List<BgExamineInfo> queryExamine(Context ctx, Connection conn, TempTablePool pool, Collection<String> examineIds, Map<String, BgExamineInfo> examineMap) throws BOSException, EASBizException {
        ArrayList<BgExamineInfo> examines = new ArrayList<BgExamineInfo>();
        if (conn == null || pool == null || examineIds == null || examineIds.isEmpty()) {
            return examines;
        }
        String tmpTableName = null;
        StringBuffer sql = null;
        BgExamineInfo examine = null;
        BgScopeInfo scopeInfo = null;
        BgExamineSubsetInfo subsetInfo = null;
        HashSet<String> _ids = new HashSet<String>(examineIds);
        if (examineMap != null && !examineMap.isEmpty()) {
            _ids.removeAll(examineMap.keySet());
        }
        HashMap<String, BgExamineInfo> _examineMap = new HashMap<String, BgExamineInfo>();
        HashMap<String, BgExamineSubsetInfo> subMap = new HashMap<String, BgExamineSubsetInfo>();
        String bgExamineId = null;
        String subsetId = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            tmpTableName = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
            if (tmpTableName == null) {
                ArrayList<BgExamineInfo> arrayList = examines;
                return arrayList;
            }
            if (!_ids.isEmpty()) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FID) values (?)"), _ids);
                sql = new StringBuffer();
                sql.append("select t.FID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FNoPass, sub.FID AS SUBID, sub.FBgExamineID, sub.FFormula, sub.FHint_" + ctx.getLocale() + " AS FHint, sub.FErrorData, sub.FName_" + ctx.getLocale() + " AS FSubsetName , sub.FSeq, s.FID AS SOID, s.FBgExamineSubSetID, s.FBgMemberNum, s.FBgMemberType, s.FBizDataType, s.FRefField, s.FFillType from T_MBG_BgExamine t left join T_MBG_BgExamineSubset sub on t.FID = sub.FBgExamineID left join T_MBG_BgScope s on sub.FID = s.FBgExamineSubSetID where exists (select FID from " + tmpTableName + " where FID = t.FID) ");
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgExamineId = rst.getString("FID");
                    if (_examineMap.containsKey(bgExamineId)) {
                        examine = (BgExamineInfo)_examineMap.get(bgExamineId);
                    } else {
                        examine = new BgExamineInfo();
                        examine.setId(BOSUuid.read((String)bgExamineId));
                        examine.setNumber(rst.getString("FNumber"));
                        examine.setName(rst.getString("FName"));
                        examine.setNoPass(BgExamineNoPassEnum.getEnum(rst.getInt("FNoPass")));
                        examines.add(examine);
                        _examineMap.put(rst.getString("FID"), examine);
                    }
                    subsetId = rst.getString("SUBID");
                    if (subMap.containsKey(subsetId)) {
                        subsetInfo = (BgExamineSubsetInfo)subMap.get(subsetId);
                    } else {
                        subsetInfo = new BgExamineSubsetInfo();
                        subsetInfo.setId(BOSUuid.read((String)subsetId));
                        subsetInfo.setFormula(BgDBUtils.getBytes((ResultSet)rst, (String)"FFormula"));
                        subsetInfo.setHint(rst.getString("FHint"));
                        subsetInfo.setErrorData(rst.getBigDecimal("FErrorData"));
                        subsetInfo.setName(rst.getString("FSubsetName"));
                        subsetInfo.setSeq(rst.getInt("FSeq"));
                        subsetInfo.setBgExamine(examine);
                        subMap.put(subsetId, subsetInfo);
                        examine.getBgExamineSubset().add(subsetInfo);
                    }
                    if (!subMap.containsKey(subsetId = rst.getString("FBgExamineSubSetID"))) continue;
                    subsetInfo = (BgExamineSubsetInfo)subMap.get(subsetId);
                    scopeInfo = new BgScopeInfo();
                    scopeInfo.setId(BOSUuid.read((String)rst.getString("SOID")));
                    scopeInfo.setBgMemberNum(rst.getString("FBgMemberNum"));
                    scopeInfo.setBgMemberType(rst.getInt("FBgMemberType"));
                    scopeInfo.setBizDataType(BgMemberSelectTypeEnum.getEnum(rst.getInt("FBizDataType")));
                    scopeInfo.setRefField(rst.getString("FRefField"));
                    scopeInfo.setFillType(DimensionMemberTypeEnum.getEnum(rst.getInt("FFillType")));
                    scopeInfo.setBgExamineSubset(subsetInfo);
                    subsetInfo.getBgScope().add(scopeInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"queryExamine error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
            if (tmpTableName != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpTableName, conn);
                }
                catch (Exception exception) {}
            }
        }
        if (examineMap != null && !examineMap.isEmpty()) {
            for (String examineId : examineIds) {
                if (!examineMap.containsKey(examineId)) continue;
                examine = examineMap.get(examineId);
                examines.add(examine);
            }
        }
        return examines;
    }

    public static BOSUuid[] queryRefBgTemplateIds(Connection conn, List<String> examineIds) throws EASBizException {
        if (conn == null || examineIds == null || examineIds.isEmpty()) {
            return null;
        }
        ArrayList<String> _examineIds = new ArrayList<String>();
        _examineIds.addAll(examineIds);
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgTemplateID from T_MBG_BgExamineRefBgTemplate where FBgExamineID IN (" + BgDBUtils.getSqlParam((int)50) + ")");
        List result = null;
        HashSet<String> bgTempalteSet = new HashSet<String>();
        BOSUuid[] bgTemplateIds = null;
        try {
            result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), _examineIds);
            if (result != null && !result.isEmpty()) {
                for (Object[] obj : result) {
                    bgTempalteSet.add((String)obj[0]);
                }
                int index = 0;
                bgTemplateIds = new BOSUuid[bgTempalteSet.size()];
                for (String bgTemplateId : bgTempalteSet) {
                    bgTemplateIds[index++] = BOSUuid.read((String)bgTemplateId);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"queryRefBgTemplateIds sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return bgTemplateIds;
    }

    public static Map<String, Set<String>> getMbgExamRefMap(Map<String, Set<String>> examineMap) {
        HashMap<String, Set<String>> examRefMap = new HashMap<String, Set<String>>();
        Set<String> billIds = null;
        Map.Entry<String, Set<String>> entry2 = null;
        for (Map.Entry<String, Set<String>> entry2 : examineMap.entrySet()) {
            for (String examineId : entry2.getValue()) {
                if (examRefMap.containsKey(examineId)) {
                    billIds = (Set)examRefMap.get(examineId);
                } else {
                    billIds = new HashSet();
                    examRefMap.put(examineId, billIds);
                }
                billIds.add(entry2.getKey());
            }
        }
        return examRefMap;
    }

    public static Map<String, List<IDimDataQuery>> getOrgFormMap(List<IDimDataQuery> billValues) {
        HashMap<String, List<IDimDataQuery>> orgModelMap = new HashMap<String, List<IDimDataQuery>>();
        if (billValues == null || billValues.isEmpty()) {
            return orgModelMap;
        }
        String orgUnitId = null;
        List<IDimDataQuery> bills = null;
        for (IDimDataQuery model : billValues) {
            orgUnitId = model.getBizOrgUnit().getId().toString();
            if (orgModelMap.containsKey(orgUnitId)) {
                bills = (List)orgModelMap.get(orgUnitId);
            } else {
                bills = new ArrayList();
                orgModelMap.put(orgUnitId, bills);
            }
            bills.add(model);
        }
        return orgModelMap;
    }

    public static void getUnionDimField(IExpress expr, Set<String> unionFields, Map<String, String> srcFieldMap) {
        if (unionFields == null || srcFieldMap == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            MBgExamineUtils.getUnionDimField((BinaryExpr)expr, unionFields, srcFieldMap);
        }
    }

    public static void getUnionDimField(BinaryExpr expr, Set<String> unionFields, Map<String, String> srcFieldMap) {
        if (expr == null || unionFields == null || srcFieldMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            MBgExamineUtils.getUnionDimField((BinaryExpr)expr.left, unionFields, srcFieldMap);
        } else if (expr.left instanceof MdxMemberExpr) {
            MBgExamineUtils.getUnionDimField((MdxMemberExpr)expr.left, unionFields, srcFieldMap);
        } else if (expr.left instanceof VariateExpr) {
            MBgExamineUtils.getUnionDimField((VariateExpr)expr.left, unionFields, srcFieldMap);
        }
        if (expr.right instanceof BinaryExpr) {
            MBgExamineUtils.getUnionDimField((BinaryExpr)expr.right, unionFields, srcFieldMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            MBgExamineUtils.getUnionDimField((MdxMemberExpr)expr.right, unionFields, srcFieldMap);
        } else if (expr.right instanceof VariateExpr) {
            MBgExamineUtils.getUnionDimField((VariateExpr)expr.right, unionFields, srcFieldMap);
        }
    }

    public static void getUnionDimField(VariateExpr expr, Set<String> unionFields, Map<String, String> srcFieldMap) {
        if (expr == null || unionFields == null || srcFieldMap == null) {
            return;
        }
        if (expr.expr instanceof MdxMemberExpr) {
            MBgExamineUtils.getUnionDimField(expr.expr, unionFields, srcFieldMap);
        }
    }

    public static void getUnionDimField(MdxMemberExpr expr, Set<String> unionFields, Map<String, String> srcFieldMap) {
        if (expr == null || unionFields == null || srcFieldMap == null) {
            return;
        }
        for (IExpress _expr : expr.params) {
            if (!(_expr instanceof MemberExpr) || DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)_expr).srcNumber)) continue;
            if (((MemberExpr)_expr).field == null) {
                ((MemberExpr)_expr).field = srcFieldMap.get(((MemberExpr)_expr).srcNumber);
            }
            unionFields.add(((MemberExpr)_expr).field);
        }
    }

    public static Map<String, Set<String>> getDimNumMap(BgScopeCollection scopes, Map<String, String> srcFieldMap) {
        HashMap<String, Set<String>> dimNumMap = new HashMap<String, Set<String>>();
        if (scopes == null || scopes.isEmpty() || srcFieldMap == null) {
            return dimNumMap;
        }
        String dimNumber = null;
        String srcNumber = null;
        String field = null;
        BgScopeInfo scope = null;
        Set<String> dimNumSet = null;
        int in = scopes.size();
        for (int i = 0; i < in; ++i) {
            scope = scopes.get(i);
            dimNumber = scope.getBgMemberNum();
            srcNumber = DimUtils.getSrcNumber(dimNumber);
            field = srcFieldMap.get(srcNumber);
            if (dimNumMap.containsKey(field)) {
                dimNumSet = (Set)dimNumMap.get(field);
            } else {
                dimNumSet = new HashSet();
                dimNumMap.put(field, dimNumSet);
            }
            dimNumSet.add(dimNumber);
        }
        return dimNumMap;
    }

    public static void putDimNumber(String schemeNum, String orgUnitNum, IExpress expr, BgScopeCollection scopes, Map<String, Map<String, Map<String, Set<String>>>> scriptDimMap, Map<String, String> srcFieldMap) {
        if (schemeNum == null || orgUnitNum == null || expr == null || scriptDimMap == null || srcFieldMap == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            MBgExamineUtils.putDimNumber(schemeNum, orgUnitNum, (BinaryExpr)expr, scopes, scriptDimMap, srcFieldMap);
        }
    }

    public static void putDimNumber(String schemeNum, String orgUnitNum, BinaryExpr expr, BgScopeCollection scopes, Map<String, Map<String, Map<String, Set<String>>>> scriptDimMap, Map<String, String> srcFieldMap) {
        if (schemeNum == null || orgUnitNum == null || expr == null || scriptDimMap == null || srcFieldMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            MBgExamineUtils.putDimNumber(schemeNum, orgUnitNum, (BinaryExpr)expr.left, scopes, scriptDimMap, srcFieldMap);
        } else if (expr.left instanceof MdxMemberExpr) {
            MBgExamineUtils.putDimNumber(schemeNum, orgUnitNum, (MdxMemberExpr)expr.left, scopes, scriptDimMap, srcFieldMap);
        }
        if (expr.right instanceof BinaryExpr) {
            MBgExamineUtils.putDimNumber(schemeNum, orgUnitNum, (BinaryExpr)expr.right, scopes, scriptDimMap, srcFieldMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            MBgExamineUtils.putDimNumber(schemeNum, orgUnitNum, (MdxMemberExpr)expr.right, scopes, scriptDimMap, srcFieldMap);
        }
    }

    public static void putDimNumber(String schemeNum, String orgUnitNum, MdxMemberExpr expr, BgScopeCollection scopes, Map<String, Map<String, Map<String, Set<String>>>> scriptDimMap, Map<String, String> srcFieldMap) {
        String orgUnitNumber;
        if (schemeNum == null || orgUnitNum == null || expr == null || scriptDimMap == null || srcFieldMap == null) {
            return;
        }
        MemberExpr schemeExpr = null;
        MemberExpr orgUnitExpr = null;
        for (IExpress _expr : expr.params) {
            if (!(_expr instanceof MemberExpr)) continue;
            if (DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)_expr).srcNumber)) {
                schemeExpr = (MemberExpr)_expr;
                continue;
            }
            if (!DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER.equals(((MemberExpr)_expr).srcNumber)) continue;
            orgUnitExpr = (MemberExpr)_expr;
        }
        String schemeNumber = schemeExpr != null ? schemeExpr.number : schemeNum;
        String string = orgUnitNumber = orgUnitExpr != null ? orgUnitExpr.number : orgUnitNum;
        if (scopes != null) {
            String dimNumber = null;
            String srcNumber = null;
            String field = null;
            BgScopeInfo scope = null;
            int in = scopes.size();
            for (int i = 0; i < in; ++i) {
                scope = scopes.get(i);
                dimNumber = scope.getBgMemberNum();
                srcNumber = DimUtils.getSrcNumber(dimNumber);
                field = srcFieldMap.get(srcNumber);
                MBgExamineUtils.putDimNumber(schemeNumber, orgUnitNumber, field, srcNumber, dimNumber, scriptDimMap);
            }
        }
        for (IExpress _expr : expr.params) {
            if (!(_expr instanceof MemberExpr) || DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)_expr).srcNumber)) continue;
            if (((MemberExpr)_expr).field == null) {
                ((MemberExpr)_expr).field = srcFieldMap.get(((MemberExpr)_expr).srcNumber);
            }
            MBgExamineUtils.putDimNumber(schemeNumber, orgUnitNumber, ((MemberExpr)_expr).field, ((MemberExpr)_expr).srcNumber, ((MemberExpr)_expr).number, scriptDimMap);
        }
    }

    public static void putDimNumber(String schemeNumber, String orgUnitNumber, String field, String srcNumber, String number, Map<String, Map<String, Map<String, Set<String>>>> schemeData) {
        if (schemeNumber == null || field == null || srcNumber == null || number == null || schemeData == null) {
            return;
        }
        if (DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(srcNumber)) {
            return;
        }
        Map<Object, Object> orgDimMap = null;
        Map dimNumMap = null;
        Set<String> dimNumSet = null;
        if (schemeData.containsKey(schemeNumber)) {
            orgDimMap = schemeData.get(schemeNumber);
        } else {
            orgDimMap = new HashMap();
            schemeData.put(schemeNumber, orgDimMap);
        }
        if (orgDimMap.containsKey(orgUnitNumber)) {
            dimNumMap = (Map)orgDimMap.get(orgUnitNumber);
        } else {
            dimNumMap = new HashMap();
            orgDimMap.put(orgUnitNumber, dimNumMap);
        }
        if (dimNumMap.containsKey(field)) {
            dimNumSet = (Set)dimNumMap.get(field);
        } else {
            dimNumSet = new HashSet();
            dimNumMap.put(field, dimNumSet);
        }
        if (DimUtils.checkBaseDimensionByField(field)) {
            dimNumSet.add(number);
        } else {
            dimNumSet.add(DimUtils.getDimNumber(srcNumber, number));
        }
    }

    public static void putDimNumber(String schemeNumber, String orgUnitNumber, String field, Set<String> dimNumbers, Map<String, Map<String, Map<String, Set<String>>>> schemeData) {
        if (schemeNumber == null || field == null || dimNumbers == null || dimNumbers.isEmpty() || schemeData == null) {
            return;
        }
        Map<Object, Object> orgDimMap = null;
        Map dimNumMap = null;
        Set<String> dimNumSet = null;
        if (schemeData.containsKey(schemeNumber)) {
            orgDimMap = schemeData.get(schemeNumber);
        } else {
            orgDimMap = new HashMap();
            schemeData.put(schemeNumber, orgDimMap);
        }
        if (orgDimMap.containsKey(orgUnitNumber)) {
            dimNumMap = (Map)orgDimMap.get(orgUnitNumber);
        } else {
            dimNumMap = new HashMap();
            orgDimMap.put(orgUnitNumber, dimNumMap);
        }
        if (dimNumMap.containsKey(field)) {
            dimNumSet = (Set)dimNumMap.get(field);
        } else {
            dimNumSet = new HashSet();
            dimNumMap.put(field, dimNumSet);
        }
        dimNumSet.addAll(dimNumbers);
    }

    public static void putDimNumber(String field, String srcNumber, String number, Map<String, Set<String>> dimNumMap, Map<String, String> srcFieldMap) {
        if (field == null || srcNumber == null || number == null || dimNumMap == null || srcFieldMap == null) {
            return;
        }
        if (DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(srcNumber)) {
            return;
        }
        Set<Object> dimNumSet = null;
        if (dimNumMap.containsKey(field)) {
            dimNumSet = dimNumMap.get(field);
        } else {
            dimNumSet = new HashSet();
            dimNumMap.put(field, dimNumSet);
        }
        if (DimUtils.checkBaseDimensionByField(field)) {
            dimNumSet.add(number);
        } else if (number.indexOf(":") > 0) {
            dimNumSet.add(number);
        } else {
            dimNumSet.add(DimUtils.getDimNumber(srcNumber, number));
        }
    }

    public static boolean checkExpr(IExpress expr, Map<String, Set<String>> mbgDataMap, Map<String, String> srcFieldMap) {
        boolean re = false;
        if (expr == null || mbgDataMap == null || mbgDataMap.isEmpty()) {
            return re;
        }
        if (expr instanceof BinaryExpr) {
            re = MBgExamineUtils.checkExpr((BinaryExpr)expr, mbgDataMap, srcFieldMap);
        }
        return re;
    }

    public static boolean checkExpr(BinaryExpr expr, Map<String, Set<String>> mbgDataMap, Map<String, String> srcFieldMap) {
        boolean re = false;
        if (expr == null || mbgDataMap == null || mbgDataMap.isEmpty()) {
            return re;
        }
        if (expr.left instanceof MdxMemberExpr) {
            re = MBgExamineUtils.checkExpr((MdxMemberExpr)expr.left, mbgDataMap, srcFieldMap);
        } else if (expr.left instanceof BinaryExpr) {
            re = MBgExamineUtils.checkExpr((BinaryExpr)expr.left, mbgDataMap, srcFieldMap);
        } else if (expr.left instanceof VariateExpr) {
            re = MBgExamineUtils.checkExpr((VariateExpr)expr.left, mbgDataMap, srcFieldMap);
        }
        if (!re) {
            if (expr.right instanceof MdxMemberExpr) {
                re = MBgExamineUtils.checkExpr((MdxMemberExpr)expr.right, mbgDataMap, srcFieldMap);
            } else if (expr.right instanceof BinaryExpr) {
                re = MBgExamineUtils.checkExpr((BinaryExpr)expr.right, mbgDataMap, srcFieldMap);
            } else if (expr.right instanceof VariateExpr) {
                re = MBgExamineUtils.checkExpr((VariateExpr)expr.right, mbgDataMap, srcFieldMap);
            }
        }
        return re;
    }

    public static boolean checkExpr(VariateExpr expr, Map<String, Set<String>> mbgDataMap, Map<String, String> srcFieldMap) {
        boolean re = false;
        if (expr == null || mbgDataMap == null || expr.expr == null) {
            return re;
        }
        return MBgExamineUtils.checkExpr(expr.expr, mbgDataMap, srcFieldMap);
    }

    public static boolean checkExpr(MdxMemberExpr expr, Map<String, Set<String>> mbgDataMap, Map<String, String> srcFieldMap) {
        int i;
        boolean re = false;
        if (expr == null || mbgDataMap == null || mbgDataMap == null || mbgDataMap.isEmpty()) {
            return re;
        }
        IExpress _expr = null;
        MemberExpr memberExpr = null;
        String number = null;
        Set<String> tmpSet = null;
        int in = expr.params.size();
        for (i = 0; i < in; ++i) {
            _expr = (IExpress)expr.params.get(i);
            if (!(_expr instanceof MemberExpr)) continue;
            memberExpr = (MemberExpr)_expr;
            if (memberExpr.field == null) {
                memberExpr.field = srcFieldMap.get(memberExpr.srcNumber);
            }
            if (!mbgDataMap.containsKey(memberExpr.field)) continue;
            number = memberExpr.number;
            tmpSet = mbgDataMap.get(memberExpr.field);
            if (memberExpr.field.equals(DimensionBaseConstants.DEF_BGINDEX_FIELD) && !tmpSet.contains(number)) {
                return false;
            }
            if (memberExpr.field.equals(DimensionBaseConstants.DEF_CURRENCY_FIELD) && !tmpSet.contains(number)) {
                return false;
            }
            if (!memberExpr.field.equals(DimensionBaseConstants.DEF_PERIOD_FIELD) || tmpSet.contains(number)) continue;
            return false;
        }
        in = expr.params.size();
        for (i = 0; i < in; ++i) {
            _expr = (IExpress)expr.params.get(i);
            if (!(_expr instanceof MemberExpr)) continue;
            memberExpr = (MemberExpr)_expr;
            if (memberExpr.field == null) {
                memberExpr.field = srcFieldMap.get(memberExpr.srcNumber);
            }
            if (!StringUtils.isEmpty((String)memberExpr.field) && memberExpr.field.equals(DimensionConstants.DEF_PROCESS_FIELD)) {
                re = true;
            }
            if (!mbgDataMap.containsKey(memberExpr.field)) continue;
            number = memberExpr.number;
            tmpSet = mbgDataMap.get(memberExpr.field);
            if (!tmpSet.contains(number)) continue;
            re = true;
            break;
        }
        return re;
    }

    public static boolean checkScope(Context ctx, BgExamineSubsetInfo subsetInfo, MbgDimCollection mbgDims, BgSchemeInfo schemeInfo, BOSUuid unionId, Map<String, Set<String>> mbgDataMap, Map<String, String> variateMap) throws Exception {
        boolean re = false;
        if (subsetInfo == null || mbgDataMap == null || variateMap == null) {
            return re;
        }
        Map<String, Set<String>> scopeMap = subsetInfo.getScopeData(ctx, schemeInfo, schemeInfo.getEditOrgViewId(), unionId, mbgDims, variateMap);
        if (scopeMap != null && !scopeMap.isEmpty()) {
            Map.Entry<String, Set<String>> entry2 = null;
            String field = null;
            Set<String> scopeSet = null;
            HashSet<String> tmpScope = null;
            Set<String> memberSet = null;
            HashSet<String> scopeNumberSet = null;
            for (Map.Entry<String, Set<String>> entry2 : scopeMap.entrySet()) {
                field = entry2.getKey();
                scopeSet = entry2.getValue();
                if (scopeSet.isEmpty()) continue;
                scopeNumberSet = new HashSet<String>();
                for (String str : scopeSet) {
                    if (str.indexOf(":") > 0) {
                        scopeNumberSet.add(str.split(":")[1]);
                        continue;
                    }
                    scopeNumberSet.add(str);
                }
                if (!mbgDataMap.containsKey(field)) continue;
                memberSet = mbgDataMap.get(field);
                tmpScope = new HashSet<String>(scopeNumberSet.size());
                tmpScope.addAll(scopeNumberSet);
                tmpScope.retainAll(memberSet);
                if (tmpScope.isEmpty()) continue;
                re = true;
                break;
            }
        } else {
            re = true;
        }
        return re;
    }

    public static Map<String, Map<String, Set<String>>> parseFormDimData(Context ctx, BgSchemeInfo schemeInfo, List<IDimDataQuery> billValues, Map<String, String> srcFieldMap, BgExamineResult result) throws Exception {
        HashMap<String, Map<String, Set<String>>> formDataMap = new HashMap<String, Map<String, Set<String>>>();
        if (ctx == null || schemeInfo == null || billValues == null || billValues.isEmpty() || result == null) {
            return formDataMap;
        }
        Map<String, Set<String>> formDimMap = null;
        Set<String> dimNumSet = null;
        Map<String, Map<String, String[]>> dimDataInfoMap = result.dimDataInfoMap;
        Map<Object, Object> dataInfoMap = null;
        IMbgViewBase view = null;
        IBgDimensionManagerBase manager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        String field = null;
        String billId = null;
        String[] tmpStrs = null;
        for (IDimDataQuery model : billValues) {
            Map<String, String[]> spMbgDimMap;
            view = model.getView(ctx, schemeInfo);
            if (view == null) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"view"});
            }
            billId = model.getId().toString();
            if (formDataMap.containsKey(billId)) {
                formDimMap = (Map)formDataMap.get(billId);
            } else {
                formDimMap = new HashMap();
                formDataMap.put(billId, formDimMap);
            }
            int periodType = model.getBizPeriod().getPeriodType().getValue();
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = view.getSheetManagers().get(i).getDimensionManager();
                    if (manager == null) continue;
                    if (manager instanceof MbgViewListDimensionManager) {
                        HashSet<String> rowColDimNumbers = new HashSet<String>();
                        List<IMbgViewListObject> rowCols = ((MbgViewListDimensionManager)manager).getRowCols();
                        for (int x = 0; x < rowCols.size(); ++x) {
                            if (!(rowCols.get(x) instanceof MbgViewListRowCol)) continue;
                            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rowCols.get(x);
                            for (MbgViewListDimensionInfo dim : rowColObj.getDimensions()) {
                                rowColDimNumbers.add(dim.getNumber());
                            }
                        }
                        for (int j = 0; j < manager.getDimension().size(); ++j) {
                            if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo) || !rowColDimNumbers.contains((dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j)).getNumber())) continue;
                            dimInfo.getMember().clear();
                        }
                        DimUtils.transMbgDimMember((MbgViewListDimensionManager)manager);
                    }
                    for (int j = 0; j < manager.getDimension().size(); ++j) {
                        int x;
                        int xn;
                        if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo) || DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j)).getNumber())) continue;
                        if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimInfo.getNumber())) {
                            if (dimInfo.getMember().isEmpty()) {
                                member = new BgDimensionMember(DimensionConstants.DEF_VERSION_NUMBER, DimensionBaseConstants.DEF_VERSION_FIELD, model.getBizVersion().getName(), model.getBizVersion().getNumber());
                                dimInfo.getMember().add(member);
                            }
                        } else if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimInfo.getNumber())) {
                            if (dimInfo.getMember().isEmpty()) {
                                member = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionBaseConstants.DEF_PERIOD_FIELD, model.getBizPeriod().getName(), model.getBizPeriod().getNumber());
                                dimInfo.getMember().add(member);
                            }
                        } else if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(dimInfo.getNumber()) && dimInfo.getMember().isEmpty()) {
                            member = new BgDimensionMember(DimensionConstants.DEF_CURRENCY_NUMBER, DimensionBaseConstants.DEF_CURRENCY_FIELD, model.getBizCurrency().getName(), model.getBizCurrency().getNumber());
                            dimInfo.getMember().add(member);
                        }
                        if (formDimMap.containsKey(field = DimUtils.getDimensionField(dimInfo))) {
                            dimNumSet = (Set)formDimMap.get(field);
                        } else {
                            dimNumSet = new HashSet();
                            formDimMap.put(field, dimNumSet);
                        }
                        if (dimDataInfoMap.containsKey(field)) {
                            dataInfoMap = dimDataInfoMap.get(field);
                        } else {
                            dataInfoMap = new HashMap();
                            dimDataInfoMap.put(field, dataInfoMap);
                        }
                        List memList = dimInfo.getMember();
                        if (memList == null || memList.isEmpty()) continue;
                        BgDimensionMember dimensionMember = null;
                        if (DimUtils.checkBaseDimension(dimInfo)) {
                            xn = memList.size();
                            for (x = 0; x < xn; ++x) {
                                dimensionMember = (BgDimensionMember)memList.get(x);
                                tmpStrs = new String[]{dimensionMember.getNumber(), dimensionMember.getName()};
                                if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimInfo.getNumber())) {
                                    tmpStrs[0] = BgPeriodNVariableHelper.getBgPeriodByN((String)model.getBizPeriod().getNumber(), (String)dimensionMember.getNumber(), (int)periodType);
                                }
                                dimNumSet.add(tmpStrs[0]);
                                dataInfoMap.put(tmpStrs[0], tmpStrs);
                            }
                            continue;
                        }
                        xn = memList.size();
                        for (x = 0; x < xn; ++x) {
                            dimensionMember = (BgDimensionMember)memList.get(x);
                            tmpStrs = new String[]{DimUtils.getDimNumber(dimensionMember.getSrcNumber(), dimensionMember.getNumber()), dimensionMember.getName()};
                            dimNumSet.add(tmpStrs[0]);
                            dataInfoMap.put(tmpStrs[0], tmpStrs);
                        }
                    }
                }
            }
            if ((spMbgDimMap = model.getSpItems(srcFieldMap)) != null && !spMbgDimMap.isEmpty()) {
                Map.Entry<String, String[]> entry2 = null;
                for (Map.Entry<String, String[]> entry2 : spMbgDimMap.entrySet()) {
                    field = entry2.getKey();
                    tmpStrs = entry2.getValue();
                    if (formDimMap.containsKey(field)) {
                        dimNumSet = (Set)formDimMap.get(field);
                    } else {
                        dimNumSet = new HashSet();
                        formDimMap.put(field, dimNumSet);
                    }
                    if (dimDataInfoMap.containsKey(field)) {
                        dataInfoMap = dimDataInfoMap.get(field);
                    } else {
                        dataInfoMap = new HashMap();
                        dimDataInfoMap.put(field, dataInfoMap);
                    }
                    if (DimUtils.checkBaseDimensionByField(field) && tmpStrs[0].indexOf(":") > 0) {
                        dimNumSet.add(DimensionFormulaHelper.getMemberNumber(tmpStrs[0]));
                        dataInfoMap.put(DimensionFormulaHelper.getMemberNumber(tmpStrs[0]), tmpStrs);
                        continue;
                    }
                    dimNumSet.add(tmpStrs[0]);
                    dataInfoMap.put(tmpStrs[0], tmpStrs);
                }
            }
            if ((dimNumSet = (HashSet<String>)formDimMap.get(DimensionBaseConstants.DEF_VERSION_FIELD)) == null) {
                dimNumSet = new HashSet<String>();
            }
            dimNumSet.clear();
            dimNumSet.add(model.getBizVersion().getNumber());
        }
        return formDataMap;
    }

    public static Map<BOSUuid, Map<String, Map<String, Map<String, Map<String, Set<String>>>>>> parseExamineDimData(String schemeNum, List<BgExamineInfo> examines, Map<String, String> srcFieldMap) throws ParseException {
        HashMap<BOSUuid, Map<String, Map<String, Map<String, Map<String, Set<String>>>>>> checkDimMap = new HashMap<BOSUuid, Map<String, Map<String, Map<String, Map<String, Set<String>>>>>>();
        if (examines == null) {
            return checkDimMap;
        }
        BgExamineInfo examine = null;
        BgScopeCollection scopes = null;
        List<IExpress> expres = null;
        IExpress expr = null;
        String exprStr = null;
        Map<String, HashMap<String, Map<String, Map<String, Set<String>>>>> examDimMap = null;
        HashMap<String, Map<String, Map<String, Set<String>>>> scriptDimMap = null;
        BgExamineSubsetInfo subsetInfo = null;
        int in = examines.size();
        for (int i = 0; i < in; ++i) {
            examine = examines.get(i);
            for (int index = 0; index < examine.getBgExamineSubset().size(); ++index) {
                subsetInfo = examine.getBgExamineSubset().get(index);
                if (checkDimMap.containsKey(examine.getId())) {
                    examDimMap = (Map)checkDimMap.get(examine.getId());
                } else {
                    examDimMap = new HashMap();
                    checkDimMap.put(examine.getId(), examDimMap);
                }
                scopes = subsetInfo.getBgScope();
                expres = subsetInfo.getExpres();
                if (expres == null) continue;
                int jn = expres.size();
                for (int j = 0; j < jn; ++j) {
                    expr = expres.get(j);
                    exprStr = expr.toString();
                    if (examDimMap.containsKey(exprStr)) {
                        scriptDimMap = (Map)examDimMap.get(exprStr);
                    } else {
                        scriptDimMap = new HashMap();
                        examDimMap.put(exprStr, scriptDimMap);
                    }
                    MBgExamineUtils.putDimNumber(schemeNum, DEFAULT_ORGUNIT_NUMBER, expr, scopes, scriptDimMap, srcFieldMap);
                }
            }
        }
        return checkDimMap;
    }

    public static void addMbgMember(IQueryData queryData, Map<String, Set<String>> dimNumMap, Map<String, MbgDimInfo> mbgDimMap, boolean rechecking) {
        if (queryData == null || dimNumMap == null) {
            return;
        }
        String field = null;
        String[] tmpStrs = null;
        MbgDimInfo mbgDim = null;
        IDimension mbgDimen = null;
        Member mbgMember = null;
        Map.Entry<String, Set<String>> entry2 = null;
        Set<String> dimNumSet = null;
        for (Map.Entry<String, Set<String>> entry2 : dimNumMap.entrySet()) {
            field = entry2.getKey();
            if (DimensionBaseConstants.DEF_PROCESS_FIELD.equals(field) || rechecking && queryData.getMbgDimMap().containsKey(field)) continue;
            mbgDim = mbgDimMap.get(field);
            dimNumSet = entry2.getValue();
            if (queryData.getMbgDimMap().containsKey(field)) {
                mbgDimen = queryData.getMbgDimMap().get(field);
            } else {
                mbgDimen = new Dimension();
                mbgDimen.setNumber(mbgDim.getNumber());
                mbgDimen.setSrcNumber(mbgDim.getSrcNumber());
                mbgDimen.setField(entry2.getKey());
                queryData.getMbgDimMap().put(field, mbgDimen);
            }
            if (DimUtils.checkBaseDimensionByField(field)) {
                for (String number : dimNumSet) {
                    mbgMember = new Member();
                    mbgMember.setNumber(number);
                    mbgMember.setDimNumber(number);
                    mbgDimen.addMember(mbgMember);
                }
                continue;
            }
            for (String dimNumber : dimNumSet) {
                tmpStrs = dimNumber.split(":");
                mbgMember = new Member();
                mbgMember.setNumber(tmpStrs[1]);
                mbgMember.setSrcNumber(mbgDim.getSrcNumber());
                mbgMember.setDimNumber(dimNumber);
                mbgDimen.addMember(mbgMember);
            }
        }
    }

    public static void addMbgMember1(IQueryData queryData, Map<String, Set<String>> dimNumMap, Map<String, MbgDimInfo> mbgDimMap) {
        if (queryData == null || dimNumMap == null || mbgDimMap == null) {
            return;
        }
        String field = null;
        String[] tmpStrs = null;
        MbgDimInfo mbgDim = null;
        IDimension mbgDimen = null;
        Member mbgMember = null;
        Map.Entry<String, Set<String>> entry2 = null;
        Set<String> dimNumSet = null;
        for (Map.Entry<String, Set<String>> entry2 : dimNumMap.entrySet()) {
            field = entry2.getKey();
            if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field) || DimensionBaseConstants.DEF_PROCESS_FIELD.equals(field)) continue;
            mbgDim = mbgDimMap.get(field);
            dimNumSet = entry2.getValue();
            if (dimNumSet == null || dimNumSet.isEmpty()) continue;
            if (queryData.getMbgDimMap().containsKey(field)) {
                mbgDimen = queryData.getMbgDimMap().get(field);
                HashSet<String> _tmpSet = new HashSet<String>();
                for (IMember _member : mbgDimen.getMembers()) {
                    _tmpSet.add(_member.getDimNumber());
                }
                _tmpSet.retainAll(dimNumSet);
                ArrayList<IMember> delMembers = new ArrayList<IMember>();
                for (IMember _member : mbgDimen.getMembers()) {
                    if (_tmpSet.contains(_member.getDimNumber())) continue;
                    delMembers.add(_member);
                }
                mbgDimen.getMembers().removeAll(delMembers);
                continue;
            }
            mbgDimen = new Dimension();
            mbgDimen.setNumber(mbgDim.getNumber());
            mbgDimen.setSrcNumber(mbgDim.getSrcNumber());
            mbgDimen.setField(entry2.getKey());
            queryData.getMbgDimMap().put(field, mbgDimen);
            if (DimUtils.checkBaseDimensionByField(field)) {
                for (String number : dimNumSet) {
                    mbgMember = new Member();
                    mbgMember.setNumber(number);
                    mbgMember.setDimNumber(number);
                    mbgDimen.addMember(mbgMember);
                }
                continue;
            }
            for (String dimNumber : dimNumSet) {
                tmpStrs = dimNumber.split(":");
                mbgMember = new Member();
                mbgMember.setNumber(tmpStrs[1]);
                mbgMember.setSrcNumber(mbgDim.getSrcNumber());
                mbgMember.setDimNumber(dimNumber);
                mbgDimen.addMember(mbgMember);
            }
        }
    }

    public static void checkFunctionMember(IExpress expr, String schemeNum, String orgUnitNum, BgExamineFacadeControllerBean.ExprDimQuery query, Map<String, Map<String, Set<String>>> formDataMap) {
        MBgExamineUtils.checkFunctionMember(expr, schemeNum, orgUnitNum, query, formDataMap, null);
    }

    public static void checkFunctionMember(IExpress expr, String schemeNum, String orgUnitNum, BgExamineFacadeControllerBean.ExprDimQuery query, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap) {
        if (expr == null || schemeNum == null || orgUnitNum == null || query == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            MBgExamineUtils.checkFunctionMember((BinaryExpr)expr, (BinaryExpr)expr, schemeNum, orgUnitNum, query, formDataMap, adjustDataMap);
        }
    }

    public static void checkFunctionMember(BinaryExpr binExpr, BinaryExpr expr, String schemeNum, String orgUnitNum, BgExamineFacadeControllerBean.ExprDimQuery query, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap) {
        if (expr == null || schemeNum == null || orgUnitNum == null || query == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            MBgExamineUtils.checkFunctionMember(binExpr, (BinaryExpr)expr.left, schemeNum, orgUnitNum, query, formDataMap, adjustDataMap);
        } else if (expr.left instanceof MdxMemberExpr) {
            MBgExamineUtils.checkFunctionMember(binExpr, (MdxMemberExpr)expr.left, schemeNum, orgUnitNum, query, formDataMap, adjustDataMap);
        }
        if (expr.right instanceof BinaryExpr) {
            MBgExamineUtils.checkFunctionMember(binExpr, (BinaryExpr)expr.right, schemeNum, orgUnitNum, query, formDataMap, adjustDataMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            MBgExamineUtils.checkFunctionMember(binExpr, (MdxMemberExpr)expr.right, schemeNum, orgUnitNum, query, formDataMap, adjustDataMap);
        }
    }

    public static void checkFunctionMember(BinaryExpr binExpr, MdxMemberExpr expr, String schemeNum, String orgUnitNum, BgExamineFacadeControllerBean.ExprDimQuery query, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap) {
        if (expr == null || schemeNum == null || orgUnitNum == null || query == null) {
            return;
        }
        IExpress param = null;
        FunctionExpr functionExpr = null;
        String _leftNumber = null;
        if (binExpr != null && binExpr.left instanceof MdxMemberExpr) {
            MdxMemberExpr left = (MdxMemberExpr)binExpr.left;
            MemberExpr _memberExpr = null;
            for (IExpress _expr : left.params) {
                if (!(_expr instanceof MemberExpr)) continue;
                _memberExpr = (MemberExpr)_expr;
                if (!DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(_memberExpr.srcNumber)) continue;
                _leftNumber = _memberExpr.number;
                break;
            }
        }
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            param = (IExpress)expr.params.get(i);
            if (!(param instanceof FunctionExpr)) continue;
            functionExpr = (FunctionExpr)param;
            if (!functionExpr.functionName.equalsIgnoreCase("lead")) continue;
            if (functionExpr.params.size() == 1) {
                OperandExpr _expr = (OperandExpr)functionExpr.params.get(0);
                if (_expr.value == null || BigDecimal.ZERO.compareTo(_expr.value) == 0) continue;
                if (StringUtils.isEmpty((String)_leftNumber)) {
                    MBgExamineUtils.checkFunctionMember(_expr.value.intValue(), schemeNum, orgUnitNum, query, formDataMap, adjustDataMap);
                    continue;
                }
                String offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)_leftNumber, (int)_expr.value.intValue());
                MBgExamineUtils.checkFunctionMember(offPeriodNum, query);
                continue;
            }
            if (functionExpr.params.size() != 2) continue;
            OperandExpr _expr1 = (OperandExpr)functionExpr.params.get(0);
            MemberExpr _expr2 = (MemberExpr)functionExpr.params.get(1);
            if (_expr1.value == null || BigDecimal.ZERO.compareTo(_expr1.value) == 0) continue;
            if (_expr2 == null) {
                MBgExamineUtils.checkFunctionMember(_expr1.value.intValue(), schemeNum, orgUnitNum, query, formDataMap, adjustDataMap);
                continue;
            }
            String offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)_expr2.number, (int)_expr1.value.intValue());
            MBgExamineUtils.checkFunctionMember(offPeriodNum, query);
        }
    }

    private static void checkFunctionMember(int offset, String schemeNum, String orgUnitNum, BgExamineFacadeControllerBean.ExprDimQuery query, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap) {
        Map<String, Set<String>> map;
        Object orgDimMap;
        if (schemeNum == null || orgUnitNum == null || query == null || formDataMap == null) {
            return;
        }
        String offPeriodNum = null;
        HashSet<String> offSet = new HashSet<String>();
        Set<String> memberSet = null;
        Map<String, Set<String>> dimDataMap22 = null;
        if (query.dimNumMap.containsKey(schemeNum) && (orgDimMap = query.dimNumMap.get(schemeNum)).containsKey(orgUnitNum) && (map = orgDimMap.get(orgUnitNum)).containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
            memberSet = map.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
            for (String periodNum : memberSet) {
                offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)periodNum, (int)offset);
                if (offPeriodNum == null) continue;
                offSet.add(offPeriodNum);
            }
        }
        if (query.scopeNumMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
            memberSet = query.scopeNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
            for (String string : memberSet) {
                offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)string, (int)offset);
                if (offPeriodNum == null) continue;
                offSet.add(offPeriodNum);
            }
        }
        if (formDataMap != null) {
            for (Map<String, Set<String>> dimDataMap22 : formDataMap.values()) {
                if (!dimDataMap22.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) continue;
                memberSet = dimDataMap22.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                for (String periodNum : memberSet) {
                    offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)periodNum, (int)offset);
                    if (offPeriodNum == null) continue;
                    offSet.add(offPeriodNum);
                }
            }
        }
        if (adjustDataMap != null) {
            memberSet = adjustDataMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
            for (String string : memberSet) {
                offPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumberNoSign((String)string, (int)offset);
                if (offPeriodNum == null) continue;
                offSet.add(offPeriodNum);
            }
        }
        if (!offSet.isEmpty()) {
            query.offPeriodSet = offSet;
        }
    }

    private static void checkFunctionMember(String offPeriodNum, BgExamineFacadeControllerBean.ExprDimQuery query) {
        if (offPeriodNum == null || query == null) {
            return;
        }
        query.offPeriodSet = new HashSet<String>();
        query.offPeriodSet.add(offPeriodNum);
    }

    public static void queryCache(Context ctx, BgSchemeInfo bgScheme, Map<String, MbgDimInfo> mbgDimMap, Collection<IDimension> dimensions, BgExamineResult result) throws Exception {
        if (dimensions == null || dimensions.isEmpty()) {
            return;
        }
        HashMap<String, Set<String>> dimMap = new HashMap<String, Set<String>>();
        Set<String> numberSet = null;
        for (IDimension dimension : dimensions) {
            if (dimMap.containsKey(dimension.getField())) {
                numberSet = (Set)dimMap.get(dimension.getField());
            } else {
                numberSet = new HashSet();
                dimMap.put(dimension.getField(), numberSet);
            }
            int jn = dimension.getMembers().size();
            for (int j = 0; j < jn; ++j) {
                numberSet.add(dimension.getMembers().get(j).getNumber());
            }
        }
        MBgExamineUtils.queryCache(ctx, bgScheme, mbgDimMap, dimMap, result);
    }

    public static void queryCache(Context ctx, BgSchemeInfo bgScheme, Map<String, MbgDimInfo> mbgDimMap, BgExamineFacadeControllerBean.ExprDimQuery query, BgExamineResult result) throws Exception {
        if (query == null || result == null) {
            return;
        }
        Map<String, Map<String, Set<String>>> orgDimMap2 = null;
        Map<String, Set<String>> dimMap2 = null;
        for (Map<String, Map<String, Set<String>>> orgDimMap2 : query.dimNumMap.values()) {
            for (Map<String, Set<String>> dimMap2 : orgDimMap2.values()) {
                MBgExamineUtils.queryCache(ctx, bgScheme, mbgDimMap, dimMap2, result);
            }
        }
    }

    public static void queryCache(Context ctx, BgSchemeInfo bgScheme, Map<String, MbgDimInfo> mbgDimMap, Map<String, Set<String>> queryNumMap, BgExamineResult result) throws Exception {
        if (ctx == null || bgScheme == null || mbgDimMap == null || queryNumMap == null || queryNumMap.isEmpty() || result == null) {
            return;
        }
        Map<String, Map<String, String[]>> cacheDataMap = null;
        Map.Entry<String, Map<String, String[]>> entry2 = null;
        Map<String, String[]> cacheMap = null;
        Map<Object, Object> dimDataMap = null;
        Set<String> numberSet = null;
        HashSet<String> tmpSet = null;
        String field = null;
        String number = null;
        String[] cacheStr2 = null;
        String[] dimDataStr = null;
        MbgDimInfo mbgDim = null;
        HashMap<String, Set<String>> _queryNumMap = new HashMap<String, Set<String>>();
        Map.Entry<String, Set<String>> fentry2 = null;
        for (Map.Entry<String, Set<String>> fentry2 : queryNumMap.entrySet()) {
            field = fentry2.getKey();
            numberSet = fentry2.getValue();
            tmpSet = new HashSet<String>();
            for (String _number : numberSet) {
                tmpSet.add(DimUtils.getNumber(_number));
            }
            _queryNumMap.put(field, tmpSet);
        }
        cacheDataMap = DimUtils.queryMemberCache(ctx, bgScheme, _queryNumMap, mbgDimMap);
        if (cacheDataMap != null) {
            for (Map.Entry<String, Map<String, String[]>> entry2 : cacheDataMap.entrySet()) {
                field = entry2.getKey();
                cacheMap = entry2.getValue();
                mbgDim = mbgDimMap.get(field);
                if (result.dimDataInfoMap.containsKey(field)) {
                    dimDataMap = result.dimDataInfoMap.get(field);
                } else {
                    dimDataMap = new HashMap();
                    result.dimDataInfoMap.put(field, dimDataMap);
                }
                for (String[] cacheStr2 : cacheMap.values()) {
                    dimDataStr = new String[4];
                    dimDataStr[0] = cacheStr2[0];
                    dimDataStr[1] = cacheStr2[2];
                    number = dimDataStr[0];
                    if (dimDataStr[1] == null) continue;
                    if (!DimUtils.checkBaseDimensionByField(field) && number.indexOf(":") == -1) {
                        number = mbgDim.getSrcNumber() + ":" + number;
                    }
                    dimDataMap.put(number, dimDataStr);
                }
            }
        }
    }

    public static void queryCache(Context ctx, BgSchemeInfo bgScheme, List<BgExamineDataCheckResult> checkResult, Map<String, MbgDimInfo> mbgDimMap, Map<String, String> srcFieldMap, BgExamineResult result) throws Exception {
        if (ctx == null || bgScheme == null || mbgDimMap == null || checkResult == null || checkResult.isEmpty()) {
            return;
        }
        BizCalcObj[] calcObjs = null;
        BizCalcObj calcObj2 = null;
        String dimNumber = null;
        String srcNumber = null;
        String number = null;
        String field = null;
        String[] params = null;
        String[] tmpStrs = null;
        String[] tmpNums = null;
        HashMap<String, Set<String>> queryNumMap = new HashMap<String, Set<String>>();
        Set<String> numberSet = null;
        for (BgExamineDataCheckResult checkRst : checkResult) {
            int in = checkRst.getResult().size();
            for (int i = 0; i < in; ++i) {
                for (BizCalcObj calcObj2 : checkRst.getResult().get(i)) {
                    if (StringUtils.isEmpty((String)calcObj2.formula) || (tmpStrs = (params = BgNFSHelper.parseFormulaPara(calcObj2.formula))[0].split(",")) == null) continue;
                    int xn = tmpStrs.length;
                    for (int x = 0; x < xn; ++x) {
                        dimNumber = tmpStrs[x];
                        tmpNums = dimNumber.split(":");
                        srcNumber = tmpNums[0];
                        number = tmpNums[1];
                        field = srcFieldMap.get(srcNumber);
                        if (queryNumMap.containsKey(field)) {
                            numberSet = (Set)queryNumMap.get(field);
                        } else {
                            numberSet = new HashSet();
                            queryNumMap.put(field, numberSet);
                        }
                        numberSet.add(number);
                    }
                }
            }
        }
        MBgExamineUtils.queryCache(ctx, bgScheme, mbgDimMap, queryNumMap, result);
    }

    public static Set<String> checkFormMember(Map<String, Map<String, Set<String>>> formDataMap) {
        HashSet<String> checkIds = new HashSet<String>();
        if (formDataMap == null || formDataMap.isEmpty()) {
            return checkIds;
        }
        String billId = null;
        Map<String, Set<String>> memberMap = null;
        Set<String> memberSet2 = null;
        Map.Entry<String, Map<String, Set<String>>> entry2 = null;
        block0: for (Map.Entry<String, Map<String, Set<String>>> entry2 : formDataMap.entrySet()) {
            billId = entry2.getKey();
            memberMap = entry2.getValue();
            if (memberMap.isEmpty()) {
                checkIds.add(billId);
            }
            for (Set<String> memberSet2 : memberMap.values()) {
                if (!memberSet2.isEmpty()) continue;
                checkIds.add(billId);
                continue block0;
            }
        }
        return checkIds;
    }

    public static List<BgExamineSubsetInfo> getSubsetsByExamines(List<BgExamineInfo> examines) {
        ArrayList<BgExamineSubsetInfo> s = new ArrayList<BgExamineSubsetInfo>();
        if (examines == null || examines.isEmpty()) {
            return s;
        }
        BgExamineInfo examine = null;
        for (int i = 0; i < examines.size(); ++i) {
            examine = examines.get(i);
            for (int j = 0; j < examine.getBgExamineSubset().size(); ++j) {
                s.add(examine.getBgExamineSubset().get(j));
            }
        }
        return s;
    }

    public static Map<String, Map<String, String>> getOrgParentNumbers(Connection conn, IExpress expr, String schemeNum, String orgUnitNum) throws BOSException {
        HashMap<String, Set<String>> parentFunOrgMap = new HashMap<String, Set<String>>();
        MBgExamineUtils.checkParentFunction(expr, schemeNum, orgUnitNum, parentFunOrgMap);
        return MBgExamineUtils.queryParentOrgUnitNumbers(conn, parentFunOrgMap);
    }

    public static void checkParentFunction(IExpress expr, String schemeNum, String orgUnitNum, Map<String, Set<String>> parentFunOrgMap) {
        if (expr == null || schemeNum == null || orgUnitNum == null || parentFunOrgMap == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            MBgExamineUtils.checkParentFunction((BinaryExpr)expr, (BinaryExpr)expr, schemeNum, orgUnitNum, parentFunOrgMap);
        }
    }

    public static void checkParentFunction(BinaryExpr binExpr, BinaryExpr expr, String schemeNum, String orgUnitNum, Map<String, Set<String>> parentFunOrgMap) {
        if (expr == null || schemeNum == null || orgUnitNum == null || parentFunOrgMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            MBgExamineUtils.checkParentFunction(binExpr, (BinaryExpr)expr.left, schemeNum, orgUnitNum, parentFunOrgMap);
        } else if (expr.left instanceof MdxMemberExpr) {
            MBgExamineUtils.checkParentFunction(binExpr, (MdxMemberExpr)expr.left, schemeNum, orgUnitNum, parentFunOrgMap);
        }
        if (expr.right instanceof BinaryExpr) {
            MBgExamineUtils.checkParentFunction(binExpr, (BinaryExpr)expr.right, schemeNum, orgUnitNum, parentFunOrgMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            MBgExamineUtils.checkParentFunction(binExpr, (MdxMemberExpr)expr.right, schemeNum, orgUnitNum, parentFunOrgMap);
        }
    }

    public static void checkParentFunction(BinaryExpr binExpr, MdxMemberExpr expr, String schemeNum, String orgUnitNum, Map<String, Set<String>> parentFunOrgMap) {
        if (expr == null || schemeNum == null || orgUnitNum == null || parentFunOrgMap == null) {
            return;
        }
        IExpress param = null;
        FunctionExpr functionExpr = null;
        String schemeNumber = schemeNum;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            param = (IExpress)expr.params.get(i);
            if (param instanceof MemberExpr && DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)param).srcNumber)) {
                schemeNumber = ((MemberExpr)param).number;
            }
            if (!(param instanceof FunctionExpr)) continue;
            functionExpr = (FunctionExpr)param;
            if (!functionExpr.functionName.equalsIgnoreCase("Parent")) continue;
            String orgUnitNumber = null;
            if (functionExpr.params.isEmpty()) {
                orgUnitNumber = orgUnitNum;
            } else if (functionExpr.params.size() == 1 && StringUtil.isEmpty((String)(orgUnitNumber = (String)functionExpr.params.get(0)))) {
                orgUnitNumber = orgUnitNum;
            }
            if (StringUtils.isEmpty((String)orgUnitNumber)) continue;
            if (!parentFunOrgMap.containsKey(schemeNumber)) {
                parentFunOrgMap.put(schemeNumber, new HashSet());
            }
            parentFunOrgMap.get(schemeNumber).add(orgUnitNumber);
        }
    }

    public static Map<String, Map<String, String>> queryParentOrgUnitNumbers(Connection conn, Map<String, Set<String>> parentFunOrgSet) throws BOSException {
        HashMap<String, Map<String, String>> orgUnitMap = new HashMap<String, Map<String, String>>();
        if (parentFunOrgSet.isEmpty()) {
            return orgUnitMap;
        }
        String schemeNumber = null;
        String orgUnitNumber = null;
        String parentNumber = null;
        HashSet<String> schemeNumSet = new HashSet<String>();
        HashSet childSet = new HashSet();
        for (String shcemeNum : parentFunOrgSet.keySet()) {
            schemeNumSet.add(shcemeNum);
            childSet.addAll(parentFunOrgSet.get(shcemeNum));
        }
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(schemeNumSet);
        params.addAll(childSet);
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t0.FNUMBER , t4.FNUMBER, t5.FNUMBER ").append(" FROM t_mbg_bgscheme  t0 ").append(" left join t_mbg_BgDimSettings t1 on t1.FBGSCHEMEID = t0.fid ").append(" left join t_mbg_BgDimSettingsMember t2 on t2.FBGDIMSETTINGSID = t1.FID ").append(" join t_mbg_bgorgview t3 on t3.FID = t2.FMEMBERID ").append(" join t_mbg_bgorgunit t4 on t4.FVIEWID = t3.FID ").append(" join t_mbg_bgorgUnit t5 on t5.FID  = t4.FPARENTID ").append(" where t1.FDIMNUMBER = 'BG_Organization' ").append(" and t0.FNUMBER in (");
        for (String s : schemeNumSet) {
            sql.append("?,");
        }
        if (schemeNumSet.size() > 0) {
            sql.delete(sql.length() - 1, sql.length());
        }
        sql.append(") ");
        sql.append(" and t4.FNUMBER in ( ");
        for (String s : childSet) {
            sql.append("?,");
        }
        if (schemeNumSet.size() > 0) {
            sql.delete(sql.length() - 1, sql.length());
        }
        sql.append(") ");
        sql.append(" and t4.FISVIRTUAL = 0");
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), params);
            while (rst.next()) {
                schemeNumber = rst.getString(1);
                orgUnitNumber = rst.getString(2);
                parentNumber = rst.getString(3);
                if (!orgUnitMap.containsKey(schemeNumber)) {
                    orgUnitMap.put(schemeNumber, new HashMap());
                }
                ((Map)orgUnitMap.get(schemeNumber)).put(orgUnitNumber, parentNumber);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryParentOrgUnitNumbers sql error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnitMap;
    }
}

