/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.IMBGFormFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgBudgetDataQueryHelper {
    private static final Logger logger = Logger.getLogger((String)MbgBudgetDataQueryHelper.class.getName());
    public static final int NORMAL = 0;
    public static final int QUERY = 1;
    private int queryState = 0;
    private MySwingWorker swingWork = null;
    private IObjectValue queryInfo = null;
    private Map<String, List<IBgDimensionManagerBase>> dimensionManagers = null;
    private int dataType = 0;
    private Set viewStates = null;
    private BOSUuid bgOrgViewId = null;
    private boolean needActData = false;
    private Component owner = null;
    private Context ctx = null;
    private Object isActionAdjust = null;

    public void setQueryState(int queryState) {
        this.queryState = queryState;
    }

    public void setViewStates(Set viewStates) {
        this.viewStates = viewStates;
    }

    public Set getViewStates() {
        return this.viewStates;
    }

    public BOSUuid getBgOrgViewId() {
        return this.bgOrgViewId;
    }

    public void setBgOrgViewId(BOSUuid bgOrgViewId) {
        this.bgOrgViewId = bgOrgViewId;
    }

    public void setNeedActData(boolean needActData) {
        this.needActData = needActData;
    }

    public boolean isNeedActData() {
        return this.needActData;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public MbgBudgetDataQueryHelper(Component owner, Context ctx) {
        this.ctx = ctx;
        this.owner = owner;
    }

    public void startQueryData(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        if (queryInfo != null && dimensionManagers != null && !dimensionManagers.isEmpty()) {
            this.queryInfo = queryInfo;
            this.dimensionManagers = dimensionManagers;
            this.dataType = dataType;
            this.queryState = 1;
            this.bgOrgViewId = bgOrgViewId;
            this.swingWork = new MySwingWorker();
            this.swingWork.start();
        }
    }

    public void startQueryData(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, BOSUuid bgOrgViewId, boolean isActionAdjust) throws BOSException, EASBizException {
        if (queryInfo != null && dimensionManagers != null && !dimensionManagers.isEmpty()) {
            this.isActionAdjust = isActionAdjust;
            this.queryInfo = queryInfo;
            this.dimensionManagers = dimensionManagers;
            this.dataType = dataType;
            this.queryState = 1;
            this.bgOrgViewId = bgOrgViewId;
            this.swingWork = new MySwingWorker();
            this.swingWork.start();
        }
    }

    public Map<String, Map<String, BgNViewDataInfo>> queryData(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        return this.queryDimData(queryInfo, dimensionManagers, dataType, false, bgOrgViewId);
    }

    public Map<String, Map<String, BgNViewDataInfo>> queryData(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        return this.queryDimData(queryInfo, dimensionManagers, dataType, isSynch, bgOrgViewId);
    }

    private Map<String, Map<String, BgNViewDataInfo>> queryDimData(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        if (this.queryState == 1) {
            Object exc;
            this.queryState = 0;
            Object obj = this.swingWork.get();
            if (obj instanceof BOSException && (exc = (BOSException)((Object)obj)).getCause() != null) {
                obj = exc.getCause();
            }
            if (obj instanceof BgPeriodException) {
                MsgBox.showDetailAndOK((Component)this.owner, (String)((BgPeriodException)((Object)obj)).getMessage(), (String)((BgPeriodException)((Object)obj)).getCause().getMessage(), (int)0);
                SysUtil.abort();
            } else if (obj instanceof DimensionException) {
                exc = (DimensionException)((Object)obj);
                if (((DimensionException)((Object)obj)).getCause() == null) {
                    MsgBox.showInfo((Component)this.owner, (String)((DimensionException)((Object)obj)).getMessage());
                } else {
                    MsgBox.showDetailAndOK((Component)this.owner, (String)((DimensionException)((Object)obj)).getMessage(), (String)((DimensionException)((Object)obj)).getCause().getMessage(), (int)0);
                }
                SysUtil.abort();
            } else {
                if (obj instanceof BOSException) {
                    throw (BOSException)((Object)obj);
                }
                if (obj instanceof EASBizException) {
                    throw (EASBizException)((Object)obj);
                }
                if (obj instanceof RuntimeException) {
                    throw (RuntimeException)obj;
                }
                if (obj instanceof Throwable) {
                    throw new BOSException((Throwable)obj);
                }
            }
            return (Map)obj;
        }
        Map obj = null;
        try {
            obj = this.runQuery(queryInfo, dimensionManagers, dataType, isSynch, bgOrgViewId);
        }
        catch (BgPeriodException ex) {
            MsgBox.showDetailAndOK((Component)this.owner, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
            SysUtil.abort();
        }
        return obj;
    }

    protected Map runQuery(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        return this.runDimQuery(queryInfo, dimensionManagers, dataType, false, bgOrgViewId);
    }

    protected Map runQuery(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, BOSUuid bgOrgViewId, boolean need) throws BOSException, EASBizException {
        return this.runDimQuery(queryInfo, dimensionManagers, dataType, false, bgOrgViewId, need, false);
    }

    protected Map runQuery(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, BOSUuid bgOrgViewId, boolean need, boolean isActionAdjust) throws BOSException, EASBizException {
        return this.runDimQuery(queryInfo, dimensionManagers, dataType, false, bgOrgViewId, need, isActionAdjust);
    }

    protected Map runQuery(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        return this.runDimQuery(queryInfo, dimensionManagers, dataType, isSynch, bgOrgViewId);
    }

    protected Map runQuery(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId, boolean need) throws BOSException, EASBizException {
        return this.runDimQuery(queryInfo, dimensionManagers, dataType, isSynch, bgOrgViewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map runDimQuery(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        Map<MbgViewListDimensionManager, List<MbgViewListCell>> cellsMap = null;
        try {
            cellsMap = this.removeCells(dimensionManagers);
            Map map = this.getBizFacade().queryViewData(queryInfo, dimensionManagers, dataType, isSynch, bgOrgViewId, false, this.viewStates, false);
            return map;
        }
        finally {
            this.addCells(cellsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map runDimQuery(IObjectValue queryInfo, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId, boolean need, boolean isActionAdjust) throws BOSException, EASBizException {
        Map<MbgViewListDimensionManager, List<MbgViewListCell>> cellsMap = null;
        try {
            cellsMap = this.removeCells(dimensionManagers);
            Map map = this.getBizFacade().queryViewData(queryInfo, dimensionManagers, dataType, isSynch, bgOrgViewId, need, this.viewStates, isActionAdjust);
            return map;
        }
        finally {
            this.addCells(cellsMap);
        }
    }

    protected IMBGFormFacade getBizFacade() throws BOSException {
        if (this.ctx == null) {
            return MBGFormFacadeFactory.getRemoteInstance();
        }
        return MBGFormFacadeFactory.getLocalInstance(this.ctx);
    }

    private Map<MbgViewListDimensionManager, List<MbgViewListCell>> removeCells(Map<String, List<IBgDimensionManagerBase>> dimensionManagers) {
        HashMap<MbgViewListDimensionManager, List<MbgViewListCell>> cellsMap = new HashMap<MbgViewListDimensionManager, List<MbgViewListCell>>();
        if (dimensionManagers == null || dimensionManagers.isEmpty()) {
            return cellsMap;
        }
        MbgViewListDimensionManager viewDim = null;
        for (List<IBgDimensionManagerBase> subList : dimensionManagers.values()) {
            for (IBgDimensionManagerBase dimManager : subList) {
                if (!(dimManager instanceof MbgViewListDimensionManager)) continue;
                viewDim = (MbgViewListDimensionManager)dimManager;
                cellsMap.put(viewDim, new ArrayList<MbgViewListCell>(viewDim.getCells()));
                viewDim.getCells().clear();
            }
        }
        return cellsMap;
    }

    private void addCells(Map<MbgViewListDimensionManager, List<MbgViewListCell>> cellsMap) {
        if (cellsMap == null || cellsMap.isEmpty()) {
            return;
        }
        for (MbgViewListDimensionManager dim : cellsMap.keySet()) {
            dim.getCells().clear();
            dim.getCells().addAll((Collection<MbgViewListCell>)cellsMap.get(dim));
        }
    }

    private class MySwingWorker
    extends SwingWorker {
        private MySwingWorker() {
        }

        public Object construct() {
            Object obj = null;
            try {
                long ct = System.currentTimeMillis();
                logger.info((Object)("start construct: " + ct));
                obj = MbgBudgetDataQueryHelper.this.isActionAdjust instanceof Boolean ? MbgBudgetDataQueryHelper.this.runQuery(MbgBudgetDataQueryHelper.this.queryInfo, (Map<String, List<IBgDimensionManagerBase>>)MbgBudgetDataQueryHelper.this.dimensionManagers, MbgBudgetDataQueryHelper.this.dataType, MbgBudgetDataQueryHelper.this.bgOrgViewId, MbgBudgetDataQueryHelper.this.needActData, (boolean)((Boolean)MbgBudgetDataQueryHelper.this.isActionAdjust)) : MbgBudgetDataQueryHelper.this.runQuery(MbgBudgetDataQueryHelper.this.queryInfo, (Map<String, List<IBgDimensionManagerBase>>)MbgBudgetDataQueryHelper.this.dimensionManagers, MbgBudgetDataQueryHelper.this.dataType, MbgBudgetDataQueryHelper.this.bgOrgViewId, MbgBudgetDataQueryHelper.this.needActData);
                logger.info((Object)("end construct: " + (System.currentTimeMillis() - ct) + "ms"));
            }
            catch (Throwable e) {
                logger.error((Object)"", e);
                obj = e;
            }
            return obj;
        }
    }
}

