/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.MbgDataUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MbgDataMultiQuery {
    private static Logger logger = Logger.getLogger(MbgDataMultiQuery.class);
    private static final int availableProcessors = Runtime.getRuntime().availableProcessors() + 1;
    private Context ctx = null;
    private static final String POOL_SIZE = "CSL_POOL_SIZE";

    protected Context getCtx() {
        return this.ctx;
    }

    public MbgDataMultiQuery(Context ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> query(Map<String, IDimensionParameter> paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.getCtx() == null || paramMap == null || paramMap.isEmpty()) {
            return resultMap;
        }
        MultiThreadQuery.loadMdxSize(this.getCtx());
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin multi data query.");
        Connection conn = null;
        MbgAggregateQueryThread call = null;
        Future<Map<String, Map<String, IBgNData>>> result = null;
        HashMap<String, Future<Map<String, Map<String, IBgNData>>>> results = new HashMap<String, Future<Map<String, Map<String, IBgNData>>>>();
        try {
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            int poolSize = this.getPoolSize(conn);
            logger.debug((Object)("multi data query poolSize = " + poolSize));
            ExecutorService service = Executors.newFixedThreadPool(poolSize);
            for (String batchKey : paramMap.keySet()) {
                call = new MbgAggregateQueryThread(conn, paramMap.get(batchKey).getDataManager().getBgOrgUnit(), paramMap.get(batchKey), batchKey);
                if (call == null) continue;
                result = service.submit(call);
                results.put(batchKey, result);
            }
            service.shutdown();
            Map tmpDataMap = null;
            for (String batchKey : results.keySet()) {
                result = (Future<Map<String, Map<String, IBgNData>>>)results.get(batchKey);
                tmpDataMap = (Map)result.get();
                if (tmpDataMap.isEmpty()) continue;
                resultMap.put(batchKey, tmpDataMap.get(tmpDataMap.keySet().toArray()[0]));
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof BOSException) {
                throw (BOSException)ex.getCause();
            }
            if (ex.getCause() instanceof EASBizException) {
                throw (EASBizException)ex.getCause();
            }
            logger.error((Object)"query error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("end multi data query. use = " + (System.currentTimeMillis() - begin) + " ms."));
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, IBgNData>> query(IDimensionParameter parameter, List<BgOrgUnitInfo> bgOrgUnits) throws BOSException, EASBizException {
        HashMap<String, Map<String, IBgNData>> multiDataMap = new HashMap<String, Map<String, IBgNData>>();
        if (this.getCtx() == null || parameter == null || bgOrgUnits == null || bgOrgUnits.isEmpty()) {
            return multiDataMap;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin multi data query.");
        Connection conn = null;
        Callable<Map<String, Map<String, IBgNData>>> call = null;
        Future<Map<String, Map<String, IBgNData>>> result = null;
        ArrayList<Future<Map<String, Map<String, IBgNData>>>> results = new ArrayList<Future<Map<String, Map<String, IBgNData>>>>();
        try {
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            int poolSize = this.getPoolSize(conn);
            logger.debug((Object)("multi data query poolSize = " + poolSize));
            ExecutorService service = Executors.newFixedThreadPool(poolSize);
            for (BgOrgUnitInfo bgOrgUnit : bgOrgUnits) {
                call = this.getMbgDataQueryThread(conn, bgOrgUnit, parameter.getClone(this.getCtx()));
                if (call == null) continue;
                result = service.submit(call);
                results.add(result);
            }
            service.shutdown();
            Map<String, Map<String, IBgNData>> tmpDataMap = null;
            int in = results.size();
            for (int i = 0; i < in; ++i) {
                result = (Future<Map<String, Map<String, IBgNData>>>)results.get(i);
                tmpDataMap = result.get();
                this.mergeData(multiDataMap, tmpDataMap);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof BOSException) {
                throw (BOSException)ex.getCause();
            }
            if (ex.getCause() instanceof EASBizException) {
                throw (EASBizException)ex.getCause();
            }
            logger.error((Object)"query error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("end multi data query. use = " + (System.currentTimeMillis() - begin) + " ms."));
        return multiDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, IBgNData>> query(BOSUuid bgOrgViewId, Map dimensionManagers, IDimDataQuery dimDataQuery, int dataType, Set<Integer> customState) throws BOSException, EASBizException {
        HashMap<String, Map<String, IBgNData>> multiDataMap = new HashMap<String, Map<String, IBgNData>>();
        if (this.getCtx() == null || bgOrgViewId == null || dimensionManagers == null || dimensionManagers.isEmpty() || dimDataQuery == null) {
            return multiDataMap;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin multi data query.");
        String currOrgUnitId = dimDataQuery.getBizOrgUnit().getId().toString();
        List subDimensionManagers = (List)dimensionManagers.get(currOrgUnitId);
        if (subDimensionManagers == null) {
            return multiDataMap;
        }
        Connection conn = null;
        Callable<Map<String, Map<String, IBgNData>>> call = null;
        Future<Map<String, Map<String, IBgNData>>> result = null;
        ArrayList<Future<Map<String, Map<String, IBgNData>>>> results = new ArrayList<Future<Map<String, Map<String, IBgNData>>>>();
        try {
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            int poolSize = this.getPoolSize(conn);
            logger.debug((Object)("multi data query poolSize = " + poolSize));
            Map<String, String> orgUnitMap = this.getOrgUnitMap(dimensionManagers, dimDataQuery);
            ExecutorService service = Executors.newFixedThreadPool(poolSize);
            for (Map.Entry<String, String> entry : orgUnitMap.entrySet()) {
                subDimensionManagers = dimensionManagers.containsKey(entry.getValue()) ? (List)dimensionManagers.get(entry.getValue()) : (List)dimensionManagers.get(currOrgUnitId);
                call = this.getMbgDataQueryThread(conn, bgOrgViewId, entry.getValue(), subDimensionManagers, dimDataQuery, dataType, customState);
                if (call == null) continue;
                result = service.submit(call);
                results.add(result);
            }
            service.shutdown();
            Map tmpDataMap = null;
            int in = results.size();
            for (int i = 0; i < in; ++i) {
                result = (Future<Map<String, Map<String, IBgNData>>>)results.get(i);
                tmpDataMap = (Map)result.get();
                this.mergeData(multiDataMap, tmpDataMap);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof BOSException) {
                throw (BOSException)ex.getCause();
            }
            if (ex.getCause() instanceof EASBizException) {
                throw (EASBizException)ex.getCause();
            }
            logger.error((Object)"query error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("end multi data query. use = " + (System.currentTimeMillis() - begin) + " ms."));
        return multiDataMap;
    }

    protected int getPoolSize(Connection conn) throws EASBizException {
        IRowSet rst;
        int poolSize;
        block8: {
            poolSize = availableProcessors;
            if (conn == null) {
                return poolSize;
            }
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = ?", (Object[])new Object[]{POOL_SIZE});
                if (!rst.next()) break block8;
                try {
                    int _poolSize = Integer.parseInt(rst.getString("FVALUE"));
                    if (poolSize > _poolSize) {
                        poolSize = _poolSize;
                    }
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"poolSize param value trans error:", (Throwable)ex);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return poolSize;
    }

    protected Map<String, String> getOrgUnitMap(Map dimensionManagers, IDimDataQuery dimDataQuery) {
        HashMap<String, String> orgUnitNumMap = new HashMap<String, String>();
        List subDimensionManagers2 = null;
        BgDimensionMember bgMember = null;
        MbgViewListDimensionInfo bgDimension = null;
        for (List subDimensionManagers2 : dimensionManagers.values()) {
            int in = subDimensionManagers2.size();
            for (int i = 0; i < in; ++i) {
                IBgDimensionManagerBase dimManger = (IBgDimensionManagerBase)subDimensionManagers2.get(i);
                List<MbgViewListDimensionInfo> dimensions = dimManger instanceof MbgViewListDimensionManager ? ((MbgViewListDimensionManager)dimManger).getAllDimensions() : dimManger.getDimension();
                int jn = dimensions.size();
                for (int j = 0; j < jn; ++j) {
                    BgDimensionBaseInfo dimension;
                    bgDimension = dimensions.get(j);
                    if (!(bgDimension instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimension = (BgDimensionBaseInfo)bgDimension).getNumber())) continue;
                    int xn = dimension.getMember().size();
                    for (int x = 0; x < xn; ++x) {
                        bgMember = (BgDimensionMember)dimension.getMember().get(x);
                        orgUnitNumMap.put(bgMember.getNumber(), bgMember.getAttribute());
                    }
                }
            }
        }
        orgUnitNumMap.put(dimDataQuery.getBizOrgUnit().getNumber(), dimDataQuery.getBizOrgUnit().getId().toString());
        return orgUnitNumMap;
    }

    protected Callable<Map<String, Map<String, IBgNData>>> getMbgDataQueryThread(Connection conn, BgOrgUnitInfo bgOrgUnit, IDimensionParameter parameter) {
        MbgDataQueryThread call = new MbgDataQueryThread(conn, bgOrgUnit, parameter);
        return call;
    }

    protected Callable<Map<String, Map<String, IBgNData>>> getMbgDataQueryThread(Connection conn, BOSUuid bgOrgViewId, String orgUnitId, List<IBgDimensionManagerBase> subDimensionManagers, IDimDataQuery dimDataQuery, int dataType, Set<Integer> customState) {
        MbgDataMultiThread call = null;
        call = dimDataQuery.getClass().getName().equalsIgnoreCase("com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo") ? new MbgWorkDataMultiThread(conn, bgOrgViewId, orgUnitId, subDimensionManagers, dimDataQuery, dataType, customState) : new MbgDataMultiThread(conn, bgOrgViewId, orgUnitId, subDimensionManagers, dimDataQuery, dataType, customState);
        return call;
    }

    protected void mergeData(Map<String, Map<String, IBgNData>> multiDataMap, Map<String, Map<String, IBgNData>> queryDataMap) {
        if (multiDataMap == null || queryDataMap == null) {
            return;
        }
        Map.Entry<String, Map<String, IBgNData>> entry2 = null;
        Map<String, IBgNData> dataMap = null;
        for (Map.Entry<String, Map<String, IBgNData>> entry2 : queryDataMap.entrySet()) {
            dataMap = multiDataMap.get(entry2.getKey());
            if (dataMap != null) {
                dataMap.putAll(entry2.getValue());
                continue;
            }
            multiDataMap.put(entry2.getKey(), entry2.getValue());
        }
    }

    class MbgDataBaseThread
    extends Thread
    implements Callable<Map<String, Map<String, IBgNData>>> {
        MbgDataBaseThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void setBgDataState(Connection conn, IDimDataQuery dimDataQuery, Map<String, IBgNData> bgDataMap, IDimensionParameter parameter) throws BOSException, EASBizException {
            TempTablePool pool;
            ResultSet rst;
            PreparedStatement pstmt;
            ArrayList<String> tmpTables;
            long ct;
            block23: {
                boolean isUseAccInt;
                if (MbgDataMultiQuery.this.getCtx() == null) return;
                if (parameter == null) return;
                if (bgDataMap == null) return;
                if (bgDataMap.isEmpty()) {
                    return;
                }
                String operState = (String)MbgDataMultiQuery.this.getCtx().get((Object)"OPEN_STATE");
                if ("VIEW".equals(operState)) return;
                if (!parameter.getControlManager().hasQueryDataState()) {
                    return;
                }
                ct = System.currentTimeMillis();
                logger.info((Object)"start setBgDataState");
                BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
                if (bgScheme == null) {
                    return;
                }
                IBgNData data = null;
                String orgUnitId = parameter.getOrgUnitId().toString();
                String cubeName = bgScheme.getRefCube();
                if (parameter.getValueType() == 16 || parameter.getValueType() == 32) {
                    cubeName = BgCubeUtils.getDailyActualCubeName(bgScheme.getRefCube());
                } else if (parameter.getValueType() == 64) {
                    cubeName = BgCubeUtils.getCFSCubeName(bgScheme.getRefCube());
                } else if (parameter.getValueType() == 128) {
                    cubeName = BgCubeUtils.getCFSAdjustCubeName(bgScheme.getRefCube());
                }
                boolean bl = isUseAccInt = BgSchemeConvertToAccIntUtils.isUseAccInt(MbgDataMultiQuery.this.ctx, bgScheme.getId().toString()) && cubeName.equals(bgScheme.getRefCube());
                if (parameter.getOrgUnitId() != null && !MbgDataUtils.checkHasDataByOrgUnit(MbgDataMultiQuery.this.ctx, isUseAccInt, cubeName, null, parameter.getOrgUnitId().toString(), parameter.getBgOrgViewId().toString())) {
                    logger.info((Object)"end setBgDataState: not data or orgunit is not leaf!");
                    return;
                }
                HashSet<String> bgPeriodNums = new HashSet<String>();
                HashSet<String> bgElementNums = new HashSet<String>();
                HashSet<String> currencyNums = new HashSet<String>();
                HashSet<String> bgScenarioNums = new HashSet<String>();
                HashSet<String> mbgMemSet = null;
                HashMap<String, HashSet<String>> dimMemMap = new HashMap<String, HashSet<String>>();
                tmpTables = new ArrayList<String>();
                ArrayList<String> tmpNums = new ArrayList<String>();
                int versionId = 0;
                String dimKey2 = null;
                String formulaStr = null;
                String versionNum = null;
                String dimNumber2 = null;
                String srcNumber = null;
                String field = null;
                String tmpIndex = null;
                String tmpPeriod = null;
                String tmpElement = null;
                String tmpCurrency = null;
                String tmpScenario = null;
                String[] tmpStrs = null;
                String[] params = null;
                StringBuffer sql = new StringBuffer();
                HashSet<String> accNumbers = new HashSet<String>();
                Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
                Map<String, String> verInnNumMap = parameter.getDataManager().getInnNumMap().get(DimensionConstants.DEF_VERSION_FIELD);
                for (String dimKey2 : bgDataMap.keySet()) {
                    tmpStrs = dimKey2.split("_");
                    formulaStr = tmpStrs[0];
                    versionNum = tmpStrs[1];
                    params = BgNFSHelper.parseFormulaPara(formulaStr);
                    for (String dimNumber2 : params[0].split(",")) {
                        srcNumber = DimUtils.getSrcNumber(dimNumber2);
                        field = srcFieldMap.get(srcNumber);
                        if (isUseAccInt && srcNumber.equals(DimensionConstants.DEF_INDEX_SRCNUMBER)) {
                            accNumbers.add(DimUtils.getNumber(dimNumber2));
                        }
                        if ((mbgMemSet = (HashSet<String>)dimMemMap.get(field)) == null) {
                            mbgMemSet = new HashSet<String>();
                            dimMemMap.put(field, mbgMemSet);
                        }
                        mbgMemSet.add(dimNumber2);
                    }
                    bgPeriodNums.add(params[1]);
                    bgElementNums.add(params[2]);
                    currencyNums.add(params[5]);
                    bgScenarioNums.add(params[3]);
                }
                pstmt = null;
                rst = null;
                pool = TempTablePool.getInstance((Context)MbgDataMultiQuery.this.getCtx());
                try {
                    if (isUseAccInt && MbgDataUtils.checkHasDataByOrgUnit(MbgDataMultiQuery.this.getCtx(), isUseAccInt, cubeName, BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(isUseAccInt, cubeName, accNumbers, BgSchemeConvertToAccIntUtils.querySplit(conn, cubeName)), parameter.getOrgUnitId().toString(), parameter.getBgOrgViewId().toString())) {
                        logger.info((Object)"end setBgDataState: not data or orgunit is not leaf!");
                        return;
                    }
                    tmpIndex = BgDBUtils.createTmpTable((Context)MbgDataMultiQuery.this.getCtx(), (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
                    tmpTables.add(tmpIndex);
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), (Collection)((Collection)dimMemMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
                    tmpPeriod = BgDBUtils.createTmpTable((Context)MbgDataMultiQuery.this.getCtx(), (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    tmpTables.add(tmpPeriod);
                    tmpNums.clear();
                    tmpNums.addAll(bgPeriodNums);
                    BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                    tmpElement = BgDBUtils.createTmpTable((Context)MbgDataMultiQuery.this.getCtx(), (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    tmpTables.add(tmpElement);
                    tmpNums.clear();
                    tmpNums.addAll(bgElementNums);
                    BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                    tmpCurrency = BgDBUtils.createTmpTable((Context)MbgDataMultiQuery.this.getCtx(), (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    tmpTables.add(tmpCurrency);
                    tmpNums.clear();
                    tmpNums.addAll(currencyNums);
                    BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                    tmpScenario = BgDBUtils.createTmpTable((Context)MbgDataMultiQuery.this.getCtx(), (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                    tmpTables.add(tmpScenario);
                    tmpNums.clear();
                    tmpNums.addAll(bgScenarioNums);
                    BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                    sql.append("select FFormula, FVersion, FState from " + cubeName + " where FOrgUnitId = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and FVersion = ?");
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, orgUnitId);
                    pstmt.setInt(2, dimDataQuery.getBizVersion().getVersionId());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        formulaStr = rst.getString("FFormula");
                        dimKey2 = DimUtils.getDimDataKey(formulaStr, versionNum = verInnNumMap.get(String.valueOf(versionId = rst.getInt("FVersion"))));
                        data = bgDataMap.get(dimKey2);
                        if (data == null) continue;
                        data.setState(rst.getInt("FState"));
                    }
                    if (pool == null) break block23;
                }
                catch (SQLException ex) {
                    logger.error((Object)"query DataState Error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Exception ex) {
                    throw new BOSException((Throwable)ex);
                }
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTables);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            logger.info((Object)("end setBgDataState:" + (System.currentTimeMillis() - ct) + "ms"));
            return;
            finally {
                if (pool != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTables);
                }
                SQLUtils.cleanup(rst, pstmt);
            }
        }

        @Override
        public Map<String, Map<String, IBgNData>> call() throws Exception {
            return new HashMap<String, Map<String, IBgNData>>();
        }
    }

    class MbgWorkDataMultiThread
    extends MbgDataMultiThread {
        public MbgWorkDataMultiThread(Connection conn, BOSUuid bgOrgViewId, String orgUnitId, List<IBgDimensionManagerBase> subDimensionManagers, IDimDataQuery dimDataQuery, int dataType, Set<Integer> customState) {
            super(conn, bgOrgViewId, orgUnitId, subDimensionManagers, dimDataQuery, dataType, customState);
        }

        @Override
        public Map<String, Map<String, IBgNData>> call() throws Exception {
            return super.call();
        }

        @Override
        protected IDimensionParameter getDimensionParameter(Context ctx, BOSUuid bgOrgViewId, List<IBgDimensionManagerBase> subDimensionManagers, IDimDataQuery dimDataQuery) throws Exception {
            IDimensionParameter parameter = super.getDimensionParameter(ctx, bgOrgViewId, subDimensionManagers, dimDataQuery);
            if (parameter != null && !parameter.getOrgUnitId().equals((Object)dimDataQuery.getBizOrgUnit().getId())) {
                IQueryData query = null;
                IDimension mbgCsl = null;
                Member mbgMember = null;
                MemberObject member = null;
                com.kingdee.eas.ma.mbg.dimension.face.IDimension cslDim = parameter.getDimension(DimensionBaseConstants.DEF_CSL_FIELD);
                cslDim.getDimensionMember().clear();
                member = new MemberObject();
                member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                member.setNumber("CSL-01");
                cslDim.getDimensionMember().add(member);
                member = new MemberObject();
                member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                member.setNumber("CSL-02");
                cslDim.getDimensionMember().add(member);
                member = new MemberObject();
                member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                member.setNumber("CSL-03");
                cslDim.getDimensionMember().add(member);
                int in = parameter.getQuerys().size();
                for (int i = 0; i < in; ++i) {
                    query = parameter.getQuerys().get(i);
                    mbgCsl = query.getMbgDimMap().get(DimensionBaseConstants.DEF_CSL_FIELD);
                    if (mbgCsl == null) continue;
                    mbgCsl.getMembers().clear();
                    mbgMember = new Member();
                    mbgMember.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                    mbgMember.setNumber("CSL-01");
                    mbgCsl.getMembers().add(mbgMember);
                    mbgMember = new Member();
                    mbgMember.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                    mbgMember.setNumber("CSL-02");
                    mbgCsl.getMembers().add(mbgMember);
                    mbgMember = new Member();
                    mbgMember.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                    mbgMember.setNumber("CSL-03");
                    mbgCsl.getMembers().add(mbgMember);
                }
                parameter.getControlManager().setHasQueryDataState(false);
            }
            return parameter;
        }
    }

    class MbgDataMultiThread
    extends MbgDataBaseThread {
        private Connection conn = null;
        private BOSUuid bgOrgViewId = null;
        private String orgUnitId = null;
        private List<IBgDimensionManagerBase> subDimensionManagers;
        private IDimDataQuery dimDataQuery;
        private int dataType = 1;
        private Set<Integer> customState = null;

        public MbgDataMultiThread(Connection conn, BOSUuid bgOrgViewId, String orgUnitId, List<IBgDimensionManagerBase> subDimensionManagers, IDimDataQuery dimDataQuery, int dataType, Set<Integer> customState) {
            this.conn = conn;
            this.bgOrgViewId = bgOrgViewId;
            this.orgUnitId = orgUnitId;
            this.subDimensionManagers = subDimensionManagers;
            this.dimDataQuery = dimDataQuery;
            this.dataType = dataType;
            this.customState = customState;
        }

        @Override
        public Map<String, Map<String, IBgNData>> call() throws Exception {
            HashMap<String, Map<String, IBgNData>> orgDataMap = new HashMap<String, Map<String, IBgNData>>();
            if (this.conn == null || this.bgOrgViewId == null || StringUtils.isEmpty((String)this.orgUnitId) || this.subDimensionManagers == null || this.dimDataQuery == null) {
                return orgDataMap;
            }
            IDimensionParameter parameter = this.getDimensionParameter(MbgDataMultiQuery.this.getCtx(), this.bgOrgViewId, this.subDimensionManagers, this.dimDataQuery);
            if (parameter != null) {
                Map tmpMap;
                parameter.setValueType(this.dataType);
                if (this.customState != null && !this.customState.isEmpty()) {
                    parameter.getDataManager().getCustomState().addAll(this.customState);
                }
                if ((tmpMap = (Map)BgDimensionFacadeFactory.getLocalInstance(MbgDataMultiQuery.this.getCtx()).dimensionQuery(parameter)) != null) {
                    this.setBgDataState(this.conn, this.dimDataQuery, tmpMap, parameter);
                    orgDataMap.put(this.orgUnitId, tmpMap);
                }
            }
            return orgDataMap;
        }

        protected IDimensionParameter getDimensionParameter(Context ctx, BOSUuid bgOrgViewId, List<IBgDimensionManagerBase> subDimensionManagers, IDimDataQuery dimDataQuery) throws Exception {
            IDimensionParameter parameter = DimUtils.transDimParameter(ctx, subDimensionManagers, dimDataQuery, bgOrgViewId);
            if (parameter != null) {
                parameter.setOrgUnitId(BOSUuid.read((String)this.orgUnitId));
                parameter.getDataManager().setOrgUnit(MbgDataHelper.getBaseOrgUnitInfo(this.conn, MbgDataMultiQuery.this.getCtx().getLocale(), parameter.getOrgUnitId()));
                parameter.getDataManager().setBgOrgUnit(MbgDataHelper.getBgOrgUnitInfo(this.conn, MbgDataMultiQuery.this.getCtx().getLocale(), bgOrgViewId, parameter.getOrgUnitId()));
                com.kingdee.eas.ma.mbg.dimension.face.IDimension orgDim = parameter.getOrgDimension();
                if (orgDim != null) {
                    parameter.getRowDims().remove(orgDim);
                    parameter.getColDims().remove(orgDim);
                    parameter.getPageDims().remove(orgDim);
                    parameter.getDimensionMap().remove(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
                }
                IQueryData query = null;
                int in = parameter.getQuerys().size();
                for (int i = 0; i < in; ++i) {
                    query = parameter.getQuerys().get(i);
                    query.getMbgDimMap().remove(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
                }
            }
            return parameter;
        }
    }

    class MbgDataQueryThread
    extends MbgDataBaseThread {
        private Connection conn = null;
        private BgOrgUnitInfo bgOrgUnit = null;
        private IDimensionParameter parameter = null;

        public MbgDataQueryThread(Connection conn, BgOrgUnitInfo bgOrgUnit, IDimensionParameter parameter) {
            this.conn = conn;
            this.bgOrgUnit = bgOrgUnit;
            this.parameter = parameter;
        }

        @Override
        public Map<String, Map<String, IBgNData>> call() throws Exception {
            HashMap<String, Map<String, IBgNData>> orgDataMap = new HashMap<String, Map<String, IBgNData>>();
            if (this.conn == null || this.bgOrgUnit == null || this.parameter == null) {
                return orgDataMap;
            }
            if (StringUtils.isEmpty((String)this.bgOrgUnit.getOrgUnitID())) {
                this.bgOrgUnit = MbgDataHelper.getBgOrgUnitInfoById(this.conn, MbgDataMultiQuery.this.getCtx().getLocale(), this.bgOrgUnit.getId());
            }
            this.parameter.setOrgUnitId(BOSUuid.read((String)this.bgOrgUnit.getOrgUnitID()));
            this.parameter.getDataManager().setBgOrgUnit(this.bgOrgUnit);
            this.parameter.getDataManager().setOrgUnit(MbgDataHelper.getOrgUnitInfo(this.conn, MbgDataMultiQuery.this.getCtx().getLocale(), this.parameter.getOrgUnitId()));
            Map tmpMap = (Map)BgDimensionFacadeFactory.getLocalInstance(MbgDataMultiQuery.this.getCtx()).dimensionQuery(this.parameter);
            if (tmpMap != null && !tmpMap.isEmpty()) {
                orgDataMap.put(this.bgOrgUnit.getOrgUnitID(), tmpMap);
            }
            return orgDataMap;
        }
    }

    class MbgAggregateQueryThread
    extends MbgDataQueryThread {
        String batchKey;

        public MbgAggregateQueryThread(Connection conn, BgOrgUnitInfo bgOrgUnit, IDimensionParameter parameter, String batchKey) {
            super(conn, bgOrgUnit, parameter);
            this.batchKey = null;
            this.batchKey = batchKey;
        }
    }
}

