/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.utils.MbgFixelQueryBgDataThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgExportThreadProcessor {
    private static final Logger logger = CoreUIObject.getLogger(MbgExportThreadProcessor.class);
    public static int THREAD_COUNT = 3;
    private Map<String, Book> bookMap = new HashMap<String, Book>();
    List<MBGViewListFormExportProvider> viewlistProviders = new ArrayList<MBGViewListFormExportProvider>();
    List<MbgFixelQueryBgDataThread> fixelThread = new ArrayList<MbgFixelQueryBgDataThread>();
    private Set<String> processFormIds = new HashSet<String>();
    private boolean isRunning = false;
    private boolean isRunningFixel = false;

    public void start(LinkedHashMap<String, BgFormInfo> bgFormInfoMap, CoreUIObject ownerUI, Boolean isMoveDimension, Map<String, String> pageViewNumbers) {
        MBGViewListFormExportProvider provider = null;
        for (int i = 0; i < THREAD_COUNT; ++i) {
            provider = new MBGViewListFormExportProvider(bgFormInfoMap, ownerUI, isMoveDimension, pageViewNumbers, this);
            this.viewlistProviders.add(provider);
        }
        this.isRunning = true;
        MbgFixelQueryBgDataThread thread = null;
        for (int i = 0; i < THREAD_COUNT; ++i) {
            thread = new MbgFixelQueryBgDataThread(bgFormInfoMap, ownerUI, this);
            this.fixelThread.add(thread);
        }
        this.isRunningFixel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestProcess(String bgFormId) {
        Set<String> set = this.processFormIds;
        synchronized (set) {
            if (this.processFormIds.contains(bgFormId)) {
                return false;
            }
            this.processFormIds.add(bgFormId);
            return true;
        }
    }

    public void addToBookMap(String bgFormId, Book book) {
        this.bookMap.put(bgFormId, book);
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public void setRunningFixel(boolean isRunningFixel) {
        this.isRunningFixel = isRunningFixel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Book getBook(String bgFormId) {
        long st = System.currentTimeMillis();
        logger.error((Object)("**************** start wait time " + st + " " + bgFormId));
        while (this.isRunning) {
            Map<String, Book> map = this.bookMap;
            synchronized (map) {
                if (this.bookMap.containsKey(bgFormId)) {
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.error((Object)("**************** end wait time " + (System.currentTimeMillis() - st) + " ms " + bgFormId));
        Book book = this.bookMap.get(bgFormId);
        this.bookMap.remove(bgFormId);
        for (MBGViewListFormExportProvider provider : this.viewlistProviders) {
            provider.removeBook(bgFormId);
        }
        return book;
    }

    public TemplateStyleInfo getTemplateStyle(BgFormInfo _bgFormInfo) {
        TemplateStyleInfo style = null;
        ViewListProvider provider = null;
        for (int i = 0; i < this.viewlistProviders.size(); ++i) {
            provider = this.viewlistProviders.get(i);
            style = ((MBGViewListFormExportProvider)provider).getTemplateStyle(_bgFormInfo);
            if (style == null) continue;
            return style;
        }
        return provider != null ? provider.getTemplateStyle() : null;
    }

    public Map<String, Integer> getAccountDataTypeMap() {
        HashMap<String, Integer> accountDataTypeMap = new HashMap<String, Integer>();
        MBGViewListFormExportProvider provider = null;
        for (int i = 0; i < this.viewlistProviders.size(); ++i) {
            provider = this.viewlistProviders.get(i);
            if (provider.getAccountDataTypeMap() == null) continue;
            accountDataTypeMap.putAll(provider.getAccountDataTypeMap());
        }
        return accountDataTypeMap;
    }

    static {
        THREAD_COUNT = Runtime.getRuntime().availableProcessors() / 2;
        if (THREAD_COUNT < 0) {
            THREAD_COUNT = 1;
        }
    }
}

