/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IMbgPermission;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.UserGroupInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class MbgPermissionHelper {
    public static String resource = "com.kingdee.eas.ma.mbg.client.MbgPermissionResource";
    public static final String CHOOSE = "choose";
    public static final String NUMBER = "number";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String SHEETNAME = "sheetName";
    public static final String CODE = "code";
    public static final String SIMPLENAME = "simpleName";
    public static final String LEVEL = "level";
    public static final String LONGNUMBER = "longnumber";
    public static final String ISLEAF = "isleaf";
    public static final String CONTROLTYPE = "controlType";
    public static final String TEMPLATETYPE = "templateType";
    public static final String BGSCHEME = "bgScheme";
    public static final String USERGROUP = "group.name";
    public static final String DEFORGUNIT = "defOrgUnit.name";
    public static final String CREATEORGUNIT = "createOrgUnit";
    public static final String SELECTEDDATA = "selectedData";
    public static final String DESCRIPTION = "description";
    public static final String ORGUNIT = "orgUnit";
    public static final String ORGUNIT_NAME = "orgUnit.name";
    public static final String SHEETOBJ = "sheetObj";
    private static final String nullID = "000000000000000000000000000=";
    private static final String DATA_PERM_PARAM = "MBG_A150";

    public static IMbgPermission getIMbgPermission(Context ctx) throws BOSException {
        if (ctx == null) {
            return MbgPermissionFactory.getRemoteInstance();
        }
        return MbgPermissionFactory.getLocalInstance(ctx);
    }

    private static FilterInfo addDataPermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo srcFilter, MbgPermissionTypeEnum permType, String bgSchemeId, String filterColumn, boolean onlyOrgNotQuerytemp) throws EASBizException, BOSException {
        if (userId == null || srcFilter == null || permType == null) {
            return null;
        }
        if (bgSchemeId != null) {
            source = MbgPermissionHelper.getSourceType(ctx, bgSchemeId);
        }
        FilterInfo filter = srcFilter;
        int paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx);
        if (paramValue == 0) {
            return srcFilter;
        }
        if (paramValue == 1) {
            if (permType.equals((Object)MbgPermissionTypeEnum.SCHEME)) {
                filter = MbgPermissionHelper.dealSchemePermission(ctx, source, userId, filter, filterColumn);
            } else if (permType.equals((Object)MbgPermissionTypeEnum.TEMPLATE)) {
                filter = MbgPermissionHelper.dealBgTemplatePermission(ctx, source, userId, filter, bgSchemeId);
            }
            return filter;
        }
        if (paramValue == 2) {
            boolean isControl = MbgPermissionHelper.getIMbgPermission(ctx).isControlByDataPermission(source, userId, onlyOrgNotQuerytemp);
            if (isControl) {
                if (permType.equals((Object)MbgPermissionTypeEnum.SCHEME)) {
                    filter = MbgPermissionHelper.dealSchemePermission(ctx, source, userId, filter, filterColumn);
                } else if (permType.equals((Object)MbgPermissionTypeEnum.TEMPLATE)) {
                    filter = MbgPermissionHelper.dealBgTemplatePermission(ctx, source, userId, filter, bgSchemeId);
                }
                return filter;
            }
            return srcFilter;
        }
        return srcFilter;
    }

    public static int getDataPerimissionParam(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)DATA_PERM_PARAM) : ParamManager.getParamValue((Context)ctx, null, (String)DATA_PERM_PARAM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paramValue == null || "".equals(paramValue.trim())) {
            return 0;
        }
        return Integer.valueOf(paramValue);
    }

    public static FilterInfo addBgSchemePermission(RptSrcTypeEnum source, String userId, FilterInfo filter) throws EASBizException, BOSException {
        return MbgPermissionHelper.addBgSchemePermission(null, source, userId, filter);
    }

    public static FilterInfo addBgSchemePermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo filter) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        if (filter != null) {
            filter = MbgPermissionHelper.addDataPermission(ctx, source, userId, filter, MbgPermissionTypeEnum.SCHEME, null, null, false);
        }
        return filter;
    }

    public static FilterInfo addBgSchemePermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo filter, String filterColumn) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        if (filter != null) {
            filter = MbgPermissionHelper.addDataPermission(ctx, source, userId, filter, MbgPermissionTypeEnum.SCHEME, null, filterColumn, false);
        }
        return filter;
    }

    private static FilterInfo dealSchemePermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo filter, String filterColumn) throws EASBizException, BOSException {
        int perNum = 0;
        HashSet<String> schPer = MbgPermissionHelper.getIMbgPermission(ctx).getBgSchemePermission(source, userId);
        if (schPer == null || schPer.isEmpty()) {
            schPer = new HashSet<String>();
            schPer.add(nullID);
        }
        FilterItemInfo item = null;
        item = filterColumn != null ? new FilterItemInfo(filterColumn.toLowerCase(), schPer, CompareType.INCLUDE) : new FilterItemInfo(ID.toLowerCase(), schPer, CompareType.INCLUDE);
        perNum = MbgPermissionHelper.replaceFilterItems(filter, item, perNum);
        return filter;
    }

    public static FilterInfo addBgTemplatePermission(RptSrcTypeEnum source, String userId, FilterInfo filter, String bgSchemeId) throws EASBizException, BOSException {
        return MbgPermissionHelper.addBgTemplatePermission(source, userId, filter, bgSchemeId, false);
    }

    public static FilterInfo addBgTemplatePermission(RptSrcTypeEnum source, String userId, FilterInfo filter, String bgSchemeId, boolean onlyOrgNotQuerytemp) throws EASBizException, BOSException {
        return MbgPermissionHelper.addBgTemplatePermission(null, source, userId, filter, bgSchemeId, onlyOrgNotQuerytemp);
    }

    public static FilterInfo addBgTemplatePermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo filter, String bgSchemeId, boolean onlyOrgNotQuerytemp) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        if (filter != null && !StringUtils.isEmpty((String)bgSchemeId)) {
            filter = MbgPermissionHelper.addDataPermission(ctx, source, userId, filter, MbgPermissionTypeEnum.TEMPLATE, bgSchemeId, null, onlyOrgNotQuerytemp);
        }
        return filter;
    }

    private static FilterInfo dealBgTemplatePermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo filter, String bgSchemeId) throws EASBizException, BOSException {
        int perNum = 0;
        HashSet<String> schPer = MbgPermissionHelper.getIMbgPermission(ctx).getBgTemplatePermission(source, userId, bgSchemeId);
        if (schPer == null || schPer != null && schPer.isEmpty()) {
            schPer = new HashSet<String>();
            schPer.add(nullID);
        }
        FilterItemInfo item = new FilterItemInfo(ID.toLowerCase(), schPer, CompareType.INCLUDE);
        perNum = MbgPermissionHelper.replaceFilterItems(filter, item, perNum);
        return filter;
    }

    public static FilterInfo addFieldDataPermission(RptSrcTypeEnum source, String userId, FilterInfo filter, MbgPermissionTypeEnum permType, String field, String bgSchemeId) throws EASBizException, BOSException {
        return MbgPermissionHelper.addFieldDataPermission(source, userId, filter, permType, field, bgSchemeId, false);
    }

    public static FilterInfo addFieldDataPermission(RptSrcTypeEnum source, String userId, FilterInfo filter, MbgPermissionTypeEnum permType, String field, String bgSchemeId, boolean onlyOrgNotQuerytemp) throws EASBizException, BOSException {
        return MbgPermissionHelper.addFieldDataPermission(null, source, userId, filter, permType, field, bgSchemeId, onlyOrgNotQuerytemp);
    }

    public static FilterInfo addFieldDataPermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo filter, MbgPermissionTypeEnum permType, String field, String bgSchemeId, boolean onlyOrgNotQuerytemp) throws EASBizException, BOSException {
        int paramValue;
        if (userId == null || filter == null || permType == null) {
            return null;
        }
        if (bgSchemeId != null) {
            source = MbgPermissionHelper.getSourceType(ctx, bgSchemeId);
        }
        if ((paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx)) == 0) {
            return filter;
        }
        if (paramValue == 1) {
            filter = MbgPermissionHelper.dealFieldDataPermission(ctx, source, userId, filter, permType, field, bgSchemeId);
            return filter;
        }
        if (paramValue == 2) {
            boolean isControl = MbgPermissionHelper.getIMbgPermission(ctx).isControlByDataPermission(source, userId, onlyOrgNotQuerytemp);
            if (isControl) {
                filter = MbgPermissionHelper.dealFieldDataPermission(ctx, source, userId, filter, permType, field, bgSchemeId);
                return filter;
            }
            return filter;
        }
        return filter;
    }

    protected static RptSrcTypeEnum getSourceType(Context ctx, String bgSchemeId) throws BOSException {
        IBgScheme ibs = null;
        ibs = ctx == null ? BgSchemeFactory.getRemoteInstance() : BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeCollection col = ibs.getBgSchemeCollection("select bgSchemeType.schemeType where id = '" + bgSchemeId + "'");
        if (col != null && !col.isEmpty()) {
            return col.get(0).getBgSchemeType().getSchemeType();
        }
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    private static FilterInfo dealFieldDataPermission(Context ctx, RptSrcTypeEnum source, String userId, FilterInfo filter, MbgPermissionTypeEnum permType, String field, String bgSchemeId) throws EASBizException, BOSException {
        int perNum = 0;
        HashSet<String> schPer = null;
        if (permType.equals((Object)MbgPermissionTypeEnum.TEMPLATE)) {
            schPer = MbgPermissionHelper.getIMbgPermission(ctx).getBgTemplatePermission(source, userId, bgSchemeId);
        } else if (permType.equals((Object)MbgPermissionTypeEnum.SCHEME)) {
            schPer = MbgPermissionHelper.getIMbgPermission(ctx).getBgSchemePermission(source, userId);
        }
        if (schPer == null || schPer.isEmpty()) {
            schPer = new HashSet<String>();
            schPer.add(nullID);
        }
        FilterItemInfo item = new FilterItemInfo(field.toLowerCase(), schPer, CompareType.INCLUDE);
        perNum = MbgPermissionHelper.replaceFilterItems(filter, item, perNum);
        return filter;
    }

    private static void addFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        filter.getFilterItems().add(item);
        String maskStr = filter.getMaskString();
        if (maskStr == null) {
            StringBuffer maskStrBuf = new StringBuffer();
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                maskStrBuf = maskStrBuf.append(" #").append(i).append(" and");
            }
            if (maskStrBuf.length() > 0) {
                maskStrBuf.delete(maskStrBuf.length() - 3, maskStrBuf.length());
            }
            filter.setMaskString(maskStrBuf.toString());
        } else {
            maskStr = "(" + maskStr + ") and #" + (filter.getFilterItems().size() - 1);
            filter.setMaskString(maskStr);
        }
    }

    private static int replaceFilterItems(FilterInfo filter, FilterItemInfo item, int perNum) {
        if (filter == null || item == null) {
            return -1;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                if (item.getCompareValue() instanceof HashSet) {
                    if (fiInfo.getCompareValue() instanceof HashSet) {
                        HashSet srcSet = (HashSet)fiInfo.getCompareValue();
                        HashSet permSet = (HashSet)item.getCompareValue();
                        if (!srcSet.contains(nullID) && !permSet.contains(nullID)) {
                            permSet.retainAll(srcSet);
                        } else {
                            permSet.clear();
                            permSet.add(nullID);
                        }
                        if (permSet.isEmpty()) {
                            permSet.add(nullID);
                        }
                        fiInfo.setCompareValue((Object)permSet);
                    } else {
                        fiInfo.setCompareValue((Object)((HashSet)item.getCompareValue()).remove(fiInfo.getCompareValue()));
                    }
                } else {
                    fiInfo.setCompareValue(item.getCompareValue());
                }
                isReplace = true;
            }
            if (!isReplace) {
                ++perNum;
                fiCol.add(item);
                String maskStr = filter.getMaskString();
                if (StringUtils.isEmpty((String)maskStr)) {
                    return perNum;
                }
                maskStr = "(" + maskStr + ") and #" + (filter.getFilterItems().size() - 1);
                filter.setMaskString(maskStr);
            }
        }
        return perNum;
    }

    private static FilterInfo setMarkStringForForm(FilterInfo filter, int perNum) {
        if (perNum == 0) {
            return filter;
        }
        String filterMark = filter.getMaskString();
        String markString = "";
        if (filterMark == null || filterMark.trim().equals("")) {
            markString = "(";
            for (int i = 0; i < perNum; ++i) {
                markString = markString + " #" + i + " and ";
            }
            markString = markString.substring(0, markString.length() - 4);
            markString = markString + ") or #" + perNum;
            filter.setMaskString(markString);
        } else {
            markString = "((";
            for (int i = perNum; i > 0; --i) {
                markString = markString + " #" + (filter.getFilterItems().size() - i - 1) + " and ";
            }
            markString = markString.substring(0, markString.length() - 4);
            markString = markString + ") or #" + (filter.getFilterItems().size() - 1);
            markString = markString + ") ";
            filter.setMaskString(filterMark + " and " + markString);
        }
        return filter;
    }

    public static void getDataByVirtualMode(final KDTable kdtable, final List<String> columnName, final Object requestEntity, final String filterTextForNameNum, final FilterItemCollection defaultFilterCols, final SorterItemCollection defaultSorterColls) {
        if (kdtable == null || columnName.isEmpty() || requestEntity == null) {
            return;
        }
        int n = columnName.size();
        for (int i = 0; i < n; ++i) {
            kdtable.getDataRequestManager().putBindContents(columnName.get(i), "mainQuery", columnName.get(i));
        }
        kdtable.getDataRequestManager().setDataRequestMode(1);
        MbgPermissionHelper.removeRequestDataListener(kdtable);
        kdtable.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    int n = columnName.size();
                    for (int i = 0; i < n; ++i) {
                        sic.add((String)columnName.get(i));
                    }
                    viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                    FilterInfo filter = new FilterInfo();
                    StringBuilder mask = new StringBuilder();
                    if (!StringUtils.isEmpty((String)filterTextForNameNum) && !EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter").equals(filterTextForNameNum)) {
                        filter.getFilterItems().add(new FilterItemInfo(MbgPermissionHelper.NUMBER, (Object)("%" + filterTextForNameNum + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo(MbgPermissionHelper.NAME, (Object)("%" + filterTextForNameNum + "%"), CompareType.LIKE));
                        mask.append("(#0 or #1) and ");
                    }
                    viewInfo.setFilter(filter);
                    if (defaultFilterCols != null) {
                        int index = viewInfo.getFilter().getFilterItems().size();
                        for (int i = 0; i < defaultFilterCols.size(); ++i) {
                            if (i == 0) {
                                mask.append("#" + index);
                            } else {
                                mask.append(" and #" + index);
                            }
                            ++index;
                        }
                        filter.setMaskString(mask.toString());
                        viewInfo.getFilter().getFilterItems().addObjectCollection((IObjectCollection)defaultFilterCols);
                    }
                    if (defaultSorterColls != null) {
                        viewInfo.getSorter().addObjectCollection((IObjectCollection)defaultSorterColls);
                    }
                    EntityObjectInfo entity = null;
                    if (requestEntity instanceof UserInfo) {
                        entity = MbgPermissionHelper.getEntity(new UserInfo().getBOSType());
                    } else if (requestEntity instanceof UserGroupInfo) {
                        entity = MbgPermissionHelper.getEntity(new UserGroupInfo().getBOSType());
                    }
                    if (entity == null) {
                        return;
                    }
                    IDataProvider mainExec = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
                    mainExec.setObjectView(viewInfo);
                    Uuid queryId = mainExec.openQuery();
                    List allIdList = mainExec.getQueryKeys(queryId);
                    mainExec.option().isAutoTranslateEnum = true;
                    mainExec.option().pageCount = kdtable.getDataRequestManager().getPageRowCount();
                    int start = (Integer)e.getParam1();
                    int length = (Integer)e.getParam2() - start + 1;
                    IRowSet res = mainExec.executeQuery(queryId, start, length);
                    e.setRowSet(res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        kdtable.checkParsed();
        kdtable.removeRows();
    }

    public static EntityObjectInfo getEntity(BOSObjectType objectType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(objectType);
    }

    public static void removeRequestDataListener(KDTable kdTable) {
        DataSetWrapperFactory dataSetFactory = kdTable.getDataRequestManager().getDataSetFactory();
        EventListener[] listener = dataSetFactory.getRequestRowSetListeners();
        for (int i = 0; i < listener.length; ++i) {
            dataSetFactory.removeRequestRowSetListener((RequestRowSetListener)listener[i]);
        }
    }

    public static UserCollection getUserCollectionByObject(Object arrUserColls) {
        if (arrUserColls == null) {
            return null;
        }
        UserCollection userColls = new UserCollection();
        if (arrUserColls instanceof UserCollection) {
            return arrUserColls == null ? null : (UserCollection)arrUserColls;
        }
        if (arrUserColls instanceof Object[]) {
            Object[] objArr = (Object[])arrUserColls;
            for (int i = 0; i < objArr.length; ++i) {
                userColls.add((UserInfo)objArr[i]);
            }
            return userColls;
        }
        return userColls;
    }

    public static StringBuffer addFieldDataPermissionBySQL(RptSrcTypeEnum source, String userId, StringBuffer sql, MbgPermissionTypeEnum permType, String field, String bgSchemeId) throws EASBizException, BOSException {
        return MbgPermissionHelper.addFieldDataPermissionBySQL(null, source, userId, sql, permType, field, bgSchemeId);
    }

    public static StringBuffer addFieldDataPermissionBySQL(Context ctx, RptSrcTypeEnum source, String userId, StringBuffer sql, MbgPermissionTypeEnum permType, String field, String bgSchemeId) throws EASBizException, BOSException {
        if (userId == null || sql == null || permType == null) {
            return null;
        }
        int paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx);
        if (bgSchemeId != null) {
            source = MbgPermissionHelper.getSourceType(ctx, bgSchemeId);
        }
        if (paramValue == 0) {
            return sql;
        }
        if (paramValue == 1) {
            sql = MbgPermissionHelper.dealFieldDataPermissionBySQL(ctx, source, userId, sql, permType, field, bgSchemeId);
            return sql;
        }
        if (paramValue == 2) {
            boolean isControl = MbgPermissionHelper.getIMbgPermission(ctx).isControlByDataPermission(source, userId, false);
            if (isControl) {
                sql = MbgPermissionHelper.dealFieldDataPermissionBySQL(ctx, source, userId, sql, permType, field, bgSchemeId);
                return sql;
            }
            return sql;
        }
        return sql;
    }

    private static StringBuffer dealFieldDataPermissionBySQL(Context ctx, RptSrcTypeEnum source, String userId, StringBuffer sql, MbgPermissionTypeEnum permType, String field, String bgSchemeId) throws EASBizException, BOSException {
        HashSet<String> schPer = null;
        if (permType.equals((Object)MbgPermissionTypeEnum.TEMPLATE)) {
            schPer = MbgPermissionHelper.getIMbgPermission(ctx).getBgTemplatePermission(source, userId, bgSchemeId);
        } else if (permType.equals((Object)MbgPermissionTypeEnum.SCHEME)) {
            schPer = MbgPermissionHelper.getIMbgPermission(ctx).getBgSchemePermission(source, userId);
        }
        if (schPer == null || schPer != null && schPer.isEmpty()) {
            schPer = new HashSet<String>();
            schPer.add(nullID);
        }
        StringBuffer sqlbuf = new StringBuffer(" and " + field + " in (");
        for (String id : schPer) {
            sqlbuf.append("'").append(id).append("'").append(",");
        }
        sqlbuf.delete(sqlbuf.length() - 1, sqlbuf.length()).append(") ");
        return sql.append(sqlbuf.toString());
    }

    public static Set<String> getSheetPermissionByParam(Context ctx, RptSrcTypeEnum source, String userId, String tempId, String bgSchemeId) throws EASBizException, BOSException {
        return MbgPermissionHelper.getIMbgPermission(ctx).getBgTemplateSheetPermission(source, userId, tempId, bgSchemeId);
    }

    public static void setSheetHide(Context ctx, RptSrcTypeEnum source, String userId, String tempId, String bgSchemeId, Book book) throws EASBizException, BOSException {
        int i;
        Set<String> sheetIdList = null;
        sheetIdList = ctx == null ? MbgPermissionHelper.getSheetPermissionByParam(null, RptSrcTypeEnum.PT_BUDGET_REPORT, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), tempId, bgSchemeId) : MbgPermissionHelper.getSheetPermissionByParam(ctx, RptSrcTypeEnum.PT_BUDGET_REPORT, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), tempId, bgSchemeId);
        TreeMap<Integer, Integer> activeSheet = new TreeMap<Integer, Integer>();
        for (i = 0; i < book.getSheetCount(); ++i) {
            activeSheet.put(i, i);
        }
        if (sheetIdList != null && !sheetIdList.isEmpty()) {
            for (i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                String id = sheet.getID();
                if (id == null || sheetIdList.contains(id)) continue;
                sheet.setHide(true);
                activeSheet.remove(i);
            }
        }
        if (book.getActiveSheet() == null || book.getActiveSheet().isHide()) {
            if (activeSheet.isEmpty()) {
                book.setActiveSheet(0);
            } else {
                book.setActiveSheet(((Integer)activeSheet.firstKey()).intValue());
            }
        }
    }

    public static Set<String> getPermitedSchemeIDs(RptSrcTypeEnum rptSrcType, String userId, Set<String> bgSchemeIds) throws EASBizException, BOSException {
        return MbgPermissionHelper.getPermitedSchemeIDs(null, rptSrcType, userId, bgSchemeIds);
    }

    public static Set<String> getPermitedSchemeIDs(Context ctx, RptSrcTypeEnum source, String userId, Set<String> bgSchemeIds) throws EASBizException, BOSException {
        int paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx);
        if (paramValue == 0) {
            return bgSchemeIds;
        }
        if (paramValue == 1) {
            return MbgPermissionHelper.getIMbgPermission(ctx).getBgSchemePermission(source, userId);
        }
        if (paramValue == 2) {
            boolean isControl = MbgPermissionHelper.getIMbgPermission(ctx).isControlByDataPermission(source, userId, false);
            if (isControl) {
                return MbgPermissionHelper.getIMbgPermission(ctx).getBgSchemePermission(source, userId);
            }
            return bgSchemeIds;
        }
        return bgSchemeIds;
    }
}

