/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcImpl;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewCollection;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseDimSettingInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseIntegrateFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseMemberInfo;
import com.kingdee.eas.ma.mbg.client.MbgQingAnalyseCommonExplorer;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBgPeriodVariable;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgQingAnalyseHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.client.utils.MbgQingAnalyseHelper");
    public static final String IS_START_QING_SAVE = "IS_START_QING_SAVE";
    public static final String IS_USE_QING_POOL = "IS_USE_QING_POOL";

    public static void analyse(CoreUI ui, MbgQingAnalyseInfo analyseInfo, OrgUnitInfo orgUnitInfo) {
        try {
            UIContext uiContext = new UIContext((Object)new MbgQingAnalyseCommonExplorer());
            uiContext.put((Object)"ORGUNIT_ID", (Object)orgUnitInfo.getId().toString());
            uiContext.put((Object)"analyseInfo", (Object)analyseInfo);
            uiContext.put((Object)"analyseId", (Object)analyseInfo.getId().toString());
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(MbgQingAnalyseCommonExplorer.class.getName(), (Map)uiContext, null);
            uiWindow.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            ui.handUIExceptionAndAbort(e);
        }
    }

    public static BgOrgViewInfo getOrgViewInfo(Context ctx, BgSchemeInfo bgscheme) throws BOSException {
        EntityViewInfo evi = null;
        BgOrgViewInfo bgOrgView = null;
        if (bgscheme != null) {
            evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("Select settMember.FMemberID FROM T_MBG_BgDimSettings sett INNER JOIN T_MBG_BgDimSettingsMember settMember On settMember.FBgDimSettingsId = sett.FID Where sett.FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' And settMember.FType = " + 2 + " AND sett.FBgSchemeId = '" + bgscheme.getId() + "'"), CompareType.INNER));
            BgOrgViewCollection col = null;
            col = ctx == null ? BgOrgViewFactory.getRemoteInstance().getBgOrgViewCollection(evi) : BgOrgViewFactory.getLocalInstance(ctx).getBgOrgViewCollection(evi);
            if (col != null && !col.isEmpty()) {
                bgOrgView = col.get(0);
            }
        }
        return bgOrgView;
    }

    public static Map<String, String> getChildrenOrgUnit(Context ctx, String bgOrgUnitId, String bgOrgViewId) throws BOSException, EASBizException {
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("orgUnitId");
        sic.add("isVirtual");
        sic.add("level");
        filter.getFilterItems().add(new FilterItemInfo("orgUnitId", (Object)bgOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        BgOrgUnitCollection costCenterColls = null;
        BgOrgUnitInfo orgUnitInfo = null;
        String longNumber = null;
        try {
            costCenterColls = ctx == null ? BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi) : BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getChildrenOrgUnitIds error");
            throw e;
        }
        if (costCenterColls == null || costCenterColls.isEmpty()) {
            return orgUnitMap;
        }
        orgUnitInfo = costCenterColls.get(0);
        longNumber = orgUnitInfo.getLongNumber();
        orgUnitMap.put(orgUnitInfo.getOrgUnitID(), orgUnitInfo.getNumber());
        evi = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        try {
            costCenterColls = ctx == null ? BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi) : BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getChildrenOrgUnitIds error");
            throw e;
        }
        if (costCenterColls == null) {
            return orgUnitMap;
        }
        for (int i = 0; i < costCenterColls.size(); ++i) {
            orgUnitMap.put(costCenterColls.get(i).getOrgUnitID(), costCenterColls.get(i).getNumber());
        }
        return orgUnitMap;
    }

    public static void getQueryMemers(BizMemberQuery query, Map<String, String> variateMap, MbgQingAnalyseMemberInfo memberInfo, List<String> numbers) throws Exception {
        int valueType = memberInfo.getMemberSelectType().getValue();
        if (valueType == 1) {
            if (0 == memberInfo.getFillType().getValue()) {
                if (!StringUtils.isEmpty((String)memberInfo.getMemberNumber())) {
                    if (DimUtils.checkBaseDimensionByField(memberInfo.getRefField()) || DimensionBaseConstants.DEF_PROCESS_FIELD.equals(memberInfo.getRefField())) {
                        numbers.add(memberInfo.getMemberNumber());
                    } else {
                        String number = memberInfo.getMemberNumber();
                        String srcNumber = memberInfo.getSrcNumber();
                        number = srcNumber + ":" + number;
                        numbers.add(number);
                    }
                }
            } else {
                query.addQueryMember(memberInfo.getRefField(), DimUtils.getNumber(memberInfo.getMemberNumber()), memberInfo.getFillType().getValue(), BizMemberQuery.QUERY_ALL);
            }
        } else if (valueType == 2) {
            if (variateMap != null && variateMap.containsKey(memberInfo.getMemberNumber())) {
                if (DimUtils.checkBaseDimensionByField(memberInfo.getRefField())) {
                    numbers.add(DimUtils.getNumber(variateMap.get(memberInfo.getMemberNumber())));
                } else {
                    numbers.add(variateMap.get(memberInfo.getMemberNumber()));
                }
            }
        } else if (valueType == 4) {
            if (!StringUtils.isEmpty((String)memberInfo.getMemberNumber())) {
                query.addQueryFunction(memberInfo.getRefField(), memberInfo.getMemberNumber(), variateMap);
            }
        } else if (valueType == 3) {
            // empty if block
        }
    }

    public static Object convertMember(BizMemberQuery query, Map<String, String> variateMap, MbgQingAnalyseDimSettingInfo dimSettingInfo, BgMemberSelectTypeEnum memberSelectType, MbgQingAnalyseMemberInfo memberInfo, BgSchemeDimensionHelper schemeHelper) throws Exception {
        Map queryMap;
        String dimNumber = dimSettingInfo.getDimNumber();
        BgMemberSelectTypeEnum selectType = memberInfo.getMemberSelectType();
        ArrayList<BgDimensionMember> result = null;
        BgDimensionMember member = null;
        if (BgMemberSelectTypeEnum.Member.equals((Object)selectType)) {
            member = new BgDimensionMember(dimNumber, dimNumber, memberInfo.getMemberName(), memberInfo.getMemberNumber());
            member.setFillType(memberInfo.getFillType().getValue());
            member.setSrcNumber(member.getSrcNumber());
            return member;
        }
        if (BgMemberSelectTypeEnum.Variate.equals((Object)selectType)) {
            member = new BgDimensionMember(dimNumber, dimNumber, null, DimUtils.getNumber(variateMap.get(memberInfo.getMemberNumber())));
            member.setFillType(memberInfo.getFillType().getValue());
            member.setSrcNumber(member.getSrcNumber());
            return member;
        }
        result = new ArrayList<BgDimensionMember>();
        if (!StringUtils.isEmpty((String)memberInfo.getMemberNumber())) {
            query.addQueryFunction(memberInfo.getRefField(), memberInfo.getMemberNumber(), variateMap);
        }
        if ((queryMap = query.queryMember()) != null && !queryMap.isEmpty()) {
            List iMembers = null;
            String refField = memberInfo.getRefField();
            if (queryMap.containsKey(refField)) {
                iMembers = (List)queryMap.get(refField);
                for (IMember imember : iMembers) {
                    member = new BgDimensionMember(dimNumber, dimNumber, imember.getName(), imember.getNumber());
                    member.setFillType(memberInfo.getFillType().getValue());
                    member.setSrcNumber(member.getSrcNumber());
                    result.add(member);
                }
            }
        }
        return result;
    }

    public static Map<String, Set<String>> fillDimensionMemberByBizCalc(Context ctx, IDimensionParameter parameter, Map<String, String> srcFieldMap, Map<String, Map<String, String>> numInnMap, BgSchemeDimensionHelper schemeHelper) throws Exception {
        if (ctx == null || parameter == null) {
            return null;
        }
        BizCalcMember member = null;
        Set numbers = null;
        List<String> viewIds = null;
        StringBuffer sql = null;
        ArrayList<BizCalcMember> members = new ArrayList<BizCalcMember>();
        HashMap mdxNumMap = new HashMap();
        BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
        List<BOSUuid> calcIds = parameter.getCalcIds();
        HashSet<String> bizCalcIds = new HashSet<String>();
        for (BOSUuid calcId : calcIds) {
            bizCalcIds.add(calcId.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bizCalcSubset.*");
        selector.add("bizCalcSubset.scope.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bizCalcIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BizCalcCollection calcs = BizCalcFactory.getLocalInstance((Context)ctx).getBizCalcCollection(view);
        String[] tmpStrs = null;
        String srcNumber = null;
        String field = null;
        HashMap<String, Set<String>> refNumMap = new HashMap<String, Set<String>>();
        Map<String, String> variateMap = parameter.getDataManager().getVariate();
        if (!calcs.isEmpty() && parameter.getPeriodStandardNumber() != null && !parameter.getPeriodStandardNumber().isEmpty()) {
            ArrayList<BizCalcInfo> _calcs = new ArrayList<BizCalcInfo>();
            for (int i = 0; i < calcs.size(); ++i) {
                _calcs.add(calcs.get(i));
            }
            MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
            variable.transPeirodVariale(ctx, _calcs, parameter.getPeriodStandardNumber(), null);
        }
        if (variateMap != null) {
            for (String dimNumber : variateMap.values()) {
                tmpStrs = dimNumber.split(":");
                if (tmpStrs == null || tmpStrs.length != 2 || !srcFieldMap.containsKey(srcNumber = tmpStrs[0])) continue;
                field = srcFieldMap.get(srcNumber);
                BizExprUtils.putDimNumber((String)field, (String)dimNumber, refNumMap);
            }
        }
        if (calcs != null && !calcs.isEmpty()) {
            int in = calcs.size();
            for (int i = 0; i < in; ++i) {
                member = new BizCalcMember();
                member.setMdxNumMap(mdxNumMap);
                member.setSrcFieldMap(srcFieldMap);
                member.setNumInnMap(numInnMap);
                member.setCalc(calcs.get(i));
                member.queryRefMbgMember(ctx, parameter, bgScheme.getId(), refNumMap);
                members.add(member);
            }
        }
        List<String> longNumbers = null;
        HashSet<String> _numbers = new HashSet<String>();
        for (Map.Entry entry : refNumMap.entrySet()) {
            String dimNumber;
            dimNumber = schemeHelper.getDimensionByRefField().get(entry.getKey()).getNumber();
            numbers = (Set)entry.getValue();
            if (numbers == null || numbers.isEmpty()) continue;
            _numbers.clear();
            for (String itemNumber : numbers) {
                if (itemNumber.startsWith(DimensionFormulaHelper.getCombination(schemeHelper.getSrcNumber(dimNumber), ""))) {
                    _numbers.add(DimensionFormulaHelper.getMemberNumber(itemNumber));
                    continue;
                }
                _numbers.add(itemNumber);
            }
            numbers.clear();
            numbers.addAll(_numbers);
            if (DimUtils.checkBaseDimension(dimNumber)) {
                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) {
                    sql = new StringBuffer();
                    viewIds = MbgQingAnalyseHelper.convertCollection(bgScheme.getViewIds(dimNumber));
                    longNumbers = MbgQingAnalyseHelper.queryDimensionMember(ctx, dimNumber, numbers, viewIds);
                    sql.append("select FNumber from T_MBG_BgOrgUnit where FViewID = '" + viewIds.get(0) + "' and ");
                    MbgQingAnalyseHelper.queryLeafMember(ctx, longNumbers, numbers, sql);
                    continue;
                }
                if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimNumber)) continue;
                sql = new StringBuffer();
                viewIds = MbgQingAnalyseHelper.convertCollection(bgScheme.getViewIds(dimNumber));
                longNumbers = MbgQingAnalyseHelper.queryDimensionMember(ctx, dimNumber, numbers, viewIds);
                sql.append("select FNumber from T_MBG_BgPeriodDisp where FTypeId in (");
                for (String viewId : viewIds) {
                    sql.append("'").append(viewId).append("'").append(",");
                }
                sql.delete(sql.lastIndexOf(","), sql.length()).append(")").append(" and ");
                MbgQingAnalyseHelper.queryLeafMember(ctx, longNumbers, numbers, sql);
                continue;
            }
            if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber)) {
                sql = new StringBuffer();
                viewIds = MbgQingAnalyseHelper.convertCollection(bgScheme.getViewIds(dimNumber));
                longNumbers = MbgQingAnalyseHelper.queryDimensionMember(ctx, dimNumber, numbers, viewIds);
                sql.append("select FNumber from T_MBG_BgAccount where FBgAccountViewId = '" + viewIds.get(0) + "' and ");
                MbgQingAnalyseHelper.queryLeafMember(ctx, longNumbers, numbers, sql);
                continue;
            }
            sql = new StringBuffer();
            viewIds = MbgQingAnalyseHelper.convertCollection(bgScheme.getViewIds(dimNumber));
            longNumbers = MbgQingAnalyseHelper.queryDimensionMember(ctx, dimNumber, numbers, viewIds);
            sql.append("select FNumber from T_MBG_MbgMember where FviewId = '" + viewIds.get(0) + "' and ");
            MbgQingAnalyseHelper.queryLeafMember(ctx, longNumbers, numbers, sql);
        }
        return refNumMap;
    }

    private static void queryLeafMember(Context ctx, List<String> longNumbers, Set<String> numbers, StringBuffer sql) throws SQLException {
        if (longNumbers == null || longNumbers.isEmpty()) {
            return;
        }
        int index = 0;
        int i = 0;
        int in = longNumbers.size();
        while (i < in) {
            if (index < 50) {
                sql.append(" FLongNumber like '" + longNumbers.get(i) + "!%' or");
            } else {
                if (sql.toString().endsWith("or")) {
                    sql.delete(sql.lastIndexOf("or"), sql.length());
                }
                IRowSet result = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString());
                while (result.next()) {
                    numbers.add(result.getString(1));
                }
                index = 0;
                sql.delete(sql.indexOf("FLongNumber"), sql.length());
            }
            ++i;
            ++index;
        }
        if (index != 0) {
            if (sql.toString().endsWith("or")) {
                sql.delete(sql.lastIndexOf("or"), sql.length());
            }
            IRowSet result = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString());
            while (result.next()) {
                numbers.add(result.getString(1));
            }
        }
    }

    public static Map<String, Set<String>> queryAllMemberofData(Context ctx, Connection conn, IDimensionParameter parameter) throws BOSException {
        IDimensionParameter dimParam = parameter.getClone(ctx);
        List<String> viewIds = null;
        BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
        Map<String, IDimension> dimMap = dimParam.getDimensionMap();
        IDimension dimension2 = null;
        HashSet<String> numbers = null;
        BizCalcImpl calcImpl = new BizCalcImpl(ctx, null);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (IDimension dimension2 : dimMap.values()) {
            if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimension2.getNumber())) continue;
            dimension2.getDimensionMember().clear();
            calcImpl.queryMembers(conn, dimParam, dimension2, dimension2.getField());
            List<com.kingdee.eas.ma.mbg.dimension.face.IMember> memberList = dimension2.getDimensionMember();
            numbers = new HashSet<String>();
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : memberList) {
                numbers.add(member.getNumber());
            }
            map.put(dimension2.getNumber(), numbers);
        }
        for (Map.Entry entry : map.entrySet()) {
            numbers = (HashSet<String>)entry.getValue();
            if (DimUtils.checkBaseDimension((String)entry.getKey())) {
                if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(entry.getKey())) continue;
                viewIds = MbgQingAnalyseHelper.convertCollection(bgScheme.getViewIds((String)entry.getKey()));
                MbgQingAnalyseHelper.queryDimensionMember(ctx, (String)entry.getKey(), numbers, viewIds);
                continue;
            }
            viewIds = MbgQingAnalyseHelper.convertCollection(bgScheme.getViewIds((String)entry.getKey()));
            MbgQingAnalyseHelper.queryDimensionMember(ctx, (String)entry.getKey(), numbers, viewIds);
        }
        return map;
    }

    private static List<String> queryDimensionMember(Context ctx, String dimNumber, Set<String> numbers, List<String> viewIds) throws BOSException {
        ArrayList<String> longNumbers;
        block7: {
            FilterInfo filter;
            EntityViewInfo view;
            block9: {
                block8: {
                    block6: {
                        if (numbers == null || numbers.isEmpty()) {
                            return null;
                        }
                        longNumbers = new ArrayList<String>();
                        view = new EntityViewInfo();
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add("id");
                        sic.add("number");
                        sic.add("longNumber");
                        view.getSelector().addObjectCollection((IObjectCollection)sic);
                        filter = new FilterInfo();
                        if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) break block6;
                        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)viewIds.get(0), CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                        view.setFilter(filter);
                        IBgOrgUnit iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
                        BgOrgUnitCollection bgOrgUnitColl = iBgOrgUnit.getBgOrgUnitCollection(view);
                        BgOrgUnitInfo bgOrgUnitInfo = null;
                        if (bgOrgUnitColl == null || bgOrgUnitColl.isEmpty()) break block7;
                        int in = bgOrgUnitColl.size();
                        for (int i = 0; i < in; ++i) {
                            bgOrgUnitInfo = bgOrgUnitColl.get(i);
                            String longNumber = bgOrgUnitInfo.getLongNumber();
                            String[] nums = longNumber.split("!");
                            numbers.addAll(Arrays.asList(nums));
                            longNumbers.add(longNumber);
                        }
                        break block7;
                    }
                    if (!DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber)) break block8;
                    filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)viewIds.get(0), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                    view.setFilter(filter);
                    IBgAccount iBgAccount = BgAccountFactory.getLocalInstance((Context)ctx);
                    BgAccountCollection accountColl = iBgAccount.getBgAccountCollection(view);
                    BgAccountInfo bgAccountInfo = null;
                    if (accountColl == null || accountColl.isEmpty()) break block7;
                    int in = accountColl.size();
                    for (int i = 0; i < in; ++i) {
                        bgAccountInfo = accountColl.get(i);
                        String longNumber = bgAccountInfo.getLongNumber();
                        String[] nums = longNumber.split("!");
                        numbers.addAll(Arrays.asList(nums));
                        longNumbers.add(longNumber);
                    }
                    break block7;
                }
                if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber)) break block9;
                filter.getFilterItems().add(new FilterItemInfo("type.id", new HashSet<String>(viewIds), CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                view.setFilter(filter);
                IBgPeriodDisp iBgPeriodDisp = BgPeriodDispFactory.getLocalInstance((Context)ctx);
                BgPeriodDispCollection periodDispColl = iBgPeriodDisp.getBgPeriodDispCollection(view);
                BgPeriodDispInfo bgPeriodDispInfo = null;
                if (periodDispColl == null || periodDispColl.isEmpty()) break block7;
                int in = periodDispColl.size();
                for (int i = 0; i < in; ++i) {
                    bgPeriodDispInfo = periodDispColl.get(i);
                    String longNumber = bgPeriodDispInfo.getLongNumber();
                    String[] nums = longNumber.split("!");
                    numbers.addAll(Arrays.asList(nums));
                    longNumbers.add(longNumber);
                }
                break block7;
            }
            filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)viewIds.get(0), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            view.setFilter(filter);
            IMbgMember iMbgMember = MbgMemberFactory.getLocalInstance((Context)ctx);
            MbgMemberInfo mbgMemberInfo = null;
            MbgMemberCollection mbgMemberColl = iMbgMember.getMbgMemberCollection(view);
            if (mbgMemberColl != null && !mbgMemberColl.isEmpty()) {
                int in = mbgMemberColl.size();
                for (int i = 0; i < in; ++i) {
                    mbgMemberInfo = mbgMemberColl.get(i);
                    String longNumber = mbgMemberInfo.getLongNumber();
                    String[] nums = longNumber.split("!");
                    numbers.addAll(Arrays.asList(nums));
                    longNumbers.add(longNumber);
                }
            }
        }
        return longNumbers;
    }

    public static void filterDimensionMember(Context ctx, Connection conn, IDimensionParameter parameter, BgSchemeDimensionHelper schemeHelper) throws BOSException {
        try {
            Map<String, Set<String>> bizCalcMembers = MbgQingAnalyseHelper.fillDimensionMemberByBizCalc(ctx, parameter, MbgQingAnalyseHelper.getSrcFieldMap(ctx, parameter), MbgQingAnalyseHelper.getNumInnMap(ctx), schemeHelper);
            Map<String, Set<String>> dataMembers = MbgQingAnalyseHelper.queryAllMemberofData(ctx, conn, parameter);
            if (dataMembers == null) {
                dataMembers = new HashMap<String, Set<String>>();
            }
            String dimNumber = null;
            Set<String> dataNumbers = null;
            List<com.kingdee.eas.ma.mbg.dimension.face.IMember> dimensionMember = null;
            IDimension dimenison = null;
            for (Map.Entry<String, Set<String>> entry : bizCalcMembers.entrySet()) {
                dimNumber = schemeHelper.getDimensionByRefField().get(entry.getKey()).getNumber();
                Set<String> bizCalcNumbers = entry.getValue();
                if (dataMembers.containsKey(dimNumber)) {
                    dataNumbers = dataMembers.get(dimNumber);
                    dataNumbers.addAll(bizCalcNumbers);
                    continue;
                }
                dataMembers.put(dimNumber, bizCalcNumbers);
            }
            Map<String, IDimension> dimensionMap = parameter.getDimensionMap();
            for (Map.Entry<String, IDimension> entry : dimensionMap.entrySet()) {
                dimNumber = entry.getKey();
                if (dataMembers == null || !dataMembers.containsKey(entry.getKey())) continue;
                dataNumbers = dataMembers.get(dimNumber);
                dimenison = entry.getValue();
                dimensionMember = dimenison.getDimensionMember();
                Iterator<com.kingdee.eas.ma.mbg.dimension.face.IMember> memIter = dimensionMember.iterator();
                while (memIter.hasNext()) {
                    if (dataNumbers.contains(memIter.next().getNumber())) continue;
                    memIter.remove();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)" MbgQingAnalyseHelper filterDimensionMember error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, String> getSrcFieldMap(Context ctx, IDimensionParameter parameter) throws EASBizException, BOSException {
        if (parameter == null) {
            return null;
        }
        if (parameter.getDimensionMap() != null && !parameter.getDimensionMap().isEmpty()) {
            HashMap<String, String> srcFieldMap = new HashMap<String, String>();
            String dimNum2 = null;
            IDimension dimObj = null;
            for (String dimNum2 : parameter.getDimensionMap().keySet()) {
                dimObj = parameter.getDimensionMap().get(dimNum2);
                srcFieldMap.put(dimObj.getSrcNumber(), dimObj.getField());
            }
            return srcFieldMap;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, parameter.getBgSchemeId().toString());
        return MbgQingAnalyseHelper.getSrcFieldMap(ctx, schemeHelper);
    }

    public static Map<String, String> getSrcFieldMap(Context ctx, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        if (ctx == null || schemeHelper == null) {
            return null;
        }
        String dimNumber = null;
        HashMap<String, String> srcFieldMap = new HashMap<String, String>();
        Map<String, String> refFieldMap = schemeHelper.getRefFieldMap();
        Map<String, String> srcNumberMap = schemeHelper.getSrcNumberMap();
        for (Map.Entry<String, String> entry : srcNumberMap.entrySet()) {
            dimNumber = entry.getKey();
            if (refFieldMap == null || !refFieldMap.containsKey(dimNumber)) continue;
            srcFieldMap.put(entry.getValue(), refFieldMap.get(dimNumber));
        }
        return srcFieldMap;
    }

    public static Map<String, Map<String, String>> getNumInnMap(Context ctx) throws BOSException {
        Connection conn = null;
        try {
            BgVersionCollection _bgVerColls;
            conn = BgDBUtils.getConnection((Context)ctx);
            HashMap<String, String> scNumInnMap = new HashMap<String, String>();
            HashMap<String, String> verNumInnMap = new HashMap<String, String>();
            HashMap<String, Map<String, String>> numInnMap = new HashMap<String, Map<String, String>>();
            BgScenarioInfo _scenario = null;
            BgVersionInfo _version = null;
            BgScenarioCollection _bgScenColls = BgScenarioHelper.getScenarioColls((Connection)conn, (Locale)ctx.getLocale());
            if (_bgScenColls != null) {
                int in = _bgScenColls.size();
                for (int i = 0; i < in; ++i) {
                    _scenario = _bgScenColls.get(i);
                    scNumInnMap.put(_scenario.getNumber(), String.valueOf(_scenario.getScenarioId()));
                }
                numInnMap.put(DimensionConstants.DEF_SCENARIO_FIELD, scNumInnMap);
            }
            if ((_bgVerColls = BgVersionHelper.getVersionColls((Connection)conn, (Locale)ctx.getLocale())) != null) {
                int in = _bgVerColls.size();
                for (int i = 0; i < in; ++i) {
                    _version = _bgVerColls.get(i);
                    verNumInnMap.put(_version.getNumber(), String.valueOf(_version.getVersionId()));
                }
                numInnMap.put(DimensionConstants.DEF_VERSION_FIELD, verNumInnMap);
            }
            HashMap<String, Map<String, String>> hashMap = numInnMap;
            return hashMap;
        }
        catch (Exception e) {
            logger.error((Object)"getNumInnMap erorr ", (Throwable)e);
            throw new BOSException();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static List<String> convertCollection(List<BOSUuid> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return null;
        }
        ArrayList<String> targetList = new ArrayList<String>(sourceList.size());
        for (BOSUuid source : sourceList) {
            targetList.add(source.toString());
        }
        return targetList;
    }

    public static boolean isSaveQingData(Connection conn, String paramKey) throws EASBizException {
        IRowSet rst;
        boolean result;
        block6: {
            result = true;
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = ?", (Object[])new Object[]{paramKey});
                if (!rst.next()) break block6;
                try {
                    result = Boolean.parseBoolean(rst.getString(1));
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"IS_START_QING_SAVE param value trans error:", (Throwable)ex);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return result;
    }

    public static Set<String> getObjectIds(Collection<? extends CoreBaseInfo> data) {
        HashSet<String> ids = new HashSet<String>();
        if (data == null || data.isEmpty()) {
            return ids;
        }
        for (CoreBaseInfo coreBaseInfo : data) {
            if (coreBaseInfo == null || coreBaseInfo.getId() == null) continue;
            ids.add(coreBaseInfo.getId().toString());
        }
        return ids;
    }

    public void updateMemberPropToQingAnalyse(Map updateData, String viewId, String dimNumber) throws BOSException, EASBizException {
        MbgQingAnalyseIntegrateFactory.getRemoteInstance().updateMbgMemberProp(updateData, viewId, dimNumber);
    }
}

