/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.preparedata.handler.budget.IQingBudgetDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.ParentChildDimension;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingFieldType;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseIntegrateFactory;
import com.kingdee.eas.ma.mbg.RefBgPropertySortCollection;
import com.kingdee.eas.ma.mbg.RefBgPropertySortInfo;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgQingAnalyseIntegUtils
extends Thread
implements IQingBudgetDataProvider {
    private static Logger logger = Logger.getLogger((String)MbgQingAnalyseIntegUtils.class.getName());
    private Context ctx = null;
    private IDimensionParameter parameter = null;
    private Map<String, Object> bgDataMap = null;
    public static final String FIELD_NUM = "NUM";
    public static final String FIELD_PNUM = "PNUM";
    public static final String FIELD_ALIAS = "ALIAS";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_KEY = "key";
    public static final String DEFAULT_NUMBER = "NONE";
    public static final String FIELD_ORG_PROPERTYSORT = "ORG_PROPERTYSORT_";
    public static final String FIELD_ACC_PROPERTYSORT = "ACC_PROPERTYSORT_";
    public static final String FIELD_MBGDIM_PROPERTYSORT = "MBGDIM_PROPERTYSORT_";
    public static final String SORT_KEY = "sourceType".concat("!").concat("number");

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    protected void setParameter(IDimensionParameter parameter) {
        this.parameter = parameter;
    }

    protected IDimensionParameter getParameter() {
        return this.parameter;
    }

    protected void setBgDataMap(Map<String, Object> bgDataMap) {
        this.bgDataMap = bgDataMap;
    }

    protected Map<String, Object> getBgDataMap() {
        return this.bgDataMap;
    }

    public MbgQingAnalyseIntegUtils(Context ctx) {
        this.ctx = ctx;
    }

    public MbgQingAnalyseIntegUtils() {
    }

    public MbgQingAnalyseIntegUtils(Context ctx, IDimensionParameter parameter, Map<String, Object> bgDataMap) {
        this.ctx = ctx;
        this.parameter = parameter;
        this.bgDataMap = bgDataMap;
    }

    @Override
    public void run() {
        super.run();
        try {
            MbgQingAnalyseIntegrateFactory.getLocalInstance(this.getCtx()).saveQingAnalyseData(this.getParameter(), this.getBgDataMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<MbgDimInfo> getSchemeMbgDim(MbgDimCollection mbgColls, BgSchemeInfo bgScheme) {
        ArrayList<MbgDimInfo> mbgDims = new ArrayList<MbgDimInfo>();
        if (mbgColls == null || bgScheme == null) {
            return mbgDims;
        }
        MbgDimInfo mbgDim = null;
        Set<String> extDimNums = bgScheme.getExtDimNums();
        int in = mbgColls.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = mbgColls.get(i);
            if (DimensionBaseConstants.DEF_CSL_NUMBER.equals(mbgDim.getNumber()) || !DimUtils.checkBaseDimension(mbgDim.getNumber()) && !DimensionConstants.DEF_INDEX_NUMBER.equals(mbgDim.getNumber()) && !extDimNums.contains(mbgDim.getNumber())) continue;
            mbgDims.add(mbgDim);
        }
        DimUtils.sortMbgDimInfo(mbgDims);
        return mbgDims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QingMeta getMeta(String paramString) throws EASBizException, BOSException {
        QingMeta qingMeta = new QingMeta();
        if (this.getCtx() == null || StringUtils.isEmpty((String)paramString)) {
            return qingMeta;
        }
        String analyseId = paramString.split(",")[0];
        MbgQingAnalyseInfo mbgQingAnalyseInfo = MbgQingAnalyseFactory.getRemoteInstance().getMbgQingAnalyseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)analyseId)));
        String bgSchemeId = mbgQingAnalyseInfo.getBgSchemeId().toString();
        if (bgSchemeId == null) {
            return qingMeta;
        }
        MbgDimCollection mbgColls = null;
        BgSchemeInfo bgScheme = null;
        List<MbgDimInfo> mbgDims = null;
        BgPropertySortInfo info = null;
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field num = null;
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field pnum = null;
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field alias = null;
        Connection conn = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            mbgColls = DimUtils.getDimensionColls(this.getCtx());
            bgScheme = BgViewServerHelper.getBgSchemeCubeInfo(this.getCtx(), BOSUuid.read((String)bgSchemeId));
            if (mbgColls == null || mbgColls.isEmpty() || bgScheme == null) {
                QingMeta qingMeta2 = qingMeta;
                return qingMeta2;
            }
            mbgDims = MbgQingAnalyseIntegUtils.getSchemeMbgDim(mbgColls, bgScheme);
            MbgQingAnalyseIntegUtils.addBgProcessType(this.getCtx(), mbgDims);
            BgPropertySortCollection sorts = MbgQingAnalyseIntegUtils.getRefBgPropertyByScheme(bgScheme);
            qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(FIELD_KEY, FIELD_KEY, QingFieldType.String.toNumber(), null, null, true, null));
            for (MbgDimInfo mbgDim : mbgDims) {
                num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(mbgDim.getNumber() + "_" + FIELD_NUM, mbgDim.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)this.ctx.getLocale()), QingFieldType.String.toNumber(), null, null, false, null);
                pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(mbgDim.getNumber() + "_" + FIELD_PNUM, mbgDim.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysepnum", (Locale)this.ctx.getLocale()), QingFieldType.String.toNumber(), null, null, true, null);
                alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(mbgDim.getNumber() + "_" + FIELD_ALIAS, mbgDim.getName(), QingFieldType.String.toNumber(), null, null, false, null);
                this.addQingMeta(qingMeta, num, pnum, alias, mbgDim.getName());
            }
            int in = sorts.size();
            for (int i = 0; i < in; ++i) {
                info = sorts.get(i);
                num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), FIELD_NUM), info.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)this.ctx.getLocale()), QingFieldType.String.toNumber(), null, null, false, null);
                pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), FIELD_PNUM), info.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)this.ctx.getLocale()), QingFieldType.String.toNumber(), null, null, true, null);
                alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), FIELD_ALIAS), info.getName(), QingFieldType.String.toNumber(), null, null, false, null);
                this.addQingMeta(qingMeta, num, pnum, alias, info.getName());
            }
            qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(FIELD_VALUE, EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysevalue", (Locale)this.ctx.getLocale()), QingFieldType.Number.toNumber(), null, null, false, null));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return qingMeta;
    }

    private void addQingMeta(QingMeta qingMeta, com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field num, com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field pnum, com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field alias, String name) {
        qingMeta.addColumn((Field)num);
        qingMeta.addColumn((Field)pnum);
        qingMeta.addColumn((Field)alias);
        ParentChildDimension pcDimension = new ParentChildDimension(num.getName(), name, (Field)num, (Field)pnum);
        pcDimension.setDefaultDisplayName((Field)alias);
        pcDimension.setSortAccording((Field)num);
        qingMeta.addParentChildDimension((com.kingdee.bos.qing.preparedata.handler.controller.model.ParentChildDimension)pcDimension);
    }

    public static BgPropertySortCollection getRefBgPropertyByScheme(BgSchemeInfo bgScheme) {
        BgPropertySortCollection bgPropertySorts = new BgPropertySortCollection(){

            public void sort(final String propertyName) {
                if (!StringUtils.isEmpty((String)propertyName) && this.list != null && this.list.size() > 1) {
                    boolean TYPE = false;
                    boolean NUMBER = true;
                    Collections.sort(this.list, new Comparator<IObjectValue>(){

                        @Override
                        public int compare(IObjectValue o1, IObjectValue o2) {
                            String[] split = propertyName.split("!");
                            String k1 = ((String)o1.get(split[0])).concat((String)o1.get(split[1]));
                            String k2 = ((String)o2.get(split[0])).concat((String)o2.get(split[1]));
                            if (k1 != null && k2 != null) {
                                return k1 instanceof Comparable ? k1.compareTo(k2) : 0;
                            }
                            if (k1 == null && k2 == null) {
                                return 0;
                            }
                            return k1 == null ? -1 : 1;
                        }
                    });
                }
            }
        };
        RefBgPropertySortCollection refProp = bgScheme.getRefProp();
        if (refProp != null) {
            Iterator it = refProp.iterator();
            while (it.hasNext()) {
                bgPropertySorts.add(((RefBgPropertySortInfo)it.next()).getBgPropertySort());
            }
        }
        bgPropertySorts.sort(SORT_KEY);
        return bgPropertySorts;
    }

    public static String getPropFieldKey(String bosType, String propNumber, String field) {
        if ("33F82845".equals(bosType)) {
            return FIELD_ORG_PROPERTYSORT + propNumber + "_" + field;
        }
        if ("E68E9293".equals(bosType)) {
            return FIELD_ACC_PROPERTYSORT + propNumber + "_" + field;
        }
        if ("D177852B".equals(bosType)) {
            return FIELD_MBGDIM_PROPERTYSORT + propNumber + "_" + field;
        }
        return FIELD_ORG_PROPERTYSORT + propNumber + "_" + field;
    }

    public static void addBgProcessType(Context ctx, List<MbgDimInfo> mbgDims) {
        MbgDimInfo mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_PROCESSTYPE_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_PROCESS_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_PROCESS_SRCNUMBER);
        mbgDim.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgProcessResource", (String)"bgProcess", (Locale)ctx.getLocale()));
        mbgDims.add(mbgDim);
    }

    public List<String> getFiles(String paramString) throws EASBizException, BOSException {
        final ArrayList<String> qsFields = new ArrayList<String>();
        if (this.getCtx() == null || StringUtils.isEmpty((String)paramString)) {
            return qsFields;
        }
        String analyseId = paramString.split(",")[0];
        String selectedOrgUnitId = paramString.split(",")[1];
        MbgQingAnalyseInfo mbgQingAnalyseInfo = MbgQingAnalyseFactory.getRemoteInstance().getMbgQingAnalyseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)analyseId)));
        String bgSchemeId = mbgQingAnalyseInfo.getBgSchemeId().toString();
        String orgUnitId = mbgQingAnalyseInfo.getOrgUnitId().toString();
        if (!orgUnitId.equals(selectedOrgUnitId)) {
            orgUnitId = selectedOrgUnitId;
        }
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId));
        BgOrgViewInfo orgViewInfo = MbgQingAnalyseHelper.getOrgViewInfo(null, bgSchemeInfo);
        Map<String, String> orgUnitMap = MbgQingAnalyseHelper.getChildrenOrgUnit(null, orgUnitId, orgViewInfo.getId().toString());
        Set<String> childrenOrgUnitIds = orgUnitMap.keySet();
        StringBuffer sql = new StringBuffer();
        sql.append("select FQsId from T_MBG_MbgQingAnalyseInteg where FBgSchemeId = ? and FOrgUnitId in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Context)this.ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{bgSchemeId}, (Object[])childrenOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                if (!"000000000000000000000000000=".equals(res.getString(1))) {
                    qsFields.add(res.getString(1));
                }
            }
        });
        return qsFields;
    }

    public Map<String, List<String>> getFilter(String paramString) throws EASBizException, BOSException {
        HashMap<String, List<String>> filter = new HashMap<String, List<String>>();
        if (this.getCtx() == null || StringUtils.isEmpty((String)paramString)) {
            return filter;
        }
        String analyseId = paramString.split(",")[0];
        MbgQingAnalyseInfo analyseInfo = MbgQingAnalyseFactory.getRemoteInstance().getMbgQingAnalyseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)analyseId)));
        Map filterMap = MbgQingAnalyseFacadeFactory.getRemoteInstance().getQingAnalyseFilter(analyseInfo.getId().toString(), analyseInfo.getBgSchemeId().toString(), analyseInfo.getOrgUnitId().toString(), false);
        return filterMap;
    }
}

