/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgViewCollection;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.logger.MbgLoggerUtils;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewListMemberCacheHelper
implements Serializable {
    private static final long serialVersionUID = 4155865519211185386L;
    private static final Logger logger = Logger.getLogger((String)ViewListMemberCacheHelper.class.getName());
    private Context ctx = null;
    public static final int NO_FILL_TYPE = -1;
    private Map<String, Map<String, List<BgDimensionMember>>> memberCache = new HashMap<String, Map<String, List<BgDimensionMember>>>();
    private Map<String, Boolean> otherDimGlobal = new HashMap<String, Boolean>();
    private Map<String, MbgViewInfo> dimViewCacheMap = new HashMap<String, MbgViewInfo>();
    private Map<String, Map<String, Boolean>> isLeafMap = new HashMap<String, Map<String, Boolean>>();
    private BgSchemeDimensionHelper schemeHelper = null;
    private boolean isQueryId = false;
    Map<String, Map<String, String>> memberNameCache = new HashMap<String, Map<String, String>>();
    Map<String, Map<String, String>> memberIdCache = new HashMap<String, Map<String, String>>();

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public List<BgDimensionMember> getMembers(String dimNumber, String orgUnitId, boolean isGlobal, String memberNumber, int fillType) {
        if (!this.memberCache.containsKey(this.getKey(dimNumber, orgUnitId = this.getOrgUnitId(orgUnitId, isGlobal)))) {
            return null;
        }
        String key = this.getKey(memberNumber, fillType);
        return this.memberCache.get(this.getKey(dimNumber, orgUnitId)).get(key);
    }

    public boolean contains(String dimNumber, String orgUnitId, boolean isGlobal) {
        orgUnitId = this.getOrgUnitId(orgUnitId, isGlobal);
        return this.memberCache.containsKey(this.getKey(dimNumber, orgUnitId));
    }

    public void putMembers(String dimNumber, String orgUnitId, boolean isGlobal, String memberNumber, int fillType, List<BgDimensionMember> members) {
        if (!this.memberCache.containsKey(this.getKey(dimNumber, orgUnitId = this.getOrgUnitId(orgUnitId, isGlobal)))) {
            this.memberCache.put(this.getKey(dimNumber, orgUnitId), new HashMap());
        }
        String key = this.getKey(memberNumber, fillType);
        if (members == null) {
            members = new ArrayList<BgDimensionMember>();
        }
        this.memberCache.get(this.getKey(dimNumber, orgUnitId)).put(key, members);
    }

    private String getOrgUnitId(String orgUnitId, boolean isGlobal) {
        if (isGlobal) {
            return "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return orgUnitId;
    }

    private String getKey(String memberNumber, int fillType) {
        return memberNumber + "_" + fillType;
    }

    private String getKey(String dimNumber, String orgUnitId) {
        return dimNumber + "_" + orgUnitId;
    }

    public Map<String, MbgViewInfo> getDimViewCacheMap() throws BOSException {
        if (this.dimViewCacheMap.isEmpty()) {
            MbgViewCollection viewInfo = null;
            viewInfo = this.ctx == null ? MbgViewFactory.getRemoteInstance().getMbgViewCollection() : MbgViewFactory.getLocalInstance((Context)this.ctx).getMbgViewCollection();
            for (int i = 0; i < viewInfo.size(); ++i) {
                this.dimViewCacheMap.put(viewInfo.get(i).getId().toString(), viewInfo.get(i));
            }
        }
        return this.dimViewCacheMap;
    }

    public boolean isGlobal(String dimNumber, BgSchemeDimensionHelper schemeHelper) {
        if (!schemeHelper.getAccAndOtherDim(true).contains(dimNumber)) {
            return true;
        }
        if (!this.otherDimGlobal.containsKey(dimNumber)) {
            BgDimensionInfo dim = schemeHelper.getDimension(dimNumber);
            if (dim == null) {
                this.otherDimGlobal.put(dimNumber, Boolean.TRUE);
            } else {
                try {
                    if (this.getDimViewCacheMap().containsKey(dim.getViewId())) {
                        this.otherDimGlobal.put(dimNumber, MemberSegregationRuleEnum.SHAREDGLOBAL.equals((Object)this.getDimViewCacheMap().get(dim.getViewId()).getSegregationRule()));
                    } else {
                        this.otherDimGlobal.put(dimNumber, Boolean.TRUE);
                    }
                }
                catch (BOSException e) {
                    this.otherDimGlobal.put(dimNumber, Boolean.TRUE);
                }
            }
        }
        return this.otherDimGlobal.get(dimNumber);
    }

    public void setSchemeHelper(BgSchemeDimensionHelper schemeHelper) {
        this.schemeHelper = schemeHelper;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.schemeHelper;
    }

    public boolean isInCache(String orgUnitId, String srcNumber, String number) {
        String orgId = this.getOrgUnitId(orgUnitId, this.isGlobal(this.schemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber(), this.schemeHelper));
        return this.isInCache1(orgId, srcNumber, number);
    }

    private boolean isInCache1(String orgUnitId, String srcNumber, String number) {
        return this.isLeafMap.get(orgUnitId) != null && this.isLeafMap.get(orgUnitId).containsKey(DimensionFormulaHelper.getCombination(srcNumber, number));
    }

    public Map<String, Set<String>> removeInChache(String orgUnitId, Map<String, Set<String>> members) {
        if (StringUtils.isEmpty((String)orgUnitId) || members == null || members.isEmpty()) {
            return members;
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        String orgId = null;
        String number2 = null;
        Set<String> subSet = null;
        HashSet<String> subResult = null;
        for (String srcNumber : members.keySet()) {
            if (StringUtils.isEmpty((String)srcNumber)) continue;
            subSet = members.get(srcNumber);
            subResult = new HashSet<String>();
            result.put(srcNumber, subResult);
            orgId = this.getOrgUnitId(orgUnitId, this.isGlobal(this.schemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber(), this.schemeHelper));
            for (String number2 : subSet) {
                if (this.isInCache1(orgId, srcNumber, number2)) continue;
                subResult.add(number2);
            }
        }
        return result;
    }

    public Map<String, Set<String>> margeLeafMap(String orgUnitId, Map<String, Set<String>> members, Map<String, Set<String>> leafMap) {
        if (leafMap == null) {
            leafMap = new HashMap<String, Set<String>>();
        }
        String orgId = null;
        String combinNumber = null;
        Set<String> subSet = null;
        Set<String> subLeafSet = null;
        for (String srcNumber : members.keySet()) {
            subSet = members.get(srcNumber);
            if (!leafMap.containsKey(srcNumber)) {
                leafMap.put(srcNumber, new HashSet());
            }
            subLeafSet = leafMap.get(srcNumber);
            orgId = this.getOrgUnitId(orgUnitId, this.isGlobal(this.schemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber(), this.schemeHelper));
            if (!this.isLeafMap.containsKey(orgId)) {
                this.isLeafMap.put(orgId, new HashMap());
            }
            for (String number : subSet) {
                combinNumber = DimensionFormulaHelper.getCombination(srcNumber, number);
                if (subLeafSet.contains(number)) {
                    this.isLeafMap.get(orgId).put(combinNumber, true);
                    continue;
                }
                if (this.isInCache1(orgId, srcNumber, number)) {
                    if (!this.isLeafMap.get(orgId).get(combinNumber).booleanValue()) continue;
                    subLeafSet.add(number);
                    continue;
                }
                this.isLeafMap.get(orgId).put(combinNumber, false);
            }
        }
        return leafMap;
    }

    public void setQueryId(boolean isQueryId) {
        this.isQueryId = isQueryId;
    }

    public void updateMemberName(String orgUnitId, String dimNumber, Map<String, BgDimensionMember> memberMap) throws EASBizException, BOSException {
        Map<String, Map<String, String>> memberNameCache = this.memberNameCache;
        if (this.isQueryId) {
            memberNameCache = this.memberIdCache;
        }
        if (!memberNameCache.containsKey(dimNumber)) {
            memberNameCache.put(dimNumber, new HashMap());
        }
        Map<String, String> subMap = memberNameCache.get(dimNumber);
        HashSet<String> querySet = new HashSet<String>();
        for (BgDimensionMember member : memberMap.values()) {
            if (subMap.containsKey(member.getNumber())) continue;
            querySet.add(member.getNumber());
        }
        if (!querySet.isEmpty()) {
            BgDimensionInfo dim = this.getSchemeHelper().getDimensionOnCheck(dimNumber);
            long st = System.currentTimeMillis();
            DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance(this.ctx, dim, orgUnitId, this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getBgOrgViewId(), null);
            TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
            String tempIds = null;
            Connection conn = null;
            int USE_TMP_COUNT = 200;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                if (querySet.size() > 200) {
                    MbgLoggerUtils.logger((String)("Start Insert Key:" + (System.currentTimeMillis() - st)));
                    tempIds = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, querySet, (String)"NVarchar(80)");
                    MbgLoggerUtils.logger((String)("End Insert Key:" + (System.currentTimeMillis() - st)));
                }
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("number");
                if (this.isQueryId) {
                    evi.getSelector().add("id");
                } else {
                    evi.getSelector().add("name");
                }
                if (this.getDimViewCacheMap().containsKey(dim.getViewId())) {
                    helper.setSegregationRule(this.getDimViewCacheMap().get(dim.getViewId()).getSegregationRule().getValue());
                    evi.setFilter(helper.getFilter(this.getDimViewCacheMap().get(dim.getViewId()).getSegregationRule().getValue() != 1));
                } else {
                    evi.setFilter(helper.getFilter());
                }
                if (querySet.size() > 200) {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)("Select FID FROM " + tempIds), CompareType.INNER));
                } else {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", querySet, CompareType.INCLUDE));
                }
                IDataProvider dataProvider = helper.getQueryExecutor();
                dataProvider.setObjectView(evi);
                MbgLoggerUtils.logger((String)("Start Execute Query:" + (System.currentTimeMillis() - st)));
                IRowSet rowset = dataProvider.executeQuery();
                MbgLoggerUtils.logger((String)("End Execute Query:" + (System.currentTimeMillis() - st)));
                while (rowset.next()) {
                    String number = rowset.getString("number");
                    String name = this.isQueryId ? rowset.getString("id") : rowset.getString("name");
                    subMap.put(number, name);
                }
                MbgLoggerUtils.logger((String)("End Result Fitch:" + (System.currentTimeMillis() - st)));
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tempIds);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempIds);
            SQLUtils.cleanup((Connection)conn);
        }
        for (BgDimensionMember member : memberMap.values()) {
            if (!subMap.containsKey(member.getNumber())) continue;
            member.setName(subMap.get(member.getNumber()));
        }
    }

    public static Map<String, List<BgDimensionMember>> queryPropertyMember(Context ctx, Connection conn, String orgId, Set<String> propSet, String bgAccountViewId, List<String> mbgDimViewIds, String bgOrgViewId) throws EASBizException, BOSException {
        HashMap<String, List<BgDimensionMember>> result = new HashMap<String, List<BgDimensionMember>>();
        if (propSet == null || propSet.isEmpty()) {
            return result;
        }
        HashSet<String> newPropSet = new HashSet<String>(propSet);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            String longNumber;
            String id;
            int i;
            StringBuffer sql = new StringBuffer();
            HashMap<String, Set<String>> childPropMap = new HashMap<String, Set<String>>();
            HashMap parentLongNumber = new HashMap();
            sql.setLength(0);
            sql.append("Select FID, FBgPropertySortID, FLongNumber, FIsLeaf FROM T_MBG_BgProperty Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FBgPropertySortID, FLongNumber");
            List paramList = MbgSqlHelper.getBatchParams(null, (Object[])newPropSet.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < paramList.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (rst.getBoolean("FIsLeaf")) continue;
                    id = rst.getString("FID");
                    String propSortId = rst.getString("FBgPropertySortID");
                    longNumber = rst.getString("FLongNumber") + "!%";
                    if (!parentLongNumber.containsKey(propSortId)) {
                        parentLongNumber.put(propSortId, new HashMap());
                    }
                    ((Map)parentLongNumber.get(propSortId)).put(longNumber, id);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            sql.setLength(0);
            sql.append("Select FID, FLongNumber FROM T_MBG_BgProperty Where FBgPropertySortID = ? AND (");
            for (i = 0; i < 50; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(" FLongNumber LIKE ? ");
            }
            sql.append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (String propSortId : parentLongNumber.keySet()) {
                paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{propSortId}, (Object[])((Map)parentLongNumber.get(propSortId)).keySet().toArray(), (int)50);
                for (int i2 = 0; i2 < paramList.size(); ++i2) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i2)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        id = rst.getString("FID");
                        newPropSet.add(id);
                        longNumber = rst.getString("FLongNumber");
                        ViewListMemberCacheHelper.addToParent(childPropMap, (Map)parentLongNumber.get(propSortId), id, longNumber);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            HashMap propMap = new HashMap();
            String sourceType2 = null;
            sql.setLength(0);
            sql.append("Select prop.FID, propSort.FSourceType FROM T_MBG_BgProperty prop INNER JOIN T_MBG_BgPropertySort propSort ON propSort.FID = prop.FBgPropertySortID Where prop.FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            paramList = MbgSqlHelper.getBatchParams(null, (Object[])newPropSet.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i3 = 0; i3 < paramList.size(); ++i3) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i3)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    sourceType2 = rst.getString("FSourceType");
                    if (!propMap.containsKey(sourceType2)) {
                        propMap.put(sourceType2, new HashSet());
                    }
                    ((Set)propMap.get(sourceType2)).add(rst.getString("FID"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            for (String sourceType2 : propMap.keySet()) {
                sql.setLength(0);
                if ("E68E9293".equals(sourceType2)) {
                    sql.append("Select acct.FID, acct.FNumber, acct.FName_" + ctx.getLocale() + " FName, acct.FLongNumber, acct.FIsLeaf, prop.FPropertyID ,acct.FDisabledDate FROM T_MBG_PropertyRefSource prop INNER JOIN T_MBG_BgAccount acct ON prop.FSourceID =  acct.FID Where acct.FBgAccountViewID = ? AND prop.FPropertyID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                    paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{bgAccountViewId}, (Object[])((Set)propMap.get(sourceType2)).toArray(), (int)50);
                } else if ("33F82845".equals(sourceType2)) {
                    sql.append("Select bgOrg.FOrgUnitID FID, bgOrg.FNumber, bgOrg.FName_" + ctx.getLocale() + " FName, bgOrg.FLongNumber, bgOrg.FIsLeaf, prop.FPropertyID FROM T_MBG_PropertyRefSource prop INNER JOIN T_MBG_BgOrgUnit bgOrg ON prop.FSourceID =  bgOrg.FID Where bgOrg.FViewID = ? AND prop.FPropertyID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                    paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{bgOrgViewId}, (Object[])((Set)propMap.get(sourceType2)).toArray(), (int)50);
                } else if ("D177852B".equals(sourceType2)) {
                    sql.append("Select memb.FID, memb.FNumber, memb.FName_" + ctx.getLocale() + " FName, memb.FLongNumber,dim.FSrcNumber, memb.FIsLeaf, prop.FPropertyID ,memb.FDisabledDate FROM T_MBG_PropertyRefSource prop INNER JOIN T_MBG_MbgMember memb ON memb.FID = prop.FSourceID  inner join T_MBG_MbgDim dim on memb.FMbgDimID = dim.FID Where memb.FViewId IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)mbgDimViewIds.size()).append(")").append(" AND prop.FPropertyID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                    paramList = MbgSqlHelper.getBatchParams((Object[])mbgDimViewIds.toArray(), (Object[])((Set)propMap.get(sourceType2)).toArray(), (int)50);
                }
                if (sql.length() <= 0) continue;
                pstmt = conn.prepareStatement(sql.toString());
                for (int i4 = 0; i4 < paramList.size(); ++i4) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i4)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        String propId = rst.getString("FPropertyID");
                        if (!result.containsKey(propId)) {
                            result.put(propId, new ArrayList());
                        }
                        BgDimensionMember member = new BgDimensionMember(null, rst.getString("FID"), rst.getString("FName"), rst.getString("FNumber"));
                        member.setSortValue((Comparable)((Object)rst.getString("FLongNumber")));
                        member.setLeaf(rst.getBoolean("FIsLeaf"));
                        if ("D177852B".equals(sourceType2)) {
                            member.setSrcNumber(rst.getString("FSrcNumber"));
                            member.setDisabledDate(rst.getTimestamp("FDisabledDate"));
                        } else if ("E68E9293".equals(sourceType2)) {
                            member.setSrcNumber(DimensionBaseConstants.DEF_INDEX_SRCNUMBER);
                            member.setDisabledDate(rst.getTimestamp("FDisabledDate"));
                        } else if ("33F82845".equals(sourceType2)) {
                            member.setSrcNumber(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER);
                        }
                        ((List)result.get(propId)).add(member);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            ArrayList repeatList = new ArrayList();
            for (String key : result.keySet()) {
                List lst = (List)result.get(key);
                repeatList.addAll(lst);
            }
            Iterator itParent = childPropMap.keySet().iterator();
            while (itParent.hasNext()) {
                List parentMember = null;
                id = (String)itParent.next();
                for (String childId : (Set)childPropMap.get(id)) {
                    List childMember = (List)result.get(childId);
                    if (childMember == null || childMember.isEmpty()) continue;
                    if (!result.containsKey(id)) {
                        result.put(id, new ArrayList());
                        for (BgDimensionMember member : childMember) {
                            if (propSet.contains(childId)) {
                                if (repeatList.contains(member)) continue;
                                ((List)result.get(id)).add(member);
                                continue;
                            }
                            ((List)result.get(id)).add(member);
                        }
                        continue;
                    }
                    parentMember = (List)result.get(id);
                    for (int i5 = 0; i5 < childMember.size(); ++i5) {
                        if (!propSet.contains(id) || propSet.contains(childId) || parentMember.contains(childMember.get(i5))) continue;
                        parentMember.add(childMember.get(i5));
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return result;
    }

    private static void addToParent(Map<String, Set<String>> childPropMap, Map<String, String> parentLongNumber, String id, String longNumber) {
        if (childPropMap == null || parentLongNumber == null || parentLongNumber.isEmpty() || StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)longNumber)) {
            return;
        }
        int lastIndex = longNumber.lastIndexOf("!");
        if (lastIndex < 0) {
            return;
        }
        String parentId = parentLongNumber.get((longNumber = longNumber.substring(0, lastIndex)) + "!%");
        if (parentId != null) {
            if (!childPropMap.containsKey(parentId)) {
                childPropMap.put(parentId, new HashSet());
            }
            childPropMap.get(parentId).add(id);
        }
        ViewListMemberCacheHelper.addToParent(childPropMap, parentLongNumber, id, longNumber);
    }
}

