/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.analysisReport;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.mbg.BgAnalysReportInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.util.PropertyContainer;
import java.util.Date;

public class BgAnalysRptPropertyAdapter
extends BgRptReportPropertyAdapter {
    private static final long serialVersionUID = 3352136649937094278L;
    private String orgTreeNumber = null;

    public void setOrgTreeNumber(String orgTreeNumber) {
        this.orgTreeNumber = orgTreeNumber;
    }

    public BgAnalysRptPropertyAdapter() {
    }

    public BgAnalysRptPropertyAdapter(BgAnalysReportInfo report) {
        this.setProperties(report);
    }

    private void setProperties(BgAnalysReportInfo report) {
        FullOrgUnitInfo costCenter;
        String treeId;
        if (this.p == null) {
            this.p = new PropertyContainer();
        }
        if (report.getOrgUnit() != null && report.getOrgUnit().getId() != null) {
            this.p.setString("Company.Name", report.getOrgUnit().getName());
            this.p.setString("Company.Number", report.getOrgUnit().getNumber());
            this.p.setString("Company.ID", report.getOrgUnit().getId().toString());
        }
        if ((treeId = report.getString("tree.id")) != null) {
            this.p.setString("CSLReport_OrgTree_Number", this.orgTreeNumber);
            this.p.setString("CSLReport_OrgUnit_Group", report.getOrgUnit().getNumber());
            this.p.setString("CSLReport_OrgTree_ID", treeId);
        }
        FullOrgUnitInfo org = report.getOrgUnit();
        this.setOrgUnit(org);
        this.p.setString("BG_TEMPLATE_ID", report.getBgTemplate().getId().toString());
        if (report.getBgScheme() != null) {
            this.p.setString("BG_SCHEME_NUMBER", report.getBgScheme().getNumber());
        }
        if (BgNFSHelper.getFormulaMap((IObjectValue)report) != null) {
            this.p.put("Report_FormulaMap", (Object)BgNFSHelper.getFormulaMap((IObjectValue)report));
        }
        BgPeriodInfo period = report.getBgPeriod();
        if (report.getBgPeriod() != null) {
            this.p.setString("bg_begin_date", String.valueOf(report.getBgPeriod().getBeginDate()));
            this.p.setDate("Report_StartDate", report.getBgPeriod().getBeginDate());
            this.p.setString("bg_end_date", String.valueOf(report.getBgPeriod().getEndDate()));
            this.p.setDate("Report_EndDate", report.getBgPeriod().getEndDate());
        }
        this.p.setDate("bg_create_date", report.getCreateTime() != null ? new Date(report.getCreateTime().getTime()) : new Date());
        if (period != null) {
            String id = period.getId().toString();
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            this.p.setString("BG_PERIOD_ID", id);
            this.p.setString("BG_PERIOD_NUMBER", period.getNumber());
            if (period.getPeriodType() != null) {
                this.p.setInt("BG_PERIOD_TYPE", period.getPeriodType().getValue());
                this.p.setInt("BG_PERIOD_YEAR", period.getYear());
            }
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    report.setInt("periodType", 6);
                    report.setInt("year", year);
                    report.setShort("period", (short)1);
                } else if (periodType.getValue() == 2) {
                    report.setInt("periodType", 5);
                    report.setInt("year", year);
                    report.setShort("period", (short)halfYear);
                    this.p.setInt("BG_PERIOD_MONTH", period.getHalfYear());
                } else if (periodType.getValue() == 3) {
                    report.setInt("periodType", 4);
                    report.setInt("year", year);
                    report.setShort("period", (short)quart);
                    this.p.setInt("BG_PERIOD_MONTH", period.getQuarter());
                } else if (periodType.getValue() == 4) {
                    report.setInt("periodType", 3);
                    report.setInt("year", year);
                    report.setShort("period", (short)month);
                    this.p.setInt("BG_PERIOD_MONTH", period.getMonth());
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    report.setInt("periodType", 3);
                    report.setInt("year", year);
                    report.setShort("period", (short)month);
                    this.p.setInt("BG_PERIOD_MONTH", period.getWeek());
                }
            }
        }
        this.p.setInt("Report.Year", report.getInt("year"));
        this.p.setInt("Report.Period", (int)report.getShort("period"));
        if (report.getCurrency() != null) {
            this.p.setString("Currency.Number", report.getCurrency().getNumber());
        }
        if (report.getLastUpdateUser() != null) {
            this.p.setString("LastUpdater.Name", report.getLastUpdateUser().getName());
        }
        this.p.setString("Report.Name", report.getName());
        if (report.getCU() != null) {
            this.p.setString("CU.Name", report.getCU().getId().toString());
        }
        if (report.getCreator() != null) {
            this.p.setString("Creater.Name", report.getCreator().getName());
        }
        if ((costCenter = report.getOrgUnit()) != null) {
            this.p.setString("BgCostCenterNum", costCenter.getNumber());
        }
        if (report.containsKey("periodType")) {
            this.p.setInt("PeriodType", report.getInt("periodType"));
        }
        if (report.getBgVersion() != null) {
            this.p.setString("BG_VERSION_NUMBER", report.getBgVersion().getNumber());
        }
        this.p.setInt("BG_FORM_STATE", report.getState().getValue());
        if (report.getProcessType() == null) {
            report.setProcessType(BgProcessEnum.C01);
        }
        this.p.setString("BG_FORM_PROCESSTYPE", report.getProcessType().getName());
    }
}

