/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.IBgExamineFacade;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgClosureMapUtils;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBgExamineUtils;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class BaseBiz {
    private static final Logger logger = Logger.getLogger(BaseBiz.class);
    Map<String, Set<String>> closureMap = null;
    private BizMbgDataControlUtils utils = null;
    private Set<String> processBillId = new HashSet<String>();
    private boolean processEnd = false;
    private Map<BOSUuid, Boolean> checkMap = new HashMap<BOSUuid, Boolean>();

    private Map<String, Set<String>> getClosureMap() {
        return this.closureMap;
    }

    private void setClosureMap(Map<String, Set<String>> closureMap) {
        this.closureMap = closureMap;
    }

    protected BizMbgDataControlUtils getUtils() {
        return this.utils;
    }

    public BaseBiz(BizMbgDataControlUtils utils) {
        this.utils = utils;
    }

    protected void process(Context ctx, List<String> billIds, Map<String, String> auditParams, AuditParam param, Map<String, Object> result) throws BOSException, EASBizException {
        if (ctx == null || billIds == null || billIds.isEmpty() || auditParams == null || param == null || result == null || this.getUtils() == null) {
            return;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin process BgForm ! ");
        BgOrgUnitInfo bgOrgUnit = null;
        BgOrgUnitInfo curBgOrgUnit = null;
        List<String> cOrgUnitIds = null;
        List<String> pOrgUnitIds = null;
        List<String> orgUnitIds = null;
        HashSet<String> checkOrgIds = new HashSet<String>();
        IObjectPK logPk = null;
        ArrayList<String> curOrgTreeOrgUnitIds = new ArrayList<String>();
        Object auditOrgUnitId = null;
        Object tempId = null;
        HashMap<String, String> curIdToOrgUnitId = new HashMap<String, String>();
        HashMap<String, String> curOrgUnitIdToParentId = new HashMap<String, String>();
        Connection conn = null;
        param.pool = TempTablePool.getInstance((Context)ctx);
        Thread thread = null;
        Boolean supportAuditRunBack = BgParamUtils.supportAuditRunBack(ctx);
        try {
            int i;
            conn = BgDBUtils.getConnection((Context)ctx);
            if (param.bgScheme == null) {
                param.bgScheme = MbgDataHelper.getBgSchemeInfo(conn, ctx.getLocale(), BOSUuid.read((String)param.audSchemeId));
            }
            param.bgOrgViewId = param.bgScheme.getEditOrgViewId();
            param.auditMbgDims = param.bgScheme.getAuditMbgDim(param.unionId != null);
            param.initTmpTable();
            param.cubeName = this.getCubeName(param);
            param.cubeEntry = this.getEntryName(param);
            this.queryAudOrgUnit(ctx, conn, param);
            this.checkCube(conn, param.bgScheme.getRefCube());
            if ((param.auditType == 10 || param.auditType == 1) && param.audOrgUnit != null) {
                List<String> longnumber = Arrays.asList(param.audOrgUnit.getLongNumber().split("!"));
                CoreBaseCollection collection = BgOrgUnitFactory.getLocalInstance(ctx).getCollection("select fid,number, orgUnitID,parent.id,longNumber,isVirtual where viewId = '" + param.bgOrgViewId + "'");
                for (i = 0; i < collection.size(); ++i) {
                    bgOrgUnit = (BgOrgUnitInfo)collection.get(i);
                    if (!bgOrgUnit.isIsVirtual()) {
                        curIdToOrgUnitId.put(bgOrgUnit.getId().toString(), bgOrgUnit.getOrgUnitID());
                        curOrgUnitIdToParentId.put(bgOrgUnit.getOrgUnitID(), bgOrgUnit.getParent() == null ? null : bgOrgUnit.getParent().getId().toString());
                    }
                    if (bgOrgUnit.getLongNumber() == null || !longnumber.contains(bgOrgUnit.getNumber()) && !bgOrgUnit.getLongNumber().startsWith(param.audOrgUnit.getLongNumber())) continue;
                    curOrgTreeOrgUnitIds.add(bgOrgUnit.getOrgUnitID());
                }
            }
            pOrgUnitIds = this.getParentOrgUnitIds(ctx, conn, param);
            IEnactmentService iEnactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
            if (this.isCheckParentNoEdit()) {
                BaseBiz.queryParentNoEdit(conn, billIds, param);
            }
            BgClosureMapUtils bgClosureMapUtils = new BgClosureMapUtils(param.bgScheme, conn);
            this.setClosureMap(bgClosureMapUtils.getClosureMap());
            int in = billIds.size();
            for (i = 0; i < in; ++i) {
                String billId;
                param.currtBillId = billId = billIds.get(i);
                IDimDataQuery model = this.getUtils().queryData(param, conn, billId);
                if (DimensionCommonHelper.isDecompose(model.getProcessType())) {
                    param.cubeName = BgCubeUtils.getCubeName(param.bgScheme.getRefCube(), DimensionCommonHelper.getDataType(model.getProcessType()));
                    param.cubeEntry = BgCubeUtils.getCubeEntryName(param.bgScheme.getRefCube(), DimensionCommonHelper.getDataType(model.getProcessType()));
                } else {
                    param.cubeName = this.getCubeName(param);
                    param.cubeEntry = this.getEntryName(param);
                }
                logPk = this.beginLog(ctx, model, param);
                bgOrgUnit = this.queryOrgUnit(ctx, conn, param, model.getBizOrgUnit().getId());
                cOrgUnitIds = this.getChildOrgUnitIds(ctx, conn, bgOrgUnit, param, false, model);
                if (param.tmpOrgUnit == null) {
                    param.tmpOrgUnit = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpOrgUnit, (String)"FID", (boolean)false, (boolean)false);
                } else {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + param.tmpOrgUnit));
                }
                if (bgOrgUnit != null) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + param.tmpOrgUnit + " (FID) values (?)"), (Object[])new Object[]{bgOrgUnit.getOrgUnitID()});
                }
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + param.tmpOrgUnit + " (FID) values (?)"), cOrgUnitIds);
                if (param.tmpPOrgUnit == null) {
                    param.tmpPOrgUnit = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpPOrgUnit, (String)"FID", (boolean)false, (boolean)false);
                } else {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + param.tmpPOrgUnit));
                }
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + param.tmpPOrgUnit + " (FID) values (?)"), pOrgUnitIds);
                if (param.tmpAudOrgUnit == null) {
                    param.tmpAudOrgUnit = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpAudOrgUnit, (String)"FID", (boolean)false, (boolean)false);
                }
                List<IDimDataQuery> models = this.getModels(conn, model, param);
                this.processSplitTable(ctx, conn, models, param.getSchemeHelper(), param);
                boolean isOnlyDealCurBgForm = model.isOnlyDealCurBgForm();
                if (this.checkAllData(ctx, conn, model, models, cOrgUnitIds, pOrgUnitIds, param, result, isOnlyDealCurBgForm)) {
                    if (Boolean.valueOf(auditParams.get("CHECK_EXAMINE")).booleanValue()) {
                        List results;
                        Object obj;
                        ArrayList checks = new ArrayList();
                        for (IDimDataQuery _model : models) {
                            checks.add(_model.getId().toString());
                        }
                        IBgExamineFacade iBgExamineFacade = BgExamineFacadeFactory.getLocalInstance(ctx);
                        if (iBgExamineFacade.canExamine(checks) && (obj = iBgExamineFacade.examines(checks)) instanceof List && !MBgExamineUtils.check(results = (List)obj)) {
                            result.put("CHECK_RESULT_EXAMINE", results);
                            return;
                        }
                    }
                    for (IDimDataQuery iDimDataQuery : models) {
                        boolean hasData;
                        IDimDataQuery iDimDataQuery2 = this.getUtils().queryData(param, conn, iDimDataQuery.getId().toString());
                        if (!model.getId().equals((Object)iDimDataQuery2.getId()) && (!param.isSynChildForm || BizMbgDataControlUtils.checkWorkFlow(iEnactmentService, iDimDataQuery2, result))) continue;
                        logger.debug((Object)("begin model : number = " + iDimDataQuery2.getNumber()));
                        this.clearData(conn, param);
                        if (param.unionId == null) {
                            curBgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgOrgViewId, iDimDataQuery2.getBizOrgUnit().getId(), false);
                            checkOrgIds.add(curBgOrgUnit.getOrgUnitID());
                        }
                        if (hasData = this.hasData(conn, param, iDimDataQuery2.getBizOrgUnit().getId(), result)) {
                            orgUnitIds = this.getAudOrgUnitIds(ctx, conn, curBgOrgUnit, param);
                            try {
                                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + param.tmpAudOrgUnit));
                                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + param.tmpAudOrgUnit + " (FID) values (?)"), orgUnitIds);
                                this.checkData(ctx, conn, iDimDataQuery2, curBgOrgUnit, orgUnitIds, pOrgUnitIds, param, result, isOnlyDealCurBgForm);
                                this.updateBase(ctx, conn, iDimDataQuery2, curBgOrgUnit, orgUnitIds, pOrgUnitIds, param, result);
                                if (!isOnlyDealCurBgForm || param.auditType == 3) {
                                    this.updateView(ctx, conn, iDimDataQuery2, curBgOrgUnit, orgUnitIds, pOrgUnitIds, param, result);
                                }
                            }
                            catch (BOSException ex) {
                                throw ex;
                            }
                            catch (EASBizException ex) {
                                throw ex;
                            }
                        }
                        if (!(model.getId().equals((Object)iDimDataQuery2.getId()) || param.auditType != 10 && param.auditType != 1)) {
                            if (billIds.contains(iDimDataQuery2.getId().toString())) continue;
                            this.dealunAuditAndUncerti(conn, param, (BgFormInfo)iDimDataQuery2, curIdToOrgUnitId, curOrgUnitIdToParentId, curOrgTreeOrgUnitIds);
                            continue;
                        }
                        this.updateFormData(conn, iDimDataQuery2, curBgOrgUnit, param);
                        this.succeed(iDimDataQuery2, param, result);
                        this.updateAuditRecord(ctx, conn, ctx.getLocale(), iDimDataQuery2, auditParams, param);
                        logger.debug((Object)("end bgForm : number = " + iDimDataQuery2.getNumber()));
                    }
                    if (!cOrgUnitIds.isEmpty()) {
                        ArrayList<String> noCheckOrgIds = new ArrayList<String>();
                        for (String cOrgUnitId : cOrgUnitIds) {
                            if (checkOrgIds.contains(cOrgUnitId) || !this.hasData(conn, param, BOSUuid.read((String)cOrgUnitId), result)) continue;
                            noCheckOrgIds.add(cOrgUnitId);
                        }
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        hashSet.add(7);
                        hashSet.add(9);
                        hashSet.add(10);
                        hashSet.add(8);
                        hashSet.add(0);
                        hashSet.add(1);
                        if (supportAuditRunBack.booleanValue() && hashSet.contains(param.auditType)) {
                            thread = new UpdateDateRunner(ctx, conn, param, noCheckOrgIds, model, pOrgUnitIds, result);
                            thread.start();
                        } else if (!noCheckOrgIds.isEmpty()) {
                            long noCheckTimeBegin = System.currentTimeMillis();
                            logger.debug((Object)"begin process noCheckOrgIds updateView data ");
                            for (String cOrgUnitId : noCheckOrgIds) {
                                curBgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgOrgViewId, BOSUuid.read((String)cOrgUnitId), false);
                                orgUnitIds = this.getAudOrgUnitIds(ctx, conn, curBgOrgUnit, param);
                                try {
                                    BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + param.tmpAudOrgUnit));
                                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + param.tmpAudOrgUnit + " (FID) values (?)"), orgUnitIds);
                                    this.checkData(ctx, conn, model, curBgOrgUnit, orgUnitIds, pOrgUnitIds, param, result, isOnlyDealCurBgForm);
                                    if (isOnlyDealCurBgForm) continue;
                                    this.updateView(ctx, conn, model, curBgOrgUnit, orgUnitIds, pOrgUnitIds, param, result);
                                }
                                catch (BOSException ex) {
                                    throw ex;
                                }
                                catch (EASBizException ex) {
                                    throw ex;
                                }
                            }
                            logger.debug((Object)("end process noCheckOrgIds updateView data = " + (System.currentTimeMillis() - noCheckTimeBegin) + "ms. "));
                        }
                    }
                    this.afterProcess(ctx, conn, param);
                    this.afterLog(ctx, logPk);
                    continue;
                }
                if (!this.checkIsInProInst(ctx, model.getId()) || !BaseBiz.checkParentNoEdit(model, param, result)) continue;
                if (param.unionId == null) {
                    curBgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgOrgViewId, model.getBizOrgUnit().getId(), false);
                }
                this.updateFormData(conn, model, curBgOrgUnit, param);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (thread == null || thread.getState() != Thread.State.RUNNABLE) {
                param.release();
                SQLUtils.cleanup((Connection)conn);
            }
        }
        this.processEnd = true;
        logger.debug((Object)("end process BgForm ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
    }

    protected void processSplitTable(Context ctx, Connection conn, List<IDimDataQuery> models, BgSchemeDimensionHelper schemeHelper, AuditParam param) throws Exception {
        param.cubes.clear();
        HashSet<String> accNumbers = new HashSet<String>();
        for (IDimDataQuery model : models) {
            IMbgViewBase view = param.getCacheView(ctx, model = param.getCacheValue(conn, model.getId().toString(), this.getUtils()));
            Map<String, Set<String>> mbgMemberMap = MbgDataHelper.parseMbgMember(view);
            if (!mbgMemberMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) continue;
            accNumbers.addAll((Collection<String>)mbgMemberMap.get(DimensionConstants.DEF_BGINDEX_FIELD));
        }
        param.cubes.addAll(param.getAccIntHelper().getSplitTablesByAcc(accNumbers));
    }

    private void dealunAuditAndUncerti(Connection conn, AuditParam param, BgFormInfo model, Map<String, String> curIdToOrgUnitId, Map<String, String> curOrgUnitIdToParentId, List<String> curOrgTreeOrgUnitIds) throws Exception {
        String auditOrgUnitId = null;
        String tempId = null;
        if (model.getAuditOrgUnit() != null) {
            auditOrgUnitId = model.getAuditOrgUnit().getId().toString();
            if (!curOrgTreeOrgUnitIds.contains(auditOrgUnitId)) {
                return;
            }
        } else {
            return;
        }
        String sql = "update T_MBg_BgForm set FauditOrgUnitID = ? where FID = ?";
        if (param.auditType == 10) {
            tempId = curOrgUnitIdToParentId.get(model.getBizOrgUnit().getId().toString());
            auditOrgUnitId = curIdToOrgUnitId.get(tempId);
        } else if (param.auditType == 1) {
            auditOrgUnitId = model.getBizOrgUnit().getId().toString();
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)sql, (Object[])new Object[]{auditOrgUnitId, model.getId().toString()});
    }

    public static void queryParentNoEdit(Connection conn, List<String> billIds, final AuditParam param) throws BOSException {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bgForm.FID, bgForm.FBgSchemeId, bgForm.FBgTemplateId, bgForm.FCurrencyId, bgForm.FBgPeriodId, bgForm.FBgVersionId, spcialItem.FDimensionNumber,bgForm.FOrgUnitId, org.FNumber FOrgUnitNumber, org.FName_").append(param.ctx.getLocale()).append(" FOrgName").append(" FROM T_MBG_BgForm bgForm ").append(" Inner Join T_MBG_BgOrgUnit org ON org.FOrgUnitID = bgForm.FOrgUnitId AND org.FViewId = '").append(param.bgOrgViewId).append("' AND org.FIsVirtual = 0 AND org.FIsLeaf = 0").append(" Left Join T_MBG_BgSpecialItems spcialItem ON bgForm.FID = spcialItem.FBgFormId ").append(" Where FProcessType = ").append(1).append(" AND FState <> ").append(42).append(" AND FState <> ").append(1).append(" AND FState <> ").append(15).append(param.auditType == 10 ? " AND FState <> 40" : "");
        sql.append(" AND bgForm.FBgSchemeId IN(Select FBgSchemeId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(" AND bgForm.FBgTemplateId IN(Select FBgTemplateId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(" AND bgForm.FCurrencyId IN(Select FCurrencyId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(" AND bgForm.FBgPeriodId IN(Select FBgPeriodId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(" AND bgForm.FBgVersionId IN(Select FBgVersionId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))").append(" Order By org.FLevel");
        int paramCount = 5;
        List oneParams = MbgSqlHelper.getBatchParams(null, (Object[])billIds.toArray(), (int)50);
        List<Object> paramList = new ArrayList<Object[]>();
        Object[] newParams = null;
        for (Object[] p : oneParams) {
            newParams = new Object[p.length * paramCount];
            paramList.add(newParams);
            for (int i = 0; i < paramCount; ++i) {
                System.arraycopy(p, 0, newParams, i * 50, p.length);
            }
        }
        HashSet<String> billSet = new HashSet<String>(billIds);
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), paramList, (IResultReader)new BgFormReader(param, billSet));
        sql.setLength(0);
        sql.append("Select FOrgUnitID, FLongNumber FROM T_MBG_BgOrgUnit Where FViewId = ? AND FOrgUnitId IN(Select FOrgUnitId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{String.valueOf(param.bgOrgViewId)}, (Object[])billIds.toArray(), (int)50);
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), paramList, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String orgUnitId = res.getString("FOrgUnitId");
                String longNumber = res.getString("FLongNumber");
                String[] lns = longNumber.split("!");
                if (lns.length > 1) {
                    if (!param.parentOrgNumbers.containsKey(orgUnitId)) {
                        param.parentOrgNumbers.put(orgUnitId, new LinkedHashSet());
                    }
                    for (int i = 0; i < lns.length - 1; ++i) {
                        param.parentOrgNumbers.get(orgUnitId).add(lns[i]);
                    }
                }
            }
        });
        Map<String, String[]> subMap = null;
        String[] orgNumbers = null;
        String[] bgFormInfos = null;
        boolean isCanUnAudit = true;
        Set<String> parentNumbers = null;
        for (String key : param.noEditFormMap.keySet()) {
            subMap = param.noEditFormMap.get(key);
            for (String orgNumber : orgNumbers = subMap.keySet().toArray(new String[0])) {
                bgFormInfos = subMap.get(orgNumber);
                isCanUnAudit = true;
                if (!billSet.contains(bgFormInfos[0])) continue;
                parentNumbers = param.parentOrgNumbers.get(bgFormInfos[2]);
                if (parentNumbers != null) {
                    for (String pN : parentNumbers) {
                        if (!subMap.containsKey(pN)) continue;
                        isCanUnAudit = false;
                        break;
                    }
                }
                if (!isCanUnAudit) continue;
                subMap.remove(orgNumber);
            }
        }
    }

    public static boolean checkParentNoEdit(IDimDataQuery bgFormInfo, AuditParam param, Map<String, Object> result) {
        if (bgFormInfo instanceof BgFormInfo) {
            int i;
            BgFormInfo info = (BgFormInfo)bgFormInfo;
            if (!BgProcessEnum.C01.equals((Object)info.getProcessType())) {
                return false;
            }
            Object[] parentNumbers = null;
            if (param.parentOrgNumbers.get(info.getOrgUnit().getId().toString()) != null) {
                parentNumbers = param.parentOrgNumbers.get(info.getOrgUnit().getId().toString()).toArray();
            }
            String[] orgParentNumbers = info.getOrgUnit().getLongNumber().split("!");
            if (parentNumbers == null || parentNumbers.length == 0) {
                return false;
            }
            String key = info.getBgScheme().getId().toString() + "_" + info.getBgTemplate().getId().toString() + "_" + info.getCurrency().getId().toString() + "_" + info.getBgPeriod().getId().toString() + "_" + info.getBgVersion().getId().toString() + "_" + info.getSpecialItemNumber();
            Map<String, String[]> noEditForm = param.noEditFormMap.get(key);
            if (noEditForm == null || noEditForm.isEmpty()) {
                return false;
            }
            for (i = orgParentNumbers.length - 2; i >= 0; --i) {
                if (!noEditForm.containsKey(orgParentNumbers[i].toString())) continue;
                if (param.auditType == 10) {
                    BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_UNCARTIFICATE_STATE", bgFormInfo, orgParentNumbers[i].toString() + "(" + noEditForm.get(orgParentNumbers[i].toString())[1] + ")");
                } else if (param.auditType == 8) {
                    BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_BACK_STATE", bgFormInfo, orgParentNumbers[i].toString() + "(" + noEditForm.get(orgParentNumbers[i].toString())[1] + ")");
                } else {
                    BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_PARENT_NOEDIT", bgFormInfo, orgParentNumbers[i].toString() + "(" + noEditForm.get(orgParentNumbers[i].toString())[1] + ")");
                }
                return true;
            }
            for (i = parentNumbers.length - 1; i >= 0; --i) {
                if (!noEditForm.containsKey(parentNumbers[i].toString())) continue;
                if (param.auditType == 10) {
                    BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_UNCARTIFICATE_STATE", bgFormInfo, parentNumbers[i].toString() + "(" + noEditForm.get(parentNumbers[i].toString())[1] + ")");
                } else if (param.auditType == 8) {
                    BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_BACK_STATE", bgFormInfo, parentNumbers[i].toString() + "(" + noEditForm.get(parentNumbers[i].toString())[1] + ")");
                } else {
                    BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_PARENT_NOEDIT", bgFormInfo, parentNumbers[i].toString() + "(" + noEditForm.get(parentNumbers[i].toString())[1] + ")");
                }
                return true;
            }
        }
        return false;
    }

    protected void afterProcess(Context ctx, Connection conn, AuditParam param) throws SQLException {
    }

    protected boolean isCheckParentNoEdit() {
        return false;
    }

    protected IObjectPK beginLog(Context ctx, IDimDataQuery dimDataQuery, AuditParam param) {
        String logItemName = null;
        if (param.auditType == 1) {
            logItemName = this.getUnAuditLogItemName(param);
        } else if (param.auditType == 0) {
            logItemName = this.getLogItemName(param);
        } else if (param.auditType == 7) {
            logItemName = this.getCourseLogItemName(param);
        } else if (param.auditType == 9) {
            logItemName = this.getCertificateLogItemName(param);
        }
        if (StringUtils.isEmpty((String)logItemName)) {
            return null;
        }
        return LogUtil.beginLog((Context)ctx, (String)"beginLog", (BOSObjectType)dimDataQuery.getBOSType(), null, (String)dimDataQuery.getLogInfo(), (String)logItemName);
    }

    protected String getMethodName(AuditParam param) {
        return "mbg_bgForm_audit";
    }

    protected String getUnAuditLogItemName(AuditParam param) {
        return "mbg_bgForm_unAudit";
    }

    protected String getCourseLogItemName(AuditParam param) {
        return "mbg_bgForm_course";
    }

    protected String getCertificateLogItemName(AuditParam param) {
        return "mbg_bgForm_certificate";
    }

    protected String getLogItemName(AuditParam param) {
        return "mbg_bgForm_audit";
    }

    protected void afterLog(Context ctx, IObjectPK pk) {
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    protected String getCubeName(AuditParam param) {
        return param.bgScheme.getRefCube();
    }

    protected String getEntryName(AuditParam param) {
        return BgCubeUtils.getBudgetEntryCubeName(param.bgScheme.getRefCube());
    }

    protected void queryAudOrgUnit(Context ctx, Connection conn, AuditParam param) throws Exception {
        if (param.audOrgUnitId == null) {
            return;
        }
        String bosType = BOSUuid.read((String)param.audOrgUnitId).getType().toString();
        param.audOrgUnit = "33F82845".equals(bosType) ? MbgDataHelper.getBgOrgUnitInfoById(conn, ctx.getLocale(), BOSUuid.read((String)param.audOrgUnitId)) : MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgOrgViewId, BOSUuid.read((String)param.audOrgUnitId), false);
        if (param.audOrgUnit != null) {
            param.bgOrgUnitMap.put(param.audOrgUnit.getNumber(), param.audOrgUnit);
        }
    }

    protected BgOrgUnitInfo queryOrgUnit(Context ctx, Connection conn, AuditParam param, BOSUuid orgUnitId) throws Exception {
        BgOrgUnitInfo bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgOrgViewId, orgUnitId, false);
        if (bgOrgUnit != null) {
            param.bgOrgUnitMap.put(bgOrgUnit.getNumber(), bgOrgUnit);
        }
        return bgOrgUnit;
    }

    protected List<String> getParentOrgUnitIds(Context ctx, Connection conn, AuditParam param) throws Exception {
        List<String> pOrgUnitIds = new ArrayList<String>();
        if (ctx == null || conn == null || param == null || param.audOrgUnit == null) {
            return pOrgUnitIds;
        }
        List<BgOrgUnitInfo> pOrgUnits = MbgDataHelper.getParentBgOrgUnit(ctx, conn, param.bgOrgViewId, param.audOrgUnit);
        pOrgUnitIds = MbgDataHelper.getBgOrgUnitIds(pOrgUnits);
        return pOrgUnitIds;
    }

    protected List<String> getChildOrgUnitIds(Context ctx, Connection conn, BgOrgUnitInfo bgOrgUnit, AuditParam param, boolean isVirtualFilter, IDimDataQuery model) throws Exception {
        List<String> cOrgUnitIds = new ArrayList<String>();
        if (ctx == null || conn == null || bgOrgUnit == null || param == null || DimensionCommonHelper.isDecompose(model.getProcessType())) {
            return cOrgUnitIds;
        }
        BgOrgUnitInfo tmpBgOrgUnit = null;
        ArrayList<BgOrgUnitInfo> cOrgUnits = new ArrayList<BgOrgUnitInfo>();
        BgOrgUnitCollection bgOrgUnitChildren = MbgDataHelper.getBgOrgUnitChildren(ctx, bgOrgUnit, param.bgOrgViewId.toString());
        int in = bgOrgUnitChildren.size();
        for (int i = 0; i < in; ++i) {
            cOrgUnits.add(bgOrgUnitChildren.get(i));
        }
        cOrgUnitIds = MbgDataHelper.getBgOrgUnitIds(cOrgUnits);
        int jn = cOrgUnits.size();
        for (int j = 0; j < jn; ++j) {
            tmpBgOrgUnit = (BgOrgUnitInfo)cOrgUnits.get(j);
            param.bgOrgUnitMap.put(tmpBgOrgUnit.getNumber(), tmpBgOrgUnit);
        }
        return cOrgUnitIds;
    }

    protected void checkCube(Connection conn, String cubeName) throws Exception {
        if (conn == null || cubeName == null) {
            return;
        }
    }

    protected List<IDimDataQuery> getModels(Connection conn, IDimDataQuery model, AuditParam param) throws Exception {
        ArrayList<IDimDataQuery> models = new ArrayList<IDimDataQuery>();
        if (conn == null || param == null || model == null || StringUtils.isEmpty((String)param.tmpOrgUnit)) {
            return models;
        }
        String _bgSchemeId = model.getBizBgScheme().getId().toString();
        String _bgTempalteId = model.getBizTemplateId().toString();
        String _bgPeriodId = model.getBizPeriod().getId().toString();
        String _currencyId = model.getBizCurrency().getId().toString();
        String _versionId = model.getBizVersion().getId().toString();
        BgProcessEnum bgProcessType = model.getProcessType();
        int formType = model.getBizTemplateType();
        BgFormInfo _bgForm = null;
        Object fullOrgUnitInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID, f.FNumber, f.FName, f.FState, f.FOrgUnitID,f.FAuditOrgUnitID from T_MBG_BgForm f ");
        if (8 == formType) {
            sql.append(" join T_MBG_BgSpecialItems s on s.FBgFormId = f.FId ");
        }
        sql.append(" where f.FBgSchemeId = ? AND f.FBgTemplateID = ? and f.FBgPeriodID = ? and f.FCurrencyID = ? and FBgVersionId = ? and f.FOrgUnitID in (select FID from " + param.tmpOrgUnit + ")");
        if (8 == formType) {
            sql.append(" and s.FDimensionNumber = ? ");
        }
        sql.append(" and f.FProcessType = ?");
        Object[] sqlParams = null;
        sqlParams = 8 == formType ? new Object[]{_bgSchemeId, _bgTempalteId, _bgPeriodId, _currencyId, _versionId, model.getSpecialItemNumber(), bgProcessType.getValue()} : new Object[]{_bgSchemeId, _bgTempalteId, _bgPeriodId, _currencyId, _versionId, bgProcessType.getValue()};
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                _bgForm = new BgFormInfo();
                _bgForm.setId(BOSUuid.read((String)rst.getString("FID")));
                _bgForm.setName(rst.getString("FName"));
                _bgForm.setNumber(rst.getString("FNumber"));
                _bgForm.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                _bgForm.setOrgUnit(new FullOrgUnitInfo());
                _bgForm.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                if (rst.getString("FAuditOrgUnitID") != null) {
                    _bgForm.setAuditOrgUnit(new FullOrgUnitInfo());
                    _bgForm.getAuditOrgUnit().setId(BOSUuid.read((String)rst.getString("FAuditOrgUnitID")));
                }
                if (15 == rst.getInt("FState") || 4 == rst.getInt("FState") || 35 == rst.getInt("FState") || param.auditType == 9 && 40 != rst.getInt("FState")) continue;
                models.add(_bgForm);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return models;
    }

    protected int[] getBgFormStates(AuditParam param) {
        int[] states = null;
        if (param.auditType == 0) {
            states = new int[6];
            states[0] = 1;
            states[1] = 42;
            states[2] = 40;
            states[3] = 41;
            states[4] = 14;
        } else if (param.auditType == 1 || param.auditType == 2) {
            states = new int[]{2};
        } else if (param.auditType == 3) {
            states = new int[]{50};
        } else if (param.auditType == 4) {
            states = new int[]{50};
        } else if (param.auditType == 5) {
            states = new int[]{51};
        } else if (param.auditType == 6) {
            states = new int[]{50, 51};
        } else if (param.auditType == 7) {
            states = new int[]{1, 42};
        } else if (param.auditType == 8) {
            states = new int[]{40};
        } else if (param.auditType == 9) {
            states = new int[]{40};
        } else if (param.auditType == 10) {
            states = new int[]{41};
        } else if (param.auditType == 11) {
            states = new int[]{14, 25};
        }
        return states;
    }

    protected Set<Integer> getBgFormStates(int[] bgFormStates) {
        HashSet<Integer> bgFormStateSet = new HashSet<Integer>();
        if (bgFormStates != null) {
            int in = bgFormStates.length;
            for (int i = 0; i < in; ++i) {
                bgFormStateSet.add(bgFormStates[i]);
            }
        }
        return bgFormStateSet;
    }

    protected int[] getDataStates(AuditParam param) {
        int[] states = null;
        if (param.auditType == 9) {
            states = new int[]{3, 1};
        } else if (param.auditType == 10) {
            states = new int[]{3};
        } else if (param.audState == 3) {
            states = new int[]{1};
        } else if (param.auditType == 0) {
            states = new int[]{1, 3, 9};
        } else if (param.auditType == 1) {
            states = new int[]{9};
        } else if (param.auditType == 2) {
            states = new int[]{1, 3, 9, 11};
        } else if (param.auditType == 3) {
            states = new int[]{11};
        } else if (param.auditType == 4) {
            states = new int[]{11};
        } else if (param.auditType == 5) {
            states = new int[]{13};
        } else if (param.auditType == 6) {
            states = new int[]{11, 13};
        } else if (param.auditType == 7) {
            states = new int[]{1, 3};
        } else if (param.auditType == 8) {
            states = new int[]{3};
        } else if (param.auditType == 11) {
            states = new int[]{3};
        }
        return states;
    }

    protected String getSqlStates(int[] dataStates) {
        return BgDBUtils.getSqlParam((int[])dataStates);
    }

    protected void clearData(Connection conn, AuditParam param) throws Exception {
        if (conn == null || param == null) {
            return;
        }
        try {
            if (param.getTmpBgIndex() != null) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + param.getTmpBgIndex()));
            }
            if (param.getTmpBgPeriod() != null) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + param.getTmpBgPeriod()));
            }
            if (param.getTmpBgElement() != null) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + param.getTmpBgElement()));
            }
            if (param.getTmpCurrency() != null) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + param.getTmpCurrency()));
            }
            if (param.getTmpScenario() != null) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + param.getTmpScenario()));
            }
            this.clearExtData(conn, param);
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected void clearExtData(Connection conn, AuditParam param) throws Exception {
        if (conn == null || param == null) {
            return;
        }
        try {
            Iterator<String> iter = param.getTmpExtMap().values().iterator();
            while (iter.hasNext()) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + iter.next()));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected boolean checkAllData(Context ctx, Connection conn, IDimDataQuery model, List<IDimDataQuery> models, List<String> cOrgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result, boolean isOnlyDealCurBgForm) throws Exception {
        boolean re = false;
        if (conn == null || model == null || models == null || models.isEmpty() || cOrgUnitIds == null || pOrgUnitIds == null || param == null || result == null) {
            return re;
        }
        if (param.auditType == 0) {
            return true;
        }
        return true;
    }

    protected void checkData(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> cOrgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result, boolean isOnlyDealCurBgForm) throws Exception {
    }

    protected boolean hasData(Connection conn, AuditParam param, BOSUuid orgUnitId, Map<String, Object> result) throws Exception {
        boolean hasData = false;
        for (String cube : param.cubes) {
            hasData = hasData || this.hasData(conn, param, cube, orgUnitId, result);
        }
        return hasData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasData(Connection conn, AuditParam param, String cube, BOSUuid orgUnitId, Map<String, Object> result) throws Exception {
        boolean hasData = true;
        if (conn == null || param == null || orgUnitId == null || cube == null) {
            return hasData;
        }
        IRowSet rst = null;
        try {
            BgSchemeAccIntHelper accIntHelper = param.getAccIntHelper();
            rst = accIntHelper.isUseAccInt() ? BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + cube + " where FOrgUnitId = ? and FScenario in (select FScenarioId from T_MBG_BgScenario where FType = 0)"), (Object[])new Object[]{accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, orgUnitId.toString())}) : BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + cube + " where FOrgUnitId = ? and FScenario in (select FScenarioId from T_MBG_BgScenario where FType = 0)"), (Object[])new Object[]{orgUnitId.toString()});
            hasData = rst.next();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return hasData;
    }

    protected Map<String, BgOrgUnitInfo> getBgOrgUnitMap(Collection<BgOrgUnitInfo> bgOrgUnits, Map<String, BgOrgUnitInfo> bgOrgUnitMap) {
        if (bgOrgUnits == null || bgOrgUnits.isEmpty()) {
            return bgOrgUnitMap;
        }
        for (BgOrgUnitInfo bgOrgUnit : bgOrgUnits) {
            bgOrgUnitMap.put(bgOrgUnit.getNumber(), bgOrgUnit);
        }
        return bgOrgUnitMap;
    }

    protected List<String> getAudOrgUnitIds(Context ctx, Connection conn, BgOrgUnitInfo bgOrgUnit, AuditParam param) throws Exception {
        int i;
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (ctx == null || conn == null || bgOrgUnit == null || param == null || param.audOrgUnit == null) {
            return orgUnitIds;
        }
        HashSet<String> numbers = new HashSet<String>();
        String[] _numbers = bgOrgUnit.getLongNumber().split("!");
        int in = _numbers.length;
        for (i = 0; i < in; ++i) {
            numbers.add(_numbers[i]);
        }
        _numbers = param.audOrgUnit.getLongNumber().split("!");
        in = _numbers.length;
        for (i = 0; i < in; ++i) {
            numbers.remove(_numbers[i]);
        }
        numbers.add(param.audOrgUnit.getNumber());
        for (String number : numbers) {
            if (!param.bgOrgUnitMap.containsKey(number)) {
                param.bgOrgUnitMap.put(number, MbgDataHelper.getBgOrgUnitInfoByNumber(conn, ctx.getLocale(), BOSUuid.read((String)bgOrgUnit.getViewID()), number));
            }
            orgUnitIds.add(param.bgOrgUnitMap.get(number).getOrgUnitID());
        }
        return orgUnitIds;
    }

    protected void updateBase(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result) throws Exception {
        if (ctx == null || conn == null || model == null || orgUnitIds == null || pOrgUnitIds == null || param == null || result == null) {
            return;
        }
        boolean re = this.checkBaseData(conn, model, bgOrgUnit, orgUnitIds, pOrgUnitIds, param, result);
        if (re) {
            this.updateBaseData(ctx, conn, model, bgOrgUnit, orgUnitIds, pOrgUnitIds, param);
        }
    }

    protected boolean checkBaseData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result) throws Exception {
        return true;
    }

    protected void updateBaseData(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (ctx == null || conn == null || model == null || orgUnitIds == null || param == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        Object[] sqlParams = null;
        int[] dataStates = this.getDataStates(param);
        try {
            for (String cube : param.cubes) {
                sql.setLength(0);
                if (!orgUnitIds.isEmpty()) {
                    sql.append("update " + cube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ? ");
                    if (param.auditType == 1 || param.auditType == 3) {
                        sql.append(",FAudFormId = ? ");
                    }
                    sql.append(" where FOrgUnitId = ? and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cube + ".FID)  and FAudOrgUnitId IN (select FID from " + param.tmpAudOrgUnit + ")  and FState IN " + this.getSqlStates(dataStates) + this.getScenSql());
                    if (param.auditType == 0 || param.auditType == 2) {
                        sqlParams = new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, model.getBizOrgUnit().getId().toString(), model.getId().toString()};
                    } else if (param.auditType == 1 || param.auditType == 3) {
                        sqlParams = new Object[]{param.audState, null, null, null, model.getBizOrgUnit().getId().toString(), model.getId().toString()};
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), sqlParams);
                }
                sql.setLength(0);
                sql.append("update " + cube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?,FAudFormId = ?  where FOrgUnitId = ? and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cube + ".FID)  and FAudOrgUnitId is null  and FState IN " + this.getSqlStates(dataStates) + this.getScenSql());
                if (param.auditType == 0 || param.auditType == 2) {
                    sqlParams = new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, param.currtBillId, model.getBizOrgUnit().getId().toString(), model.getId().toString()};
                } else if (param.auditType == 1 || param.auditType == 3) {
                    sqlParams = new Object[]{param.audState, null, null, null, model.getBizOrgUnit().getId().toString(), model.getId().toString()};
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected String getScenSql() {
        return " and FScenario IN (select FScenarioId from T_MBG_BgScenario where FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE + ")";
    }

    protected void updateView(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result) throws Exception {
        if (ctx == null || conn == null || model == null || orgUnitIds == null || param == null) {
            return;
        }
        IMbgViewBase view = param.getCacheView(ctx, model);
        if (view == null) {
            return;
        }
        boolean re = this.updateMemberTable(conn, model, view, param);
        if (re && (re = this.checkViewData(conn, model, bgOrgUnit, orgUnitIds, pOrgUnitIds, param, result))) {
            this.updateViewData(conn, model, bgOrgUnit, orgUnitIds, pOrgUnitIds, param);
        }
    }

    protected boolean updateMemberTable(Connection conn, IDimDataQuery model, IMbgViewBase view, AuditParam param) throws Exception {
        if (conn == null || model == null || view == null || param == null) {
            return false;
        }
        Map<String, Set<String>> mbgMemberMap = MbgDataHelper.parseMbgMember(view);
        if (mbgMemberMap.isEmpty()) {
            return false;
        }
        ArrayList<Object> tmpList = new ArrayList<Object>();
        try {
            param.getAccIntHelper().insertToTmpTable(conn, param.getTmpBgIndex(), mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD), DimensionConstants.DEF_BGINDEX_FIELD, false);
            this.querySubMember(conn, param, DimensionBaseConstants.DEF_INDEX_NUMBER, mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD), param.getTmpBgIndex());
            tmpList.clear();
            if (this.getClosureMap() != null) {
                Set<String> periodNumberSet = mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                for (String periodNumber : periodNumberSet) {
                    if (this.getClosureMap().get(periodNumber) == null) continue;
                    tmpList.addAll((Collection)this.getClosureMap().get(periodNumber));
                }
            } else {
                tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.getTmpBgPeriod() + " (FID, FIntID) select FID, FIntID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.getTmpBgElement() + " (FID, FIntID) select FID, FIntID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.getTmpCurrency() + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
            this.insertParamForScen(conn, param, tmpList);
            this.updateExtMemberTable(conn, model, view, param, mbgMemberMap);
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return true;
    }

    protected void insertParamForScen(Connection conn, AuditParam param, List<Object> tmpList) throws Exception {
        BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.getTmpScenario() + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") and FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE), tmpList);
    }

    protected void updateExtMemberTable(Connection conn, IDimDataQuery model, IMbgViewBase view, AuditParam param, Map<String, Set<String>> mbgMemberMap) throws Exception {
    }

    protected void innerUpdateExtMemberTable(Connection conn, IDimDataQuery model, IMbgViewBase view, AuditParam param, Map<String, Set<String>> mbgMemberMap) throws Exception {
        if (conn == null || model == null || view == null || param == null || mbgMemberMap == null) {
            return;
        }
        if (8 == model.getBizTemplateType()) {
            Object tmpNums;
            Object dimNumber2 = null;
            String srcNumber = null;
            String spItemNumber = model.getSpecialItemNumber();
            if (!StringUtils.isEmpty((String)spItemNumber) && (tmpNums = spItemNumber.split(",")) != null) {
                for (Object dimNumber2 : tmpNums) {
                    srcNumber = DimUtils.getSrcNumber((String)dimNumber2);
                    if (!param.srcDims.containsKey(srcNumber)) continue;
                    param.auditMbgDims.add(param.srcDims.get(srcNumber).getNumber());
                }
            }
        }
        if (param.auditMbgDims != null && param.auditMbgDims.size() > 1) {
            String tmpTable = null;
            String field = null;
            Set<String> memberSet = null;
            try {
                for (String mbgDimNumber : param.auditMbgDims) {
                    if (DimensionBaseConstants.DEF_INDEX_NUMBER.equals(mbgDimNumber) || param.unionId == null && DimensionBaseConstants.DEF_CSL_NUMBER.equals(mbgDimNumber)) continue;
                    tmpTable = param.getTmpExtMap().get(mbgDimNumber);
                    field = param.mbgDims.get(mbgDimNumber).getRefField();
                    memberSet = mbgMemberMap.get(field);
                    param.getAccIntHelper().insertToTmpTable(conn, tmpTable, memberSet, param.getSchemeHelper().getRefField(mbgDimNumber), false);
                    this.querySubMember(conn, param, mbgDimNumber, memberSet, tmpTable);
                    if (!param.getAccIntHelper().isUseAccInt()) continue;
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpTable + " t0 Set FIntID = (Select FIntID FROM T_MBG_MbgMember Where FViewId = ? AND ('" + param.getSchemeHelper().getSrcNumber(mbgDimNumber) + ":" + "' || FNumber) = t0.FNumber)"), (Object[])new Object[]{param.getSchemeHelper().getDimension(mbgDimNumber).getViewId()});
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
        }
    }

    protected void querySubMember(Connection conn, AuditParam param, String mbgDimNumber, Set<String> dimNumbers, String tmpTable) throws EASBizException, BOSException {
        if (conn == null || param == null || mbgDimNumber == null || dimNumbers == null || dimNumbers.isEmpty() || tmpTable == null) {
            return;
        }
        IRowSet rst = null;
        BOSUuid viewId = param.bgScheme.getViewId(mbgDimNumber);
        if (viewId == null) {
            return;
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        List rsts = null;
        Object[] objs = null;
        HashSet<String> factDataSet = new HashSet<String>();
        String longNumber = null;
        String[] numbers = null;
        StringBuffer sql = new StringBuffer();
        try {
            int i;
            String factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)viewId);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FLongNumber from " + factTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + factTable + ".FDimNumber)"));
            while (rst.next()) {
                sqlParams.add(rst.getString(1) + "!%");
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.append("select FDimLongNumber from " + factTable + " where FLongNumber like ? ");
            for (i = 1; i < 100; ++i) {
                sql.append(" OR FLongNumber like ? ");
            }
            rsts = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams, (int)100);
            int in = rsts.size();
            for (i = 0; i < in; ++i) {
                objs = (Object[])rsts.get(i);
                longNumber = (String)objs[0];
                if (longNumber == null || (numbers = longNumber.split("!")) == null) continue;
                for (int j = 0; j < numbers.length; ++j) {
                    if (dimNumbers.contains(numbers[j])) continue;
                    factDataSet.add(numbers[j]);
                }
            }
            if (!factDataSet.isEmpty()) {
                param.getAccIntHelper().insertToTmpTable(conn, tmpTable, factDataSet, param.getAccIntHelper().getSchemeHelper().getRefField(mbgDimNumber), false);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"querySubMember sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    protected boolean checkViewData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result) throws Exception {
        return true;
    }

    protected void updateViewData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return;
        }
        int[] dataStates = this.getDataStates(param);
        Object[] sqlParams = null;
        try {
            for (String cube : param.cubes) {
                StringBuffer sql = new StringBuffer();
                sql.append("update " + cube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?");
                if (param.auditType != 0) {
                    sql.append(",FAudFormId = ? ");
                }
                sql.append(" where FOrgUnitId = ?  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cube + ".F2)  and exists (select FID from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cube + ".FBgPeriodID)  and exists (select FID from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cube + ".FBgElementID)  and exists (select FID from " + param.getTmpCurrency() + " where FID = " + cube + ".FCurrencyID)  and exists (select FID from " + param.getTmpScenario() + " where FID = " + cube + ".FScenario)  and FVersion = ?");
                sql.append(" and FState IN " + this.getSqlStates(dataStates));
                if (!orgUnitIds.isEmpty()) {
                    sql.append(" and FAudOrgUnitId IN (select FID from " + param.tmpAudOrgUnit + ")");
                }
                sqlParams = param.auditType == 0 ? new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, model.getBizOrgUnit().getId().toString(), model.getBizVersion().getVersionId()} : new Object[]{param.audState, null, null, null, model.getBizOrgUnit().getId().toString(), model.getBizVersion().getVersionId()};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                sql.setLength(0);
                sql.append("update " + cube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?,FAudFormId = ? where FOrgUnitId = ? and FAudOrgUnitId is null  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cube + ".F2)  and exists (select FID from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cube + ".FBgPeriodID)  and exists (select FID from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cube + ".FBgElementID)  and exists (select FID from " + param.getTmpCurrency() + " where FID = " + cube + ".FCurrencyID)  and exists (select FID from " + param.getTmpScenario() + " where FID = " + cube + ".FScenario)  and FVersion = ?");
                sql.append(" and FState IN " + this.getSqlStates(dataStates));
                sqlParams = param.auditType == 0 ? new Object[]{param.audState, param.audOrgUnit.getOrgUnitID(), param.audUserId, param.currtBillId, model.getBizOrgUnit().getId().toString(), model.getBizVersion().getVersionId()} : new Object[]{param.audState, null, null, null, model.getBizOrgUnit().getId().toString(), model.getBizVersion().getVersionId()};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected void updateFormData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, AuditParam param) throws Exception {
        if (conn == null || model == null || bgOrgUnit == null || param == null) {
            return;
        }
        int[] formStates = this.getBgFormStates(param);
        Set<Integer> bgFormStateSet = this.getBgFormStates(formStates);
        Object[] sqlParams = null;
        if (!bgFormStateSet.contains(model.getBizState())) {
            return;
        }
        String sql = "update T_MBg_BgForm set FState = ?, FAuditorID = ?, FAuditedTime = ?, FStateBeforeAudit = ?,FauditOrgUnitID = ? where FID = ?";
        if (formStates != null && formStates.length > 0) {
            sql = sql + " and FState IN " + this.getSqlStates(formStates);
        }
        if (param.auditType == 0 || param.auditType == 9) {
            sqlParams = new Object[]{param.audFormState, this.isSetAudit() ? param.audUserId : null, this.isSetAudit() ? new Timestamp(System.currentTimeMillis()) : null, model.getBizState(), param.audOrgUnitId, model.getId().toString()};
        } else if (1 == param.audFormState || 42 == param.audFormState || 40 == param.audFormState) {
            sqlParams = new Object[]{param.audFormState, this.isSetAudit() ? param.audUserId : null, this.isSetAudit() ? new Timestamp(System.currentTimeMillis()) : null, model.getBizState(), null, model.getId().toString()};
        } else {
            sql = "update T_MBg_BgForm set FState = ?, FStateBeforeAudit = ? where FID = ?";
            sqlParams = new Object[]{param.audFormState, model.getBizState(), model.getId().toString()};
        }
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)sql, (Object[])sqlParams);
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected boolean isSetAudit() {
        return true;
    }

    protected void succeed(IDimDataQuery model, AuditParam param, Map<String, Object> result) throws Exception {
        if (model == null || param == null || result == null) {
            return;
        }
        String billId = model.getId().toString();
        if (param.billMap.containsKey(billId)) {
            boolean isErrorState;
            Map object;
            if (param.auditType == 0 && result.containsKey("CHECK_RESULT_STATE") && result.get("CHECK_RESULT_STATE") instanceof Map && (object = (Map)result.get("CHECK_RESULT_STATE")).keySet() != null && object.keySet().contains(billId)) {
                object.remove(billId);
            }
            if (isErrorState = this.utils.checkBillState(model, param)) {
                BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_STATE", model);
            } else {
                BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_SUCCEED", model);
            }
        }
    }

    protected void updateAuditRecord(Context ctx, Connection conn, Locale locale, IDimDataQuery model, Map<String, String> auditParams, AuditParam param) throws Exception {
        if (ctx == null || conn == null || locale == null || model == null || auditParams == null || param == null) {
            return;
        }
        if (!auditParams.containsKey("AUDIT_COURSE_COMMENT_STATE")) {
            return;
        }
        int[] formStates = this.getBgFormStates(param);
        Set<Integer> bgFormStateSet = this.getBgFormStates(formStates);
        if (!bgFormStateSet.contains(param.audFormState) && !bgFormStateSet.contains(model.getBizState())) {
            return;
        }
        if (25 == param.audFormState) {
            return;
        }
        BgAuditIdeaInfo ideaInfo = new BgAuditIdeaInfo();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String message = auditParams.containsKey("AUDIT_MESSAGE") ? auditParams.get("AUDIT_MESSAGE") : "";
        String sql = "Insert Into T_MBG_BgAuditIdea (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FState, FIdea_" + locale + ", FBgFormID) values (?,?,?,?,?,?,?,?,?)";
        Object[] sqlParams = null;
        sqlParams = param.auditType == 0 ? new Object[]{BOSUuid.create((BOSObjectType)ideaInfo.getBOSType()).toString(), param.audUserId, time, param.audUserId, time, null, 0, message, model.getId().toString()} : (param.auditType == 9 ? new Object[]{BOSUuid.create((BOSObjectType)ideaInfo.getBOSType()).toString(), param.audUserId, time, param.audUserId, time, null, 8, message, model.getId().toString()} : (param.auditType == 10 ? new Object[]{BOSUuid.create((BOSObjectType)ideaInfo.getBOSType()).toString(), param.audUserId, time, param.audUserId, time, null, 9, message, model.getId().toString()} : (param.auditType == 11 ? new Object[]{BOSUuid.create((BOSObjectType)ideaInfo.getBOSType()).toString(), param.audUserId, time, param.audUserId, time, null, 1, message, model.getId().toString()} : new Object[]{BOSUuid.create((BOSObjectType)ideaInfo.getBOSType()).toString(), param.audUserId, time, param.audUserId, time, null, 2, message, model.getId().toString()})));
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)sql, (Object[])sqlParams);
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    private boolean checkIsInProInst(Context ctx, BOSUuid bgFormId) throws BOSException {
        boolean check = true;
        if (this.checkMap.containsKey(bgFormId)) {
            check = this.checkMap.get(bgFormId);
        } else {
            check = BgNFSHelper.checkLocalInProInst(ctx, bgFormId.toString());
            this.checkMap.put(bgFormId, check);
        }
        return check;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ boolean access$100(BaseBiz x0) {
        return x0.processEnd;
    }

    protected class UpdateDateRunner
    extends Thread {
        private Context ctx = null;
        private Connection conn = null;
        private AuditParam param = null;
        private List<String> noCheckOrgIds = null;
        private IDimDataQuery model = null;
        private List<String> pOrgUnitIds = null;
        private Map<String, Object> result = null;

        UpdateDateRunner(Context ctx, Connection conn, AuditParam param, List<String> noCheckOrgIds, IDimDataQuery model, List<String> pOrgUnitIds, Map<String, Object> result) {
            this.ctx = ctx;
            this.conn = conn;
            this.param = param;
            this.noCheckOrgIds = noCheckOrgIds;
            this.model = model;
            this.pOrgUnitIds = pOrgUnitIds;
            this.result = result;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class BgFormReader
    implements IResultReader {
        private AuditParam param = null;
        private Set<String> billSet = null;

        public BgFormReader(AuditParam param, Set<String> billSet) {
            this.param = param;
            this.billSet = billSet;
        }

        public void read(ResultSet res) throws SQLException {
            String id = res.getString("FID");
            String bgSchemeid = res.getString("FBgSchemeId");
            String bgTemplateId = res.getString("FBgTemplateId");
            String currencyId = res.getString("FCurrencyId");
            String bgPeriodId = res.getString("FBgPeriodId");
            String versionId = res.getString("FBgVersionId");
            String dimensionNumber = res.getString("FDimensionNumber");
            String orgUnitNumber = res.getString("FOrgUnitNumber");
            String orgName = res.getString("FOrgName");
            String orgId = res.getString("FOrgUnitID");
            String key = bgSchemeid + "_" + bgTemplateId + "_" + currencyId + "_" + bgPeriodId + "_" + versionId + "_" + dimensionNumber;
            if (!this.param.noEditFormMap.containsKey(key)) {
                this.param.noEditFormMap.put(key, new LinkedHashMap());
            }
            this.param.noEditFormMap.get(key).put(orgUnitNumber, new String[]{id, orgName, orgId});
        }
    }
}

