/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgCourseCommentFactory;
import com.kingdee.eas.ma.mbg.BgCourseCommentInfo;
import com.kingdee.eas.ma.mbg.BgCourseOperateEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListControlUtils;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.ClosureUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgUnAuditCheckResult;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BaseBiz;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizDataControlUtils
implements Serializable {
    private static final long serialVersionUID = 5648949896973093599L;
    private static final Logger logger = Logger.getLogger(BizDataControlUtils.class);
    private Context ctx;
    private Map<String, BgSchemeDimensionHelper> bgSchemeHelperMap = new HashMap<String, BgSchemeDimensionHelper>();
    private boolean isSynchionzeSubFormState = true;
    private static final String bgFormState = "(1,2,14,25,40,41,42)";

    public BizDataControlUtils(Context ctx) {
        this.ctx = ctx;
    }

    public BizDataControlUtils(Context ctx, boolean isSynchionzeSubFormState) {
        this(ctx);
        this.isSynchionzeSubFormState = isSynchionzeSubFormState;
    }

    private BgSchemeDimensionHelper getBgSchemeHelper(String bgSchemeId) throws EASBizException, BOSException {
        if (!this.bgSchemeHelperMap.containsKey(bgSchemeId)) {
            this.bgSchemeHelperMap.put(bgSchemeId, new BgSchemeDimensionHelper(this.ctx, bgSchemeId));
        }
        return this.bgSchemeHelperMap.get(bgSchemeId);
    }

    private RelationUtils getRelationUtils(String bgSchemeId) throws EASBizException, BOSException {
        return RelationUtils.getInstance(this.getBgSchemeHelper(bgSchemeId));
    }

    public boolean isSynchionzeSubFormState() {
        return this.isSynchionzeSubFormState;
    }

    public void setSynchionzeSubFormState(boolean isSynchionzeSubFormState) {
        this.isSynchionzeSubFormState = isSynchionzeSubFormState;
    }

    public final BgSchemeDimensionHelper getSchemeHelper(String bgSchemeId) throws EASBizException, BOSException {
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.ctx, bgSchemeId);
        return schemeHelper;
    }

    public void updateAudOrgUnit(BOSUuid billId, BOSUuid audOrgUnitId, BOSUuid audUserId, int valueType, int bgDataState, String auditIdea, Set successFormIds, BgFormStateEnum[] bgFormStates) throws BOSException, EASBizException {
        long begin;
        if (this.ctx == null || billId == null || audOrgUnitId == null || audUserId == null) {
            return;
        }
        logger.debug((Object)"begin Audit OrgUnit Data!");
        long tmpBegin = begin = System.currentTimeMillis();
        BgFormInfo formInfo = BgViewServerHelper.getBgFormInfoNoQueryData(this.ctx, billId, false);
        if (formInfo == null) {
            return;
        }
        String _audOrgUnitId = audOrgUnitId.toString();
        String _audUserId = audUserId.toString();
        BOSUuid bgSchemeId = formInfo.getBgScheme().getId();
        BOSUuid orgUnitId = formInfo.getOrgUnit().getId();
        BOSUuid rootTemplateId = formInfo.getBgTemplate().getRootId();
        BOSUuid bgPeriodId = formInfo.getBgPeriod().getId();
        BOSUuid currencyId = formInfo.getCurrency().getId();
        BOSUuid bgVersionId = formInfo.getBgVersion().getId();
        BgSchemeInfo rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgSchemeId);
        if (rootScheme == null) {
            return;
        }
        BgSchemeDimensionHelper schemehelper = this.getSchemeHelper(rootScheme.getId().toString());
        String orgViewId = schemehelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        String cubeName = BgCubeUtils.getCubeName(rootScheme.getRefCube(), valueType);
        String cubeEntryName = BgCubeUtils.getCubeEntryName(rootScheme.getRefCube(), valueType);
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rst = null;
        String orgUnitTmpTable = null;
        List<bgBaseData> bgBaseDatas = null;
        List<String> orgUnitIds = null;
        Set<String> pOrgUnitIds = null;
        HashSet<String> upBgDataIds = new HashSet<String>();
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            orgUnitIds = this.getSubOrgUnitIds(conn, orgViewId, this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, orgUnitId.toString()).getLongNumber());
            if (orgUnitIds.isEmpty()) {
                return;
            }
            pOrgUnitIds = this.getParentOrgUnitIds(conn, orgViewId, this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, audOrgUnitId.toString()).getLongNumber());
            orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), orgUnitIds);
            List<String> bgFormIds = null;
            bgFormIds = formInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM) ? this.getBgFormSpecialIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, bgFormStates, this.getSpecialItemNumberByForm(formInfo)) : this.getBgFormIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, bgFormStates);
            logger.error((Object)("end query bgFormId! use Time = " + (System.currentTimeMillis() - tmpBegin)));
            tmpBegin = System.currentTimeMillis();
            if (!bgFormIds.isEmpty()) {
                for (String bgFormId : bgFormIds) {
                    bgBaseDatas = this.queryBaseData(conn, cubeName, cubeEntryName, bgFormId, pOrgUnitIds);
                    this.updateAudOrgUnitCheck(bgBaseDatas, bgDataState);
                    Set<String> tmpSet = this.updateBaseData(conn, cubeName, bgBaseDatas, _audOrgUnitId, _audUserId, false);
                    if (tmpSet != null && !tmpSet.isEmpty()) {
                        upBgDataIds.addAll(tmpSet);
                    }
                    if (successFormIds == null) continue;
                    successFormIds.add(bgFormId);
                }
                if (bgDataState == 9) {
                    this.updateAudFormState(conn, formInfo, bgFormIds, audUserId, 2, auditIdea);
                } else if (bgDataState == 3) {
                    this.updateAudFormState(conn, formInfo, bgFormIds, audUserId, 41, auditIdea);
                }
            }
            logger.error((Object)("end update base Data! use Time = " + (System.currentTimeMillis() - tmpBegin)));
            tmpBegin = System.currentTimeMillis();
            IBgDimensionManagerBase manager = null;
            IMbgViewBase view = null;
            view = DimensionCommonHelper.getBgFormView(this.ctx, formInfo);
            if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formInfo.getBgTemplate().getFormType())) {
                view = MBGFormFacadeFactory.getLocalInstance(this.ctx).loadViewManager(billId.toString(), null, (IMbgViewManager)view, null, orgUnitId.toString(), true, false);
            } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formInfo.getBgTemplate().getFormType())) {
                Map result = MBGViewListFormFacadeFactory.getLocalInstance(this.ctx).initViewListData(formInfo, null, orgViewId, (MbgViewListManager)view, null);
                view = (IMbgViewBase)result.get("dimensino.member");
            }
            logger.error((Object)("end get View Data! use Time = " + (System.currentTimeMillis() - tmpBegin)));
            tmpBegin = System.currentTimeMillis();
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = view.getSheetManagers().get(i).getDimensionManager();
                    if (manager == null) continue;
                    IBizData bizData = this.getBizDataInstance(view);
                    bgBaseDatas = bizData.queryBaseData(conn, pool, cubeName, view, manager, formInfo, rootScheme, orgUnitIds, pOrgUnitIds, upBgDataIds);
                    logger.error((Object)("end query Data By View! use Time = " + (System.currentTimeMillis() - tmpBegin)));
                    tmpBegin = System.currentTimeMillis();
                    this.updateAudOrgUnitCheck(bgBaseDatas, bgDataState);
                    Set<String> tmpSet = this.updateBaseData(conn, cubeName, bgBaseDatas, _audOrgUnitId, _audUserId, false);
                    if (tmpSet == null) continue;
                    upBgDataIds.addAll(tmpSet);
                }
            }
            pool.releaseTable(orgUnitTmpTable);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        logger.error((Object)("end Audit OrgUnit Data! use Time = " + (System.currentTimeMillis() - begin)));
    }

    public List<String> updateDataState(BOSUuid billId, BOSUuid audOrgUnitId, int bgDataState, BgFormStateEnum[] sourceBgFormState) throws BOSException, EASBizException {
        if (this.ctx == null || billId == null || audOrgUnitId == null) {
            return null;
        }
        List<String> bgFormIds = null;
        System.out.println("begin Update OrgUnit Data!");
        long begin = System.currentTimeMillis();
        BgFormInfo formInfo = BgViewServerHelper.getBgFormInfoNoQueryData(this.ctx, billId, false);
        if (formInfo == null) {
            return null;
        }
        BOSUuid bgSchemeId = formInfo.getBgScheme().getId();
        BOSUuid orgUnitId = formInfo.getOrgUnit().getId();
        BOSUuid rootTemplateId = formInfo.getBgTemplate().getRootId();
        BOSUuid bgPeriodId = formInfo.getBgPeriod().getId();
        BOSUuid currencyId = formInfo.getCurrency().getId();
        BOSUuid bgVersionId = formInfo.getBgVersion().getId();
        BgSchemeInfo rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgSchemeId);
        if (rootScheme == null) {
            return null;
        }
        BgSchemeDimensionHelper schemehelper = this.getSchemeHelper(rootScheme.getId().toString());
        String orgViewId = schemehelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        String cubeName = BgCubeUtils.getCubeName(rootScheme.getRefCube(), 1);
        String cubeEntryName = BgCubeUtils.getCubeEntryName(rootScheme.getRefCube(), 1);
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rst = null;
        String orgUnitTmpTable = null;
        List<bgBaseData> bgBaseDatas = null;
        List<String> orgUnitIds = null;
        Set<String> pOrgUnitIds = null;
        HashSet<String> upBgDataIds = new HashSet<String>();
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            orgUnitIds = this.getSubOrgUnitIds(conn, orgViewId, this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, orgUnitId.toString()).getLongNumber());
            if (orgUnitIds.isEmpty()) {
                List<String> list = null;
                return list;
            }
            pOrgUnitIds = this.getParentOrgUnitIds(conn, orgViewId, this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, audOrgUnitId.toString()).getLongNumber());
            orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), orgUnitIds);
            bgFormIds = formInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM) ? this.getBgFormSpecialIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, sourceBgFormState, this.getSpecialItemNumberByForm(formInfo)) : this.getBgFormIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, sourceBgFormState);
            if (!bgFormIds.isEmpty()) {
                for (String bgFormId : bgFormIds) {
                    bgBaseDatas = this.queryBaseData(conn, cubeName, cubeEntryName, bgFormId, pOrgUnitIds);
                    this.updateDataStateCheck(bgBaseDatas, bgDataState);
                    Set<String> tmpSet = this.updateBaseState(conn, cubeName, bgBaseDatas);
                    if (tmpSet == null || tmpSet.isEmpty()) continue;
                    upBgDataIds.addAll(tmpSet);
                }
            }
            IBgDimensionManagerBase manager = null;
            IMbgViewBase view = DimensionCommonHelper.getBgFormView(this.ctx, formInfo);
            if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formInfo.getBgTemplate().getFormType())) {
                view = MBGFormFacadeFactory.getLocalInstance(this.ctx).loadViewManager(billId.toString(), null, (IMbgViewManager)view, null, orgUnitId.toString(), true, false);
            } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formInfo.getBgTemplate().getFormType())) {
                Map result = MBGViewListFormFacadeFactory.getLocalInstance(this.ctx).initViewListData(formInfo, null, orgViewId, (MbgViewListManager)view, null);
                view = (IMbgViewBase)result.get("dimensino.member");
            }
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = view.getSheetManagers().get(i).getDimensionManager();
                    if (manager == null) continue;
                    IBizData bizData = this.getBizDataInstance(view);
                    bgBaseDatas = bizData.queryBaseData(conn, pool, cubeName, view, manager, formInfo, rootScheme, orgUnitIds, pOrgUnitIds, upBgDataIds);
                    this.updateAudOrgUnitCheck(bgBaseDatas, bgDataState);
                    Set<String> tmpSet = this.updateBaseState(conn, cubeName, bgBaseDatas);
                    if (tmpSet == null) continue;
                    upBgDataIds.addAll(tmpSet);
                }
            }
            pool.releaseTable(orgUnitTmpTable);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        System.out.println("end Update OrgUnit Data!");
        long end = System.currentTimeMillis();
        System.out.println("Update OrgUnit Data use Time!" + (end - begin));
        return bgFormIds;
    }

    public void recoverAudOrgUnit(BOSUuid billId, BOSUuid audOrgUnitId, BOSUuid audUserId, int valueType, int bgDataState, boolean optType, String auditIdea, BgFormStateEnum[] states) throws BOSException, EASBizException {
        long begin;
        if (this.ctx == null || billId == null || audOrgUnitId == null || audUserId == null) {
            return;
        }
        logger.debug((Object)"begin UnAudit OrgUnit Data!");
        long tmpBegin = begin = System.currentTimeMillis();
        BgFormInfo formInfo = BgViewServerHelper.getBgFormInfoNoQueryData(this.ctx, billId, false);
        if (formInfo == null) {
            return;
        }
        String _audOrgUnitId = audOrgUnitId.toString();
        String _audUserId = audUserId.toString();
        BOSUuid bgSchemeId = formInfo.getBgScheme().getId();
        BOSUuid orgUnitId = formInfo.getOrgUnit().getId();
        BOSUuid rootTemplateId = formInfo.getBgTemplate().getRootId();
        BOSUuid bgPeriodId = formInfo.getBgPeriod().getId();
        BOSUuid currencyId = formInfo.getCurrency().getId();
        BOSUuid bgVersionId = formInfo.getBgVersion().getId();
        BgSchemeInfo rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgSchemeId);
        if (rootScheme == null) {
            return;
        }
        BgSchemeDimensionHelper schemehelper = this.getSchemeHelper(rootScheme.getId().toString());
        String orgViewId = schemehelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        String cubeName = BgCubeUtils.getCubeName(rootScheme.getRefCube(), valueType);
        String cubeEntryName = BgCubeUtils.getCubeEntryName(rootScheme.getRefCube(), valueType);
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rst = null;
        String orgUnitTmpTable = null;
        List<bgBaseData> bgBaseDatas = null;
        List<String> orgUnitIds = null;
        Set<String> pOrgUnitIds = null;
        HashSet<String> upBgDataIds = new HashSet<String>();
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            orgUnitIds = this.getSubOrgUnitIds(conn, orgViewId, this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, orgUnitId.toString()).getLongNumber());
            if (orgUnitIds.isEmpty()) {
                return;
            }
            pOrgUnitIds = this.getParentOrgUnitIds(conn, orgViewId, this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, audOrgUnitId.toString()).getLongNumber());
            orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), orgUnitIds);
            List<String> bgFormIds = null;
            bgFormIds = formInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM) ? this.getBgFormSpecialIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, states, this.getSpecialItemNumberByForm(formInfo)) : this.getBgFormIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, states);
            logger.debug((Object)("end query bgFormIds! time = " + (System.currentTimeMillis() - tmpBegin)));
            tmpBegin = System.currentTimeMillis();
            if (!bgFormIds.isEmpty()) {
                for (String bgFormId : bgFormIds) {
                    bgBaseDatas = this.queryBaseData(conn, cubeName, cubeEntryName, bgFormId, pOrgUnitIds);
                    this.recoverAudOrgUnitCheck(bgBaseDatas, bgDataState, optType);
                    Set<String> tmpSet = this.updateBaseData(conn, cubeName, bgBaseDatas, _audOrgUnitId, _audUserId, optType);
                    if (tmpSet == null || tmpSet.isEmpty()) continue;
                    upBgDataIds.addAll(tmpSet);
                }
                if (this.isSynchionzeSubFormState()) {
                    this.recoverAudOrgUnitState(conn, formInfo, bgFormIds, audOrgUnitId, audUserId, optType, auditIdea);
                }
            }
            logger.debug((Object)("end update base data! time = " + (System.currentTimeMillis() - tmpBegin)));
            tmpBegin = System.currentTimeMillis();
            IBgDimensionManagerBase manager = null;
            IMbgViewBase view = DimensionCommonHelper.getBgFormView(this.ctx, formInfo);
            if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formInfo.getBgTemplate().getFormType())) {
                view = MBGFormFacadeFactory.getLocalInstance(this.ctx).loadViewManager(billId.toString(), null, (IMbgViewManager)view, null, orgUnitId.toString(), true, false);
            } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formInfo.getBgTemplate().getFormType())) {
                Map result = MBGViewListFormFacadeFactory.getLocalInstance(this.ctx).initViewListData(formInfo, null, orgViewId, (MbgViewListManager)view, null);
                view = (IMbgViewBase)result.get("dimensino.member");
            }
            logger.debug((Object)("end get view data! time = " + (System.currentTimeMillis() - tmpBegin)));
            tmpBegin = System.currentTimeMillis();
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = view.getSheetManagers().get(i).getDimensionManager();
                    if (manager == null) continue;
                    IBizData bizData = this.getBizDataInstance(view);
                    bgBaseDatas = bizData.queryBaseData(conn, pool, cubeName, view, manager, formInfo, rootScheme, orgUnitIds, pOrgUnitIds, upBgDataIds);
                    this.recoverAudOrgUnitCheck(bgBaseDatas, bgDataState, optType);
                    Set<String> tmpSet = this.updateBaseData(conn, cubeName, bgBaseDatas, _audOrgUnitId, _audUserId, optType);
                    if (tmpSet == null) continue;
                    upBgDataIds.addAll(tmpSet);
                }
            }
            pool.releaseTable(orgUnitTmpTable);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        logger.debug((Object)("end UnAudit OrgUnit Data! UnAudit OrgUnit Data use Time!" + (System.currentTimeMillis() - begin)));
    }

    public List checkBatchUnAudit(List formIDs, BOSUuid userID, BOSUuid orgID) throws BOSException, EASBizException {
        if (this.ctx == null || formIDs == null || formIDs.isEmpty() || userID == null || orgID == null) {
            return null;
        }
        System.out.println("begin Check UnAudit OrgUnit Data!");
        long begin = System.currentTimeMillis();
        ArrayList<BgUnAuditCheckResult> msgList = new ArrayList<BgUnAuditCheckResult>();
        int size = formIDs.size();
        for (int index = 0; index < size; ++index) {
            BgUnAuditCheckResult result = this.checkCanUnAudit(BOSUuid.read((String)formIDs.get(index).toString()), orgID, userID, 1);
            if (result == null) continue;
            msgList.add(result);
        }
        System.out.println("end Check UnAudit OrgUnit Data!");
        long end = System.currentTimeMillis();
        System.out.println("Check UnAudit OrgUnit Data use Time!" + (end - begin));
        return msgList;
    }

    public List<String> getChildByBgForm(BOSUuid billId) throws BOSException, EASBizException {
        List<String> bgFormIds = new ArrayList<String>();
        if (this.ctx == null || billId == null) {
            return bgFormIds;
        }
        BgFormInfo formInfo = BgViewServerHelper.getBgFormInfoNoQueryData(this.ctx, billId, false);
        if (formInfo == null) {
            return bgFormIds;
        }
        BOSUuid bgSchemeId = formInfo.getBgScheme().getId();
        BOSUuid rootTemplateId = formInfo.getBgTemplate().getRootId();
        BOSUuid orgUnitId = formInfo.getOrgUnit().getId();
        BOSUuid bgPeriodId = formInfo.getBgPeriod().getId();
        BOSUuid currencyId = formInfo.getCurrency().getId();
        BOSUuid bgVersionId = formInfo.getBgVersion().getId();
        BgSchemeInfo rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgSchemeId);
        if (rootScheme == null) {
            return bgFormIds;
        }
        BgSchemeDimensionHelper schemehelper = this.getSchemeHelper(rootScheme.getId().toString());
        String orgViewId = schemehelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        Connection conn = null;
        String orgUnitTmpTable = null;
        List<String> orgUnitIds = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            orgUnitIds = this.getSubOrgUnitIds(conn, orgViewId, this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, orgUnitId.toString()).getLongNumber());
            if (orgUnitIds.isEmpty()) {
                List<String> list = null;
                return list;
            }
            orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), orgUnitIds);
            bgFormIds = formInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM) ? this.getBgFormSpecialIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, null, this.getSpecialItemNumberByForm(formInfo)) : this.getBgFormIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, null);
            pool.releaseTable(orgUnitTmpTable);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup((Connection)conn);
        }
        SQLUtils.cleanup((Connection)conn);
        return bgFormIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BgUnAuditCheckResult checkCanUnAudit(BOSUuid billId, BOSUuid audOrgUnitId, BOSUuid audUserId, int valueType) throws BOSException, EASBizException {
        BgUnAuditCheckResult bgUnAuditCheckResult;
        HashMap subMemberTmpTableMap;
        String orgUnitTmpTable;
        IRowSet rst;
        Statement pstmt;
        Connection conn;
        TempTablePool pool;
        block58: {
            BgUnAuditCheckResult bgUnAuditCheckResult2;
            block57: {
                BgUnAuditCheckResult bgUnAuditCheckResult3;
                block56: {
                    BgUnAuditCheckResult bgUnAuditCheckResult4;
                    block55: {
                        BgUnAuditCheckResult bgUnAuditCheckResult5;
                        block54: {
                            BgUnAuditCheckResult bgUnAuditCheckResult6;
                            block52: {
                                if (this.ctx == null) return null;
                                if (billId == null) return null;
                                if (audOrgUnitId == null) return null;
                                if (audUserId == null) {
                                    return null;
                                }
                                BgFormInfo formInfo = BgViewServerHelper.getBgFormInfoNoQueryData(this.ctx, billId, false);
                                if (formInfo == null) {
                                    return null;
                                }
                                BOSUuid bgSchemeId = formInfo.getBgScheme().getId();
                                BOSUuid rootTemplateId = formInfo.getBgTemplate().getRootId();
                                BOSUuid orgUnitId = formInfo.getOrgUnit().getId();
                                BOSUuid bgPeriodId = formInfo.getBgPeriod().getId();
                                BOSUuid currencyId = formInfo.getCurrency().getId();
                                BOSUuid bgVersionId = formInfo.getBgVersion().getId();
                                BgSchemeInfo rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgSchemeId);
                                if (rootScheme == null) {
                                    return null;
                                }
                                BgSchemeDimensionHelper schemehelper = this.getSchemeHelper(rootScheme.getId().toString());
                                String orgViewId = schemehelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
                                String cubeName = BgCubeUtils.getCubeName(rootScheme.getRefCube(), valueType);
                                String cubeEntryName = BgCubeUtils.getCubeEntryName(rootScheme.getRefCube(), valueType);
                                BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(this.ctx, schemehelper, cubeName);
                                if (accIntHelper.isUseAccInt()) {
                                    return null;
                                }
                                BgUnAuditCheckResult result = new BgUnAuditCheckResult();
                                result.setId(formInfo.getId().toString());
                                result.setName(formInfo.getName());
                                result.setNumber(formInfo.getNumber());
                                pool = TempTablePool.getInstance((Context)this.ctx);
                                conn = null;
                                pstmt = null;
                                rst = null;
                                orgUnitTmpTable = null;
                                bgBaseData data = null;
                                IMbgViewBase view = null;
                                List<String> orgUnitIds = null;
                                List<String> tmpList = null;
                                Set<String> pOrgUnitIds = null;
                                HashSet<String> subOrgUnitIds = new HashSet<String>();
                                HashSet<String> bgPeriodNums = new HashSet<String>();
                                HashSet<String> versionNums = new HashSet<String>();
                                subMemberTmpTableMap = new HashMap();
                                try {
                                    Object subMap;
                                    conn = BgDBUtils.getConnection((Context)this.ctx);
                                    BgOrgUnitInfo formOrg = this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, orgUnitId.toString());
                                    AuditParam auditParam = new AuditParam(this.ctx);
                                    auditParam.bgOrgViewId = BOSUuid.read((String)orgViewId);
                                    ArrayList<String> billIds = new ArrayList<String>();
                                    billIds.add(billId.toString());
                                    BaseBiz.queryParentNoEdit(conn, billIds, auditParam);
                                    HashMap<String, Object> checkParentResult = new HashMap<String, Object>();
                                    BaseBiz.checkParentNoEdit(formInfo, auditParam, checkParentResult);
                                    if (checkParentResult.containsKey("CHECK_RESULT_PARENT_NOEDIT") && (subMap = (Map)checkParentResult.get("CHECK_RESULT_PARENT_NOEDIT")).containsKey(billId.toString())) {
                                        String[] subStrings = (String[])subMap.get(billId.toString());
                                        result.setOtherMessage("unAuditByParentState:" + subStrings[5]);
                                        result.setCanUnAudit(false);
                                        BgUnAuditCheckResult bgUnAuditCheckResult7 = result;
                                        return bgUnAuditCheckResult7;
                                    }
                                    if (!formOrg.isIsLeaf()) {
                                        subMap = result;
                                        return subMap;
                                    }
                                    orgUnitIds = this.getSubOrgUnitIds(conn, orgViewId, formOrg.getLongNumber());
                                    if (orgUnitIds.isEmpty()) {
                                        subMap = null;
                                        return subMap;
                                    }
                                    String audOrgLongNumber = this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, audOrgUnitId.toString()).getLongNumber();
                                    pOrgUnitIds = this.getParentOrgUnitIds(conn, orgViewId, audOrgLongNumber);
                                    tmpList = this.getSubOrgUnitIds(conn, orgViewId, audOrgLongNumber);
                                    subOrgUnitIds.addAll(tmpList);
                                    orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), orgUnitIds);
                                    List<String> bgFormIds = null;
                                    bgFormIds = formInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM) ? this.getBgFormSpecialIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, null, this.getSpecialItemNumberByForm(formInfo)) : this.getBgFormIds(conn, rootScheme.getId(), orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId, bgVersionId, null);
                                    boolean isHavaData = false;
                                    boolean isHavaParentData = false;
                                    boolean isHaveSubData = false;
                                    HashSet<String> orgSets = new HashSet<String>();
                                    String orgParentAuditId = null;
                                    if (!bgFormIds.isEmpty()) {
                                        Set<String> check = this.checkHasAdjust(conn, bgFormIds);
                                        if (!check.isEmpty()) {
                                            result.setCanUnAudit(false);
                                            result.setHasAdjust(true);
                                            bgUnAuditCheckResult6 = result;
                                            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                                            break block52;
                                        }
                                        String sql = "select distinct FAudOrgUnitID, FOrgUnitID  from " + cubeName + " where FID in (select FDataID from " + cubeEntryName + " where FFormID = ?)";
                                        for (String bgFormId : bgFormIds) {
                                            if (isHavaParentData && isHaveSubData) continue;
                                            try {
                                                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{bgFormId});
                                                while (rst.next()) {
                                                    if (!isHavaData) {
                                                        isHavaData = true;
                                                    }
                                                    data = new bgBaseData();
                                                    data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                                    orgSets.add(rst.getString("FOrgUnitID"));
                                                    orgParentAuditId = data.getAudOrgUnitId();
                                                    if (!isHaveSubData && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                                                        isHaveSubData = true;
                                                    }
                                                    if (!isHavaParentData && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                                                        isHavaParentData = true;
                                                    }
                                                    if (!isHavaParentData || !isHaveSubData) continue;
                                                    break;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                SQLUtils.cleanup(rst);
                                                throw throwable;
                                            }
                                            SQLUtils.cleanup((ResultSet)rst);
                                        }
                                        sql = "select top 1 FID from " + cubeName + " where FID in (select FDataID from " + cubeEntryName + " where FFormID = ?) and FState IN (?, ?)";
                                        for (String bgFormId : bgFormIds) {
                                            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{bgFormId, 11, 13});
                                            if (!rst.next()) continue;
                                            result.setCanUnAudit(false);
                                            result.hasUnionData = true;
                                            BgUnAuditCheckResult bgUnAuditCheckResult8 = result;
                                            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                                            pool.releaseTable(orgUnitTmpTable);
                                            SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                                            return bgUnAuditCheckResult8;
                                            finally {
                                                SQLUtils.cleanup((ResultSet)rst);
                                            }
                                        }
                                    }
                                    Set<String> bgDataIds = this.checkHasAdjustData(conn, cubeName, orgUnitTmpTable);
                                    if (!isHaveSubData || !isHavaParentData) {
                                        IBgDimensionManagerBase manager = null;
                                        BgUnAuditCheckData checkData = null;
                                        view = DimensionCommonHelper.getBgFormView(this.ctx, formInfo);
                                        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formInfo.getBgTemplate().getFormType())) {
                                            view = MBGFormFacadeFactory.getLocalInstance(this.ctx).loadViewManager(billId.toString(), null, (IMbgViewManager)view, null, orgUnitId.toString(), true, false);
                                        } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formInfo.getBgTemplate().getFormType())) {
                                            Map viewMap = MBGViewListFormFacadeFactory.getLocalInstance(this.ctx).initViewListData(formInfo, null, orgViewId, (MbgViewListManager)view, null);
                                            view = (IMbgViewBase)viewMap.get("dimensino.member");
                                        }
                                        if (view != null && view.getSheetManagers() != null) {
                                            int in = view.getSheetManagers().size();
                                            for (int i = 0; i < in; ++i) {
                                                manager = view.getSheetManagers().get(i).getDimensionManager();
                                                if (manager == null || isHaveSubData && isHavaParentData) continue;
                                                IBizData bizData = this.getBizDataInstance(view);
                                                checkData = bizData.checkData(conn, pool, cubeName, view, manager, formInfo, rootScheme, orgUnitIds, pOrgUnitIds, subOrgUnitIds, bgDataIds, isHaveSubData, isHavaParentData, orgParentAuditId);
                                                if (checkData.getResult() != null) {
                                                    bgUnAuditCheckResult5 = checkData.getResult();
                                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                                                    break block54;
                                                }
                                                isHaveSubData = checkData.isHaveSubData;
                                                isHavaParentData = checkData.isHavaParentData();
                                                if (StringUtils.isEmpty((String)orgParentAuditId)) {
                                                    orgParentAuditId = checkData.getOrgParentAuditId();
                                                }
                                                if (isHavaParentData && isHaveSubData) break;
                                            }
                                        }
                                    }
                                    String orgName = null;
                                    if (orgParentAuditId != null) {
                                        orgName = this.getOrgUnitInfo(this.ctx.getLocale(), conn, orgViewId, orgParentAuditId).getName();
                                    }
                                    if (view == null) {
                                        view = DimensionCommonHelper.getBgFormView(this.ctx, formInfo);
                                        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formInfo.getBgTemplate().getFormType())) {
                                            view = MBGFormFacadeFactory.getLocalInstance(this.ctx).loadViewManager(billId.toString(), null, (IMbgViewManager)view, null, orgUnitId.toString(), true, false);
                                        } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formInfo.getBgTemplate().getFormType())) {
                                            Map _result = MBGViewListFormFacadeFactory.getLocalInstance(this.ctx).initViewListData(formInfo, null, orgViewId, (MbgViewListManager)view, null);
                                            view = (IMbgViewBase)_result.get("dimensino.member");
                                        }
                                    }
                                    HashSet<String> mbgDimNums = new HashSet<String>();
                                    mbgDimNums.add(DimensionBaseConstants.DEF_PERIOD_NUMBER);
                                    mbgDimNums.add(DimensionBaseConstants.DEF_VERSION_NUMBER);
                                    bgPeriodNums.add(formInfo.getBgPeriod().getNumber());
                                    versionNums.add(formInfo.getBizVersion().getNumber());
                                    if (this.isFetchSingleValue(this.ctx, conn, rootScheme, orgSets, bgPeriodNums, versionNums)) {
                                        result.setCanUnAudit(false);
                                        result.setOtherMessage("cantUnAuditByFetchSingleValue");
                                        bgUnAuditCheckResult4 = result;
                                        BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                                        break block55;
                                    }
                                    if (isHavaParentData) {
                                        if (isHaveSubData) {
                                            result.setCanUnAudit(true);
                                            result.setNeedMes(true);
                                            bgUnAuditCheckResult3 = result;
                                            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                                            break block56;
                                        }
                                        result.setOtherMessage("cantUnAuditByParentOrg:" + orgName);
                                        result.setCanUnAudit(false);
                                        bgUnAuditCheckResult2 = result;
                                        BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                                        break block57;
                                    }
                                    bgUnAuditCheckResult = result;
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                                    break block58;
                                }
                                catch (SQLException ex) {
                                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                                }
                                catch (EASBizException ex) {
                                    throw ex;
                                }
                                catch (Exception ex) {
                                    throw new BOSException((Throwable)ex);
                                }
                            }
                            pool.releaseTable(orgUnitTmpTable);
                            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                            return bgUnAuditCheckResult6;
                        }
                        pool.releaseTable(orgUnitTmpTable);
                        SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                        return bgUnAuditCheckResult5;
                    }
                    pool.releaseTable(orgUnitTmpTable);
                    SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                    return bgUnAuditCheckResult4;
                }
                pool.releaseTable(orgUnitTmpTable);
                SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                return bgUnAuditCheckResult3;
            }
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
            return bgUnAuditCheckResult2;
        }
        pool.releaseTable(orgUnitTmpTable);
        SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
        return bgUnAuditCheckResult;
        finally {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    private boolean isFetchSingleValue(Context ctx, Connection conn, BgSchemeInfo bgScheme, Set<String> orgUnitIds, Set<String> bgPeriodNums, Set<String> versionNums) throws Exception {
        return false;
    }

    private void updateAudOrgUnitCheck(List<bgBaseData> bgBaseDatas, int bgDataState) {
        if (bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return;
        }
        bgBaseData data = null;
        int in = bgBaseDatas.size();
        for (int i = 0; i < in; ++i) {
            data = bgBaseDatas.get(i);
            if (data.getState() >= bgDataState) continue;
            data.setState(bgDataState);
        }
    }

    private void updateDataStateCheck(List<bgBaseData> bgBaseDatas, int bgDataState) {
        if (bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return;
        }
        ArrayList<bgBaseData> tmpList = new ArrayList<bgBaseData>();
        bgBaseData data = null;
        int in = bgBaseDatas.size();
        for (int i = 0; i < in; ++i) {
            data = bgBaseDatas.get(i);
            if (bgDataState == 1 && data.getState() == 3) {
                tmpList.add(data);
                data.setState(bgDataState);
                continue;
            }
            if (bgDataState != 3 || data.getState() != 1) continue;
            tmpList.add(data);
            data.setState(bgDataState);
        }
        bgBaseDatas.clear();
        bgBaseDatas.addAll(tmpList);
    }

    private void recoverAudOrgUnitCheck(List<bgBaseData> bgBaseDatas, int bgDataState, boolean optType) {
        if (bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return;
        }
        ArrayList<bgBaseData> tmpList = new ArrayList<bgBaseData>();
        boolean check = false;
        bgBaseData data = null;
        int in = bgBaseDatas.size();
        for (int i = 0; i < in; ++i) {
            data = bgBaseDatas.get(i);
            boolean bl = check = optType && data.getState() == 3 || !optType && data.getState() == 9;
            if (!check) continue;
            tmpList.add(data);
            data.setState(bgDataState);
            data.setAudOrgUnitId(null);
        }
        bgBaseDatas.clear();
        bgBaseDatas.addAll(tmpList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAudFormState(Connection conn, BgFormInfo bgFormInfo, List<String> bgFormIds, BOSUuid audUserId, int formState, String auditIdea) throws SQLException {
        PreparedStatement pstmt;
        block14: {
            if (conn == null || bgFormIds == null || bgFormIds.isEmpty() || audUserId == null) {
                return;
            }
            int batchIndex = 0;
            String _auUserId = audUserId.toString();
            Timestamp _time = new Timestamp(System.currentTimeMillis());
            StringBuffer sql = new StringBuffer();
            if (formState == 2) {
                sql.append("update T_MBG_BgForm set FState = ?, FAuditorId = ?, FAuditedTime = ? where FID = ?");
            } else if (formState == 41) {
                sql.append("update T_MBG_BgForm set FState = ?, FCertificateUserId = ?, FCertificateTime = ? where FID = ?");
            }
            pstmt = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (String bgFormId : bgFormIds) {
                    pstmt.setInt(1, formState);
                    pstmt.setString(2, _auUserId);
                    pstmt.setTimestamp(3, _time);
                    pstmt.setString(4, bgFormId);
                    pstmt.addBatch();
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex > 0) {
                    pstmt.executeBatch();
                }
                if (2 != formState && 1 != formState) break block14;
                CoreBaseCollection colls = new CoreBaseCollection();
                ArrayList comments = new ArrayList();
                BgAuditIdeaInfo bgAuditIdea = null;
                BgCourseCommentInfo comment = null;
                Timestamp time = new Timestamp(System.currentTimeMillis());
                UserInfo userInfo = new UserInfo();
                userInfo.setId(audUserId);
                for (String bgFormId : bgFormIds) {
                    if (bgFormId.equals(bgFormInfo.getId().toString())) continue;
                    bgAuditIdea = new BgAuditIdeaInfo();
                    bgAuditIdea.setCreator(userInfo);
                    bgAuditIdea.setCreateTime(time);
                    bgAuditIdea.setIdea(auditIdea);
                    bgAuditIdea.setFormId(BOSUuid.read((String)bgFormId));
                    colls.add((CoreBaseInfo)bgAuditIdea);
                    comment = new BgCourseCommentInfo();
                    comment.setBgFormId(bgFormId);
                    comment.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                    if (2 == formState) {
                        int _state = bgFormInfo.getState().getValue();
                        if (_state == 4 || _state == 35) {
                            bgAuditIdea.setState(BgAuditIdeaEnum.ADJUSTPASS);
                        } else {
                            bgAuditIdea.setState(BgAuditIdeaEnum.AUDITPASS);
                        }
                        comment.setState(BgCourseOperateEnum.Confirm);
                        continue;
                    }
                    if (1 != formState) continue;
                    bgAuditIdea.setState(BgAuditIdeaEnum.UNAUDIT);
                    comment.setState(BgCourseOperateEnum.UnConfirm);
                }
                try {
                    BgAuditIdeaFactory.getLocalInstance(this.ctx).addnewBatchData(colls);
                    BgCourseCommentFactory.getLocalInstance(this.ctx).batchAddnew(comments);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverAudOrgUnitState(Connection conn, BgFormInfo bgFormInfo, List<String> bgFormIds, BOSUuid audOrgUnitId, BOSUuid audUserId, boolean optType, String auditIdea) throws SQLException {
        PreparedStatement pstmt;
        block14: {
            if (conn == null || bgFormIds == null || bgFormIds.isEmpty()) {
                return;
            }
            pstmt = null;
            int srcState = 2;
            int distState = 1;
            if (optType) {
                srcState = 41;
                distState = 40;
            } else {
                srcState = 2;
                distState = 1;
            }
            int batchSize = 50;
            int batchIndex = 0;
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String _audUserId = audUserId.toString();
            try {
                if (!optType) {
                    Set<String> tmpBillIds = this.checkHasAdjust(conn, bgFormIds);
                    if (tmpBillIds != null) {
                        bgFormIds.removeAll(tmpBillIds);
                    }
                    if ((tmpBillIds = this.checkHasDailyActual(conn, bgFormIds)) != null) {
                        bgFormIds.removeAll(tmpBillIds);
                    }
                }
                if (!bgFormIds.isEmpty()) {
                    pstmt = conn.prepareStatement("UPDATE T_MBG_BGFORM Set FCertificateUserId = '', FCertificateTime = null, FIsConfirm = 0, FState = ?, FAuditorID = ?, FAuditedTime=? WHERE FID = ? and FState =?");
                    for (String bgFormId : bgFormIds) {
                        pstmt.setInt(1, distState);
                        pstmt.setString(2, "");
                        pstmt.setTimestamp(3, null);
                        pstmt.setString(4, bgFormId);
                        pstmt.setInt(5, srcState);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex > 0) {
                        pstmt.executeBatch();
                    }
                }
                if (1 != distState || 2 != srcState) break block14;
                CoreBaseCollection colls = new CoreBaseCollection();
                ArrayList comments = new ArrayList();
                BgAuditIdeaInfo bgAuditIdea = null;
                BgCourseCommentInfo comment = null;
                UserInfo userInfo = new UserInfo();
                userInfo.setId(audUserId);
                for (String bgFormId : bgFormIds) {
                    if (bgFormId.equals(bgFormInfo.getId().toString())) continue;
                    bgAuditIdea = new BgAuditIdeaInfo();
                    bgAuditIdea.setCreator(userInfo);
                    bgAuditIdea.setCreateTime(time);
                    bgAuditIdea.setIdea(auditIdea);
                    bgAuditIdea.setFormId(BOSUuid.read((String)bgFormId));
                    bgAuditIdea.setState(BgAuditIdeaEnum.UNAUDIT);
                    colls.add((CoreBaseInfo)bgAuditIdea);
                    comment = new BgCourseCommentInfo();
                    comment.setBgFormId(bgFormId);
                    comment.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                    comment.setState(BgCourseOperateEnum.UnConfirm);
                }
                try {
                    BgAuditIdeaFactory.getLocalInstance(this.ctx).addnewBatchData(colls);
                    BgCourseCommentFactory.getLocalInstance(this.ctx).batchAddnew(comments);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private Set<String> checkHasAdjust(Connection conn, List<String> bgFormIds) throws SQLException {
        if (conn == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT FAdjustId FROM T_MBg_BgForm WHERE FAdjustId IN (");
        int in = 50;
        for (int i = 1; i < in; ++i) {
            sql.append("?,");
        }
        sql.append("?) and FID <> FAdjustId");
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.addAll(bgFormIds);
        HashSet<String> adjustIds = new HashSet<String>();
        List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams);
        for (Object[] objs : result) {
            adjustIds.add(objs[0].toString());
        }
        return adjustIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> checkHasAdjustData(Connection conn, String cubeName, String orgUnitTmpTable) throws SQLException {
        StringBuffer sql = new StringBuffer("select t.FID from " + cubeName + " t  join T_MBG_BgPastData p on t.FID = p.FBgDataId  join T_MBG_BgPastRecord r on p.FPastRecordId = r.FID  where t.FOrgUnitID IN (select FID from " + orgUnitTmpTable + ") and r.FPastSource <> " + 12);
        IRowSet rst = null;
        HashSet<String> bgDataIds = new HashSet<String>();
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                bgDataIds.add(rst.getString(1));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgDataIds;
    }

    private Set<String> checkHasDailyActual(Connection conn, List<String> bgFormIds) throws SQLException {
        if (conn == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT FBgFormId FROM T_MBG_BgActualRecord WHERE FBgFormId IN (");
        int in = 50;
        for (int i = 1; i < in; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.addAll(bgFormIds);
        HashSet<String> dailyIds = new HashSet<String>();
        List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams);
        for (Object[] objs : result) {
            dailyIds.add(objs[0].toString());
        }
        return dailyIds;
    }

    private List<String[]> getFormulaByDims(List<IDimension> dims) {
        ArrayList<String[]> relationData = new ArrayList<String[]>();
        if (dims == null || dims.isEmpty()) {
            return relationData;
        }
        String[] tmpStr = null;
        IDimension dimension = dims.get(0);
        tmpStr = new String[]{dimension.getField()};
        relationData.add(tmpStr);
        if (DimUtils.checkBaseDimension(dimension)) {
            for (IMember member : dimension.getDimensionMember()) {
                tmpStr = new String[]{member.getNumber()};
                relationData.add(tmpStr);
            }
        } else {
            for (IMember member : dimension.getDimensionMember()) {
                tmpStr = new String[]{member.getDimNumber()};
                relationData.add(tmpStr);
            }
        }
        return this.getFormulaByRelation(relationData, dims);
    }

    private List<String[]> getFormulaByRelation(List<String[]> relationData, List<IDimension> dims) {
        int i;
        if (relationData == null || relationData.isEmpty() || dims == null) {
            return relationData;
        }
        IDimension bgPeriodDim = DimUtils.getDimension(dims, DimensionConstants.DEF_PERIOD_NUMBER);
        IDimension bgElementDim = DimUtils.getDimension(dims, DimensionConstants.DEF_ELEMENT_NUMBER);
        IDimension currencyDim = DimUtils.getDimension(dims, DimensionConstants.DEF_CURRENCY_NUMBER);
        if (bgPeriodDim == null || bgElementDim == null || currencyDim == null) {
            return relationData;
        }
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String[]> tmpRelData = new ArrayList<String[]>();
        HashSet<String> refFields = new HashSet<String>();
        String field = null;
        String[] tmpStrs = null;
        String[] relField = relationData.get(0);
        int in = relationData.size();
        for (i = 1; i < in; ++i) {
            tmpRelData.add(relationData.get(i));
        }
        relationData.clear();
        in = relField.length;
        for (i = 0; i < in; ++i) {
            fields.add(relField[i]);
        }
        refFields.addAll(fields);
        for (IDimension dimension : dims) {
            field = dimension.getField();
            if (refFields.contains(field)) continue;
            fields.add(field);
            refFields.add(field);
            tmpStrs = new String[relField.length + 1];
            System.arraycopy(relField, 0, tmpStrs, 0, relField.length);
            tmpStrs[relField.length] = field;
            relField = tmpStrs;
            if (DimUtils.checkBaseDimension(dimension)) {
                for (IMember member : dimension.getDimensionMember()) {
                    if (!tmpRelData.isEmpty()) {
                        for (String[] relData : tmpRelData) {
                            tmpStrs = new String[relData.length + 1];
                            System.arraycopy(relData, 0, tmpStrs, 0, relData.length);
                            tmpStrs[relData.length] = member.getNumber();
                            relationData.add(tmpStrs);
                        }
                        continue;
                    }
                    tmpStrs = new String[relField.length];
                    tmpStrs[relField.length - 1] = member.getNumber();
                    relationData.add(tmpStrs);
                }
            } else {
                for (IMember member : dimension.getDimensionMember()) {
                    if (!tmpRelData.isEmpty()) {
                        for (String[] relData : tmpRelData) {
                            tmpStrs = new String[relData.length + 1];
                            System.arraycopy(relData, 0, tmpStrs, 0, relData.length);
                            tmpStrs[relData.length] = member.getDimNumber();
                            relationData.add(tmpStrs);
                        }
                        continue;
                    }
                    tmpStrs = new String[relField.length];
                    tmpStrs[relField.length - 1] = member.getDimNumber();
                    relationData.add(tmpStrs);
                }
            }
            tmpRelData.clear();
            tmpRelData.addAll(relationData);
            relationData.clear();
        }
        relationData.add(relField);
        relationData.addAll(tmpRelData);
        return relationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgOrgUnitInfo getOrgUnitInfo(Locale locale, Connection conn, String orgViewId, String orgUnitId) throws SQLException {
        if (conn == null || orgViewId == null || orgUnitId == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgOrgUnitInfo orgUnitInfo = null;
        try {
            pstmt = conn.prepareStatement("Select FName_" + locale + " AS FName, FLongNumber, FIsLeaf FROM T_Mbg_BgOrgUnit Where FIsVirtual = 0 AND FViewId = ? AND FOrgUnitId = ?");
            pstmt.setString(1, orgViewId);
            pstmt.setString(2, orgUnitId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                orgUnitInfo = new BgOrgUnitInfo();
                orgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                orgUnitInfo.setName(rst.getString("FName"));
                orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return orgUnitInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSubOrgUnitIds(Connection conn, String orgViewId, String orgLongNumber) throws SQLException {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (conn == null || orgViewId == null || orgLongNumber == null) {
            return orgUnitIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FOrgUnitID from T_MBG_BgOrgUnit t where FIsVirtual = 0 AND t.FViewId = ? and (t.FLongNumber = ? OR t.FLongNumber like ?) order by t.FLongNumber");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{orgViewId.toString(), orgLongNumber, orgLongNumber + "!%"});
            while (rst.next()) {
                orgUnitIds.add(rst.getString("FOrgUnitID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getParentOrgUnitIds(Connection conn, String orgViewId, String orgLongNumber) throws SQLException {
        HashSet<String> pOrgUnitIds = new HashSet<String>();
        if (conn == null || orgViewId == null || orgLongNumber == null) {
            return pOrgUnitIds;
        }
        String[] pOrgUnitNums = orgLongNumber.split("!");
        if (pOrgUnitNums != null && pOrgUnitNums.length > 1) {
            String query = "select FOrgUnitID from T_MBG_BgOrgUnit where FVIewId = ? AND FNumber IN (";
            int in = pOrgUnitNums.length - 1;
            for (int i = 0; i < in; ++i) {
                query = query + "'" + pOrgUnitNums[i] + "',";
            }
            query = query.substring(0, query.length() - 1) + ")";
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)query, (Object[])new Object[]{orgViewId});
                while (rst.next()) {
                    pOrgUnitIds.add(rst.getString("FOrgUnitID"));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        return pOrgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBgFormIds(Connection conn, BOSUuid bgSchemeRootId, String orgUnitTmpTable, BOSUuid rootTemplateId, BOSUuid bgPeriodId, BOSUuid currencyId, BOSUuid bgVersionId, BgFormStateEnum[] states) throws SQLException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        if (conn == null || StringUtils.isEmpty((String)orgUnitTmpTable) || rootTemplateId == null || bgPeriodId == null || currencyId == null) {
            return bgFormIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID from T_MBG_BgForm f join T_MBG_BgTemplate t on f.FBgTemplateID = t.FID where f.FBgSchemeId = ? AND t.FRootID = ? and f.FBgPeriodID = ? and f.FCurrencyID = ? and FBgVersionId = ? and f.FOrgUnitID in (select FID from " + orgUnitTmpTable + ") and f.FState IN ");
        if (states == null) {
            sql.append(bgFormState);
        } else {
            sql.append("(");
            for (int i = 0; i < states.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(states[i].getValue());
            }
            sql.append(")");
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeRootId.toString(), rootTemplateId.toString(), bgPeriodId.toString(), currencyId.toString(), bgVersionId.toString()});
            while (rst.next()) {
                bgFormIds.add(rst.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgFormIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBgFormSpecialIds(Connection conn, BOSUuid bgSchemeRootId, String orgUnitTmpTable, BOSUuid rootTemplateId, BOSUuid bgPeriodId, BOSUuid currencyId, BOSUuid bgVersionId, BgFormStateEnum[] states, String specialItemNumber) throws SQLException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        if (conn == null || StringUtils.isEmpty((String)orgUnitTmpTable) || rootTemplateId == null || bgPeriodId == null || currencyId == null || specialItemNumber == null) {
            return bgFormIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID from T_MBG_BgForm f  join T_MBG_BgTemplate t on f.FBgTemplateID = t.FID  join T_MBG_BgSpecialItems s on s.FBgFormId = f.FId  where f.FBgSchemeId = ? AND t.FRootID = ? and f.FBgPeriodID = ? and f.FCurrencyID = ? and FBgVersionId = ?  and s.FDimensionNumber = ?  and f.FOrgUnitID in (select FID from " + orgUnitTmpTable + ") and f.FState IN ");
        if (states == null) {
            sql.append(bgFormState);
        } else {
            sql.append("(");
            for (int i = 0; i < states.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(states[i].getValue());
            }
            sql.append(")");
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeRootId.toString(), rootTemplateId.toString(), bgPeriodId.toString(), currencyId.toString(), bgVersionId.toString(), specialItemNumber});
            while (rst.next()) {
                bgFormIds.add(rst.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgFormIds;
    }

    private String getSpecialItemNumberByForm(BgFormInfo bgFormInfo) {
        String itemNumber = null;
        if (bgFormInfo != null && bgFormInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM) && bgFormInfo.getBgSpecialItems().get(0) != null) {
            itemNumber = bgFormInfo.getBgSpecialItems().get(0).getDimensionNumber();
        }
        return itemNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<bgBaseData> queryBaseData(Connection conn, String cubeName, String cubeEntryName, String bgFormId, Set<String> pOrgUnitIds) throws SQLException {
        ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
        if (conn == null || StringUtils.isEmpty((String)cubeName) || StringUtils.isEmpty((String)cubeEntryName) || StringUtils.isEmpty((String)bgFormId) || pOrgUnitIds == null) {
            return bgBaseDatas;
        }
        String querySql = "select FID, FState, FAudOrgUnitID from " + cubeName + " where FID in (select FDataID from " + cubeEntryName + " where FFormID = ?)";
        bgBaseData data = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)querySql, (Object[])new Object[]{bgFormId});
            while (rst.next()) {
                data = new bgBaseData();
                data.setFid(rst.getString("FID"));
                data.setState(rst.getInt("FState"));
                data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                if (data.getAudOrgUnitId() != null && pOrgUnitIds.contains(data.getAudOrgUnitId())) continue;
                bgBaseDatas.add(data);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgBaseDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOrgUnitHasData(Connection conn, String cubeName, String orgUnitId) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean hasData = false;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FID from " + cubeName + " where FOrgUnitId = ?"), (Object[])new Object[]{orgUnitId});
            if (rst.next()) {
                hasData = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return hasData;
    }

    private IBizData getBizDataInstance(IMbgViewBase view) {
        if (view instanceof MbgViewListManager) {
            return new BizViewListDataImpl();
        }
        if (view instanceof IMbgViewManager) {
            if (this.hasRelation((IMbgViewManager)view)) {
                return new BizViewDataImpl();
            }
            return new BizFixDataImpl();
        }
        return null;
    }

    private boolean hasRelation(IMbgViewManager view) {
        return view != null && view.getRelationMaps() != null && !view.getRelationMaps().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> updateBaseData(Connection conn, String cubeName, List<bgBaseData> bgBaseDatas, String audOrgUnitId, String audUserId, boolean optType) throws SQLException {
        HashSet<String> bgDataIds = new HashSet<String>();
        if (conn == null || StringUtils.isEmpty((String)cubeName) || bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return bgDataIds;
        }
        String updateSql = "update " + cubeName + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ? where FID = ?";
        PreparedStatement pstmt = null;
        bgBaseData data = null;
        int batchIndex = 0;
        try {
            pstmt = conn.prepareStatement(updateSql);
            int in = bgBaseDatas.size();
            for (int i = 0; i < in; ++i) {
                data = bgBaseDatas.get(i);
                bgDataIds.add(data.getFid());
                pstmt.setInt(1, data.getState());
                if (optType || data.getState() == 1) {
                    pstmt.setString(2, null);
                    pstmt.setString(3, null);
                } else {
                    pstmt.setString(2, audOrgUnitId);
                    pstmt.setString(3, audUserId);
                }
                pstmt.setString(4, data.getFid());
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return bgDataIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> updateBaseState(Connection conn, String cubeName, List<bgBaseData> bgBaseDatas) throws SQLException {
        HashSet<String> bgDataIds = new HashSet<String>();
        if (conn == null || StringUtils.isEmpty((String)cubeName) || bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return bgDataIds;
        }
        String updateSql = "update " + cubeName + " set FState = ? where FID = ?";
        PreparedStatement pstmt = null;
        bgBaseData data = null;
        int batchIndex = 0;
        try {
            pstmt = conn.prepareStatement(updateSql);
            int in = bgBaseDatas.size();
            for (int i = 0; i < in; ++i) {
                data = bgBaseDatas.get(i);
                bgDataIds.add(data.getFid());
                pstmt.setInt(1, data.getState());
                pstmt.setString(2, data.getFid());
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return bgDataIds;
    }

    public Map<String, BgPeriodDispInfo> getBgPeriodMap(Connection conn, List<String> bgPeriodNums, BgSchemeInfo rootScheme) throws EASBizException, BOSException {
        final HashMap<String, BgPeriodDispInfo> bgPeriodMap = new HashMap<String, BgPeriodDispInfo>();
        if (conn == null || bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return bgPeriodMap;
        }
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        _bgPeriodSet.addAll(bgPeriodNums);
        Object[] bgPeriodTypeNumbers = this.getSchemeHelper(rootScheme.getId().toString()).getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, false).toArray();
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FBgPeriodID, FNumber, FBeginDate, FEndDate, FTypeId from T_MBG_BgPeriodDisp where FTypeId IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)bgPeriodTypeNumbers.length).append(") ");
        sql.append("AND FNumber IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])bgPeriodTypeNumbers, (Object[])_bgPeriodSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet rst) throws SQLException {
                BgPeriodDispInfo bgPeriodInfo = new BgPeriodDispInfo();
                bgPeriodInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgPeriodInfo.setBgPeriod(new BgPeriodInfo());
                bgPeriodInfo.getBgPeriod().setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                bgPeriodInfo.setNumber(rst.getString("FNumber"));
                bgPeriodInfo.setBeginDate((Date)rst.getDate("FBeginDate"));
                bgPeriodInfo.setEndDate((Date)rst.getDate("FEndDate"));
                bgPeriodInfo.setType(new BgPeriodTypeInfo());
                bgPeriodInfo.getType().setId(BOSUuid.read((String)rst.getString("FTypeId")));
                bgPeriodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
            }
        });
        return bgPeriodMap;
    }

    public void synDataState(Context ctx, String bgFormId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        BOSUuid billId = BOSUuid.read((String)bgFormId);
        int valueType = 1;
        System.out.println("begin synDataState!" + bgFormId);
        long begin = System.currentTimeMillis();
        BgFormInfo formInfo = BgViewServerHelper.getBgFormInfoNoQueryData(ctx, billId, false);
        if (formInfo == null) {
            return;
        }
        String _audUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        BOSUuid bgSchemeId = formInfo.getBgScheme().getId();
        BOSUuid orgUnitId = formInfo.getOrgUnit().getId();
        BgSchemeInfo rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeId);
        if (rootScheme == null) {
            return;
        }
        String orgViewId = rootScheme.getEditOrgViewId().toString();
        String cubeName = BgCubeUtils.getCubeName(rootScheme.getRefCube(), valueType);
        String cubeEntryName = BgCubeUtils.getCubeEntryName(rootScheme.getRefCube(), valueType);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rst = null;
        String orgUnitTmpTable = null;
        List<String> orgUnitIds = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            orgUnitIds = this.getSubOrgUnitIds(conn, orgViewId, this.getOrgLongNumber(conn, orgViewId, orgUnitId.toString()));
            if (orgUnitIds.isEmpty()) {
                return;
            }
            orgUnitTmpTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), orgUnitIds);
            String sql = this.getSynUpdateSql(cubeName) + " where FID in (select FDataID from " + cubeEntryName + " where FFormID = ?) AND " + this.getSynStateFilter();
            List params = this.getSynUpdateBaseParams(_audUserId);
            params.add(bgFormId);
            MbgSqlHelper.execute((Context)ctx, (String)sql, (Object[])params.toArray());
            IBgDimensionManager manager = null;
            IMbgViewBase view = null;
            view = DimensionCommonHelper.getBgFormView(ctx, formInfo);
            if (view != null && view instanceof IMbgViewManager) {
                IMbgViewManager viewManager = null;
                viewManager = (IMbgViewManager)view;
                viewManager = MBGFormFacadeFactory.getLocalInstance(ctx).loadViewManager(billId.toString(), orgViewId, viewManager, null, orgUnitId.toString(), true, false);
                if (viewManager != null && viewManager.getSheetManagers() != null) {
                    int in = viewManager.getSheetManagers().size();
                    for (int i = 0; i < in; ++i) {
                        manager = viewManager.getSheetManagers().get(i).getDimensionManager();
                        if (manager == null) continue;
                        AbstractBizData bizData = null;
                        bizData = this.hasRelation(viewManager) ? new BizViewDataImpl() : new BizFixDataImpl();
                        bizData.synDataState(conn, pool, cubeName, viewManager, manager, formInfo, rootScheme, orgUnitIds, null);
                    }
                }
            } else {
                MbgViewListDimensionManager dimensionManager = null;
                MbgViewListManager viewListManager = MBGViewListFormFacadeFactory.getLocalInstance(ctx).loadViewListManager(bgFormId, orgViewId, (MbgViewListManager)view, null, orgUnitId.toString(), true, false);
                if (viewListManager != null && viewListManager.getSheetManagers() != null) {
                    int in = viewListManager.getSheetManagers().size();
                    for (int i = 0; i < in; ++i) {
                        dimensionManager = ((MbgViewListSheetManager)viewListManager.getSheetManagers().get(i)).getDimensionManager();
                    }
                    BizViewListDataImpl bizData = new BizViewListDataImpl();
                    bizData.synDataState(conn, pool, cubeName, viewListManager, dimensionManager, formInfo, rootScheme, orgUnitIds, null);
                }
            }
            pool.releaseTable(orgUnitTmpTable);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        System.out.println("end synDataState!");
        long end = System.currentTimeMillis();
        System.out.println("SynDataState use Time!" + (end - begin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrgLongNumber(Connection conn, String orgViewId, String orgUnitId) throws SQLException {
        ResultSet rst;
        PreparedStatement pstmt;
        block3: {
            String string;
            if (conn == null) {
                return null;
            }
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement("Select FLongNumber FROM T_Mbg_BgOrgUnit Where FViewId = ? AND FOrgUnitId = ?");
                pstmt.setString(1, orgViewId);
                pstmt.setString(2, orgUnitId);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block3;
                string = rst.getString("FLongNumber");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return null;
    }

    private List getSynUpdateBaseParams(String _audUserId) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(9);
        params.add(_audUserId);
        return params;
    }

    private String getSynUpdateSql(String cubeName) {
        return "Update " + cubeName + " t0 Set FState = ?, FAudUserID = ?, FAudOrgUnitID = FOrgUnitId, FDetail = 1";
    }

    private String getSynStateFilter() {
        return "FState IN(1, 3)";
    }

    class BizFixDataImpl
    extends AbstractBizData {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<bgBaseData> queryBaseData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> upBgDataIds) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || upBgDataIds == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
            List<IDimension> bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            Map<String, String> subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, bgDims);
            String field = null;
            IDimension dimension = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ?");
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            int pos = 0;
            bgBaseData data = null;
            PreparedStatement pstmt = null;
            IRowSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData = BizDataControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId);
                        if (!hasData) continue;
                        pstmt.setString(1, orgUnitId);
                        pstmt.setInt(2, bgVersionId);
                        pstmt.addBatch();
                        if (++pos <= 50) continue;
                        pstmt.executeBatch();
                        pos = 0;
                    }
                    if (pos > 0) {
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                StringBuffer query = new StringBuffer();
                query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
                while (rst.next()) {
                    data = new bgBaseData();
                    data.setFid(rst.getString("FID"));
                    data.setState(rst.getInt("FState"));
                    data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                    if (upBgDataIds.contains(data.getFid()) || data.getAudOrgUnitId() != null && pOrgUnitIds.contains(data.getAudOrgUnitId())) continue;
                    bgBaseDatas.add(data);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            return bgBaseDatas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String queryDataToTmpTable(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, String stateFilter) throws Exception {
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            List<IDimension> bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(200) NOT NULL, FVersion INT)");
            Map<String, String> subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, bgDims);
            String field = null;
            IDimension dimension = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ?");
            if (!StringUtils.isEmpty((String)stateFilter)) {
                sql.append(" AND d.").append(stateFilter).append(" ");
            }
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            int pos = 0;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData = BizDataControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId);
                        if (!hasData) continue;
                        pstmt.setString(1, orgUnitId);
                        pstmt.setInt(2, bgVersionId);
                        pstmt.addBatch();
                        if (++pos <= 50) continue;
                        pstmt.executeBatch();
                        pos = 0;
                    }
                    if (pos > 0) {
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            }
            return queryTmpTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BgUnAuditCheckData checkData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> subOrgUnitIds, Set<String> bgDataIds, boolean isHaveSubData, boolean isHavaParentData, String orgParentAuditId) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || subOrgUnitIds == null || bgDataIds == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            bgVersionId = formInfo.getBgVersion().getVersionId();
            checkData = new BgUnAuditCheckData();
            checkData.setHaveSubData(isHaveSubData);
            checkData.setHavaParentData(isHavaParentData);
            bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, bgDims);
            field = null;
            dimension = null;
            sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ?");
            in = bgDims.size();
            for (i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            query = new StringBuffer();
            query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
            data = null;
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        block28: {
                            block27: {
                                if (checkData.isHaveSubData() && checkData.isHavaParentData() || !(hasData = BizDataControlUtils.access$600(BizDataControlUtils.this, conn, cubeName, orgUnitId))) continue;
                                pstmt.setString(1, orgUnitId);
                                pstmt.setInt(2, bgVersionId);
                                pstmt.executeUpdate();
                                try {
                                    rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
lbl54:
                                    // 2 sources

                                    while (rst.next()) {
                                        data = new bgBaseData();
                                        data.setFid(rst.getString("FID"));
                                        data.setState(rst.getInt("FState"));
                                        data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                        if (bgDataIds.contains(data.getFid())) {
                                            result = new BgUnAuditCheckResult();
                                            result.setId(formInfo.getId().toString());
                                            result.setName(formInfo.getName());
                                            result.setNumber(formInfo.getNumber());
                                            result.setCanUnAudit(false);
                                            result.setHasAdjust(true);
                                            checkData.setResult(result);
                                            var31_35 = checkData;
                                            break block27;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    break block28;
                                }
                                catch (Throwable var32_37) {
                                    SQLUtils.cleanup(rst);
                                    throw var32_37;
                                }
                            }
                            SQLUtils.cleanup((ResultSet)rst);
                            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                            return var31_35;
lbl-1000:
                            // 1 sources

                            {
                                if (data.getState() != 11 && data.getState() != 13) ** GOTO lbl-1000
                                result = new BgUnAuditCheckResult();
                                result.setId(formInfo.getId().toString());
                                result.setName(formInfo.getName());
                                result.setNumber(formInfo.getNumber());
                                result.setCanUnAudit(false);
                                result.hasUnionData = true;
                                checkData.setResult(result);
                                var31_36 = checkData;
                            }
                            SQLUtils.cleanup((ResultSet)rst);
                            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                            return var31_36;
lbl-1000:
                            // 1 sources

                            {
                                if (!checkData.isHaveSubData() && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                                    checkData.setHaveSubData(true);
                                }
                                if (!checkData.isHavaParentData() && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                                    checkData.setHavaParentData(true);
                                    if (StringUtils.isEmpty((String)orgParentAuditId)) {
                                        checkData.setOrgParentAuditId(data.getAudOrgUnitId());
                                    }
                                }
                                if (!checkData.isHavaParentData() || !checkData.isHaveSubData()) ** GOTO lbl54
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        BgDBUtils.executeUpdate((Connection)conn, (String)("truncate Table " + queryTmpTable));
                    }
                    return checkData;
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            }
        }

        private Map<String, String> getSubMemberTmpTableMap(Connection conn, TempTablePool pool, BgSchemeInfo bgScheme, List<IDimension> bgDims) throws Exception {
            HashMap<String, String> subMemberTmpTableMap = new HashMap<String, String>();
            if (conn == null || pool == null || bgScheme == null || bgDims == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            HashSet<String> dimNumber = new HashSet<String>();
            IDimension dimension = null;
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                int j;
                int jn;
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                dimNumber.clear();
                if (DimUtils.checkBaseDimension(dimension)) {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getNumber());
                    }
                } else {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getDimNumber());
                    }
                }
                if (!DimUtils.checkBaseDimension(dimension)) {
                    this.bulidCommTmpTable(conn, pool, bgScheme, subMemberTmpTableMap, dimension, dimNumber);
                    continue;
                }
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                    this.buildPeriodTmpTable(conn, pool, bgScheme, subMemberTmpTableMap, dimension, dimNumber);
                    continue;
                }
                if (!DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                this.bulidCommTmpTable(conn, pool, bgScheme, subMemberTmpTableMap, dimension, dimNumber);
            }
            return subMemberTmpTableMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bulidCommTmpTable(Connection conn, TempTablePool pool, BgSchemeInfo bgScheme, Map<String, String> subMemberTmpTableMap, IDimension dimension, Set<String> dimNumbers) throws Exception {
            if (conn == null || subMemberTmpTableMap == null || dimension == null || dimNumbers == null) {
                return;
            }
            String tmpTableName = null;
            String srcNumber = null;
            String dimNumber = null;
            ArrayList<String> sqlParam = new ArrayList<String>();
            for (String dimNum : dimNumbers) {
                if (srcNumber == null) {
                    srcNumber = DimUtils.getSrcNumber(dimNum);
                }
                sqlParam.add(DimUtils.getNumber(dimNum));
            }
            if (subMemberTmpTableMap.containsKey(dimension.getField())) {
                tmpTableName = subMemberTmpTableMap.get(dimension.getField());
                subMemberTmpTableMap.remove(dimension.getField());
                BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + tmpTableName));
            }
            tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FDimNumber NVARCHAR(84))");
            pool.createIndex(tmpTableName, "FDimNumber", false, false);
            subMemberTmpTableMap.put(dimension.getField(), tmpTableName);
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            if (!(DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()))) {
                String factName = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)bgScheme.getViewId(dimension.getNumber()));
                StringBuffer sql = new StringBuffer("select FLongNumber from " + factName + " where FNumber IN (");
                int jn = 50;
                for (int j = 1; j < jn; ++j) {
                    sql.append("?,");
                }
                sql.append("?)");
                StringBuffer query = new StringBuffer("select FLongNumber from " + factName + " where ");
                int jn2 = 50;
                for (int j = 1; j < jn2; ++j) {
                    query.append(" FLongNumber like ? OR");
                }
                query.append(" FLongNumber like ?");
                String longNumber = null;
                String[] tmpStrs = null;
                HashSet<String> sqlData = new HashSet<String>(dimNumbers);
                List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParam);
                if (!result.isEmpty()) {
                    int size = result.size();
                    int count = (size - 1) / 50 + 1;
                    int pos = 0;
                    try {
                        pstmt = conn.prepareStatement(query.toString());
                        for (int index = 0; index < count; ++index) {
                            int x = 1;
                            while (x <= 50) {
                                if (pos < size) {
                                    pstmt.setObject(x, ((Object[])result.get(pos))[0] + "!%");
                                } else {
                                    pstmt.setObject(x, BgBaseConstants.noFindStr);
                                }
                                ++x;
                                ++pos;
                            }
                            try {
                                rst = pstmt.executeQuery();
                                while (rst.next()) {
                                    longNumber = rst.getString(1);
                                    tmpStrs = longNumber.split("!");
                                    if (tmpStrs == null) continue;
                                    int jn3 = tmpStrs.length;
                                    for (int j = 0; j < jn3; ++j) {
                                        dimNumber = DimUtils.getDimNumber(srcNumber, tmpStrs[j]);
                                        sqlData.add(dimNumber);
                                    }
                                }
                                continue;
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                    }
                    finally {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                    }
                }
                if (!sqlData.isEmpty()) {
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber) values (?)"), sqlData);
                }
            } else if (!dimNumbers.isEmpty()) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber) values (?)"), dimNumbers);
            }
        }
    }

    class BizViewDataImpl
    extends AbstractBizData {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<bgBaseData> queryBaseData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> upBgDataIds) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || upBgDataIds == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
            List<String[]> relationData = BizDataControlUtils.this.getRelationUtils(rootScheme.getId().toString()).queryRelation(((IMbgViewManager)view).getRelationMaps(), (IBgDimensionManager)manager);
            if (relationData == null || relationData.isEmpty()) {
                return bgBaseDatas;
            }
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            String[] relField = relationData.get(0);
            if (relField == null || relField.length == 0) {
                return bgBaseDatas;
            }
            List<IDimension> bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            Set<String> refFields = this.getRefFields(relationData);
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            Map<String, String> subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, refFields, relationData, bgDims);
            HashMap<String, Integer> refIndexMap = new HashMap<String, Integer>();
            int jn = relField.length;
            for (int j = 0; j < jn; ++j) {
                refIndexMap.put(relField[j], j);
            }
            String field = null;
            String[] relData = null;
            ArrayList<Object> params = new ArrayList<Object>();
            IDimension dimension = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ? ");
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND e.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND c.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND s.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (refFields.contains(field)) {
                    sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + " where FParentNumber = ?)");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            bgBaseData data = null;
            PreparedStatement pstmt = null;
            IRowSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData = BizDataControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId);
                        if (!hasData) continue;
                        int pos = 0;
                        int xn = relationData.size();
                        for (int x = 1; x < xn; ++x) {
                            relData = relationData.get(x);
                            params.clear();
                            params.add(orgUnitId);
                            params.add(bgVersionId);
                            int yn = bgDims.size();
                            for (int y = 0; y < yn; ++y) {
                                dimension = bgDims.get(y);
                                field = dimension.getField();
                                if (DimensionConstants.DEF_VERSION_FIELD.equals(field) || DimensionConstants.DEF_PERIOD_FIELD.equals(field) || !refFields.contains(field)) continue;
                                params.add(relData[(Integer)refIndexMap.get(field)]);
                            }
                            int zn = params.size();
                            for (int z = 0; z < zn; ++z) {
                                pstmt.setObject(z + 1, params.get(z));
                            }
                            pstmt.addBatch();
                            if (++pos <= 50) continue;
                            pstmt.executeBatch();
                            pos = 0;
                        }
                        if (pos <= 0) continue;
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                StringBuffer query = new StringBuffer();
                query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
                while (rst.next()) {
                    data = new bgBaseData();
                    data.setFid(rst.getString("FID"));
                    data.setState(rst.getInt("FState"));
                    data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                    if (upBgDataIds.contains(data.getFid()) || data.getAudOrgUnitId() != null && pOrgUnitIds.contains(data.getAudOrgUnitId())) continue;
                    bgBaseDatas.add(data);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            return bgBaseDatas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String queryDataToTmpTable(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, String stateFilter) throws Exception {
            List<String[]> relationData = RelationUtils.getInstance(BizDataControlUtils.this.getBgSchemeHelper(rootScheme.getId().toString())).queryRelation(((IMbgViewManager)view).getRelationMaps(), (IBgDimensionManager)manager);
            if (relationData == null || relationData.isEmpty()) {
                return null;
            }
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            String[] relField = relationData.get(0);
            if (relField == null || relField.length == 0) {
                return null;
            }
            List<IDimension> bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            Set<String> refFields = this.getRefFields(relationData);
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(200) NOT NULL, FVersion INT)");
            Map<String, String> subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, refFields, relationData, bgDims);
            HashMap<String, Integer> refIndexMap = new HashMap<String, Integer>();
            int jn = relField.length;
            for (int j = 0; j < jn; ++j) {
                refIndexMap.put(relField[j], j);
            }
            String field = null;
            String[] relData = null;
            ArrayList<Object> params = new ArrayList<Object>();
            IDimension dimension = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ? ");
            if (!StringUtils.isEmpty((String)stateFilter)) {
                sql.append(" AND d.").append(stateFilter).append(" ");
            }
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND e.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND c.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND s.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (refFields.contains(field)) {
                    sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + " where FParentNumber = ?)");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData = BizDataControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId);
                        if (!hasData) continue;
                        int pos = 0;
                        int xn = relationData.size();
                        for (int x = 1; x < xn; ++x) {
                            relData = relationData.get(x);
                            params.clear();
                            params.add(orgUnitId);
                            params.add(bgVersionId);
                            int yn = bgDims.size();
                            for (int y = 0; y < yn; ++y) {
                                dimension = bgDims.get(y);
                                field = dimension.getField();
                                if (DimensionConstants.DEF_VERSION_FIELD.equals(field) || DimensionConstants.DEF_PERIOD_FIELD.equals(field) || !refFields.contains(field)) continue;
                                params.add(relData[(Integer)refIndexMap.get(field)]);
                            }
                            int zn = params.size();
                            for (int z = 0; z < zn; ++z) {
                                pstmt.setObject(z + 1, params.get(z));
                            }
                            pstmt.addBatch();
                            if (++pos <= 50) continue;
                            pstmt.executeBatch();
                            pos = 0;
                        }
                        if (pos <= 0) continue;
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            }
            return queryTmpTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BgUnAuditCheckData checkData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> subOrgUnitIds, Set<String> bgDataIds, boolean isHaveSubData, boolean isHavaParentData, String orgParentAuditId) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || subOrgUnitIds == null || bgDataIds == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            checkData = new BgUnAuditCheckData();
            checkData.setHaveSubData(isHaveSubData);
            checkData.setHavaParentData(isHavaParentData);
            bgVersionId = formInfo.getBgVersion().getVersionId();
            relationData = BizDataControlUtils.access$700(BizDataControlUtils.this, rootScheme.getId().toString()).queryRelation(((IMbgViewManager)view).getRelationMaps(), (IBgDimensionManager)manager);
            if (relationData == null || relationData.isEmpty()) {
                return checkData;
            }
            relField = relationData.get(0);
            if (relField == null || relField.length == 0) {
                return checkData;
            }
            bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            refFields = this.getRefFields(relationData);
            queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, refFields, relationData, bgDims);
            refIndexMap = new HashMap<String, Integer>();
            jn = relField.length;
            for (j = 0; j < jn; ++j) {
                refIndexMap.put(relField[j], j);
            }
            field = null;
            relData = null;
            params = new ArrayList<Object>();
            dimension = null;
            sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ?");
            in = bgDims.size();
            for (i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND e.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND c.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND s.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (refFields.contains(field)) {
                    sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + " where FParentNumber = ?)");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            query = new StringBuffer();
            query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
            data = null;
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        block38: {
                            if (checkData.isHaveSubData() && checkData.isHavaParentData() || !(hasData = BizDataControlUtils.access$600(BizDataControlUtils.this, conn, cubeName, orgUnitId))) continue;
                            pos = 0;
                            xn = relationData.size();
                            for (x = 1; x < xn; ++x) {
                                relData = relationData.get(x);
                                params.clear();
                                params.add(orgUnitId);
                                params.add(bgVersionId);
                                yn = bgDims.size();
                                for (y = 0; y < yn; ++y) {
                                    dimension = bgDims.get(y);
                                    field = dimension.getField();
                                    if (DimensionConstants.DEF_VERSION_FIELD.equals(field) || DimensionConstants.DEF_PERIOD_FIELD.equals(field) || !refFields.contains(field)) continue;
                                    params.add(relData[(Integer)refIndexMap.get(field)]);
                                }
                                zn = params.size();
                                for (z = 0; z < zn; ++z) {
                                    pstmt.setObject(z + 1, params.get(z));
                                }
                                pstmt.addBatch();
                                if (++pos <= 50) continue;
                                pstmt.executeBatch();
                                pos = 0;
                            }
                            if (pos > 0) {
                                pstmt.executeBatch();
                            }
                            try {
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
lbl111:
                                // 2 sources

                                while (rst.next()) {
                                    data = new bgBaseData();
                                    data.setFid(rst.getString("FID"));
                                    data.setState(rst.getInt("FState"));
                                    data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                    if (bgDataIds.contains(data.getFid())) {
                                        result = new BgUnAuditCheckResult();
                                        result.setId(formInfo.getId().toString());
                                        result.setName(formInfo.getName());
                                        result.setNumber(formInfo.getNumber());
                                        result.setCanUnAudit(false);
                                        result.setHasAdjust(true);
                                        checkData.setResult(result);
                                        var38_46 = checkData;
                                        break block38;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl158
                            }
                            catch (Throwable var41_50) {
                                SQLUtils.cleanup(rst);
                                throw var41_50;
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                        return var38_46;
lbl-1000:
                        // 1 sources

                        {
                            if (data.getState() != 11 && data.getState() != 13) ** GOTO lbl-1000
                            result = new BgUnAuditCheckResult();
                            result.setId(formInfo.getId().toString());
                            result.setName(formInfo.getName());
                            result.setNumber(formInfo.getNumber());
                            result.setCanUnAudit(false);
                            result.hasUnionData = true;
                            checkData.setResult(result);
                            var38_47 = checkData;
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                        return var38_47;
lbl-1000:
                        // 1 sources

                        {
                            if (!checkData.isHaveSubData() && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                                checkData.setHaveSubData(true);
                            }
                            if (!checkData.isHavaParentData() && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                                checkData.setHavaParentData(true);
                                if (StringUtils.isEmpty((String)orgParentAuditId)) {
                                    checkData.setOrgParentAuditId(data.getAudOrgUnitId());
                                }
                            }
                            if (!checkData.isHavaParentData() || !checkData.isHaveSubData()) ** GOTO lbl111
lbl158:
                            // 2 sources

                            BgDBUtils.executeUpdate((Connection)conn, (String)("truncate Table " + queryTmpTable));
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                    return checkData;
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            }
        }

        private Set<String> getRefFields(List<String[]> relationData) {
            HashSet<String> refFields = new HashSet<String>();
            if (relationData == null || relationData.isEmpty()) {
                return refFields;
            }
            String[] fields = relationData.get(0);
            int in = fields.length;
            for (int i = 0; i < in; ++i) {
                refFields.add(fields[i]);
            }
            return refFields;
        }

        private Map<String, String> getSubMemberTmpTableMap(Connection conn, TempTablePool pool, BgSchemeInfo rootScheme, Set<String> refFields, List<String[]> relationData, List<IDimension> bgDims) throws Exception {
            HashMap<String, String> subMemberTmpTableMap = new HashMap<String, String>();
            if (conn == null || pool == null || relationData == null || bgDims == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            HashSet<String> dimNumber = new HashSet<String>();
            IDimension dimension = null;
            String[] fields = relationData.get(0);
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                int j;
                int jn;
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                dimNumber.clear();
                int fieldIndex = -1;
                if (refFields.contains(dimension.getField())) {
                    int xn = fields.length;
                    for (int x = 0; x < xn; ++x) {
                        if (!dimension.getField().equals(fields[x])) continue;
                        fieldIndex = x;
                        break;
                    }
                    jn = relationData.size();
                    for (j = 1; j < jn; ++j) {
                        dimNumber.add(relationData.get(j)[fieldIndex]);
                    }
                } else if (DimUtils.checkBaseDimension(dimension)) {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getNumber());
                    }
                } else {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getDimNumber());
                    }
                }
                if (!DimUtils.checkBaseDimension(dimension)) {
                    this.bulidCommTmpTable(conn, pool, subMemberTmpTableMap, dimension, dimNumber);
                    continue;
                }
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                    this.buildPeriodTmpTable(conn, pool, rootScheme, subMemberTmpTableMap, dimension, dimNumber);
                    continue;
                }
                if (!DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                this.bulidCommTmpTable(conn, pool, subMemberTmpTableMap, dimension, dimNumber);
            }
            return subMemberTmpTableMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bulidCommTmpTable(Connection conn, TempTablePool pool, Map<String, String> subMemberTmpTableMap, IDimension dimension, Set<String> dimNumber) throws Exception {
            if (conn == null || subMemberTmpTableMap == null || dimension == null) {
                return;
            }
            String tmpTableName = null;
            ArrayList sqlParams = new ArrayList();
            ArrayList<String> sqlParam = new ArrayList<String>();
            sqlParam.addAll(dimNumber);
            if (subMemberTmpTableMap.containsKey(dimension.getField())) {
                tmpTableName = subMemberTmpTableMap.get(dimension.getField());
                subMemberTmpTableMap.remove(dimension.getField());
                BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + tmpTableName));
            }
            tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FDimNumber NVARCHAR(84), FParentNumber NVARCHAR(84))");
            pool.createIndex(tmpTableName, "FParentNumber", false, false);
            subMemberTmpTableMap.put(dimension.getField(), tmpTableName);
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            String factName = ClosureUtils.getFactTableName(dimension.getNumber());
            int re = BgDBUtils.existColumn((Connection)conn, (String)factName, (String)"FLongNumber");
            if (!(re != BgDBUtils.YES || DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()))) {
                StringBuffer sql = new StringBuffer("select FLongNumber from " + factName + " where FDimNumber IN (");
                int jn = 50;
                for (int j = 1; j < jn; ++j) {
                    sql.append("?,");
                }
                sql.append("?)");
                StringBuffer query = new StringBuffer("select FDimNumber, FLongNumber from " + factName + " where ");
                int jn2 = 50;
                for (int j = 1; j < jn2; ++j) {
                    query.append(" FLongNumber like ? OR");
                }
                query.append(" FLongNumber like ?");
                String number = null;
                String longNumber = null;
                String subNumber2 = null;
                String[] tmpStrs = null;
                HashMap sqlDataMap = new HashMap();
                Set<String> sqlData = null;
                List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParam);
                if (!result.isEmpty()) {
                    int size = result.size();
                    int count = (size - 1) / 50 + 1;
                    int pos = 0;
                    try {
                        pstmt = conn.prepareStatement(query.toString());
                        for (int index = 0; index < count; ++index) {
                            int x = 1;
                            while (x <= 50) {
                                if (pos < size) {
                                    pstmt.setObject(x, ((Object[])result.get(pos))[0] + "%");
                                } else {
                                    pstmt.setObject(x, BgBaseConstants.noFindStr);
                                }
                                ++x;
                                ++pos;
                            }
                            try {
                                rst = pstmt.executeQuery();
                                while (rst.next()) {
                                    number = rst.getString("FDimNumber");
                                    longNumber = rst.getString("FLongNumber");
                                    tmpStrs = longNumber.split("!");
                                    if (tmpStrs == null) continue;
                                    int jn3 = tmpStrs.length;
                                    for (int j = 0; j < jn3; ++j) {
                                        if (!dimNumber.contains(tmpStrs[j])) continue;
                                        if (sqlDataMap.containsKey(tmpStrs[j])) {
                                            sqlData = (Set)sqlDataMap.get(tmpStrs[j]);
                                        } else {
                                            sqlData = new HashSet();
                                            sqlDataMap.put(tmpStrs[j], sqlData);
                                        }
                                        sqlData.add(number);
                                    }
                                }
                                continue;
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                    }
                    finally {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                    }
                }
                if (!sqlDataMap.isEmpty()) {
                    Map.Entry entry2 = null;
                    for (Map.Entry entry2 : sqlDataMap.entrySet()) {
                        number = (String)entry2.getKey();
                        for (String subNumber2 : (Set)entry2.getValue()) {
                            sqlParam = new ArrayList();
                            sqlParam.add(subNumber2);
                            sqlParam.add(number);
                            sqlParams.add(sqlParam);
                        }
                    }
                    BgDBUtils.insertValue((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber, FParentNumber) values (?,?)"), sqlParams);
                }
            } else {
                for (String str : dimNumber) {
                    sqlParam = new ArrayList();
                    sqlParam.add(str);
                    sqlParam.add(str);
                    sqlParams.add(sqlParam);
                }
                BgDBUtils.insertValue((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber, FParentNumber) values (?,?)"), sqlParams);
            }
        }
    }

    class BizViewListDataImpl
    extends AbstractBizData {
        BizViewListDataImpl() {
        }

        @Override
        public List<bgBaseData> queryBaseData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> upBgDataIds) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || upBgDataIds == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            BgSchemeDimensionHelper schemeHelper = BizDataControlUtils.this.getBgSchemeHelper(rootScheme.getId().toString());
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
            MbgViewListControlUtils viewListUtils = new MbgViewListControlUtils(BizDataControlUtils.this.ctx, conn, formInfo.getOrgUnit().getId().toString(), schemeHelper, pool, (MbgViewListDimensionManager)manager, formInfo.getBgVersion().getNumber());
            Map<String, String> subMemberTmpTableMap = viewListUtils.getSubMemberTmpTableMap();
            String querySql = viewListUtils.getQuerySql(subMemberTmpTableMap, cubeName);
            bgBaseData data = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(querySql);
                List paramList = MbgSqlHelper.getBatchParams(null, (Object[])orgUnitIds.toArray(), (int)50);
                for (int i = 0; i < paramList.size(); ++i) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        data = new bgBaseData();
                        data.setFid(rst.getString("FID"));
                        data.setState(rst.getInt("FState"));
                        data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                        if (upBgDataIds.contains(data.getFid()) || data.getAudOrgUnitId() != null && pOrgUnitIds.contains(data.getAudOrgUnitId())) continue;
                        bgBaseDatas.add(data);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            }
            return bgBaseDatas;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BgUnAuditCheckData checkData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> subOrgUnitIds, Set<String> bgDataIds, boolean isHaveSubData, boolean isHavaParentData, String orgParentAuditId) throws Exception {
            block14: {
                block13: {
                    if (conn == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (pool == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (view == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (manager == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (formInfo == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (rootScheme == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (orgUnitIds == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (pOrgUnitIds == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (subOrgUnitIds == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (bgDataIds == null) {
                        throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    }
                    schemeHelper = BizDataControlUtils.access$400(BizDataControlUtils.this, rootScheme.getId().toString());
                    bgVersionId = formInfo.getBgVersion().getVersionId();
                    checkData = new BgUnAuditCheckData();
                    checkData.setHaveSubData(isHaveSubData);
                    checkData.setHavaParentData(isHavaParentData);
                    viewListUtils = new MbgViewListControlUtils(BizDataControlUtils.access$500(BizDataControlUtils.this), conn, formInfo.getOrgUnit().getId().toString(), schemeHelper, pool, (MbgViewListDimensionManager)manager, formInfo.getBgVersion().getNumber());
                    subMemberTmpTableMap = viewListUtils.getSubMemberTmpTableMap();
                    querySql = viewListUtils.getQuerySql(subMemberTmpTableMap, cubeName);
                    data = null;
                    pstmt = null;
                    rst = null;
                    try {
                        pstmt = conn.prepareStatement(querySql);
                        paramList = MbgSqlHelper.getBatchParams(null, (Object[])orgUnitIds.toArray(), (int)50);
                        i = 0;
lbl27:
                        // 2 sources

                        while (i < paramList.size()) {
                            MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                            rst = pstmt.executeQuery();
lbl30:
                            // 2 sources

                            while (rst.next()) {
                                data = new bgBaseData();
                                data.setFid(rst.getString("FID"));
                                data.setState(rst.getInt("FState"));
                                data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                if (bgDataIds.contains(data.getFid())) {
                                    result = new BgUnAuditCheckResult();
                                    result.setId(formInfo.getId().toString());
                                    result.setName(formInfo.getName());
                                    result.setNumber(formInfo.getNumber());
                                    result.setCanUnAudit(false);
                                    result.setHasAdjust(true);
                                    checkData.setResult(result);
                                    var27_29 = checkData;
                                    break block13;
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl78
                        }
                        break block14;
                    }
                    catch (SQLException ex) {
                        try {
                            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        }
                        catch (Throwable var28_31) {
                            SQLUtils.cleanup(rst, (Statement)pstmt);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                            throw var28_31;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                return var27_29;
lbl-1000:
                // 1 sources

                {
                    if (data.getState() != 11 && data.getState() != 13) ** GOTO lbl-1000
                    result = new BgUnAuditCheckResult();
                    result.setId(formInfo.getId().toString());
                    result.setName(formInfo.getName());
                    result.setNumber(formInfo.getNumber());
                    result.setCanUnAudit(false);
                    result.hasUnionData = true;
                    checkData.setResult(result);
                    var27_30 = checkData;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                return var27_30;
lbl-1000:
                // 1 sources

                {
                    if (!checkData.isHaveSubData() && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                        checkData.setHaveSubData(true);
                    }
                    if (!checkData.isHavaParentData() && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                        checkData.setHavaParentData(true);
                        if (StringUtils.isEmpty((String)orgParentAuditId)) {
                            checkData.setOrgParentAuditId(data.getAudOrgUnitId());
                        }
                    }
                    if (!checkData.isHavaParentData() || !checkData.isHaveSubData()) ** GOTO lbl30
lbl78:
                    // 2 sources

                    SQLUtils.cleanup((ResultSet)rst);
                    ++i;
                    ** GOTO lbl27
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            return checkData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String queryDataToTmpTable(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, String stateFilter) throws Exception {
            BgSchemeDimensionHelper schemeHelper = BizDataControlUtils.this.getBgSchemeHelper(rootScheme.getId().toString());
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            MbgViewListControlUtils viewListUtils = new MbgViewListControlUtils(BizDataControlUtils.this.ctx, conn, formInfo.getOrgUnit().getId().toString(), schemeHelper, pool, (MbgViewListDimensionManager)manager, formInfo.getBgVersion().getNumber());
            Map<String, String> subMemberTmpTableMap = viewListUtils.getSubMemberTmpTableMap();
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            String sql = viewListUtils.getQueryTmpSql(queryTmpTable, subMemberTmpTableMap, cubeName);
            int pos = 0;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData = BizDataControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId);
                        if (!hasData) continue;
                        pstmt.setString(1, orgUnitId);
                        pstmt.setInt(2, bgVersionId);
                        pstmt.addBatch();
                        if (++pos <= 50) continue;
                        pstmt.executeBatch();
                        pos = 0;
                    }
                    if (pos > 0) {
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            }
            return queryTmpTable;
        }
    }

    abstract class AbstractBizData
    implements IBizData {
        AbstractBizData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void buildPeriodTmpTable(Connection conn, TempTablePool pool, BgSchemeInfo rootScheme, Map<String, String> subMemberTmpTableMap, IDimension dimension, Set<String> dimNumber) throws Exception {
            if (conn == null || pool == null || rootScheme == null || subMemberTmpTableMap == null || dimension == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            String tmpTableName = null;
            IRowSet rst = null;
            HashSet<String> periodIds = new HashSet<String>();
            ArrayList<String> tmpNumber = new ArrayList<String>();
            tmpNumber.addAll(dimNumber);
            Map<String, BgPeriodDispInfo> periodMap = BizDataControlUtils.this.getBgPeriodMap(conn, tmpNumber, rootScheme);
            BgPeriodDispInfo bgPeriodInfo2 = null;
            for (BgPeriodDispInfo bgPeriodInfo2 : periodMap.values()) {
                try {
                    if (bgPeriodInfo2.getBeginDate() != null) {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FBgPeriodID from T_MBG_BgPeriodDisp where FBeginDate >= ? and FEndDate <= ? and FTypeID = ?", (Object[])new Object[]{new Timestamp(BgNPeriodHelper.getDayBegin((Date)bgPeriodInfo2.getBeginDate()).getTime()), new Timestamp(BgNPeriodHelper.getDayEnd((Date)bgPeriodInfo2.getEndDate()).getTime()), bgPeriodInfo2.getType().getId().toString()});
                        while (rst.next()) {
                            periodIds.add(rst.getString("FBgPeriodID"));
                        }
                        continue;
                    }
                    periodIds.add(bgPeriodInfo2.getBgPeriod().getId().toString());
                }
                finally {
                    SQLUtils.cleanup(rst);
                }
            }
            if (subMemberTmpTableMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                tmpTableName = subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD);
                BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + tmpTableName));
            } else {
                tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                subMemberTmpTableMap.put(DimensionConstants.DEF_PERIOD_FIELD, tmpTableName);
            }
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FID) values (?)"), periodIds);
        }

        protected abstract String queryDataToTmpTable(Connection var1, TempTablePool var2, String var3, IMbgViewBase var4, IBgDimensionManagerBase var5, BgFormInfo var6, BgSchemeInfo var7, List<String> var8, String var9) throws Exception;

        @Override
        public void synDataState(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, String audUserId) throws Exception {
            ResultSet rst;
            Statement pstmt;
            String queryTmpTable;
            block9: {
                if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null) {
                    throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                }
                queryTmpTable = null;
                pstmt = null;
                rst = null;
                queryTmpTable = this.queryDataToTmpTable(conn, pool, cubeName, view, manager, formInfo, rootScheme, orgUnitIds, BizDataControlUtils.this.getSynStateFilter());
                if (queryTmpTable != null) break block9;
                SQLUtils.cleanup(rst, pstmt);
                if (queryTmpTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                }
                return;
            }
            try {
                StringBuffer sql = new StringBuffer();
                sql.append(BizDataControlUtils.this.getSynUpdateSql(cubeName)).append(" where exists (Select FOrgUnitId, FFormula, FVersion from ").append(queryTmpTable).append(" where t0.FOrgUnitId = FOrgUnitId and t0.FFormula = FFormula and t0.FVersion = FVersion)");
                List params = BizDataControlUtils.this.getSynUpdateBaseParams(audUserId);
                MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), (Object)params.toArray());
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    if (queryTmpTable != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, queryTmpTable);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup(rst, pstmt);
            if (queryTmpTable != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            }
        }
    }

    class BgUnAuditCheckData {
        private BgUnAuditCheckResult result = null;
        private boolean isHaveSubData = false;
        private boolean isHavaParentData = false;
        private String orgParentAuditId = null;

        BgUnAuditCheckData() {
        }

        public void setResult(BgUnAuditCheckResult result) {
            this.result = result;
        }

        public BgUnAuditCheckResult getResult() {
            return this.result;
        }

        public boolean isHaveSubData() {
            return this.isHaveSubData;
        }

        public void setHaveSubData(boolean isHaveSubData) {
            this.isHaveSubData = isHaveSubData;
        }

        public boolean isHavaParentData() {
            return this.isHavaParentData;
        }

        public void setHavaParentData(boolean isHavaParentData) {
            this.isHavaParentData = isHavaParentData;
        }

        public String getOrgParentAuditId() {
            return this.orgParentAuditId;
        }

        public void setOrgParentAuditId(String orgParentAuditId) {
            this.orgParentAuditId = orgParentAuditId;
        }
    }

    static interface IBizData {
        public List<bgBaseData> queryBaseData(Connection var1, TempTablePool var2, String var3, IMbgViewBase var4, IBgDimensionManagerBase var5, BgFormInfo var6, BgSchemeInfo var7, List<String> var8, Set<String> var9, Set<String> var10) throws Exception;

        public void synDataState(Connection var1, TempTablePool var2, String var3, IMbgViewBase var4, IBgDimensionManagerBase var5, BgFormInfo var6, BgSchemeInfo var7, List<String> var8, String var9) throws Exception;

        public BgUnAuditCheckData checkData(Connection var1, TempTablePool var2, String var3, IMbgViewBase var4, IBgDimensionManagerBase var5, BgFormInfo var6, BgSchemeInfo var7, List<String> var8, Set<String> var9, Set<String> var10, Set<String> var11, boolean var12, boolean var13, String var14) throws Exception;
    }

    public class bgBaseData
    implements Serializable {
        private static final long serialVersionUID = 1722814966647918183L;
        private String fid = null;
        private int state = 1;
        private String audOrgUnitId = null;

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getFid() {
            return this.fid;
        }

        public void setState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public void setAudOrgUnitId(String audOrgUnitId) {
            this.audOrgUnitId = audOrgUnitId;
        }

        public String getAudOrgUnitId() {
            return this.audOrgUnitId;
        }
    }
}

