/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgCourseCommentFactory;
import com.kingdee.eas.ma.mbg.BgCourseCommentInfo;
import com.kingdee.eas.ma.mbg.BgCourseOperateEnum;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgExamineFacade;
import com.kingdee.eas.ma.mbg.MbgAuditException;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.BgTemplateSequenceSetHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MBgExamineUtils;
import com.kingdee.eas.ma.mbg.utils.data.AuditBiz;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BackBiz;
import com.kingdee.eas.ma.mbg.utils.data.BizDataControlUtils;
import com.kingdee.eas.ma.mbg.utils.data.BizDataOtherCheckUtils;
import com.kingdee.eas.ma.mbg.utils.data.DimBackBiz;
import com.kingdee.eas.ma.mbg.utils.data.DimCertificateBiz;
import com.kingdee.eas.ma.mbg.utils.data.DimCourseBiz;
import com.kingdee.eas.ma.mbg.utils.data.DimUnAuditBiz;
import com.kingdee.eas.ma.mbg.utils.data.DimUnCertificateBiz;
import com.kingdee.eas.ma.mbg.utils.data.ReceiveBiz;
import com.kingdee.eas.ma.mbg.utils.data.ReportBiz;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizMbgDataControlUtils {
    private static final Logger logger = Logger.getLogger(BizDataControlUtils.class);
    public static final String AUDIT_PARAM = "AUDIT_PARAM";
    public static final String AUDIT_COURSE_COMMENT_STATE = "AUDIT_COURSE_COMMENT_STATE";
    public static final String FILTER_BATCH_ANTIAUDIT_SUBMITIDEA = "FILTER_BATCH_ANTIAUDIT_SUBMITIDEA";
    public static final String AUDIT_SCHEME_ID = "AUDIT_SCHEME_ID";
    public static final String AUDIT_ORGUNIT_ID = "AUDIT_ORGUNIT_ID";
    public static final String AUDIT_USER_ID = "AUDIT_USER_ID";
    public static final String AUDIT_DATA_STATE = "AUDIT_DATA_STATE";
    public static final String AUDIT_BILL_STATE = "AUDIT_BILL_STATE";
    public static final String AUDIT_SYN_CHILD = "AUDIT_SYN_CHILD";
    public static final String AUDIT_MESSAGE = "AUDIT_MESSAGE";
    public static final String CHECK_MUTEX = "CHECK_MUTEX";
    public static final String CHECK_WORKFLOW = "CHECK_WORKFLOW";
    public static final String CHECK_REPORT = "CHECK_REPORT";
    public static final String CHECK_EXAMINE = "CHECK_EXAMINE";
    public static final String CHECK_RESULT_SUCCEED = "CHECK_RESULT_SUCCEED";
    public static final String CHECK_RESULT_REPORT = "CHECK_RESULT_REPORT";
    public static final String CHECK_RESULT_EXAMINE = "CHECK_RESULT_EXAMINE";
    public static final String CHECK_RESULT_STATE = "CHECK_RESULT_STATE";
    public static final String CHECK_RESULT_WORKFLOW = "CHECK_RESULT_WORKFLOW";
    public static final String CHECK_RESULT_DATASTATE = "CHECK_RESULT_DATASTATE";
    public static final String CHECK_RESULT_ADJUST = "CHECK_RESULT_ADJUST";
    public static final String CHECK_RESULT_DAILY = "CHECK_RESULT_DAILY";
    public static final String CHECK_RESULT_PASTDATA = "CHECK_RESULT_PASTDATA";
    public static final String CHECK_RESULT_UNION = "CHECK_RESULT_UNION";
    public static final String CHECK_RESULT_MUTEX = "CHECK_RESULT_MUTEX";
    public static final String CHECK_RESULT_AUDORG = "CHECK_RESULT_AUDORG";
    public static final String CHECK_RESULT_COURSE = "CHECK_RESULT_COURSE";
    public static final String CHECK_RESULT_COURSE_FORMTYPE = "CHECK_RESULT_COURSE_FORMTYPE";
    public static final String CHECK_RESULT_PROCESSTYPE = "CHECK_RESULT_PROCESSTYPE";
    public static final String CHECK_RESULT_PARENT_NOEDIT = "CHECK_RESULT_PARENT_NOEDIT";
    public static final String CHECK_RESULT_AUDIT_ORGUNIT = "CHECK_RESULT_AUDIT_ORGUNIT";
    public static final String CHECK_RESULT_CARTIFICATE_ORGUNIT = "CHECK_RESULT_CARTIFICATE_ORGUNIT";
    public static final String CHECK_RESULT_COURSE_READONLY = "CHECK_RESULT_COURSE_READONLY";
    public static final String CHECK_RESULT_BACK_STATE = "CHECK_RESULT_BACK_STATE";
    public static final String CHECK_RESULT_UNCARTIFICATE_STATE = "CHECK_RESULT_UNCARTIFICATE_STATE";
    public static final String CHECK_RESULT_PERMISSION = "CHECK_RESULT_PERMISSION";
    public static final String OBJECT_BILL = "OBJECT_BILL";
    public static final String CHECK_RESULT_ISROLLED = "CHECK_RESULT_ISROLLED";
    public static final String CHECK_RESULT_BGTEMPLATE_SEQUENCESET = "CHECK_RESULT_BGTEMPLATE_SEQUENCESET";
    public static final String CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX = "CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX";
    public static final String CHECK_RESULT_ROLLVERSION = "CHECK_RESULT_ROLLVERSION";
    private AuditBiz audit = null;
    private ReportBiz report = null;
    private ReceiveBiz receive = null;
    private BackBiz back = null;
    private DimCourseBiz course = null;
    private DimBackBiz dimBack = null;
    private DimCertificateBiz certificate = null;
    private DimUnCertificateBiz unCertificate = null;
    private List<String> mutexSucceed = new ArrayList<String>();

    protected AuditBiz getAudit() {
        if (this.audit == null) {
            this.audit = new AuditBiz(this);
        }
        return this.audit;
    }

    public void setAudit(AuditBiz audit) {
        this.audit = audit;
    }

    protected ReportBiz getReport() {
        if (this.report == null) {
            this.report = new ReportBiz(this);
        }
        return this.report;
    }

    public void setReport(ReportBiz report) {
        this.report = report;
    }

    protected ReceiveBiz getReceive() {
        if (this.receive == null) {
            this.receive = new ReceiveBiz(this);
        }
        return this.receive;
    }

    public void setReceive(ReceiveBiz receive) {
        this.receive = receive;
    }

    protected BackBiz getBack() {
        if (this.back == null) {
            this.back = new BackBiz(this);
        }
        return this.back;
    }

    public void setBack(BackBiz back) {
        this.back = back;
    }

    public DimCourseBiz getCourse() {
        return this.course;
    }

    public void setCourse(DimCourseBiz course) {
        this.course = course;
    }

    public DimBackBiz getDimBack() {
        return this.dimBack;
    }

    public void setDimBack(DimBackBiz dimBack) {
        this.dimBack = dimBack;
    }

    public DimCertificateBiz getCertificate() {
        return this.certificate;
    }

    public void setCertificate(DimCertificateBiz certificate) {
        this.certificate = certificate;
    }

    public DimUnCertificateBiz getUnCertificate() {
        return this.unCertificate;
    }

    public void setUnCertificate(DimUnCertificateBiz unCertificate) {
        this.unCertificate = unCertificate;
    }

    public IDimDataQuery queryData(Context ctx, Connection conn, String billId) throws Exception {
        if (ctx == null || conn == null || billId == null) {
            return null;
        }
        return MbgDataHelper.getBgFormInfo(conn, ctx.getLocale(), BOSUuid.read((String)billId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> audit(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin BatchAudit BgForm !");
        AuditParam param = new AuditParam(ctx);
        param.auditType = 0;
        param.convertParams(auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getAudit().audit(ctx, billIds, auditParams, param, result);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            this.recordCourseComment(ctx, result, auditParams);
        }
        logger.debug((Object)("end BatchAudit BgForm ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unAudit(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin BatchAntiAudit BgForm ! ");
        AuditParam param = new AuditParam(ctx);
        param.auditType = 1;
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getAudit().audit(ctx, billIds, auditParams, param, result);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            this.recordCourseComment(ctx, result, auditParams);
        }
        logger.debug((Object)("end BatchAntiAudit BgForm ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> auditCancelForm(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin BatchAntiAudit BgForm ! ");
        AuditParam param = new AuditParam(ctx);
        param.auditType = 11;
        param.convertParams(auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getAudit().audit(ctx, billIds, auditParams, param, result);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            this.recordCourseComment(ctx, result, auditParams);
        }
        logger.debug((Object)("end BatchAntiAudit BgForm ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unionReport(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin batchUnionReport BgForm ! ");
        AuditParam param = this.transReportParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getReport().report(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        logger.debug((Object)("end batchUnionReport BgForm ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transReportParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 2;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unionUnReport(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin batchUnUnionReport BgForm ! ");
        AuditParam param = this.transUnReportParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getReport().report(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        logger.debug((Object)("end batchUnUnionReport BgForm ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transUnReportParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 3;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> receive(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin receive Form ! ");
        AuditParam param = this.transReceiveParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getReceive().receive(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        logger.debug((Object)("end receive Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transReceiveParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 4;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unReceive(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin unReceive Form ! ");
        AuditParam param = this.transUnReceiveParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getReceive().receive(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        logger.debug((Object)("end unReceive Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transUnReceiveParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 5;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unionBack(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin unionBack Form ! ");
        AuditParam param = this.transUnionBackParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getBack().back(ctx, billIds, auditParams, result, param);
        }
        catch (Exception e) {
            logger.error((Object)"unionBack error", (Throwable)e);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        logger.debug((Object)("end unionBack Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transUnionBackParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 6;
        return param;
    }

    public Map<String, Object> refer(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin refer Form ! ");
        logger.debug((Object)("end refer Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> course(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin course Form ! ");
        AuditParam param = this.transCourseParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getCourse().course(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            this.recordCourseComment(ctx, result, auditParams);
        }
        logger.debug((Object)("end course Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transCourseParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 7;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> dimBack(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin dimBack Form ! ");
        AuditParam param = this.transDimBackParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getDimBack().back(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            this.recordCourseComment(ctx, result, auditParams);
        }
        logger.debug((Object)("end dimBack Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transDimBackParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 8;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> certificate(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin certificate Form ! ");
        AuditParam param = this.transCertificateParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getCertificate().certificate(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            this.recordCourseComment(ctx, result, auditParams);
        }
        logger.debug((Object)("end certificate Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transCertificateParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 9;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unCertificate(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin certificate Form ! ");
        AuditParam param = this.transUnCertificateParams(ctx, auditParams);
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.getUnCertificate().unCertificate(ctx, billIds, auditParams, result, param);
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            this.recordCourseComment(ctx, result, auditParams);
        }
        logger.debug((Object)("end certificate Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    protected AuditParam transUnCertificateParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = new AuditParam(ctx);
        param.auditType = 10;
        return param;
    }

    public void recordCourseComment(Context ctx, Map<String, Object> result, Map<String, String> auditParams) throws EASBizException, BOSException {
        if (ctx == null || result == null || !result.containsKey(CHECK_RESULT_SUCCEED) || auditParams == null || !auditParams.containsKey(AUDIT_COURSE_COMMENT_STATE)) {
            return;
        }
        BgCourseOperateEnum operate = BgCourseOperateEnum.getEnum(auditParams.get(AUDIT_COURSE_COMMENT_STATE));
        Map formMap = (Map)result.get(CHECK_RESULT_SUCCEED);
        if (formMap == null || formMap.isEmpty()) {
            return;
        }
        this.recordOperation(ctx, formMap.keySet(), operate, auditParams.get(AUDIT_MESSAGE));
    }

    protected void recordOperation(Context ctx, Collection<String> _bgFormIds, BgCourseOperateEnum status, String idea) throws EASBizException, BOSException {
        if (_bgFormIds == null || _bgFormIds.isEmpty()) {
            return;
        }
        BgCourseCommentInfo info = null;
        ArrayList<BgCourseCommentInfo> tmpList = new ArrayList<BgCourseCommentInfo>();
        for (String _bgFormId : _bgFormIds) {
            info = new BgCourseCommentInfo();
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setBgFormId(_bgFormId);
            info.setState(status);
            info.setComment(idea);
            tmpList.add(info);
        }
        BgCourseCommentFactory.getLocalInstance(ctx).batchAddnew(tmpList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> auditCheck(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin auditCheck Form ! ");
        AuditParam param = new AuditParam(ctx);
        param.auditType = 0;
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        logger.debug((Object)("end auditCheck Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unAuditCheck(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx == null) {
            return result;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin unAuditCheck Form ! ");
        AuditParam param = new AuditParam(ctx);
        param.auditType = 1;
        if (this.checkParams(billIds, auditParams)) {
            return result;
        }
        try {
            billIds = this.filterBillIds(billIds);
            if (this.beforeCheck(ctx, billIds, auditParams, result, param)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        logger.debug((Object)("end unAuditCheck Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return result;
    }

    public Set<String> checkBizPastData(Context ctx, List<String> billIds, Map<String, String> auditParams) throws EASBizException, BOSException {
        if (ctx == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin checkBizPastData Form ! ");
        AuditParam param = new AuditParam(ctx);
        param.auditType = 1;
        param.audSchemeId = auditParams.get(AUDIT_SCHEME_ID);
        billIds = this.filterBillIds(billIds);
        logger.debug((Object)("end checkBizPastData Form ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return new DimUnAuditBiz(this).checkBizPastData(ctx, billIds, auditParams, param);
    }

    protected boolean checkParams(List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        if (billIds == null || billIds.isEmpty()) {
            throw new MbgAuditException(MbgAuditException.BILLIDISNULL);
        }
        if (auditParams == null || auditParams.isEmpty()) {
            throw new MbgAuditException(MbgAuditException.AUDITPARAMSISNULL);
        }
        if (!auditParams.containsKey(AUDIT_SCHEME_ID)) {
            throw new MbgAuditException(MbgAuditException.AUDITBGSCHEMEIDISNULL);
        }
        if (!(auditParams.containsKey(AUDIT_BILL_STATE) && String.valueOf(25).equals(auditParams.get(AUDIT_BILL_STATE)) || auditParams.containsKey(AUDIT_ORGUNIT_ID))) {
            throw new MbgAuditException(MbgAuditException.AUDITORGUNITIDISNULL);
        }
        if (!auditParams.containsKey(AUDIT_USER_ID)) {
            throw new MbgAuditException(MbgAuditException.AUDITUSERIDISNULL);
        }
        if (!auditParams.containsKey(AUDIT_DATA_STATE)) {
            throw new MbgAuditException(MbgAuditException.AUDITSTATEISNULL);
        }
        if (!auditParams.containsKey(AUDIT_BILL_STATE)) {
            throw new MbgAuditException(MbgAuditException.AUDITBILLSTATEISNULL);
        }
        return false;
    }

    protected IDimDataQuery queryData(AuditParam auditParam, Connection conn, String billId) throws Exception {
        if (conn == null || auditParam == null || billId == null) {
            return null;
        }
        return auditParam.getCacheValue(conn, billId, this);
    }

    protected List<String> filterBillIds(List<String> billIds) {
        ArrayList<String> _billIds = new ArrayList<String>();
        if (billIds == null) {
            return _billIds;
        }
        for (String billId : billIds) {
            if (!"3BA5F027".equals(BOSUuid.read((String)billId).getType().toString())) continue;
            _billIds.add(billId);
        }
        return _billIds;
    }

    protected boolean beforeCheck(Context ctx, List<String> billIds, Map<String, String> auditParams, Map<String, Object> result, AuditParam param) throws BOSException, EASBizException {
        if (ctx == null || billIds == null || auditParams == null || result == null || param == null) {
            return false;
        }
        new BizDataOtherCheckUtils().beforeCheck(ctx, billIds, param.auditType);
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin Batch Check ! ");
        boolean check = false;
        param.audSchemeId = auditParams.get(AUDIT_SCHEME_ID);
        param.audOrgUnitId = auditParams.get(AUDIT_ORGUNIT_ID);
        param.audUserId = auditParams.get(AUDIT_USER_ID);
        param.audState = Integer.valueOf(auditParams.get(AUDIT_DATA_STATE));
        param.audFormState = Integer.valueOf(auditParams.get(AUDIT_BILL_STATE));
        boolean _checkWorkFlow = false;
        boolean _checkReport = false;
        boolean _checkExamine = false;
        boolean _checkMutext = false;
        if (param.auditType == 0 || param.auditType == 7 || param.auditType == 9 || param.auditType == 10 || param.auditType == 8) {
            _checkMutext = Boolean.valueOf(auditParams.get(CHECK_MUTEX));
            _checkWorkFlow = Boolean.valueOf(auditParams.get(CHECK_WORKFLOW));
            _checkReport = Boolean.valueOf(auditParams.get(CHECK_REPORT));
            _checkExamine = Boolean.valueOf(auditParams.get(CHECK_EXAMINE));
        }
        String billId = null;
        IDimDataQuery model = null;
        BgOrgUnitInfo bgOrgUnit = null;
        BgProcessEnum processType = null;
        ArrayList<String> checks = new ArrayList<String>();
        checks.addAll(billIds);
        ArrayList<String> detailChecks = new ArrayList<String>();
        IEnactmentService iEnactmentService = null;
        Connection conn = null;
        try {
            MbgDimCollection colls;
            conn = BgDBUtils.getConnection((Context)ctx);
            param.bgScheme = MbgDataHelper.getBgSchemeInfo(conn, ctx.getLocale(), BOSUuid.read((String)param.audSchemeId));
            if (_checkMutext) {
                this.mutexSucceed.addAll(billIds);
                Set<String> mutexErrs = null;
                if (BgParamUtils.checkFinalized(ctx) && param.auditType == 7) {
                    BgCalculateSchemeInfo calcScheme = BgFinalizedFacadeFactory.getLocalInstance(ctx).getCalcSchemeByBgScheme(param.audSchemeId);
                    if (calcScheme == null) {
                        mutexErrs = MBgCheckHelper.requestMutex(ctx, billIds, true);
                    }
                } else {
                    mutexErrs = MBgCheckHelper.requestMutex(ctx, billIds, true);
                }
                if (mutexErrs != null && !mutexErrs.isEmpty()) {
                    this.mutexSucceed.removeAll(mutexErrs);
                    check = true;
                    List<BgFormInfo> bgForms = MbgDataHelper.getBgFormInfo(ctx, conn, mutexErrs);
                    if (bgForms != null) {
                        for (BgFormInfo bgForm : bgForms) {
                            BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_MUTEX, bgForm);
                        }
                    }
                }
            }
            int in = billIds.size();
            for (int i = 0; i < in; ++i) {
                billId = billIds.get(i);
                model = param.getCacheValue(conn, billId, this);
                processType = model.getProcessType();
                bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgScheme.getEditOrgViewId(), model.getBizOrgUnit().getId());
                if (bgOrgUnit != null && (bgOrgUnit.isIsLeaf() && !DimensionCommonHelper.isDecompose(processType) || !bgOrgUnit.isIsLeaf() && DimensionCommonHelper.isDecompose(processType))) {
                    detailChecks.add(billId);
                }
                this.checkBillState(model, param, result);
                this.checkCanCourse(model, bgOrgUnit, param, result);
                if (_checkWorkFlow) {
                    if (iEnactmentService == null) {
                        iEnactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
                    }
                    BizMbgDataControlUtils.checkWorkFlow(iEnactmentService, model, result);
                }
                if (model == null || !(model instanceof BgFormInfo)) continue;
                this.checkunAuditOrgUnit(ctx, conn, model, param, result);
                this.checkIsRollVersion(ctx, model, result);
                if (param.auditType != 1) continue;
                BizMbgDataControlUtils.checkIsRolledForm(model, result);
            }
            if (result.containsKey(CHECK_RESULT_STATE)) {
                Map stateMap = (Map)result.get(CHECK_RESULT_STATE);
                checks.removeAll(stateMap.keySet());
                billIds.removeAll(stateMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_COURSE)) {
                Map courseMap = (Map)result.get(CHECK_RESULT_COURSE);
                checks.removeAll(courseMap.keySet());
                billIds.removeAll(courseMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_PROCESSTYPE)) {
                Map courseMap = (Map)result.get(CHECK_RESULT_PROCESSTYPE);
                checks.removeAll(courseMap.keySet());
                billIds.removeAll(courseMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_COURSE_FORMTYPE)) {
                Map courseMap = (Map)result.get(CHECK_RESULT_COURSE_FORMTYPE);
                checks.removeAll(courseMap.keySet());
                billIds.removeAll(courseMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_COURSE_READONLY)) {
                Map courseMap = (Map)result.get(CHECK_RESULT_COURSE_READONLY);
                checks.removeAll(courseMap.keySet());
                billIds.removeAll(courseMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_WORKFLOW)) {
                Map workFlowMap = (Map)result.get(CHECK_RESULT_WORKFLOW);
                checks.removeAll(workFlowMap.keySet());
                billIds.removeAll(workFlowMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_MUTEX)) {
                Map mutexMap = (Map)result.get(CHECK_RESULT_MUTEX);
                checks.removeAll(mutexMap.keySet());
                billIds.removeAll(mutexMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_AUDIT_ORGUNIT)) {
                Map auditMap = (Map)result.get(CHECK_RESULT_AUDIT_ORGUNIT);
                checks.removeAll(auditMap.keySet());
                billIds.removeAll(auditMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_CARTIFICATE_ORGUNIT)) {
                Map cartificateMap = (Map)result.get(CHECK_RESULT_CARTIFICATE_ORGUNIT);
                checks.removeAll(cartificateMap.keySet());
                billIds.removeAll(cartificateMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_ROLLVERSION)) {
                Map rollMap = (Map)result.get(CHECK_RESULT_ROLLVERSION);
                checks.removeAll(rollMap.keySet());
                billIds.removeAll(rollMap.keySet());
            }
            if (result.containsKey(CHECK_RESULT_ISROLLED)) {
                Map rollMap = (Map)result.get(CHECK_RESULT_ISROLLED);
                checks.removeAll(rollMap.keySet());
                billIds.removeAll(rollMap.keySet());
            }
            if (checks.isEmpty()) {
                check = true;
            }
            if (_checkReport) {
                if (result.containsKey(CHECK_RESULT_STATE)) {
                    Map stateMap = (Map)result.get(CHECK_RESULT_STATE);
                    checks.removeAll(stateMap.keySet());
                    billIds.removeAll(stateMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_COURSE)) {
                    Map courseMap = (Map)result.get(CHECK_RESULT_COURSE);
                    checks.removeAll(courseMap.keySet());
                    billIds.removeAll(courseMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_COURSE_FORMTYPE)) {
                    Map courseMap = (Map)result.get(CHECK_RESULT_COURSE_FORMTYPE);
                    checks.removeAll(courseMap.keySet());
                    billIds.removeAll(courseMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_WORKFLOW)) {
                    Map workFlowMap = (Map)result.get(CHECK_RESULT_WORKFLOW);
                    checks.removeAll(workFlowMap.keySet());
                    billIds.removeAll(workFlowMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_MUTEX)) {
                    Map mutexMap = (Map)result.get(CHECK_RESULT_MUTEX);
                    checks.removeAll(mutexMap.keySet());
                    billIds.removeAll(mutexMap.keySet());
                }
                BOSUuid[] uuids = new BOSUuid[checks.size()];
                int in2 = checks.size();
                for (int i = 0; i < in2; ++i) {
                    uuids[i] = BOSUuid.read((String)((String)checks.get(i)));
                }
                List _result = BgFormFactory.getLocalInstance(ctx).reportCheck(uuids);
                if (_result.size() >= 3 && _result.get(3) != null) {
                    result.put(CHECK_RESULT_REPORT, _result);
                    check = true;
                }
            }
            if (_checkExamine) {
                List results;
                Object obj;
                IBgExamineFacade examFacade;
                if (result.containsKey(CHECK_RESULT_STATE)) {
                    Map stateMap = (Map)result.get(CHECK_RESULT_STATE);
                    checks.removeAll(stateMap.keySet());
                    billIds.removeAll(stateMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_COURSE)) {
                    Map courseMap = (Map)result.get(CHECK_RESULT_COURSE);
                    checks.removeAll(courseMap.keySet());
                    billIds.removeAll(courseMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_COURSE_FORMTYPE)) {
                    Map courseMap = (Map)result.get(CHECK_RESULT_COURSE_FORMTYPE);
                    checks.removeAll(courseMap.keySet());
                    billIds.removeAll(courseMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_WORKFLOW)) {
                    Map workFlowMap = (Map)result.get(CHECK_RESULT_WORKFLOW);
                    checks.removeAll(workFlowMap.keySet());
                    billIds.removeAll(workFlowMap.keySet());
                }
                if (result.containsKey(CHECK_RESULT_MUTEX)) {
                    Map mutexMap = (Map)result.get(CHECK_RESULT_MUTEX);
                    checks.removeAll(mutexMap.keySet());
                    billIds.removeAll(mutexMap.keySet());
                }
                if ((examFacade = BgExamineFacadeFactory.getLocalInstance(ctx)).canExamine(checks) && (obj = examFacade.examines(checks)) instanceof List && !MBgExamineUtils.check(results = (List)obj)) {
                    result.put(CHECK_RESULT_EXAMINE, results);
                    check = true;
                }
            }
            if (this.checkAdjustData(conn, detailChecks, param, result) && result.containsKey(CHECK_RESULT_ADJUST)) {
                Map mutexMap = (Map)result.get(CHECK_RESULT_ADJUST);
                checks.removeAll(mutexMap.keySet());
                billIds.removeAll(mutexMap.keySet());
            }
            if (this.checkDailyActualData(conn, billIds, param, result) && result.containsKey(CHECK_RESULT_DAILY)) {
                Map mutexMap = (Map)result.get(CHECK_RESULT_DAILY);
                checks.removeAll(mutexMap.keySet());
                billIds.removeAll(mutexMap.keySet());
            }
            if (!check && (colls = DimUtils.getDimensionColls(conn, ctx.getLocale())) != null) {
                MbgDimInfo mbgDim = null;
                int in3 = colls.size();
                for (int i = 0; i < in3; ++i) {
                    mbgDim = colls.get(i);
                    param.mbgDims.put(mbgDim.getNumber(), mbgDim);
                    param.srcDims.put(mbgDim.getSrcNumber(), mbgDim);
                }
            }
            if (!check && !billIds.isEmpty()) {
                if (iEnactmentService == null) {
                    iEnactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
                }
                boolean isHold = false;
                block10: for (int i = 0; i < billIds.size(); ++i) {
                    ProcessInstInfo[] procInsts = iEnactmentService.getProcessInstanceByHoldedObjectId(billIds.get(i));
                    if (procInsts == null) continue;
                    int jn = procInsts.length;
                    for (int j = 0; j < jn; ++j) {
                        if (!procInsts[j].getState().startsWith("open")) continue;
                        isHold = true;
                        break block10;
                    }
                }
                if (!isHold) {
                    this.checkBgTemplateSequenceSet(ctx, conn, billIds, result, param);
                }
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("end Batch Check ! use = " + (System.currentTimeMillis() - begin) + "ms. "));
        return check || billIds.isEmpty();
    }

    private void checkIsRollVersion(Context ctx, IDimDataQuery model, Map<String, Object> result) {
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        if (bgFormInfo.getBgVersion() != null && bgFormInfo.getBgVersion().isIsRollVersion()) {
            BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_ROLLVERSION, bgFormInfo);
        }
    }

    protected void checkBgTemplateSequenceSet(Context ctx, Connection conn, List<String> billIds, Map<String, Object> result, AuditParam param) throws EASBizException, BOSException {
        BgTemplateSequenceSetHelper.checkBgTemplateSequenceSet(ctx, conn, billIds, result, param);
    }

    private void checkunAuditOrgUnit(Context ctx, Connection conn, IDimDataQuery model, AuditParam param, Map<String, Object> result) throws EASBizException, BOSException {
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        if (conn == null || bgFormInfo == null || bgFormInfo.getAuditOrgUnit() == null || param == null || result == null || bgFormInfo.isDecompose()) {
            return;
        }
        if (param.auditType == 1 || param.auditType == 10) {
            if (param.bgScheme == null) {
                param.bgScheme = MbgDataHelper.getBgSchemeInfo(conn, ctx.getLocale(), BOSUuid.read((String)param.audSchemeId));
            }
            param.bgOrgViewId = param.bgScheme.getEditOrgViewId();
            List<Object> pOrgUnitIds = new ArrayList();
            param.audOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select * where orgUnitID=  '" + param.audOrgUnitId + "' and viewID = '" + param.bgOrgViewId + "' and isVirtual = 0 ");
            List<BgOrgUnitInfo> pOrgUnits = MbgDataHelper.getParentBgOrgUnit(ctx, conn, param.bgOrgViewId, param.audOrgUnit);
            pOrgUnitIds = MbgDataHelper.getBgOrgUnitIds(pOrgUnits);
            Map<String, String[]> dailyMap = null;
            if (pOrgUnitIds.contains(bgFormInfo.getAuditOrgUnit().getId().toString())) {
                if (param.auditType == 1) {
                    if (result.containsKey(CHECK_RESULT_AUDIT_ORGUNIT)) {
                        dailyMap = (Map)result.get(CHECK_RESULT_AUDIT_ORGUNIT);
                    } else {
                        dailyMap = new HashMap();
                        result.put(CHECK_RESULT_AUDIT_ORGUNIT, dailyMap);
                    }
                } else if (result.containsKey(CHECK_RESULT_CARTIFICATE_ORGUNIT)) {
                    dailyMap = (Map)result.get(CHECK_RESULT_CARTIFICATE_ORGUNIT);
                } else {
                    dailyMap = new HashMap();
                    result.put(CHECK_RESULT_CARTIFICATE_ORGUNIT, dailyMap);
                }
                String[] bgFormStr = new String[]{bgFormInfo.getOrgUnit().getName(), bgFormInfo.getNumber(), bgFormInfo.getAuditOrgUnit().getName()};
                dailyMap.put(bgFormInfo.getId().toString(), bgFormStr);
            }
        }
    }

    protected void checkCanCourse(IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, AuditParam param, Map<String, Object> result) {
        if (model == null || result == null) {
            return;
        }
        boolean isErrorState = this.checkCanCourse(model, bgOrgUnit, param);
        if (isErrorState) {
            BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_COURSE, model);
        }
        if (isErrorState = this.checkCanCourseType(model, param)) {
            BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_PROCESSTYPE, model);
        }
        if (isErrorState = this.checkCanCourseReadonly(model, param)) {
            BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_COURSE_READONLY, model);
        }
    }

    protected boolean checkCanCourseReadonly(IDimDataQuery model, AuditParam param) {
        BgFormInfo info;
        boolean error = false;
        if (model == null || param == null) {
            return error;
        }
        if (param.auditType == 7 && model instanceof BgFormInfo && (info = (BgFormInfo)model).getBgTemplate() != null && info.getBgTemplate().isReadonly()) {
            error = true;
        }
        return error;
    }

    protected boolean checkCanCourseFormType(IDimDataQuery model, AuditParam param) {
        BgFormInfo info;
        boolean error = false;
        if (model == null || param == null) {
            return error;
        }
        if (param.auditType == 7 && model instanceof BgFormInfo && (info = (BgFormInfo)model).getBgTemplate() != null && BgTemFormTypeEnum.SPECIALFORM.equals((Object)info.getBgTemplate().getFormType())) {
            error = true;
        }
        return error;
    }

    protected boolean checkCanCourseType(IDimDataQuery model, AuditParam param) {
        boolean error = false;
        if (!(model instanceof BgFormInfo) || param == null) {
            return error;
        }
        BgFormInfo info = (BgFormInfo)model;
        if (param.auditType == 7) {
            if (BgProcessEnum.C03.equals((Object)info.getProcessType())) {
                error = true;
            }
        } else if (param.auditType == 2 && !BgProcessEnum.C01.equals((Object)info.getProcessType())) {
            error = true;
        }
        return error;
    }

    protected boolean checkCanCourse(IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, AuditParam param) {
        boolean error = false;
        if (model == null || param == null) {
            return error;
        }
        if (param.auditType == 7 && model instanceof BgFormInfo) {
            BgFormInfo info = (BgFormInfo)model;
            if (info.getBgTemplate().getOrgUnit().getId().equals((Object)info.getOrgUnit().getId())) {
                error = true;
            } else if (bgOrgUnit != null && (bgOrgUnit.getParent() == null || bgOrgUnit.getParent().getId().equals((Object)bgOrgUnit.getId()))) {
                error = true;
            }
        }
        return error;
    }

    protected void checkBillState(IDimDataQuery model, AuditParam param, Map<String, Object> result) {
        if (model == null || result == null) {
            return;
        }
        boolean isErrorState = this.checkBillState(model, param);
        if (isErrorState) {
            BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_STATE, model);
        }
    }

    protected boolean checkBillState(IDimDataQuery model, AuditParam param) {
        boolean error = true;
        if (model == null || param == null) {
            return error;
        }
        int state = model.getBizState();
        if (param.auditType == 0) {
            HashSet<Integer> checkStates = new HashSet<Integer>();
            checkStates.add(1);
            checkStates.add(25);
            checkStates.add(14);
            checkStates.add(3);
            checkStates.add(41);
            checkStates.add(42);
            checkStates.add(4);
            checkStates.add(35);
            checkStates.add(6);
            if (param.ctx != null && !BgParamNHelper.isNeedCertificate((Context)param.ctx)) {
                checkStates.add(40);
            }
            if (checkStates.contains(state)) {
                error = false;
            }
        } else if (param.auditType == 1 || param.auditType == 2) {
            if (state == 2) {
                error = false;
            }
        } else if (param.auditType == 3) {
            if (state == 50) {
                error = false;
            }
        } else if (param.auditType == 6) {
            if (state == 50 || state == 51) {
                error = false;
            }
        } else if (param.auditType == 7) {
            if (state == 1 || state == 42) {
                error = false;
            }
        } else if (param.auditType == 8) {
            if (state == 40) {
                error = false;
            }
        } else if (param.auditType == 9) {
            if (state == 40) {
                error = false;
            }
        } else if (param.auditType == 10) {
            if (state == 41) {
                error = false;
            }
        } else if (param.auditType == 4) {
            if (state == 50) {
                error = false;
            }
        } else if (param.auditType == 5) {
            if (state == 51) {
                error = false;
            }
        } else if (param.auditType == 6) {
            if (state == 50) {
                error = false;
            }
        } else if (param.auditType == 11 && (state == 14 || state == 25)) {
            error = false;
        }
        return error;
    }

    public static boolean checkWorkFlow(IEnactmentService iEnactmentService, IDimDataQuery model, Map<String, Object> result) throws BOSException {
        if (iEnactmentService == null || model == null || result == null) {
            return true;
        }
        ProcessInstInfo[] procInsts = iEnactmentService.getProcessInstanceByHoldedObjectId(model.getId().toString());
        if (procInsts != null) {
            int jn = procInsts.length;
            for (int j = 0; j < jn; ++j) {
                if (!procInsts[j].getState().startsWith("open")) continue;
                BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_WORKFLOW, model);
                return true;
            }
        }
        return false;
    }

    public static void checkIsRolledForm(IDimDataQuery model, Map<String, Object> result) throws BOSException {
        BgFormInfo info;
        if (model instanceof BgFormInfo && (info = (BgFormInfo)model).isIsRolled()) {
            BizMbgDataControlUtils.syncMessage(result, CHECK_RESULT_ISROLLED, model);
        }
    }

    public boolean checkAdjustData(Connection conn, Collection<String> billIds, AuditParam param, Map<String, Object> result) throws BOSException, EASBizException {
        boolean check = false;
        if (conn == null || billIds == null || billIds.isEmpty() || param == null || result == null) {
            return check;
        }
        if (param.auditType != 1) {
            return check;
        }
        int[] formStates = new int[]{4, 35, 15};
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.addAll(billIds);
        List rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FNumber, t.FName, t.FAdjustId, t.FState, c.FName_" + param.ctx.getLocale() + " from T_MBG_BgForm t left join T_ORG_CostCenter c on t.FOrgUnitId = c.FID where FAdjustId IN (" + BgDBUtils.getSqlParam() + ") and FState IN " + BgDBUtils.getSqlParam((int[])formStates));
        try {
            rst = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams);
            if (!rst.isEmpty()) {
                check = true;
                Map<String, String[]> adjustMap = null;
                if (result.containsKey(CHECK_RESULT_ADJUST)) {
                    adjustMap = (Map)result.get(CHECK_RESULT_ADJUST);
                } else {
                    adjustMap = new HashMap();
                    result.put(CHECK_RESULT_ADJUST, adjustMap);
                }
                for (Object[] obj : rst) {
                    if (obj[0].equals(obj[3])) continue;
                    String[] bgFormStr = new String[5];
                    bgFormStr[3] = (String)obj[3];
                    bgFormStr[0] = (String)obj[1];
                    bgFormStr[2] = (String)obj[2];
                    bgFormStr[4] = (String)obj[5];
                    adjustMap.put(bgFormStr[3], bgFormStr);
                }
            }
            int[] sourceStates = new int[]{1, 3, 12};
            sql.setLength(0);
            sql.append("select f.FID, f.FNumber, f.FName, c.FName_" + param.ctx.getLocale() + " from T_MBG_BgForm f  join T_ORG_CostCenter c on f.FOrgUnitId = c.FID  join T_MBG_BGPASTRECORD r on f.FID = r.FBgFormId where f.FID IN (" + BgDBUtils.getSqlParam() + ") and r.FPASTSOURCE IN " + BgDBUtils.getSqlParam((int[])formStates));
            rst = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams);
            if (!rst.isEmpty()) {
                check = true;
                Map<String, String[]> pastMap = null;
                if (result.containsKey(CHECK_RESULT_PASTDATA)) {
                    pastMap = (Map)result.get(CHECK_RESULT_PASTDATA);
                } else {
                    pastMap = new HashMap();
                    result.put(CHECK_RESULT_PASTDATA, pastMap);
                }
                for (Object[] obj : rst) {
                    if (obj[0].equals(obj[3])) continue;
                    String[] bgFormStr = new String[5];
                    bgFormStr[3] = (String)obj[0];
                    bgFormStr[0] = (String)obj[1];
                    bgFormStr[2] = (String)obj[2];
                    bgFormStr[4] = (String)obj[3];
                    pastMap.put(bgFormStr[3], bgFormStr);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return check;
    }

    protected boolean checkDailyActualData(Connection conn, Collection<String> billIds, AuditParam param, Map<String, Object> result) throws BOSException, EASBizException {
        boolean check = false;
        if (conn == null || billIds == null || billIds.isEmpty() || param == null || result == null) {
            return check;
        }
        if (param.auditType != 1) {
            return check;
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.addAll(billIds);
        List rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FNumber, t.FName, c.FName_" + param.ctx.getLocale() + " from T_MBG_BgForm t  join T_ORG_CostCenter c on t.FOrgUnitId = c.FID  join T_MBG_BgActualRecord r on t.FID = r.FBgFormID  where t.FID IN (" + BgDBUtils.getSqlParam() + ")");
        try {
            rst = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams);
            if (!rst.isEmpty()) {
                check = true;
                Map<String, String[]> dailyMap = null;
                if (result.containsKey(CHECK_RESULT_DAILY)) {
                    dailyMap = (Map)result.get(CHECK_RESULT_DAILY);
                } else {
                    dailyMap = new HashMap();
                    result.put(CHECK_RESULT_DAILY, dailyMap);
                }
                for (Object[] obj : rst) {
                    if (obj[0].equals(obj[3])) continue;
                    String[] bgFormStr = new String[5];
                    bgFormStr[3] = (String)obj[0];
                    bgFormStr[0] = (String)obj[1];
                    bgFormStr[2] = (String)obj[2];
                    bgFormStr[4] = (String)obj[3];
                    dailyMap.put(bgFormStr[3], bgFormStr);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return check;
    }

    public static void syncMessage(Map<String, Object> result, String messagekey, IDimDataQuery dimDataQuery) {
        if (result == null || StringUtils.isEmpty((String)messagekey) || dimDataQuery == null) {
            return;
        }
        Map<String, String[]> formMap = null;
        if (result.containsKey(messagekey)) {
            formMap = (Map)result.get(messagekey);
        } else {
            formMap = new HashMap();
            result.put(messagekey, formMap);
        }
        String[] bgFormStr = new String[5];
        bgFormStr[3] = dimDataQuery.getId().toString();
        bgFormStr[0] = dimDataQuery.getNumber();
        bgFormStr[2] = dimDataQuery.getName();
        bgFormStr[4] = dimDataQuery.getBizOrgUnit().getName();
        formMap.put(bgFormStr[3], bgFormStr);
    }

    public static void syncMessage(Map<String, Object> result, String messagekey, IDimDataQuery dimDataQuery, String otherMsg) {
        if (result == null || StringUtils.isEmpty((String)messagekey) || dimDataQuery == null) {
            return;
        }
        Map<String, String[]> formMap = null;
        if (result.containsKey(messagekey)) {
            formMap = (Map)result.get(messagekey);
        } else {
            formMap = new HashMap();
            result.put(messagekey, formMap);
        }
        String[] bgFormStr = new String[6];
        bgFormStr[3] = dimDataQuery.getId().toString();
        bgFormStr[0] = dimDataQuery.getNumber();
        bgFormStr[2] = dimDataQuery.getName();
        bgFormStr[4] = dimDataQuery.getBizOrgUnit().getName();
        bgFormStr[5] = otherMsg;
        if (!formMap.containsKey(bgFormStr[3])) {
            formMap.put(bgFormStr[3], bgFormStr);
        }
    }

    public static void syncMessage(Map<String, Object> result, String messagekey, String billId, String billNumber, String billName, String orgUnitName) {
        if (result == null || StringUtils.isEmpty((String)messagekey) || StringUtils.isEmpty((String)billId) || StringUtils.isEmpty((String)billNumber) || StringUtils.isEmpty((String)billName) || StringUtils.isEmpty((String)orgUnitName)) {
            return;
        }
        Map<String, String[]> formMap = null;
        if (result.containsKey(messagekey)) {
            formMap = (Map)result.get(messagekey);
        } else {
            formMap = new HashMap();
            result.put(messagekey, formMap);
        }
        String[] bgFormStr = new String[5];
        bgFormStr[3] = billId;
        bgFormStr[0] = billNumber;
        bgFormStr[2] = billName;
        bgFormStr[4] = orgUnitName;
        formMap.put(bgFormStr[3], bgFormStr);
    }
}

