/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import com.kingdee.eas.ma.mbg.utils.data.DimBaseBiz;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DimAuditBiz
extends DimBaseBiz {
    private static final Logger logger = Logger.getLogger(DimAuditBiz.class);

    public DimAuditBiz(BizMbgDataControlUtils utils) {
        super(utils);
    }

    @Override
    protected void process(Context ctx, List<String> billIds, Map<String, String> auditParams, AuditParam param, Map<String, Object> result) throws BOSException, EASBizException {
        super.process(ctx, billIds, auditParams, param, result);
    }

    @Override
    protected void updateBaseData(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (ctx == null || conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        Object[] sqlParams = null;
        int[] dataStates = this.getDataStates(param);
        BgSchemeAccIntHelper accIntHelper = param.getAccIntHelper();
        try {
            if (param.tmpDataId == null) {
                param.tmpDataId = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FRefCube VARCHAR(44))");
                BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpDataId, (String)"FID", (boolean)false, (boolean)false);
            } else {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + param.tmpDataId));
            }
            for (String cube : param.cubes) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Delete FROM " + param.tmpDataId));
                sql.setLength(0);
                if (!orgUnitIds.isEmpty()) {
                    sql.append("Insert Into " + param.tmpDataId + " (FID) Select FID from " + cube + " where FOrgUnitId = ? and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cube + ".FID)  and FAudOrgUnitId IN (select FID from " + param.tmpAudOrgUnit + ")  and FState IN " + this.getSqlStates(dataStates) + " and FScenario IN (select FScenarioId from T_MBG_BgScenario where FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE + ")  and FVersion = ?");
                    sqlParams = new Object[]{model.getBizOrgUnit().getId().toString(), model.getId().toString(), model.getBizVersion().getVersionId()};
                    if (accIntHelper.isUseAccInt()) {
                        sqlParams[0] = accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, model.getBizOrgUnit().getId().toString());
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                }
                sql.setLength(0);
                sql.append("Insert Into " + param.tmpDataId + " (FID) Select FID from " + cube + " where FOrgUnitId = ? and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cube + ".FID)  and FAudOrgUnitId is null  and FState IN " + this.getSqlStates(dataStates) + " and FScenario IN (select FScenarioId from T_MBG_BgScenario where FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE + ")  and FVersion = ?");
                sqlParams = new Object[]{model.getBizOrgUnit().getId().toString(), model.getId().toString(), model.getBizVersion().getVersionId()};
                if (accIntHelper.isUseAccInt()) {
                    sqlParams[0] = accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, model.getBizOrgUnit().getId().toString());
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                sql.setLength(0);
                sql.append("update " + cube + " set FAudFormId = ? where FAudFormId is null and exists (select FID from " + param.tmpDataId + " where FID = " + cube + ".FID)");
                sqlParams = new Object[]{param.currtBillId};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                sql.setLength(0);
                sql.append("update " + cube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?, FDetail = ? where exists (select FID from " + param.tmpDataId + " where FID = " + cube + ".FID)");
                sqlParams = new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, 1};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                sql.setLength(0);
                sql.append("update " + cube + " set FDetail = 1 where  exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cube + ".FID) and FState = ? and FDetail = 0");
                sqlParams = new Object[]{model.getId().toString(), param.audState};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    @Override
    protected void updateViewData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return;
        }
        boolean isDetail = model.getBizOrgUnit().getId().toString().equals(bgOrgUnit.getOrgUnitID());
        int[] dataStates = this.getDataStates(param);
        Object[] sqlParams = null;
        BgSchemeAccIntHelper accIntHelper = param.getAccIntHelper();
        try {
            for (String cube : param.cubes) {
                Map.Entry<String, String> entry2;
                String field;
                String tmpTable;
                String mbgDimNum;
                StringBuffer sql = new StringBuffer();
                sql.append("update " + cube + " set FState = ?, FAudFormId = ? , FAudOrgUnitID = ?, FAudUserID = ? " + (isDetail ? ", FDetail = ? " : "") + " where FOrgUnitId = ?  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cube + ".F2) ");
                if (!param.getTmpExtMap().isEmpty()) {
                    mbgDimNum = null;
                    tmpTable = null;
                    field = null;
                    entry2 = null;
                    for (Map.Entry<String, String> entry2 : param.getTmpExtMap().entrySet()) {
                        if (param.unionId == null && DimensionConstants.DEF_CSL_NUMBER.equals(entry2.getKey())) continue;
                        mbgDimNum = entry2.getKey();
                        tmpTable = entry2.getValue();
                        field = param.mbgDims.get(mbgDimNum).getRefField();
                        sql.append(" and exists (select FID from " + tmpTable + " where " + param.getField("FNumber") + " = " + cube + "." + field + ") ");
                    }
                }
                sql.append(" and exists (select FID from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cube + ".FBgPeriodID)  and exists (select FID from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cube + ".FBgElementID)  and exists (select FID from " + param.getTmpCurrency() + " where FID = " + cube + ".FCurrencyID)  and exists (select FID from " + param.getTmpScenario() + " where FID = " + cube + ".FScenario)  and FVersion = ? and FState IN " + this.getSqlStates(dataStates));
                if (!orgUnitIds.isEmpty()) {
                    sql.append(" and FAudOrgUnitId IN (select FID from " + param.tmpAudOrgUnit + ")");
                }
                if (isDetail) {
                    sql.append(" and not exists (select FID from " + param.tmpDataId + " where FID = " + cube + ".FID)");
                }
                sqlParams = isDetail ? (param.auditType == 0 ? new Object[]{param.audState, param.currtBillId, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, isDetail, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()} : new Object[]{param.audState, null, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, isDetail, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()}) : (param.auditType == 0 ? new Object[]{param.audState, param.currtBillId, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()} : new Object[]{param.audState, null, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()});
                if (accIntHelper.isUseAccInt()) {
                    if (isDetail) {
                        sqlParams[5] = accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, (String)sqlParams[5]);
                    } else {
                        sqlParams[4] = accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, (String)sqlParams[4]);
                    }
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                sql.setLength(0);
                sql.append("update " + cube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?, FAudFormId = ? " + (isDetail ? ", FDetail = ? " : "") + " where FOrgUnitId = ? and FAudOrgUnitId is null  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cube + ".F2) ");
                if (!param.getTmpExtMap().isEmpty()) {
                    mbgDimNum = null;
                    tmpTable = null;
                    field = null;
                    entry2 = null;
                    for (Map.Entry<String, String> entry2 : param.getTmpExtMap().entrySet()) {
                        if (param.unionId == null && DimensionConstants.DEF_CSL_NUMBER.equals(entry2.getKey())) continue;
                        mbgDimNum = entry2.getKey();
                        tmpTable = entry2.getValue();
                        field = param.mbgDims.get(mbgDimNum).getRefField();
                        sql.append(" and exists (select FID from " + tmpTable + " where " + param.getField("FNumber") + " = " + cube + "." + field + ") ");
                    }
                }
                sql.append(" and exists (select FID from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cube + ".FBgPeriodID)  and exists (select FID from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cube + ".FBgElementID)  and exists (select FID from " + param.getTmpCurrency() + " where FID = " + cube + ".FCurrencyID)  and exists (select FID from " + param.getTmpScenario() + " where FID = " + cube + ".FScenario)  and FVersion = ?");
                sql.append(" and FState IN " + this.getSqlStates(dataStates));
                if (isDetail) {
                    sql.append(" and not exists (select FID from " + param.tmpDataId + " where FID = " + cube + ".FID)");
                }
                sqlParams = isDetail ? (param.auditType == 0 ? new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, param.currtBillId, isDetail, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()} : new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, null, isDetail, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()}) : (param.auditType == 0 ? new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, param.currtBillId, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()} : new Object[]{param.audState, param.audOrgUnit != null ? param.audOrgUnit.getOrgUnitID() : null, param.audUserId, param.currtBillId, bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()});
                if (accIntHelper.isUseAccInt()) {
                    if (isDetail) {
                        sqlParams[5] = accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, (String)sqlParams[5]);
                    } else {
                        sqlParams[4] = accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, (String)sqlParams[4]);
                    }
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }
}

