/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import com.kingdee.eas.ma.mbg.utils.data.DimBaseBiz;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DimCourseBiz
extends DimBaseBiz {
    private static final Logger logger = Logger.getLogger(DimCourseBiz.class);

    public DimCourseBiz(BizMbgDataControlUtils utils) {
        super(utils);
    }

    public void course(Context ctx, List<String> billIds, Map<String, String> auditParams, Map<String, Object> result, AuditParam param) throws BOSException, EASBizException {
        logger.debug((Object)"begin course BgForm !");
        this.process(ctx, billIds, auditParams, param, result);
        logger.debug((Object)"end course BgForm !");
    }

    @Override
    protected void process(Context ctx, List<String> billIds, Map<String, String> auditParams, AuditParam param, Map<String, Object> result) throws BOSException, EASBizException {
        super.process(ctx, billIds, auditParams, param, result);
    }

    @Override
    protected void updateBaseData(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (ctx == null || conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        Object[] sqlParams = null;
        int[] dataStates = this.getDataStates(param);
        String billId = model.getId().toString();
        String orgUnitId = model.getBizOrgUnit().getId().toString();
        int versionId = model.getBizVersion().getVersionId();
        try {
            if (param.tmpDataId == null) {
                param.tmpDataId = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FRefCube VARCHAR(44))");
            }
            for (String cubeName : param.cubes) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + param.tmpDataId));
                sql.setLength(0);
                sql.append("Insert Into " + param.tmpDataId + " (FID) Select FID from " + cubeName + " where FOrgUnitId = ?  and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cubeName + ".FID)  and FState IN " + this.getSqlStates(dataStates) + " and FScenario IN (select FScenarioId from T_MBG_BgScenario where FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE + ")  and FVersion = ?");
                sqlParams = new Object[]{param.getAccIntHelper().convertOrgObject(orgUnitId), billId, versionId};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                sql.setLength(0);
                sql.append("update " + cubeName + " set FState = ? where exists (select FID from " + param.tmpDataId + " where FID = " + cubeName + ".FID)");
                sqlParams = new Object[]{param.audState};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                sql.setLength(0);
                sql.append("update " + cubeName + " set FDetail = 1 where exists (select FID from " + param.tmpDataId + " where FID = " + cubeName + ".FID) and FState = ? and FDetail = 0");
                sqlParams = new Object[]{param.audState};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    @Override
    protected void updateViewData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return;
        }
        boolean isDetail = model.getBizOrgUnit().getId().toString().equals(bgOrgUnit.getOrgUnitID());
        int[] dealedDataStates = new int[]{1, 3};
        String orgUnitId = bgOrgUnit.getOrgUnitID();
        int versionId = model.getBizVersion().getVersionId();
        Object[] sqlParams = null;
        try {
            for (String cubeName : param.cubes) {
                StringBuffer sql = new StringBuffer();
                sql.append("update " + cubeName + " set FState = ? ");
                if (isDetail) {
                    sql.append(",FDetail = 1 ");
                }
                sql.append(" where FOrgUnitId = ?  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cubeName + ".F2) ");
                if (!param.getTmpExtMap().isEmpty()) {
                    String mbgDimNum = null;
                    String tmpTable = null;
                    String field = null;
                    Map.Entry<String, String> entry2 = null;
                    for (Map.Entry<String, String> entry2 : param.getTmpExtMap().entrySet()) {
                        mbgDimNum = entry2.getKey();
                        tmpTable = entry2.getValue();
                        field = param.mbgDims.get(mbgDimNum).getRefField();
                        sql.append(" and exists (select FID from " + tmpTable + " where " + param.getField("FNumber") + " = " + cubeName + "." + field + ") ");
                    }
                }
                sql.append(" and exists (select FID from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cubeName + ".FBgElementID)  and exists (select FID from " + param.getTmpCurrency() + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + param.getTmpScenario() + " where FID = " + cubeName + ".FScenario)  and FVersion = ?");
                sql.append(" and FState IN " + this.getSqlStates(dealedDataStates));
                if (isDetail) {
                    sql.append(" and not exists (select FID from " + param.tmpDataId + " where FID = " + cubeName + ".FID)");
                }
                sqlParams = new Object[]{param.audState, param.getAccIntHelper().convertOrgObject(orgUnitId), versionId};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    @Override
    protected boolean isSetAudit() {
        return false;
    }

    @Override
    protected void updateAuditRecord(Context ctx, Connection conn, Locale locale, IDimDataQuery model, Map<String, String> auditParams, AuditParam param) throws Exception {
    }

    @Override
    protected String getLogItemName(AuditParam param) {
        return "mbg_bgForm_course";
    }
}

