/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.orgunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgOrgUnitException;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.utils.orgunit.BgTreeView;
import com.kingdee.eas.ma.mbg.utils.orgunit.MbgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.orgunit.OrgTreeEvent;
import com.kingdee.eas.ma.mbg.utils.orgunit.OrgUnitBaseUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class BgOrgUnitTreeUtils
extends OrgUnitBaseUtils {
    public static final String SHARE_ORGUNIT_TAG = "(s)";
    private BgTreeView bgTreeView = null;
    private Map<String, List<DefaultKingdeeTreeNode>> virtualNodeMap = new HashMap<String, List<DefaultKingdeeTreeNode>>();
    private Map<String, DefaultKingdeeTreeNode> ccOrgNodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
    private Set<String> checkOrgUnitIds = null;
    private Map<String, IObjectValue> cantInsertByDataIds = new HashMap<String, IObjectValue>();

    public BgTreeView getBgTreeView() {
        return this.bgTreeView;
    }

    protected Map<String, List<DefaultKingdeeTreeNode>> getVirtualNodeMap() {
        return this.virtualNodeMap;
    }

    public Map<String, DefaultKingdeeTreeNode> getCcOrgNodeMap() {
        return this.ccOrgNodeMap;
    }

    public void setCheckOrgUnitIds(Set<String> checkOrgUnitIds) {
        this.checkOrgUnitIds = checkOrgUnitIds;
        this.initCheckListener();
    }

    public Set<String> getCheckOrgUnitIds() {
        return this.checkOrgUnitIds;
    }

    public Map<String, IObjectValue> getCantInsertByDataIds() {
        return this.cantInsertByDataIds;
    }

    public void setCantInsertByDataIds(Map<String, IObjectValue> cantInsertByDataIds) {
        this.cantInsertByDataIds = cantInsertByDataIds;
    }

    public BgOrgUnitTreeUtils(Component component, KDTree kdTree, OrgType orgType) {
        super(component, kdTree, orgType);
    }

    public BgOrgUnitTreeUtils(Component component, KDTree kdTree, OrgType orgType, boolean isAsyncLoad) {
        super(component, kdTree, orgType, isAsyncLoad);
    }

    public void buildBgTeee(BOSUuid bgOrgViewId, boolean isSealUp, boolean isShowNumber) throws BOSException, EASBizException {
        TreeModel treeModel = this.builderTreeModel(bgOrgViewId, isSealUp, isShowNumber);
        this.setTreeModel(treeModel);
        this.getKdTree().setModel(treeModel);
        this.getKdTree().updateUI();
    }

    public void rebuildBgTeee(boolean isSealUp, boolean isShowNumber) {
        this.setSealUp(isSealUp);
        this.setShowNumber(isShowNumber);
        this.clearNodeRef();
        TreeModel treeModel = this.builderTreeModel();
        this.setTreeModel(treeModel);
        this.getKdTree().setModel(treeModel);
        this.getKdTree().updateUI();
    }

    @Override
    protected TreeModel getModel(DefaultKingdeeTreeNode root) {
        TreeModel model = super.getModel(root);
        return model;
    }

    @Override
    protected List<Object[]> queryFirstOrgUnits(BOSUuid uuid) throws BOSException, EASBizException {
        return null;
    }

    protected void queryLastOrgUnits(BOSUuid uuid) throws BOSException, EASBizException {
    }

    @Override
    protected List<Object[]> queryFullOrgUnits(BOSUuid uuid) throws BOSException, EASBizException {
        List bgOrgUnits = this.getBizInterface().getBgOrgUnits(uuid);
        return bgOrgUnits;
    }

    public List<BgOrgUnitInfo> getOrgUnits(String createOrgId) {
        ArrayList<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        this.getChildrenOrgUnit(root, null, bgOrgUnits);
        MbgOrgUnitHelper.sort(bgOrgUnits, createOrgId);
        return bgOrgUnits;
    }

    private void getChildrenOrgUnit(DefaultKingdeeTreeNode root, BgOrgUnitInfo pBgOrgUnit, List<BgOrgUnitInfo> orgUnits) {
        if (root == null || orgUnits == null || root.getChildCount() == 0) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        FullOrgUnitInfo model = null;
        BgOrgUnitInfo _bgOrgUnit = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            model = this.getOrgUnit(node);
            _bgOrgUnit = this.transBgOrgUnit((IObjectValue)model, pBgOrgUnit);
            if (pBgOrgUnit == null) {
                orgUnits.add(_bgOrgUnit);
            } else {
                pBgOrgUnit.setIsLeaf(false);
                pBgOrgUnit.getChildren().add(_bgOrgUnit);
            }
            this.getChildrenOrgUnit(node, _bgOrgUnit, orgUnits);
        }
        if (pBgOrgUnit != null) {
            MbgOrgUnitHelper.sort(pBgOrgUnit.getChildren(), null);
        }
    }

    @Override
    protected IObjectValue getOrgUnit(Object[] obj) {
        IObjectValue orgUnit = super.getOrgUnit(obj);
        orgUnit.setInt("isVirtual", ((Integer)obj[11]).intValue());
        orgUnit.setString("orgUnitId", (String)obj[12]);
        return orgUnit;
    }

    protected IObjectValue toBgOrgUnit(IObjectValue orgUnit) {
        if (orgUnit == null) {
            return null;
        }
        IObjectValue bgOrgUnit = this.createNewOrgUnit();
        bgOrgUnit.setString(bgOrgUnit.getPKField(), BOSUuid.create((String)"33F82845").toString());
        bgOrgUnit.setString("name", orgUnit.getString("name"));
        bgOrgUnit.setString("number", orgUnit.getString("number"));
        bgOrgUnit.setString("orgUnitId", orgUnit.getString(orgUnit.getPKField()));
        bgOrgUnit.setBoolean("isLeaf", true);
        bgOrgUnit.setInt("isOUSealUp", orgUnit.getBoolean("isOUSealUp") ? 1 : 0);
        bgOrgUnit.setString("simpleName", orgUnit.getString("simpleName"));
        bgOrgUnit.setString("code", orgUnit.getString("code"));
        bgOrgUnit.setString("description", orgUnit.getString("description"));
        return bgOrgUnit;
    }

    protected BgOrgUnitInfo transBgOrgUnit(IObjectValue orgUnit, BgOrgUnitInfo pBgOrgUnit) {
        if (orgUnit == null) {
            return null;
        }
        BgOrgUnitInfo bgOrgUnit = new BgOrgUnitInfo();
        bgOrgUnit.setString(bgOrgUnit.getPKField(), orgUnit.getString(orgUnit.getPKField()));
        bgOrgUnit.setOrgUnitID(orgUnit.getString("orgUnitId"));
        bgOrgUnit.setName(orgUnit.getString("name"));
        bgOrgUnit.setNumber(orgUnit.getString("number"));
        bgOrgUnit.setIsLeaf(true);
        bgOrgUnit.setIsVirtual(orgUnit.getInt("isVirtual") != 0);
        bgOrgUnit.setIsOUSealUp(orgUnit.getInt("isOUSealUp") != 0);
        bgOrgUnit.setSimpleName(orgUnit.getString("simpleName"));
        bgOrgUnit.setDisplayName(orgUnit.getString("name"));
        bgOrgUnit.setDescription(orgUnit.getString("description"));
        bgOrgUnit.setCode(orgUnit.getString("code"));
        if (pBgOrgUnit != null) {
            bgOrgUnit.setLevel(pBgOrgUnit.getLevel() + 1);
            bgOrgUnit.setParent(pBgOrgUnit);
            bgOrgUnit.setLongNumber(pBgOrgUnit.getLongNumber() + "!" + bgOrgUnit.getNumber());
            bgOrgUnit.setDisplayName(pBgOrgUnit.getDisplayName() + "_" + bgOrgUnit.getName());
        } else {
            bgOrgUnit.setLevel(1);
            bgOrgUnit.setParent(null);
            bgOrgUnit.setLongNumber(bgOrgUnit.getNumber());
        }
        return bgOrgUnit;
    }

    @Override
    protected String getOrgUnitOrderKey(IObjectValue orgUnit) {
        return orgUnit.getInt("isVirtual") + "_" + orgUnit.getString("longNumber");
    }

    @Override
    public synchronized DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, IObjectValue orgUnit) throws Exception {
        return this.addNode(parent, orgUnit, null, false);
    }

    @Override
    public synchronized DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, IObjectValue orgUnit, StringBuilder errMsg, boolean isAddByStructCostCenter) throws Exception {
        if (orgUnit != null && this.getCcOrgNodeMap().containsKey(orgUnit.getString("orgUnitId"))) {
            orgUnit.setInt("isVirtual", 1);
        }
        return super.addNode(parent, orgUnit, errMsg, isAddByStructCostCenter);
    }

    @Override
    public DefaultKingdeeTreeNode getOrgUnitNode(IObjectValue orgUnit) {
        DefaultKingdeeTreeNode node = super.getOrgUnitNode(orgUnit);
        if (node != null && this.checkVirtualOrg(orgUnit)) {
            node.setText(orgUnit.getString("name") + SHARE_ORGUNIT_TAG);
        }
        return node;
    }

    public boolean checkVirtualOrg(DefaultKingdeeTreeNode node) {
        return this.checkVirtualOrg((IObjectValue)this.getOrgUnit(node));
    }

    public boolean checkVirtualOrg(IObjectValue orgUnit) {
        return orgUnit != null && orgUnit.getInt("isVirtual") == 1;
    }

    @Override
    protected void addNodeData(DefaultKingdeeTreeNode node, IObjectValue orgUnit) {
        if (node == null || orgUnit == null) {
            return;
        }
        if (!this.getCcOrgNodeMap().containsKey(orgUnit.getString("orgUnitId"))) {
            this.getCcOrgNodeMap().put(orgUnit.getString("orgUnitId"), node);
        }
        if (this.checkVirtualOrg(orgUnit)) {
            List<DefaultKingdeeTreeNode> nodes = this.getVirtualNodeMap().get(orgUnit.getString("orgUnitId"));
            if (nodes == null) {
                nodes = new ArrayList<DefaultKingdeeTreeNode>();
                this.getVirtualNodeMap().put(orgUnit.getString("orgUnitId"), nodes);
            }
            nodes.add(node);
        }
        super.addNodeData(node, orgUnit);
    }

    public void addSelectNodes(DefaultKingdeeTreeNode bgParent, List<DefaultKingdeeTreeNode> ccOrgUnits, boolean checkSelected) throws Exception {
        if (bgParent == null || ccOrgUnits == null || ccOrgUnits.isEmpty()) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode hisNode = null;
        DefaultKingdeeTreeNode bgNode = null;
        int in = ccOrgUnits.size();
        for (int i = 0; i < in; ++i) {
            node = ccOrgUnits.get(i);
            if (hisNode != null && this.checkIsParent(node, hisNode) || (bgNode = this.addSelectNode(bgParent, node, checkSelected)) == null) continue;
            hisNode = node;
        }
    }

    private boolean checkIsParent(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode histNode) {
        boolean check = false;
        if (node == null || histNode == null) {
            return check;
        }
        FullOrgUnitInfo orgUnit = this.getOrgUnit(node);
        FullOrgUnitInfo pOrgUnit = this.getOrgUnit(histNode);
        if (orgUnit == null || pOrgUnit == null) {
            return check;
        }
        String longNumber = orgUnit.getString("longNumber");
        String pLongNumber = pOrgUnit.getString("longNumber");
        int level = orgUnit.getInt("level");
        int pLevel = pOrgUnit.getInt("level");
        if (longNumber.startsWith(pLongNumber + "!") && level == pLevel + 1) {
            check = true;
        }
        DefaultKingdeeTreeNode _hisNode = null;
        int in = histNode.getChildCount();
        for (int i = 0; i < in && !check; ++i) {
            _hisNode = (DefaultKingdeeTreeNode)histNode.getChildAt(i);
            check = this.checkIsParent(node, _hisNode);
        }
        return check;
    }

    public DefaultKingdeeTreeNode addSelectNode(DefaultKingdeeTreeNode bgParent, DefaultKingdeeTreeNode ccOrgUnit, boolean checkSelected) throws Exception {
        return this.addSelectNode(bgParent, ccOrgUnit, checkSelected, null, false, null);
    }

    public DefaultKingdeeTreeNode addSelectNode(DefaultKingdeeTreeNode bgParent, DefaultKingdeeTreeNode ccOrgUnit, boolean checkSelected, StringBuilder errMsg, boolean isAddByStructCostCenter, Map<String, DefaultKingdeeTreeNode> orgIdToNodes) throws Exception {
        if (bgParent == null || ccOrgUnit == null) {
            return null;
        }
        if (checkSelected && !ccOrgUnit.isChecked()) {
            return null;
        }
        DefaultKingdeeTreeNode _bgNode = null;
        DefaultKingdeeTreeNode _node = null;
        FullOrgUnitInfo pBgOrgUnit = this.getOrgUnit(bgParent);
        FullOrgUnitInfo orgUnit = this.getOrgUnit(ccOrgUnit);
        if (orgUnit != null) {
            FullOrgUnitInfo bgOrgUnit = null;
            if (this.hasBgOrgUnit((IObjectValue)orgUnit)) {
                bgOrgUnit = orgUnit;
            } else {
                bgOrgUnit = this.toBgOrgUnit((IObjectValue)orgUnit);
                bgOrgUnit.setBoolean("isLeaf", true);
                if (pBgOrgUnit != null) {
                    bgOrgUnit.setString("longNumber", pBgOrgUnit.getString("longNumber") + "!" + bgOrgUnit.getString("number"));
                    bgOrgUnit.setInt("level", pBgOrgUnit.getInt("level") + 1);
                    bgOrgUnit.setString("parentId", pBgOrgUnit.getString(pBgOrgUnit.getPKField()));
                } else {
                    bgOrgUnit.setString("longNumber", bgOrgUnit.getString("number"));
                    bgOrgUnit.setInt("level", 1);
                    bgOrgUnit.setString("parentId", null);
                }
            }
            _bgNode = this.addNode(bgParent, (IObjectValue)bgOrgUnit, errMsg, isAddByStructCostCenter);
        }
        if (_bgNode != null) {
            int in = ccOrgUnit.getChildCount();
            for (int i = 0; i < in; ++i) {
                _node = (DefaultKingdeeTreeNode)ccOrgUnit.getChildAt(i);
                DefaultKingdeeTreeNode childNode = this.addSelectNode(_bgNode, _node, checkSelected, errMsg, isAddByStructCostCenter, orgIdToNodes);
                this.addNewNodeToNodesMap(childNode, orgIdToNodes);
            }
        }
        return _bgNode;
    }

    private boolean hasBgOrgUnit(IObjectValue orgUnit) {
        String orgUnitId;
        return orgUnit != null && "33F82845".equals(BOSUuid.read((String)(orgUnitId = orgUnit.getString(orgUnit.getPKField()))).getType().toString());
    }

    @Override
    public void removeNode(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnit(root);
        if (!this.checkVirtualOrg((IObjectValue)bgOrgUnit)) {
            this.removeAllVirtualNode(root);
        }
        super.removeNode(root);
    }

    @Override
    protected void removeNodeData(DefaultKingdeeTreeNode node) {
        super.removeNodeData(node);
        if (node == null) {
            return;
        }
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnit(node);
        if (bgOrgUnit != null) {
            if (this.checkVirtualOrg((IObjectValue)bgOrgUnit)) {
                List<DefaultKingdeeTreeNode> nodes = this.getVirtualNodeMap().get(bgOrgUnit.getString("orgUnitId"));
                if (nodes != null) {
                    nodes.remove(node);
                }
            } else {
                this.getCcOrgNodeMap().remove(bgOrgUnit.getString("orgUnitId"));
            }
        }
    }

    protected void removeAllVirtualNode(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnit(root);
        if (this.checkVirtualOrg((IObjectValue)bgOrgUnit)) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.removeNode(node);
        }
        List<DefaultKingdeeTreeNode> nodes = this.getVirtualNodeMap().get(bgOrgUnit.getString("orgUnitId"));
        if (nodes != null && !nodes.isEmpty()) {
            for (int i = nodes.size() - 1; i >= 0; --i) {
                node = nodes.get(i);
                this.removeNode(node);
            }
        }
    }

    public void moveToNodes(TreeModel destModel, DefaultKingdeeTreeNode root, TreeModel srcModel, List<DefaultKingdeeTreeNode> nodes) throws BgOrgUnitException {
        if (destModel == null || root == null || srcModel == null || nodes == null || nodes.isEmpty()) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        FullOrgUnitInfo bOrgUnit = null;
        int in = nodes.size();
        for (int i = 0; i < in; ++i) {
            node = nodes.get(i);
            bOrgUnit = this.getOrgUnit(node);
            if (this.checkVirtualOrg((IObjectValue)bOrgUnit)) {
                throw new BgOrgUnitException(BgOrgUnitException.CANTMOVEVIRTUALORG);
            }
            ((DefaultTreeModel)srcModel).removeNodeFromParent((MutableTreeNode)node);
            ((DefaultTreeModel)destModel).insertNodeInto((MutableTreeNode)node, (MutableTreeNode)root, root.getChildCount());
            this.disableChildCheckBox(node);
            this.removeNodesData(node);
        }
    }

    public void moveBackNodes(TreeModel destModel, DefaultKingdeeTreeNode destNode, TreeModel srcModel, List<DefaultKingdeeTreeNode> nodes, boolean isShowNumber) throws Exception {
        if (destNode == null || nodes == null) {
            return;
        }
        this.moveVerify(destNode, nodes);
        this.addSelectNodes(destNode, nodes, false);
        Enumeration nodeEnum = destNode.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            FullOrgUnitInfo orginfo = null;
            if (node == null || node.getUserObject() == null) continue;
            orginfo = ((OrgStructureInfo)node.getUserObject()).getUnit();
            if (node.getText().indexOf(orginfo.getNumber() + "_") != -1) {
                node.setText(node.getText().substring(node.getText().indexOf(orginfo.getNumber() + "_") + orginfo.getNumber().length() + 1, node.getText().length()));
            }
            if (!isShowNumber) continue;
            node.setText(orginfo.getNumber() + "_" + node.getText());
        }
        this.expandNode(destNode);
        this.getKdTree().updateUI();
        DefaultKingdeeTreeNode nodess = null;
        int in = nodes.size();
        for (int i = 0; i < in; ++i) {
            nodess = nodes.get(i);
            ((DefaultTreeModel)srcModel).removeNodeFromParent((MutableTreeNode)nodess);
        }
    }

    private void moveVerify(DefaultKingdeeTreeNode destNode, List<DefaultKingdeeTreeNode> nodes) throws Exception {
        if (destNode == null || nodes == null || nodes.isEmpty()) {
            return;
        }
        HashSet<String> orgUnitIds = new HashSet<String>();
        DefaultKingdeeTreeNode root = this.getRootNode(destNode);
        FullOrgUnitInfo orgUnit = null;
        FullOrgUnitInfo rOrgUnit = this.getOrgUnit(root);
        List<DefaultKingdeeTreeNode> children = this.getAllNode(root);
        for (DefaultKingdeeTreeNode node : children) {
            orgUnit = this.getOrgUnit(node);
            if (orgUnit == null) continue;
            orgUnitIds.add(orgUnit.getString("orgUnitId"));
        }
        for (DefaultKingdeeTreeNode node : nodes) {
            children = this.getAllNode(node);
            for (DefaultKingdeeTreeNode child : children) {
                orgUnit = this.getOrgUnit(child);
                if (orgUnit == null || !orgUnitIds.contains(orgUnit.getString("orgUnitId"))) continue;
                throw new BgOrgUnitException(BgOrgUnitException.HASEXISTORG, new String[]{orgUnit.getString("name"), rOrgUnit.getString("name"), orgUnit.getString("name")});
            }
        }
    }

    @Override
    protected boolean treeNodes_Inserted(OrgTreeEvent e) throws Exception {
        boolean state = true;
        super.treeNodes_Inserted(e);
        StringBuilder errMsg = e.getErrMsg();
        DefaultKingdeeTreeNode node = e.getNode();
        DefaultKingdeeTreeNode parent = e.getParent();
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnit(node);
        FullOrgUnitInfo pOrgUnit = this.getOrgUnit(parent);
        if (pOrgUnit != null && this.checkVirtualOrg((IObjectValue)pOrgUnit) && !this.checkVirtualOrg((IObjectValue)bgOrgUnit)) {
            if (e.isAddByStructCostCenter()) {
                this.addErrMsg(errMsg, (IObjectValue)bgOrgUnit, "com.kingdee.eas.ma.mbg.BgOrgUnitReource", "hasVirtualOrg");
                return false;
            }
            throw new BgOrgUnitException(BgOrgUnitException.HASVIRTUALORG, new String[]{bgOrgUnit.getString("name")});
        }
        state &= this.checkParentNode(node, parent, errMsg, e.isAddByStructCostCenter());
        state &= this.checkTreeNode(node, parent, errMsg, e.isAddByStructCostCenter());
        if (!e.isAddByStructCostCenter()) {
            DefaultKingdeeTreeNode root = this.getRootNode(parent);
            FullOrgUnitInfo rOrgUnit = this.getOrgUnit(root);
            if (this.checkAllTree(root, (IObjectValue)bgOrgUnit)) {
                throw new BgOrgUnitException(BgOrgUnitException.HASEXISTORG, new String[]{bgOrgUnit.getString("name"), rOrgUnit.getString("name"), bgOrgUnit.getString("name")});
            }
        }
        return state;
    }

    private void addErrMsg(StringBuilder errMsg, IObjectValue bgOrgUnit, String resClassName, String resName) {
        if (errMsg != null) {
            errMsg.append(EASResource.getString((String)resClassName, (String)resName, (Object[])new Object[]{bgOrgUnit.get("name"), bgOrgUnit.get("number")})).append("\r\n");
        }
    }

    public boolean checkParentNode(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode parent) throws EASBizException {
        return this.checkParentNode(node, parent, null, false);
    }

    public boolean checkParentNode(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode parent, StringBuilder errMsg, boolean isAddByStructCostCenter) throws EASBizException {
        DefaultKingdeeTreeNode realNode;
        DefaultKingdeeTreeNode _node;
        if (node == null || parent == null) {
            return true;
        }
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnit(node);
        FullOrgUnitInfo pOrgUnit = this.getOrgUnit(parent);
        FullOrgUnitInfo _pOrgUnit = null;
        if (bgOrgUnit != null && this.checkVirtualOrg((IObjectValue)pOrgUnit) && (_node = this.getCcOrgNodeMap().get(bgOrgUnit.get("orgUnitId"))) != null && _node.getParent() != null) {
            HashSet<String> _parentIds = new HashSet<String>();
            List<DefaultKingdeeTreeNode> _parents = this.getAllParentNodes(_node);
            for (DefaultKingdeeTreeNode _parent : _parents) {
                _pOrgUnit = this.getOrgUnit(_parent);
                _parentIds.add(_pOrgUnit.getString("orgUnitId"));
            }
            if (!_parentIds.contains(pOrgUnit.getString("orgUnitId"))) {
                if (isAddByStructCostCenter) {
                    this.addErrMsg(errMsg, (IObjectValue)bgOrgUnit, "com.kingdee.eas.ma.mbg.BgOrgUnitReource", "cantInsertByShareOrgParent");
                    return false;
                }
                throw new BgOrgUnitException(BgOrgUnitException.CANTINSERTBYSHAREORGPARENT, new String[]{bgOrgUnit.getString("name")});
            }
        }
        if (bgOrgUnit != null && this.checkVirtualOrg((IObjectValue)bgOrgUnit) && (realNode = this.getCcOrgNodeMap().get(bgOrgUnit.get("orgUnitId"))) != null) {
            List<DefaultKingdeeTreeNode> virNodes;
            FullOrgUnitInfo realpOrgUnit;
            DefaultKingdeeTreeNode rootNode = this.getRootNode(parent);
            DefaultKingdeeTreeNode realParent = (DefaultKingdeeTreeNode)realNode.getParent();
            if (realParent != null && parent == null || realParent == null && parent != null) {
                if (isAddByStructCostCenter) {
                    this.addErrMsg(errMsg, (IObjectValue)bgOrgUnit, "com.kingdee.eas.ma.mbg.BgOrgUnitReource", "cantInsertByShareOrgParent");
                    return false;
                }
                throw new BgOrgUnitException(BgOrgUnitException.CANTINSERTBYSHAREORGPARENT, new String[]{bgOrgUnit.getString("name")});
            }
            if (realParent != null && parent != null && (realpOrgUnit = this.getOrgUnit(realParent)) != null && (virNodes = this.getVirtualNodeMap().get(realpOrgUnit.get("orgUnitId"))) != null) {
                for (DefaultKingdeeTreeNode virnode : virNodes) {
                    if (rootNode != this.getRootNode(virnode) || (_pOrgUnit = this.getOrgUnit(virnode)) == null || pOrgUnit == null || _pOrgUnit.get("orgUnitId").equals(pOrgUnit.get("orgUnitId"))) continue;
                    if (isAddByStructCostCenter) {
                        this.addErrMsg(errMsg, (IObjectValue)bgOrgUnit, "com.kingdee.eas.ma.mbg.BgOrgUnitReource", "cantInsertByShareOrgParent");
                        return false;
                    }
                    throw new BgOrgUnitException(BgOrgUnitException.CANTINSERTBYSHAREORGPARENT, new String[]{bgOrgUnit.getString("name")});
                }
            }
        }
        return true;
    }

    protected boolean checkTreeNode(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode parent) throws Exception {
        return this.checkTreeNode(node, parent, null, false);
    }

    protected boolean checkTreeNode(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode parent, StringBuilder errMsg, boolean isAddByStructCostCenter) throws Exception {
        if (node == null || parent == null) {
            return true;
        }
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnit(node);
        if (bgOrgUnit != null && this.checkVirtualOrg((IObjectValue)bgOrgUnit)) {
            DefaultKingdeeTreeNode realNode = this.getCcOrgNodeMap().get(bgOrgUnit.get("orgUnitId"));
            if (parent != null && parent.getUserObject() != null) {
                FullOrgUnitInfo _orgUnit = null;
                DefaultKingdeeTreeNode _node = null;
                List<DefaultKingdeeTreeNode> parents = this.getAllParentNodes(realNode);
                List<DefaultKingdeeTreeNode> childs = this.getAllLeafNodes(realNode);
                HashSet<String> orgUnitIds = new HashSet<String>();
                for (DefaultKingdeeTreeNode _parent : parents) {
                    _orgUnit = this.getOrgUnit(_parent);
                    orgUnitIds.add((String)_orgUnit.get("orgUnitId"));
                }
                for (DefaultKingdeeTreeNode _child : childs) {
                    _orgUnit = this.getOrgUnit(_child);
                    orgUnitIds.add((String)_orgUnit.get("orgUnitId"));
                }
                int in = parent.getChildCount();
                for (int i = 0; i < in; ++i) {
                    _node = (DefaultKingdeeTreeNode)parent.getChildAt(i);
                    _orgUnit = this.getOrgUnit(_node);
                    if (!this.checkVirtualOrg((IObjectValue)_orgUnit) || !orgUnitIds.contains(_orgUnit.get("orgUnitId"))) continue;
                    if (isAddByStructCostCenter) {
                        this.addErrMsg(errMsg, (IObjectValue)bgOrgUnit, "com.kingdee.eas.ma.mbg.BgOrgUnitReource", "cantInsertByShareOrgParent");
                        return false;
                    }
                    throw new BgOrgUnitException(BgOrgUnitException.CANTINSERTBYSHAREORGPARENT, new String[]{bgOrgUnit.getString("name")});
                }
            }
        }
        return true;
    }

    public void checkChildNode(DefaultKingdeeTreeNode node) throws EASBizException {
        if (node == null || node.getChildCount() == 0) {
            return;
        }
        if (this.checkVirtualOrg(node)) {
            FullOrgUnitInfo virOrgUnit = this.getOrgUnit(node);
            DefaultKingdeeTreeNode _node = this.getCcOrgNodeMap().get(virOrgUnit.get("orgUnitId"));
            if (_node != null) {
                DefaultKingdeeTreeNode tmpNode = null;
                FullOrgUnitInfo orgUnit = null;
                HashMap<String, DefaultKingdeeTreeNode> virOrgIds = new HashMap<String, DefaultKingdeeTreeNode>();
                List<DefaultKingdeeTreeNode> leafs = this.getAllLeafNodes(node);
                int in = leafs.size();
                for (int i = 0; i < in; ++i) {
                    tmpNode = leafs.get(i);
                    orgUnit = this.getOrgUnit(tmpNode);
                    if (orgUnit == null) continue;
                    virOrgIds.put(orgUnit.getString("orgUnitId"), tmpNode);
                }
                HashSet<String> orgIds = new HashSet<String>();
                List<DefaultKingdeeTreeNode> nodes = this.getAllNode(_node);
                int in2 = nodes.size();
                for (int i = 0; i < in2; ++i) {
                    tmpNode = nodes.get(i);
                    orgUnit = this.getOrgUnit(tmpNode);
                    if (orgUnit == null || this.checkVirtualOrg((IObjectValue)orgUnit)) continue;
                    orgIds.add(orgUnit.getString("orgUnitId"));
                }
                for (String orgUnitId : orgIds) {
                    virOrgIds.remove(orgUnitId);
                }
                if (!virOrgIds.isEmpty()) {
                    tmpNode = (DefaultKingdeeTreeNode)virOrgIds.values().iterator().next();
                    orgUnit = this.getOrgUnit(tmpNode);
                    this.selectNode(tmpNode);
                    this.expandNode(tmpNode);
                    throw new BgOrgUnitException(BgOrgUnitException.CANTINSERTBYSHAREORGPARENT, new String[]{orgUnit.getString("name")});
                }
            }
        }
    }

    private boolean checkAllTree(DefaultKingdeeTreeNode parent, IObjectValue bgOrgUnit) {
        boolean check = false;
        if (parent == null || parent.getUserObject() == null) {
            return check;
        }
        FullOrgUnitInfo pOrgUnit = this.getOrgUnit(parent);
        if (bgOrgUnit.getString("orgUnitId").equals(pOrgUnit.get("orgUnitId"))) {
            check = true;
        } else {
            DefaultKingdeeTreeNode node = null;
            int in = parent.getChildCount();
            for (int i = 0; i < in && !check; ++i) {
                node = (DefaultKingdeeTreeNode)parent.getChildAt(i);
                check = this.checkAllTree(node, bgOrgUnit);
            }
        }
        return check;
    }

    @Override
    protected void treeNodes_Removed(OrgTreeEvent e) throws Exception {
        super.treeNodes_Removed(e);
        DefaultKingdeeTreeNode node = e.getNode();
        FullOrgUnitInfo orgUnit = this.getOrgUnit(node);
        if (orgUnit != null) {
            if (!this.checkVirtualOrg((IObjectValue)orgUnit) && this.getCheckOrgUnitIds() != null && this.getCheckOrgUnitIds().contains(orgUnit.getString("orgUnitId"))) {
                throw new BgOrgUnitException(BgOrgUnitException.CANTREMOVEBYDATA, new String[]{orgUnit.getString("name")});
            }
            if (this.getCantInsertByDataIds() != null && this.getCantInsertByDataIds().get(orgUnit.getString("orgUnitId")) != null) {
                this.getCantInsertByDataIds().remove(orgUnit.getString("orgUnitId"));
            }
        }
    }

    public void checkAllTreeNode() throws EASBizException {
        int i;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel().getRoot();
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        DefaultKingdeeTreeNode child = null;
        FullOrgUnitInfo orgUnit = null;
        HashMap<String, HashSet<String>> orgUnitIdMap = new HashMap<String, HashSet<String>>();
        HashSet<String> orgUnitIds = new HashSet();
        int in = root.getChildCount();
        for (i = 0; i < in; ++i) {
            child = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (this.checkVirtualOrg(child)) continue;
            orgUnit = this.getOrgUnit(child);
            if (orgUnitIdMap.containsKey(orgUnit.getString("orgUnitId"))) {
                orgUnitIds = (Set)orgUnitIdMap.get(orgUnit.getString("orgUnitId"));
            } else {
                orgUnitIds = new HashSet();
                orgUnitIdMap.put(orgUnit.getString("orgUnitId"), orgUnitIds);
            }
            this.putAllTreeNode(child, orgUnitIds);
        }
        in = root.getChildCount();
        for (i = 0; i < in; ++i) {
            child = (DefaultKingdeeTreeNode)root.getChildAt(i);
            orgUnit = this.getOrgUnit(child);
            if (this.checkVirtualOrg((IObjectValue)orgUnit)) continue;
            if (orgUnitIdMap.containsKey(orgUnit.getString("orgUnitId"))) {
                orgUnitIds = (Set)orgUnitIdMap.get(orgUnit.getString("orgUnitId"));
            } else {
                orgUnitIds = new HashSet();
                orgUnitIdMap.put(orgUnit.getString("orgUnitId"), orgUnitIds);
            }
            this.checkAllTreeNode(child, orgUnitIds);
        }
    }

    private void putAllTreeNode(DefaultKingdeeTreeNode root, Set<String> orgUnitIds) throws EASBizException {
        if (root == null || orgUnitIds == null) {
            return;
        }
        FullOrgUnitInfo orgUnit = this.getOrgUnit(root);
        if (!this.checkVirtualOrg((IObjectValue)orgUnit) && orgUnit != null) {
            orgUnitIds.add((String)orgUnit.get("orgUnitId"));
            DefaultKingdeeTreeNode child = null;
            int in = root.getChildCount();
            for (int i = 0; i < in; ++i) {
                child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.putAllTreeNode(child, orgUnitIds);
            }
        }
    }

    private void checkAllTreeNode(DefaultKingdeeTreeNode root, Set<String> orgUnitIds) throws EASBizException {
        if (root == null || orgUnitIds == null) {
            return;
        }
        FullOrgUnitInfo orgUnit = this.getOrgUnit(root);
        FullOrgUnitInfo pOrgUnit = this.getOrgUnit((DefaultKingdeeTreeNode)root.getParent());
        if (this.checkVirtualOrg((IObjectValue)orgUnit)) {
            if (orgUnitIds.contains(orgUnit.get("orgUnitId"))) {
                this.selectNode(root);
                this.expandNode(root);
                throw new BgOrgUnitException(BgOrgUnitException.CHECKSHAREORG, new String[]{pOrgUnit != null ? pOrgUnit.getName() : "", orgUnit.getName() + SHARE_ORGUNIT_TAG});
            }
            root = this.getCcOrgNodeMap().get(orgUnit.get("orgUnitId"));
            orgUnit = this.getOrgUnit(root);
            DefaultKingdeeTreeNode child = null;
            int in = root.getChildCount();
            for (int i = 0; i < in; ++i) {
                child = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.checkAllTreeNode(child, orgUnitIds);
            }
        }
    }

    public Map<String, DefaultKingdeeTreeNode> getVirtualNodes(DefaultKingdeeTreeNode node) {
        HashMap<String, DefaultKingdeeTreeNode> virNodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        if (node == null) {
            return virNodeMap;
        }
        this.getVirtualNodes(node, virNodeMap);
        return virNodeMap;
    }

    private void getVirtualNodes(DefaultKingdeeTreeNode node, Map<String, DefaultKingdeeTreeNode> virNodeMap) {
        if (node == null || virNodeMap == null) {
            return;
        }
        FullOrgUnitInfo orgUnit = this.getOrgUnit(node);
        if (this.checkVirtualOrg((IObjectValue)orgUnit)) {
            virNodeMap.put((String)orgUnit.get("orgUnitId"), node);
        }
        DefaultKingdeeTreeNode child = null;
        int in = node.getChildCount();
        for (int i = 0; i < in; ++i) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.getVirtualNodes(child, virNodeMap);
        }
    }

    public void checkVirtualNode(DefaultKingdeeTreeNode node) throws Exception {
        DefaultKingdeeTreeNode realNode;
        FullOrgUnitInfo orgUnit;
        if (!this.checkVirtualOrg(node)) {
            return;
        }
        if (node.getChildCount() > 0 && (orgUnit = this.getOrgUnit(node)) != null && (realNode = this.getCcOrgNodeMap().get(orgUnit.get("orgUnitId"))) != null) {
            int i;
            DefaultKingdeeTreeNode child = null;
            FullOrgUnitInfo _orgUnit = null;
            if (realNode.getChildCount() != node.getChildCount()) {
                this.selectNode(node);
                throw new BgOrgUnitException(BgOrgUnitException.CHECKVIRTUALSTRUCTURE, new String[]{orgUnit.getString("name")});
            }
            HashSet<String> rChildIds = new HashSet<String>();
            HashSet<String> vChildIds = new HashSet<String>();
            int in = realNode.getChildCount();
            for (i = 0; i < in; ++i) {
                child = (DefaultKingdeeTreeNode)realNode.getChildAt(i);
                if (this.checkVirtualOrg(child)) continue;
                _orgUnit = this.getOrgUnit(child);
                rChildIds.add((String)_orgUnit.get("orgUnitId"));
            }
            in = node.getChildCount();
            for (i = 0; i < in; ++i) {
                child = (DefaultKingdeeTreeNode)node.getChildAt(i);
                _orgUnit = this.getOrgUnit(child);
                vChildIds.add((String)_orgUnit.get("orgUnitId"));
            }
            if (!rChildIds.containsAll(vChildIds)) {
                this.selectNode(node);
                throw new BgOrgUnitException(BgOrgUnitException.CHECKVIRTUALSTRUCTURE, new String[]{orgUnit.getString("name")});
            }
        }
    }

    public void checkVirtualNode(DefaultKingdeeTreeNode node, Map<String, DefaultKingdeeTreeNode> virNodeMap) throws Exception {
        FullOrgUnitInfo orgUnit;
        if (node == null || virNodeMap == null) {
            return;
        }
        if (this.checkVirtualOrg(node) && (orgUnit = this.getOrgUnit(node)) != null) {
            DefaultKingdeeTreeNode realNode = this.getCcOrgNodeMap().get(orgUnit.get("orgUnitId"));
            List<DefaultKingdeeTreeNode> parents = this.getAllParentNodes(realNode);
            FullOrgUnitInfo pOrgUnit = null;
            DefaultKingdeeTreeNode virNode = null;
            for (DefaultKingdeeTreeNode parent : parents) {
                pOrgUnit = this.getOrgUnit(parent);
                if (!virNodeMap.containsKey(pOrgUnit.get("orgUnitId")) || this.checkRelation((IObjectValue)orgUnit, (IObjectValue)this.getOrgUnit(virNode = virNodeMap.get(pOrgUnit.get("orgUnitId"))))) continue;
                this.selectNode(node);
                throw new BgOrgUnitException(BgOrgUnitException.CHECKVIRTUALSTRUCTURE, new String[]{orgUnit.getString("name")});
            }
        }
        DefaultKingdeeTreeNode child = null;
        int in = node.getChildCount();
        for (int i = 0; i < in; ++i) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.checkVirtualNode(child, virNodeMap);
        }
    }

    private boolean checkRelation(IObjectValue orgUnit, IObjectValue parent) {
        if (orgUnit == null || parent == null) {
            return true;
        }
        String longNumber = (String)orgUnit.get("longNumber");
        String pLongNumber = (String)parent.get("longNumber");
        return longNumber.startsWith(pLongNumber + "!");
    }

    public void addSelectNodesByStructCostCenter(DefaultKingdeeTreeNode bgParent, List<DefaultKingdeeTreeNode> ccOrgUnits, boolean checkSelected, StringBuilder errMsg) throws Exception {
        if (bgParent == null || ccOrgUnits == null || ccOrgUnits.isEmpty()) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode hisNode = null;
        DefaultKingdeeTreeNode bgNode = null;
        DefaultKingdeeTreeNode rootNode = this.getRootNode(bgParent);
        List<DefaultKingdeeTreeNode> childNodes = this.getAllNode(rootNode);
        HashMap<String, DefaultKingdeeTreeNode> orgIdToNodes = new HashMap<String, DefaultKingdeeTreeNode>();
        int in = childNodes.size();
        for (int i = 0; i < in; ++i) {
            DefaultKingdeeTreeNode tmpNode = childNodes.get(i);
            FullOrgUnitInfo orgUnit = this.getOrgUnit(tmpNode);
            if (orgUnit == null) continue;
            orgIdToNodes.put(orgUnit.getString("orgUnitId"), tmpNode);
        }
        Set orgIds = orgIdToNodes.keySet();
        int in2 = ccOrgUnits.size();
        for (int i = 0; i < in2; ++i) {
            node = ccOrgUnits.get(i);
            FullOrgUnitInfo unit = this.getOrgUnit(node);
            if (orgIds.contains(unit.getId().toString())) {
                DefaultKingdeeTreeNode csNodeParent = (DefaultKingdeeTreeNode)node.getParent();
                if (csNodeParent == null) continue;
                String csParentOrgId = this.getOrgUnit(csNodeParent).getId().toString();
                if (orgIdToNodes.containsKey(csParentOrgId)) {
                    DefaultKingdeeTreeNode targetBgNode = (DefaultKingdeeTreeNode)orgIdToNodes.get(unit.getId().toString());
                    DefaultKingdeeTreeNode bgNodeParent = (DefaultKingdeeTreeNode)targetBgNode.getParent();
                    if (bgNodeParent == null || this.getOrgUnit(bgNodeParent).get("orgUnitId").equals(csParentOrgId)) continue;
                    this.addSelectNodeByStruct((DefaultKingdeeTreeNode)orgIdToNodes.get(csParentOrgId), targetBgNode);
                    continue;
                }
                this.addErrMsg(errMsg, (IObjectValue)unit, "com.kingdee.eas.ma.mbg.BgOrgUnitReource", "parentNotExists");
                continue;
            }
            DefaultKingdeeTreeNode nodeParent = (DefaultKingdeeTreeNode)node.getParent();
            if (nodeParent == null) continue;
            String parentId = this.getOrgUnit(nodeParent).getId().toString();
            if (hisNode != null && this.checkIsParent(node, hisNode)) continue;
            if (orgIds.contains(parentId)) {
                bgNode = this.addSelectNode((DefaultKingdeeTreeNode)orgIdToNodes.get(parentId), node, checkSelected, errMsg, true, orgIdToNodes);
                if (bgNode == null) continue;
                hisNode = node;
                this.addNewNodeToNodesMap(bgNode, orgIdToNodes);
                continue;
            }
            this.addErrMsg(errMsg, (IObjectValue)unit, "com.kingdee.eas.ma.mbg.BgOrgUnitReource", "parentNotExists");
        }
    }

    private void addNewNodeToNodesMap(DefaultKingdeeTreeNode bgNode, Map<String, DefaultKingdeeTreeNode> orgIdToNodes) {
        if (bgNode == null || orgIdToNodes == null) {
            return;
        }
        FullOrgUnitInfo bgOrgUnit = this.getOrgUnit(bgNode);
        Set<String> orgIds = orgIdToNodes.keySet();
        if (!orgIds.contains(bgOrgUnit.get("orgUnitId"))) {
            orgIdToNodes.put(bgOrgUnit.getString("orgUnitId"), bgNode);
        }
    }

    private void addSelectNodeByStruct(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode changeNode) {
        if (parentNode == null || changeNode == null) {
            return;
        }
        FullOrgUnitInfo pBgOrgUnit = this.getOrgUnit(parentNode);
        FullOrgUnitInfo orgUnit = this.getOrgUnit(changeNode);
        ((DefaultTreeModel)this.getKdTree().getModel()).removeNodeFromParent((MutableTreeNode)changeNode);
        int in = 0;
        for (int i = parentNode.getChildCount() - 1; i >= in; --i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (!this.getOrgUnit(child).get("orgUnitId").equals(orgUnit.get("orgUnitId"))) continue;
            parentNode.remove(i);
        }
        ((DefaultTreeModel)this.getKdTree().getModel()).insertNodeInto((MutableTreeNode)changeNode, (MutableTreeNode)parentNode, parentNode.getChildCount());
        if (pBgOrgUnit != null) {
            orgUnit.setString("longNumber", pBgOrgUnit.getString("longNumber") + "!" + orgUnit.getString("number"));
            orgUnit.setInt("level", pBgOrgUnit.getInt("level") + 1);
            orgUnit.setString("parentId", pBgOrgUnit.getString(pBgOrgUnit.getPKField()));
        } else {
            orgUnit.setString("longNumber", orgUnit.getString("number"));
            orgUnit.setInt("level", 1);
            orgUnit.setString("parentId", null);
        }
        int in2 = changeNode.getChildCount();
        for (int i = 0; i < in2; ++i) {
            DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)changeNode.getChildAt(i);
            this.addSelectNodeByStruct(changeNode, _node);
        }
    }
}

