/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.orgunit;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.utils.orgunit.BgOrgUnitTreeUtils;
import com.kingdee.eas.ma.mbg.utils.orgunit.CsOrgUnitTreeUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class MbgOrgUnitHelper {
    public void copyFromCsTree(CsOrgUnitTreeUtils csOrgUnitUtils, BgOrgUnitTreeUtils bgOrgUnitUtils) throws Exception {
        if (csOrgUnitUtils == null || bgOrgUnitUtils == null) {
            return;
        }
        if (!bgOrgUnitUtils.getOrgNodeMap().isEmpty()) {
            return;
        }
        csOrgUnitUtils.selectAllOrgUnit();
        List<DefaultKingdeeTreeNode> orgUnits = csOrgUnitUtils.getSelectNodes();
        try {
            DefaultKingdeeTreeNode root = bgOrgUnitUtils.getRoot();
            bgOrgUnitUtils.addSelectNodes(root, orgUnits, true);
            if (bgOrgUnitUtils.getKdTree() != null) {
                bgOrgUnitUtils.getKdTree().setModel(bgOrgUnitUtils.getModel(root));
            }
        }
        catch (Exception ex) {
            csOrgUnitUtils.unSelectAllOrgUnit();
        }
    }

    private OrgUnitInfo toBgOrgUnit(FullOrgUnitInfo orgUnit, Map<String, String> toIdsMap) {
        if (orgUnit == null) {
            return null;
        }
        OrgUnitInfo bgOrgUnit = new OrgUnitInfo();
        bgOrgUnit.setString(bgOrgUnit.getPKField(), BOSUuid.create((String)"33F82845").toString());
        bgOrgUnit.setString("orgUnitId", orgUnit.getString(orgUnit.getPKField()));
        bgOrgUnit.setString("name", orgUnit.getString("name"));
        bgOrgUnit.setString("number", orgUnit.getString("number"));
        bgOrgUnit.setString("longNumber", orgUnit.getString("longNumber"));
        bgOrgUnit.setBoolean("isLeaf", orgUnit.getBoolean("isLeaf"));
        bgOrgUnit.setInt("isVirtual", 0);
        bgOrgUnit.setInt("isOUSealUp", 0);
        bgOrgUnit.setInt("level", orgUnit.getInt("level"));
        toIdsMap.put(bgOrgUnit.getString("orgUnitId"), bgOrgUnit.getString(bgOrgUnit.getPKField()));
        if (orgUnit.getString("parentId") != null) {
            bgOrgUnit.setString("parentId", toIdsMap.get(orgUnit.getString("parentId")));
        }
        return bgOrgUnit;
    }

    public static void sort(List<BgOrgUnitInfo> orgUnits, final String createOrgUnitId) {
        if (orgUnits == null || orgUnits.isEmpty()) {
            return;
        }
        Collections.sort(orgUnits, new Comparator<BgOrgUnitInfo>(){

            @Override
            public int compare(BgOrgUnitInfo o1, BgOrgUnitInfo o2) {
                if (o1.isIsVirtual() == o2.isIsVirtual()) {
                    if (o1.getOrgUnitID().equals(createOrgUnitId)) {
                        return -1;
                    }
                    if (o2.getOrgUnitID().equals(createOrgUnitId)) {
                        return 1;
                    }
                    return o1.getLongNumber().compareTo(o2.getLongNumber());
                }
                return o1.isIsVirtual() ? 1 : 0;
            }
        });
    }
}

