/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherFacadeFactory;
import com.kingdee.eas.ma.budget.IBgGatherFacade;
import com.kingdee.eas.ma.budget.client.BudgetUtilForClient;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordProcessUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.util.Map;

public class BgActualRecordProvider
extends IBookProvider {
    private BgNActualRecordProcessUI ui = null;

    private BgActualRecordProvider() {
    }

    public BgActualRecordProvider(Component obj) {
        this.ui = (BgNActualRecordProcessUI)obj;
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getBgActualRecordInfo() == null) {
            this.setEditValue(this.createNewReport());
        }
        if (this.getBgActualRecordInfo().getData() != null) {
            book = this.getBgActualRecordInfo().getBook();
        }
        if (book != null) {
            BudgetUtilForClient.prepareReportInfo4Display((ReportBaseInfo)this.getBgActualRecordInfo(), (Book)book);
        }
        return book;
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        Object obj = this.ui.getUIContext().get("IS_GATHER");
        if (obj != null && obj instanceof Boolean) {
            return this.gatherEditData(pk);
        }
        return super.queryEditData(pk);
    }

    protected IObjectValue gatherEditData(IObjectPK pk) throws Exception {
        Object obj = null;
        Map _gatherOrgUnitMap = null;
        Map _gatherBgSchemeIdMap = null;
        Map _gatherBgFormIdsMap = null;
        Map _patameterMap = null;
        obj = this.ui.getUIContext().get("GATHER_CHECK_ORGUNIT");
        if (obj != null && obj instanceof Map) {
            _gatherOrgUnitMap = obj;
        }
        if ((obj = this.ui.getUIContext().get("GATHER_CHECK_BGSCHEME_ID")) != null && obj instanceof Map) {
            _gatherBgSchemeIdMap = obj;
        }
        if ((obj = this.ui.getUIContext().get("GATHER_CHECK_BGFORM_ID")) != null && obj instanceof Map) {
            _gatherBgFormIdsMap = obj;
        }
        if ((obj = this.ui.getUIContext().get("GATHER_PARAMETER")) != null && obj instanceof Map) {
            _patameterMap = obj;
        }
        IObjectValue model = super.queryEditData(pk);
        if (_gatherOrgUnitMap != null && !_gatherOrgUnitMap.isEmpty() && _gatherBgSchemeIdMap != null && _patameterMap != null) {
            BgActualRecordInfo _info = (BgActualRecordInfo)model;
            BgFormInfo _bgFormInfo = new BgFormInfo();
            _bgFormInfo.setId(_info.getBgForm().getId());
            _bgFormInfo.setState(_info.getBgForm().getState());
            _bgFormInfo.setBgScheme(_info.getBgForm().getBgScheme());
            _bgFormInfo.setBgTemplate(_info.getBgForm().getBgTemplate());
            _bgFormInfo.setBgPeriod(_info.getBgForm().getBgPeriod());
            _bgFormInfo.setCurrency(_info.getBgForm().getCurrency());
            _bgFormInfo.setZipData(_info.getZipData());
            _bgFormInfo = this.getGatherInterface().getGatherValue(_bgFormInfo, _gatherOrgUnitMap, _gatherBgSchemeIdMap, _gatherBgFormIdsMap, _patameterMap);
            _info.setZipData(_bgFormInfo.getZipData());
            this.ui.getUIContext().remove("GATHER_CHECK_ORGUNIT");
            this.ui.getUIContext().remove("GATHER_CHECK_BGSCHEME_ID");
            this.ui.getUIContext().remove("GATHER_CHECK_BGFORM_ID");
            this.ui.getUIContext().remove("GATHER_PARAMETER");
        }
        return model;
    }

    public IObjectValue getEditValue() {
        return super.getEditValue();
    }

    public BgActualRecordInfo getBgActualRecordInfo() {
        return (BgActualRecordInfo)this.getEditValue();
    }

    public void restoreBook(Book book) throws Exception {
        if (ReportVariables.loadFromBook((Book)book) == null) {
            book.setUserObject("VARIABLES", (Object)new ReportVariables());
        }
        BudgetUtilForClient.prepareReportInfo4Save((ReportBaseInfo)this.getBgActualRecordInfo(), (Book)book);
        this.getBgActualRecordInfo().setBook(book);
    }

    public IObjectValue createNewReport() throws Exception {
        UIContext uiContext = new UIContext(this.ui.getUIContext().get("Owner"));
        uiContext.put((Object)"ORGUNIT_INFO", this.ui.getUIContext().get("ORGUNIT_INFO"));
        uiContext.put((Object)"ORGUNIT_CU", this.ui.getUIContext().get("ORGUNIT_CU"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgNActualRecordEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean hasSubmit = ((BgNActualRecordEditUI)uiWindow.getUIObject()).isHasSubmit();
        IObjectValue model = uiWindow.getUIObject().getDataObject();
        this.setEditValue(model);
        if (!hasSubmit || model == null || !(model instanceof BgActualRecordInfo)) {
            SysUtil.abort();
        }
        return model;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("data");
        sic.add("isEditByPeriod");
        sic.add("bgPeriod.*");
        sic.add("measureUnit.*");
        sic.add("bgForm.bgTemplate.bgFormType");
        sic.add("bgForm.id");
        sic.add("bgForm.state");
        sic.add("bgForm.measureUnit.id");
        sic.add("bgForm.measureUnit.id");
        sic.add("bgForm.measureUnit.name");
        sic.add("bgForm.measureUnit.number");
        sic.add("bgForm.measureUnit.coefficient");
        sic.add("bgForm.bgMeasureUnit.bgElement.id");
        sic.add("bgForm.bgMeasureUnit.bgElement.name");
        sic.add("bgForm.bgMeasureUnit.bgElement.number");
        sic.add("bgForm.bgMeasureUnit.measureUnit.id");
        sic.add("bgForm.bgMeasureUnit.measureUnit.name");
        sic.add("bgForm.bgMeasureUnit.measureUnit.number");
        sic.add("bgForm.bgMeasureUnit.measureUnit.coefficient");
        sic.add("bgForm.bgPeriod.id");
        sic.add("periodType");
        sic.add("bgForm.sheetParam.*");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.currency.name");
        sic.add("bgForm.currency.number");
        sic.add("bgForm.currency.precision");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.rootId");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.name");
        sic.add("bgForm.bgTemplate.number");
        sic.add("bgForm.bgTemplate.rootId");
        sic.add("bgForm.bgTemplate.formType");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.company.id");
        sic.add("bgForm.company.name");
        sic.add("bgForm.company.number");
        sic.add("bgForm.periodType");
        sic.add("bgForm.year");
        sic.add("bgForm.period");
        sic.add("bgForm.startDate");
        sic.add("bgForm.endDate");
        sic.add("bgForm.lastUpdateUser.id");
        sic.add("bgForm.lastUpdateUser.name");
        sic.add("bgForm.lastUpdateUser.number");
        sic.add("bgForm.name");
        sic.add("bgForm.sourceType");
        sic.add("bgForm.CU.id");
        sic.add("bgForm.creator.id");
        sic.add("bgForm.creator.number");
        sic.add("bgForm.creator.name");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.number");
        sic.add("bgForm.bgPeriod.periodType");
        sic.add("bgForm.bgPeriod.name");
        sic.add("lastUpdateUser.*");
        sic.add("lastUpdateTime");
        sic.add("company");
        sic.add("currency");
        sic.add("auditedStatus");
        sic.add("checkedStatus");
        sic.add("sourceType");
        return sic;
    }

    public ICoreBase getBizInterface() throws Exception {
        return BgActualRecordFactory.getRemoteInstance();
    }

    protected IBgGatherFacade getGatherInterface() throws Exception {
        return BgGatherFacadeFactory.getRemoteInstance();
    }

    public String getBizFactoryName() {
        return BgActualRecordFactory.class.getName();
    }
}

