/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrlSetHelper;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgCtrSettingFacade;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.view.app.BgViewServerHelper;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNAdjHelper {
    private static final Logger logger = Logger.getLogger(BgNAdjHelper.class);

    public static Map getTmpDataOfFormula(BgFormInfo bgFormInfo, Map adjustMap) throws BOSException {
        if (bgFormInfo == null || bgFormInfo.getZipData() == null) {
            return adjustMap;
        }
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        BgFormDiversityData divData = null;
        String formulaStr = null;
        BigDecimal value = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        try {
            _book = bgFormInfo.getBook();
            int _sheetSize = _book.getSheetCount();
            for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                _sheet = _book.getSheet(_sheetIndex);
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        if (!BgNFSHelper.checkCanEditFormulaOfCell(_cell) || adjustMap.containsKey(formulaStr)) continue;
                        value = BgNFSHelper.getBudgetValue(_cell);
                        divData = new BgFormDiversityData();
                        divData.setFormula(formulaStr);
                        divData.setNewValue(value);
                        divData.setOldValue(BgNConstants.ZERO);
                        adjustMap.put(formulaStr, divData);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        return adjustMap;
    }

    public static void createTmpDataOfFormulaForView(Context ctx, Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgTemplateId, BOSUuid bgAdjustId, Map adjustMap, Map members, BOSUuid bgFormId, Map bgDataMap) throws EASBizException, BOSException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String formulaString = null;
        HashMap<String, BgFormDiversityData> updateMap = new HashMap<String, BgFormDiversityData>();
        HashMap addMap = new HashMap();
        HashSet<String> delSet = new HashSet<String>();
        BgFormDiversityData bgFormDiversityData = null;
        String formulaStr = null;
        Iterator iterator = adjustMap.keySet().iterator();
        while (iterator.hasNext()) {
            formulaStr = (String)iterator.next();
            bgFormDiversityData = (BgFormDiversityData)adjustMap.get(formulaStr);
            if (!BgViewHelper.compareDivValue((BigDecimal)bgFormDiversityData.getNewValue(), (BigDecimal)bgFormDiversityData.getOldValue())) continue;
            delSet.add(formulaStr);
            iterator.remove();
        }
        try {
            if (adjustMap.size() > 0) {
                addMap.putAll(adjustMap);
                StringBuffer sql0 = new StringBuffer();
                Object[] paraArr = null;
                sql0.append("SELECT FID, FFormula from T_Bg_BgTmpData where FOrgUnitId = ? and FBgSchemeId = ? and FBgFormId = ? and FFormula in (");
                BgNSQLHelper.addPlaceHolder(sql0, 200).append(")");
                paraArr = adjustMap.keySet().toArray();
                pstmt = conn.prepareStatement(sql0.toString());
                int batchCount = (adjustMap.keySet().size() - 1) / 200 + 1;
                Object fid = null;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, orgUnitId.toString());
                    pstmt.setString(2, bgSchemeId.toString());
                    pstmt.setString(3, bgAdjustId.toString());
                    BgNSQLHelper.setParam4Batch(pstmt, 4, i, 200, paraArr);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        fid = rst.getString("FID");
                        formulaString = rst.getString("FFormula");
                        if (adjustMap.get(formulaString) == null) continue;
                        bgFormDiversityData = (BgFormDiversityData)adjustMap.get(formulaString);
                        updateMap.put(formulaString, bgFormDiversityData);
                        addMap.remove(formulaString);
                    }
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
            if (!addMap.isEmpty()) {
                BgNAdjHelper.insertTmpDataOfFormula(ctx, conn, orgUnitId, bgSchemeId, bgTemplateId, bgAdjustId, addMap);
            }
            if (!updateMap.isEmpty()) {
                BgNAdjHelper.updateTmpDataOfFormula(ctx, conn, orgUnitId, bgSchemeId, updateMap);
            }
            if (!delSet.isEmpty()) {
                BgNAdjHelper.delTmpDataOfFormula(conn, orgUnitId, bgSchemeId, delSet, bgAdjustId);
            }
            if (members != null && (members.get("add") != null || members.get("del") != null)) {
                List allDimensionInfo = (List)members.get("all");
                HashSet<String> addItemNum = new HashSet<String>();
                BgDimensionMember member = null;
                if (members.get("add") instanceof Set) {
                    for (Object o : (Set)members.get("add")) {
                        member = (BgDimensionMember)o;
                        addItemNum.add(member.getNumber());
                    }
                }
                HashSet<String> delItemNum = new HashSet<String>();
                if (members.get("del") instanceof Set) {
                    for (Object o : (Set)members.get("del")) {
                        member = (BgDimensionMember)o;
                        delItemNum.add(member.getNumber());
                    }
                }
                if (delItemNum.size() > 0) {
                    Set delFormulasInTmpData = BgViewServerHelper.queryExitFormulaByItem((Context)ctx, delItemNum, (boolean)false, (String)bgAdjustId.toString());
                    BgNSQLHelper.executeBatch(conn, "DELETE FROM T_BG_BGTMPDATA WHERE FID = ? ", new ArrayList(delFormulasInTmpData));
                }
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e1.getMessage()});
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
    }

    public static void createTmpDataOfFormula(Context ctx, Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgTemplateId, BOSUuid bgFormId, Map adjustMap) throws BOSException, EASBizException {
        if (ctx == null || conn == null || orgUnitId == null || bgSchemeId == null || bgFormId == null) {
            return;
        }
        if (adjustMap == null || adjustMap.isEmpty()) {
            return;
        }
        HashMap formulaMap = new HashMap();
        String formulaString = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, BgFormDiversityData> updateMap = new HashMap<String, BgFormDiversityData>();
        HashMap addMap = new HashMap();
        HashSet<String> delSet = new HashSet<String>();
        HashSet<String> rangSet = new HashSet<String>();
        addMap.putAll(adjustMap);
        try {
            String sql = "SELECT FFORMULA FROM T_BG_BGDATA WHERE FBGFORMID = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                formulaString = rst.getString("FFormula");
                if (rangSet.contains(formulaString)) continue;
                rangSet.add(formulaString);
            }
            rangSet.addAll(adjustMap.keySet());
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            StringBuffer sql0 = new StringBuffer();
            Object[] paraArr = null;
            sql0.append("SELECT FID, FFormula from T_Bg_BgTmpData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
            BgNSQLHelper.addPlaceHolder(sql0, 200).append(")");
            paraArr = rangSet.toArray();
            pstmt = conn.prepareStatement(sql0.toString());
            int batchCount = (paraArr.length - 1) / 200 + 1;
            String fid = null;
            BgFormDiversityData bgFormDiversityData = null;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, orgUnitId.toString());
                pstmt.setString(2, bgSchemeId.toString());
                BgNSQLHelper.setParam4Batch(pstmt, 3, i, 200, paraArr);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    fid = rst.getString("FID");
                    formulaString = rst.getString("FFormula");
                    if (adjustMap.get(formulaString) != null) {
                        bgFormDiversityData = (BgFormDiversityData)adjustMap.get(formulaString);
                        updateMap.put(formulaString, bgFormDiversityData);
                        addMap.remove(formulaString);
                        continue;
                    }
                    delSet.add(formulaString);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        try {
            if (!addMap.isEmpty()) {
                BgNAdjHelper.insertTmpDataOfFormula(ctx, conn, orgUnitId, bgSchemeId, bgTemplateId, bgFormId, addMap);
            }
            if (!updateMap.isEmpty()) {
                BgNAdjHelper.updateTmpDataOfFormula(ctx, conn, orgUnitId, bgSchemeId, updateMap);
            }
            if (!delSet.isEmpty()) {
                BgNAdjHelper.delTmpDataOfFormula(conn, orgUnitId, bgSchemeId, delSet, bgFormId);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static void delTmpDataOfFormula(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, Set delFormulaSet, BOSUuid bgAdjustId) throws EASBizException {
        if (conn == null || orgUnitId == null || bgSchemeId == null) {
            return;
        }
        if (delFormulaSet == null || delFormulaSet.isEmpty()) {
            return;
        }
        Object formulaString = null;
        String fid = null;
        Object divData = null;
        HashSet<String> fidSet = new HashSet<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer tmpSql = new StringBuffer();
        StringBuffer selSql = new StringBuffer();
        selSql.append("SELECT FId FROM T_BG_BgTmpData WHERE FOrgUnitId = ? and FBgSchemeId = ? and FBgFormId = ? and FFormula in(");
        tmpSql.append("delete from T_BG_BgTmpData where Fid = ?");
        try {
            BgNSQLHelper.addPlaceHolder(selSql, 200).append(")");
            pstmt = conn.prepareStatement(selSql.toString());
            int batchCount = (delFormulaSet.size() - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, orgUnitId.toString());
                pstmt.setString(2, bgSchemeId.toString());
                pstmt.setString(3, bgAdjustId.toString());
                BgNSQLHelper.setParam4Batch(pstmt, 4, i, 200, delFormulaSet.toArray());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    fid = rst.getString("FID");
                    fidSet.add(fid);
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            BgNSQLHelper.executeBatch(conn, tmpSql.toString(), new ArrayList(fidSet));
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insertTmpDataOfFormula(Context ctx, Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgTemplateId, BOSUuid bgAdjustId, Map addMap) throws EASBizException, BOSException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        HashSet<String> bgElementSet = new HashSet<String>();
        Map bgElementMap = null;
        HashSet<String> bgPeriodSet = new HashSet<String>();
        Map bgPeriodMap = null;
        HashSet<String> currencySet = new HashSet<String>();
        Map currencyMap = null;
        HashMap formulaMap = new HashMap();
        String[] parameter = null;
        String formulaString2222222 = null;
        for (String formulaString2222222 : addMap.keySet()) {
            parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaString2222222);
            if (parameter == null) continue;
            if (parameter[2] != null) {
                bgElementSet.add(parameter[2]);
            }
            if (parameter[1] != null) {
                bgPeriodSet.add(parameter[1]);
            }
            if (parameter[5] == null) continue;
            currencySet.add(parameter[5]);
        }
        PreparedStatement pstmt = null;
        try {
            bgElementMap = BgInfoHelper.getBgElementMap(ctx, conn, bgElementSet);
            bgPeriodMap = BgInfoHelper.getBgPeriodMap(ctx, conn, bgPeriodSet);
            currencyMap = BgInfoHelper.getCurrencyMap(ctx, conn, currencySet);
            Map formulaCtrl = null;
            Object formula = null;
            boolean isControl = false;
            boolean isFlexible = false;
            BigDecimal flexParam = null;
            int ctrlType = -1;
            boolean isGroupCtrl = false;
            String groupNo = null;
            boolean isCtrlAllowChange = false;
            boolean isFromSuper = false;
            boolean isAllowAccess = false;
            BgAdjustFormDiversityData bgFormDiversityData = null;
            IBgCtrSettingFacade ibgCtrSettingFacade = BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx);
            Map ctrlModeMap = ibgCtrSettingFacade.getBgFormCtrlModeMap(bgAdjustId);
            Map itemAndElementCtrl = (Map)ibgCtrSettingFacade.getTemplateCtrlSetting(bgTemplateId, null).get("ctrlModeMap");
            Hashtable defCtrlMode = ibgCtrSettingFacade.getDefCtrlSetByTemplateID(bgTemplateId.toString());
            StringBuffer create = new StringBuffer();
            create.append("Insert Into T_BG_BgTmpData (FID, FBgValue, FBizActual, FBgBalance, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgFormId, FFormula, FBgItemCombinId, FBgElementId, FBgPeriodId, FCurrencyId, FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo, FIsCtrlAllowChange, FIsFromSuper, FIsAllowAccess,FCtrlModeFrom,FAdjustorId, FAdjustTime, FAdjustReason) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?,?,?,?,?,?,?,?,?,?,?,?,?)");
            pstmt = conn.prepareStatement(create.toString());
            BgDataInfo bgData = new BgDataInfo();
            String itemAndElement = null;
            int batchIndex = 0;
            int batchSize = 200;
            for (String formulaString2222222 : addMap.keySet()) {
                block60: {
                    block63: {
                        if (addMap.get(formulaString2222222) instanceof BgAdjustFormDiversityData) {
                            bgFormDiversityData = (BgAdjustFormDiversityData)addMap.get(formulaString2222222);
                        } else if (addMap.get(formulaString2222222) instanceof BgFormDiversityData) {
                            bgFormDiversityData = (BgFormDiversityData)addMap.get(formulaString2222222);
                        }
                        formulaCtrl = (Map)ctrlModeMap.get(formulaString2222222);
                        pstmt.setString(1, BOSUuid.create((BOSObjectType)bgData.getBOSType()).toString());
                        if (bgFormDiversityData == null) continue;
                        if (bgFormDiversityData.getNewValue() != null) {
                            pstmt.setBigDecimal(2, bgFormDiversityData.getNewValue().setScale(8, 4));
                        } else {
                            pstmt.setBigDecimal(2, BgNConstants.ZERO);
                            bgFormDiversityData.setNewValue(BgNConstants.ZERO);
                        }
                        if (bgFormDiversityData.getOldValue() != null) {
                            pstmt.setBigDecimal(3, bgFormDiversityData.getOldValue().setScale(8, 4));
                        } else {
                            pstmt.setBigDecimal(3, BgNConstants.ZERO);
                            bgFormDiversityData.setOldValue(BgNConstants.ZERO);
                        }
                        pstmt.setBigDecimal(4, bgFormDiversityData.getNewValue().subtract(bgFormDiversityData.getOldValue()));
                        pstmt.setString(5, orgUnitId.toString());
                        pstmt.setString(6, bgSchemeId.toString());
                        pstmt.setString(7, bgTemplateId.toString());
                        pstmt.setString(8, bgAdjustId.toString());
                        pstmt.setString(9, formulaString2222222);
                        pstmt.setString(10, null);
                        if (!formulaMap.containsKey(formulaString2222222)) break block63;
                        parameter = (String[])formulaMap.get(formulaString2222222);
                        itemAndElement = parameter[0] + "_" + parameter[2];
                        if (parameter[2] != null) {
                            if (bgElementMap.containsKey(parameter[2])) {
                                pstmt.setString(11, ((BgElementInfo)bgElementMap.get(parameter[2])).getId().toString());
                            } else {
                                pstmt.setString(11, null);
                            }
                        } else {
                            pstmt.setString(11, null);
                        }
                        if (parameter[1] != null) {
                            if (bgPeriodMap.containsKey(parameter[1])) {
                                pstmt.setString(12, ((BgPeriodInfo)bgPeriodMap.get(parameter[1])).getId().toString());
                            } else {
                                pstmt.setString(12, null);
                            }
                        } else {
                            pstmt.setString(12, null);
                        }
                        if (parameter[5] != null) {
                            if (currencyMap.containsKey(parameter[5])) {
                                pstmt.setString(13, ((CurrencyInfo)currencyMap.get(parameter[5])).getId().toString());
                                break block60;
                            } else {
                                pstmt.setString(13, null);
                            }
                            break block60;
                        } else {
                            pstmt.setString(13, null);
                        }
                        break block60;
                    }
                    pstmt.setString(11, null);
                    pstmt.setString(12, null);
                    pstmt.setString(13, null);
                }
                if (formulaCtrl != null && !formulaCtrl.isEmpty()) {
                    isControl = formulaCtrl.get("isCtrl") == null ? false : (Boolean)formulaCtrl.get("isCtrl");
                    isFlexible = formulaCtrl.get("isFlexCtrl") == null ? false : (Boolean)formulaCtrl.get("isFlexCtrl");
                    flexParam = formulaCtrl.get("flexCtrlParam") == null ? new BigDecimal("1") : (BigDecimal)formulaCtrl.get("flexCtrlParam");
                    ctrlType = formulaCtrl.get("periodCtrlPolicy") == null ? -1 : (Integer)formulaCtrl.get("periodCtrlPolicy");
                    isGroupCtrl = formulaCtrl.get("isGroupCtrl") == null ? false : (Boolean)formulaCtrl.get("isGroupCtrl");
                    groupNo = BgCtrlSetHelper.getStrGroupNo(formulaCtrl.get("groupCtrlNo"), (String)bgTemplateId.toString());
                    if (itemAndElementCtrl != null && itemAndElementCtrl.containsKey(itemAndElement)) {
                        isCtrlAllowChange = false;
                        isFromSuper = true;
                    } else {
                        isCtrlAllowChange = formulaCtrl.get("isCtrlAllowChange") == null ? true : (Boolean)formulaCtrl.get("isCtrlAllowChange");
                        isFromSuper = formulaCtrl.get("isFromSuper") == null ? false : (Boolean)formulaCtrl.get("isFromSuper");
                    }
                    isAllowAccess = formulaCtrl.get("isAllowAccess") == null ? false : (Boolean)formulaCtrl.get("isAllowAccess");
                    pstmt.setBoolean(14, isControl);
                    pstmt.setBoolean(15, isFlexible);
                    pstmt.setBigDecimal(16, flexParam);
                    pstmt.setInt(17, ctrlType);
                    pstmt.setBoolean(18, isGroupCtrl);
                    pstmt.setString(19, groupNo);
                    pstmt.setBoolean(20, isCtrlAllowChange);
                    pstmt.setBoolean(21, isFromSuper);
                    pstmt.setBoolean(22, isAllowAccess);
                    if (formulaCtrl.get("ctrlModeFrom") instanceof Integer) {
                        pstmt.setInt(23, (Integer)formulaCtrl.get("ctrlModeFrom"));
                    } else {
                        pstmt.setInt(23, 1);
                    }
                } else {
                    if (defCtrlMode != null && !defCtrlMode.isEmpty()) {
                        Object obj = null;
                        obj = defCtrlMode.get("isCtrl");
                        if (obj instanceof Boolean) {
                            pstmt.setBoolean(14, (Boolean)obj);
                        } else {
                            pstmt.setBoolean(14, false);
                        }
                        obj = defCtrlMode.get("isFlexCtrl");
                        if (obj instanceof Boolean) {
                            pstmt.setBoolean(15, (Boolean)obj);
                        } else {
                            pstmt.setBoolean(15, false);
                        }
                        obj = defCtrlMode.get("flexCtrlParam");
                        if (obj instanceof BigDecimal) {
                            pstmt.setBigDecimal(16, obj);
                        } else {
                            pstmt.setBigDecimal(16, new BigDecimal("1"));
                        }
                        obj = defCtrlMode.get("periodCtrlPolicy");
                        if (obj instanceof Integer) {
                            pstmt.setInt(17, (Integer)obj);
                        } else {
                            pstmt.setInt(17, -1);
                        }
                        obj = defCtrlMode.get("isGroupCtrl");
                        if (obj instanceof Boolean) {
                            pstmt.setBoolean(18, (Boolean)obj);
                        } else {
                            pstmt.setBoolean(18, false);
                        }
                        obj = defCtrlMode.get("groupCtrlNo");
                        if (obj instanceof Integer) {
                            pstmt.setString(19, BgCtrlSetHelper.getStrGroupNo(obj, (String)bgTemplateId.toString()));
                        } else {
                            pstmt.setString(19, "-1");
                        }
                        if (itemAndElementCtrl.containsKey(itemAndElement)) {
                            pstmt.setBoolean(20, false);
                            pstmt.setBoolean(21, true);
                        } else {
                            pstmt.setBoolean(20, true);
                            pstmt.setBoolean(21, false);
                        }
                        obj = defCtrlMode.get("isAllowAccess");
                        if (obj instanceof BigDecimal) {
                            pstmt.setBoolean(22, (Boolean)obj);
                        } else {
                            pstmt.setBoolean(22, isAllowAccess);
                        }
                    } else {
                        pstmt.setBoolean(14, false);
                        pstmt.setBoolean(15, false);
                        pstmt.setBigDecimal(16, new BigDecimal("1"));
                        pstmt.setInt(17, -1);
                        pstmt.setBoolean(18, false);
                        pstmt.setString(19, "-1");
                        if (itemAndElementCtrl.containsKey(itemAndElement)) {
                            pstmt.setBoolean(20, false);
                            pstmt.setBoolean(21, true);
                        } else {
                            pstmt.setBoolean(20, true);
                            pstmt.setBoolean(21, false);
                        }
                        pstmt.setBoolean(22, isAllowAccess);
                    }
                    pstmt.setInt(23, -1);
                }
                pstmt.setString(24, bgFormDiversityData.getAdjustor());
                pstmt.setTimestamp(25, bgFormDiversityData.getAdjustTime() != null ? new Timestamp(bgFormDiversityData.getAdjustTime().getTime()) : now);
                if (addMap.get(formulaString2222222) instanceof BgAdjustFormDiversityData) {
                    pstmt.setString(26, bgFormDiversityData.getAdjustReson());
                } else {
                    pstmt.setString(26, "");
                }
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e1) {
            try {
                logger.error((Object)e1);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e1.getMessage()});
                catch (EASBizException ex) {
                    logger.error((Object)ex);
                    throw ex;
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static void updateTmpDataOfFormula(Context ctx, Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, Map updateMap) throws EASBizException {
        if (conn == null || orgUnitId == null || bgSchemeId == null) {
            return;
        }
        if (updateMap == null || updateMap.isEmpty()) {
            return;
        }
        String formulaString2 = null;
        Object divData = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgTmpData set FBgValue = ?, FBizActual = ?, FBgBalance = ? , FAdjustorId = ?, FAdjustTime = ?, FAdjustReason = ?  where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (String formulaString2 : updateMap.keySet()) {
                Object obj = updateMap.get(formulaString2);
                divData = obj instanceof BgAdjustFormDiversityData ? (BgAdjustFormDiversityData)obj : (BgFormDiversityData)obj;
                if (divData.getNewValue() != null) {
                    pstmt.setBigDecimal(1, divData.getNewValue().setScale(8, 4));
                } else {
                    pstmt.setBigDecimal(1, BgNConstants.ZERO);
                }
                if (divData.getOldValue() != null) {
                    pstmt.setBigDecimal(2, divData.getOldValue().setScale(8, 4));
                } else {
                    pstmt.setBigDecimal(2, BgNConstants.ZERO);
                    divData.setOldValue(BgNConstants.ZERO);
                }
                pstmt.setBigDecimal(3, divData.getNewValue().subtract(divData.getOldValue()).setScale(8, 4));
                if (divData.getAdjustor() != null) {
                    pstmt.setString(4, divData.getAdjustor());
                } else {
                    pstmt.setString(4, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                }
                if (divData.getAdjustTime() != null) {
                    pstmt.setTimestamp(5, new Timestamp(divData.getAdjustTime().getTime()));
                } else {
                    pstmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                }
                if (divData instanceof BgAdjustFormDiversityData) {
                    if (divData.getAdjustReson() != null) {
                        pstmt.setString(6, divData.getAdjustReson());
                    } else {
                        pstmt.setString(6, "#");
                    }
                } else {
                    pstmt.setString(6, "#");
                }
                pstmt.setString(7, orgUnitId.toString());
                pstmt.setString(8, bgSchemeId.toString());
                pstmt.setString(9, formulaString2);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }
}

