/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNLockProtectHelper {
    private static Logger logger = Logger.getLogger((String)BgNLockProtectHelper.class.getName());

    public static void setCellLockedAndProtectionOnlyCell(Cell cell, boolean locked, boolean isCanUndo) {
        ArrayList<Integer> notAllowOperation = new ArrayList<Integer>();
        notAllowOperation.add(Integer.valueOf("65536"));
        notAllowOperation.add(Integer.valueOf("8192"));
        notAllowOperation.add(Integer.valueOf("1024"));
        BgNLockProtectHelper.setCellLockedAndProtection(cell, locked, notAllowOperation, isCanUndo);
    }

    public static void setCellLockedAndProtection(Cell cell, boolean locked, List notAllowOperation, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        Protection pro = cell.getSheet().getSheetOption().getProtection(true);
        if (locked) {
            BgNLockProtectHelper.initSheeProtected(pro, notAllowOperation, false);
            if (!pro.isProtected()) {
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        if (locked) {
            BgNTemplateHelper.setCellCtrlValue(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE, isCanUndo);
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(locked);
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
        if (!locked) {
            BgNTemplateHelper.removeCellCtrlValue(cell, "CELL_LOCK", isCanUndo);
        }
    }

    public static void setCellLocked(Cell cell, boolean locked, boolean isCanUndo) {
        if (locked) {
            BgNTemplateHelper.setCellCtrlValue(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE, isCanUndo);
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(locked);
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
        if (!locked) {
            BgNTemplateHelper.removeCellCtrlValue(cell, "CELL_LOCK", isCanUndo);
        }
    }

    public static void setCellLockedAndProtectionFromSuper(Cell cell, boolean locked, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (locked) {
            BgNTemplateHelper.setCellCtrlValue(cell, "CELL_LOCK_SUPER", BgNConstants.TRUE_UPDATE, isCanUndo);
        } else {
            BgNTemplateHelper.removeCellCtrlValue(cell, "CELL_LOCK_SUPER", isCanUndo);
        }
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setCellLocked(locked);
    }

    private static Protection initSheeProtected(Protection pro, List notAllowOperation, boolean isProExit) {
        if (notAllowOperation != null) {
            if (!isProExit) {
                pro.appendOperation(2048);
                pro.appendOperation(256);
                pro.appendOperation(512);
                pro.appendOperation(65536);
                pro.appendOperation(8192);
                pro.appendOperation(16384);
                pro.appendOperation(4);
                pro.appendOperation(32);
                pro.appendOperation(128);
                pro.appendOperation(64);
                pro.appendOperation(16);
                pro.appendOperation(1);
                pro.appendOperation(2);
                pro.appendOperation(8);
                pro.appendOperation(16);
                pro.appendOperation(1024);
                pro.appendOperation(4096);
            }
            int size = notAllowOperation.size();
            for (int i = 0; i < size; ++i) {
                pro.deleteOperation(((Integer)notAllowOperation.get(i)).intValue());
            }
        } else {
            pro.deleteOperations();
            pro.appendOperation(1);
            pro.appendOperation(2);
        }
        return pro;
    }

    public static boolean isCellLockedAndProtectionFromSupser(Cell cell) {
        if (cell == null) {
            return false;
        }
        if (!BgNLockProtectHelper.isCellLocked(cell)) {
            return false;
        }
        return BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK_SUPER") != null && BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK_SUPER").equals(BgNConstants.TRUE_UPDATE);
    }

    public static boolean isCellLockedAndProtection11(Cell cell) {
        if (cell == null) {
            return false;
        }
        return BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK") != null && BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK").equals(BgNConstants.TRUE_UPDATE);
    }

    public static void setBookLockedAndProtection(Book book, boolean locked, List notAllowBookOperation, List notAllowSheetOperation) {
        if (book == null) {
            return;
        }
        SimpleTimer tim = new SimpleTimer();
        logger.info((Object)"begin setBookLockedAndProtection -----");
        BgNLockProtectHelper.setBookProtection(book, locked, notAllowBookOperation);
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            BgNLockProtectHelper.setSheetLockedAndProtection(book.getSheet(i), locked, notAllowSheetOperation);
        }
        logger.info((Object)("end setBookLockedAndProtection -----" + tim.getTime()));
    }

    public static void setSheetLockedAndProtection(Sheet sheet, boolean locked, List notAllowOperation) {
        Range range = sheet.getSheetRange();
        range.setIgnoreProtected(true);
        range.setCellLocked(true);
        BgNLockProtectHelper.setSheetProtection(sheet, locked, notAllowOperation);
    }

    public static void setSheetLockedAndProtectionAllCe(Sheet sheet, boolean locked, List notAllowOperation) {
        Range range = null;
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        int maxColIndex = sheet.getMaxColIndex() + 1;
        Row row = null;
        Cell cell = null;
        for (int i = 0; i < maxRowIndex; ++i) {
            row = sheet.getRow(i, false);
            if (row == null) continue;
            for (int j = 0; j < maxColIndex; ++j) {
                cell = row.getCell(j, false);
                if (cell == null || cell.getValue() == null || StringUtils.isEmpty((String)cell.getValue().toString())) continue;
                range = sheet.getRange(cell);
                range.setIgnoreProtected(true);
                range.setCellLocked(true);
            }
        }
        BgNLockProtectHelper.setSheetProtection(sheet, locked, notAllowOperation);
    }

    public static boolean isBookLockedAndProtection(Book book) {
        return book != null && book.getUserObjectValue("BOOK_LOCK") != null && book.getUserObjectValue("BOOK_LOCK").equals(BgNConstants.TRUE_UPDATE);
    }

    public static boolean isSheetLockedAndProtection(Sheet sheet) {
        return sheet != null && sheet.getUserObjectValue("BOOK_LOCK") != null && sheet.getUserObjectValue("BOOK_LOCK").equals(BgNConstants.TRUE_UPDATE);
    }

    public static void setChildTemplateBookProAndSheetPro(Book book, boolean isLock) {
        ArrayList<Integer> notAllowOperation = new ArrayList<Integer>();
        notAllowOperation.add(Integer.valueOf("65536"));
        notAllowOperation.add(Integer.valueOf("8192"));
        notAllowOperation.add(Integer.valueOf("1024"));
        int bookCount = book.getSheetCount();
        for (int i = 0; i < bookCount; ++i) {
            BgNLockProtectHelper.setSheetProtection(book.getSheet(i), isLock, notAllowOperation);
        }
        BgNLockProtectHelper.setBookProtection(book, true, null);
    }

    public static Map clearChildTemplateBookProAndSheetPro(Book book) {
        if (book == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, HashMap<String, Object>> mapPro = new HashMap<String, HashMap<String, Object>>();
        BookProtection pro = book.getProtection();
        if (pro != null && pro.isProtected()) {
            if (!pro.allowOperatorStruct()) {
                map.put("1", null);
            }
            if (!pro.allowOperatorWindow()) {
                map.put("2", null);
            }
            pro.appendOperation(2);
            pro.appendOperation(1);
            mapPro.put("BOOK_PROTECT_TAG", map);
        }
        Sheet sheet = null;
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            sheet = book.getSheet(i);
            Protection proSheet = sheet.getSheetOption().getProtection(false);
            if (proSheet == null) {
                mapPro.put(sheet.getID(), null);
                continue;
            }
            map = new HashMap();
            if (!proSheet.allowDeletingColumns()) {
                map.put("256", null);
            }
            if (!proSheet.allowDeletingRows()) {
                map.put("512", null);
            }
            if (!proSheet.allowEditObjects()) {
                map.put("8192", null);
            }
            if (!proSheet.allowEditScenarios()) {
                map.put("16384", null);
            }
            if (!proSheet.allowFiltering()) {
                map.put("2048", null);
            }
            if (!proSheet.allowFormattingCells()) {
                map.put("4", null);
            }
            if (!proSheet.allowFormattingColumns()) {
                map.put("8", null);
            }
            if (!proSheet.allowFormattingRows()) {
                map.put("16", null);
            }
            if (!proSheet.allowInsertingColumns()) {
                map.put("32", null);
            }
            if (!proSheet.allowInsertingRows()) {
                map.put("64", null);
            }
            if (!proSheet.allowInsertingHyperlinks()) {
                map.put("128", null);
            }
            if (!proSheet.allowSelectLocked()) {
                map.put("1", null);
            }
            if (!proSheet.allowSelectUnLocked()) {
                map.put("2", null);
            }
            if (!proSheet.allowSorting()) {
                map.put("1024", null);
            }
            if (!proSheet.allowUsingPivotTables()) {
                map.put("4096", null);
            }
            proSheet.appendOperation(2048);
            proSheet.appendOperation(256);
            proSheet.appendOperation(512);
            proSheet.appendOperation(65536);
            proSheet.appendOperation(8192);
            proSheet.appendOperation(16384);
            proSheet.appendOperation(4);
            proSheet.appendOperation(32);
            proSheet.appendOperation(128);
            proSheet.appendOperation(64);
            proSheet.appendOperation(16);
            proSheet.appendOperation(1);
            proSheet.appendOperation(2);
            proSheet.appendOperation(8);
            proSheet.appendOperation(16);
            proSheet.appendOperation(1024);
            proSheet.appendOperation(4096);
            proSheet.appendOperation(32768);
            mapPro.put(sheet.getID(), map);
        }
        return mapPro;
    }

    public static void reDoChildTemplateBookProAndSheetPro(Book book, Map mapPro, boolean isEnumerateForm) {
        if (book == null) {
            return;
        }
        if (mapPro == null || mapPro.isEmpty()) {
            return;
        }
        Map map = (Map)mapPro.get("BOOK_PROTECT_TAG");
        BookProtection pro = book.getProtection();
        if (pro != null && map != null && !map.isEmpty()) {
            if (!pro.isProtected()) {
                pro.start();
            }
            pro.appendOperation(2);
            pro.appendOperation(1);
            Integer proValue = null;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                proValue = Integer.valueOf(iter.next() + "");
                if (proValue == null) continue;
                pro.deleteOperation(proValue.intValue());
            }
        }
        Sheet sheet = null;
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            sheet = book.getSheet(i);
            if (sheet == null) continue;
            map = (Map)mapPro.get(sheet.getID());
            Protection proSheet = sheet.getSheetOption().getProtection(true);
            if (proSheet == null || map == null || map.isEmpty()) continue;
            if (!proSheet.isProtected()) {
                proSheet.start();
            }
            if (!isEnumerateForm) {
                proSheet.appendOperation(256);
                proSheet.appendOperation(32);
            }
            proSheet.appendOperation(2048);
            proSheet.appendOperation(512);
            proSheet.appendOperation(65536);
            proSheet.appendOperation(8192);
            proSheet.appendOperation(16384);
            proSheet.appendOperation(4);
            proSheet.appendOperation(128);
            proSheet.appendOperation(64);
            proSheet.appendOperation(16);
            proSheet.appendOperation(1);
            proSheet.appendOperation(2);
            proSheet.appendOperation(8);
            proSheet.appendOperation(16);
            proSheet.appendOperation(1024);
            proSheet.appendOperation(4096);
            proSheet.appendOperation(32768);
            Integer proValue = null;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                proValue = Integer.valueOf(iter.next() + "");
                if (proValue == null) continue;
                proSheet.deleteOperation(proValue.intValue());
            }
        }
    }

    public static void reCombinProMap(Map mapPro1, Map mapPro2) {
        if (mapPro1 == null || mapPro1.isEmpty() || mapPro2 == null) {
            return;
        }
        Map map1 = null;
        HashMap map2 = null;
        Object key22 = null;
        for (Object key22 : mapPro1.keySet()) {
            if (!mapPro2.containsKey(key22)) {
                mapPro2.put(key22, mapPro1.get(key22));
                continue;
            }
            map1 = (Map)mapPro1.get(key22);
            map2 = (HashMap)mapPro2.get(key22);
            if (map1 == null || map1.isEmpty()) continue;
            if (map2 == null) {
                map2 = new HashMap();
                mapPro2.put(key22, map2);
            }
            for (Object key22 : map1.keySet()) {
                if (map2.containsKey(key22)) continue;
                map2.put(key22, null);
            }
        }
    }

    public static void setSheetProtection(Sheet sheet, boolean locked, List notAllowOperation) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        if (locked) {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                BgNLockProtectHelper.initSheeProtected(pro, notAllowOperation, true);
            } else {
                BgNLockProtectHelper.initSheeProtected(pro, notAllowOperation, false);
            }
            pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setBookProtection(Book book, boolean locked, List notAllowOperation) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (locked) {
            if (pro.isProtected()) {
                BgNLockProtectHelper.initBookProtected(pro, notAllowOperation, true);
            } else {
                BgNLockProtectHelper.initBookProtected(pro, notAllowOperation, false);
            }
            pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            book.setUserObject("BOOK_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("BOOK_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        }
    }

    private static BookProtection initBookProtected(BookProtection pro, List allowOperation, boolean proIsExit) {
        if (allowOperation != null) {
            if (!proIsExit) {
                pro.appendOperation(1);
                pro.appendOperation(2);
            }
            int size = allowOperation.size();
            for (int i = 0; i < size; ++i) {
                int notAllow = (Integer)allowOperation.get(i);
                pro.deleteOperation(notAllow);
            }
        } else {
            pro.allowOperatorStruct();
            pro.deleteOperations();
        }
        return pro;
    }

    public static boolean isCellLocked(Cell cell) {
        if (cell == null) {
            return false;
        }
        return cell.isLocked();
    }
}

