/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.nbudget.IResultReader;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNSQLHelper {
    private static Logger logger = Logger.getLogger(BgNSQLHelper.class);
    public static final int BATCH_COUNT = 200;
    public static final String NO_FOUND = "#";
    public static final Map bgTypeRefTables;

    public static StringBuffer addPlaceHolder(StringBuffer sql, int count) {
        if (sql == null) {
            return null;
        }
        for (int i = 0; i < count - 1; ++i) {
            sql.append("?,");
        }
        sql.append("?");
        return sql;
    }

    public static StringBuffer addPlaceHolder(StringBuffer sql) {
        return BgNSQLHelper.addPlaceHolder(sql, 200);
    }

    public static void setParam4Batch(PreparedStatement pmt, int pStartIndex, int batchIndex, int batchCount, Object[] params) throws SQLException {
        if (pmt == null || pStartIndex < 1 || batchIndex < 0 || batchCount <= 0 || params == null || params.length == 0) {
            throw new SQLException("param error!");
        }
        int length = params.length;
        int start = batchIndex * batchCount;
        if (length <= start) {
            throw new SQLException("param error!");
        }
        for (int i = 0; i < batchCount; ++i) {
            if (i + start >= length) {
                pmt.setObject(i + pStartIndex, NO_FOUND);
                continue;
            }
            pmt.setObject(i + pStartIndex, params[i + start]);
        }
    }

    public static void setParam4BatchDefCount(PreparedStatement pmt, int pStartIndex, int batchIndex, Object[] params) throws SQLException {
        BgNSQLHelper.setParam4Batch(pmt, pStartIndex, batchIndex, 200, params);
    }

    public static void setParam4Batch(PreparedStatement pmt, int batchIndex, int batchCount, Object[] params) throws SQLException {
        BgNSQLHelper.setParam4Batch(pmt, 1, batchIndex, batchCount, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatch(Connection conn, String sql, List paramList) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || paramList == null || paramList.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int index = 0;
            for (int i = 0; i < paramList.size(); ++i) {
                if (paramList.get(i) instanceof Object[]) {
                    Object[] params = (Object[])paramList.get(i);
                    for (int p = 0; p < params.length; ++p) {
                        pstmt.setObject(p + 1, params[p]);
                    }
                } else {
                    pstmt.setObject(1, paramList.get(i));
                }
                pstmt.addBatch();
                if (++index <= 200) continue;
                pstmt.executeBatch();
                pstmt.clearBatch();
                index = 0;
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static int getBatchCount(Object[] params) {
        return BgNSQLHelper.getBatchCount(params, 200);
    }

    public static int getBatchCount(Object[] params, int batch) {
        if (params == null) {
            return 0;
        }
        return BgNSQLHelper.getBatchCount(params.length, batch);
    }

    public static int getBatchCount(int size, int batch) {
        if (size <= 0) {
            return 0;
        }
        return (size - 1) / batch + 1;
    }

    public static int getBatchCount(int size) {
        return BgNSQLHelper.getBatchCount(size, 200);
    }

    public static ResultSet batchExecuteQuery(Context ctx, String sql, Object[] params) throws SQLException {
        if (ctx == null || sql == null || params == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        Object rst = null;
        conn = EJBFactory.getConnection((Context)ctx);
        pstmt = conn.prepareStatement(sql);
        BgNSQLHelper.setParams(pstmt, params);
        return pstmt.executeQuery();
    }

    public static ResultSet batchExecuteQuery(Connection conn, String sql, Set params) throws SQLException {
        if (conn == null || sql == null || params == null) {
            return null;
        }
        PreparedStatement pstmt = conn.prepareStatement(sql);
        BgNSQLHelper.setParams(pstmt, params);
        return pstmt.executeQuery();
    }

    public static ResultSet batchExecuteQuery(Connection conn, String sql, Object[] params) throws SQLException {
        if (conn == null || sql == null || params == null) {
            return null;
        }
        PreparedStatement pstmt = conn.prepareStatement(sql);
        BgNSQLHelper.setParams(pstmt, params);
        return pstmt.executeQuery();
    }

    public static int batchExecuteUpdate(Connection conn, String sql, Object[] params) throws SQLException {
        if (conn == null || sql == null || params == null) {
            return -1;
        }
        PreparedStatement pstmt = conn.prepareStatement(sql);
        BgNSQLHelper.setParams(pstmt, params);
        return pstmt.executeUpdate();
    }

    public static void setParams(PreparedStatement pstmt, Object[] params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int in = params.length;
        for (int i = 1; i <= in; ++i) {
            pstmt.setObject(i, params[i - 1]);
        }
    }

    public static void setParams(PreparedStatement pstmt, int index, Object[] params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int in = params.length;
        for (int i = 1; i <= in; ++i) {
            pstmt.setObject(i + index - 1, params[i - 1]);
        }
    }

    public static void setParams(PreparedStatement pstmt, List params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            pstmt.setObject(i + 1, params.get(i));
        }
    }

    public static void setParams(PreparedStatement pstmt, List params, int index) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int in = params.size() + index;
        for (int i = index; i < in; ++i) {
            pstmt.setObject(i, params.get(i - index));
        }
    }

    public static void setParams(PreparedStatement pstmt, Set params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int index = 1;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            pstmt.setObject(index++, iter.next());
        }
    }

    public static String getParamSizeString(Collection collection) {
        if (collection == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int in = collection.size();
        for (int i = 0; i < in; ++i) {
            str.append("?,");
        }
        if (str.length() > 0) {
            str.delete(str.length() - 1, str.length());
        }
        return str.toString();
    }

    public static String getParamSizeString(int size) {
        if (size <= 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int in = size;
        for (int i = 0; i < in; ++i) {
            str.append("?,");
        }
        if (str.length() > 0) {
            str.delete(str.length() - 1, str.length());
        }
        return str.toString();
    }

    public static int execute(Context ctx, String sql, Object[] params) throws SQLException {
        if (ctx == null || sql == null) {
            return -1;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int number = -1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            number = pstmt.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                throw exc;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return number;
    }

    public static int execute(Context ctx, String sql, String params) throws BOSException {
        if (ctx == null || sql == null) {
            return -1;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int number = -1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setObject(1, params);
            number = pstmt.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                sb.append("param is:").append(params);
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return number;
    }

    public static void executeBatchQuery(Context ctx, String sql, List<Object[]> params, IResultReader reader) throws BOSException {
        if (ctx == null || sql == null || params == null || params.isEmpty() || reader == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < params.size(); ++i) {
                BgNSQLHelper.setParams(pstmt, params.get(i));
                res = pstmt.executeQuery();
                while (res.next()) {
                    reader.read(res);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
    }

    public static void setBatchParams(Object[] sourceParams, Object[] targetParams, int startIndex, int batchIndex) {
        if (sourceParams == null || targetParams == null) {
            return;
        }
        for (int i = 0; i < 200; ++i) {
            int id = batchIndex * 200 + i;
            targetParams[startIndex + i] = id >= sourceParams.length ? NO_FOUND : sourceParams[id];
        }
    }

    public static void setBatchParams(Object[] sourceParams, Object[] targetParams, int startIndex, int batchIndex, int batchCont) {
        if (sourceParams == null || targetParams == null) {
            return;
        }
        for (int i = 0; i < batchCont; ++i) {
            int id = batchIndex * batchCont + i;
            targetParams[startIndex + i] = id >= sourceParams.length ? NO_FOUND : sourceParams[id];
        }
    }

    public static Map getSubMap(Map parent, String key, boolean create) {
        if (parent == null) {
            return null;
        }
        if (parent.containsKey(key)) {
            return (Map)parent.get(key);
        }
        if (create) {
            parent.put(key, new HashMap());
            return (Map)parent.get(key);
        }
        return null;
    }

    public static List<Object[]> getBatchParams(Object[] commonParams, Object[] batchParams, int oneBatchCount) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (batchParams == null || batchParams.length == 0) {
            return params;
        }
        int commonCount = commonParams == null ? 0 : commonParams.length;
        int batchCount = BgNSQLHelper.getBatchCount(batchParams);
        for (int i = 0; i < batchCount; ++i) {
            Object[] oneParam = new Object[commonCount + oneBatchCount];
            if (commonCount > 0) {
                BgNSQLHelper.setBatchParams(commonParams, oneParam, 0, 0, commonCount);
            }
            BgNSQLHelper.setBatchParams(batchParams, oneParam, commonCount, i, oneBatchCount);
            params.add(oneParam);
        }
        return params;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("T_BG_BgTemplate", "FBgTypeID!Fid");
        map.put("T_BG_BgForm", "FBgTypeID!FBgTemplateID");
        bgTypeRefTables = Collections.unmodifiableMap(map);
    }
}

