/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BgOrgUtils {
    public static final String NUMBER = "number";
    public static final String NAME = "name";

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, String field, String value, boolean isBlured) {
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (node == null || node.getUserObject() == null) continue;
            unitInfo = ((OrgStructureInfo)node.getUserObject()).getUnit();
            if (value == null || value.trim().length() == 0) continue;
            String numberOrName = null;
            if (NUMBER.equalsIgnoreCase(field)) {
                numberOrName = unitInfo.getNumber();
            } else if (NAME.equalsIgnoreCase(field)) {
                numberOrName = unitInfo.getName();
            }
            if (numberOrName == null) continue;
            if (isBlured) {
                if (numberOrName.indexOf(value) != -1) continue;
                OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
                continue;
            }
            if (numberOrName.equals(value)) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    public static TreeModel clipAndCloneTreeModel(TreeModel model, String field, String value, boolean isBlured) {
        if (field == null || field.trim().length() == 0) {
            return model;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)BgOrgUtils.deepCloneTreeModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            BgOrgUtils.disableTreeNodeByFilterCondition(root, field, value, isBlured);
            OrgF7InnerUtils.clipTreeNodeByColor((DefaultKingdeeTreeNode)root);
        }
        return treeModel;
    }

    private static TreeModel deepCloneTreeModel(TreeModel model) {
        if (model.getRoot() != null) {
            DefaultKingdeeTreeNode newRoot = BgOrgUtils.cloneTreeNode((DefaultKingdeeTreeNode)model.getRoot());
            return new DefaultTreeModel((TreeNode)newRoot);
        }
        return new DefaultTreeModel(null);
    }

    private static DefaultKingdeeTreeNode cloneTreeNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode(node.getUserObject());
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            DefaultKingdeeTreeNode newChildNode = BgOrgUtils.cloneTreeNode(childNode);
            newNode.add((MutableTreeNode)newChildNode);
        }
        return newNode;
    }
}

