/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgCollectFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.budget.RefBgFormInfo;
import org.apache.log4j.Logger;

public final class BgUpgradeHelper {
    private static Logger logger = Logger.getLogger((String)BgUpgradeHelper.class.getName());

    public static void UpgradeModel(IObjectValue model) {
        if (model == null) {
            return;
        }
        byte[] data = null;
        if (model instanceof BgFormInfo) {
            data = ((BgFormInfo)model).getZipData();
        } else if (model instanceof BgTemplateInfo) {
            data = ((BgTemplateInfo)model).getZipData();
        } else if (model instanceof BgCollectFormInfo) {
            data = ((BgCollectFormInfo)model).getKdtData();
        } else if (model instanceof BgDecomposerFormInfo) {
            data = ((BgDecomposerFormInfo)model).getKdtData();
        } else if (model instanceof RefBgFormInfo) {
            data = ((RefBgFormInfo)model).getKdtData();
        } else if (model instanceof RefBgDecFormInfo) {
            data = ((RefBgDecFormInfo)model).getKdtData();
        }
        if (data != null && data.length > 17) {
            try {
                String magic_str = new String(data, 0, 17);
                if (magic_str.equalsIgnoreCase("###PACKER4.0.1###")) {
                    Book _book = IOHelper.unpackBook((byte[])data);
                    data = IOHelper.packBook((Book)_book);
                    if (model instanceof BgFormInfo) {
                        ((BgFormInfo)model).setZipData(data);
                    } else if (model instanceof BgTemplateInfo) {
                        ((BgTemplateInfo)model).setZipData(data);
                    } else if (model instanceof BgCollectFormInfo) {
                        ((BgCollectFormInfo)model).setKdtData(data);
                    } else if (model instanceof BgDecomposerFormInfo) {
                        ((BgDecomposerFormInfo)model).setKdtData(data);
                    } else if (model instanceof RefBgFormInfo) {
                        ((RefBgFormInfo)model).setKdtData(data);
                    } else if (model instanceof RefBgDecFormInfo) {
                        ((RefBgDecFormInfo)model).setKdtData(data);
                    }
                }
            }
            catch (Exception ex0) {
                logger.error((Object)ex0);
            }
        }
    }
}

