/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetDisplayValueProvider
implements IDisplayValueProvider {
    private static final Logger logger = Logger.getLogger(BudgetDisplayValueProvider.class);
    private static String BGFORMULA = "bgformula";
    private static String BGACTUALS = "bgactuals";
    private static String BGBALANCE = "bgbal";
    private static String BGRPTDATE = "=bgRptDate";
    private static String RPTDATE = "=rptDate";
    private Component ui = null;
    private Map measureUnitMap = null;
    private Map currencyMap = null;
    private Map formulaMap = null;
    private BigDecimal coefficient = null;
    private int precision = -1;

    private BudgetDisplayValueProvider() {
    }

    public BudgetDisplayValueProvider(Component component) {
        this.ui = component;
    }

    public BigDecimal getCoefficient() {
        if (this.coefficient != null) {
            return this.coefficient;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getEditData", null);
                if (method != null) {
                    MeasureUnitInfo mu;
                    IObjectValue model = (IObjectValue)method.invoke((Object)this.ui, null);
                    if (model != null && model instanceof BgFormInfo) {
                        MeasureUnitInfo mu2 = ((BgFormInfo)model).getMeasureUnit();
                        if (mu2 != null) {
                            this.coefficient = mu2.getCoefficient();
                            return this.coefficient;
                        }
                    } else if (model != null && model instanceof BgActualRecordInfo && (mu = ((BgActualRecordInfo)model).getMeasureUnit()) != null) {
                        this.coefficient = mu.getCoefficient();
                        return this.coefficient;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        return BgNConstants.ONE;
    }

    public int getPrecision() {
        if (this.precision != -1) {
            return this.precision;
        }
        this.precision = 3;
        if (this.ui != null) {
            Method method = null;
            try {
                IObjectValue model;
                method = this.ui.getClass().getMethod("getEditData", null);
                if (method != null && (model = (IObjectValue)method.invoke((Object)this.ui, null)) != null && model instanceof BgFormInfo) {
                    this.precision = ((BgFormInfo)model).getCurrency().getPrecision();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        return this.precision;
    }

    public Map getMeasureUnitMap() {
        if (this.measureUnitMap != null) {
            return this.measureUnitMap;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getMeasureUnitMap", null);
                if (method != null) {
                    this.measureUnitMap = (Map)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.measureUnitMap == null) {
            this.measureUnitMap = new HashMap();
        }
        return this.measureUnitMap;
    }

    public Map getCurrencyMap() {
        if (this.currencyMap != null) {
            return this.currencyMap;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getCurrencyMap", null);
                if (method != null) {
                    this.currencyMap = (Map)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.currencyMap == null) {
            this.currencyMap = new HashMap();
        }
        return this.currencyMap;
    }

    public Map getFormulaMap() {
        if (this.formulaMap != null) {
            return this.formulaMap;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getFormulaMap", null);
                if (method != null) {
                    this.formulaMap = (Map)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.formulaMap == null) {
            this.formulaMap = new HashMap();
        }
        return this.formulaMap;
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null) {
            StyleAttributes sa = Styles.getEmptySA();
            cell.getSheet().getRange(cell).getStyle(sa);
            if (sa.isHided()) {
                return "";
            }
            if (viewMode == 0) {
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    if (cell.getValue().getValue() instanceof GregorianCalendar) {
                        return cell.getText();
                    }
                    String _text = cell.getText();
                    if (!StringUtils.isEmpty((String)_text)) {
                        if ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0) {
                            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                            if (obj instanceof ReportCalculateErrorProvider) {
                                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                                if ("#DIV/0!".equals(_text)) {
                                    return rcep.getZeroDivDisplayAs();
                                }
                                if (_text.indexOf("#BAD FUNCTION") >= 0) {
                                    return rcep.getExceptionReplacer();
                                }
                            }
                            return _text;
                        }
                        Object obj = cell.getValue().getValue();
                        if (BgNFSHelper.checkHasPercentage(cell)) {
                            String text = cell.getText();
                            if (text != null && !text.endsWith("%") && !BgNFSHelper.checkHasFormulaOfCell(cell)) {
                                int precision = BgNFSHelper.getDigitOfNumber(cell, 0);
                                BigDecimal textVal = null;
                                try {
                                    textVal = new BigDecimal(text);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (textVal == null) {
                                    return cell.getText();
                                }
                                String numberFormat = null;
                                numberFormat = precision == 0 ? "0" + BgNFSHelper.getNumberFormat("0", precision) + "%" : "0." + BgNFSHelper.getNumberFormat("0", precision) + "%";
                                DecimalFormat format = new DecimalFormat(numberFormat, BgNationalFormatUIUtil.getDecimalFormatSymbols());
                                return format.format(textVal);
                            }
                            return cell.getText();
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        if (BgNFSHelper.checkHasExpression(cell)) {
                            String showStr;
                            if (obj instanceof String) {
                                return _text;
                            }
                            if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
                                return showStr;
                            }
                            if (cell.getFormula().startsWith(BGRPTDATE) || cell.getFormula().startsWith(RPTDATE)) {
                                return this.getFormulaMeasureUnitDisplayValue(cell, obj);
                            }
                            int _precision = BgNFSHelper.getDigitOfNumber(cell, this.getPrecision());
                            return this.getDisplayValue(obj, this.getCoefficient(), _precision);
                        }
                        return this.getDefMeasureUnitDisplayValue(cell, obj);
                    }
                }
            } else if (viewMode == 1) {
                Object obj;
                if (cell.hasFormula()) {
                    return cell.getFormula();
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell) && (obj = cell.getValue().getValue()) != null) {
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                        if (this.getMeasureUnitMap().isEmpty()) {
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                        }
                        return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                    }
                    if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                        String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                        if (this.getMeasureUnitMap().isEmpty()) {
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                        }
                        return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, obj);
                }
            } else if (viewMode == 10) {
                if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                    return BgNFSHelper.getDisplayFormula(BgNFSHelper.getFormulaOfCell(cell), this.getFormulaMap());
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    Object obj = cell.getValue().getValue();
                    if (BgNFSHelper.checkHasExpression(cell)) {
                        return this.getFormulaMeasureUnitDisplayValue(cell, obj);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, obj);
                }
            }
        }
        return null;
    }

    protected Object getMeasureUnitDisplayValue(Cell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        _parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_parameter[2]));
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_parameter[2]));
                }
                if (!StringUtils.isEmpty((String)_parameter[3]) && this.getCurrencyMap().containsKey(_parameter[3])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[3]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    private BigDecimal getCoefficent(Object measureUnit) {
        if (measureUnit instanceof BigDecimal) {
            return (BigDecimal)measureUnit;
        }
        if (measureUnit instanceof MeasureUnitInfo) {
            return ((MeasureUnitInfo)measureUnit).getCoefficient();
        }
        return BgNConstants.ONE;
    }

    protected Object getFormulaMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        Expression _expression = null;
        Object _obj = null;
        String _expressions = cell.getFormula();
        try {
            _expression = ExcelFormulaPaserHelper.parse((String)_expressions);
        }
        catch (Exception ex) {
            _obj = obj;
        }
        _obj = this.getFormulaMeasureUnitDisplayValue(_expression, cell, obj);
        if (_obj == null) {
            _obj = this.getDefMeasureUnitDisplayValue(cell, obj);
        }
        return _obj;
    }

    protected Object getFormulaMeasureUnitDisplayValue(Expression expression, Cell cell, Object obj) {
        if (expression == null) {
            return null;
        }
        Object _obj = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        if (expression instanceof FunctionExpr) {
            String _funcionName = ((FunctionExpr)expression).funcionName;
            if (BGFORMULA.equalsIgnoreCase(_funcionName) || BGACTUALS.equalsIgnoreCase(_funcionName) || BGBALANCE.equalsIgnoreCase(_funcionName)) {
                StringExpr _bgelement = (StringExpr)((FunctionExpr)expression).parameters.get(2);
                StringExpr _currency = (StringExpr)((FunctionExpr)expression).parameters.get(4);
                if (this.getMeasureUnitMap().containsKey(_bgelement.value)) {
                    _coefficient = this.getCoefficent(this.getMeasureUnitMap().get(_bgelement.value));
                }
                if (this.getCurrencyMap().containsKey(_currency.value)) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_currency.value);
                    _precision = _currencyInfo.getPrecision();
                }
                _obj = this.getDisplayValue(obj, _coefficient, _precision);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            _obj = this.getFormulaMeasureUnitDisplayValue(((BinaryOperationExpr)expression).left, cell, obj);
            if (obj == null) {
                _obj = this.getFormulaMeasureUnitDisplayValue(((BinaryOperationExpr)expression).right, cell, obj);
            }
        }
        return _obj;
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if (!BgNFSHelper.checkHasNumbericOfCell(cell) || !BgNFSHelper.checkIsNumericOfCell(cell)) {
            return cell.getText();
        }
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String cellStyle = cell.getDisplayStyle().getNumberFormat();
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
            _text = this.getDisplayValue(obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = BgNationalFormatUIUtil.parseToBigDecimal((Object)obj).divide(coefficient, precision, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }
}

