/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherFacadeFactory;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.IBgGatherFacade;
import com.kingdee.eas.ma.budget.client.BudgetUtilForClient;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormEditUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.util.Map;

public class BudgetProvider
extends IBookProvider {
    private BgNFProcessUI ui = null;
    private String[] sheetIds = null;
    private boolean isEnumerateForm = false;
    private boolean isScriptForm = false;

    private BudgetProvider() {
    }

    public BudgetProvider(Component obj) {
        this.ui = (BgNFProcessUI)obj;
    }

    protected IBgGatherFacade getGatherInterface() throws Exception {
        return BgGatherFacadeFactory.getRemoteInstance();
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getBudgetInfo() == null) {
            this.setEditValue(this.createNewReport());
        }
        if (this.getBudgetInfo().getData() != null) {
            book = this.getBudgetInfo().getBook();
        }
        if (book != null) {
            if (OprtState.ADDNEW.equals(this.ui.getOprtState())) {
                this.sheetIds = new String[book.getSheetCount()];
                int in = book.getSheetCount();
                for (int i = 0; i < in; ++i) {
                    this.sheetIds[i] = book.getSheet(i).getID();
                }
            }
            BudgetUtilForClient.prepareReportInfo4Display((ReportBaseInfo)this.getBudgetInfo(), (Book)book);
        }
        return book;
    }

    public IObjectValue getEditValue() {
        return super.getEditValue();
    }

    public BgFormInfo getBudgetInfo() {
        if ((BgFormInfo)this.getEditValue() != null && ((BgFormInfo)this.getEditValue()).getBgTemplate() != null && ((BgFormInfo)this.getEditValue()).getBgTemplate().getFormType() != null && ((BgFormInfo)this.getEditValue()).getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
            this.isEnumerateForm = true;
        }
        return (BgFormInfo)this.getEditValue();
    }

    public void restoreBook(Book book) throws Exception {
        BudgetUtilForClient.prepareReportInfo4Save((ReportBaseInfo)this.getBudgetInfo(), (Book)book);
        this.getBudgetInfo().setBook(book);
    }

    public IObjectValue createNewReport() throws Exception {
        UIContext uiContext = new UIContext(this.ui.getUIContext().get("Owner"));
        uiContext.put((Object)"ORGUNIT_INFO", this.ui.getUIContext().get("ORGUNIT_INFO"));
        uiContext.put((Object)"ORGUNIT_CU", this.ui.getUIContext().get("ORGUNIT_CU"));
        if (this.ui.getUIContext().get("BGFORM_LINK_SCHEME") != null) {
            uiContext.put((Object)"BGFORM_LINK_SCHEME", this.ui.getUIContext().get("BGFORM_LINK_SCHEME"));
        }
        if (this.ui.getUIContext().get("BGFORM_LINK_TEMPLATE") != null) {
            uiContext.put((Object)"BGFORM_LINK_TEMPLATE", this.ui.getUIContext().get("BGFORM_LINK_TEMPLATE"));
        }
        if (this.ui.getUIContext().get("BGFORM_LINK_PERIOD") != null) {
            uiContext.put((Object)"BGFORM_LINK_PERIOD", this.ui.getUIContext().get("BGFORM_LINK_PERIOD"));
        }
        if (this.ui.getUIContext().get("BGFORM_LINK_CURRENCY") != null) {
            uiContext.put((Object)"BGFORM_LINK_CURRENCY", this.ui.getUIContext().get("BGFORM_LINK_CURRENCY"));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean hasSubmit = false;
        IObjectValue model = null;
        if (uiWindow.getUIObject() instanceof BgNFormEditUI) {
            hasSubmit = ((BgNFormEditUI)uiWindow.getUIObject()).isHasSubmit();
            model = uiWindow.getUIObject().getDataObject();
            this.setEditValue(model);
        }
        if (!hasSubmit || model == null || !(model instanceof BgFormInfo)) {
            SysUtil.abort();
        }
        if (model instanceof BgFormInfo) {
            BgFormInfo bgFormInfo = (BgFormInfo)model;
            if (BgTemFormTypeEnum.ENUMERATEFORM.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                this.setEnumerateForm(true);
            } else if (BgTemFormTypeEnum.SCRIPTFORM.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                this.setScriptForm(true);
            }
        }
        return model;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return BgNFormEditUI.class.getName();
    }

    public ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected SelectorItemCollection getSelectors() {
        return BgNFSHelper.getSelectors();
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        Object obj = this.ui.getUIContext().get("IS_GATHER");
        IObjectValue model = null;
        model = obj != null && obj instanceof Boolean ? this.gatherEditData(pk) : super.queryEditData(pk);
        if (model instanceof BgFormInfo) {
            BgFormInfo bgFormInfo = (BgFormInfo)model;
            if (BgTemFormTypeEnum.ENUMERATEFORM.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                this.setEnumerateForm(true);
            } else if (BgTemFormTypeEnum.SCRIPTFORM.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                this.setScriptForm(true);
            }
        }
        return model;
    }

    protected IObjectValue gatherEditData(IObjectPK bgFormPk) throws Exception {
        Object obj = null;
        Map _gatherOrgUnitMap = null;
        Map _gatherBgSchemeIdMap = null;
        Map _gatherBgFormIdsMap = null;
        Map _patameterMap = null;
        obj = this.ui.getUIContext().get("GATHER_CHECK_ORGUNIT");
        if (obj != null && obj instanceof Map) {
            _gatherOrgUnitMap = obj;
        }
        if ((obj = this.ui.getUIContext().get("GATHER_CHECK_BGSCHEME_ID")) != null && obj instanceof Map) {
            _gatherBgSchemeIdMap = obj;
        }
        if ((obj = this.ui.getUIContext().get("GATHER_CHECK_BGFORM_ID")) != null && obj instanceof Map) {
            _gatherBgFormIdsMap = obj;
        }
        if ((obj = this.ui.getUIContext().get("GATHER_PARAMETER")) != null && obj instanceof Map) {
            _patameterMap = obj;
        }
        if (_gatherOrgUnitMap != null && !_gatherOrgUnitMap.isEmpty() && _gatherBgSchemeIdMap != null && _patameterMap != null) {
            BgFormInfo model = this.getGatherInterface().getGatherValue(bgFormPk, _gatherOrgUnitMap, _gatherBgSchemeIdMap, _gatherBgFormIdsMap, _patameterMap);
            this.ui.getUIContext().remove("GATHER_CHECK_ORGUNIT");
            this.ui.getUIContext().remove("GATHER_CHECK_BGSCHEME_ID");
            this.ui.getUIContext().remove("GATHER_CHECK_BGFORM_ID");
            this.ui.getUIContext().remove("GATHER_PARAMETER");
            return model;
        }
        return super.queryEditData(bgFormPk);
    }

    public void restoreSheetId(Book book) {
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            book.getSheet(i).setID(this.sheetIds[i]);
        }
    }

    public boolean audit(BOSUuid bgFormId, BOSUuid auditorId) throws Exception {
        return this.ui.getFacadeInterface().auditForm(bgFormId, auditorId);
    }

    public boolean audit(BOSUuid bgFormId, BOSUuid auditorId, String idea) throws Exception {
        return this.ui.getFacadeInterface().auditForm(bgFormId, auditorId, idea);
    }

    public boolean antiAudit(BOSUuid bgFormId, BOSUuid auditorId, String idea) throws Exception {
        return this.ui.getFacadeInterface().submitAntiAudit(bgFormId, auditorId, idea);
    }

    public void setEnumerateForm(boolean isEnumerateForm) {
        this.isEnumerateForm = isEnumerateForm;
    }

    public boolean isEnumerateForm() {
        return this.isEnumerateForm;
    }

    public void setScriptForm(boolean isScriptForm) {
        this.isScriptForm = isScriptForm;
    }

    public boolean isScriptForm() {
        return this.isScriptForm;
    }

    public String getBizFactoryName() {
        return BgFormFactory.class.getName();
    }
}

