/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.kdf.kds.ICells;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.nbudget.Parameter;
import com.kingdee.eas.ma.nbudget.Parser;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Excel2007Reader
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(Excel2007Reader.class);
    private KDSBook book = null;
    private KDSSheet kdSheet = null;
    private float defaultRowHeight = 0.0f;
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    private int curRow = 0;
    private int curCol = 0;
    public StylesTable stylesTable;
    private String stylesIndex;
    private String formula;
    private boolean nextIsBoolean;
    private short type = 0;
    public static final String NULL_FORMULA = "ATTR(semiVolatile)";
    public static final String KD_SINGLE_COMMA = "\\\\'";
    public static final String KD_DOUBLE_COMMA = "'";
    public static final String KD_EXCHANGE_COMMA = "KD_EXCHANGE_COMMA";
    public static final String KD_FORMULA_SPLIT = "_@_";
    private Object value = null;
    private Map colors = HSSFColor.getIndexHash();
    private HashMap styles = null;
    private HashMap sharedFormulas = null;
    private HashMap sameFormulas = null;
    private String sharedIdentity;
    private boolean hasBeenShared;
    private boolean hasShared;
    private String curCell;
    private HashMap srcCells;
    public static final String EXPORT_FORMULA = "EXPORT_FORMULA";
    public static final String IMPORT_FORMAT = "IMPORT_FORMAT";
    public static final String IMPORT_STYLE = "IMPORT_STYLE";
    private boolean importFormula = true;
    private boolean importFormat = true;
    private boolean importStyle = true;

    public KDSBook parse(String fileName, HashMap parameter) throws Exception {
        String sImportStyle;
        String sImportFormat;
        String sImportFormula = (String)parameter.get(EXPORT_FORMULA);
        if (!StringUtil.isEmptyString((String)sImportFormula)) {
            this.importFormula = Boolean.valueOf(sImportFormula);
        }
        if (!StringUtil.isEmptyString((String)(sImportFormat = (String)parameter.get(IMPORT_FORMAT)))) {
            this.importFormat = Boolean.valueOf(sImportFormat);
        }
        if (!StringUtil.isEmptyString((String)(sImportStyle = (String)parameter.get(IMPORT_STYLE)))) {
            this.importStyle = Boolean.valueOf(sImportStyle);
        }
        return this.parse(fileName);
    }

    public KDSBook parse(String filename) throws Exception {
        this.book = new KDSBook("aa");
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        this.stylesTable = r.getStylesTable();
        XMLReader parser = this.fetchSheetParser(sst);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
        while (sheets.hasNext()) {
            InputStream sheet = sheets.next();
            this.kdSheet = new KDSSheet(this.book, sheets.getSheetName());
            this.book.addSheet(null, this.kdSheet);
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            this.sharedFormulas = null;
            this.sameFormulas = null;
            this.srcCells = null;
            sheet.close();
        }
        pkg.close();
        return this.book;
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.sst = sst;
        parser.setContentHandler(this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("sheetFormatPr".equals(name)) {
            this.defaultRowHeight = Float.parseFloat(attributes.getValue("defaultRowHeight"));
        }
        if ("row".equals(name)) {
            String rowId = attributes.getValue("r");
            this.curRow = Integer.parseInt(rowId) - 1;
            String rowHeight = attributes.getValue("ht");
            if (rowHeight != null) {
                this.kdSheet.getRows().setRowHeight(this.curRow, (float)(StyleUtil.ptToLom((double)Float.parseFloat(rowHeight)) / 10.0));
            } else {
                this.kdSheet.getRows().setRowHeight(this.curRow, (float)(StyleUtil.ptToLom((double)this.defaultRowHeight) / 10.0));
            }
        }
        if ("c".equals(name)) {
            String cellType = attributes.getValue("t");
            this.stylesIndex = attributes.getValue("s");
            this.curCell = attributes.getValue("r");
            this.curCol = this.calCellColumn(this.curCell) - 1;
            this.nextIsString = cellType != null && cellType.equals("s");
            this.nextIsBoolean = cellType != null && cellType.equals("b");
        }
        if (this.importFormula && "f".equals(name)) {
            this.hasBeenShared = false;
            this.hasShared = false;
            String formulaType = attributes.getValue("t");
            if (formulaType != null && "shared".equals(formulaType.trim())) {
                String ref = attributes.getValue("ref");
                this.sharedIdentity = attributes.getValue("si");
                if (this.sharedFormulas == null) {
                    this.sharedFormulas = new HashMap();
                }
                if (this.srcCells == null) {
                    this.srcCells = new HashMap();
                }
                if (ref != null && !StringUtil.isEmptyString((String)ref)) {
                    this.hasBeenShared = true;
                } else {
                    this.hasShared = true;
                }
            }
        }
        if ("mergeCell".equals(name)) {
            String[] mergeCellStrs = attributes.getValue("ref").split(":");
            this.parseMergeCell(mergeCellStrs);
        }
        this.lastContents = "";
    }

    private void parseMergeCell(String[] mergeCellStrs) {
        int firstRow = this.calCellRow(mergeCellStrs[0]);
        int firstCol = this.calCellColumn(mergeCellStrs[0]);
        int lastRow = this.calCellRow(mergeCellStrs[1]);
        int lastCol = this.calCellColumn(mergeCellStrs[1]);
        this.kdSheet.getMerges().addMerge(firstRow, firstCol, lastRow, lastCol);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                this.type = 1;
            }
            catch (Exception idx) {
                // empty catch block
            }
        }
        if (this.nextIsBoolean) {
            this.type = (short)4;
        }
        if ("v".equals(name) || "t".equals(name)) {
            this.value = this.lastContents.trim();
            if (!StringUtils.isEmpty((String)this.stylesIndex)) {
                XSSFCellStyle cellStyle = this.stylesTable.getStyleAt(Integer.parseInt(this.stylesIndex));
                short formatIndex = cellStyle.getDataFormat();
                String formatString = cellStyle.getDataFormatString();
                if (formatString == null) {
                    formatString = BuiltinFormats.getBuiltinFormat((int)formatIndex);
                }
                if (DateUtil.isADateFormat((int)formatIndex, (String)formatString)) {
                    Date date = DateUtil.getJavaDate((double)Double.parseDouble((String)this.value));
                    DateFormat simpleDateFormat = BgNationalFormatUIUtil.getNationalDateFormat();
                    this.value = simpleDateFormat.format(date);
                } else if (!this.nextIsString) {
                    this.value = NumberUtil.cutZero((String)this.lastContents.trim());
                }
            }
        }
        this.importFormula = true;
        if (true && "f".equals(name)) {
            if (!this.hasShared) {
                this.formula = this.lastContents.trim();
                String[] returnValue = this.convertFormula(this.formula);
                if (returnValue[1].equals("1")) {
                    this.value = returnValue[2];
                }
                this.formula = returnValue[0];
                if (this.hasBeenShared && !returnValue[1].equals("1")) {
                    Parser parser = new Parser();
                    parser.parse(this.formula);
                    this.sharedFormulas.put(this.sharedIdentity, parser);
                    this.srcCells.put(this.sharedIdentity, this.curCell);
                }
                if (this.hasBeenShared && returnValue[1].equals("1")) {
                    if (this.sameFormulas == null) {
                        this.sameFormulas = new HashMap();
                    }
                    this.sameFormulas.put(this.sharedIdentity, this.formula);
                }
            } else {
                this.formula = this.sameFormulas != null && this.sameFormulas.get(this.sharedIdentity) != null ? String.valueOf(this.sameFormulas.get(this.sharedIdentity)) : this.calFormula((Parser)this.sharedFormulas.get(this.sharedIdentity), String.valueOf(this.srcCells.get(this.sharedIdentity)), this.curCell);
            }
            this.type = (short)2;
        }
        if ("c".equals(name)) {
            ICells kdCells = this.kdSheet.getCells();
            XSSFCellStyle cellStyle = null;
            StyleAttributes kdsa = null;
            if (!StringUtils.isEmpty((String)this.stylesIndex)) {
                if (this.styles == null) {
                    this.styles = new HashMap();
                }
                if ((kdsa = (StyleAttributes)this.styles.get(this.stylesIndex)) == null) {
                    cellStyle = this.stylesTable.getStyleAt(Integer.parseInt(this.stylesIndex));
                    kdsa = this.parseKDStyleAttributes(cellStyle);
                    this.styles.put(this.stylesIndex, kdsa);
                }
            }
            KDSCell kdCell = null;
            kdCell = kdsa != null && !kdsa.isEmpty() ? kdCells.setCell(this.curRow, this.curCol, this.value, this.formula, Styles.getSSA((StyleAttributes)kdsa)) : kdCells.setCellValue(this.curRow, this.curCol, this.value);
            kdCell.setType(this.type);
            if (this.formula != null) {
                this.kdSheet.getCell(this.curRow, this.curCol, true).setFormula(this.formula);
            } else {
                kdCells.setCellValue(this.curRow, this.curCol, this.value);
            }
            kdCell.setType(this.type);
            this.value = null;
            this.formula = null;
            this.stylesIndex = null;
            this.type = 0;
        }
    }

    private String calFormula(Parser parser, String srcCell, String cellPos) {
        String tempFormula = parser.getFormula();
        int srcCol = this.calCellColumn(srcCell) - 1;
        int srcRow = Integer.parseInt(srcCell.replaceAll("[A-Z]", "").trim()) - 1;
        int offsetX = this.curCol - srcCol;
        int offsetY = this.curRow - srcRow;
        ObjectArray parametersArray = parser.getParameters();
        Parameter parameter = null;
        StringBuffer sb = new StringBuffer(tempFormula);
        StringBuffer temp = null;
        for (int i = 0; i < parametersArray.size(); ++i) {
            temp = new StringBuffer();
            parameter = (Parameter)parametersArray.get(i);
            temp.append(SheetBaseMath.getColumnName((int)(parameter.getColNum() + offsetX), (int)0, (boolean)true, (boolean)false));
            temp.append(SheetBaseMath.getRowName((int)(parameter.getRowNum() + offsetY), (int)0, (boolean)true, (boolean)false));
            sb.delete(parameter.getTokenPos(), parameter.getTokenLength() + parameter.getTokenPos());
            sb.insert(parameter.getTokenPos(), temp.toString());
        }
        return sb.toString();
    }

    private String[] convertFormula(String formula) {
        int pos;
        String tmpFormula = formula;
        String[] returnValue = new String[3];
        returnValue[1] = "0";
        String formulaValue = "";
        if (tmpFormula.indexOf(KD_FORMULA_SPLIT) != -1) {
            int beginIndex = 5;
            int endIndex = tmpFormula.indexOf(KD_FORMULA_SPLIT);
            int valueIndex = tmpFormula.lastIndexOf(",");
            formulaValue = tmpFormula.substring(0, valueIndex - 1);
            valueIndex = formulaValue.lastIndexOf(",") - 1;
            formula = tmpFormula.substring(beginIndex, endIndex);
            String sValue = tmpFormula.substring(endIndex + KD_FORMULA_SPLIT.length(), valueIndex);
            formula = this.convertFormulaSpecialString(formula);
            sValue = this.convertFormulaSpecialString(sValue);
            returnValue[1] = "1";
            returnValue[2] = sValue;
        }
        int iNullIndex = formula.indexOf(NULL_FORMULA);
        int iNullLen = NULL_FORMULA.length();
        while (iNullIndex != -1) {
            formula = formula.substring(0, iNullIndex) + formula.substring(iNullIndex + iNullLen);
            iNullIndex = formula.indexOf(NULL_FORMULA);
        }
        if (formula != null && (pos = formula.indexOf("!")) > 0) {
            String sheetName = formula.substring(0, pos);
            try {
                Double.parseDouble(sheetName);
                formula = KD_DOUBLE_COMMA + sheetName + KD_DOUBLE_COMMA + formula.substring(pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        returnValue[0] = formula;
        return returnValue;
    }

    private String convertFormulaSpecialString(String formula2) {
        this.formula = this.formula.replaceAll(KD_SINGLE_COMMA, KD_EXCHANGE_COMMA);
        this.formula = this.formula.replaceAll(KD_DOUBLE_COMMA, "\"");
        this.formula = this.formula.replaceAll(KD_EXCHANGE_COMMA, KD_DOUBLE_COMMA);
        return this.formula;
    }

    public int calCellColumn(String curCell) {
        curCell = curCell.replaceAll("[^A-Z]", "");
        byte[] rowAbc = curCell.getBytes();
        int len = rowAbc.length;
        float num = 0.0f;
        for (int i = 0; i < len; ++i) {
            num = (float)((double)num + (double)(rowAbc[i] - 65 + 1) * Math.pow(26.0, len - i - 1));
        }
        return (int)num;
    }

    public int calCellRow(String curCell) {
        curCell = curCell.replaceAll("[A-Z]", "");
        return Integer.parseInt(curCell);
    }

    private StyleAttributes parseKDStyleAttributes(XSSFCellStyle cellStyle) {
        StyleAttributes sa = Styles.getEmptySA();
        ShareStyleAttributes defaultssa = Styles.getDefaultSSA();
        if (this.importStyle) {
            XSSFFont xssfFont = cellStyle.getFont();
            this.font2SA(defaultssa, sa, xssfFont);
            this.alignment2SA(defaultssa, sa, cellStyle);
            this.protection2SA(defaultssa, sa, cellStyle);
            this.borders2SA(defaultssa, sa, cellStyle);
            this.interior2SA(defaultssa, sa, cellStyle);
        }
        if (this.importFormat && cellStyle.getDataFormat() != 0) {
            try {
                String format = cellStyle.getDataFormatString();
                if (!StringUtil.isEmptyString((String)format) && format.indexOf(40) == 0 && format.indexOf("_);") != -1) {
                    format = format.substring(1);
                }
                sa.setNumberFormat(format);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return sa;
    }

    private void interior2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle cellStyle) {
        short backmode = cellStyle.getFillPattern().getCode();
        Pattern pn = this.getkdpattern(backmode);
        if (pn != Pattern.None) {
            if (pn == Pattern.Solid) {
                Color awtcolor = this.getAWTColor(cellStyle.getFillForegroundColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
            } else {
                Color awtcolor = this.getAWTColor(cellStyle.getFillBackgroundColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
                awtcolor = this.getAWTColor(cellStyle.getFillForegroundColor(), Color.WHITE);
                if (!defaultssa.getPatternColor().equals(awtcolor)) {
                    sa.setPatternColor(awtcolor);
                }
            }
        }
        sa.setPattern(pn);
    }

    private Color getAWTColor(short index, Color deflt) {
        HSSFColor clr = (HSSFColor)this.colors.get(new Integer(index));
        if (clr == null) {
            return deflt;
        }
        return this.getAWTColor(clr);
    }

    private Color getAWTColor(int index) {
        HSSFColor clr = (HSSFColor)this.colors.get(new Integer(index));
        if (clr == null) {
            return null;
        }
        return this.getAWTColor(clr);
    }

    private Color getAWTColor(HSSFColor clr) {
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    private Pattern getkdpattern(short backmode) {
        Pattern pn;
        switch (backmode) {
            case 1: {
                pn = Pattern.Solid;
                break;
            }
            case 2: {
                pn = Pattern.Percent50;
                break;
            }
            case 3: {
                pn = Pattern.Percent25;
                break;
            }
            case 4: {
                pn = Pattern.Percent70;
                break;
            }
            case 5: {
                pn = Pattern.DarkHorizontal;
                break;
            }
            case 6: {
                pn = Pattern.DarkVertical;
                break;
            }
            case 7: {
                pn = Pattern.DarkDownwardDiagonal;
                break;
            }
            case 8: {
                pn = Pattern.DarkUpwardDiagonal;
                break;
            }
            case 9: {
                pn = Pattern.SmallCheckerBoard;
                break;
            }
            case 10: {
                pn = Pattern.Trellis;
                break;
            }
            case 11: {
                pn = Pattern.Percent60;
                break;
            }
            case 12: {
                pn = Pattern.LightVertical;
                break;
            }
            case 13: {
                pn = Pattern.LightDownwardDiagonal;
                break;
            }
            case 14: {
                pn = Pattern.LightUpwardDiagonal;
                break;
            }
            case 15: {
                pn = Pattern.SmallGrid;
                break;
            }
            case 16: {
                pn = Pattern.Percent30;
                break;
            }
            case 17: {
                pn = Pattern.Percent20;
                break;
            }
            case 18: {
                pn = Pattern.Percent10;
                break;
            }
            default: {
                pn = Pattern.None;
            }
        }
        return pn;
    }

    private void borders2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle cellStyle) {
        Color awtbordercolor = this.getAWTColor(cellStyle.getLeftBorderColor(), Color.BLACK);
        if (!defaultssa.getBorderColor(Styles.Position.LEFT).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.LEFT, awtbordercolor);
        }
        awtbordercolor = this.getAWTColor(cellStyle.getRightBorderColor(), Color.BLACK);
        if (!defaultssa.getBorderColor(Styles.Position.RIGHT).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.RIGHT, awtbordercolor);
        }
        awtbordercolor = this.getAWTColor(cellStyle.getTopBorderColor(), Color.BLACK);
        if (!defaultssa.getBorderColor(Styles.Position.TOP).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.TOP, awtbordercolor);
        }
        awtbordercolor = this.getAWTColor(cellStyle.getBottomBorderColor(), Color.BLACK);
        if (!defaultssa.getBorderColor(Styles.Position.BOTTOM).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.BOTTOM, awtbordercolor);
        }
        this.borderstyle2sa(sa, Styles.Position.BOTTOM, cellStyle.getBorderBottom());
        this.borderstyle2sa(sa, Styles.Position.LEFT, cellStyle.getBorderLeft());
        this.borderstyle2sa(sa, Styles.Position.RIGHT, cellStyle.getBorderRight());
        this.borderstyle2sa(sa, Styles.Position.TOP, cellStyle.getBorderTop());
    }

    private void borderstyle2sa(StyleAttributes sa, Styles.Position pos, BorderStyle xssfborder) {
        switch (xssfborder) {
            case NONE: {
                sa.setBorderLineStyle(pos, LineStyle.NULL_LINE);
                break;
            }
            case THIN: {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
                break;
            }
            case DASH_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case DASH_DOT_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case DASHED: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case DOTTED: {
                sa.setBorderPenStyle(pos, PenStyle.PS_CONTINUOUS);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case MEDIUM: {
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            case MEDIUM_DASHED: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            case MEDIUM_DASH_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            case MEDIUM_DASH_DOT_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            default: {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
            }
        }
    }

    private void protection2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle cellStyle) {
        boolean bLock = cellStyle.getLocked();
        if (defaultssa.isLocked() != bLock) {
            sa.setLocked(bLock);
        }
        boolean bhide = cellStyle.getHidden();
        if (defaultssa.isHided() != bhide) {
            sa.setHided(bhide);
        }
    }

    private void alignment2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle cellStyle) {
        Styles.VerticalAlignment valign;
        Styles.HorizontalAlignment align;
        switch (cellStyle.getAlignment()) {
            case LEFT: {
                align = Styles.HorizontalAlignment.LEFT;
                break;
            }
            case RIGHT: {
                align = Styles.HorizontalAlignment.RIGHT;
                break;
            }
            case CENTER: {
                align = Styles.HorizontalAlignment.CENTER;
                break;
            }
            default: {
                align = null;
            }
        }
        if (align != null) {
            sa.setHorizontalAlign(align);
        }
        switch (cellStyle.getVerticalAlignment()) {
            case TOP: {
                valign = Styles.VerticalAlignment.TOP;
                break;
            }
            case CENTER: {
                valign = Styles.VerticalAlignment.MIDDLE;
                break;
            }
            case BOTTOM: {
                valign = Styles.VerticalAlignment.BOTTOM;
                break;
            }
            default: {
                valign = Styles.VerticalAlignment.BOTTOM;
            }
        }
        if (defaultssa.getVerticalAlign() != valign) {
            sa.setVerticalAlign(valign);
        }
        boolean bwraptext = cellStyle.getWrapText();
        if (defaultssa.isWrapText() != bwraptext) {
            sa.setWrapText(bwraptext);
        }
        short roration = cellStyle.getRotation();
        if (defaultssa.getRotation() != roration) {
            sa.setRotation((int)roration);
        }
    }

    private void font2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFFont hssffont) {
        String fontName = hssffont.getFontName();
        if (!defaultssa.getFontName().equals(fontName)) {
            sa.setFontName(fontName);
        }
        short fontSize = hssffont.getFontHeightInPoints();
        sa.setFontSize((int)fontSize);
        Color awtclr = this.getAWTColor(hssffont.getColor(), Color.BLACK);
        if (!defaultssa.getFontColor().equals(awtclr)) {
            sa.setFontColor(awtclr);
        }
        boolean bvalue = hssffont.getBold();
        if (defaultssa.isBold() != bvalue) {
            sa.setBold(bvalue);
        }
        bvalue = hssffont.getItalic();
        if (defaultssa.isItalic() != bvalue) {
            sa.setItalic(bvalue);
        }
        bvalue = hssffont.getStrikeout();
        if (defaultssa.isStrikeThrough() != bvalue) {
            sa.setStrikeThrough(bvalue);
        }
        boolean bl = bvalue = hssffont.getUnderline() != 0;
        if (defaultssa.isUnderline() != bvalue) {
            sa.setUnderline(bvalue);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }
}

