/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrlRecordCollection;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlState;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.nbudget.app.AbstractBgActualBillControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgActualBillControllerBean
extends AbstractBgActualBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgActualBillControllerBean");

    @Override
    protected void _auditApproved(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _auditApproving(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _auditEdited(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _auditRefferring(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _submitRefer(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _submitAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected Map _audit(Context ctx, BOSUuid[] idList) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _unAudit(Context ctx, BOSUuid[] idList) throws BOSException, EASBizException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addNewCtrlRecord(Context ctx, BgCtrlRecordCollection ctrlRecordCol) throws BOSException, EASBizException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" insert into T_BG_BgCtrlRecord");
        kSql.append("   (FId,");
        kSql.append("    FCreatorId,");
        kSql.append("    FCreateTime,");
        kSql.append("    FLastUpdateUserId,");
        kSql.append("    FLastUpdateTime,");
        kSql.append("    FControlUnitId,");
        kSql.append("    FBgDataId,");
        kSql.append("    FBillId,");
        kSql.append("    FBillName,");
        kSql.append("    FBillNumber,");
        kSql.append("    FBillAlias,");
        kSql.append("    FBillType,");
        kSql.append("    FBizDate,");
        kSql.append("    FActualAmount,");
        kSql.append("    FBillOperate,");
        kSql.append("    FBgPeriodId,");
        kSql.append("    FItemName,");
        kSql.append("    FBgTraceType,");
        kSql.append("    FOrgUnitId,");
        kSql.append("    FBgSchemeId,");
        kSql.append("    FItemFormula,");
        kSql.append("    FPayState,");
        kSql.append("    FISCollected,");
        kSql.append("    FDayDate)");
        kSql.append(" values (newbosid('FF6153C2'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx) != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : "";
        Date time = new Date(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            int batchCounter = 0;
            boolean isRun = false;
            for (int i = 0; i < ctrlRecordCol.size(); ++i) {
                BgCtrlRecordInfo info = ctrlRecordCol.get(i);
                statement.setString(1, userId);
                statement.setDate(2, time);
                statement.setString(3, userId);
                statement.setDate(4, time);
                statement.setString(5, info.getOrgUnitId());
                statement.setString(6, info.getBgDataId());
                statement.setString(7, info.getBillId());
                statement.setString(8, info.getBillName());
                statement.setString(9, info.getBillNumber());
                statement.setString(10, info.getBillAlias());
                statement.setString(11, info.getBillType());
                statement.setDate(12, info.getBizDate() != null ? new Date(info.getBizDate().getTime()) : null);
                statement.setBigDecimal(13, info.getActualAmount());
                statement.setString(14, info.getBillOperate());
                statement.setString(15, info.getBgPeriodId());
                statement.setString(16, info.getItemName());
                statement.setInt(17, info.getBgTraceType().getValue());
                statement.setString(18, info.getOrgUnitId());
                statement.setString(19, info.getBgSchemeId());
                statement.setString(20, info.getItemFormula());
                statement.setInt(21, 0);
                statement.setInt(22, 1);
                statement.setDate(23, info.getDayDate() != null ? new Date(info.getDayDate().getTime()) : null);
                statement.addBatch();
                isRun = true;
                if (++batchCounter < 200) continue;
                statement.executeBatch();
                batchCounter = 0;
            }
            if (isRun && batchCounter != 0) {
                statement.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Throwable)ex);
                catch (Exception ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectCtrlDataImmediately(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol) throws EASBizException, BOSException {
        if (ctrlResultCol == null || ctrlResultCol.isEmpty()) {
            return;
        }
        HashMap orgIdMap = new HashMap();
        HashMap<String, String> orgId2schemeIdMap = new HashMap<String, String>();
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (!BgActualBillControllerBean.isCanCollect(ctrlResultInfo)) continue;
            String orgUnitId = ctrlResultInfo.getOrgUnitId();
            String bgSchemeId = ctrlResultInfo.getBgSchemeId();
            orgIdMap.put(orgUnitId, null);
            orgId2schemeIdMap.put(orgUnitId, bgSchemeId);
        }
        if (BudgetCtrlUtil.isEmpty(orgIdMap) || BudgetCtrlUtil.isEmpty(orgId2schemeIdMap)) {
            orgIdMap.clear();
            orgId2schemeIdMap.clear();
            return;
        }
        Map orgId2parentOrgMap = BgActualBillControllerBean.getAllParentOrgMap(ctx, orgIdMap);
        if (BudgetCtrlUtil.isEmpty((Object)orgId2parentOrgMap)) {
            return;
        }
        HashMap org2parentOrgSchemeMap = new HashMap();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx) != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : "";
        Date time = new Date(System.currentTimeMillis());
        Connection conn = null;
        IRowSet rst = null;
        PreparedStatement updateBgDataSta = null;
        PreparedStatement insertCtrlRecordSta = null;
        PreparedStatement updateCtrlRecordSta = null;
        try {
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                String parentOrgId;
                List parents;
                BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
                if (!BgActualBillControllerBean.isCanCollect(ctrlResultInfo)) continue;
                String orgUnitId = ctrlResultInfo.getOrgUnitId();
                String schemeId = (String)orgId2schemeIdMap.get(orgUnitId);
                if (org2parentOrgSchemeMap.containsKey(orgUnitId) || BudgetCtrlUtil.isEmpty((Object)(parents = (List)orgId2parentOrgMap.get(orgUnitId)))) continue;
                StringBuffer parentOrgIds = new StringBuffer("(");
                for (int j = 0; j < parents.size(); ++j) {
                    CostCenterOrgUnitInfo parent = (CostCenterOrgUnitInfo)parents.get(j);
                    parentOrgId = parent.getId().toString();
                    if (j == 0) {
                        parentOrgIds.append("'").append(parentOrgId).append("'");
                        continue;
                    }
                    parentOrgIds.append(",'").append(parentOrgId).append("'");
                }
                parentOrgIds.append(")");
                StringBuffer kSQL = new StringBuffer();
                kSQL.append(" select FOrgUnitId,");
                kSQL.append("        FId");
                kSQL.append("   from T_BG_BgScheme");
                kSQL.append("  where FOrgUnitId in " + parentOrgIds.toString());
                kSQL.append("    and frootid = (select FRootId from T_BG_BgScheme where FId = ?)");
                kSQL.append("    and FId <> ?");
                rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])new String[]{schemeId, schemeId});
                HashMap<String, String> parentOrg2SchemeMap = new HashMap<String, String>();
                while (rst.next()) {
                    parentOrgId = rst.getString("FOrgUnitId");
                    String parentSchemeId = rst.getString("FId");
                    parentOrg2SchemeMap.put(parentOrgId, parentSchemeId);
                }
                org2parentOrgSchemeMap.put(orgUnitId, parentOrg2SchemeMap);
            }
            conn = this.getConnection(ctx);
            StringBuffer updateBgDataSQL = new StringBuffer();
            updateBgDataSQL.append(" update T_BG_BgData ");
            updateBgDataSQL.append("    set FBizActual = FBizActual + ?");
            updateBgDataSQL.append("  where FOrgUnitId= ?");
            updateBgDataSQL.append("    and FBgSchemeId = ?");
            updateBgDataSQL.append("    and FFormula = ?");
            updateBgDataSta = conn.prepareStatement(updateBgDataSQL.toString());
            StringBuffer insertCtrlRecordSQL = new StringBuffer();
            insertCtrlRecordSQL.append(" insert into T_BG_BgCtrlRecord");
            insertCtrlRecordSQL.append("   (FId,");
            insertCtrlRecordSQL.append("    FCreatorId,");
            insertCtrlRecordSQL.append("    FCreateTime,");
            insertCtrlRecordSQL.append("    FLastUpdateUserId,");
            insertCtrlRecordSQL.append("    FLastUpdateTime,");
            insertCtrlRecordSQL.append("    FControlUnitId,");
            insertCtrlRecordSQL.append("    FBgDataId,");
            insertCtrlRecordSQL.append("    FBillId,");
            insertCtrlRecordSQL.append("    FBillName,");
            insertCtrlRecordSQL.append("    FBillNumber,");
            insertCtrlRecordSQL.append("    FBillAlias,");
            insertCtrlRecordSQL.append("    FBillType,");
            insertCtrlRecordSQL.append("    FBizDate,");
            insertCtrlRecordSQL.append("    FActualAmount,");
            insertCtrlRecordSQL.append("    FBillOperate,");
            insertCtrlRecordSQL.append("    FBgPeriodId,");
            insertCtrlRecordSQL.append("    FItemName,");
            insertCtrlRecordSQL.append("    FBgTraceType,");
            insertCtrlRecordSQL.append("    FOrgUnitId,");
            insertCtrlRecordSQL.append("    FBgSchemeId,");
            insertCtrlRecordSQL.append("    FItemFormula,");
            insertCtrlRecordSQL.append("    FPayState,");
            insertCtrlRecordSQL.append("    FISCollected,");
            insertCtrlRecordSQL.append("    FDayDate,");
            insertCtrlRecordSQL.append("    FActualType)");
            insertCtrlRecordSQL.append(" values (newbosid('FF6153C2'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            insertCtrlRecordSta = conn.prepareStatement(insertCtrlRecordSQL.toString());
            StringBuffer updateCtrlRecordSQL = new StringBuffer();
            updateCtrlRecordSQL.append(" update T_BG_BgCtrlRecord");
            updateCtrlRecordSQL.append("    set FBgDataId = (select FId");
            updateCtrlRecordSQL.append("                         from T_BG_BgData");
            updateCtrlRecordSQL.append("                        where FOrgUnitId = ?");
            updateCtrlRecordSQL.append("                          and FBgSchemeId = ?");
            updateCtrlRecordSQL.append("                          and FFormula = ?");
            updateCtrlRecordSQL.append("                        )");
            updateCtrlRecordSQL.append("  where FBillId = ?");
            updateCtrlRecordSQL.append("    and FOrgUnitId = ?");
            updateCtrlRecordSQL.append("    and FBgSchemeId = ?");
            updateCtrlRecordSQL.append("    and FItemFormula = ?");
            updateCtrlRecordSta = conn.prepareStatement(updateCtrlRecordSQL.toString());
            StringBuffer deleteKSQL = new StringBuffer();
            deleteKSQL.append(" delete T_BG_BgCtrlRecord");
            deleteKSQL.append("  where not exists (select *");
            deleteKSQL.append("           from T_Bg_BgData");
            deleteKSQL.append("          where FOrgUnitId = T_BG_BgCtrlRecord.FOrgUnitId");
            deleteKSQL.append("            and FBgSchemeId = T_BG_BgCtrlRecord.FBgSchemeId");
            deleteKSQL.append("            and FFormula = T_BG_BgCtrlRecord.FItemFormula)");
            deleteKSQL.append("    and FOrgUnitId is not null");
            deleteKSQL.append("    and FBgSchemeId is not null");
            deleteKSQL.append("    and FItemFormula is not null");
            BgCtrlRecordCollection ctrlRecordCol = new BgCtrlRecordCollection();
            int batchCounter = 0;
            boolean isRunUpdate = false;
            for (int i2 = 0; i2 < ctrlResultCol.size(); ++i2) {
                String orgUnitId;
                Map parentOrg2SchemeMap;
                BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i2);
                if (!BgActualBillControllerBean.isCanCollect(ctrlResultInfo) || BudgetCtrlUtil.isEmpty((Object)(parentOrg2SchemeMap = (Map)org2parentOrgSchemeMap.get(orgUnitId = ctrlResultInfo.getOrgUnitId())))) continue;
                String formula = ctrlResultInfo.getBgItemFormula();
                BigDecimal actualValue = ctrlResultInfo.getReqAmount();
                for (String orgId : parentOrg2SchemeMap.keySet()) {
                    String schemeId = (String)parentOrg2SchemeMap.get(orgId);
                    updateBgDataSta.setBigDecimal(1, actualValue);
                    updateBgDataSta.setString(2, orgId);
                    updateBgDataSta.setString(3, schemeId);
                    updateBgDataSta.setString(4, formula);
                    updateBgDataSta.addBatch();
                    BgCtrlRecordInfo ctrlRecordInfo = new BgCtrlRecordInfo();
                    ctrlRecordInfo.setBgDataId(null);
                    ctrlRecordInfo.setBillId(ctrlResultInfo.getBillId());
                    ctrlRecordInfo.setBillNumber(ctrlResultInfo.getBillNumber());
                    ctrlRecordInfo.setBillName(ctrlResultInfo.getBillNumber());
                    ctrlRecordInfo.setBillAlias(ctrlResultInfo.getBillType());
                    ctrlRecordInfo.setBillType(BgActualBillControllerBean.getTypeAllias(ctrlResultInfo.getBillType(), BgTraceTypeEnum.SumFromLower));
                    ctrlRecordInfo.setBizDate(ctrlResultInfo.getBizDate());
                    ctrlRecordInfo.setActualAmount(ctrlResultInfo.getReqAmount());
                    ctrlRecordInfo.setItemName(ctrlResultInfo.getItemCombinName());
                    ctrlRecordInfo.setBgPeriodId(ctrlResultInfo.getBgPeriodNumber());
                    ctrlRecordInfo.setOrgUnitId(orgId);
                    ctrlRecordInfo.setBgSchemeId(schemeId);
                    ctrlRecordInfo.setItemFormula(formula);
                    ctrlRecordInfo.setBgTraceType(BgTraceTypeEnum.SumFromLower);
                    ctrlRecordInfo.setIsCollected(true);
                    ctrlRecordInfo.setActualType(ctrlResultInfo.getActualType());
                    ctrlRecordCol.add(ctrlRecordInfo);
                    insertCtrlRecordSta.setString(1, userId);
                    insertCtrlRecordSta.setDate(2, time);
                    insertCtrlRecordSta.setString(3, userId);
                    insertCtrlRecordSta.setDate(4, time);
                    insertCtrlRecordSta.setString(5, ctrlRecordInfo.getOrgUnitId());
                    insertCtrlRecordSta.setString(6, ctrlRecordInfo.getBgDataId());
                    insertCtrlRecordSta.setString(7, ctrlRecordInfo.getBillId());
                    insertCtrlRecordSta.setString(8, ctrlRecordInfo.getBillName());
                    insertCtrlRecordSta.setString(9, ctrlRecordInfo.getBillNumber());
                    insertCtrlRecordSta.setString(10, ctrlRecordInfo.getBillAlias());
                    insertCtrlRecordSta.setString(11, ctrlRecordInfo.getBillType());
                    insertCtrlRecordSta.setDate(12, ctrlRecordInfo.getBizDate() != null ? new Date(ctrlRecordInfo.getBizDate().getTime()) : null);
                    insertCtrlRecordSta.setBigDecimal(13, ctrlRecordInfo.getActualAmount());
                    insertCtrlRecordSta.setString(14, ctrlRecordInfo.getBillOperate());
                    insertCtrlRecordSta.setString(15, ctrlRecordInfo.getBgPeriodId());
                    insertCtrlRecordSta.setString(16, ctrlRecordInfo.getItemName());
                    insertCtrlRecordSta.setInt(17, ctrlRecordInfo.getBgTraceType().getValue());
                    insertCtrlRecordSta.setString(18, ctrlRecordInfo.getOrgUnitId());
                    insertCtrlRecordSta.setString(19, ctrlRecordInfo.getBgSchemeId());
                    insertCtrlRecordSta.setString(20, ctrlRecordInfo.getItemFormula());
                    insertCtrlRecordSta.setInt(21, 0);
                    insertCtrlRecordSta.setInt(22, ctrlRecordInfo.isIsCollected() ? 1 : 0);
                    insertCtrlRecordSta.setDate(23, ctrlRecordInfo.getBizDate() != null ? new Date(ctrlRecordInfo.getBizDate().getTime()) : null);
                    if (BudgetCtrlState.isOccupation((BudgetCtrlState)state)) {
                        insertCtrlRecordSta.setInt(24, 10);
                    } else if (ctrlRecordInfo.getActualType() != null) {
                        insertCtrlRecordSta.setInt(24, ctrlRecordInfo.getActualType().getValue());
                    } else {
                        insertCtrlRecordSta.setInt(24, 20);
                    }
                    insertCtrlRecordSta.addBatch();
                    updateCtrlRecordSta.setString(1, orgId);
                    updateCtrlRecordSta.setString(2, schemeId);
                    updateCtrlRecordSta.setString(3, formula);
                    updateCtrlRecordSta.setString(4, ctrlResultInfo.getBillId());
                    updateCtrlRecordSta.setString(5, orgId);
                    updateCtrlRecordSta.setString(6, schemeId);
                    updateCtrlRecordSta.setString(7, formula);
                    updateCtrlRecordSta.addBatch();
                    if (!isRunUpdate) {
                        isRunUpdate = true;
                    }
                    if (++batchCounter < 200) continue;
                    updateBgDataSta.executeBatch();
                    insertCtrlRecordSta.executeBatch();
                    updateCtrlRecordSta.executeBatch();
                    batchCounter = 0;
                }
            }
            if (isRunUpdate) {
                if (batchCounter != 0) {
                    updateBgDataSta.executeBatch();
                    insertCtrlRecordSta.executeBatch();
                    updateCtrlRecordSta.executeBatch();
                }
                DbUtil.execute((Context)ctx, (String)deleteKSQL.toString());
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Throwable)ex);
                catch (Exception ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                SQLUtils.cleanup(updateBgDataSta);
                SQLUtils.cleanup(insertCtrlRecordSta);
                SQLUtils.cleanup(updateCtrlRecordSta);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)updateBgDataSta);
        SQLUtils.cleanup((Statement)insertCtrlRecordSta);
        SQLUtils.cleanup((Statement)updateCtrlRecordSta);
        SQLUtils.cleanup((Connection)conn);
        this.updateUpperOrgUpperItemCtrlData(ctx, state, ctrlResultCol, org2parentOrgSchemeMap);
    }

    private void updateUpperOrgUpperItemCtrlData(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, Map org2parentOrgSchemeMap) throws BOSException, EASBizException {
        if (ctrlResultCol == null || ctrlResultCol.size() == 0) {
            return;
        }
        IBgItem iBgItem = BgItemFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (!BgActualBillControllerBean.isCanCollect(ctrlResultInfo)) continue;
            BigDecimal actualValue = ctrlResultInfo.getReqAmount();
            String formula = ctrlResultInfo.getBgItemFormula();
            String orgUnitId = ctrlResultInfo.getOrgUnitId();
            Map parentOrg2SchemeMap = (Map)org2parentOrgSchemeMap.get(orgUnitId);
            if (BudgetCtrlUtil.isEmpty((Object)parentOrg2SchemeMap)) continue;
            for (String orgId : parentOrg2SchemeMap.keySet()) {
                String schemeId = (String)parentOrg2SchemeMap.get(orgId);
                iBgItem.updateBgItemSuperiorValue(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, actualValue);
                iBgItem.updateBgItemSuperiorCtrlRecord(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, ctrlResultInfo, state == null ? null : state.getCategory());
            }
        }
    }

    static boolean isCanCollect(BgCtrlResultInfo ctrlResultInfo) {
        if (ctrlResultInfo == null) {
            return false;
        }
        return ctrlResultInfo.getOrgUnitId() != null && ctrlResultInfo.getBgSchemeId() != null && ctrlResultInfo.getBgDataId() != null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map getAllParentOrgMap(Context ctx, Map orgUnitMap) throws EASBizException, BOSException {
        HashMap orgId2parentOrgMap = new HashMap();
        if (BudgetCtrlUtil.isEmpty((Object)orgUnitMap)) {
            return orgId2parentOrgMap;
        }
        Set orgUnitSet = orgUnitMap.keySet();
        StringBuffer kSQL = new StringBuffer();
        kSQL.append("select a.FId as costCenterId,");
        kSQL.append("       b.FId as parentId,");
        kSQL.append("       b.FNumber as parentNumber,");
        kSQL.append("       b.FName_" + ctx.getLocale() + " as parentName");
        kSQL.append("  from T_ORG_CostCenter a,");
        kSQL.append("       T_ORG_CostCenter b");
        kSQL.append(" where a.FID in " + BgHelper.tranSet2String(orgUnitSet));
        kSQL.append("   and (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) ");
        kSQL.append(" order by a.FLongNumber desc, b.flongnumber desc");
        IRowSet rst = null;
        try {
            for (String orgUnitId : orgUnitSet) {
                orgId2parentOrgMap.put(orgUnitId, new ArrayList());
            }
            rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString());
            while (rst.next()) {
                String ccid = rst.getString("costCenterId");
                String parentId = rst.getString("parentId");
                String parentNumber = rst.getString("parentNumber");
                String parentName = rst.getString("parentName");
                CostCenterOrgUnitInfo ccInfo = new CostCenterOrgUnitInfo();
                ccInfo.setId(BOSUuid.read((String)parentId));
                ccInfo.setNumber(parentNumber);
                ccInfo.setName(parentName);
                List tmp = (List)orgId2parentOrgMap.get(ccid);
                tmp.add(ccInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Throwable)ex);
                catch (Exception ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgId2parentOrgMap;
    }

    static String getTypeAllias(String billType, BgTraceTypeEnum traceType) {
        if (BudgetCtrlUtil.isEmpty((Object)billType)) {
            return "";
        }
        if (traceType == null) {
            return billType;
        }
        if (traceType == BgTraceTypeEnum.Bill) {
            return billType;
        }
        return billType + "\uff08" + traceType.getAlias() + "\uff09";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectValue _getBudgetData(Context ctx, BOSUuid orgUnit, BOSUuid bgScheme, BOSUuid bgForm, String formula) throws BOSException, EASBizException {
        BgDataInfo data = null;
        BigDecimal value = BgConstants.BIGZERO;
        if (orgUnit == null) return data;
        if (bgScheme == null) return data;
        if (formula == null) {
            return data;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer("select FBgValue ,fiscontrol,fisflexible,fflexparam,fctrltype,fisgroupctrl, fgroupno, fIsAllowAccess  from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FBgFormId = ? and FFormula = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnit.toString());
            pstmt.setString(2, bgScheme.toString());
            pstmt.setString(3, bgForm.toString());
            pstmt.setString(4, formula);
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                throw new BgAdjustException(BgAdjustException.NOFORMULA, (Object[])new String[]{formula});
            }
            value = rst.getBigDecimal(1);
            boolean isControl = rst.getBoolean(2);
            boolean isFlexible = rst.getBoolean(3);
            BigDecimal flexParam = rst.getBigDecimal(4) == null ? new BigDecimal(1.0) : rst.getBigDecimal(4);
            BgCtrlTypeEnum ctrlType = BgCtrlTypeEnum.getEnum((int)rst.getInt(5));
            boolean isGroupCtrl = rst.getBoolean(6);
            String groupNo = rst.getString(7) == null ? "-1" : rst.getString(7);
            boolean isAllowAccess = rst.getBoolean(8);
            data = new BgDataInfo();
            data.setBgValue(value);
            data.setIsControl(isControl);
            data.setIsFlexible(isFlexible);
            data.setFlexParam(flexParam);
            data.setCtrlType(ctrlType);
            data.setIsGroupCtrl(isGroupCtrl);
            data.setGroupNo(groupNo);
            data.setIsAllowAccess(isAllowAccess);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (BOSException ex3) {
                    logger.error((Object)ex3.getMessage());
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return data;
    }
}

