/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class BgCodeNumberNHelper {
    private static final Logger logger = Logger.getLogger(BgCodeNumberNHelper.class);

    public static boolean hasCodeNumber(Context ctx, IObjectValue model, String orgUnitId) {
        if (ctx == null || model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist(model, orgUnitId);
        }
        catch (Exception e) {
            logger.error((Object)"Code Number Error:", (Throwable)e);
        }
        return result;
    }

    public static boolean hasCodeNumber(Context ctx, IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberNHelper.hasCodeNumber(ctx, model, orgUnitId, property, null);
    }

    public static boolean hasCodeNumber(Context ctx, IObjectValue model, String orgUnitId, String property, String fieldName) {
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberNHelper.hasCodeNumber(ctx, model, orgUnitId);
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist(model, orgUnitId, property, BgCodeNumberNHelper.getParmCodingRule(fieldName));
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
        }
        return result;
    }

    public static boolean hasDisplayNumber(Context ctx, IObjectValue model, String orgUnitId) {
        boolean isAddView = false;
        if (ctx == null || model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId);
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static boolean hasDisplayNumber(Context ctx, IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberNHelper.hasDisplayNumber(ctx, model, orgUnitId, property, null);
    }

    public static boolean hasDisplayNumber(Context ctx, IObjectValue model, String orgUnitId, String property, String fieldName) {
        boolean isAddView = false;
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberNHelper.hasCodeNumber(ctx, model, orgUnitId);
        }
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId, property, BgCodeNumberNHelper.getParmCodingRule(fieldName));
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId, String property) throws EASBizException {
        BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId, property, null);
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId, String property, String fieldName) throws EASBizException {
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = "number";
        }
        if (!StringUtils.isEmpty((String)model.getString(fieldName))) {
            return;
        }
        if (StringUtils.isEmpty((String)property)) {
            BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId);
        } else {
            if (ctx == null || model == null) {
                return;
            }
            boolean hasProperty = false;
            String number = model.getString(fieldName);
            ICodingRuleManager codingRuleManager = null;
            ParmCodingRule pcr = BgCodeNumberNHelper.getParmCodingRule(fieldName);
            try {
                codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                CodingRuleInfo cri = codingRuleManager.getCodingRule(model, orgUnitId, property, pcr);
                if (cri != null) {
                    hasProperty = true;
                } else {
                    cri = codingRuleManager.getCodingRule(model, orgUnitId);
                }
                if (!hasProperty) {
                    BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId);
                } else {
                    if (cri != null) {
                        number = codingRuleManager.getNumber(model, cri);
                    }
                    if (StringUtils.isEmpty((String)number)) {
                        number = "Bg-" + System.currentTimeMillis();
                    }
                    if (!StringUtils.isEmpty((String)number)) {
                        model.setString(fieldName, number);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Code Number Error:", (Throwable)ex);
                throw new BgException(BgException.NUMBERMANAGERERROR);
            }
        }
    }

    private static ParmCodingRule getParmCodingRule(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || "number".equals(fieldName)) {
            return null;
        }
        ParmCodingRule pcr = new ParmCodingRule();
        pcr.setCustomProperty(fieldName);
        return pcr;
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId) throws EASBizException {
        if (ctx == null || model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        if (!StringUtils.isEmpty((String)model.getString("number"))) {
            return;
        }
        boolean hasCode = true;
        boolean hasAddNewShow = false;
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            hasCode = codingRuleManager.isExist(model, orgUnitId);
            if (hasCode) {
                hasAddNewShow = codingRuleManager.isAddView(model, orgUnitId);
            }
            if (hasCode) {
                if (codingRuleManager.isUseIntermitNumber(model, orgUnitId)) {
                    number = codingRuleManager.getNonbreakNumber(model, orgUnitId);
                } else {
                    number = codingRuleManager.getNumber(model, orgUnitId);
                    if (StringUtils.isEmpty((String)number)) {
                        number = "Bg-" + System.currentTimeMillis();
                    }
                }
            } else {
                number = model.getString("number");
                if (StringUtils.isEmpty((String)number)) {
                    number = "Bg-" + System.currentTimeMillis();
                }
            }
            if (!StringUtils.isEmpty((String)number)) {
                model.setString("number", number);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void recycleNumber(Context ctx, IObjectValue model, String orgUnitId, String number) throws EASBizException {
        if (ctx == null || model == null || StringUtils.isEmpty((String)number)) {
            return;
        }
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist(model, orgUnitId) && codingRuleManager.isUseIntermitNumber(model, orgUnitId)) {
                codingRuleManager.recycleNumber(model, orgUnitId, number);
            }
        }
        catch (Exception ex) {
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void recycleNumber(Context ctx, IObjectValue model, String orgUnitId, String number, String property) throws EASBizException {
        if (StringUtils.isEmpty((String)property)) {
            BgCodeNumberNHelper.recycleNumber(ctx, model, orgUnitId, number);
        } else {
            if (ctx == null || model == null || StringUtils.isEmpty((String)number)) {
                return;
            }
            ICodingRuleManager codingRuleManager = null;
            try {
                codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                boolean hasCode = codingRuleManager.isExist(model, orgUnitId, property);
                if (hasCode) {
                    if (codingRuleManager.isUseIntermitNumber(model, orgUnitId, property)) {
                        codingRuleManager.recycleNumber(model, orgUnitId, property, null, number);
                    }
                } else {
                    BgCodeNumberNHelper.recycleNumber(ctx, model, orgUnitId, number);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Code Number Error:", (Throwable)ex);
                throw new BgException(BgException.NUMBERMANAGERERROR);
            }
        }
    }
}

