/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.nbudget.BgCourseCommentInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgCourseCommentControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class BgCourseCommentControllerBean
extends AbstractBgCourseCommentControllerBean {
    private static final long serialVersionUID = 967593058380455862L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgCourseCommentControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _batchAddnew(Context ctx, List model) throws BOSException, EASBizException {
        if (model == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (model.isEmpty()) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        BgCourseCommentInfo info = null;
        String _bgFormId = null;
        String _userId = null;
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BG_BgCourseComment (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FState, FBgFormId, FComment) values(?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int in = model.size();
            for (int i = 0; i < in; ++i) {
                info = (BgCourseCommentInfo)model.get(i);
                _bgFormId = info.getBgFormId();
                _userId = info.getCreator().getId().toString();
                pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                pstmt.setString(2, _userId);
                pstmt.setTimestamp(3, _timestamp);
                pstmt.setString(4, _userId);
                pstmt.setTimestamp(5, _timestamp);
                pstmt.setString(6, null);
                if (info.getState() != null) {
                    pstmt.setInt(7, info.getState().getValue());
                } else {
                    pstmt.setInt(7, 4);
                }
                pstmt.setString(8, _bgFormId);
                pstmt.setString(9, info.getComment());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

