/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BGTEMPLATE_STATUS_Enum;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgDBUtils;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTypeInfo;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.IResultReader;
import com.kingdee.eas.ma.nbudget.app.AbstractBgCourseFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCourseFacadeControllerBean
extends AbstractBgCourseFacadeControllerBean {
    private static final long serialVersionUID = 497115466766338585L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgCourseFacadeControllerBean");
    private static final String PERMISSION_STR = "bg_course01_list";

    @Override
    protected List _queryCourseInfo(Context ctx, Map parameter, boolean isSelectAllOrgUnit) throws BOSException, EASBizException {
        boolean isImmOrgUnit;
        if (ctx == null || parameter == null || parameter.isEmpty()) {
            return null;
        }
        boolean isPermissionUsed = BgSHelper.isBgPermissionUsed((Context)ctx);
        String curUserID = (String)parameter.get("CURR_USER_ID");
        String curOrgID = (String)parameter.get("CURR_ORGUNIT_ID");
        String curCtrlOrgID = (String)parameter.get("CURR_CTRLORGUNIT_ID");
        String selectOrgID = (String)parameter.get("SEL_ORGUNIT_ID");
        Integer selectOrgType = (Integer)parameter.get("SEL_ORGUNIT_TYPE");
        String[] selectSchemeIDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] selectPeriodIDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] selectCurrencyIDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] selectTemplateIDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        Map sortTypeMap = (Map)parameter.get("SORT_TYPE_MAP");
        ArrayList<Map<String, Object>> _reList = new ArrayList<Map<String, Object>>();
        HashSet<String> queryOrgIds = new HashSet<String>();
        HashSet<Integer> _state = new HashSet<Integer>();
        HashMap<String, String> _bgFormAtt = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = this.bgFormSelectorItem();
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        HashSet<String> bgSchemeIdsSet = new HashSet<String>();
        this.copyArrayToSet(bgSchemeIdsSet, selectSchemeIDS);
        HashSet<String> bgTemplateIdsSet = new HashSet<String>();
        this.copyArrayToSet(bgTemplateIdsSet, selectTemplateIDS);
        HashSet<String> bgPeriodIdsSet = new HashSet<String>();
        this.copyArrayToSet(bgPeriodIdsSet, selectPeriodIDS);
        HashSet<String> currnecyIdsSet = new HashSet<String>();
        this.copyArrayToSet(currnecyIdsSet, selectCurrencyIDS);
        _state.add(new Integer(15));
        _state.add(new Integer(5));
        _state.add(new Integer(4));
        _state.add(new Integer(35));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootId", bgSchemeIdsSet, CompareType.INCLUDE));
        boolean isTemplateIdsEmpty = EmptyUtil.isEmpty(bgTemplateIdsSet);
        if (!isTemplateIdsEmpty) {
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.rootId", bgTemplateIdsSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", bgPeriodIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", currnecyIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", _state, CompareType.NOTINCLUDE));
        boolean bl = isImmOrgUnit = selectOrgType == 2;
        if (selectOrgType == 1) {
            if (this.verifyPermission(ctx, curUserID, selectOrgID)) {
                queryOrgIds.add(selectOrgID);
            }
        } else if (isImmOrgUnit || selectOrgType == 3) {
            queryOrgIds = this.queryImmOrgUnit(ctx, selectOrgID, isImmOrgUnit, isSelectAllOrgUnit);
            queryOrgIds = this.verifyPermission(ctx, curCtrlOrgID, curUserID, queryOrgIds);
        }
        if (queryOrgIds.isEmpty()) {
            return null;
        }
        String tmpOrgTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            tmpOrgTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + "(FID) values (?)"), queryOrgIds);
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)("select FID from " + tmpOrgTable), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"BV/FQwEUEADgABtLwKgSXv9s2OA=", CompareType.NOTEQUALS));
            if (!isTemplateIdsEmpty) {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and (#6 or #7)");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6 )");
            }
            if (isPermissionUsed) {
                BgPermissionHelper.addBgFormPermission(ctx, curUserID, queryOrgIds, filter);
            }
            view.setFilter(filter);
            this.addSortItem(view, sortTypeMap);
            Map<String, Map<String, BgSchemeInfo>> bgSchemeMap = this.queryBgSchemeInfo(ctx, curUserID, tmpOrgTable, bgSchemeIdsSet, isPermissionUsed);
            Map<String, Map<String, BgTemplateInfo>> bgTemplateMap = this.queryBgTemplateInfo(ctx, curUserID, tmpOrgTable, bgSchemeIdsSet, bgTemplateIdsSet, isPermissionUsed, isSelectAllOrgUnit);
            BgPeriodCollection bgPeriodCol = this.queryBgPeriod(ctx, bgPeriodIdsSet);
            CurrencyCollection currencyCol = this.queryCurrency(ctx, currnecyIdsSet);
            Map<String, BgFormInfo> _bgFormMap = this.queryBgFormFromDB(ctx, view, _bgFormAtt);
            Map<String, Object[]> keyMap = this.getKeyMap(queryOrgIds, bgSchemeMap, bgTemplateMap, bgPeriodCol, currencyCol, _bgFormMap);
            _reList.add(_bgFormMap);
            _reList.add(_bgFormAtt);
            _reList.add(keyMap);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (pool != null && tmpOrgTable != null) {
                try {
                    pool.releaseTable(tmpOrgTable);
                }
                catch (Exception exception) {}
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return _reList;
    }

    protected void addSortItem(EntityViewInfo view, Map<String, SortType> sortTypeMap) {
        if (view == null) {
            return;
        }
        String fieldName = "number";
        SortType sortType = SortType.ASCEND;
        if (!EmptyUtil.isEmpty(sortTypeMap)) {
            for (Map.Entry<String, SortType> entry : sortTypeMap.entrySet()) {
                fieldName = entry.getKey();
                sortType = entry.getValue();
            }
        }
        view.setSorter(new SorterItemCollection());
        SorterItemInfo sort = new SorterItemInfo(fieldName);
        sort.setSortType(sortType);
        view.getSorter().add(sort);
    }

    protected void copyArrayToSet(Set<String> set, String[] array) {
        if (array != null) {
            int in = array.length;
            for (int i = 0; i < in; ++i) {
                if (array[i] == null) continue;
                set.add(array[i].toString());
            }
        }
    }

    private Map<String, BgFormInfo> queryBgFormFromDB(Context ctx, EntityViewInfo view, Map<String, String> _bgFormAtt) throws BOSException, EASBizException {
        LinkedHashMap<String, BgFormInfo> _bgFormMap = new LinkedHashMap<String, BgFormInfo>();
        if (view == null || _bgFormAtt == null) {
            return _bgFormMap;
        }
        BgFormInfo bgFormInfo2 = null;
        BgFormCollection bgFormColl = null;
        StringBuffer _key = null;
        try {
            bgFormColl = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(view);
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < bgFormColl.size(); ++i) {
                ids.add(bgFormColl.get(i).getId().toString());
            }
            Map<String, String> bgformattach = this._queryHasAttach(ctx, ids);
            String bgItemGroupId = null;
            String bgItemId = null;
            boolean isNull = false;
            if (bgFormColl != null) {
                for (BgFormInfo bgFormInfo2 : bgFormColl) {
                    _key = this.getKey(bgFormInfo2);
                    if (bgFormInfo2.getBgTemplate().getFormType().getValue() == 3) {
                        isNull = bgFormInfo2.getBgItemGroup() == null || bgFormInfo2.getBgItemGroup().getId() == null;
                        bgItemGroupId = isNull ? "" : bgFormInfo2.getBgItemGroup().getId().toString();
                        isNull = bgFormInfo2.getBgItem() == null || bgFormInfo2.getBgItem().getId() == null;
                        bgItemId = isNull ? "" : bgFormInfo2.getBgItem().getId().toString();
                        _key.append("_").append(bgItemGroupId).append("_").append(bgItemId);
                    }
                    _bgFormMap.put(_key.toString(), bgFormInfo2);
                    if (!bgformattach.containsKey(bgFormInfo2.getId().toString())) continue;
                    _bgFormAtt.put(_key.toString(), bgformattach.get(bgFormInfo2.getId().toString()));
                }
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        finally {
            if (bgFormColl != null) {
                bgFormColl.clear();
            }
        }
        return _bgFormMap;
    }

    private StringBuffer getKey(BgFormInfo bgFormInfo) {
        StringBuffer key = new StringBuffer(bgFormInfo.getOrgUnit().getId().toString()).append("_").append(bgFormInfo.getBgScheme().getId().toString()).append("_").append(bgFormInfo.getBgTemplate().getId().toString()).append("_").append(bgFormInfo.getBgPeriod().getId().toString()).append("_").append(bgFormInfo.getCurrency().getId().toString());
        return key;
    }

    private StringBuffer getKey(String orgID, String bgSchemeID, String bgTemplateID, String bgPeriodID, String currencyID) {
        StringBuffer key = new StringBuffer(orgID).append("_").append(bgSchemeID).append("_").append(bgTemplateID).append("_").append(bgPeriodID).append("_").append(currencyID);
        return key;
    }

    protected Map<String, Object[]> getKeyMap(Set<String> orgIds, Map<String, Map<String, BgSchemeInfo>> bgSchemeMap, Map<String, Map<String, BgTemplateInfo>> bgTemplateMap, BgPeriodCollection bgPeriodCol, CurrencyCollection currencyCol, Map<String, BgFormInfo> _bgFormMap) {
        HashMap<String, Object[]> keyMap = new HashMap<String, Object[]>();
        Boolean isEmpty = EmptyUtil.isEmpty(orgIds) || EmptyUtil.isEmpty(bgSchemeMap) || EmptyUtil.isEmpty(bgTemplateMap) || EmptyUtil.isEmpty((AbstractObjectCollection)bgPeriodCol) || EmptyUtil.isEmpty((AbstractObjectCollection)currencyCol);
        if (isEmpty.booleanValue()) {
            return keyMap;
        }
        Map<String, List<String>> specialTmpMap = this.getSpecialTmpMap(_bgFormMap);
        Object[] tmpValue = null;
        String _orgId2 = null;
        String _bgSchemeId = null;
        String _bgTemplateId = null;
        StringBuffer _key = null;
        Map<String, BgSchemeInfo> _tmpScMap = null;
        Map<String, BgTemplateInfo> _tmpTmMap = null;
        List<String> extKey = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgTemplateInfo templateInfo = null;
        for (String _orgId2 : orgIds) {
            if (!bgSchemeMap.containsKey(_orgId2)) continue;
            _tmpScMap = bgSchemeMap.get(_orgId2);
            for (Map.Entry<String, BgSchemeInfo> _entrysc : _tmpScMap.entrySet()) {
                _bgSchemeId = _entrysc.getKey();
                bgSchemeInfo = _entrysc.getValue();
                if (!bgTemplateMap.containsKey(_bgSchemeId)) continue;
                _tmpTmMap = bgTemplateMap.get(_bgSchemeId);
                for (Map.Entry<String, BgTemplateInfo> _entrytm : _tmpTmMap.entrySet()) {
                    _bgTemplateId = _entrytm.getKey();
                    templateInfo = _entrytm.getValue();
                    int ips = bgPeriodCol.size();
                    for (int ip = 0; ip < ips; ++ip) {
                        bgPeriodInfo = bgPeriodCol.get(ip);
                        int ics = currencyCol.size();
                        for (int ic = 0; ic < ics; ++ic) {
                            currencyInfo = currencyCol.get(ic);
                            if (specialTmpMap.containsKey(_bgTemplateId)) {
                                extKey = specialTmpMap.get(_bgTemplateId);
                                int size = extKey.size();
                                for (int extKeyIndex = 0; extKeyIndex < size; ++extKeyIndex) {
                                    _key = this.getKey(_orgId2, _bgSchemeId, _bgTemplateId, bgPeriodInfo.getId().toString(), currencyInfo.getId().toString());
                                    _key.append(extKey.get(extKeyIndex));
                                    tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo, currencyInfo};
                                    keyMap.put(_key.toString(), tmpValue);
                                }
                                continue;
                            }
                            _key = this.getKey(_orgId2, _bgSchemeId, _bgTemplateId, bgPeriodInfo.getId().toString(), currencyInfo.getId().toString());
                            tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo, currencyInfo};
                            keyMap.put(_key.toString(), tmpValue);
                        }
                    }
                }
            }
        }
        return keyMap;
    }

    protected Map<String, List<String>> getSpecialTmpMap(Map<String, BgFormInfo> _bgFormMap) {
        HashMap<String, List<String>> specialTmpMap = new HashMap<String, List<String>>();
        if (EmptyUtil.isEmpty(specialTmpMap)) {
            return specialTmpMap;
        }
        List<String> extKey = null;
        String bgItemGroupId = null;
        String bgItemId = null;
        BgFormInfo bgFormInfo = null;
        String tempId = null;
        boolean isNull = false;
        Iterator<String> it = _bgFormMap.keySet().iterator();
        while (it.hasNext()) {
            bgFormInfo = _bgFormMap.get(it.next());
            if (bgFormInfo.getBgTemplate().getFormType().getValue() != 3) continue;
            tempId = bgFormInfo.getBgTemplate().getId().toString();
            isNull = bgFormInfo.getBgItemGroup() == null || bgFormInfo.getBgItemGroup().getId() == null;
            bgItemGroupId = isNull ? "" : bgFormInfo.getBgItemGroup().getId().toString();
            isNull = bgFormInfo.getBgItem() == null || bgFormInfo.getBgItem().getId() == null;
            bgItemId = isNull ? "" : bgFormInfo.getBgItem().getId().toString();
            extKey = specialTmpMap.containsKey(tempId) ? (List)specialTmpMap.get(tempId) : new ArrayList();
            extKey.add("_" + bgItemGroupId + "_" + bgItemId);
            specialTmpMap.put(tempId, extKey);
        }
        return specialTmpMap;
    }

    protected SelectorItemCollection bgFormSelectorItem() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("courseOrgId");
        sic.add("lastUpdateTime");
        sic.add("bgScheme.id");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.period");
        sic.add("bgScheme.formallyYearScheme");
        sic.add("bgScheme.state");
        sic.add("bgScheme.isSubmitByScheme");
        sic.add("bgScheme.isFiling");
        sic.add("bgScheme.isReportByScheme");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.rootId");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("bgItemGroup.id");
        sic.add("bgItem.id");
        sic.add("auditor.id");
        sic.add("auditor.name");
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<String> queryImmOrgUnit(Context ctx, String currOrgUnitId, boolean isImmOrgUnit, boolean isSelectAllOrgUnit) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currOrgUnitId)) {
            return new HashSet<String>();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        int _level = 0;
        String _number = null;
        String _longNumber = null;
        String _orgUnitId = null;
        String sql1 = "select FNumber, FLongNumber, FLevel from T_ORG_CostCenter where FID = ?";
        String sql2 = "select FID from T_ORG_CostCenter where FLongnumber like ? " + (isImmOrgUnit ? "and FLevel = ?" : "");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql1);
            pstmt.setString(1, BOSUuid.read((String)currOrgUnitId).toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitSet.add(currOrgUnitId);
                _number = rst.getString(1);
                _longNumber = rst.getString(2);
                _level = rst.getInt(3);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty(_number) && !StringUtils.isEmpty(_longNumber)) {
                pstmt = conn.prepareStatement(sql2);
                pstmt.setString(1, _longNumber + "!%");
                if (isImmOrgUnit) {
                    pstmt.setInt(2, _level + 1);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(1);
                    orgUnitSet.add(_orgUnitId);
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    if (isSelectAllOrgUnit) {
                        throw new BgException(BgFormException.TOOMUCHORG);
                    }
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set queryAllOrgUnit(Context ctx, String currOrgUnitId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currOrgUnitId)) {
            return new HashSet();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        String _number = null;
        String _longNumber = null;
        String _orgUnitId = null;
        String sql1 = "select FNumber, FLongNumber from T_ORG_CostCenter where FID = ?";
        Object[] _numbers = null;
        StringBuffer sql = new StringBuffer("select FID from T_ORG_CostCenter where FLongnumber like ? ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql1);
            pstmt.setString(1, BOSUuid.read((String)currOrgUnitId).toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitSet.add(currOrgUnitId);
                _number = rst.getString(1);
                _longNumber = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty(_number) && !StringUtils.isEmpty(_longNumber) && (_numbers = _longNumber.split("!")) != null) {
                int in = _numbers.length;
                for (int i = 0; i < in; ++i) {
                    sql.append(" or FNumber = ? ");
                }
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, _longNumber + "!%");
                BgNSQLHelper.setParams(pstmt, 2, _numbers);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(1);
                    orgUnitSet.add(_orgUnitId);
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitSet;
    }

    protected Map<String, Map<String, BgSchemeInfo>> queryBgSchemeInfo(Context ctx, String userId, String tmpOrgTable, Set<String> bgSchemeRootIds, boolean _isBgPermissionUsed) throws BOSException, EASBizException {
        if (ctx == null || tmpOrgTable == null || bgSchemeRootIds == null) {
            return new HashMap<String, Map<String, BgSchemeInfo>>();
        }
        HashMap<String, Map<String, BgSchemeInfo>> _bgSchemeMap = new HashMap<String, Map<String, BgSchemeInfo>>();
        Map<String, BgSchemeInfo> _tmpMap = null;
        String _orgId = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("isFormal");
        sic.add("period");
        sic.add("formallyYearScheme");
        sic.add("state");
        sic.add("isSubmitByScheme");
        sic.add("isFiling");
        sic.add("isReportByScheme");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (_isBgPermissionUsed) {
            // empty if block
        }
        filter.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)("select fid from " + tmpOrgTable), CompareType.INNER));
        if (!bgSchemeRootIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("rootId", bgSchemeRootIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgSchemeCollection bgSchemeCol = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeCollection(view);
        BgSchemeInfo info = null;
        int j = bgSchemeCol.size();
        for (int i = 0; i < j; ++i) {
            info = bgSchemeCol.get(i);
            _orgId = info.getOrgUnit().getId().toString();
            if (_bgSchemeMap.containsKey(_orgId)) {
                _tmpMap = (Map)_bgSchemeMap.get(_orgId);
            } else {
                _tmpMap = new HashMap();
                _bgSchemeMap.put(_orgId, _tmpMap);
            }
            _tmpMap.put(info.getId().toString(), info);
        }
        return _bgSchemeMap;
    }

    protected Map<String, Map<String, BgTemplateInfo>> queryBgTemplateInfo(Context ctx, String userId, String tmpOrgTable, Set<String> bgSchemeRootIds, Set<String> bgTemplateIds, boolean isPermission, boolean isSelectAllOrgUnit) throws BOSException, EASBizException {
        if (ctx == null || userId == null || bgSchemeRootIds == null || tmpOrgTable == null || bgTemplateIds == null) {
            return new HashMap<String, Map<String, BgTemplateInfo>>();
        }
        HashMap<String, Map<String, BgTemplateInfo>> _bgTemplateMap = new HashMap<String, Map<String, BgTemplateInfo>>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map<String, BgTemplateInfo> tmpMap = null;
        BgTemplateInfo templateInfo = null;
        BgTypeInfo typeInfo = null;
        String _schemeId = null;
        String _tempId = null;
        String _tempNumber = null;
        String _tempName = null;
        String _roodID = null;
        String _bgTypeID = null;
        String _bgTypeNumber = null;
        String _bgTypeName = null;
        String _formType = null;
        String _templateStatus = null;
        StringBuffer sql = this.queryBgTemplateSql(ctx);
        if (tmpOrgTable != null) {
            sql.append(" and t.FOrgUnitId IN (select FID from " + tmpOrgTable + ")");
        }
        if (isPermission) {
            FilterInfo filter = new FilterInfo();
            String _query = filter.toString();
            _query = _query.replaceAll(" creator.id ", " t.FCreatorId ");
            if (!StringUtils.isEmpty((String)(_query = _query.replaceAll("\\(id", "\\(t.FID")))) {
                sql.append(" and " + _query);
            }
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _schemeId = rst.getString(1);
                _tempId = rst.getString(2);
                _tempName = rst.getString(3);
                _tempNumber = rst.getString(4);
                _formType = rst.getString(5);
                _templateStatus = rst.getString(6);
                _roodID = rst.getString(7);
                _bgTypeID = rst.getString(8);
                _bgTypeNumber = rst.getString(9);
                _bgTypeName = rst.getString(10);
                if (!EmptyUtil.isEmpty(bgTemplateIds) && !bgTemplateIds.contains(_roodID)) continue;
                if (_bgTemplateMap.containsKey(_schemeId)) {
                    tmpMap = (Map)_bgTemplateMap.get(_schemeId);
                } else {
                    tmpMap = new HashMap();
                    _bgTemplateMap.put(_schemeId, tmpMap);
                }
                templateInfo = new BgTemplateInfo();
                templateInfo.setId(BOSUuid.read((String)_tempId));
                templateInfo.setName(_tempName);
                templateInfo.setNumber(_tempNumber);
                if (!StringUtils.isEmpty((String)_formType)) {
                    templateInfo.setFormType(BgTemFormTypeEnum.getEnum((int)Integer.valueOf(_formType)));
                }
                if (!StringUtils.isEmpty((String)_templateStatus)) {
                    templateInfo.setTemplateStatus(BGTEMPLATE_STATUS_Enum.getEnum((int)Integer.valueOf(_templateStatus)));
                }
                typeInfo = new BgTypeInfo();
                if (!StringUtils.isEmpty((String)_bgTypeID)) {
                    typeInfo.setId(BOSUuid.read((String)_bgTypeID));
                    typeInfo.setName(_bgTypeName);
                    typeInfo.setNumber(_bgTypeNumber);
                }
                templateInfo.setBgType(typeInfo);
                tmpMap.put(_tempId, templateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                if (isSelectAllOrgUnit) {
                    throw new BgException(BgFormException.TOOMUCHTEMP);
                }
                throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _bgTemplateMap;
    }

    protected StringBuffer queryBgTemplateSql(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("select n.FBgSchemeId, n.FBgTemplateId, t.FName, t.FNumber,t.FFormType,t.FTemplateStatus , t.frootid , y.FID, y.FNumber, y.FName_").append(ctx.getLocale()).append(" from T_BG_BgSchemeNode n ").append(" left join T_BG_BgScheme s on n.FBgSchemeId = s.FID").append(" left join T_BG_BgTemplate t on n.FBgTemplateId = t.FID").append(" left join T_BG_BgType y on t.FBgTypeId = y.FID").append(" where (y.FID IS NULL or y.FID <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') ");
        return sql;
    }

    protected BgPeriodCollection queryBgPeriod(Context ctx, Set<String> bgPeriodIds) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodIds == null) {
            return new BgPeriodCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!bgPeriodIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", bgPeriodIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgPeriodCollection bgPeriodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
        return bgPeriodCol;
    }

    protected CurrencyCollection queryCurrency(Context ctx, Set<String> currencyIds) throws BOSException, EASBizException {
        if (ctx == null || currencyIds == null) {
            return new CurrencyCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!currencyIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", currencyIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        CurrencyCollection currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        return currencyCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _loadColorScheme(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Integer _state = null;
        String _color = null;
        HashMap<Integer, String> colorScheme = new HashMap<Integer, String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FState, FColor from T_BG_BgColorScheme");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _state = new Integer(rst.getInt(1));
                _color = rst.getString(2);
                colorScheme.put(_state, _color);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colorScheme;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveColorScheme(Context ctx, Map colorScheme) throws BOSException, EASBizException {
        if (colorScheme == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map.Entry _entry2222222 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BgColorScheme");
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("insert into T_BG_BgColorScheme (FState, FColor) values(?, ?)");
            for (Map.Entry _entry2222222 : colorScheme.entrySet()) {
                pstmt.setInt(1, (Integer)_entry2222222.getKey());
                pstmt.setString(2, (String)_entry2222222.getValue());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected IPermission getPermissionInterface(Context ctx) throws BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx);
    }

    protected boolean verifyPermission(Context ctx, String userId, String orgUnitId) throws BOSException, EASBizException {
        return this.getPermissionInterface(ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), PERMISSION_STR);
    }

    protected Set<String> verifyPermission(Context ctx, String ctrlUnitId, String userId, Set<String> orgUnitIdSet) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId) || orgUnitIdSet == null || orgUnitIdSet.isEmpty()) {
            return new HashSet<String>();
        }
        FullOrgUnitInfo _orgUnitInfo = null;
        FullOrgUnitCollection _orgUnitCol = null;
        HashSet<String> _orgUnitIdSet = new HashSet<String>();
        _orgUnitCol = this.getPermissionInterface(ctx).getAuthorizedOrgOfIncludeSubCU((IObjectPK)new ObjectUuidPK(ctrlUnitId), (IObjectPK)new ObjectUuidPK(userId), OrgType.CostCenter, null, PERMISSION_STR);
        if (_orgUnitCol != null && !_orgUnitCol.isEmpty()) {
            int in = _orgUnitCol.size();
            for (int i = 0; i < in; ++i) {
                _orgUnitInfo = _orgUnitCol.get(i);
                _orgUnitIdSet.add(_orgUnitInfo.getId().toString());
            }
        }
        orgUnitIdSet.retainAll(_orgUnitIdSet);
        return orgUnitIdSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _loadCause(Context ctx, String bgFormId, String formula) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId)) return null;
        if (StringUtils.isEmpty((String)formula)) {
            return null;
        }
        byte[] _byte = null;
        String _cause = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FCause from T_BG_BgCourseCause where FBgFormId = ? and FFormula = ?");
            pstmt.setString(1, bgFormId);
            pstmt.setString(2, formula);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _byte = BgInfoHelper.getBytes(rst, 1);
                _cause = (String)BgAnalyseHelper.getObject((byte[])_byte);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (IOException ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _cause;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveCause(Context ctx, String userId, String bgFormId, String formula, String cause) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId)) return;
        if (StringUtils.isEmpty((String)formula)) {
            return;
        }
        byte[] _byte = null;
        String _userId = null;
        Timestamp _Timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        _byte = BgAnalyseHelper.getBytes((Object)cause);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("SELECT FID FROM T_BG_BgCourseCause WHERE FBgFormId = ? and FFormula = ?");
            pstmt.setString(1, bgFormId);
            pstmt.setString(2, formula);
            rst = pstmt.executeQuery();
            boolean isExists = rst.next();
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!isExists) {
                pstmt = conn.prepareStatement("INSERT INTO T_BG_BgCourseCause(FID, FBgFormID, FFormula, FCreatorID, FCreatorTime, FLastUpdateUserId, FLastUpdateTime) (select FID, FBgFormId, FFormula, '" + _userId + "', NOW(), '" + _userId + "', NOW() from T_BG_BgData bgdata where bgdata.FBgFormId = ? and bgdata.FFormula = ?)");
                pstmt.setString(1, bgFormId);
                pstmt.setString(2, formula);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstmt = conn.prepareStatement("update T_BG_BgCourseCause set FCause = ?, FLastUpdateUserID = ?, FLastUpdateTime = ? where FBgFormId = ? and FFormula = ?");
            pstmt.setBytes(1, _byte);
            pstmt.setString(2, _userId);
            pstmt.setTimestamp(3, _Timestamp);
            pstmt.setString(4, bgFormId);
            pstmt.setString(5, formula);
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _viewDiffInfo(Context ctx, String bgFormId, String formula, Map value) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _formula = null;
        BigDecimal _oldValue = null;
        BigDecimal _newValue = null;
        ArrayList<List<String>> _reList = new ArrayList<List<String>>();
        List<String> _diffInfo = null;
        Date _date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, Object> _bgItemMap = new HashMap<String, Object>();
        BgFormInfo formInfo = BgInfoHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormId), false);
        boolean hasFormula = !StringUtils.isEmpty((String)formula);
        VisualItemInfo _visInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select i.FKey, e.FName_" + ctx.getLocale() + ", p.FName_" + ctx.getLocale() + ", c.FBValue, d.FBgValue, d.FBgValue - c.FBValue, u.fname_l2, c.flastupdatetime, c.Fformula").append(" from T_BG_BgCourseData c ").append(" left join T_BG_BgData d on c.FBgFormId = d.FBgFormId and c.FFormula = d.FFormula ").append(" left join T_BG_BgItemcombination i on d.fbgitemcombinid = i.FID ").append(" left join T_BG_BgElement e on d.FBgElementId = e.FID ").append(" left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append(" left join T_PM_User u on c.FLastUpdateUserId = u.FID ").append(" where c.FBgFormId = ? ").append(hasFormula ? " and c.FFormula = ? " : "");
        sql.append(" and c.FBValue <> d.FBgValue");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId);
            if (hasFormula) {
                pstmt.setString(2, formula);
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _formula = rst.getString(9);
                if (value != null && !value.isEmpty()) {
                    if (!value.containsKey(_formula)) continue;
                    _newValue = (BigDecimal)value.get(_formula);
                    _oldValue = rst.getBigDecimal(4);
                    if (_oldValue.compareTo(_newValue) == 0) continue;
                    _diffInfo = new ArrayList();
                    _diffInfo.add(rst.getString(1));
                    _bgItemMap.put(rst.getString(1), null);
                    _diffInfo.add(rst.getString(2));
                    _diffInfo.add(rst.getString(3));
                    _diffInfo.add(BgPastSourceEnum.COURSE.getAlias());
                    _diffInfo.add((String)((Object)rst.getBigDecimal(4)));
                    _diffInfo.add((String)((Object)_newValue));
                    _diffInfo.add((String)((Object)_newValue.subtract(_oldValue)));
                    _diffInfo.add(rst.getString(7));
                    _date = rst.getDate(8);
                    _diffInfo.add(_date != null ? sdf.format(_date) : null);
                    _diffInfo.add(null);
                    _diffInfo.add(null);
                    _reList.add(_diffInfo);
                    continue;
                }
                _diffInfo = new ArrayList<String>();
                _diffInfo.add(rst.getString(1));
                _bgItemMap.put(rst.getString(1), null);
                _diffInfo.add(rst.getString(2));
                _diffInfo.add(rst.getString(3));
                _diffInfo.add(BgPastSourceEnum.COURSE.getAlias());
                _diffInfo.add((String)((Object)rst.getBigDecimal(4)));
                _diffInfo.add((String)((Object)rst.getBigDecimal(5)));
                _diffInfo.add((String)((Object)rst.getBigDecimal(6)));
                _diffInfo.add(rst.getString(7));
                _date = rst.getDate(8);
                _diffInfo.add(_date != null ? sdf.format(_date) : null);
                _diffInfo.add(null);
                _diffInfo.add(null);
                _reList.add(_diffInfo);
            }
            if (formInfo != null && formInfo.getOrgUnit() != null && formInfo.getOrgUnit().getId() != null && (_bgItemMap = BgSHelper.getBgItemsInfo((Context)ctx, _bgItemMap, null, null, (Object)formInfo.getOrgUnit().getId().toString())) != null && !_bgItemMap.isEmpty()) {
                int in = _reList.size();
                for (int i = 0; i < in; ++i) {
                    _diffInfo = (List)_reList.get(i);
                    try {
                        _visInfo = BgSHelper.getBgItemCombinInfo((Context)ctx, (String)((String)_diffInfo.get(0)), _bgItemMap, (String)formInfo.getOrgUnit().getId().toString());
                        if (_visInfo == null) continue;
                        _diffInfo.set(0, _visInfo.getNumber() + "_" + _visInfo.getName());
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryOrgInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        int in;
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) {
            return new HashMap();
        }
        boolean _isBgPermissionUsed = BgSHelper.isBgPermissionUsed((Context)ctx);
        String CURR_USER_ID = (String)parameter.get("CURR_USER_ID");
        String CURR_CTRLORGUNIT_ID = (String)parameter.get("CURR_CTRLORGUNIT_ID");
        String SEL_ORGUNIT_ID = (String)parameter.get("SEL_ORGUNIT_ID");
        Integer SEL_ORGUNIT_TYPE = (Integer)parameter.get("SEL_ORGUNIT_TYPE");
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        Set<Object> _queryOrgUnitIds = new HashSet<String>();
        if (SEL_ORGUNIT_TYPE == 1) {
            if (this.verifyPermission(ctx, CURR_USER_ID, SEL_ORGUNIT_ID)) {
                _queryOrgUnitIds.add(SEL_ORGUNIT_ID);
            }
        } else if (SEL_ORGUNIT_TYPE == 2) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, true, true);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, false, true);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        }
        if (_queryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        HashMap _dataMap = new HashMap();
        Map<Integer, BigDecimal> _tmpMap = null;
        int _state = 0;
        int _count = 0;
        Object _obj2222222 = null;
        String _id2222222 = null;
        String _orgUnitId = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FOrgUnitId, f.FState, count(f.FID) from T_BG_BgForm f ").append("left join T_BG_BgScheme s on f.Fbgschemeid = s.fid ").append("left join T_BG_BgTemplate t on f.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') ").append("and f.FOrgUnitId IN (");
        for (Object _obj2222222 : _queryOrgUnitIds) {
            if (_obj2222222 == null) continue;
            sql.append("?,");
            _tmpList.add(_obj2222222.toString());
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") ");
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FRootId IN (");
            in = SEL_BGSCHEME_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGSCHEME_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGTEMPLATE_IDS != null && SEL_BGTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            in = SEL_BGTEMPLATE_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGTEMPLATE_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String _id2222222 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            for (String _id2222222 : SEL_CURRENCY_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (_isBgPermissionUsed) {
            FilterInfo filter = new FilterInfo();
            filter = BgPermissionHelper.addBgFormPermission(ctx, CURR_USER_ID, _queryOrgUnitIds, filter);
            String _query = filter.toString();
            _query = _query.replaceAll("bgtemplate.id", "t.FID");
            _query = _query.replaceAll("bgscheme.id", "s.FID");
            _query = _query.replaceAll(" creator.id ", " t.FCreatorId ");
            if (!StringUtils.isEmpty((String)(_query = _query.replaceAll("\\(id", "\\(t.FID")))) {
                sql.append(" and " + _query);
            }
        }
        sql.append(" group by f.FOrgUnitId, f.FState");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            this.queryOrgCount(ctx, CURR_USER_ID, _dataMap, _queryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_BGTEMPLATE_IDS, _isBgPermissionUsed);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams(pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString(1);
                _state = rst.getInt(2);
                _count = rst.getInt(3);
                if (_dataMap.containsKey(_orgUnitId)) {
                    _tmpMap = (Map)_dataMap.get(_orgUnitId);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(_orgUnitId, _tmpMap);
                }
                _tmpMap.put(new Integer(_state), new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryOrgCount(Context ctx, String userId, Map queryMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS, boolean isBgPermissionUsed) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        int _count = 0;
        Integer _state = new Integer(100);
        String _rootId2222222 = null;
        String _orgUnitId2222222 = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FOrgUnitId, count(n.fid) from T_BG_BgSchemeNode n ").append("left join T_BG_BgScheme s on n.FBgSchemeId = s.FID ").append("left join T_BG_BgTemplate t on n.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') ");
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and s.FOrgUnitId IN (");
            for (String _orgUnitId2222222 : orgUnitIds) {
                sql.append("?,");
                _tmpList.add(_orgUnitId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND s.FRootId IN (");
            for (String _rootId2222222 : bgSchemeRootIds) {
                sql.append("?,");
                _tmpList.add(_rootId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String _rootId2222222 : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(_rootId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (isBgPermissionUsed) {
            FilterInfo filter = new FilterInfo();
            filter = BgPermissionHelper.addBgTemplatePermission(ctx, userId, orgUnitIds, filter);
            String _query = filter.toString();
            _query = _query.replaceAll("bgtemplate.id", "t.FID");
            _query = _query.replaceAll("bgscheme.id", "s.FID");
            _query = _query.replaceAll(" creator.id ", " t.FCreatorId ");
            if (!StringUtils.isEmpty((String)(_query = _query.replaceAll("\\(id", "\\(t.FID")))) {
                sql.append(" and " + _query);
            }
        }
        sql.append(" group by s.FOrgUnitId");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams(pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId2222222 = rst.getString(1);
                _count = rst.getInt(2);
                if (queryMap.containsKey(_orgUnitId2222222)) {
                    _tmpMap = (Map)queryMap.get(_orgUnitId2222222);
                } else {
                    _tmpMap = new HashMap();
                    queryMap.put(_orgUnitId2222222, _tmpMap);
                }
                _tmpMap.put(_state, new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _querySchemeInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        int in;
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) {
            return new HashMap();
        }
        boolean _isBgPermissionUsed = BgSHelper.isBgPermissionUsed((Context)ctx);
        String CURR_USER_ID = (String)parameter.get("CURR_USER_ID");
        String CURR_CTRLORGUNIT_ID = (String)parameter.get("CURR_CTRLORGUNIT_ID");
        String SEL_ORGUNIT_ID = (String)parameter.get("SEL_ORGUNIT_ID");
        Integer SEL_ORGUNIT_TYPE = (Integer)parameter.get("SEL_ORGUNIT_TYPE");
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        Set<Object> _queryOrgUnitIds = new HashSet<String>();
        if (SEL_ORGUNIT_TYPE == 1) {
            if (this.verifyPermission(ctx, CURR_USER_ID, SEL_ORGUNIT_ID)) {
                _queryOrgUnitIds.add(SEL_ORGUNIT_ID);
            }
        } else if (SEL_ORGUNIT_TYPE == 2) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, true, true);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, false, true);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        }
        if (_queryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        HashMap _dataMap = new HashMap();
        Map<Integer, BigDecimal> _tmpMap = null;
        HashMap<String, String> _nameMap = new HashMap<String, String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        int _state = 0;
        int _count = 0;
        Object _obj2222222 = null;
        String _id2222222 = null;
        String _name = null;
        String _rootId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FName, t.FRootId, f.FState, count(f.FID) from T_BG_BgForm f ").append("left join T_BG_BgScheme s on f.FBgSchemeId = s.FID ").append("left join T_BG_BgTemplate t on f.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') ");
        if (_queryOrgUnitIds != null && !_queryOrgUnitIds.isEmpty()) {
            sql.append(" and f.FOrgUnitId IN (");
            for (Object _obj2222222 : _queryOrgUnitIds) {
                if (_obj2222222 == null) continue;
                sql.append("?,");
                _tmpList.add(_obj2222222.toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FRootId IN (");
            in = SEL_BGSCHEME_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGSCHEME_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGTEMPLATE_IDS != null && SEL_BGTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            in = SEL_BGTEMPLATE_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGTEMPLATE_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String _id2222222 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            for (String _id2222222 : SEL_CURRENCY_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (_isBgPermissionUsed) {
            FilterInfo filter = new FilterInfo();
            filter = BgPermissionHelper.addBgFormPermission(ctx, CURR_USER_ID, _queryOrgUnitIds, filter);
            String _query = filter.toString();
            _query = _query.replaceAll("bgtemplate.id", "t.FID");
            _query = _query.replaceAll("bgscheme.id", "s.FID");
            _query = _query.replaceAll(" creator.id ", " t.FCreatorId ");
            if (!StringUtils.isEmpty((String)(_query = _query.replaceAll("\\(id", "\\(t.FID")))) {
                sql.append(" and " + _query);
            }
        }
        sql.append(" group by t.FName, t.FRootId, f.FState order by t.FName");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            this.querySchemeCount(ctx, CURR_USER_ID, _dataMap, _nameMap, _queryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_BGTEMPLATE_IDS, _isBgPermissionUsed);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams(pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _rootId = rst.getString(2);
                _state = rst.getInt(3);
                _count = rst.getInt(4);
                if (_dataMap.containsKey(_rootId)) {
                    _tmpMap = (Map)_dataMap.get(_rootId);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(_rootId, _tmpMap);
                }
                _nameMap.put(_rootId, _name);
                _tmpMap.put(new Integer(_state), new BigDecimal(_count));
            }
            _dataMap.put("BGTEMPLATE_INFO", _nameMap);
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void querySchemeCount(Context ctx, String userId, Map queryMap, Map nameMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS, boolean isBgPermissionUsed) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        int _count = 0;
        Integer _state = new Integer(100);
        String _id2222222 = null;
        String _rootId = null;
        String _name = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FName, t.FRootId, count(t.FID) from T_BG_BgSchemeNode n ").append("left join T_BG_BgScheme s on n.FBgSchemeId = s.FID ").append("left join T_BG_BgTemplate t on n.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') ");
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and t.FOrgUnitId IN (");
            for (String _id2222222 : orgUnitIds) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND s.FRootId IN (");
            for (String _id2222222 : bgSchemeRootIds) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String _id2222222 : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (isBgPermissionUsed) {
            FilterInfo filter = new FilterInfo();
            filter = BgPermissionHelper.addBgTemplatePermission(ctx, userId, orgUnitIds, filter);
            String _query = filter.toString();
            _query = _query.replaceAll("bgtemplate.id", "t.FID");
            _query = _query.replaceAll(" creator.id ", " t.FCreatorId ");
            if (!StringUtils.isEmpty((String)(_query = _query.replaceAll("\\(id", "\\(t.FID")))) {
                sql.append(" and " + _query);
            }
        }
        sql.append(" group by t.FName, t.FRootId");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams(pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _rootId = rst.getString(2);
                _count = rst.getInt(3);
                if (queryMap.containsKey(_rootId)) {
                    _tmpMap = (Map)queryMap.get(_rootId);
                } else {
                    _tmpMap = new HashMap();
                    queryMap.put(_rootId, _tmpMap);
                }
                nameMap.put(_rootId, _name);
                _tmpMap.put(_state, new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected Map<String, String> _queryHasAttach(Context ctx, List ids) throws BOSException, EASBizException {
        final HashMap<String, String> result = new HashMap<String, String>();
        if (ids == null || ids.isEmpty()) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FBoID ,count(*) from  T_BAS_BoAttchAsso where fassobusobjtype = 'FF66566A' and  FBoID in ( ");
        BgNSQLHelper.addPlaceHolder(sql, 200);
        sql.append(" ) group by FBoID ");
        List<Object[]> params = BgNSQLHelper.getBatchParams(null, ids.toArray(), 200);
        BgNSQLHelper.executeBatchQuery(ctx, sql.toString(), params, new IResultReader(){

            @Override
            public void read(ResultSet res) throws SQLException {
                result.put(res.getString(1), res.getString(2));
            }
        });
        return result;
    }
}

