/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgCourseCommentInfo;
import com.kingdee.eas.ma.nbudget.BgCslDataCollection;
import com.kingdee.eas.ma.nbudget.BgCslDataInfo;
import com.kingdee.eas.ma.nbudget.BgCslFormInfo;
import com.kingdee.eas.ma.nbudget.BgCslFormPropertyAdapter;
import com.kingdee.eas.ma.nbudget.BgCslFormStateEnum;
import com.kingdee.eas.ma.nbudget.BgCslHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgCslFormControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslFormControllerBean
extends AbstractBgCslFormControllerBean {
    private static final long serialVersionUID = 9133874862184461789L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgCslFormControllerBean");

    @Override
    protected String _checkNumber(Context ctx, String orgId, String number, IObjectValue model, boolean isDisplay) throws BOSException, EASBizException {
        ResultSet res;
        PreparedStatement pstmt;
        Connection conn;
        block9: {
            String string;
            if (orgId == null) {
                return null;
            }
            if (!isDisplay) {
                BgCslFormInfo info = (BgCslFormInfo)model;
                BgCodeNumberNHelper.applyNumber(ctx, (IObjectValue)info, orgId, "sourceType");
                number = info.getNumber().trim();
                if (number.length() > 80) {
                    number = number.substring(0, 80);
                }
            }
            if (StringUtils.isEmpty((String)number)) {
                return "noNumber";
            }
            if (!BgNWorkPaperHelper.checkNumber(number)) {
                return "numberError";
            }
            String sql = "SELECT FID FROM T_BG_BGCSLFORM WHERE FORGUNITID = ? AND FNUMBER = ?";
            conn = null;
            pstmt = null;
            res = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, orgId);
                pstmt.setString(2, number);
                res = pstmt.executeQuery();
                if (!res.next()) break block9;
                string = "numberRepeat";
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        return null;
    }

    @Override
    protected String _checkHasExist(Context ctx, String orgId, String bgSchemeId, String bgCslTemplateId, String bgPeriodId, String currencyId, int dataType, String number) throws BOSException, EASBizException {
        ResultSet res;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            String string;
            String sql = "SELECT FID FROM T_BG_BGCSLFORM WHERE FORGUNITID = ? AND FBGSCHEMEID = ? AND FBgCslTemplateID = ? AND FBGPERIODID = ? AND FCURRENCYID = ? AND FDATATYPE = ?";
            conn = null;
            pstmt = null;
            res = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, orgId);
                pstmt.setString(2, bgSchemeId);
                pstmt.setString(3, bgCslTemplateId);
                pstmt.setString(4, bgPeriodId);
                pstmt.setString(5, currencyId);
                pstmt.setInt(6, dataType);
                res = pstmt.executeQuery();
                if (!res.next()) break block4;
                string = "hasExist";
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        return null;
    }

    @Override
    protected Map _audit(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String currId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("update t_bg_bgCslForm set FAuditedTime = ? ,FAuditorID = ?, fstate =").append(2).append(" where fstate = ").append(1).append(" and fid = ?");
        StringBuffer sql2 = new StringBuffer("update t_bg_bgWorkPaper set FAuditedTime = ? ,FAuditorID = ?, fstate =").append(2).append(" where fstate = ").append(1).append(" and fid in (select distinct FBgWorkPaperID from T_BG_BGCslData where FBgCslFormID = ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt2 = conn.prepareStatement(sql2.toString());
            int batchCount = 200;
            for (int i = 0; i < idList.size(); ++i) {
                if (i != 0 && i % batchCount == 0) {
                    pstmt.executeBatch();
                    pstmt2.executeBatch();
                }
                pstmt.setTimestamp(1, now);
                pstmt.setString(2, currId);
                pstmt.setObject(3, idList.get(i));
                pstmt.addBatch();
                pstmt2.setTimestamp(1, now);
                pstmt2.setString(2, currId);
                pstmt2.setObject(3, idList.get(i));
                pstmt2.addBatch();
            }
            if (idList.size() > 0) {
                pstmt.executeBatch();
                pstmt2.executeBatch();
                String _userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                this.updateOperateInfo(ctx, idList, _userId, 7);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmt2);
        return null;
    }

    @Override
    protected Map _unAudit(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("update t_bg_bgCslForm set FAuditedTime = null ,FAuditorID = null, fstate =").append(1).append(" where fstate = ").append(2).append(" and fid = ?");
        StringBuffer sql2 = new StringBuffer("update t_bg_bgWorkPaper set FAuditedTime = null ,FAuditorID = null, fstate =").append(1).append(" where fstate = ").append(2).append(" and fid not in (select distinct FBgWorkPaperID from T_BG_BGCslData where FBgWorkPaperID is not null ").append(" and FBgCslFormID IN (").append(" select fid from t_bg_bgCslForm where fstate =").append(2).append("))");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = 200;
            for (int i = 0; i < idList.size(); ++i) {
                if (i != 0 && i % batchCount == 0) {
                    pstmt.executeBatch();
                }
                pstmt.setObject(1, idList.get(i));
                pstmt.addBatch();
            }
            if (idList.size() > 0) {
                pstmt.executeBatch();
                String _userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                this.updateOperateInfo(ctx, idList, _userId, 8);
            }
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(sql2.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return null;
    }

    @Override
    protected Map _getCslData(Context ctx, String treeId, String orgUnitId, String bgSchemeId, BgDataTypeEnum dataType, List formulas) throws BOSException {
        int i;
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        if (StringUtils.isEmpty((String)treeId) || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgSchemeId) || dataType == null || formulas == null || formulas.isEmpty()) {
            return formulaMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int pos = 0;
        int batchSize = 200;
        int size = formulas.size();
        int count = (size - 1) / batchSize + 1;
        StringBuffer sql = new StringBuffer("SELECT FFormula, FConsolidAmount FROM T_BG_BGWorkData ").append(" WHERE FOrgTreeID = ? AND FOrgGroupID = ? ").append(" AND FBgSchemeID IN (SELECT FID FROM T_BG_BGScheme WHERE FRootID = (SELECT FRootID FROM T_BG_BGScheme WHERE FID = ?)) ").append("AND FDataType = ").append(dataType.getValue()).append(" AND FFormula IN (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) ORDER BY FFormula ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, treeId);
            pstmt.setString(2, orgUnitId);
            pstmt.setString(3, bgSchemeId);
            for (i = 0; i < count; ++i) {
                int j = 0;
                while (j < batchSize) {
                    if (pos < size) {
                        pstmt.setString(j + 4, (String)formulas.get(pos));
                    } else {
                        pstmt.setString(j + 4, "#");
                    }
                    ++j;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    formulaMap.put(rst.getString(1), rst.getBigDecimal(2));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return formulaMap;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslFormInfo info = (BgCslFormInfo)model;
        if (info.getId() != null && super._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            BgCslFormInfo tempInfo = (BgCslFormInfo)super._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            info.setNumber(tempInfo.getNumber());
        }
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        if (info.getId() == null && pk != null) {
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        this.saveBgCslData(ctx, info);
        return pk;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number;
        BgCslFormInfo info = (BgCslFormInfo)model;
        if (info.getOrgUnit() != null) {
            BgCodeNumberNHelper.applyNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), "sourceType");
        }
        if ((number = info.getNumber().trim()).length() > 80) {
            number = number.substring(0, 80);
            info.setNumber(number);
        }
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgCslForm_add");
        IObjectPK result = super._addnew(ctx, (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return result;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCslFormInfo info = this.getBgCslFormInfo(ctx, pk);
        if (BgCslFormStateEnum.EDIT.equals((Object)info.getState())) {
            if (pk != null) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM T_BG_BGCslData WHERE FBgCslFormId = '" + pk.toString() + "'"));
            }
            super._delete(ctx, pk);
            BgCodeNumberNHelper.recycleNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), info.getNumber());
        }
    }

    private void saveBgCslData(Context ctx, BgCslFormInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        OrgTreeInfo treeInfo = info.getOrgTree();
        FullOrgUnitInfo orgUnit = info.getOrgUnit();
        BgSchemeInfo bgScheme = info.getBgScheme();
        BgPeriodInfo bgPeriod = info.getBgPeriod();
        CurrencyInfo currency = info.getCurrency();
        BgDataTypeEnum dataType = info.getDataType();
        Book book = null;
        Sheet sheet = null;
        Cell cell = null;
        String formula = null;
        String[] formulaPara = null;
        HashMap formulaMap = new HashMap();
        HashMap<String, BgElementInfo> bgElementMap = new HashMap<String, BgElementInfo>();
        BgCslDataInfo dataInfo = null;
        BgCslDataCollection dataCol = new BgCslDataCollection();
        try {
            book = info.getBook();
            if (book != null) {
                int sheetCount = book.getSheetCount();
                for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                    sheet = book.getSheet(sheetIndex);
                    int rowCount = sheet.getMaxRowIndex() + 1;
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        int colCount = sheet.getMaxColIndex() + 1;
                        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                            cell = sheet.getCell(rowIndex, colIndex, false);
                            if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                            formula = BgNFSHelper.getFormulaOfCell(cell);
                            formulaPara = BgNFSHelper.parseFormulaPara(formulaMap, formula);
                            if (formulaPara != null && formulaPara.length == 4) {
                                formula = this.constructFormula(formulaPara[0], formulaPara[2], formulaPara[1], formulaPara[5]);
                            }
                            dataInfo = new BgCslDataInfo();
                            dataInfo.setBgCslForm(info);
                            dataInfo.setOrgTree(treeInfo);
                            dataInfo.setOrgGroup(orgUnit);
                            dataInfo.setBgScheme(bgScheme);
                            dataInfo.setBgPeriod(bgPeriod);
                            dataInfo.setCurrency(currency);
                            dataInfo.setDataType(dataType);
                            dataInfo.setFormula(formula);
                            dataInfo.setConsolidAmount(BgCslHelper.getValue(cell));
                            if (bgElementMap.containsKey(formulaPara[2])) {
                                dataInfo.setBgElement((BgElementInfo)bgElementMap.get(formulaPara[2]));
                            } else {
                                BgElementCollection elementCol = BgElementFactory.getLocalInstance((Context)ctx).getBgElementCollection("select id, name, number where number = '" + formulaPara[2] + "'");
                                if (!elementCol.isEmpty()) {
                                    dataInfo.setBgElement(elementCol.get(0));
                                    bgElementMap.put(formulaPara[2], elementCol.get(0));
                                }
                            }
                            dataCol.add(dataInfo);
                        }
                    }
                }
            }
            if (!dataCol.isEmpty()) {
                this.processSaveCslData(ctx, info, dataCol);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{e.getMessage()});
        }
    }

    private void processSaveCslData(Context ctx, BgCslFormInfo bgCslForminfo, BgCslDataCollection dataCol) throws BOSException, EASBizException {
        if (dataCol == null || dataCol.isEmpty()) {
            return;
        }
        BgCslDataInfo info = dataCol.get(0);
        HashMap<String, BgWorkPaperInfo> workPaperMap = new HashMap<String, BgWorkPaperInfo>();
        BgWorkPaperInfo workPaperInfo = null;
        String treeId = info.getOrgTree() != null ? info.getOrgTree().getId().toString() : null;
        String orgUnitId = info.getOrgGroup() != null ? info.getOrgGroup().getId().toString() : null;
        String bgSchemeId = info.getBgScheme() != null ? info.getBgScheme().getId().toString() : null;
        String bgPeriodId = info.getBgPeriod() != null ? info.getBgPeriod().getId().toString() : null;
        BgDataTypeEnum dataType = dataCol.get(0).getDataType();
        ArrayList<String> formulas = new ArrayList<String>();
        for (int i = 0; i < dataCol.size(); ++i) {
            formulas.add(dataCol.get(i).getFormula());
        }
        if (StringUtils.isEmpty((String)treeId) || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgSchemeId) || dataType == null || formulas.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int pos = 0;
        int batchIndex = 0;
        int batchSize = 200;
        int size = formulas.size();
        int count = (size - 1) / batchSize + 1;
        StringBuffer sql = new StringBuffer("SELECT FFormula, FConsolidAmount, FBgWorkPaperID, FBgItemId FROM T_BG_BGWorkData ").append(" WHERE FOrgTreeID = ? AND FOrgGroupID = ? ").append(" AND FBgSchemeID IN (SELECT FID FROM T_BG_BGScheme WHERE FRootID = (SELECT FRootID FROM T_BG_BGScheme WHERE FID = ?)) ").append("AND FDataType = ").append(dataType.getValue()).append(" AND FFormula IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) ORDER BY FFormula ");
        StringBuffer sqlDelete = new StringBuffer("DELETE FROM T_BG_BGCslData WHERE FBgCslFormId = ? ");
        StringBuffer sqlInsert = new StringBuffer("INSERT INTO T_BG_BGCslData (FID, FFormula, FBgCslFormID, FOrgTreeID, FOrgGroupID, FBgWorkPaperID, ").append(" FBgSchemeID, FBgPeriodID, FBgElementID, FCurrencyID, FConsolidAmount, FDataType, FBgItemCombinId)").append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, treeId);
            pstmt.setString(2, orgUnitId);
            pstmt.setString(3, bgSchemeId);
            for (int i = 0; i < count; ++i) {
                int j = 0;
                while (j < batchSize) {
                    if (pos < size) {
                        pstmt.setString(j + 4, (String)formulas.get(pos));
                    } else {
                        pstmt.setString(j + 4, "#");
                    }
                    ++j;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                block8: while (rst.next()) {
                    for (int k = 0; k < dataCol.size(); ++k) {
                        info = dataCol.get(k);
                        String formula = rst.getString(1);
                        String workPaperId = rst.getString(3);
                        String bgItemCombinId = rst.getString(4);
                        if (formula == null || !formula.equals(info.getFormula())) continue;
                        if (workPaperMap.containsKey(workPaperId)) {
                            workPaperInfo = (BgWorkPaperInfo)workPaperMap.get(workPaperId);
                        } else {
                            workPaperInfo = new BgWorkPaperInfo();
                            workPaperInfo.setId(BOSUuid.read((String)workPaperId));
                            workPaperMap.put(workPaperId, workPaperInfo);
                        }
                        info.setBgWorkPaper(workPaperInfo);
                        info.setBgItemCombinId(bgItemCombinId);
                        continue block8;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(sqlDelete.toString());
            pstmt.setString(1, bgCslForminfo.getId().toString());
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
            BOSObjectType type = dataCol.get(0).getBOSType();
            pstmt = conn.prepareStatement(sqlInsert.toString());
            for (int i = 0; i < dataCol.size(); ++i) {
                info = dataCol.get(i);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                pstmt.setString(2, info.getFormula());
                pstmt.setString(3, bgCslForminfo.getId().toString());
                pstmt.setString(4, treeId);
                pstmt.setString(5, orgUnitId);
                pstmt.setString(6, info.getBgWorkPaper() != null ? info.getBgWorkPaper().getId().toString() : null);
                pstmt.setString(7, bgSchemeId);
                pstmt.setString(8, bgPeriodId);
                pstmt.setString(9, info.getBgElement() != null ? info.getBgElement().getId().toString() : null);
                pstmt.setString(10, info.getCurrency() != null ? info.getCurrency().getId().toString() : null);
                pstmt.setBigDecimal(11, info.getConsolidAmount() != null ? info.getConsolidAmount() : BgNConstants.ZERO);
                pstmt.setInt(12, dataType.getValue());
                pstmt.setString(13, info.getBgItemCombinId());
                pstmt.addBatch();
                if (++batchIndex <= batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private String constructFormula(String bgItem, String bgElement, String bgPeriod, String currency) {
        if (bgItem == null || bgElement == null) {
            return null;
        }
        String formulaLine = "=BgItem(\"" + bgItem + "\",\"" + bgPeriod + "\",\"" + bgElement + "\",\"BgData\",true,\"" + currency + "\")";
        return formulaLine;
    }

    @Override
    protected List _reportCheck(Context ctx, BOSUuid[] ids) throws BOSException, EASBizException {
        ArrayList<Object> reList = new ArrayList<Object>();
        reList.add(Boolean.TRUE);
        if (ids == null || ids.length == 0) {
            return reList;
        }
        ArrayList<BOSUuid> _pass = new ArrayList<BOSUuid>();
        ArrayList<BOSUuid> _nopass = new ArrayList<BOSUuid>();
        List check = null;
        StringBuffer msg = new StringBuffer();
        BgCslFormInfo bgCslFormInfo = null;
        RptOperationSchemaComp comp = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                bgCslFormInfo = BgCslHelper.getBgCslFormInfo(ctx, ids[i], true);
                BookProperties bp = BookProperties.loadFromBook((Book)bgCslFormInfo.getBook());
                comp = bgCslFormInfo.get("operationSchemas") != null ? (RptOperationSchemaComp)bgCslFormInfo.get("operationSchemas") : bp.getOperationSchema();
                if (comp != null && !comp.isCheckExpEmpty()) {
                    bgCslFormInfo.put("FORMULA_DATA", this.extractData(bgCslFormInfo, true, null));
                    bgCslFormInfo.put("operationSchemas", comp);
                    BgCslFormPropertyAdapter adapter = new BgCslFormPropertyAdapter();
                    adapter.initReportProperties((IObjectValue)bgCslFormInfo, ctx);
                    check = ReportCheck.checkReport((Context)ctx, (ReportBaseInfo)bgCslFormInfo, (IReportPropertyAdapter)adapter, null);
                } else {
                    check = null;
                }
                if (check != null && Boolean.FALSE.equals(check.get(0))) {
                    reList.set(0, Boolean.FALSE);
                    msg.append("<a>" + bgCslFormInfo.getNumber() + " - " + bgCslFormInfo.getName() + "</a>");
                    msg.append("<br>");
                    msg.append(check.get(2));
                    msg.append("<br>");
                    msg.append("<br>");
                    _nopass.add(ids[i]);
                    continue;
                }
                _pass.add(ids[i]);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        reList.add(_pass);
        reList.add(_nopass);
        reList.add(msg.length() > 0 ? msg.toString() : null);
        return reList;
    }

    private List extractData(BgCslFormInfo model, boolean valueFirst, int[] calIndex) {
        Book _book = null;
        Sheet _sheet = null;
        try {
            _book = model.getBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_book == null) {
            return new ArrayList();
        }
        BgNFSHelper.disableCal(_book);
        BgNFSHelper.disableUndo(_book);
        ArrayList result = new ArrayList(_book.getSheetCount());
        ArrayList<String> names = new ArrayList<String>(_book.getSheetCount());
        result.add(names);
        int i = 0;
        int jn = _book.getSheetCount();
        for (int j = 0; j < jn; ++j) {
            int r;
            _sheet = _book.getSheet(j);
            if (_sheet == null) {
                result.add(null);
                names.add(null);
                continue;
            }
            names.add(_sheet.getSheetName());
            int rowcount = _sheet.getMaxRowIndex();
            if (rowcount < 1) continue;
            ArrayList myBody = new ArrayList(rowcount);
            result.add(myBody);
            int lastRow = 0;
            for (r = 0; r < rowcount; ++r) {
                Row row = _sheet.getRow(r, false);
                if (row == null) {
                    myBody.add(null);
                    continue;
                }
                ArrayList<Object> myRow = new ArrayList<Object>(_sheet.getMaxColIndex());
                boolean hasContent = false;
                for (int k = 0; k < _sheet.getMaxColIndex(); ++k) {
                    Cell cell = row.getCell(k, false);
                    if (cell == null || cell.getValue() == Variant.nullVariant && BgNFSHelper.getExpression(cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    if (cell != null && BgNFSHelper.getValue(cell) instanceof String && StringUtils.isEmpty((String)((String)BgNFSHelper.getValue(cell))) && BgNFSHelper.getExpression(cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    hasContent = true;
                    String s = BgNFSHelper.getExpression(cell);
                    Variant obj = cell.getValue();
                    if (!StringUtils.isEmpty((String)s)) {
                        if (valueFirst || calIndex != null && calIndex[i] < 0) {
                            myRow.add(obj);
                            continue;
                        }
                        myRow.add(s);
                        continue;
                    }
                    myRow.add(obj);
                }
                if (hasContent) {
                    myBody.add(myRow);
                    lastRow = j;
                    continue;
                }
                myBody.add(null);
            }
            for (r = rowcount - 1; r > lastRow; --r) {
                myBody.remove(r);
            }
            ++i;
        }
        return result;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCslFormInfo info = (BgCslFormInfo)super._getValue(ctx, pk);
        return info.getNumber() + " " + info.getName();
    }

    @Override
    protected IObjectCollection _bantchUpdateState(Context ctx, List pkIds, BgCslFormStateEnum currentState, BgCslFormStateEnum state, String dealInfo) throws BOSException, EASBizException {
        if (pkIds == null || state == null || pkIds.size() <= 0) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgCslForm  set FState = " + state.getValue());
        sql.append(" where fid in (");
        for (int index = 1; index < pkIds.size(); ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        sql.append(" and  FState = " + currentState.getValue());
        conn = this.getConnection(ctx);
        ArrayList<String> _tmpList = new ArrayList<String>();
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < pkIds.size(); ++i) {
                pstmt.setString(i + 1, pkIds.get(i).toString());
                _tmpList.add(pkIds.get(i).toString());
            }
            pstmt.executeUpdate();
            String _userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            int operateEnum = this.getOperateByBgCslFormStates(currentState, state);
            if (operateEnum > 0 && 4 != operateEnum) {
                this.updateOperateInfo(ctx, _tmpList, _userId, operateEnum);
            }
        }
        catch (SQLException e) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        if (currentState.getValue() == 5 && state.getValue() == 2) {
            this.updateWorkPaper(ctx, pkIds, 1, 2);
        } else if (state.getValue() == 5 && currentState.getValue() == 2) {
            this.updateWorkPaper(ctx, pkIds, 2, 1);
        }
        return null;
    }

    private int getOperateByBgCslFormStates(BgCslFormStateEnum currentState, BgCslFormStateEnum state) {
        int currentStateValue = currentState.getValue();
        int targetStateValue = state.getValue();
        if (currentStateValue == 1 && targetStateValue == 3) {
            return 7;
        }
        if (currentStateValue == 3 && targetStateValue == 4) {
            return 1;
        }
        if (currentStateValue == 4 && targetStateValue == 6) {
            return 4;
        }
        if (currentStateValue == 4 && targetStateValue == 5) {
            return 2;
        }
        if (currentStateValue == 5 && targetStateValue == 4) {
            return 3;
        }
        if (currentStateValue == 5 && targetStateValue == 2) {
            return 5;
        }
        if (currentStateValue == 2 && targetStateValue == 5) {
            return 6;
        }
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateOperateInfo(Context ctx, List<String> bgFormIds, String userId, int operate) throws BOSException, EASBizException {
        if (ctx == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (bgFormIds == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (bgFormIds.isEmpty()) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (userId == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        BgCourseCommentInfo info = new BgCourseCommentInfo();
        String _bgFormId = null;
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BG_BgCslFormComment (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FState, FBgclsFormId, FComment) values(?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = bgFormIds.get(i);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, _timestamp);
                pstmt.setString(4, userId);
                pstmt.setTimestamp(5, _timestamp);
                pstmt.setString(6, null);
                pstmt.setInt(7, operate);
                pstmt.setString(8, _bgFormId);
                pstmt.setString(9, info.getComment());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateWorkPaper(Context ctx, List idList, int srcState, int targetState) throws EASBizException, BOSException {
        StringBuffer sql2 = new StringBuffer("update t_bg_bgWorkPaper set FAuditedTime = ? ,FAuditorID = ?, fstate =").append(targetState).append(" where fstate = ").append(srcState).append(" and fid in (select distinct FBgWorkPaperID from T_BG_BGCslData where FBgCslFormID = ?)");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String currId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Connection conn = null;
        PreparedStatement pstmt2 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt2 = conn.prepareStatement(sql2.toString());
            int batchCount = 200;
            for (int i = 0; i < idList.size(); ++i) {
                if (i != 0 && i % batchCount == 0) {
                    pstmt2.executeBatch();
                }
                pstmt2.setTimestamp(1, now);
                pstmt2.setString(2, currId);
                pstmt2.setObject(3, idList.get(i));
                pstmt2.addBatch();
            }
            if (idList.size() > 0) {
                pstmt2.executeBatch();
                String _userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                this.updateOperateInfo(ctx, idList, _userId, 7);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt2);
    }

    @Override
    protected Map _notRootAudit(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String currId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("update t_bg_bgCslForm set FAuditedTime = ? ,FAuditorID = ?, fstate =").append(3).append(" where fstate = ").append(1).append(" and fid = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = 200;
            for (int i = 0; i < idList.size(); ++i) {
                if (i != 0 && i % batchCount == 0) {
                    pstmt.executeBatch();
                }
                pstmt.setTimestamp(1, now);
                pstmt.setString(2, currId);
                pstmt.setObject(3, idList.get(i));
                pstmt.addBatch();
            }
            if (idList.size() > 0) {
                pstmt.executeBatch();
                String _userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                this.updateOperateInfo(ctx, idList, _userId, 7);
                pstmt = conn.prepareStatement("update t_bas_paramitem set FIsModify = 1 where fid = '8r0AAAAHffvtKpea'");
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return null;
    }

    @Override
    protected Map _notRootUnAudit(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("update t_bg_bgCslForm set FAuditedTime = null ,FAuditorID = null, fstate =").append(1).append(" where fstate = ").append(3).append(" and fid = ?");
        StringBuffer sql2 = new StringBuffer("update t_bg_bgWorkPaper set FAuditedTime = null ,FAuditorID = null, fstate =").append(1).append(" where fstate = ").append(2).append(" and fid not in (select distinct FBgWorkPaperID from T_BG_BGCslData where FBgWorkPaperID is not null ").append(" and FBgCslFormID IN (").append(" select fid from t_bg_bgCslForm where fstate =").append(3).append("))");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = 200;
            for (int i = 0; i < idList.size(); ++i) {
                if (i != 0 && i % batchCount == 0) {
                    pstmt.executeBatch();
                }
                pstmt.setObject(1, idList.get(i));
                pstmt.addBatch();
            }
            if (idList.size() > 0) {
                pstmt.executeBatch();
                String _userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                this.updateOperateInfo(ctx, idList, _userId, 8);
            }
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(sql2.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _loadColorScheme(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Integer _state = null;
        String _color = null;
        HashMap<Integer, String> colorScheme = new HashMap<Integer, String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FState, FColor from T_BG_BgCslFormColorScheme");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _state = new Integer(rst.getInt(1));
                _color = rst.getString(2);
                colorScheme.put(_state, _color);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colorScheme;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveColorScheme(Context ctx, Map colorScheme) throws BOSException, EASBizException {
        if (colorScheme == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map.Entry _entry2222222 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BgCslFormColorScheme");
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("insert into T_BG_BgCslFormColorScheme (FState, FColor) values(?, ?)");
            for (Map.Entry _entry2222222 : colorScheme.entrySet()) {
                pstmt.setInt(1, (Integer)_entry2222222.getKey());
                pstmt.setString(2, (String)_entry2222222.getValue());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }
}

