/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgExamineCollection;
import com.kingdee.eas.ma.budget.BgExamineFactory;
import com.kingdee.eas.ma.budget.BgExamineNodeInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgSchemeException;
import com.kingdee.eas.ma.budget.BgTemplateException;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgExamine;
import com.kingdee.eas.ma.nbudget.BgCslFormCollection;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslTemplateCollection;
import com.kingdee.eas.ma.nbudget.BgCslTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgElimException;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgCslTemplateControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgCslTemplateControllerBean
extends AbstractBgCslTemplateControllerBean {
    private static final long serialVersionUID = -8406225655601485115L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgCslTemplateControllerBean");

    @Override
    protected Map _getRPCDataMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> rpcDataMap = new HashMap<String, Boolean>();
        BgCslTemplateInfo bgTemplateInfo = new BgCslTemplateInfo();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String CUID = (String)paramMap.get("CUID");
        boolean result = codingRuleManager.isExist((IObjectValue)bgTemplateInfo, CUID);
        rpcDataMap.put("hasCodingRule", result);
        String oprtState = (String)paramMap.get("oprtState");
        IMeasureUnit iM = MeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        if (oprtState.equals(OprtState.ADDNEW)) {
            muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)"0", CompareType.EQUALS));
        }
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol1 = iM.getMeasureUnitCollection(muView);
        rpcDataMap.put("muCol1", (Boolean)muCol1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        SorterItemInfo sorter = new SorterItemInfo("number");
        view.getSorter().add(sorter);
        view.setFilter(filter);
        IBgElement iElement = BgElementFactory.getLocalInstance((Context)ctx);
        BgElementCollection bgElementCol = iElement.getBgElementCollection(view);
        rpcDataMap.put("bgElementCol", (Boolean)bgElementCol);
        EntityViewInfo muView2 = new EntityViewInfo();
        FilterInfo muFilter2 = new FilterInfo();
        muFilter2.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView2.setFilter(muFilter2);
        muView2.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol2 = iM.getMeasureUnitCollection(muView2);
        rpcDataMap.put("muCol2", (Boolean)muCol2);
        return rpcDataMap;
    }

    @Override
    protected void _addExamieNodes(Context ctx, String templateId, Vector examineIds, Vector hadExamineIds) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)templateId)) {
            return;
        }
        if (examineIds == null) {
            examineIds = new Vector();
        }
        if (hadExamineIds == null) {
            hadExamineIds = new Vector();
        }
        Vector<String> sql = new Vector<String>();
        Vector tmp = new Vector();
        List<String> _tmpList = null;
        for (int i = 0; i < hadExamineIds.size(); ++i) {
            if (examineIds.contains(hadExamineIds.get(i))) continue;
            sql.add("delete from t_bg_bgexamineNode where FBgExamineID = ? and  FBgTemplateID = ?");
            _tmpList = new ArrayList();
            _tmpList.add((String)hadExamineIds.get(i));
            _tmpList.add(templateId);
            tmp.add(_tmpList);
        }
        for (int n = 0; n < examineIds.size(); ++n) {
            if (hadExamineIds.contains(examineIds.get(n))) continue;
            sql.add("insert into t_bg_bgexamineNode (fid,FBgTemplateID,FBgExamineID,FIsParent) values (?, ?, ?, 0 )");
            _tmpList = new ArrayList();
            _tmpList.add(BOSUuid.create((BOSObjectType)new BgExamineNodeInfo().getBOSType()).toString());
            _tmpList.add(templateId);
            _tmpList.add(examineIds.get(n).toString());
            tmp.add(_tmpList);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            for (int i = 0; i < sql.size(); ++i) {
                pstmt = conn.prepareStatement(sql.get(i).toString());
                _tmpList = (List)tmp.get(i);
                BgNSQLHelper.setParams(pstmt, _tmpList);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    @Override
    protected IObjectCollection _getExamine(Context ctx, String templateId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        ArrayList<String> examineIds;
        IBgExamine iBgEx;
        BgExamineCollection col;
        block9: {
            col = new BgExamineCollection();
            iBgEx = BgExamineFactory.getLocalInstance((Context)ctx);
            examineIds = new ArrayList<String>();
            String sql = "select FBgExamineID from t_bg_bgexaminenode where FBgTemplateID = ?";
            conn = null;
            pstmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, templateId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                examineIds.add(rs.getString("FBgExamineID").toString());
            }
            if (examineIds.size() != 0) break block9;
            IObjectCollection iObjectCollection = null;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return iObjectCollection;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (examineIds.size() == 1) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)examineIds.get(0).toString(), CompareType.EQUALS));
            } else if (examineIds.size() > 1) {
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(examineIds), CompareType.INCLUDE));
            }
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getExamineSelectors());
            col = iBgEx.getBgExamineCollection(view);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return col;
    }

    protected SelectorItemCollection getExamineSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("CU.id");
        sic.add("examineGroup.*");
        sic.add("formula");
        sic.add("formulaAlias");
        sic.add("compareValue");
        sic.add("compareType");
        sic.add("hint");
        sic.add("citation.*");
        sic.add("citation.costCenter.id");
        sic.add("citation.bgScheme.id");
        sic.add("citation.bgTemplate.id");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgTemplate.id");
        sic.add("noPass");
        sic.add("errorData");
        return sic;
    }

    @Override
    protected void _removeexamineontemplate(Context ctx, String templateId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        Vector<String> examineIds;
        block8: {
            examineIds = new Vector<String>();
            String sql = "select FBgExamineID from t_bg_bgexaminenode where FBgTemplateID = ?";
            conn = null;
            pstmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, templateId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                examineIds.add(rs.getString("FBgExamineID").toString());
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            if (examineIds.size() != 0) break block8;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return;
        }
        try {
            if (examineIds.size() > 0) {
                String deleteSQL = "delete from t_bg_bgexamineNode where FBgExamineID = ?";
                pstmt = conn.prepareStatement(deleteSQL);
                for (int i = 0; i < examineIds.size(); ++i) {
                    pstmt.setString(1, examineIds.get(i).toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _saveMeasure(Context ctx, IObjectValue info) throws BOSException {
        if (info == null) {
            return;
        }
        BgCslTemplateInfo bgTem = (BgCslTemplateInfo)info;
        String id = bgTem.getId().toString();
        PreparedStatement ps = null;
        Connection connection = null;
        BOSObjectType type = new BgMeasureUnitInfo().getBOSType();
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(80);
            strBuffer.append("delete t_bg_bgcsltemmeasureunit where fbgcsltemplateid = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            ps.executeUpdate();
            if (bgTem.getBgMeasureUnit() != null && bgTem.getBgMeasureUnit().size() != 0) {
                strBuffer = new StringBuffer(80);
                strBuffer.append("insert into t_bg_bgcsltemmeasureunit(fid,fbgcsltemplateid,fbgelementid,fmeasureunitid) values(?,?,?,?)");
                ps = connection.prepareStatement(strBuffer.toString());
                for (int i = 0; i < bgTem.getBgMeasureUnit().size(); ++i) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    ps.setString(2, id);
                    ps.setString(3, bgTem.getBgMeasureUnit().get(i).getBgElement().getId().toString());
                    ps.setString(4, bgTem.getBgMeasureUnit().get(i).getMeasureUnit().getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected void _saveSimpleInfo(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        BgCslTemplateInfo bgTemInfo = (BgCslTemplateInfo)info;
        String id = bgTemInfo.getId().toString();
        String name = bgTemInfo.getName();
        String number = bgTemInfo.getNumber();
        String description = bgTemInfo.getDescription();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        if (bgTemInfo.getDefaultMeasureUnit() == null) {
            throw new BgTemplateException(BgTemplateException.HAVENOTSETDEFAULTMEASUREUNIT);
        }
        String measureId = bgTemInfo.getDefaultMeasureUnit().getId().toString();
        if (this.checkDupNumber(ctx, number, id)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        sql.append(" update t_bg_bgCsltemplate set fname = ?, fnumber = ?, fdescription = ?, fDefaultMeasureUnitId = ?, FLastUpdateTime = ? where fid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, name);
            sm.setString(2, number);
            sm.setString(3, description);
            sm.setString(4, measureId);
            sm.setTimestamp(5, time);
            sm.setString(6, id);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
    }

    private boolean checkDupNumber(Context ctx, String number, String id) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" SELECT FID FROM T_BG_BGCslTemplate where FNumber = ? ");
            if (!StringUtils.isEmpty((String)id)) {
                sql.append(" and fid != ?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                if (!StringUtils.isEmpty((String)id)) {
                    sm.setString(2, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    @Override
    protected boolean _checkRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_Bg_BgCslForm where FBgCslTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumber(ctx, model);
        String logName = "";
        BgCslTemplateInfo info = (BgCslTemplateInfo)model;
        logName = info.getNumber() + " " + info.getName();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgCslTemplate_add");
        IObjectPK result = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
        return result;
    }

    private void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslTemplateCollection col;
        BgCslTemplateInfo info = (BgCslTemplateInfo)model;
        String oql = "where number = '" + info.getNumber() + "'";
        if (info.getId() != null) {
            oql = oql + " and id <> '" + info.getId().toString() + "'";
        }
        if ((col = this.getBgCslTemplateCollection(ctx, oql)) != null && !col.isEmpty()) {
            throw new BgElimException(BgElimException.TEMPLATENUMBERREPEAT, new Object[]{info.getNumber()});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslTemplateInfo info = (BgCslTemplateInfo)model;
        this.checkNumber(ctx, (IObjectValue)info);
        Book book = null;
        if (info.getData() == null || info.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                info.setBook(book);
            }
            catch (IOException e) {
                throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, e);
            }
        }
        try {
            book = info.getBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
        book = this.transAndCheckBook(ctx, info, book);
        return super._save(ctx, model);
    }

    protected Book transAndCheckBook(Context ctx, BgCslTemplateInfo model, Book book) throws BOSException, EASBizException {
        if (ctx == null || model == null || book == null) {
            return book;
        }
        Sheet sheet = null;
        Cell cell = null;
        String formulaStr = null;
        String expression = null;
        String _tmpStr = null;
        String[] formula = null;
        String[] _tmpStrs = null;
        String[] bgItemNums = null;
        ArrayList<String[]> checkList = new ArrayList<String[]>();
        ArrayList<String> bgItemNumList = new ArrayList<String>();
        HashSet<String> bgElementSet = new HashSet<String>();
        HashSet<String> bgItemSet = new HashSet<String>();
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRowCount = sheet.getMaxRowIndex();
            int maxColCount = sheet.getMaxColIndex();
            for (int i = 0; i <= maxRowCount; ++i) {
                for (int j = 0; j <= maxColCount; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    _tmpStrs = BgNFSHelper.parseFormulaPara(formulaStr);
                    if (_tmpStrs != null && _tmpStrs.length == 4) {
                        formulaStr = this.constructFormula(_tmpStrs[0], _tmpStrs[2], "", "");
                    }
                    formula = new String[]{sheet.getSheetName(), formulaStr, String.valueOf(i), String.valueOf(j)};
                    checkList.add(formula);
                    _tmpStr = _tmpStrs[0];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"item.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgItemSet.add(_tmpStr.replaceAll(",", "_"));
                    bgItemNums = _tmpStr.split(",");
                    for (int x = 0; x < bgItemNums.length; ++x) {
                        if (bgItemNumList.contains(bgItemNums[x])) continue;
                        bgItemNumList.add(bgItemNums[x]);
                    }
                    _tmpStr = _tmpStrs[2];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"element.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgElementSet.add(_tmpStr);
                    expression = (String)BgNFSHelper.getCellData(cell, "BG_BUDGET_EXPRESSIONS");
                    if (!StringUtils.isEmpty((String)expression)) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inDataFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                        }
                    }
                    if (!StringUtils.isEmpty((String)(expression = (String)BgNFSHelper.getCellData(cell, "BG_ACTUAL_EXPRESSIONS")))) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                        }
                    }
                    if (StringUtils.isEmpty((String)(expression = (String)BgNFSHelper.getCellData(cell, "BG_ADD_EXPRESSIONS")))) continue;
                    try {
                        ExcelFormulaPaserHelper.parse((String)expression);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inADDFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                        throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                    }
                }
            }
        }
        try {
            BgNTemplateHelper.checkFormulaIsEctype(checkList, ctx.getLocale());
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkList.clear();
        }
        return book;
    }

    private String constructFormula(String bgItem, String bgElement, String bgPeriod, String currency) {
        if (bgItem == null || bgElement == null) {
            return null;
        }
        String formulaLine = "=BgItem(\"" + bgItem + "\",\"" + bgPeriod + "\",\"" + bgElement + "\",\"BgData\",true,\"" + currency + "\")";
        return formulaLine;
    }

    protected Book createNewBook(Context ctx) {
        Book book = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        book = Book.Manager.getNewBook(null, (int)1);
        Sheet sheet = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
            BgNFSHelper.setSheetSign(sheet);
        }
        return book;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String oql = "where bgCslTemplate.id = '" + pk.toString() + "'";
        BgCslFormCollection col = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormCollection(oql);
        if (col != null && !col.isEmpty()) {
            throw new BgElimException(BgElimException.CANTDELETEREFCSLTEMPLATE);
        }
        BgCslTemplateInfo info = (BgCslTemplateInfo)super._getValue(ctx, pk);
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgCslTemplate_remove");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _clone(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelectors();
        BgCslTemplateInfo info = this.getBgCslTemplateInfo(ctx, pk, sic);
        BgCslTemplateInfo cloneInfo = info.deepClone();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
            cloneInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        cloneInfo.setNumber("clone_" + cloneInfo.getNumber());
        cloneInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + cloneInfo.getName());
        if (cloneInfo.getNumber().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NUMBERTOOLONG);
        }
        if (cloneInfo.getName().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NAMETOOLONG);
        }
        if (this.checkDupNumber(ctx, cloneInfo.getNumber(), null)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            Book book = cloneInfo.getBook();
            Sheet sheet = null;
            int n = book.getSheetCount();
            for (int i = 0; i < n; ++i) {
                sheet = book.getSheet(i);
                sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
                BgNFSHelper.setSheetSign(sheet);
            }
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
            }
            catch (Exception e) {
                throw new BOSException(e.toString());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            cloneInfo.setData(IOHelper.packBook((Book)book));
        }
        catch (IOException e) {
            throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, e);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        super._addnew(ctx, (IObjectValue)cloneInfo);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        return sic;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCslTemplateInfo info = (BgCslTemplateInfo)super._getValue(ctx, pk);
        return info.getNumber() + " " + info.getName();
    }
}

