/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgSqlHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class BgDataAnalyseHelper {
    public static final String FBeforeAdjust = "FBeforeAdjust";
    public static final String FAdjustValue = "FAdjustValue";
    public static final String FBgValue = "FBgValue";
    public static final String FActual = "FActual";
    public static final String FLYBgValue = "FLYBgValue";
    public static final String FLYActual = "FLYActual";
    public static final String FLYBgValueRate = "FLYBgValueRate";
    public static final String FBgValueSum = "FBgValueSum";
    public static final String FActualSum = "FActualSum";
    public static final String FTYBgValue = "FTYBgValue";
    public static final String FTYActual = "FTYActual";
    public static final String FOperationPlan = "FOperationPlan";
    public static final String FOperationDifference = "FOperationDifference";
    public static final String FOperationDifferRate = "FOperationDifferRate";
    public static final String FLYActualRatet = "FLYActualRatet";
    public static final String FBefBizActual = "FBefBizActual";

    public static String getSumPeriod(Map dataMap, Map itemTableSum, Context ctx) {
        StringBuffer reS = new StringBuffer();
        reS.append(ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"3_BgDataAnalyseHelper", (Locale)ctx.getLocale())).append(" ");
        if (dataMap.containsKey(FBgValue)) {
            reS.append("when [Measures].[MFBgValue] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FActual)) {
            reS.append("when [Measures].[MBizActual] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FBeforeAdjust)) {
            reS.append("when [Measures].[MFBgValueBeforeAdjust] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FAdjustValue)) {
            reS.append("when [Measures].[MFAdjustValue] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FLYBgValue)) {
            reS.append("when [Measures].[MLYBgValue] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FLYActual)) {
            reS.append("when [Measures].[MLYActualValue] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FLYBgValueRate)) {
            reS.append("when [Measures].[MLYBgValueRate] then ([Measures].[MFBgValue]- [Measures].[MLYBgValue])/[Measures].[MLYBgValue]  ");
        }
        if (dataMap.containsKey(FLYActualRatet)) {
            reS.append("when [Measures].[MLYActualValueRate] then ([Measures].[MBizActual]- [Measures].[MLYActualValue])/[Measures].[MLYActualValue]  ");
        }
        if (dataMap.containsKey(FBgValueSum)) {
            reS.append("when [Measures].[MBgValueSumFinal] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FActualSum)) {
            reS.append("when [Measures].[MActualValueSumFinal] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FTYBgValue)) {
            reS.append("when [Measures].[MTYBgValueFinal] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FTYActual)) {
            reS.append("when [Measures].[MTYActualValueFinal] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FOperationPlan)) {
            reS.append("when [Measures].[OperationPlan] then [Measures].[MBizActual]/[Measures].[MFBgValue] ");
        }
        if (dataMap.containsKey(FOperationDifferRate)) {
            reS.append("when [Measures].[OperationDifferRate] then ([Measures].[MFBgValue]- [Measures].[MBizActual])/[Measures].[MFBgValue] ");
        }
        if (dataMap.containsKey(FOperationDifference)) {
            reS.append("when [Measures].[MOperationDifference] then sum(setPeriod) ");
        }
        if (dataMap.containsKey(FBefBizActual)) {
            reS.append("when [Measures].[FBefBizActual] then sum(setPeriod) ");
        }
        reS.append("end ");
        reS.append(")',solve_order=6 ");
        reS.append(ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"4_BgDataAnalyseHelper", (Locale)ctx.getLocale())).append(" ");
        if (dataMap.containsKey(FBgValue)) {
            reS.append("when [Measures].[MFBgValue] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FActual)) {
            reS.append("when [Measures].[MBizActual] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FBeforeAdjust)) {
            reS.append("when [Measures].[MFBgValueBeforeAdjust] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FAdjustValue)) {
            reS.append("when [Measures].[MFAdjustValue] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FLYBgValue)) {
            reS.append("when [Measures].[MLYBgValue] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FLYActual)) {
            reS.append("when [Measures].[MLYActualValue] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FLYBgValueRate)) {
            reS.append("when [Measures].[MLYBgValueRate] then ([Measures].[MFBgValue]- [Measures].[MLYBgValue])/[Measures].[MLYBgValue] ");
        }
        if (dataMap.containsKey(FLYActualRatet)) {
            reS.append("when [Measures].[MLYActualValueRate] then ([Measures].[MBizActual]- [Measures].[MLYActualValue])/[Measures].[MLYActualValue]  ");
        }
        if (dataMap.containsKey(FBgValueSum)) {
            reS.append("when [Measures].[MBgValueSumFinal] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FActualSum)) {
            reS.append("when [Measures].[MActualValueSumFinal] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FTYBgValue)) {
            reS.append("when [Measures].[MTYBgValueFinal] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FTYActual)) {
            reS.append("when [Measures].[MTYActualValueFinal] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FOperationPlan)) {
            reS.append("when [Measures].[OperationPlan] then [Measures].[MBizActual]/[Measures].[MFBgValue] ");
        }
        if (dataMap.containsKey(FOperationDifferRate)) {
            reS.append("when [Measures].[OperationDifferRate] then ([Measures].[MFBgValue]- [Measures].[MBizActual])/[Measures].[MFBgValue] ");
        }
        if (dataMap.containsKey(FOperationDifference)) {
            reS.append("when [Measures].[MOperationDifference] then sum([Company].members) ");
        }
        if (dataMap.containsKey(FBefBizActual)) {
            reS.append("when [Measures].[FBefBizActual] then sum([Company].members) ");
        }
        reS.append("end ");
        reS.append(")',solve_order=6 ");
        String key2 = null;
        String value = null;
        for (String key2 : itemTableSum.keySet()) {
            value = (String)itemTableSum.get(key2);
            reS.append(" member " + key2 + " as '(case [Measures].currentmember ");
            if (dataMap.containsKey(FBgValue)) {
                reS.append("when [Measures].[MFBgValue] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FActual)) {
                reS.append("when [Measures].[MBizActual] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FBeforeAdjust)) {
                reS.append("when [Measures].[MFBgValueBeforeAdjust] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FAdjustValue)) {
                reS.append("when [Measures].[MFAdjustValue] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FLYBgValue)) {
                reS.append("when [Measures].[MLYBgValue] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FLYActual)) {
                reS.append("when [Measures].[MLYActualValue] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FLYBgValueRate)) {
                reS.append("when [Measures].[MLYBgValueRate] then ([Measures].[MFBgValue]- [Measures].[MLYBgValue])/[Measures].[MLYBgValue] ");
            }
            if (dataMap.containsKey(FLYActualRatet)) {
                reS.append("when [Measures].[MLYActualValueRate] then ([Measures].[MBizActual]- [Measures].[MLYActualValue])/[Measures].[MLYActualValue]  ");
            }
            if (dataMap.containsKey(FBgValueSum)) {
                reS.append("when [Measures].[MBgValueSumFinal] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FActualSum)) {
                reS.append("when [Measures].[MActualValueSumFinal] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FTYBgValue)) {
                reS.append("when [Measures].[MTYBgValueFinal] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FTYActual)) {
                reS.append("when [Measures].[MTYActualValueFinal] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FOperationPlan)) {
                reS.append("when [Measures].[OperationPlan] then [Measures].[MBizActual]/[Measures].[MFBgValue] ");
            }
            if (dataMap.containsKey(FOperationDifferRate)) {
                reS.append("when [Measures].[OperationDifferRate] then ([Measures].[MFBgValue]- [Measures].[MBizActual])/[Measures].[MFBgValue] ");
            }
            if (dataMap.containsKey(FOperationDifference)) {
                reS.append("when [Measures].[MOperationDifference] then sum(" + value + ") ");
            }
            if (dataMap.containsKey(FBefBizActual)) {
                reS.append("when [Measures].[FBefBizActual] then sum(" + value + ") ");
            }
            reS.append("end ");
            reS.append(")',solve_order=6 ");
        }
        return reS.toString();
    }

    public static void updateElementUnit(Context ctx, String[] elementArr, BigDecimal[] unitArr, Map dataMap, String factTableName, String elementUnit) throws Exception {
        String upUnit = "update " + factTableName + " set FUnit = (select funit from " + elementUnit + " B where B.felement = FElementId)";
        DbUtil.execute((Context)ctx, (String)upUnit);
        StringBuffer upSqlCol = new StringBuffer();
        upSqlCol.append("update " + factTableName + " set ");
        if (dataMap.containsKey(FBeforeAdjust)) {
            upSqlCol.append("FBeforeAdjust = FBeforeAdjust / funit , ");
        }
        if (dataMap.containsKey(FAdjustValue)) {
            upSqlCol.append("FAdjustValue = FAdjustValue / funit , ");
        }
        if (dataMap.containsKey(FBgValue)) {
            upSqlCol.append("FBgValue = FBgValue / funit , ");
        }
        if (dataMap.containsKey(FActual)) {
            upSqlCol.append("FActual = FActual / funit , ");
        }
        if (dataMap.containsKey(FLYBgValue)) {
            upSqlCol.append("FLYBgValue = FLYBgValue / funit , ");
        }
        if (dataMap.containsKey(FLYActual)) {
            upSqlCol.append("FLYActual = FLYActual / funit , ");
        }
        if (dataMap.containsKey(FBgValueSum)) {
            upSqlCol.append("FBgValueSum = FBgValueSum / funit , ");
        }
        if (dataMap.containsKey(FActualSum)) {
            upSqlCol.append("FActualSum = FActualSum / funit , ");
        }
        if (dataMap.containsKey(FTYBgValue)) {
            upSqlCol.append("FTYBgValue = FTYBgValue / funit , ");
        }
        if (dataMap.containsKey(FTYActual)) {
            upSqlCol.append("FTYActual = FTYActual / funit , ");
        }
        if (dataMap.containsKey(FOperationDifference)) {
            upSqlCol.append("FOperationDifference = FOperationDifference / funit , ");
        }
        if (dataMap.containsKey(FBefBizActual)) {
            upSqlCol.append("FBefBizActual = FBefBizActual / funit , ");
        }
        DbUtil.execute((Context)ctx, (String)upSqlCol.toString().substring(0, upSqlCol.length() - 2));
    }

    public static String createElementWithUnitTable(Context ctx, String[] elementArr, BigDecimal[] unitArr, Connection conn) throws Exception {
        String createSql = "create table text (Felement VARCHAR(44), fUnit  decimal(21,6));";
        String elementUnit = BgSqlHelper.addTable(ctx, createSql);
        String insSql = "insert into " + elementUnit + " (felement, funit) values ( ? , ?);";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(insSql);
            for (int i = 0; i < elementArr.length; ++i) {
                pstmt.setString(1, elementArr[i]);
                pstmt.setBigDecimal(2, unitArr[i]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return elementUnit;
    }

    public static void insertOperationData(Context ctx, boolean isOperPlan, boolean isOperDiff, boolean isOperRate, String factTableName) throws Exception {
        String upSql;
        if (isOperPlan) {
            upSql = "update " + factTableName + " set " + FOperationPlan + " = " + FActual + " / " + FBgValue + " where FbgValue is not null and fbgvalue <> 0";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
        if (isOperDiff) {
            upSql = "update " + factTableName + " set " + FOperationDifference + " = " + FBgValue + " - " + FActual;
            DbUtil.execute((Context)ctx, (String)upSql);
        }
        if (isOperRate) {
            upSql = "update " + factTableName + " set " + FOperationDifferRate + " = " + FOperationDifference + " / " + FBgValue + " where FbgValue is not null and fbgvalue <> 0";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
    }

    public static void insertThisYearData(Context ctx, boolean isTYBgValue, boolean isTYActral, BgPeriodInfo endPeriodInfo, String factTableName) throws Exception {
        String upSql;
        if (isTYBgValue) {
            upSql = "update " + factTableName + " set " + FTYBgValue + " = (select B.fbgvalue from (select sum(X.FBgValue) fbgvalue, X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid from t_bg_bgdata X  where   X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgDataAnalyseHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fbegindate>= to_date('" + BgDataAnalyseHelper.dateToStrForYear(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + ") group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId )";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
        if (isTYActral) {
            upSql = "update " + factTableName + " set " + FTYActual + " = (select B.factual from (select sum(X.FBizActual) factual , X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid  from t_bg_bgdata X where  X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgDataAnalyseHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fbegindate>= to_date('" + BgDataAnalyseHelper.dateToStrForYear(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + " ) group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId )";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
    }

    public static void insertSumData(Context ctx, boolean isSumBgValue, boolean isSumActral, BgPeriodInfo endPeriodInfo, String factTableName) throws Exception {
        String upSql;
        if (isSumBgValue) {
            upSql = "update " + factTableName + " set " + FBgValueSum + " = (select B.fbgvalue from (select sum(X.FBgValue) fbgvalue , X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid  from t_bg_bgdata X where X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgDataAnalyseHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + " )group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId )";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
        if (isSumActral) {
            upSql = "update " + factTableName + " set " + FActualSum + " = (select B.factual from (select sum(X.FBizActual) factual , X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid  from t_bg_bgdata X where  X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgDataAnalyseHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + " )group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId )";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
    }

    public static String insertLYdata(Context ctx, boolean isLYB, boolean isLYBR, boolean isLYA, boolean isLYAR, boolean isBA, Map perIdNum, String[] periodIds, Connection conn, String factTableName, BgSchemeInfo currentBgScheme) throws Exception {
        String tmpTablePeriod = null;
        String tmpTableScheme = null;
        if (isLYB || isLYBR || isLYA || isLYAR || isBA) {
            tmpTablePeriod = BgDataAnalyseHelper.createTemPeriodTable(ctx, conn, factTableName, periodIds, perIdNum);
            tmpTableScheme = BgDataAnalyseHelper.createTemSchemeTable(ctx, conn, factTableName, tmpTablePeriod, currentBgScheme.getId().toString());
            String upSql = "";
            if (isLYB) {
                upSql = "update " + factTableName + "  set " + FLYBgValue + " = (select B.fbgvalue  from (select X.FBgValue fbgvalue, X.FBgItemCombinId, X.forgunitid, X.Fbgschemeid,   X.fbgelementid, X.fcurrencyId, X.Fbgperiodid from t_bg_bgdata X where X.fbgperiodid in (select flastyearid from  " + tmpTablePeriod + " ))B  where B.FBgItemCombinId = FItemCombinId  and B.forgunitid = fcompanyid  and B.fbgelementid = felementId  and B.fcurrencyId = fcurrencyId  and FSchemeId = (select top 1 FID from " + tmpTableScheme + " where FLYSchemeId = B.FBgSchemeId) and FPeriodId = (select top 1 fid from  " + tmpTablePeriod + " where flastyearid = B.Fbgperiodid))";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isLYA) {
                upSql = "update " + factTableName + " set " + FLYActual + " = (select B.fActual  from (select X.FBizActual fActual, X.FBgItemCombinId, X.forgunitid, X.Fbgschemeid,   X.fbgelementid, X.fcurrencyId, X.Fbgperiodid  from t_bg_bgdata X where  X.fbgperiodid in (select flastyearid from " + tmpTablePeriod + " ) )B  where B.FBgItemCombinId = FItemCombinId  and B.forgunitid = fcompanyid  and B.fbgelementid = felementId  and B.fcurrencyId = fcurrencyId and FSchemeId = (select top 1 FID from " + tmpTableScheme + " where FLYSchemeId = B.FBgSchemeId) and FPeriodId = (select top 1 fid from  " + tmpTablePeriod + " where flastyearid = B.Fbgperiodid))";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isLYBR) {
                upSql = "update " + factTableName + " set " + FLYBgValueRate + " = (" + FBgValue + " - " + FLYBgValue + ") /" + FLYBgValue + " where " + FLYBgValue + " is not null and " + FLYBgValue + " <> 0";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isLYAR) {
                upSql = "update " + factTableName + " set " + FLYActualRatet + " = (" + FActual + " - " + FLYActual + ") /" + FLYActual + " where " + FLYActual + " is not null and " + FLYActual + " <> 0";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isBA) {
                upSql = "update " + factTableName + " set " + FBefBizActual + " = (select B.fActual  from (select X.FBizActual fActual , X.FBgItemCombinId, X.forgunitid, X.Fbgschemeid,   X.fbgelementid, X.fcurrencyId  from t_bg_bgdata X where  X.fbgperiodid in (select fbefid from " + tmpTablePeriod + " ))B  where B.FBgItemCombinId = FItemCombinId  and B.forgunitid = fcompanyid  and FSchemeId = (select top 1 FID from " + tmpTableScheme + " where FLYSchemeId = B.FBgSchemeId) and B.fbgelementid = felementId  and B.fcurrencyId = fcurrencyId)";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
        }
        return tmpTablePeriod;
    }

    public static String createTemPeriodTable(Context ctx, Connection conn, String factTableName, String[] periodIds, Map perIdNum) throws Exception {
        PreparedStatement pstmtSel = null;
        PreparedStatement pstmtUpdate = null;
        Statement pstmt = null;
        ResultSet rst = null;
        HashMap<String, String> periodLYNum = new HashMap<String, String>();
        HashMap<String, String> periodBNum = new HashMap<String, String>();
        HashMap<String, String> nums = new HashMap<String, String>();
        String num = null;
        String id2 = null;
        String tmpTablePeriod = null;
        try {
            String[] create = new String[]{BgDataAnalyseHelper.createPeriodLastIdTable()};
            tmpTablePeriod = BgSqlHelper.addTable(ctx, create);
            if (tmpTablePeriod != null) {
                pstmt = conn.createStatement();
                String insertSql = "insert into " + tmpTablePeriod + " (Fid) select fperiodId from " + factTableName;
                pstmt.execute(insertSql);
                for (String id2 : perIdNum.keySet()) {
                    num = (String)perIdNum.get(id2);
                    num = BgNPeriodHelper.getOffsetBgPeriodNumberForYear(num, -1);
                    nums.put(num, null);
                    periodLYNum.put(id2, num);
                    num = (String)perIdNum.get(id2);
                    num = BgNPeriodHelper.getOffsetBgPeriodNumber(num, -1);
                    periodBNum.put(id2, num);
                    nums.put(num, null);
                }
                String selSql = "select fid, fnumber from t_bg_bgperiod where fnumber in " + BgHelper.tranMap2String(nums) + " order by fnumber;";
                pstmtSel = conn.prepareStatement(selSql);
                rst = pstmtSel.executeQuery();
                while (rst.next()) {
                    nums.put(rst.getString("fnumber"), rst.getString("fid"));
                }
                String lyNum = null;
                String lyId2 = null;
                String upLyId = "update " + tmpTablePeriod + " set FLastYearID = ? where fid = ?";
                pstmtUpdate = conn.prepareStatement(upLyId);
                for (String lyId2 : periodLYNum.keySet()) {
                    lyNum = (String)periodLYNum.get(lyId2);
                    if (!nums.containsKey(lyNum) || nums.get(lyNum) == null) continue;
                    pstmtUpdate.setString(1, (String)nums.get(lyNum));
                    pstmtUpdate.setString(2, lyId2);
                    pstmtUpdate.addBatch();
                }
                pstmtUpdate.executeBatch();
                SQLUtils.cleanup((Statement)pstmtUpdate);
                String beNum = null;
                String beId2 = null;
                String upBeId = "update " + tmpTablePeriod + " set FBefID = ? where fid = ?";
                pstmtUpdate = conn.prepareStatement(upBeId);
                for (String beId2 : periodBNum.keySet()) {
                    beNum = (String)periodBNum.get(lyId2);
                    if (!nums.containsKey(beNum) || nums.get(beNum) == null) continue;
                    pstmtUpdate.setString(1, (String)nums.get(beNum));
                    pstmtUpdate.setString(2, beId2);
                    pstmtUpdate.addBatch();
                }
            } else {
                throw new BgException(BgException.ERROROFCREATETABLE);
            }
            pstmtUpdate.executeBatch();
            SQLUtils.cleanup((Statement)pstmtUpdate);
        }
        catch (SQLException exx) {
            try {
                throw new SQLException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(rst, pstmtUpdate);
                SQLUtils.cleanup(pstmtSel);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtUpdate);
        SQLUtils.cleanup((Statement)pstmtSel);
        return tmpTablePeriod;
    }

    public static String createTemSchemeTable(Context ctx, Connection conn, String factTableName, String tmpTablePeriod, String currentBgSchemeID) throws Exception {
        String orgUnitId2 = null;
        String lySchemeId = null;
        String tmpTableScheme = null;
        HashMap<String, String> orgSchemeMap = new HashMap<String, String>();
        PreparedStatement pstmtUpdate = null;
        ResultSet rst = null;
        try {
            String[] create = new String[]{"Create Table tmpScheme ( FID VARCHAR(44) NOT NULL, FOrgUnitID VARCHAR(44) NOT NULL, FLYSchemeID VARCHAR(44));"};
            tmpTableScheme = BgSqlHelper.addTable(ctx, create);
            if (tmpTableScheme != null) {
                IRowSet rs = null;
                String insertSql = "insert into " + tmpTableScheme + " (Fid, FOrgUnitId, FLYSchemeID) select distinct FSchemeId, FCompanyId, FSchemeId from " + factTableName;
                DbUtil.execute((Context)ctx, (String)insertSql);
                String sqlCheck = "select fid from t_bg_bgData where FBgSchemeId in (select distinct FSchemeId from " + factTableName + ")  and FOrgUnitId in (select distinct FCompanyID from " + factTableName + ")  and FBgItemCombinId in (select distinct FItemCombinId from " + factTableName + ")  and FBgElementId in (select distinct FElementId from " + factTableName + ")  and FCurrencyId in (select distinct FCurrencyId from " + factTableName + ")  and FBgPeriodId in (select distinct FLastYearId from " + tmpTablePeriod + ") ";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlCheck);
                    if (rs.next()) {
                        String string = tmpTableScheme;
                        return string;
                    }
                }
                catch (SQLException ex) {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs);
                }
                String sql = "select fdatefrom, fdateto from t_bg_bgscheme where fid = '" + currentBgSchemeID + "'";
                java.util.Date sDate = null;
                java.util.Date eDate = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rs.next()) {
                        Date tempSDate = rs.getDate("fdatefrom");
                        Date tempEDate = rs.getDate("fdateto");
                        sDate = new java.util.Date(tempSDate.getYear() - 1, 0, 1, 0, 0, 0);
                        eDate = new java.util.Date(tempEDate.getYear() - 1, 11, 31, 23, 59, 59);
                    }
                }
                catch (BOSException ex) {
                    throw ex;
                }
                catch (SQLException ex) {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs);
                }
                StringBuffer sqlSB = new StringBuffer("select fid ,fname_l2, forgUnitId from t_bg_bgscheme where ");
                sqlSB.append(" ( (fdateto <= to_date('" + BgDataAnalyseHelper.dateToStr(eDate) + "') ");
                sqlSB.append(" and fdateto >= to_date('" + BgDataAnalyseHelper.dateToStr(sDate) + "') ) or");
                sqlSB.append("   ( fdatefrom <= to_date('" + BgDataAnalyseHelper.dateToStr(eDate) + "')");
                sqlSB.append(" and fdatefrom >= to_date('" + BgDataAnalyseHelper.dateToStr(sDate) + "') )");
                sqlSB.append(" ) and fisFormal = 1 ");
                sqlSB.append(" and forgunitid in (select distinct FCompanyId from " + factTableName + ")");
                sqlSB.append(" order by fisformal desc,fnumber asc");
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
                    while (rs.next()) {
                        orgSchemeMap.put(rs.getString("forgUnitId"), rs.getString("fid"));
                    }
                }
                catch (BOSException ex) {
                    throw ex;
                }
                catch (SQLException ex) {
                    throw new BgException(BgException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs);
                }
                String upLyId = "update " + tmpTableScheme + " set FLYSchemeID = ? where FOrgUnitID = ?";
                pstmtUpdate = conn.prepareStatement(upLyId);
                for (String orgUnitId2 : orgSchemeMap.keySet()) {
                    lySchemeId = (String)orgSchemeMap.get(orgUnitId2);
                    pstmtUpdate.setString(1, lySchemeId);
                    pstmtUpdate.setString(2, orgUnitId2);
                    pstmtUpdate.addBatch();
                }
            } else {
                throw new BgException(BgException.ERROROFCREATETABLE);
            }
            pstmtUpdate.executeBatch();
            SQLUtils.cleanup((Statement)pstmtUpdate);
            SQLUtils.cleanup(rst, (Statement)pstmtUpdate);
        }
        catch (SQLException exx) {
            throw new SQLException();
        }
        finally {
            SQLUtils.cleanup(rst, pstmtUpdate);
        }
        return tmpTableScheme;
    }

    public static String getLastBgSchemeID(Context ctx, String currentBgSchemeID, String[] orgs) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currentBgSchemeID)) {
            return currentBgSchemeID;
        }
        String sql = "select fdatefrom , fdateto from t_bg_bgscheme where fid = '" + currentBgSchemeID + "'";
        java.util.Date sDate = null;
        java.util.Date eDate = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                Date tempSDate = rs.getDate("fdatefrom");
                Date tempEDate = rs.getDate("fdateto");
                sDate = new java.util.Date(tempSDate.getYear() - 1, 0, 1, 0, 0, 0);
                eDate = new java.util.Date(tempEDate.getYear() - 1, 11, 31, 23, 59, 59);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        StringBuffer sqlSB = new StringBuffer("select fid ,fname_l2, fisFormal from t_bg_bgscheme where ");
        sqlSB.append(" ( (fdateto <= to_date('" + BgDataAnalyseHelper.dateToStr(eDate) + "') ");
        sqlSB.append(" and fdateto >= to_date('" + BgDataAnalyseHelper.dateToStr(sDate) + "') ) or");
        sqlSB.append("   ( fdatefrom <= to_date('" + BgDataAnalyseHelper.dateToStr(eDate) + "')");
        sqlSB.append(" and fdatefrom >= to_date('" + BgDataAnalyseHelper.dateToStr(sDate) + "') )");
        sqlSB.append(" ) and fisFormal = 1 ");
        sqlSB.append(" and forgunitid in " + BgDataAnalyseHelper.constructInSqlFromStrArr(orgs));
        sqlSB.append(" order by fisformal desc,fnumber asc");
        String idList = currentBgSchemeID;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            while (rs.next()) {
                String id = rs.getString("fid");
                idList = idList + "," + id;
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Throwable)ex, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return idList;
    }

    public static String constructInSqlFromStrArr(String[] arr) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = arr.length;
        for (int i = 0; i < num; ++i) {
            sb.append(arr[i]);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    public static BgPeriodCollection getPeriodCol(Context ctx, BgPeriodInfo[] bgPeriodsN, BgPeriodInfo endPeriodInfo) throws Exception {
        BgPeriodCollection period = new BgPeriodCollection();
        if (bgPeriodsN.length > 1) {
            for (int i = 0; i < bgPeriodsN.length; ++i) {
                period.add(bgPeriodsN[i]);
            }
        } else if (bgPeriodsN[0].getId().equals((Object)endPeriodInfo.getId())) {
            period.add(bgPeriodsN[0]);
        } else {
            period = BgPeriodHelper.getPeriodColInfo((int)endPeriodInfo.getPeriodType().getValue(), (java.util.Date)bgPeriodsN[0].getBeginDate(), (java.util.Date)endPeriodInfo.getEndDate(), (Context)ctx);
        }
        return period;
    }

    public static BgPeriodCollection getPeriodCol(Context ctx, BgPeriodInfo bgPeriodsN, BgPeriodInfo endPeriodInfo) throws Exception {
        BgPeriodCollection period = new BgPeriodCollection();
        if (bgPeriodsN.getId().equals((Object)endPeriodInfo.getId())) {
            period.add(bgPeriodsN);
        } else {
            period = BgPeriodHelper.getPeriodColInfo((int)endPeriodInfo.getPeriodType().getValue(), (java.util.Date)bgPeriodsN.getBeginDate(), (java.util.Date)endPeriodInfo.getEndDate(), (Context)ctx);
        }
        return period;
    }

    public static void insertAdjust(Context ctx, boolean isBeforeAdjust, String factTableName, Map dataIds) throws Exception {
        String selSql = "select U.Fid FBgDataID, L.FSumPastValue FSumPastValue from t_bg_bgdata U LEFT JOIN (select EE.FBgDataID fid, sum(EE.Fpastvalue) FSumPastValue  from  t_bg_bgpastrecord DD, t_bg_bgpastdata EE  where DD.fid = EE.fpastrecordid and EE.fpastrecordid in (select fid from t_bg_bgpastrecord where fpastSource <> " + BgPastSourceEnum.DECOMPOSER.getValue() + ")group by FBgDataID) L ON U.Fid = L.fid where U.fid in " + BgHelper.tranMap2String((Map)dataIds);
        String upSql = "update " + factTableName + "  set " + FAdjustValue + " = (select A.fSumPastValue from (" + selSql + ") A where A.fbgdataId = fdataId)";
        DbUtil.execute((Context)ctx, (String)upSql);
        upSql = "update " + factTableName + "  set " + FAdjustValue + " = 0 where " + FAdjustValue + " is Null";
        DbUtil.execute((Context)ctx, (String)upSql);
        if (isBeforeAdjust) {
            String upBef = "update " + factTableName + " set " + FBeforeAdjust + " = " + FBgValue + " - " + FAdjustValue;
            DbUtil.execute((Context)ctx, (String)upBef);
        }
    }

    public static void insertElement(Context ctx, String[] periodIds, String[] orgs, BgSchemeInfo scheme, String[] bgSchemeIds, String[] elementArr, CurrencyInfo currInfo, Vector itemArr, Map dataMap, Map itemToRef, String factTableName) throws Exception {
        StringBuffer insertSql = new StringBuffer();
        for (int i = 0; i < orgs.length; ++i) {
            insertSql.append("insert into " + factTableName + " ( FdataId , FPeriodId , FCompanyId , FSchemeId , FSchemeRootId , FItemCombinId , FElementId , FCurrencyID " + BgDataAnalyseHelper.isHadValue(dataMap) + ")  select a.fid, a.fbgperiodid, a.forgunitid, b.fid ,b.frootid, a.fbgitemcombinid, a.fbgelementid, a.fcurrencyid " + BgDataAnalyseHelper.isHadValueForData(dataMap) + " from t_bg_bgdata a, t_bg_bgScheme b where a.fbgschemeId = b.fid and  a.forgunitid = '" + orgs[i] + "' and  a.fbgschemeid = '" + bgSchemeIds[i] + "' and  a.fbgElementid in " + BgHelper.tranArray2String((String[])elementArr) + " and  a.FCurrencyId = '" + currInfo.getId().toString() + "' and  a.FBgItemCombinId in " + BgHelper.tranVector2String((Vector)itemArr) + " and ");
            insertSql.append(" a.FbgPeriodId in " + BgHelper.tranArray2String((String[])periodIds));
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            insertSql = new StringBuffer();
        }
        if (itemToRef != null) {
            String upSql = null;
            String key2 = null;
            String value = null;
            StringBuffer values = new StringBuffer();
            boolean isTrue = false;
            for (String key2 : itemToRef.keySet()) {
                value = (String)itemToRef.get(key2);
                values.append(key2 + " = (select B." + value + " from t_bg_bgitemcombination B where B.fid = FItemCombinId) , ");
                isTrue = true;
            }
            if (isTrue) {
                upSql = "update " + factTableName + " set " + values.substring(0, values.length() - 2);
                DbUtil.execute((Context)ctx, (String)upSql);
            }
        }
    }

    public static String isHadValueForData(Map dataMap) {
        String addSql = "";
        if (dataMap.containsKey(FBgValue)) {
            addSql = addSql + " , a.FBgValue";
        }
        if (dataMap.containsKey(FActual)) {
            addSql = addSql + " , a.FBizActual";
        }
        if (dataMap.containsKey(FAdjustValue)) {
            addSql = addSql + " , 0 ";
        }
        return addSql;
    }

    public static String delZeroForData(Map dataMap) {
        String delSql = "";
        int i = 0;
        if (!dataMap.isEmpty() && dataMap.size() > 0) {
            delSql = delSql + " where ";
            if (dataMap.containsKey(FBgValue)) {
                delSql = delSql + " FBgValue <>0 ";
                ++i;
            }
            if (dataMap.containsKey(FActual)) {
                if (i != 0) {
                    delSql = delSql + " or ";
                }
                delSql = delSql + " FActual <>0 ";
                ++i;
            }
            if (dataMap.containsKey(FAdjustValue)) {
                if (i != 0) {
                    delSql = delSql + " or ";
                }
                delSql = delSql + " FAdjustValue <>0";
                ++i;
            }
        }
        return delSql;
    }

    public static String isHadValue(Map dataMap) {
        String addSql = "";
        if (dataMap.containsKey(FBgValue)) {
            addSql = addSql + " , " + FBgValue;
        }
        if (dataMap.containsKey(FActual)) {
            addSql = addSql + " , " + FActual;
        }
        if (dataMap.containsKey(FAdjustValue)) {
            addSql = addSql + " , " + FAdjustValue;
        }
        return addSql;
    }

    public static String getFactData(Map dataMap) {
        String sql = "";
        Iterator ite = dataMap.keySet().iterator();
        while (ite.hasNext()) {
            sql = sql + " , " + ite.next().toString() + " decimal(21,6) ";
        }
        return sql;
    }

    public static String getOrgNums(OrgUnitInfo info) {
        String longN = info.getLongNumber();
        String[] nums = longN.split("!");
        String num = "(";
        for (int i = 0; i < nums.length; ++i) {
            num = i + 1 == nums.length ? num + " '" + nums[i] + "' " : num + " '" + nums[i] + "' , ";
        }
        num = num + ")";
        return num;
    }

    public static String getMeas(Object[][] filterParams, SchemaSource ss, Map dataMap, Map showDataMap) {
        String date = new String();
        date = date + "{";
        for (int i = 0; i < 16 && i != filterParams.length; ++i) {
            if (!((Boolean)filterParams[i][1]).booleanValue()) continue;
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgValueBeforeAdjust", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MFBgValueBeforeAdjust]} , ";
                dataMap.put(FBeforeAdjust, null);
                dataMap.put(FAdjustValue, null);
                dataMap.put(FBgValue, null);
                showDataMap.put(FBeforeAdjust, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"AdjustValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MFAdjustValue]} , ";
                dataMap.put(FAdjustValue, null);
                showDataMap.put(FAdjustValue, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FBgValue, (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MFBgValue]} , ";
                dataMap.put(FBgValue, null);
                showDataMap.put(FBgValue, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActual", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MBizActual]} , ";
                dataMap.put(FActual, null);
                showDataMap.put(FActual, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FLYBgValue, (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MLYBgValue]} , ";
                dataMap.put(FLYBgValue, null);
                showDataMap.put(FLYBgValue, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FLYActualValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MLYActualValue]} , ";
                dataMap.put(FLYActual, null);
                showDataMap.put(FLYActual, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYBgValueRate", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MLYBgValueRate]} , ";
                dataMap.put(FLYBgValueRate, null);
                dataMap.put(FBgValue, null);
                dataMap.put(FLYBgValue, null);
                showDataMap.put(FLYBgValueRate, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FBgValueSum, (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MBgValueSumFinal]} , ";
                dataMap.put(FBgValueSum, null);
                showDataMap.put(FBgValueSum, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActualSum", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MActualValueSumFinal]} , ";
                dataMap.put(FActualSum, null);
                showDataMap.put(FActualSum, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FTYBgValue, (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MTYBgValueFinal]} , ";
                dataMap.put(FTYBgValue, null);
                showDataMap.put(FTYBgValue, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FTYActualValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MTYActualValueFinal]} , ";
                dataMap.put(FTYActual, null);
                showDataMap.put(FTYActual, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationPlan", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[OperationPlan]} , ";
                dataMap.put(FOperationPlan, null);
                dataMap.put(FBgValue, null);
                dataMap.put(FActual, null);
                showDataMap.put(FOperationPlan, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifference", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MOperationDifference]} , ";
                dataMap.put(FOperationDifference, null);
                dataMap.put(FBgValue, null);
                dataMap.put(FActual, null);
                showDataMap.put(FOperationDifference, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifferRate", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[OperationDifferRate]} , ";
                dataMap.put(FOperationDifferRate, null);
                dataMap.put(FBgValue, null);
                dataMap.put(FActual, null);
                showDataMap.put(FOperationDifferRate, null);
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYActualValueRate", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MLYActualValueRate]} , ";
                dataMap.put(FLYActualRatet, null);
                dataMap.put(FActual, null);
                dataMap.put(FLYActual, null);
                showDataMap.put(FLYActualRatet, null);
            }
            if (!((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BefActualValue", (Locale)ContextUtils.getLocaleFromEnv()))) continue;
            date = date + "{[Measures].[FBefBizActual]} , ";
            dataMap.put(FBefBizActual, null);
            showDataMap.put(FBefBizActual, null);
        }
        date = date.substring(0, date.lastIndexOf(",") - 1);
        date = date + "}";
        return date;
    }

    public static void getBgDate(RptParams params, SchemaSource ss, Map dataMap) {
        String[] valueKey = new String[16];
        String[] valueName = new String[16];
        String[] valueCol = new String[16];
        for (int i = 0; i < valueKey.length; ++i) {
            valueKey[i] = null;
            valueName[i] = null;
            valueCol[i] = null;
        }
        if (dataMap.containsKey(FAdjustValue)) {
            valueKey[0] = "MFAdjustValue";
            valueName[0] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"AdjustValue", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[0] = FAdjustValue;
        }
        if (dataMap.containsKey(FBeforeAdjust)) {
            valueKey[1] = "MFBgValueBeforeAdjust";
            valueName[1] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgValueBeforeAdjust", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[1] = FBeforeAdjust;
        }
        if (dataMap.containsKey(FBgValue)) {
            valueKey[2] = "MFBgValue";
            valueName[2] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FBgValue, (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[2] = FBgValue;
        }
        if (dataMap.containsKey(FActual)) {
            valueKey[3] = "MBizActual";
            valueName[3] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActual", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[3] = FActual;
        }
        if (dataMap.containsKey(FLYBgValue)) {
            valueKey[4] = "MLYBgValue";
            valueName[4] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FLYBgValue, (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[4] = FLYBgValue;
        }
        if (dataMap.containsKey(FLYActual)) {
            valueKey[5] = "MLYActualValue";
            valueName[5] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FLYActualValue", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[5] = FLYActual;
        }
        if (dataMap.containsKey(FLYBgValueRate)) {
            valueKey[6] = "MLYBgValueRate";
            valueName[6] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYBgValueRate", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[6] = FLYBgValueRate;
        }
        if (dataMap.containsKey(FLYActualRatet)) {
            valueKey[7] = "MLYActualValueRate";
            valueName[7] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYActualValueRate", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[7] = FLYActualRatet;
        }
        if (dataMap.containsKey(FBgValueSum)) {
            valueKey[8] = "MBgValueSumFinal";
            valueName[8] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FBgValueSum, (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[8] = FBgValueSum;
        }
        if (dataMap.containsKey(FActualSum)) {
            valueKey[9] = "MActualValueSumFinal";
            valueName[9] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActualSum", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[9] = FActualSum;
        }
        if (dataMap.containsKey(FTYBgValue)) {
            valueKey[10] = "MTYBgValueFinal";
            valueName[10] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)FTYBgValue, (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[10] = FTYBgValue;
        }
        if (dataMap.containsKey(FTYActual)) {
            valueKey[11] = "MTYActualValueFinal";
            valueName[11] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FTYActualValue", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[11] = FTYActual;
        }
        if (dataMap.containsKey(FOperationPlan)) {
            valueKey[12] = "OperationPlan";
            valueName[12] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationPlan", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[12] = FOperationPlan;
        }
        if (dataMap.containsKey(FOperationDifference)) {
            valueKey[13] = "MOperationDifference";
            valueName[13] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifference", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[13] = FOperationDifference;
        }
        if (dataMap.containsKey(FOperationDifferRate)) {
            valueKey[14] = "OperationDifferRate";
            valueName[14] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifferRate", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[14] = FOperationDifferRate;
        }
        if (dataMap.containsKey(FBefBizActual)) {
            valueKey[15] = FBefBizActual;
            valueName[15] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BefActualValue", (Locale)ContextUtils.getLocaleFromEnv());
            valueCol[15] = FBefBizActual;
        }
        BgDataAnalyseHelper.setSchemaConfigFileMacroValue(valueKey, valueName, valueCol, ss);
    }

    public static void setSchemaConfigFileMacroValue(String[] valueKey, String[] valueName, String[] valueCol, SchemaSource ss) {
        StringBuffer m = new StringBuffer();
        for (int i = 0; i < valueKey.length; ++i) {
            if (valueKey[i] == null || valueCol[i].equals(FOperationDifferRate) || valueCol[i].equals(FOperationPlan) || valueCol[i].equals(FLYBgValueRate) || valueCol[i].equals(FLYActualRatet)) continue;
            m.append("<Measure name=\"" + valueKey[i] + "\" caption=\"" + valueName[i] + "\" column=\"" + valueCol[i] + "\" aggregator=\"sum\" formatString=\"#,##0.00\"/>\r\n");
        }
        ss.setMacroValue("Measure", m.toString());
    }

    public static String[] getOrgs(OrgUnitInfo[] orgCont) {
        String[] orgs = new String[orgCont.length];
        for (int i = 0; i < orgCont.length; ++i) {
            if (orgCont[i] == null) continue;
            orgs[i] = orgCont[i].getId().toString();
        }
        return orgs;
    }

    public static String dateToStr(java.util.Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd H:mm:ss.mmm");
        return sdf.format(date);
    }

    public static String dateToStrForYear(java.util.Date date) {
        CalendarHelper cal = new CalendarHelper();
        date = cal.getLastDayOfYear(cal.getCurrentlyYear(date) - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd H:mm:ss.mmm");
        return sdf.format(date);
    }

    public static String createPeriodLastIdTable() {
        return "Create Table text ( FID VARCHAR(44) NOT NULL ,FLastYearID VARCHAR(44),FBefID VARCHAR(44));";
    }

    public static void setRateMds(Map dataMap, StringBuffer mdx) {
        if (dataMap.containsKey(FOperationPlan)) {
            mdx.append(" member [Measures].[OperationPlan] as '(iif(([Measures].[MFBgValue] = 0),null,[Measures].[MBizActual]/[Measures].[MFBgValue] ))',formatString='0.00%',solve_order=2,caption='" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationPlan", (Locale)ContextUtils.getLocaleFromEnv()) + "'");
        }
        if (dataMap.containsKey(FLYActualRatet)) {
            mdx.append(" member [Measures].[MLYActualValueRate] as '(iif(([Measures].[MLYActualValue] = 0),null,([Measures].[MBizActual]- [Measures].[MLYActualValue])/[Measures].[MLYActualValue] ))',formatString='0.00%',solve_order=2,caption='" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYActualValueRate", (Locale)ContextUtils.getLocaleFromEnv()) + "'");
        }
        if (dataMap.containsKey(FLYBgValueRate)) {
            mdx.append(" member [Measures].[MLYBgValueRate] as '(iif(([Measures].[MLYBgValue] = 0),null,([Measures].[MFBgValue]- [Measures].[MLYBgValue])/[Measures].[MLYBgValue] ))',formatString='0.00%',solve_order=2,caption='" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYBgValueRate", (Locale)ContextUtils.getLocaleFromEnv()) + "'");
        }
        if (dataMap.containsKey(FOperationDifferRate)) {
            mdx.append(" member [Measures].[OperationDifferRate] as '(iif(([Measures].[MFBgValue] = 0),null,([Measures].[MFBgValue]- [Measures].[MBizActual])/[Measures].[MFBgValue] ))',formatString='0.00%',solve_order=2,caption='" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifferRate", (Locale)ContextUtils.getLocaleFromEnv()) + "'");
        }
    }
}

