/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.app.BgDataFacadeImpl;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class BgDataHelper {
    private BgDataFacadeImpl impl = null;
    private List formulas = new ArrayList();

    public BgDataHelper() {
        this.impl = new BgDataFacadeImpl(this);
    }

    protected List getFormulas() {
        return this.formulas;
    }

    public BgDataFacadeImpl getImpl() {
        return this.impl;
    }

    public void addBgDataInfo(Cell cell, String formula, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal bizActual) throws EASBizException {
        BgNDataInfo _dataInfo = this.addBaseValue(cell, formula, budgetValue, actualValue, bizActual);
        if (_dataInfo != null) {
            _dataInfo.setFormula(formula);
            _dataInfo.setBudgetValue(budgetValue);
            _dataInfo.setActualValue(actualValue);
            _dataInfo.setBizActual(bizActual);
            this.getFormulas().add(_dataInfo);
        }
    }

    public void addBgDataInfo(Cell cell, String formula, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal bizActual, boolean isControl, int controlType, boolean isFlexible, BigDecimal flexParam, boolean isAllowAccess, boolean isGorupCtrl, String groupNo, boolean isFormSuper, boolean isChange) throws EASBizException {
        BgNDataInfo _dataInfo = this.addBaseValue(cell, formula, budgetValue, actualValue, bizActual);
        if (_dataInfo != null) {
            _dataInfo.setControl(isControl);
            _dataInfo.setControlType(controlType);
            _dataInfo.setFlexible(isFlexible);
            _dataInfo.setFlexParam(flexParam);
            _dataInfo.setAllowAccess(isAllowAccess);
            _dataInfo.setGroupCtrl(isGorupCtrl);
            _dataInfo.setGroupNo(groupNo);
            _dataInfo.setFromSuper(isFormSuper);
            _dataInfo.setChange(isChange);
            this.getFormulas().add(_dataInfo);
        }
    }

    public void addBgDataInfo(BgFormInfo model, Cell cell, String formula, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal bizActual, Map ctrlMap, Map defCtrlMap) throws EASBizException {
        BgNDataInfo _dataInfo = this.buildBgNDataInfo(model, cell, formula, budgetValue, actualValue, bizActual, ctrlMap, defCtrlMap);
        if (_dataInfo != null) {
            this.getFormulas().add(_dataInfo);
        }
    }

    public BgNDataInfo buildBgNDataInfo(BgFormInfo model, Cell cell, String formula, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal bizActual, Map ctrlMap, Map defCtrlMap) throws EASBizException {
        BgNDataInfo _dataInfo = this.addBaseValue(cell, formula, budgetValue, actualValue, bizActual);
        if (_dataInfo != null) {
            if (ctrlMap != null) {
                this.addCtrlInfo(model, _dataInfo, ctrlMap);
            } else if (defCtrlMap != null) {
                this.addCtrlInfo(model, _dataInfo, defCtrlMap);
            } else {
                this.addDefCtrlInfo(_dataInfo);
            }
        }
        return _dataInfo;
    }

    public BgNDataInfo buildBgNDataInfo(BgFormInfo model, String formula, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal bizActual, Map ctrlMap, Map defCtrlMap) throws EASBizException {
        BgNDataInfo _dataInfo = this.addBaseValue(formula, budgetValue, actualValue, bizActual);
        if (_dataInfo != null) {
            if (ctrlMap != null) {
                this.addCtrlInfo(model, _dataInfo, ctrlMap);
            } else if (defCtrlMap != null) {
                this.addCtrlInfo(model, _dataInfo, defCtrlMap);
            } else {
                this.addDefCtrlInfo(_dataInfo);
            }
        }
        return _dataInfo;
    }

    public BgNDataInfo addCtrlInfo(BgFormInfo model, BgNDataInfo dataInfo, Map ctrlMap) {
        if (dataInfo != null && ctrlMap != null) {
            Boolean isCtrl = (Boolean)ctrlMap.get("isCtrl");
            if (isCtrl != null) {
                dataInfo.setControl(isCtrl);
            } else {
                dataInfo.setControl(false);
            }
            Integer ctrlType = (Integer)ctrlMap.get("periodCtrlPolicy");
            if (ctrlType != null) {
                dataInfo.setControlType(ctrlType);
            } else {
                dataInfo.setControlType(-1);
            }
            Boolean isFlexible = (Boolean)ctrlMap.get("isFlexCtrl");
            if (isFlexible != null) {
                dataInfo.setFlexible(isFlexible);
            } else {
                dataInfo.setFlexible(false);
            }
            BigDecimal flexParam = (BigDecimal)ctrlMap.get("flexCtrlParam");
            if (flexParam != null) {
                dataInfo.setFlexParam(flexParam);
            } else {
                dataInfo.setFlexParam(BgNConstants.ONE);
            }
            Boolean isAllowAccess = (Boolean)ctrlMap.get("isAllowAccess");
            if (isAllowAccess != null) {
                dataInfo.setAllowAccess(isAllowAccess);
            } else {
                dataInfo.setAllowAccess(true);
            }
            Boolean isGorupCtrl = (Boolean)ctrlMap.get("isGroupCtrl");
            if (isGorupCtrl != null) {
                dataInfo.setGroupCtrl(isGorupCtrl);
            } else {
                dataInfo.setGroupCtrl(false);
            }
            Object _obj = ctrlMap.get("groupCtrlNo");
            if (_obj instanceof Integer) {
                Integer integer = (Integer)_obj;
                if (new Integer(-1).compareTo(integer) == 0) {
                    dataInfo.setGroupNo("-1");
                } else {
                    String groupNO = null;
                    groupNO = BgTemFormTypeEnum.SPECIALFORM.equals((Object)model.getBgTemplate().getFormType()) ? _obj.toString() + "_" + model.getId().toString() : _obj.toString() + "_" + model.getBgTemplate().getId().toString();
                    dataInfo.setGroupNo(groupNO);
                }
            } else if (_obj instanceof String) {
                String[] arr;
                String _tmp = _obj.toString();
                if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)model.getBgTemplate().getFormType()) && (arr = _tmp.split("_")).length == 2) {
                    _tmp = arr[0] + "_" + model.getId().toString();
                }
                dataInfo.setGroupNo(_tmp);
            } else {
                dataInfo.setGroupNo("-1");
            }
            Boolean isFormSuper = (Boolean)ctrlMap.get("isFromSuper");
            if (isFormSuper != null) {
                dataInfo.setFromSuper(isFormSuper);
            } else {
                dataInfo.setFromSuper(false);
            }
            Boolean isChange = (Boolean)ctrlMap.get("isCtrlAllowChange");
            if (isChange != null) {
                dataInfo.setChange(isChange);
            } else {
                dataInfo.setChange(true);
            }
            Integer ctrlMode = (Integer)ctrlMap.get("ctrlModeFrom");
            if (ctrlMode != null) {
                dataInfo.setCtrlMode(ctrlMode);
            } else {
                dataInfo.setCtrlMode(1);
            }
        }
        return dataInfo;
    }

    public BgNDataInfo addDefCtrlInfo(BgNDataInfo dataInfo) {
        dataInfo.setControl(false);
        dataInfo.setControlType(-1);
        dataInfo.setFlexible(false);
        dataInfo.setFlexParam(BgNConstants.ONE);
        dataInfo.setAllowAccess(true);
        dataInfo.setGroupCtrl(false);
        dataInfo.setGroupNo("-1");
        dataInfo.setFromSuper(false);
        dataInfo.setChange(true);
        dataInfo.setCtrlMode(-1);
        return dataInfo;
    }

    public String parseBgFormula(String[] formulaPara, String SpecialNumber) {
        if (formulaPara == null || StringUtils.isEmpty((String)SpecialNumber)) {
            return null;
        }
        String[] _tmpStrs = (String[])formulaPara.clone();
        String _formula = null;
        String _newItemNumber = null;
        String _itemNumber = formulaPara[0];
        if (StringUtils.isEmpty((String)_itemNumber)) {
            return null;
        }
        String[] _strs = _itemNumber.split(",");
        if (_strs != null) {
            int in = _strs.length;
            for (int i = 0; i < in; ++i) {
                if (!SpecialNumber.equals(_strs[i])) continue;
                int jn = _strs.length;
                for (int j = 0; j < jn; ++j) {
                    if (j == i) continue;
                    _newItemNumber = _formula != null ? _formula + "," + _strs[j] : _strs[j];
                }
                break;
            }
            _tmpStrs[0] = _newItemNumber;
            _formula = BgNFSHelper.getItemFormula(_tmpStrs);
        }
        return _formula;
    }

    private BgNDataInfo addBaseValue(Cell cell, String formula, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal bizActual) throws EASBizException {
        BgNDataInfo _dataInfo = null;
        if (!StringUtils.isEmpty((String)formula)) {
            _dataInfo = new BgNDataInfo();
            _dataInfo.setRow(cell.getRow());
            _dataInfo.setCol(cell.getCol());
            _dataInfo.setFormula(formula);
            _dataInfo.setBudgetValue(budgetValue);
            _dataInfo.setActualValue(actualValue);
            _dataInfo.setBizActual(bizActual);
            this.parseBgFormula(_dataInfo);
        }
        return _dataInfo;
    }

    private BgNDataInfo addBaseValue(String formula, BigDecimal budgetValue, BigDecimal actualValue, BigDecimal bizActual) throws EASBizException {
        BgNDataInfo _dataInfo = null;
        if (!StringUtils.isEmpty((String)formula)) {
            _dataInfo = new BgNDataInfo();
            _dataInfo.setFormula(formula);
            _dataInfo.setBudgetValue(budgetValue);
            _dataInfo.setActualValue(actualValue);
            _dataInfo.setBizActual(bizActual);
            this.parseBgFormula(_dataInfo);
        }
        return _dataInfo;
    }

    private void parseBgFormula(BgNDataInfo info) throws EASBizException {
        if (info != null && !StringUtils.isEmpty((String)info.getFormula())) {
            String[] _para = BgNFSHelper.parseFormulaPara(info.getFormula());
            BgNFSHelper.checkFormulaPara(info.getFormula(), _para);
            if (_para != null) {
                info.setBgItemNumber(_para[0]);
                info.setBgPeriodNumber(_para[1]);
                info.setBgElementNumber(_para[2]);
                info.setCurrencyNumber(_para[5]);
            }
        }
    }

    public void removeBgDataInfo(String formula) {
        this.getFormulas().remove(formula);
    }

    public Object[] compareBgDataInfo(Context ctx, BOSUuid bgFormId, String orgId, String bgSchemeId) throws BOSException, EASBizException {
        return this.getImpl().compareBgDataInfo(ctx, bgFormId, orgId, bgSchemeId);
    }

    public void checkFormulaIsEctype(Context ctx, BgFormInfo model, Object[] objs) throws Exception {
        this.getImpl().checkFormulaIsEctypeFromTmpTable(ctx, model, objs);
    }

    public void disposeBgDataValue(Context ctx, BgFormInfo model, Object[] objs) throws BOSException, EASBizException {
        this.getImpl().disposeBgDataValue(ctx, model, objs);
    }
}

