/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgActualRecordStateEnum;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDecException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.nbudget.BgDecompActualRecordFactory;
import com.kingdee.eas.ma.nbudget.BgDecompActualRecordInfo;
import com.kingdee.eas.ma.nbudget.BgExpressionsParseHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.IBgDecompActualRecord;
import com.kingdee.eas.ma.nbudget.RefBgDecActualRecordCollection;
import com.kingdee.eas.ma.nbudget.RefBgDecActualRecordFactory;
import com.kingdee.eas.ma.nbudget.RefBgDecActualRecordInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgDecompActualRecordControllerBean;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDecompActualRecordControllerBean
extends AbstractBgDecompActualRecordControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgDecompActualRecordControllerBean");

    @Override
    protected Map _getBgForm(Context ctx, String id) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fname,fnumber from t_bg_bgform where fid=(");
        sql.append("select fbgformid from t_bg_bgactualrecord where fid='");
        sql.append(id).append("' );");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        set.size();
        try {
            while (set.next()) {
                result.put("fid", set.getString("fid"));
                result.put("fname", set.getString("fname"));
                result.put("fnumber", set.getString("fnumber"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            return null;
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        String sql = "select fstate from t_bg_bgdecompactualrecord where fid=?";
        Object[] param = new Object[]{pk.toString()};
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            while (rs.next()) {
                int state = rs.getInt("fstate");
                if (101 != state) continue;
                throw new CanNotDeleteException();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"Error", (Throwable)ex);
                throw new CanNotDeleteException();
                catch (BOSException ex2) {
                    logger.error((Object)"Error", (Throwable)ex2);
                    throw new CanNotDeleteException();
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    protected ArrayList _checkSelectedOrg(Context ctx, Map orgMap, String artualRecordID) throws BOSException {
        ArrayList rusltrList = new ArrayList();
        Iterator it = orgMap.keySet().iterator();
        while (it.hasNext()) {
        }
        return rusltrList;
    }

    @Override
    protected void _addBgActualRecordToChildren(Context ctx, Map orgIdsMap, String bgActualId) throws BOSException, EASBizException {
        IBgActualRecord iBgActualRecord = BgActualRecordFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgForm.id");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.rootId");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.rootId");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.*");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.*");
        sic.add("isFormulaFromTem");
        sic.add("isEditByPeriod");
        BgActualRecordInfo bgActual = iBgActualRecord.getBgActualRecordInfo((IObjectPK)new ObjectStringPK(bgActualId), sic);
        boolean isformulaFromTem = bgActual.isIsFormulaFromTem();
        boolean isEditByPeriod = bgActual.isIsEditByPeriod();
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance((Context)ctx);
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance((Context)ctx);
        if (bgActual == null || orgIdsMap.size() < 1) {
            return;
        }
        boolean isLockedOpen = BgParamCHelper.isLockedOfOpen();
        String schemeRootId = bgActual.getBgForm().getBgScheme().getRootId().toString();
        String templateRootId = bgActual.getBgForm().getBgTemplate().getRootId().toString();
        String currencyId = bgActual.getBgForm().getCurrency().getId().toString();
        String periodId = bgActual.getBgForm().getBgPeriod().getId().toString();
        String orgUnitId2 = null;
        for (String orgUnitId2 : orgIdsMap.keySet()) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("select fid from t_bg_bgactualrecord where fbgformid in (");
                sql.append("select fid from t_bg_bgform f ");
                sql.append("where f.fbgschemeid = (select fid from t_bg_bgscheme where frootid= ? and forgunitid = ? )");
                sql.append("and f.fbgtemplateid = (select fid from t_bg_bgtemplate where frootid= ? and forgunitid = ? ) ");
                sql.append("and f.fbgperiodid= ? ");
                sql.append("and f.fcurrencyid= ? ");
                sql.append("and f.forgunitid = ? ");
                sql.append(" ) and fbgperiodid = ? ");
                sql.append(" and fstate in (");
                sql.append(2).append(" ,");
                sql.append(14).append(" ) ;");
                IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{schemeRootId, orgUnitId2, templateRootId, orgUnitId2, periodId, currencyId, orgUnitId2, bgActual.getBgPeriod().getId().toString()});
                sql = new StringBuffer();
                sql.append("select f.fid,f.forgunitid from t_bg_bgform f ");
                sql.append("where f.fbgschemeid = (select fid from t_bg_bgscheme where frootid= ? and forgunitid = ? ) ");
                sql.append("and f.fbgtemplateid = (select fid from t_bg_bgtemplate where frootid= ? and forgunitid = ? ) ");
                sql.append("and f.fbgperiodid= ? ");
                sql.append("and f.fcurrencyid= ? ");
                sql.append("and f.forgunitid = ? ");
                sql.append("and f.fstate=2  ;");
                IRowSet formSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{schemeRootId, orgUnitId2, templateRootId, orgUnitId2, periodId, currencyId, orgUnitId2});
                if (resultSet.size() != 0 || formSet.size() == 0) continue;
                formSet.next();
                String bgformID = formSet.getString("fid");
                BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgformID), this.getFormSelectors());
                BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo("where rootId = '" + schemeRootId + "' and orgUnit = '" + orgUnitId2 + "'");
                BgTemplateInfo bgTemplateInfo = null;
                BgTemplateCollection templateCol = iBgTemplate.getBgTemplateCollection("where rootId = '" + templateRootId + "' and orgUnit = '" + orgUnitId2 + "' and id in (select fbgTemplateid from t_bg_BgSchemeNode where fbgSchemeid = '" + bgSchemeInfo.getId().toString() + "'  ) order by createTime ");
                if (templateCol.size() <= 0) continue;
                bgTemplateInfo = templateCol.get(0);
                BgActualRecordInfo bgActualInfo = new BgActualRecordInfo();
                bgActualInfo.setIsFormulaFromTem(isformulaFromTem);
                bgActualInfo.setIsEditByPeriod(isEditByPeriod);
                bgActualInfo.setId(BOSUuid.create((BOSObjectType)bgActualInfo.getBOSType()));
                bgActualInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                bgActualInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bgActualInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                fullOrgUnit = iFullOrgUnit.getFullOrgUnitInfo("where id = '" + bgTemplateInfo.getOrgUnit().getId().toString() + "'");
                CompanyOrgUnitInfo companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)fullOrgUnit, ctx);
                if (companyInfo != null) {
                    bgActualInfo.setCompany(companyInfo);
                }
                bgActualInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                bgActualInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
                bgActualInfo.setBgForm(bgFormInfo);
                bgActualInfo.setBgPeriod(bgActual.getBgPeriod());
                String bgFormName = null;
                bgFormName = bgActualInfo.getCU().getName() != null ? bgActualInfo.getCU().getName().trim() + "_" + bgActualInfo.getBgPeriod().getName().trim() + "_" + fullOrgUnit.getName().trim() : bgActualInfo.getCU().getName().trim() + "_" + bgActualInfo.getBgPeriod().getName().trim() + "_" + fullOrgUnit.getName().trim();
                bgActualInfo.setName(bgFormName.length() > 80 ? bgFormName.substring(1, 80) : bgFormName);
                Book formB = bgFormInfo.getBook();
                if (isformulaFromTem) {
                    BgTemplateInfo temInfo = bgFormInfo.getBgTemplate();
                    Book temB = temInfo.getBook();
                    if (formB == null || temB == null) {
                        return;
                    }
                    HashMap<String, String> formulaMap = new HashMap<String, String>();
                    Sheet sheet = null;
                    Cell cell = null;
                    for (int i = 0; i < temB.getSheetCount(); ++i) {
                        sheet = temB.getSheet(i);
                        for (int m = 0; m <= sheet.getMaxRowIndex(); ++m) {
                            for (int n = 0; n <= sheet.getMaxColIndex(); ++n) {
                                cell = sheet.getCell(m, n, false);
                                if (!BgNFSHelper.checkHasExpression(cell, 2)) continue;
                                formulaMap.put(BgNFSHelper.getRowSign(sheet.getRow(m, false)) + BgNFSHelper.getColSign(sheet.getColumn(n, false)), BgNFSHelper.loadExpression(cell, 2));
                            }
                        }
                    }
                    String companyNumber = BgNExpressionHelper.getCompanyNumber(ctx, (IObjectValue)bgFormInfo);
                    for (int i = 0; i < formB.getSheetCount(); ++i) {
                        sheet = formB.getSheet(i);
                        for (int m = 0; m <= sheet.getMaxRowIndex(); ++m) {
                            for (int n = 0; n <= sheet.getMaxColIndex(); ++n) {
                                cell = sheet.getCell(m, n, false);
                                if (cell == null) continue;
                                if (formulaMap.containsKey(BgNFSHelper.getRowSign(sheet.getRow(m, false)) + BgNFSHelper.getColSign(sheet.getColumn(n, false)))) {
                                    BgNFSHelper.saveExpression(cell, (String)formulaMap.get(BgNFSHelper.getRowSign(sheet.getRow(m, false)) + BgNFSHelper.getColSign(sheet.getColumn(n, false))), 2);
                                    BgNFSHelper.checkExpressions(cell, (IObjectValue)bgFormInfo, 2, companyNumber);
                                    continue;
                                }
                                BgNFSHelper.clearExpression(cell, 2);
                            }
                        }
                    }
                }
                bgActualInfo.setData(IOHelper.packBook((Book)formB));
                this.updateValueAndExpression(ctx, bgActualInfo, isLockedOpen);
                bgActualInfo.setState(BgActualRecordStateEnum.decomposer);
                bgActualInfo.setMeasureUnit(bgTemplateInfo.getDefaultMeasureUnit());
                iBgActualRecord.save((CoreBaseInfo)bgActualInfo);
            }
            catch (BOSException ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
    }

    protected void updateValueAndExpression(Context ctx, BgActualRecordInfo bgActualRecord, boolean isLockedOpen) throws BgFormException, BOSException {
        Book book = null;
        try {
            book = bgActualRecord.getBook();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        boolean isEnum = false;
        if (bgActualRecord != null && bgActualRecord.getBgForm() != null && bgActualRecord.getBgForm().getBgTemplate() != null && bgActualRecord.getBgForm().getBgTemplate().getFormType() != null) {
            boolean bl = isEnum = bgActualRecord.getBgForm().getBgTemplate().getFormType().getValue() == 1;
        }
        if (book == null) {
            return;
        }
        String companyNumber = BgNExpressionHelper.getCompanyNumber(ctx, (IObjectValue)bgActualRecord);
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String expression = null;
        int _sheetSize = book.getSheetCount();
        for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = book.getSheet(_sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    BgNLockProtectHelper.setCellLockedAndProtectionOnlyCell(_cell, false, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        BgNFSHelper.setFormulaEditOfCell(_cell, false);
                        BgNFSHelper.setValue(_cell, null);
                        expression = BgNFSHelper.loadExpression(_cell, 2);
                        if (!StringUtils.isEmpty((String)expression)) {
                            if (isEnum) {
                                String e_budget = BgNFSHelper.loadExpression(_cell, 0);
                                String e_actual = BgNFSHelper.loadExpression(_cell, 1);
                                if (BgExpressionsParseHelper.isSumExpress(expression) && BgExpressionsParseHelper.isSumExpress(e_actual) && BgExpressionsParseHelper.isSumExpress(e_budget)) {
                                    expression = e_budget;
                                }
                            }
                            String tmpExp = BgNExpressionHelper.checkExpression(_cell, expression, (IObjectValue)bgActualRecord, null, companyNumber);
                            BgNFSHelper.setExpression(_cell, tmpExp);
                        } else {
                            BgNFSHelper.clearExpression(_cell);
                        }
                    }
                    if (!_cell.hasFormula()) continue;
                    BgNFSHelper.setValue(_cell, null);
                    if (!isLockedOpen) continue;
                    BgNFSHelper.setLockOfCell(_cell, true);
                }
            }
        }
        try {
            bgActualRecord.setBook(book);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo, Context ctx) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent, ctx);
        }
        return null;
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    private SelectorItemCollection getFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("data"));
        sic.add("bgTemplate.formType");
        sic.add(new SelectorItemInfo("bgTemplate.data"));
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addNewData(Context ctx, Map decIdMap) throws BOSException, EASBizException {
        if (decIdMap == null) {
            return;
        }
        String decId = (String)decIdMap.get("decId");
        String mainSql = "update T_BG_BgDecompActualRecord set FKdtData = (select fdata from T_BG_BgActualRecord where fid = T_BG_BgDecompActualRecord.FBgActualRecordID) where fid = ?";
        String subSql = "update T_BG_RefBgDecActualRecord set FKdtData = (select fdata from T_BG_BgActualRecord where fid = T_BG_RefBgDecActualRecord.FBgActualRecordID) where FBgDecompserID = ?";
        String decActuSql = "update t_bg_bgactualrecord set fstate=15 where fid=(select fbgactualrecordid from T_BG_BgDecompActualRecord where fid=? )  ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(mainSql);
            pstmt.setString(1, decId);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(subSql);
            pstmt.setString(1, decId);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement(decActuSql);
            pstmt.setString(1, decId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)"", (Throwable)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _loadAllRelateInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (id == null) {
            return resultMap;
        }
        IBgDecompActualRecord iDec = BgDecompActualRecordFactory.getLocalInstance(ctx);
        BgDecompActualRecordInfo info = iDec.getBgDecompActualRecordInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        IBgActualRecord iBgActualRecord = BgActualRecordFactory.getLocalInstance((Context)ctx);
        ICostCenterOrgUnit iccOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        if (info == null) {
            throw new BgException(BgException.NOOBJECT);
        }
        ObjectUuidPK pk = new ObjectUuidPK(info.getBgActualRecord().getId());
        BgActualRecordInfo bgActualRecordInfo = null;
        CostCenterOrgUnitInfo ccOrgInfo = null;
        HashSet<String> orgSet = new HashSet<String>();
        if (!iBgActualRecord.exists((IObjectPK)pk)) {
            throw new BgException(BgException.NOOBJECT);
        }
        bgActualRecordInfo = iBgActualRecord.getBgActualRecordInfo((IObjectPK)pk, this.getBgActualRecordInfo());
        resultMap.put("bgActualRecordInfo", bgActualRecordInfo);
        ccOrgInfo = iccOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(bgActualRecordInfo.getBgForm().getOrgUnit().getId()));
        resultMap.put("defOrgUnitInfo", ccOrgInfo);
        orgSet.add(ccOrgInfo.getId().toString());
        CostCenterOrgUnitCollection refOrgUnitCol = new CostCenterOrgUnitCollection();
        HashSet<String> orgId = new HashSet<String>();
        if (info.getRefBgDecActualRecord() != null && !info.getRefBgDecActualRecord().isEmpty()) {
            RefBgDecActualRecordInfo refBgDecActualRecordInfo = null;
            RefBgDecActualRecordCollection refBgDecomActualCol = info.getRefBgDecActualRecord();
            int n = refBgDecomActualCol.size();
            for (int i = 0; i < n; ++i) {
                refBgDecActualRecordInfo = refBgDecomActualCol.get(i);
                if (refBgDecActualRecordInfo.getBgActualRecord() == null || refBgDecActualRecordInfo.getBgActualRecord().getBgForm().getOrgUnit() == null) {
                    throw new BgDecException(BgDecException.NOTHAVEBGFORM);
                }
                orgId.add(refBgDecActualRecordInfo.getBgActualRecord().getBgForm().getOrgUnit().getId().toString());
                orgSet.add(refBgDecActualRecordInfo.getBgActualRecord().getBgForm().getOrgUnit().getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection item = filter.getFilterItems();
        item.add(new FilterItemInfo("id", orgId, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        refOrgUnitCol = iccOrgUnit.getCostCenterOrgUnitCollection(viewInfo);
        resultMap.put("refOrgUnitCol", refOrgUnitCol);
        EntityViewInfo view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sore = new SorterItemInfo("longNumber");
        sore.setSortType(SortType.DESCEND);
        view.getSorter().add(sore);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        CostCenterOrgUnitCollection costCenterOrgUnitColl = null;
        HashMap<BOSUuid, CostCenterOrgUnitInfo> orgSheetCheckMap = new HashMap<BOSUuid, CostCenterOrgUnitInfo>();
        try {
            costCenterOrgUnitColl = iccOrgUnit.getCostCenterOrgUnitCollection(view);
            int size = costCenterOrgUnitColl.size();
            for (int i = 0; i < size; ++i) {
                costCenterOrgUnitInfo = costCenterOrgUnitColl.get(i);
                if (costCenterOrgUnitInfo == null) continue;
                orgSheetCheckMap.put(costCenterOrgUnitInfo.getId(), costCenterOrgUnitInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        resultMap.put("orgSheetCheckMap", orgSheetCheckMap);
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        }
        resultMap.put("currencyMap", currencyMap);
        return resultMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("bgActualRecord.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.id"));
        sic.add(new SelectorItemInfo("bgActualRecord.name"));
        sic.add(new SelectorItemInfo("bgActualRecord.data"));
        sic.add(new SelectorItemInfo("bgActualRecord.number"));
        sic.add(new SelectorItemInfo("bgActualRecord.currency.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.currency.id"));
        sic.add(new SelectorItemInfo("bgActualRecord.currency.number"));
        sic.add(new SelectorItemInfo("bgActualRecord.currency.name"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.id"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.id"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.data"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.number"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.bgForm.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.bgForm.orgUnit.*"));
        return sic;
    }

    public SelectorItemCollection getBgActualRecordInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgForm.*"));
        sic.add(new SelectorItemInfo("bgForm.orgUnit.*"));
        sic.add(new SelectorItemInfo("bgForm.bgScheme.*"));
        sic.add(new SelectorItemInfo("bgForm.bgTemplate.*"));
        sic.add(new SelectorItemInfo("bgForm.bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setBgActualRecordStatus(ctx, (BgDecompActualRecordInfo)model, BgActualRecordStateEnum.decomposer);
        this.addNewGetOldData(ctx, model);
        return super._addnew(ctx, model);
    }

    private void setBgActualRecordStatus(Context ctx, BgDecompActualRecordInfo bgActualRecordInfo, BgActualRecordStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgActualRecordStatus = new StringBuffer("UPDATE T_BG_BgDecompActualRecord SET FState = ? WHERE");
        RefBgDecActualRecordCollection refBgActualRecordCols = bgActualRecordInfo.getRefBgDecActualRecord();
        sqlToUpdateBgActualRecordStatus.append(" FID = ");
        sqlToUpdateBgActualRecordStatus.append("'");
        sqlToUpdateBgActualRecordStatus.append(bgActualRecordInfo.getBgActualRecord().getId().toString());
        sqlToUpdateBgActualRecordStatus.append("'");
        int count = refBgActualRecordCols.size();
        for (int i = 0; i < count; ++i) {
            sqlToUpdateBgActualRecordStatus.append(" OR ");
            sqlToUpdateBgActualRecordStatus.append(" FID = ");
            sqlToUpdateBgActualRecordStatus.append("'");
            sqlToUpdateBgActualRecordStatus.append(refBgActualRecordCols.get(i).getBgActualRecord().getId().toString());
            sqlToUpdateBgActualRecordStatus.append("'");
        }
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgActualRecordStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void addNewGetOldData(Context ctx, IObjectValue model) {
        BgDecompActualRecordInfo info = (BgDecompActualRecordInfo)model;
        HashMap<String, Object> bgActualRecordIDs = new HashMap<String, Object>();
        ArrayList<String> mutexIds = new ArrayList<String>();
        bgActualRecordIDs.put(info.getBgActualRecord().getId().toString(), null);
        int n = info.getRefBgDecActualRecord().size();
        for (int i = 0; i < n; ++i) {
            bgActualRecordIDs.put(info.getRefBgDecActualRecord().get(i).getBgActualRecord().getId().toString(), null);
            mutexIds.add(info.getRefBgDecActualRecord().get(i).getBgActualRecord().getId().toString());
        }
        try {
            IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            iMC.batchRequestObjIDForUpdate(mutexIds);
            Map oldData = this._getOldData(ctx, bgActualRecordIDs);
            HashMap<String, byte[]> otherData = new HashMap<String, byte[]>();
            otherData.put("oldData", BgHelper.storeHashMapToByte((HashMap)((HashMap)oldData)));
            if (otherData != null && !otherData.isEmpty()) {
                info.setOtherCon(BgHelper.storeHashMapToByte(otherData));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getOldData(Context ctx, Map bgActualRecordID) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> itemValue = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fbgactualrecordid, fformula, FBizActual  from T_bg_bgActualdata where fbgactualrecordid = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String id : bgActualRecordID.keySet()) {
                pstmt.setString(1, id);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    itemValue.put(rst.getString(1) + rst.getString(2), rst.getBigDecimal(3));
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return itemValue;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateAdjustData(Context ctx, String id, Map adjustMap) throws BOSException, EASBizException {
        if (id == null) return;
        if (adjustMap == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgActualRecord.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.id"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgForm.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.id"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.id"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.bgForm.*"));
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BgDecompActualRecordInfo info = this.getBgDecompActualRecordInfo(ctx, (IObjectPK)pk, sic);
        String mainActualSql = "update T_BG_BgDecompActualRecord set FAdjustMapData = ? where FId = ?";
        String entryActualSql = "update T_BG_RefBgDecActualRecord set FAdjustMapData = ? where FId = ?";
        Connection conn = null;
        PreparedStatement mainPrst = null;
        PreparedStatement entryPrst = null;
        try {
            conn = this.getConnection(ctx);
            BOSUuid mainBgActualId = info.getBgActualRecord().getId();
            if (adjustMap.containsKey(mainBgActualId)) {
                HashMap childAdjMap = (HashMap)adjustMap.get(mainBgActualId);
                mainPrst = conn.prepareStatement(mainActualSql);
                mainPrst.setBytes(1, BgHelper.storeHashMapToByte((HashMap)childAdjMap));
                mainPrst.setString(2, info.getId().toString());
                mainPrst.executeUpdate();
                childAdjMap.clear();
            }
            RefBgDecActualRecordInfo refInfo = null;
            entryPrst = conn.prepareStatement(entryActualSql);
            int size = info.getRefBgDecActualRecord().size();
            for (int i = 0; i < size; ++i) {
                refInfo = info.getRefBgDecActualRecord().get(i);
                BOSUuid entryFormId = refInfo.getBgActualRecord().getId();
                if (!adjustMap.containsKey(entryFormId)) continue;
                HashMap childAdjMap = (HashMap)adjustMap.get(entryFormId);
                entryPrst.setBytes(1, BgHelper.storeHashMapToByte((HashMap)childAdjMap));
                entryPrst.setString(2, refInfo.getId().toString());
                entryPrst.addBatch();
                childAdjMap.clear();
            }
            entryPrst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (IOException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(mainPrst, (Connection)conn);
                SQLUtils.cleanup(entryPrst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)mainPrst, (Connection)conn);
        SQLUtils.cleanup((Statement)entryPrst);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgDecompActualRecord iBgDecompActualRecaord = BgDecompActualRecordFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bgActualRecord.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.id"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.id"));
        sic.add(new SelectorItemInfo("id"));
        BgDecompActualRecordInfo info = iBgDecompActualRecaord.getBgDecompActualRecordInfo(pk, sic);
        if (info == null) {
            SysUtil.abort();
            return;
        }
        this.updateBgActualRecord(ctx, (IObjectPK)new ObjectUuidPK(info.getBgActualRecord().getId()));
        RefBgDecActualRecordCollection son = info.getRefBgDecActualRecord();
        Iterator it = son.iterator();
        while (it.hasNext()) {
            RefBgDecActualRecordInfo refBgDecActualRecordInfo = (RefBgDecActualRecordInfo)it.next();
            this.updateBgActualRecord(ctx, (IObjectPK)new ObjectUuidPK(refBgDecActualRecordInfo.getBgActualRecord().getId()));
        }
        super._delete(ctx, pk);
    }

    private boolean updateBgActualRecord(Context ctx, IObjectPK pk) throws BOSException {
        boolean result = false;
        String sql = "update t_bg_bgActualRecord set fstate= 1 where fstate = 15 and fid='" + pk.toString() + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
        return result;
    }

    @Override
    protected Object[] _calculate(Context ctx, String bgFormId, String mainFormId, String bgDecId, Map adjustMap) throws BOSException, EASBizException {
        if (bgFormId == null || mainFormId == null || bgDecId == null) {
            return null;
        }
        IBgActualRecord iBgAcualRecord = BgActualRecordFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
        ObjectUuidPK mainPk = new ObjectUuidPK(mainFormId);
        if (!iBgAcualRecord.exists((IObjectPK)pk)) {
            return null;
        }
        if (!iBgAcualRecord.exists((IObjectPK)mainPk)) {
            return null;
        }
        byte[] newData = null;
        Object[] obj = null;
        String key = null;
        BgActualRecordInfo info = iBgAcualRecord.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(bgFormId), this.getActualSelector());
        info.put("myBgPeriod", (Object)info.getBgPeriod());
        try {
            if (info.getId().toString().equals(mainFormId)) {
                key = "from`" + info.getId().toString();
                newData = this.getMainNewData(ctx, info.getId(), bgDecId);
            } else {
                key = "ref`" + info.getId().toString();
                newData = this.getRefNewData(ctx, info.getId(), bgDecId);
            }
            if (newData != null) {
                info.setData(this.getNewDataToRefCal(newData, IOHelper.unpackBook((byte[])newData), info.getId(), adjustMap));
            } else if (info.getData() != null) {
                info.setData(this.getNewDataToRefCal(info.getData(), IOHelper.unpackBook((byte[])info.getData()), info.getId(), adjustMap));
            }
            ArrayList tableData = ReportFactory.getLocalInstance((Context)ctx).backCalcEx((IObjectValue)info.getBgForm(), info.getZipData(), null);
            obj = this._updateBgFormData(ctx, bgFormId, (IObjectValue)info, tableData);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        Object[] result = new Object[2];
        if (obj != null) {
            result[0] = obj[0];
            result[1] = bgFormId.equals(mainFormId) ? (Map)obj[2] : null;
            RefBgDecFormInfo refInfo = new RefBgDecFormInfo();
            HashMap<String, RefBgDecFormInfo> dataMap = new HashMap<String, RefBgDecFormInfo>();
            refInfo.setKdtData((byte[])obj[1]);
            dataMap.put(key, refInfo);
            if (refInfo != null) {
                this._updateDataForForm(ctx, bgDecId, dataMap);
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _updateDataForForm(Context ctx, String bgDecId, Map dataMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement refPstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgDecomposerForm  set  FKdtData = ? where FBgFormID = ? and fid = ?");
            refPstmt = conn.prepareStatement("update T_BG_RefBgDecForm  set  FKdtData = ? where FBgFormID = ? and FBgDecomposerID = ?");
            String typeId2222222 = null;
            String[] type = null;
            for (String typeId2222222 : dataMap.keySet()) {
                type = typeId2222222.split("`");
                if (type[0].equals("from")) {
                    pstmt.setBytes(1, ((RefBgDecFormInfo)dataMap.get(typeId2222222)).getKdtData());
                    pstmt.setString(2, type[1]);
                    pstmt.setString(3, bgDecId);
                    pstmt.executeUpdate();
                    continue;
                }
                if (!type[0].equals("ref")) continue;
                refPstmt.setBytes(1, ((RefBgDecFormInfo)dataMap.get(typeId2222222)).getKdtData());
                refPstmt.setString(2, type[1]);
                refPstmt.setString(3, bgDecId);
                refPstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(refPstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)refPstmt);
    }

    protected Object[] _updateBgFormData(Context ctx, String bgFormId, IObjectValue info, ArrayList tableData) throws BOSException, EASBizException {
        Book book = null;
        try {
            book = ((BgActualRecordInfo)info).getBook();
        }
        catch (Exception e) {
            return null;
        }
        if (book == null) {
            return null;
        }
        Object[] obj = new Object[3];
        HashMap adjustMap = new HashMap();
        HashMap valueMap = new HashMap();
        if (tableData != null) {
            int index = 0;
            ArrayList tbl = null;
            ArrayList row = null;
            if (book == null || book.getSheetCount() <= 0) {
                return null;
            }
            book.setCalculate(false);
            int sheetCount = book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                Sheet sheet = book.getSheet(sheetIndex);
                tbl = (ArrayList)tableData.get(index);
                if (tbl != null) {
                    int rowCount = sheet.getMaxRowIndex() + 1;
                    int colCount = sheet.getMaxColIndex() + 1;
                    for (int r = 0; r < rowCount; ++r) {
                        for (int c = 0; c < colCount; ++c) {
                            Cell cell = sheet.getCell(r, c, false);
                            boolean b = BgNFSHelper.checkHasExpression(cell);
                            if (b) {
                                cell.updateFormula();
                            }
                            if (!b || tbl.size() < r) continue;
                            row = (ArrayList)tbl.get(r);
                            if (row.get(c) != null) {
                                BgNFSHelper.setValue(cell, row.get(c));
                            } else {
                                cell.setValue(null);
                            }
                            if (row != null && BgNFSHelper.checkHasFormulaOfCell(cell)) {
                                String formulaString = BgNFSHelper.getFormulaOfCell(cell);
                                if (formulaString == null || formulaString.trim().length() <= 0) continue;
                                if (row.get(c) != null) {
                                    BgNFSHelper.getItemFormula(cell).putExt("BG_ACTUAL_VALUE", String.valueOf(row.get(c)));
                                } else {
                                    BgNFSHelper.getItemFormula(cell).putExt("BG_ACTUAL_VALUE", null);
                                }
                                adjustMap.put(formulaString, row.get(c));
                                continue;
                            }
                            String expr = BgNFSHelper.getExpression(cell);
                            valueMap.put(expr, row.get(c));
                        }
                    }
                }
                ++index;
            }
        }
        byte[] data = null;
        try {
            data = IOHelper.packBook((Book)book);
        }
        catch (IOException e) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e.getMessage()});
        }
        obj[0] = adjustMap;
        obj[1] = data;
        obj[2] = valueMap;
        return obj;
    }

    private byte[] getNewDataToRefCal(byte[] data, Book book, BOSUuid bgFormId, Map adjustMap) throws Exception {
        if (adjustMap == null || adjustMap.isEmpty() || adjustMap.toString().equals("{}")) {
            return data;
        }
        if (book == null) {
            return data;
        }
        Sheet table = null;
        ArrayList<String> formulaList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> valueRow = new ArrayList<String>();
        ArrayList<String> valueCol = new ArrayList<String>();
        ArrayList<String> isCtrl = new ArrayList<String>();
        ArrayList<String> isFlexCtrl = new ArrayList<String>();
        ArrayList<String> flexCtrlParam = new ArrayList<String>();
        ArrayList<String> periodCtrlPolicy = new ArrayList<String>();
        ArrayList<String> isGroupCtrl = new ArrayList<String>();
        ArrayList<String> groupCtrlNo = new ArrayList<String>();
        ArrayList<String> isAllowAccess = new ArrayList<String>();
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        String formulaString = null;
        String ctrlString = null;
        BgFormDiversityData adjustData = null;
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        for (int n = 0; n < book.getSheetCount(); ++n) {
            table = book.getSheet(n);
            rowCount = table.getMaxRowIndex() + 1;
            colCount = table.getMaxColIndex() + 1;
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    Cell cell = table.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaString = BgNFSHelper.getFormulaOfCell(cell);
                    if (adjustMap.containsKey(formulaString)) {
                        adjustData = (BgFormDiversityData)adjustMap.get(formulaString);
                        if (adjustData == null || adjustData.getNewValue() == null) {
                            BgNFSHelper.setValue(cell, null);
                            BgNFSHelper.getItemFormula(cell).putExt("BG_ACTUAL_VALUE", null);
                        } else {
                            BgNFSHelper.setValue(cell, adjustData.getNewValue());
                            BgNFSHelper.getItemFormula(cell).putExt("BG_ACTUAL_VALUE", adjustData.getNewValue().toString());
                        }
                        if (adjustData.getOldValue() == null) {
                            adjustData.setOldValue(BgConstants.BIGZERO);
                        }
                        if (adjustData.getNewValue().compareTo(adjustData.getOldValue()) != 0) {
                            BgNFSHelper.setBackGroup(cell, BgSHelper.EDIT_COLOR);
                        }
                    }
                    if (!BgNFSHelper.checkCanEditFormulaOfCell(cell)) continue;
                    formulaList.add(formulaString);
                    if (adjustMap.containsKey(formulaString)) {
                        adjustData = (BgFormDiversityData)adjustMap.get(formulaString);
                        if (adjustData == null || adjustData.getNewValue() == null) {
                            valueList.add("0");
                        } else {
                            valueList.add(adjustData.getNewValue().toString());
                        }
                    } else if (cell.getValue() != Variant.nullVariant) {
                        valueList.add(cell.getValue().toString());
                    } else {
                        valueList.add("0");
                    }
                    valueRow.add(String.valueOf(rowIndex));
                    valueCol.add(String.valueOf(colIndex));
                    ctrlString = BgNFSHelper.getItemFormula(cell).getExt("isCtrl");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isCtrl.add(null);
                    } else {
                        isCtrl.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula(cell).getExt("isFlexCtrl");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isFlexCtrl.add(null);
                    } else {
                        isFlexCtrl.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula(cell).getExt("flexCtrlParam");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        flexCtrlParam.add(null);
                    } else {
                        flexCtrlParam.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula(cell).getExt("periodCtrlPolicy");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        periodCtrlPolicy.add(null);
                    } else {
                        periodCtrlPolicy.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula(cell).getExt("isGroupCtrl");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isGroupCtrl.add(null);
                    } else {
                        isGroupCtrl.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula(cell).getExt("groupCtrlNo");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        groupCtrlNo.add(null);
                    } else {
                        groupCtrlNo.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula(cell).getExt("isAllowAccess");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isAllowAccess.add(null);
                        continue;
                    }
                    isAllowAccess.add(ctrlString);
                }
            }
        }
        return IOHelper.packBook((Book)book);
    }

    private byte[] getRefNewData(Context ctx, BOSUuid uuid, String bgDecId) throws Exception {
        RefBgDecActualRecordInfo info = RefBgDecActualRecordFactory.getLocalInstance(ctx).getRefBgDecActualRecordInfo("select id , kdtData where bgDecompser.id = '" + bgDecId + "' and bgActualRecord.id = '" + uuid.toString() + "'");
        return info == null ? null : info.getKdtData();
    }

    private byte[] getMainNewData(Context ctx, BOSUuid uuid, String bgDecId) throws Exception {
        BgDecompActualRecordInfo info = BgDecompActualRecordFactory.getLocalInstance(ctx).getBgDecompActualRecordInfo("select id, kdtData where id = '" + bgDecId + "'");
        return info == null ? null : info.getKdtData();
    }

    @Override
    protected List _checkChildOrg(Context ctx, Map orgMap, IObjectValue actualrecordInfo) throws BOSException, EASBizException {
        IBgActualRecord iBgActualRecord = BgActualRecordFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bgForm.id"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("bgForm.*"));
        sic.add(new SelectorItemInfo("bgForm.bgScheme.*"));
        sic.add(new SelectorItemInfo("bgForm.bgTemplate.*"));
        sic.add(new SelectorItemInfo("bgForm.bgPeriod.*"));
        sic.add(new SelectorItemInfo("bgForm.currency.*"));
        BgActualRecordInfo bgActualRecordInfo = iBgActualRecord.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(((BgActualRecordInfo)actualrecordInfo).getId()), sic);
        ArrayList<String> result = new ArrayList<String>();
        String schemeRootId = bgActualRecordInfo.getBgForm().getBgScheme().getRootId().toString();
        String templateRootId = bgActualRecordInfo.getBgForm().getBgTemplate().getRootId().toString();
        String currencyId = bgActualRecordInfo.getBgForm().getCurrency().getId().toString();
        String periodId = bgActualRecordInfo.getBgForm().getBgPeriod().getId().toString();
        String orgUnitId2 = null;
        for (String orgUnitId2 : orgMap.keySet()) {
            boolean isPeriodAcross = this._checkBgPeriodAcross(ctx, bgActualRecordInfo.getBgPeriod().getBeginDate(), bgActualRecordInfo.getBgPeriod().getEndDate(), orgUnitId2, schemeRootId, templateRootId, currencyId, periodId, bgActualRecordInfo.getBgPeriod().getId().toString());
            if (isPeriodAcross) {
                result.add("@" + orgMap.get(orgUnitId2));
                return result;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select fid from t_bg_bgactualrecord where fbgformid in (");
            sql.append("select fid from t_bg_bgform f ");
            sql.append("where f.fbgschemeid = (select fid from t_bg_bgscheme where frootid= ? and forgunitid = ? )");
            sql.append("and f.fbgtemplateid = (select fid from t_bg_bgtemplate where frootid= ? and forgunitid = ? ) ");
            sql.append("and f.fbgperiodid= ? ");
            sql.append("and f.fcurrencyid= ? ");
            sql.append("and f.forgunitid = ? ");
            sql.append(" ) and fbgperiodid= ?  ");
            sql.append(" and fstate in (");
            sql.append(2).append(" ,");
            sql.append(14).append(" ) ;");
            IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{schemeRootId, orgUnitId2, templateRootId, orgUnitId2, periodId, currencyId, orgUnitId2, bgActualRecordInfo.getBgPeriod().getId().toString()});
            sql = new StringBuffer();
            sql.append("select f.fid,f.forgunitid from t_bg_bgform f ");
            sql.append("where f.fbgschemeid = (select fid from t_bg_bgscheme where frootid= ? and forgunitid = ? ) ");
            sql.append("and f.fbgtemplateid = (select fid from t_bg_bgtemplate where frootid= ? and forgunitid = ? ) ");
            sql.append("and f.fbgperiodid= ? ");
            sql.append("and f.fcurrencyid= ? ");
            sql.append("and f.forgunitid = ? ");
            sql.append("and f.fstate=2  ;");
            IRowSet formSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{schemeRootId, orgUnitId2, templateRootId, orgUnitId2, periodId, currencyId, orgUnitId2});
            if (resultSet.size() == 0 && formSet.size() != 0) continue;
            result.add((String)orgMap.get(orgUnitId2));
        }
        return result;
    }

    protected boolean _checkBgPeriodAcross(Context ctx, Date begin, Date end, String orgId, String schemeRootId, String templateRootId, String currencyId, String periodId, String actualRecordPeriodID) throws BOSException, EASBizException {
        block5: {
            StringBuffer sqlA = new StringBuffer();
            sqlA.append("select fid from t_bg_bgactualrecord where fbgformid in (");
            sqlA.append("select fid from t_bg_bgform f ");
            sqlA.append("where f.fbgschemeid = (select fid from t_bg_bgscheme where frootid= ? and forgunitid = ? )");
            sqlA.append("and f.fbgtemplateid = (select fid from t_bg_bgtemplate where frootid= ? and forgunitid = ? ) ");
            sqlA.append("and f.fbgperiodid= ? ");
            sqlA.append("and f.fcurrencyid= ? ");
            sqlA.append("and f.forgunitid = ? ");
            sqlA.append(" ) and fbgperiodid in (select fid from t_bg_bgperiod where fbegindate <= ? and  fenddate >= ? ) and fbgperiodid <> ? ");
            IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)sqlA.toString(), (Object[])new Object[]{schemeRootId, orgId, templateRootId, orgId, periodId, currencyId, orgId, new Timestamp(end.getTime()), new Timestamp(begin.getTime()), actualRecordPeriodID});
            if (!resultSet.next()) break block5;
            boolean bl = true;
            return bl;
        }
        try {
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _confirm(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        this.updateDecompActualRecord(ctx, id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgActualRecord.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.id"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.id"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.adjustMapData"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.*"));
        sic.add(new SelectorItemInfo("refBgDecActualRecord.bgActualRecord.id"));
        BgDecompActualRecordInfo bgDecompInfo = this.getBgDecompActualRecordInfo(ctx, id, sic);
        if (bgDecompInfo == null) {
            SysUtil.abort();
            return;
        }
        String sql = "";
        sql = "update t_bg_bgActualRecord set fstate=1 where fid='" + bgDecompInfo.getBgActualRecord().getId().toString() + "' ;";
        DbUtil.execute((Context)ctx, (String)sql);
        RefBgDecActualRecordCollection colls = bgDecompInfo.getRefBgDecActualRecord();
        RefBgDecActualRecordInfo childInfo = null;
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            childInfo = (RefBgDecActualRecordInfo)it.next();
            sql = "update t_bg_bgActualRecord set fstate=1  where fid='" + childInfo.getBgActualRecord().getId().toString() + "' ;";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        sql = "update T_BG_BgDecompActualRecord set fstate=101 where fid='" + bgDecompInfo.getId().toString() + "' ;";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void updateDecompActualRecord(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgActualRecord iBgActualRecord = BgActualRecordFactory.getLocalInstance((Context)ctx);
        IBgDecompActualRecord ibgdec = BgDecompActualRecordFactory.getLocalInstance(ctx);
        if (ibgdec == null || iBgActualRecord == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        BgDecompActualRecordInfo bgDecompActualRecordInfo = null;
        if (!ibgdec.exists(pk)) {
            throw new BgCollectException(BgCollectException.NODATA);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("KdtData");
        sic.add("adjustMapData");
        sic.add("state");
        sic.add("bgActualRecord.*");
        sic.add("bgActualRecord.id");
        sic.add("refBgDecActualRecord.*");
        sic.add("refBgDecActualRecord.id");
        sic.add("refBgDecActualRecord.kdtData");
        sic.add("refBgDecActualRecord.adjustMapData");
        sic.add("refBgDecActualRecord.bgActualRecord.*");
        sic.add("refBgDecActualRecord.bgActualRecord.id");
        bgDecompActualRecordInfo = ibgdec.getBgDecompActualRecordInfo(pk, sic);
        Map adjustMap = null;
        try {
            adjustMap = this.loadDiversityInfo(bgDecompActualRecordInfo);
        }
        catch (Exception e) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        BOSUuid bgActualId = null;
        Connection conn = null;
        bgActualId = bgDecompActualRecordInfo.getBgActualRecord().getId();
        BgActualRecordInfo bgActualRecordInfo = null;
        StringBuffer bgActualId_ForDeleteTmpData = new StringBuffer("(");
        StringBuffer bgActualId_ForUpdateBgActualRecord = new StringBuffer("(");
        try {
            conn = this.getConnection(ctx);
            if (adjustMap != null && !adjustMap.isEmpty() && adjustMap.get(bgActualId) != null && !adjustMap.get(bgActualId).toString().equals("{}") && iBgActualRecord.exists(pk = new ObjectUuidPK(bgActualId))) {
                bgActualRecordInfo = iBgActualRecord.getBgActualRecordInfo(pk, this.getActualSelector());
                this.processUpdateBgActualDataByte(conn, bgActualId, bgDecompActualRecordInfo.getKdtData());
                bgActualRecordInfo.setData(bgDecompActualRecordInfo.getKdtData());
                this.processUpdateBgActualInfoData(ctx, iBgActualRecord, bgActualId, (Map)adjustMap.get(bgActualId), BgPastSourceEnum.DECOMPOSER, bgActualRecordInfo);
                bgActualId_ForUpdateBgActualRecord.append("'" + bgActualId.toString() + "',");
            }
            bgActualId_ForDeleteTmpData.append("'" + bgActualId.toString() + "',");
            RefBgDecActualRecordInfo refInfo = null;
            RefBgDecActualRecordCollection refCol = bgDecompActualRecordInfo.getRefBgDecActualRecord();
            if (refCol != null && !refCol.isEmpty()) {
                int n = refCol.size();
                for (int i = 0; i < n; ++i) {
                    refInfo = refCol.get(i);
                    bgActualId = refInfo.getBgActualRecord().getId();
                    bgActualId_ForDeleteTmpData.append("'" + bgActualId.toString() + "',");
                    if (adjustMap == null || adjustMap.isEmpty() || adjustMap.get(bgActualId) == null || adjustMap.get(bgActualId).toString().equals("{}") || !iBgActualRecord.exists(pk = new ObjectUuidPK(bgActualId))) continue;
                    bgActualRecordInfo = iBgActualRecord.getBgActualRecordInfo(pk, this.getActualSelector());
                    this.processUpdateBgActualDataByte(conn, bgActualId, refInfo.getKdtData());
                    bgActualRecordInfo.setData(refInfo.getKdtData());
                    this.processUpdateBgActualInfoData(ctx, iBgActualRecord, bgActualId, (Map)adjustMap.get(bgActualId), BgPastSourceEnum.DECOMPOSER, bgActualRecordInfo);
                    bgActualId_ForUpdateBgActualRecord.append("'" + bgActualId.toString() + "',");
                }
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void processUpdateBgActualDataByte(Connection conn, BOSUuid bgFormId, byte[] data) throws EASBizException {
        if (conn == null || bgFormId == null || data == null || data.length == 0) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("update T_BG_BgActualRecord set FData = ? where FID = ?");
            pstmt.setBytes(1, data);
            pstmt.setString(2, bgFormId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"Error: ", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadDiversityInfo(BgDecompActualRecordInfo bgDecompActualRecordInfo) throws Exception {
        Map childAdjustMap = null;
        HashMap adjustMap = new HashMap();
        if (bgDecompActualRecordInfo != null) {
            byte[] data = bgDecompActualRecordInfo.getAdjustMapData();
            if (data == null || data.length == 0) {
                childAdjustMap = new HashMap();
                adjustMap.put(bgDecompActualRecordInfo.getBgActualRecord().getId(), childAdjustMap);
            } else {
                InputStream is = null;
                ObjectInputStream ois = null;
                try {
                    is = ZipUtil.unpack((byte[])data);
                    ois = new ObjectInputStream(is);
                    childAdjustMap = (Map)ois.readObject();
                    if (childAdjustMap == null) {
                        childAdjustMap = new HashMap();
                    }
                    adjustMap.put(bgDecompActualRecordInfo.getBgActualRecord().getId(), childAdjustMap);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                }
            }
            RefBgDecActualRecordInfo refBgDecActualInfo = null;
            int n = bgDecompActualRecordInfo.getRefBgDecActualRecord().size();
            for (int i = 0; i < n; ++i) {
                refBgDecActualInfo = bgDecompActualRecordInfo.getRefBgDecActualRecord().get(i);
                data = refBgDecActualInfo.getAdjustMapData();
                if (data == null || data.length == 0) {
                    childAdjustMap = new HashMap();
                    adjustMap.put(refBgDecActualInfo.getBgActualRecord().getId(), childAdjustMap);
                    continue;
                }
                InputStream is = null;
                ObjectInputStream ois = null;
                try {
                    is = ZipUtil.unpack((byte[])data);
                    ois = new ObjectInputStream(is);
                    childAdjustMap = (Map)ois.readObject();
                    if (childAdjustMap == null) {
                        childAdjustMap = new HashMap();
                    }
                    adjustMap.put(refBgDecActualInfo.getBgActualRecord().getId(), childAdjustMap);
                    continue;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        return adjustMap;
    }

    private void processUpdateBgActualInfoData(Context ctx, IBgActualRecord ibgActual, BOSUuid bgBgAtualId, Map adjustMap, BgPastSourceEnum tableEnum, BgActualRecordInfo bgActualRecordInfo) throws BOSException, EASBizException {
        if (ctx == null || ibgActual == null || bgBgAtualId == null || adjustMap == null) {
            return;
        }
        if (bgActualRecordInfo == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        if (adjustMap.isEmpty()) {
            return;
        }
        Book book = null;
        Sheet sheet = null;
        Object tableCol = null;
        ArrayList<String> formulaList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> valueRow = new ArrayList<String>();
        ArrayList<String> valueCol = new ArrayList<String>();
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        String formulaString = null;
        BgFormDiversityData adjustData = null;
        try {
            book = bgActualRecordInfo.getBook();
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
            for (int n = 0; n < book.getSheetCount(); ++n) {
                sheet = book.getSheet(n);
                rowCount = sheet.getMaxRowIndex() + 1;
                colCount = sheet.getMaxColIndex() + 1;
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex < colCount; ++colIndex) {
                        Cell cell = sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        formulaString = BgNFSHelper.getFormulaOfCell(cell);
                        if (adjustMap.containsKey(formulaString)) {
                            adjustData = (BgFormDiversityData)adjustMap.get(formulaString);
                            if (adjustData == null || adjustData.getNewValue() == null) {
                                BgNFSHelper.setValue(cell, BgNConstants.ZERO);
                            } else {
                                BgNFSHelper.setValue(cell, adjustData.getNewValue());
                            }
                            if (adjustData.getNewValue().compareTo(adjustData.getOldValue()) == 0) {
                                BgNFSHelper.setBackGroup(cell, BgSHelper.BASE_COLOR);
                            }
                        }
                        formulaList.add(formulaString);
                        if (adjustMap.containsKey(formulaString)) {
                            adjustData = (BgFormDiversityData)adjustMap.get(formulaString);
                            if (adjustData == null || adjustData.getNewValue() == null) {
                                valueList.add("0");
                            } else {
                                valueList.add(adjustData.getNewValue().toString());
                            }
                        } else if (cell.getValue() != Variant.nullVariant) {
                            valueList.add(cell.getValue().toString());
                        } else {
                            valueList.add("0");
                        }
                        valueRow.add(String.valueOf(rowIndex));
                        valueCol.add(String.valueOf(colIndex));
                    }
                }
            }
            if (bgActualRecordInfo.getAuditTime() != null) {
                bgActualRecordInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
            }
            bgActualRecordInfo.setBook(book);
            bgActualRecordInfo.setState(BgActualRecordStateEnum.Edited);
            ibgActual.save((CoreBaseInfo)bgActualRecordInfo);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Error: ", (Throwable)ex);
            throw new BOSException(ex.getMessage());
        }
        finally {
            book = null;
        }
    }

    protected void processClearFormulaIsAdjust(Context ctx, BOSUuid id, List formulas) throws EASBizException, BOSException {
        if (id == null || formulas == null || formulas.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        BgActualRecordInfo bgActualRecordInfo = null;
        IBgActualRecord iBgActualRecord = null;
        ObjectUuidPK pk = null;
        try {
            conn = this.getConnection(ctx);
            iBgActualRecord = BgActualRecordFactory.getLocalInstance((Context)ctx);
            if (iBgActualRecord == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            pk = new ObjectUuidPK(id);
            if (!iBgActualRecord.exists((IObjectPK)pk)) {
                return;
            }
            bgActualRecordInfo = iBgActualRecord.getBgActualRecordInfo((IObjectPK)pk, this.getActualSelector());
            int index = 0;
            int batchNum = 50;
            int size = formulas.size();
            int count = (size - 1) / batchNum + 1;
            int pos = 0;
            String noFindStr = "#";
            StringBuffer sql = new StringBuffer(1024);
            sql.append("DELETE FROM T_BG_BGActualDATA WHERE FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula IN (");
            for (index = 1; index < batchNum; ++index) {
                sql.append("?, ");
            }
            sql.append("?) AND fbgactualrecordid = ?");
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString());
                pstmt.setString(2, bgActualRecordInfo.getBgForm().getBgScheme().getId().toString());
                int k = 3;
                while (k <= batchNum + 2) {
                    if (pos < size) {
                        pstmt.setString(k, (String)formulas.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                pstmt.setString(batchNum + 3, bgActualRecordInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"Error: ", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    public SelectorItemCollection getActualSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("data");
        sic.add("bgPeriod.*");
        sic.add("bgForm.id");
        sic.add("bgForm.name");
        sic.add("bgForm.number");
        sic.add("bgForm.createTime");
        sic.add("bgForm.creator.id");
        sic.add("bgForm.creator.name");
        sic.add("bgForm.state");
        sic.add("bgForm.auditedStatus");
        sic.add("bgForm.dataSource");
        sic.add("bgForm.description");
        sic.add("bgForm.versionNo");
        sic.add("bgForm.startDate");
        sic.add("bgForm.endDate");
        sic.add("bgForm.data");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.company.id");
        sic.add("bgForm.company.name");
        sic.add("bgForm.company.number");
        sic.add("bgForm.company.isBizUnit");
        sic.add("bgForm.company.accountPeriodType.id");
        sic.add("bgForm.CU.id");
        sic.add("bgForm.CU.name");
        sic.add("bgForm.bgType.id");
        sic.add("bgForm.bgType.name");
        sic.add("bgForm.bgType.number");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.bgScheme.period");
        sic.add("bgForm.bgScheme.rootId");
        sic.add("bgForm.bgScheme.isFormal");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.name");
        sic.add("bgForm.bgTemplate.number");
        sic.add("bgForm.bgTemplate.canModify");
        sic.add("bgForm.bgTemplate.parent.id");
        sic.add("bgForm.bgTemplate.rootId");
        sic.add("bgForm.bgTemplate.formType");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.name");
        sic.add("bgForm.bgPeriod.number");
        sic.add("bgForm.bgPeriod.periodType");
        sic.add("bgForm.bgPeriod.beginDate");
        sic.add("bgForm.bgPeriod.endDate");
        sic.add("bgForm.bgPeriod.year");
        sic.add("bgForm.bgPeriod.halfYear");
        sic.add("bgForm.bgPeriod.quarter");
        sic.add("bgForm.bgPeriod.month");
        sic.add("bgForm.bgPeriod.week");
        sic.add("bgForm.periodType");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.currency.name");
        sic.add("bgForm.currency.number");
        sic.add("bgForm.currency.isoCode");
        sic.add("bgForm.currency.precision");
        sic.add("bgForm.bgItemGroup.id");
        sic.add("bgForm.bgItemGroup.name");
        sic.add("bgForm.bgItemGroup.number");
        sic.add("bgForm.bgItemEntry.id");
        sic.add("bgForm.bgItemEntry.name");
        sic.add("bgForm.bgItemEntry.number");
        sic.add("bgForm.measureUnit.id");
        sic.add("bgForm.measureUnit.name");
        sic.add("bgForm.measureUnit.number");
        sic.add("bgForm.measureUnit.coefficient");
        sic.add("bgForm.bgMeasureUnit.id");
        sic.add("bgForm.bgMeasureUnit.bgElement.id");
        sic.add("bgForm.bgMeasureUnit.bgElement.name");
        sic.add("bgForm.bgMeasureUnit.bgElement.number");
        sic.add("bgForm.bgMeasureUnit.measureUnit.id");
        sic.add("bgForm.bgMeasureUnit.measureUnit.name");
        sic.add("bgForm.bgMeasureUnit.measureUnit.number");
        sic.add("bgForm.bgMeasureUnit.measureUnit.coefficient");
        sic.add("bgForm.bgItemEntry.id");
        sic.add("bgForm.bgItemEntry.name");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.id");
        sic.add("sheetParam.*");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.sheet.sheetID");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("bgForm.adjust.id");
        sic.add("bgForm.adjustMapData");
        sic.add("bgForm.auditTime");
        sic.add("bgForm.courseOrgId");
        return sic;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgDecompActualRecordInfo info = (BgDecompActualRecordInfo)super._getValue(ctx, pk);
        return info.getNumber() + "  " + info.getName();
    }
}

