/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgElimException;
import com.kingdee.eas.ma.nbudget.BgElimTemplateCollection;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryCollection;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryInfo;
import com.kingdee.eas.ma.nbudget.BgElimTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgElimTemplateControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgElimTemplateControllerBean
extends AbstractBgElimTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgElimTemplateControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgElimTemplateCollection col;
        BgElimTemplateInfo info = (BgElimTemplateInfo)model;
        String oql = "where treeid = '" + info.getTreeId() + "' and number = '" + info.getNumber() + "'";
        if (info.getId() != null) {
            oql = oql + " and id <> '" + info.getId().toString() + "'";
        }
        if ((col = this.getBgElimTemplateCollection(ctx, oql)) != null && !col.isEmpty()) {
            throw new BgElimException(BgElimException.ELIMTEMPLATENUMBERDUPLACTED);
        }
        Connection conn = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            BgElimTemplateEntryCollection entryCol = info.getEntries();
            BgElimTemplateEntryInfo entryInfo = null;
            Map mapCombinNum = new HashMap();
            if (entryCol != null && !entryCol.isEmpty()) {
                for (i = 0; i < entryCol.size(); ++i) {
                    mapCombinNum.put(entryCol.get(i).getBgItemNumber(), null);
                }
                mapCombinNum = BgEliminationHelper.dealWithBgItemCombin(ctx, mapCombinNum);
            }
            if (mapCombinNum != null && !mapCombinNum.isEmpty()) {
                for (i = 0; i < entryCol.size(); ++i) {
                    entryInfo = entryCol.get(i);
                    entryInfo.setBgItemId((String)mapCombinNum.get(entryInfo.getBgItemNumber()));
                }
            }
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.checkLength(info);
        return super._save(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgElimTemplateInfo info = (BgElimTemplateInfo)model;
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgElimTemplate_add");
        IObjectPK result = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return result;
    }

    private void checkLength(BgElimTemplateInfo info) {
        String str = null;
        str = info.getNumber();
        if (!StringUtils.isEmpty((String)str) && str.length() > 80) {
            info.setNumber(str.substring(0, 79));
        }
        if (!StringUtils.isEmpty((String)(str = info.getName())) && str.length() > 80) {
            info.setName(str.substring(0, 79));
        }
        BgElimTemplateEntryCollection entryCol = info.getEntries();
        BgElimTemplateEntryInfo entryInfo = null;
        for (int i = 0; i < entryCol.size(); ++i) {
            entryInfo = entryCol.get(i);
            str = entryInfo.getComment();
            if (StringUtils.isEmpty((String)str) || str.length() <= 80) continue;
            entryInfo.setComment(str.substring(0, 79));
        }
    }

    @Override
    protected boolean _activate(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)id)) {
            return false;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT e.FBgItemNumber,e.FBgItemName, t.FNumber, t.FName FROM T_BG_BGElimTemplateEntry e ").append(" INNER JOIN T_BG_BGElimTemplate t ON t.FID = e.FElimTemplateId ").append(" WHERE e.FBgItemNumber IN (SELECT FBgItemNumber FROM T_BG_BGElimTemplateEntry ").append(" WHERE FElimTemplateId = ? ) ").append(" AND e.FElimTemplateId <> ? ").append(" AND t.FTreeId = (SELECT FTreeId FROM T_BG_BGElimTemplate WHERE FID = ?)").append(" AND t.FIsEffective = 1 ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" UPDATE T_BG_BGElimTemplate SET FIsEffective = 1 WHERE FID = ? ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, id);
            pstmt.setString(3, id);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BgElimException(BgElimException.DUPLICATEBGITEMINELIMTEMPLATE, new String[]{rst.getString(1), rst.getString(3)});
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement(sql2.toString());
            pstmt.setString(1, id);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _deactivate(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)id)) {
            return false;
        }
        DbUtil.execute((Context)ctx, (String)(" UPDATE T_BG_BGElimTemplate SET FIsEffective = 0 WHERE FID = '" + id + "'"));
        return true;
    }

    @Override
    protected Map _checkBgItemRef(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<Integer, Object> returnMap = new HashMap<Integer, Object>();
        returnMap.put(new Integer(0), null);
        if (StringUtils.isEmpty((String)id)) {
            return returnMap;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("treeId");
        sic.add("orgUnitId");
        sic.add("isEffective");
        sic.add("entries.bgItemNumber");
        BgElimTemplateInfo editData = this.getBgElimTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sic);
        return this._checkBgItemRef(ctx, (IObjectValue)editData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _checkBgItemRef(Context ctx, IObjectValue editData) throws BOSException, EASBizException {
        HashMap hashMap;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block20: {
            HashMap returnMap = new HashMap();
            if (editData == null) {
                return returnMap;
            }
            BgElimTemplateInfo info = (BgElimTemplateInfo)editData;
            BgElimTemplateEntryCollection entryCol = info.getEntries();
            String treeId = info.getTreeId();
            String orgUnitId = info.getOrgUnitId();
            ArrayList<String> numberList = new ArrayList<String>();
            HashMap<String, String> longNumMap = new HashMap<String, String>();
            ArrayList<String> eItemList = new ArrayList<String>();
            for (int i = 0; i < entryCol.size(); ++i) {
                numberList.add(entryCol.get(i).getBgItemNumber());
            }
            orgUnitId = BgSHelper.getIsolateOrg((Context)ctx, (String)orgUnitId);
            conn = null;
            pstmt = null;
            rst = null;
            int index = 0;
            int batchSize = 50;
            int size = numberList.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FNumber, FLongNumber FROM T_BG_BgItem WHERE FNumber IN (");
            for (index = 1; index < batchSize; ++index) {
                sql.append("?,");
            }
            sql.append("?) AND FOrgUnitID = ? ORDER BY FLongnumber");
            StringBuffer sql2 = new StringBuffer();
            sql2.append("SELECT FLongNumber FROM T_BG_BgItem WHERE FNumber IN (");
            sql2.append(" SELECT e.FBgItemNumber FROM T_BG_BgElimTemplateEntry e ");
            sql2.append(" JOIN T_BG_BGElimTemplate t ON t.FID = e.FElimTemplateId ");
            sql2.append(" WHERE t.FIsEffective = 1 AND t.FOrgUnitID = ? AND t.FID <> ?)");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                index = 0;
                while (true) {
                    if (index < count) {
                    } else {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                        pstmt = conn.prepareStatement(sql2.toString());
                        pstmt.setString(1, orgUnitId);
                        pstmt.setString(2, info.getId().toString());
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            eItemList.add(rst.getString(1));
                        }
                        break;
                    }
                    for (int i = 1; i < batchSize + 1; ++i, ++pos) {
                        if (pos < size) {
                            pstmt.setString(i, (String)numberList.get(pos));
                            continue;
                        }
                        pstmt.setString(i, "#");
                    }
                    pstmt.setString(batchSize + 1, orgUnitId);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        longNumMap.put(rst.getString(2), rst.getString(1));
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    ++index;
                }
                String longNum = null;
                int ref = 0;
                int checkSize = eItemList.size();
                Iterator it = longNumMap.keySet().iterator();
                block11: while (true) {
                    if (!it.hasNext()) {
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                        if (returnMap.isEmpty()) {
                            returnMap.put(new Integer(0), null);
                        }
                        return returnMap;
                    }
                    longNum = (String)it.next();
                    int i = 0;
                    while (true) {
                        if (i >= checkSize) continue block11;
                        ref = this.checkItemRef(longNum, (String)eItemList.get(i));
                        if (ref > 1) {
                            returnMap.put(new Integer(ref), longNumMap.get(longNum));
                            hashMap = returnMap;
                            break block20;
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"error", (Throwable)e);
                    throw new BgException(BgException.DATABASEERROR, (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hashMap;
    }

    private int checkItemRef(String longNum, String longNum2) {
        int ref = 0;
        if (!StringUtils.isEmpty((String)longNum) && !StringUtils.isEmpty((String)longNum2)) {
            if (longNum.length() >= longNum2.length()) {
                if (longNum.equals(longNum2)) {
                    ref = 1;
                } else if (longNum.indexOf(longNum2 + "!") != -1) {
                    ref = 2;
                }
            } else if (longNum2.indexOf(longNum + "!") != -1) {
                ref = 3;
            }
        }
        return ref;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgElimTemplateInfo editData = this.getBgElimTemplateInfo(ctx, pk);
        if (editData.isIsEffective()) {
            return;
        }
        String logName = editData.getNumber() + " " + editData.getName();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgElimTemplate_remove");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgElimTemplateInfo info = (BgElimTemplateInfo)super._getValue(ctx, pk);
        return info.getNumber() + " " + info.getName();
    }
}

