/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.nbudget.BgElimException;
import com.kingdee.eas.ma.nbudget.BgElimStatusEnum;
import com.kingdee.eas.ma.nbudget.BgEliminationCollection;
import com.kingdee.eas.ma.nbudget.BgEliminationEntryCollection;
import com.kingdee.eas.ma.nbudget.BgEliminationEntryInfo;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgEliminationInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgEliminationControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgEliminationControllerBean
extends AbstractBgEliminationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgEliminationControllerBean");

    @Override
    protected boolean _antiAudit(Context ctx, List ids) throws BOSException, EASBizException {
        int i;
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int pos = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("update t_bg_bgelimination set fStatus = ?, fAuditDate = ?, FAuditorID = ? where FID in (");
        for (i = 1; i < ids.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(pos++, 1);
            pstmt.setDate(pos++, null);
            pstmt.setString(pos++, null);
            for (i = 0; i < ids.size(); ++i) {
                pstmt.setString(pos++, (String)ids.get(i));
            }
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _audit(Context ctx, List ids) throws BOSException, EASBizException {
        int i;
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Date date = new Date(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        int pos = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("update t_bg_bgelimination set fStatus = ?, fAuditDate = ?, FAuditorID = ? where FID in (");
        for (i = 1; i < ids.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(pos++, 2);
            pstmt.setDate(pos++, date);
            pstmt.setString(pos++, userId);
            for (i = 0; i < ids.size(); ++i) {
                pstmt.setString(pos++, (String)ids.get(i));
            }
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BgException(BgException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgEliminationInfo info = (BgEliminationInfo)model;
        if (info.getOrgUnit() != null) {
            BgCodeNumberNHelper.applyNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString());
        }
        if (info.get("status") == null) {
            info.setInt("status", 1);
        }
        String logName = info.getNumber();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgElimination_add");
        BgEliminationEntryCollection colls = info.getEntries();
        if (colls != null) {
            for (int index = 0; index < colls.size(); ++index) {
                BigDecimal big;
                BgEliminationEntryInfo entry = colls.get(index);
                if (entry.getCreditAmount() == null) {
                    big = new BigDecimal(0);
                    entry.setCreditAmount(big);
                }
                if (entry.getDebitAmount() != null) continue;
                big = new BigDecimal(0);
                entry.setDebitAmount(big);
            }
        }
        IObjectPK result = super._addnew(ctx, (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return result;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgEliminationInfo info = this.getBgEliminationInfo(ctx, pk);
        if (BgElimStatusEnum.Audited.equals((Object)info.getStatus())) {
            return;
        }
        String logName = info.getNumber();
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgElimination_remove");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        BgCodeNumberNHelper.recycleNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), info.getNumber());
        DbUtil.execute((Context)ctx, (String)"UPDATE T_BG_BGInnerFillDataEntry SET FEliminationId = '', FStatus = 2 WHERE FEliminationId = ? ", (Object[])new String[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)"UPDATE T_BG_BGInnerFillDiffData SET FEliminationId = '', FStatus = 2 WHERE FEliminationId = ? ", (Object[])new String[]{pk.toString()});
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int i;
        BgEliminationCollection col;
        BgEliminationInfo info = (BgEliminationInfo)model;
        String oql = "where orgUnit = '" + info.getOrgUnit().getId() + "' and number = '" + info.getNumber() + "'";
        if (info.getId() != null) {
            oql = oql + " and id <> '" + info.getId().toString() + "'";
        }
        if ((col = this.getBgEliminationCollection(ctx, oql)) != null && !col.isEmpty()) {
            throw new BgElimException(BgElimException.ELIMINATIONNUMBERDUPLICATED);
        }
        BgEliminationEntryCollection entryCol = info.getEntries();
        BgEliminationEntryInfo entryInfo = null;
        Map mapCombinNum = new HashMap();
        if (entryCol != null && !entryCol.isEmpty()) {
            for (i = 0; i < entryCol.size(); ++i) {
                mapCombinNum.put(entryCol.get(i).getBgItemNumber(), null);
            }
            mapCombinNum = BgEliminationHelper.dealWithBgItemCombin(ctx, mapCombinNum);
        }
        if (mapCombinNum != null && !mapCombinNum.isEmpty()) {
            for (i = 0; i < entryCol.size(); ++i) {
                entryInfo = entryCol.get(i);
                entryInfo.setBgItemId((String)mapCombinNum.get(entryInfo.getBgItemNumber()));
            }
        }
        this.checkLength((BgEliminationInfo)model);
        return super._save(ctx, model);
    }

    private void checkLength(BgEliminationInfo info) {
        if (info == null) {
            return;
        }
        String str = null;
        BgEliminationEntryCollection entryCol = info.getEntries();
        BgEliminationEntryInfo entryInfo = null;
        for (int i = 0; i < entryCol.size(); ++i) {
            entryInfo = entryCol.get(i);
            str = entryInfo.getSummary();
            if (StringUtils.isEmpty((String)str) || str.length() <= 80) continue;
            entryInfo.setSummary(str.substring(0, 79));
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgEliminationInfo bgEliminationInfo = (BgEliminationInfo)super._getValue(ctx, pk);
        return bgEliminationInfo.getNumber();
    }
}

