/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.bireport.util.BireportDBUtil;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.NumberExpandInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.nbudget.BgFormColumnAnalyseHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.BgSqlHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgFormColumnAnalyseFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgFormColumnAnalyseServerHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormColumnAnalyseFacadeControllerBean
extends AbstractBgFormColumnAnalyseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgFormColumnAnalyseFacadeControllerBean");
    protected static final String NEW_ANALYSIS_COL_KEY = "AnalysisColKey";
    public static final String ANALYSIS_FLAG = "ANALYSIS_FLAG";
    protected static final String ADD_ROW_FLAG = "add_row_flag";
    protected static final String COL_KEY = "bgCompareAndAnalysisColKey";
    protected static final String TITLE_FLAG = "TITLE_FLAG";
    protected static final BigDecimal ONE = new BigDecimal("1.00");
    protected static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String resourcePath = "com.kingdee.eas.ma.budget.BgFormAnalyseLableResource";

    @Override
    protected Map _initData(Context ctx, Map param) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo[] orgInfoAry = null;
        BgSchemeInfo bgSchemeInfo = null;
        String bgSchemeNum = null;
        String bgSchemeId = null;
        Map tableName = null;
        NewBgCompareAndAnalysisFilterParam filter1Params = (NewBgCompareAndAnalysisFilterParam)param.get("PARAM1");
        NewBgCompareAndAnalysisFilterParam filter2Params = (NewBgCompareAndAnalysisFilterParam)param.get("PARAM2");
        try {
            orgInfoAry = filter1Params.getCostCenterOrgUnitInfoAry();
            bgSchemeInfo = filter1Params.getBgSchemeInfo();
            bgSchemeNum = bgSchemeInfo.getNumber();
            bgSchemeId = bgSchemeInfo.getId().toString();
        }
        catch (Exception e) {
            logger.error((Object)(e.toString() + " \n org or scheme error"));
            return null;
        }
        HashMap<String, Object> orgNums = new HashMap<String, Object>();
        String[] orgs = new String[orgInfoAry.length];
        for (int q = 0; q < orgInfoAry.length; ++q) {
            if (orgInfoAry[q] == null) continue;
            orgs[q] = orgInfoAry[q].getId().toString();
            orgNums.put(orgInfoAry[q].getNumber(), null);
        }
        HashMap dataMap = new HashMap();
        this.addDataMap(dataMap, filter2Params);
        Book book = null;
        try {
            BgFormInfo formInfo = this.getBgFromInfo(ctx, filter1Params);
            book = formInfo.getBook();
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
        }
        catch (Exception e) {
            logger.error((Object)(e.toString() + " \n book error"));
            return null;
        }
        Map paramItemMap = this.getParamFromBook(ctx, book, orgNums, bgSchemeNum);
        tableName = this.buildTableAndData(ctx, orgs, bgSchemeId, paramItemMap, filter1Params, filter2Params, dataMap);
        HashMap dataParam = new HashMap();
        HashMap<String, Object> orgId = new HashMap<String, Object>();
        orgId.put(orgInfoAry[0].getId().toString(), null);
        dataParam.put(orgId, null);
        Map data = this._getOrgDataWithItem(ctx, dataParam, (String)tableName.get("FactName"));
        book = this.buildBook(ctx, book, data, filter1Params, filter2Params);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        byte[] bookByte = null;
        try {
            bookByte = IOHelper.packBook((Book)book);
        }
        catch (IOException e) {
            throw new BOSException(e.toString());
        }
        returnData.put("BOOK", bookByte);
        returnData.put("TABLENAME", tableName);
        return returnData;
    }

    private Book buildBook(Context ctx, Book book, Map dataMap, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params) throws EASBizException, BOSException {
        try {
            int sheetNum = book.getSheetCount();
            for (int i = 0; i < sheetNum; ++i) {
                Sheet sheet = book.getSheet(i);
                int addRowIndex = this.constructSheet(ctx, filter1Params, filter2Params.getAnalysisElement(), sheet);
                this.delBgItemWithAllAnalysisDataEqualZero(filter1Params.isDisplayZero(), sheet, addRowIndex, filter2Params);
                List<Integer> notAllowOperation = Arrays.asList(Integer.valueOf("65536"));
                BgNLockProtectHelper.setSheetLockedAndProtection(sheet, true, notAllowOperation);
            }
        }
        catch (Exception e) {
            logger.error((Object)(e.toString() + " \n end"));
            return null;
        }
        BgFormColumnAnalyseHelper.fillData(dataMap, book);
        return book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildTableAndData(Context ctx, String[] orgs, String bgSchemeId, Map paramItemMap, NewBgCompareAndAnalysisFilterParam params1, NewBgCompareAndAnalysisFilterParam params2, Map dataMap) {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        String tableName = null;
        String tmpTablePeriod = null;
        Object elementUnit = null;
        boolean isSinglePeriod = false;
        boolean isHadPeriod = false;
        if (params1.getBeginPeriod() != null) {
            isHadPeriod = true;
            if (params1.getBeginPeriod().getNumber().equals(params1.getEndPeriod().getNumber())) {
                isSinglePeriod = true;
            }
        }
        HashMap<String, String> perIdNum = new HashMap<String, String>();
        String[] periodNum = null;
        String[] periodIds = null;
        try {
            if (isHadPeriod && !isSinglePeriod) {
                BgPeriodCollection periodColl = BgFormColumnAnalyseServerHelper.getPeriodCol(ctx, params1.getBeginPeriod(), params1.getEndPeriod());
                periodNum = new String[periodColl.size()];
                periodIds = new String[periodColl.size()];
                for (int i = 0; i < periodColl.size(); ++i) {
                    periodNum[i] = periodColl.get(i).getNumber();
                    periodIds[i] = periodColl.get(i).getId().toString();
                    perIdNum.put(periodColl.get(i).getId().toString(), periodColl.get(i).getNumber());
                }
            } else if (isSinglePeriod) {
                periodNum = new String[1];
                periodIds = new String[1];
                periodNum[0] = params1.getBeginPeriod().getNumber();
                periodIds[0] = params1.getBeginPeriod().getId().toString();
                perIdNum.put(params1.getBeginPeriod().getId().toString(), params1.getBeginPeriod().getNumber());
            } else {
                Map periodNumM = (Map)paramItemMap.get("PERIOD");
                BgPeriodCollection periodColl = BgFormColumnAnalyseServerHelper.getPeriodCol(ctx, periodNumM);
                periodNum = new String[periodColl.size()];
                periodIds = new String[periodColl.size()];
                for (int i = 0; i < periodColl.size(); ++i) {
                    periodNum[i] = periodColl.get(i).getNumber();
                    periodIds[i] = periodColl.get(i).getId().toString();
                    perIdNum.put(periodColl.get(i).getId().toString(), periodColl.get(i).getNumber());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(e.toString() + " \n period error"));
            return null;
        }
        String factTable = "create table test (FdataId VarChar(44),FPeriodId VarChar(44), FPeriodNum NVarChar(255), FPeriodEndDate DateTime, FPeriodTYDate DateTime, FSchemeBeginDate DateTime, FOrgId VarChar(44), FOrgNum NVarChar(255),FSchemeId VarChar(44), FSchemeNum NVarChar(255),FItemId VarChar(44), FItemNum NVarChar(255),FElementId VarChar(44), FElementNum NVarChar(255),FCurrencyId VarChar(44), FCurrencyNum NVarChar(255)," + BgFormColumnAnalyseServerHelper.getFactData(dataMap) + " )";
        try {
            tableName = BgSqlHelper.addTable(ctx, factTable);
        }
        catch (Exception e) {
            logger.error((Object)(e.toString() + " \n creatTable error"));
            return null;
        }
        String[] bgSchemeIds = new String[orgs.length];
        HashMap<String, String> schemeWithOrg = new HashMap<String, String>();
        StringBuffer sqlSch = new StringBuffer();
        sqlSch.append("select fid, forgunitid from t_bg_bgscheme where forgunitid in ");
        sqlSch.append(BgHelper.tranArray2String((String[])orgs));
        sqlSch.append(" and frootid in (select frootid from t_bg_bgscheme where fid = '");
        sqlSch.append(bgSchemeId);
        sqlSch.append("')");
        IRowSet rss = null;
        try {
            rss = BireportDBUtil.executeQuery((String)sqlSch.toString(), null, (Context)ctx);
            int i = 0;
            while (rss.next()) {
                bgSchemeIds[i] = rss.getString("fid");
                ++i;
                schemeWithOrg.put(rss.getString("fOrgunitId"), rss.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)(e.toString() + " \n scheme"));
            Map map = null;
            return map;
        }
        finally {
            if (rss != null) {
                SQLUtils.cleanup((ResultSet)rss);
            }
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormColumnAnalyseServerHelper.insertElement(ctx, conn, periodIds, orgs, schemeWithOrg, dataMap, paramItemMap, perIdNum, tableName);
            HashMap<String, Object> dataIds = new HashMap<String, Object>();
            String selDataId = "Select fid from " + tableName;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selDataId);
            while (rs.next()) {
                dataIds.put(rs.getString("fid"), null);
            }
            try {
                if (dataMap.containsKey("FBalance") || dataMap.containsKey("FSumPastValue")) {
                    BgFormColumnAnalyseServerHelper.insertAdjust(ctx, dataMap.containsKey("FBalance"), tableName, dataIds);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                tmpTablePeriod = BgFormColumnAnalyseServerHelper.insertLYdata(ctx, dataMap.containsKey("FLYBgValue"), dataMap.containsKey("LYBgValueRate"), dataMap.containsKey("FLYActualValue"), dataMap.containsKey("LYBgValueRate"), dataMap.containsKey("LastActualVal"), perIdNum, periodIds, conn, tableName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                BgFormColumnAnalyseServerHelper.insertSumData(ctx, dataMap.containsKey("FBgValueSum"), dataMap.containsKey("BizActualSum"), params1.getEndPeriod(), tableName, params1.getBgSchemeInfo().getDateTo());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                BgFormColumnAnalyseServerHelper.insertThisYearData(ctx, dataMap.containsKey("FTYBgValue"), dataMap.containsKey("FTYActualValue"), params1.getEndPeriod(), tableName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                BgFormColumnAnalyseServerHelper.insertOperationData(ctx, dataMap.containsKey("OperationPlan"), dataMap.containsKey("OperationDifference"), dataMap.containsKey("OperationDifferRate"), tableName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        catch (Exception exception) {
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        tableMap.put("FactName", tableName);
        return tableMap;
    }

    private Map getParamFromBook(Context ctx, Book book, Map orgNums, String bgSchemeNum) {
        Sheet sheet = null;
        Cell cell = null;
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        HashMap<String, Object> elemMap = new HashMap<String, Object>();
        HashMap<String, Object> periodMap = new HashMap<String, Object>();
        HashMap<String, Object> currencyMap = new HashMap<String, Object>();
        int maxRowIndex = -1;
        int maxColIndex = -1;
        String formula = null;
        String[] formulaParam = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            maxRowIndex = sheet.getMaxRowIndex() + 1;
            for (int m = maxColIndex = sheet.getMaxColIndex() + 1; m >= 0; --m) {
                for (int j = maxRowIndex; j >= 0; --j) {
                    cell = sheet.getCell(j, m, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        formula = BgNFSHelper.getFormulaOfCell(cell);
                        formulaParam = BgNFSHelper.parseFormulaPara(formula);
                        itemMap.put(formulaParam[0], null);
                        elemMap.put(formulaParam[2], null);
                        periodMap.put(formulaParam[1], null);
                        currencyMap.put(formulaParam[3], null);
                        continue;
                    }
                    if (!BgNFSHelper.checkHasExpression(cell) || !BgFormulaHelper.isSingleBgFormula((String)(formula = BgNFSHelper.getExpression(cell)))) continue;
                    formulaParam = BgFillHelper.parseStrFormulaToArray((String)formula);
                    itemMap.put(formulaParam[0], null);
                    elemMap.put(formulaParam[2], null);
                    periodMap.put(formulaParam[1], null);
                    currencyMap.put(formulaParam[3], null);
                }
            }
        }
        HashMap<String, HashMap<String, Object>> returnMap = new HashMap<String, HashMap<String, Object>>();
        returnMap.put("ITEM", itemMap);
        returnMap.put("ELEMENT", elemMap);
        returnMap.put("PERIOD", periodMap);
        returnMap.put("CURRENCY", currencyMap);
        return returnMap;
    }

    private void addDataMap(Map dataMap, NewBgCompareAndAnalysisFilterParam filter2Params) {
        List list = filter2Params.getAnalysisElement();
        String name = null;
        String number = null;
        for (int i = 0; i < list.size(); ++i) {
            number = (String)list.get(i);
            if (number.equals("col5")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FBalance", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FBalance", name);
                continue;
            }
            if (number.equals("col6")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FSumPastValue", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FSumPastValue", name);
                continue;
            }
            if (number.equals("col4")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FBgValue", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FBgValue", name);
                continue;
            }
            if (number.equals("col0")) {
                name = ResourceBase.getString((String)resourcePath, (String)"BizActual", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("BizActual", name);
                continue;
            }
            if (number.equals("col7")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FLYBgValue", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FLYBgValue", name);
                continue;
            }
            if (number.equals("col8")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FLYActualValue", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FLYActualValue", name);
                continue;
            }
            if (number.equals("col9")) {
                name = ResourceBase.getString((String)resourcePath, (String)"LYBgValueRate", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("LYBgValueRate", name);
                continue;
            }
            if (number.equals("col10")) {
                name = ResourceBase.getString((String)resourcePath, (String)"LYActualValueRate", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("LYActualValueRate", name);
                continue;
            }
            if (number.equals("col11")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FBgValueSum", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FBgValueSum", name);
                continue;
            }
            if (number.equals("col12")) {
                name = ResourceBase.getString((String)resourcePath, (String)"BizActualSum", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("BizActualSum", name);
                continue;
            }
            if (number.equals("col1")) {
                name = ResourceBase.getString((String)resourcePath, (String)"OperationPlan", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("OperationPlan", name);
                continue;
            }
            if (number.equals("col2")) {
                name = ResourceBase.getString((String)resourcePath, (String)"OperationDifference", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("OperationDifference", name);
                continue;
            }
            if (number.equals("col3")) {
                name = ResourceBase.getString((String)resourcePath, (String)"OperationDifferRate", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("OperationDifferRate", name);
                continue;
            }
            if (number.equals("col13")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FTYBgValue", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FTYBgValue", name);
                continue;
            }
            if (number.equals("col14")) {
                name = ResourceBase.getString((String)resourcePath, (String)"FTYActualValue", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("FTYActualValue", name);
                continue;
            }
            if (number.equals("col15")) {
                name = ResourceBase.getString((String)resourcePath, (String)"Balance", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("Balance", name);
                continue;
            }
            if (number.equals("col16")) {
                name = ResourceBase.getString((String)resourcePath, (String)"LastActualVal", (Locale)ContextUtils.getLocaleFromEnv());
                dataMap.put("LastActualVal", name);
                continue;
            }
            if (!number.equals("col30")) continue;
            name = ResourceBase.getString((String)resourcePath, (String)"PeriodBalance", (Locale)ContextUtils.getLocaleFromEnv());
            dataMap.put("PeriodBalance", name);
        }
    }

    private Map getFormulaMap(Book book, Map analysisColsMap, BgPeriodInfo beginPeriod, BgPeriodInfo endPeriod, boolean isSinglePeriod, boolean isHadPeriod) {
        String sheetID = null;
        String sheetName = null;
        String key = null;
        Sheet sheet = null;
        Cell cell = null;
        String formula = null;
        String[] formulaParam = null;
        HashMap<String, Object> formulaMap = new HashMap<String, Object>();
        HashMap<String, Object> periodMap = new HashMap<String, Object>();
        int maxRowIndex = -1;
        int maxColIndex = -1;
        String period = null;
        if (isSinglePeriod) {
            period = beginPeriod.getNumber();
        }
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            sheetID = sheet.getID();
            sheetName = sheet.getSheetName();
            key = sheetID + "&" + sheetName;
            List analysisColsList = (List)analysisColsMap.get(key);
            if (analysisColsList == null || analysisColsList.isEmpty()) continue;
            maxRowIndex = sheet.getMaxRowIndex() + 1;
            for (int m = maxColIndex = sheet.getMaxColIndex() + 1; m >= 0; --m) {
                if (!analysisColsList.contains(new Integer(m))) continue;
                for (int j = maxRowIndex; j >= 0; --j) {
                    cell = sheet.getCell(j, m, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        formula = BgNFSHelper.getFormulaOfCell(cell);
                        formulaParam = BgNFSHelper.parseFormulaPara(formula);
                        if (isSinglePeriod) {
                            formula = new StringBuffer("=BgItem(\"" + formulaParam[0] + "\",\"" + period + "\",\"" + formulaParam[2] + "\",\"" + "BgData\",true,\"" + formulaParam[5] + "\")").toString();
                            formulaMap.put(formula, null);
                            BgNFSHelper.setFormulaOfCell(cell, formula);
                            continue;
                        }
                        if (isHadPeriod) {
                            formula = new StringBuffer("=BgItem(\"" + formulaParam[0] + "\",\"%\",\"" + formulaParam[2] + "\",\"" + "BgData\",true,\"" + formulaParam[5] + "\")").toString();
                            formulaMap.put(formula, null);
                            BgNFSHelper.setFormulaOfCell(cell, formula);
                            continue;
                        }
                        periodMap.put(formulaParam[1], null);
                        formulaMap.put(formula, null);
                        continue;
                    }
                    if (!BgNFSHelper.checkHasExpression(cell) || !BgFormulaHelper.isSingleBgFormula((String)(formula = BgNFSHelper.getExpression(cell)))) continue;
                    formulaParam = BgFillHelper.parseStrFormulaToArray((String)formula);
                    if (isSinglePeriod) {
                        formula = new StringBuffer("=BgItem(\"" + formulaParam[0] + "\",\"" + period + "\",\"" + formulaParam[2] + "\",\"" + "BgData\",true,\"" + formulaParam[3] + "\")").toString();
                        formulaMap.put(formula, null);
                        BgNFSHelper.setFormulaOfCell(cell, formula);
                        continue;
                    }
                    if (isHadPeriod) {
                        formula = new StringBuffer("=BgItem(\"" + formulaParam[0] + "\",\"%\",\"" + formulaParam[2] + "\",\"" + "BgData\",true,\"" + formulaParam[3] + "\")").toString();
                        formulaMap.put(formula, null);
                        BgNFSHelper.setFormulaOfCell(cell, formula);
                        continue;
                    }
                    periodMap.put(formulaParam[1], null);
                    formulaMap.put(formula, null);
                }
            }
        }
        HashMap<String, HashMap<String, Object>> returnMap = new HashMap<String, HashMap<String, Object>>();
        returnMap.put("formula", formulaMap);
        returnMap.put("period", periodMap);
        return returnMap;
    }

    protected int constructSheet(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Param, List analysisElementList, Sheet sheet) throws Exception {
        Map analysisColsMap = filter1Param.getAnalysisColsMap();
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String key = sheetID + "&" + sheetName;
        List analysisColsList = (List)analysisColsMap.get(key);
        if (analysisColsList == null) {
            return 0;
        }
        Map titleColsMap = filter1Param.getTitleColsMap();
        List titleColsList = null;
        if (titleColsMap != null) {
            titleColsList = (List)titleColsMap.get(key);
        }
        if (titleColsList != null && titleColsList.size() != 0) {
            this.removeUnRequiredCols(titleColsList, analysisColsList, sheet);
        } else {
            this.removeUnRequiredCols(analysisColsList, sheet);
        }
        int rowIndex = this.locateAddedNewRowIndex(sheet);
        Row addRow = BgNFSHelper.addRow(sheet, rowIndex);
        addRow.setUserObject(ADD_ROW_FLAG, (Object)"addRow");
        this.addAnalysisCols(analysisElementList, rowIndex, sheet);
        this.removeOldColumns(sheet);
        this.accessorizeNewTable(analysisElementList.size(), rowIndex, sheet);
        this.addOrgUnitByCol(ctx, filter1Param, rowIndex + 1, sheet);
        return rowIndex;
    }

    private void addOrgUnitByCol(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Param, int beginRow, Sheet sheet) {
        CostCenterOrgUnitInfo[] orgInfoAry = filter1Param.getCostCenterOrgUnitInfoAry();
        int num = orgInfoAry.length;
        String[] companyIds = new String[num];
        for (int i = 0; i < num; ++i) {
            companyIds[i] = orgInfoAry[i].getId().toString();
        }
        if (companyIds != null && companyIds.length != 0) {
            FullOrgUnitInfo baseOrgUnit = null;
            try {
                baseOrgUnit = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyIds[0])));
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            Column column = BgNFSHelper.addColumn(sheet, 0);
            int colIndex = column.getCol();
            sheet.getColRange(colIndex, colIndex).setColumnWidth(200);
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            MergeBlocks blocks = sheet.getMerger(false);
            CellBlock block = null;
            Cell firstCell = null;
            for (int rowIndex = beginRow; rowIndex < rowCount; ++rowIndex) {
                if (!this.checkHasBgItem(sheet, rowIndex)) continue;
                if (blocks != null && !blocks.isEmpty()) {
                    for (int i = 0; i < colCount; ++i) {
                        if (sheet.getCell(rowIndex, i, false) == null || (block = sheet.getCell(rowIndex, i, false).getMerge(false)) == null || (firstCell = sheet.getCell(block.getRow(), block.getCol(), false)) == null) continue;
                        sheet.getMerger(false).remove(sheet.getCell(rowIndex, i, false).getMerge(false));
                        int n = block.getRow2();
                        for (int ii = block.getRow(); ii <= n; ++ii) {
                            BgNFSHelper.setValue(sheet.getCell(ii, block.getCol(), true), BgNFSHelper.getValue(firstCell));
                        }
                    }
                }
                this.addExpandInfo(sheet.getCell(rowIndex, column.getCol(), true), baseOrgUnit, companyIds.length);
            }
        }
    }

    protected void addExpandInfo(Cell cell, FullOrgUnitInfo orgUnitInfo, int orgNum) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        expandInfo.setLeaf(false);
        if (orgNum == 1) {
            BgNFSHelper.setValue(cell, orgUnitInfo.getName());
            cell.setUserObject("orgUnitId", (Object)expandInfo.getId());
            cell.setUserObject("orgUnitName", (Object)expandInfo.getName());
        } else {
            BgNFSHelper.setNumberExpandInfo(cell, expandInfo);
        }
    }

    private boolean checkHasBgItem(Sheet sheet, int rowIndex) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int colIndex = colNum - 1; colIndex >= 0; --colIndex) {
            Column col = sheet.getColumn(colIndex, false);
            Object colKey = BgNFSHelper.getColObject(col, NEW_ANALYSIS_COL_KEY);
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell(cell);
            String bgFormula = BgNFSHelper.getExpression(cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula((String)bgFormula)) continue;
            return true;
        }
        return false;
    }

    private void accessorizeNewTable(int mergeColNum, int rowIndex, Sheet sheet) {
        int num = sheet.getMaxColIndex();
        for (int i = num - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject(col, NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            for (int j = rowIndex - 1; j >= 0; --j) {
                Cell cell = sheet.getCell(j, i, false);
                if (cell == null || !BgNFSHelper.checkHasCurrencyInfo(cell) && !BgNFSHelper.checkHasBgElementInfo(cell) && !BgNFSHelper.checkHasBgItemInfo(cell) && !BgNFSHelper.checkHasBgPeriodInfo(cell)) continue;
                sheet.getRange(j, i, j, mergeColNum + i - 1).merge();
            }
        }
    }

    private void addAnalysisCols(List analysisElementList, int rowIndex, Sheet sheet) throws Exception {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject(col, COL_KEY);
            if (!ANALYSIS_FLAG.equals(colKey)) continue;
            if (!this.isRealAnalysisCol(col, sheet)) {
                BgNFSHelper.setColObject(col, COL_KEY, null);
                continue;
            }
            int num = analysisElementList.size();
            for (int j = 0; j < num; ++j) {
                int colIndex = i + j + 1;
                Column column = BgNFSHelper.addColumn(sheet, colIndex);
                String proName = analysisElementList.get(j).toString();
                BgNFSHelper.setColObject(column, COL_KEY, proName);
            }
        }
    }

    private boolean isRealAnalysisCol(Column column, Sheet sheet) {
        int colIndex = column.getCol();
        int num = sheet.getMaxColIndex() + 11;
        for (int i = 0; i < num; ++i) {
            String tempBgItem;
            Cell cell = sheet.getCell(i, colIndex, false);
            if (cell == null) continue;
            String bgItem = BgNFSHelper.getFormulaOfCell(cell);
            String bgFormula = BgNFSHelper.getExpression(cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula((String)bgFormula) || "".equals(tempBgItem = AnalysisColumnTool.changeBgFormulaToBgItem((String)bgFormula))) continue;
            return true;
        }
        return false;
    }

    private void removeOldColumns(Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column oldCol = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject(oldCol, COL_KEY);
            Row row = null;
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            int newAnalysisColIndex = i + 1;
            Column newAnalysisCol = sheet.getColumn(newAnalysisColIndex, false);
            BgNFSHelper.setColObject(newAnalysisCol, NEW_ANALYSIS_COL_KEY, ANALYSIS_FLAG);
            int num = sheet.getMaxRowIndex() + 1;
            for (int j = 0; j < num; ++j) {
                Cell newCell;
                Cell cell;
                row = sheet.getRow(j, false);
                if (row != null && row.getUserObjectValue(ADD_ROW_FLAG) != null && row.getUserObjectValue(ADD_ROW_FLAG).toString().equals("addRow") || (cell = sheet.getCell(j, i, false)) == null) continue;
                String bgItem = BgNFSHelper.getFormulaOfCell(cell);
                String bgFormula = BgNFSHelper.getExpression(cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setFormulaOfCell(newCell, bgItem, true);
                } else if (BgNFSHelper.checkHasExpression(cell)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setExpression(newCell, bgFormula);
                }
                Object txtCellObj = BgNFSHelper.getValue(cell);
                if (txtCellObj == null) continue;
                Cell newCell2 = sheet.getCell(j, newAnalysisColIndex, true);
                BgNFSHelper.setValue(newCell2, txtCellObj);
            }
            boolean isDelete = BgNFSHelper.removeColumn(sheet, i);
            if (isDelete) continue;
            BgNFSHelper.setSheetProtection(sheet, false);
            BgNFSHelper.removeColumn(sheet, i);
        }
    }

    private int locateAddedNewRowIndex(Sheet sheet) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        boolean continueFlag = true;
        int rowIndex = 0;
        block0: for (int i = 0; i < rowCount && continueFlag; ++i) {
            for (int j = 0; j < colCount && continueFlag; ++j) {
                Cell cell = sheet.getCell(i, j, false);
                String bgItem = BgNFSHelper.getFormulaOfCell(cell);
                String bgFormula = BgNFSHelper.getExpression(cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    rowIndex = cell.getRow();
                    continueFlag = false;
                    continue block0;
                }
                if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula((String)bgFormula)) continue;
                rowIndex = cell.getRow();
                continueFlag = false;
                continue block0;
            }
        }
        return rowIndex;
    }

    private void removeUnRequiredCols(List titleList, List analysisList, Sheet sheet) throws Exception {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (titleList.contains(new Integer(i))) {
                BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, TITLE_FLAG);
                continue;
            }
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, ANALYSIS_FLAG);
                continue;
            }
            BgNFSHelper.removeColumn(sheet, i);
            continue;
        }
    }

    private void removeUnRequiredCols(List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, ANALYSIS_FLAG);
                continue;
            }
            BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, TITLE_FLAG);
        }
    }

    protected void delBgItemWithAllAnalysisDataEqualZero(boolean isDelete, Sheet sheet, int addRowIndex, NewBgCompareAndAnalysisFilterParam filter2Params) {
        if (isDelete) {
            this.delRow(sheet, addRowIndex, filter2Params);
        }
    }

    private void delRow(Sheet sheet, int addRowIndex, NewBgCompareAndAnalysisFilterParam filter2Params) {
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        List analysisElementList = filter2Params.getAnalysisElement();
        for (int rowIndex = sheet.getMaxRowIndex() + 1; rowIndex > addRowIndex; --rowIndex) {
            if (!this.isDeleteRow(sheet, rowIndex, analysisColIndexList, analysisElementList)) continue;
            BgNFSHelper.removeRow(sheet, rowIndex);
        }
    }

    protected final List getAnalysisColIndexList(Sheet sheet) {
        ArrayList<Integer> analysisColIndexList = new ArrayList<Integer>();
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject(col, NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            analysisColIndexList.add(new Integer(i));
        }
        return analysisColIndexList;
    }

    private boolean isDeleteRow(Sheet sheet, int rowIndex, List analysisColIndexList, List analysisElementList) {
        int colNum = analysisColIndexList.size();
        for (int k = 0; k < colNum; ++k) {
            int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
            int num = analysisElementList.size();
            for (int i = 0; i < num; ++i) {
                String variantStr;
                Variant variant;
                Cell cell = sheet.getCell(rowIndex, analysisColIndex + i, false);
                if (cell == null || (variant = cell.getValue()) == null || DataDealCenter.ZIROSTR_LIST.contains(variantStr = variant.toString().trim())) continue;
                return false;
            }
        }
        return true;
    }

    protected BgFormInfo getBgFromInfo(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params) throws Exception {
        String bgFormID = filter1Params.getBgFormID();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgFormID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("data"));
        selector.add(new SelectorItemInfo("orgUnit.*"));
        selector.add(new SelectorItemInfo("bgScheme.*"));
        selector.add(new SelectorItemInfo("bgTemplate.*"));
        selector.add(new SelectorItemInfo("currency.*"));
        selector.add(new SelectorItemInfo("currency.precision"));
        selector.add(new SelectorItemInfo("sheetParam.*"));
        selector.add(new SelectorItemInfo("bgPeriod.*"));
        selector.add(new SelectorItemInfo("state"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        BgFormInfo formInfo = null;
        formInfo = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(viewInfo).get(0);
        if (formInfo == null) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"5_BgFormColumnAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return formInfo;
    }

    @Override
    protected Map _getOrgDataWithItem(Context ctx, Map param, String tableName) throws BOSException, EASBizException {
        String orgKey2 = null;
        HashMap dataMap = new HashMap();
        Map entryMap = new HashMap();
        Object itemMap = null;
        for (String orgKey2 : param.keySet()) {
            entryMap = BgFormColumnAnalyseServerHelper.getData(ctx, orgKey2, tableName);
            dataMap.put(orgKey2, entryMap);
        }
        return dataMap;
    }
}

