/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgSqlHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BgFormColumnAnalyseServerHelper {
    public static void insertElement(Context ctx, Connection conn, String[] periodIds, String[] orgs, Map schemeWithOrg, Map dataMap, Map paramItemMap, Map perIdNum, String factTableName) throws Exception {
        String MaxStr = BgFormColumnAnalyseServerHelper.getMaxString();
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into " + factTableName + " ( FdataId ,FPeriodId, FOrgId, FSchemeId, FItemId, FElementId, FCurrencyId " + BgFormColumnAnalyseServerHelper.isHadValue(dataMap) + ")  select a.fid, a.fbgperiodid, a.forgunitid, a.fbgschemeId , a.FBgItemCombinId , a.fbgelementId, a.FcurrencyID  " + BgFormColumnAnalyseServerHelper.isHadValueForData(dataMap) + " from t_bg_bgdata a where  a.forgunitid = ? and  a.fbgschemeid = ? and  a.FCurrencyId in (select fid from T_BG_BgItemCombination where fkey in (" + MaxStr + ")) and  a.FElementId in (select fid from t_bg_bgelement where fnumber in (" + MaxStr + ")) and  a.FPeriodId in (" + MaxStr + ") and  a.FItemId in (select fid from T_BD_Currency where fnumber in (" + MaxStr + "));  ");
        PreparedStatement pstmt = null;
        Map currencyMap = (Map)paramItemMap.get("CURRENCY");
        Map elementMap = (Map)paramItemMap.get("ELEMENT");
        Map itemMap = (Map)paramItemMap.get("ITEM");
        HashMap hadCurrency = new HashMap();
        HashMap hadElement = new HashMap();
        HashMap hadItem = new HashMap();
        HashMap hadPeriod = new HashMap();
        String currencyStr = null;
        String elementStr = null;
        String itemStr = null;
        String periodStr = null;
        String orgStr = null;
        String schemeStr = null;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int ab = 0;
        int bb = 0;
        int cb = 0;
        int db = 0;
        try {
            pstmt = conn.prepareStatement(insertSql.toString());
            for (int i = 0; i < orgs.length; ++i) {
                orgStr = orgs[i];
                pstmt.setString(1, orgStr);
                schemeStr = (String)schemeWithOrg.get(orgStr);
                pstmt.setString(2, schemeStr);
                for (a = 0; a < currencyMap.size() / 50 + 1; ++a) {
                    Iterator iteCurr = currencyMap.keySet().iterator();
                    for (ab = 0; ab < 50; ++ab) {
                        if (iteCurr.hasNext()) {
                            currencyStr = (String)iteCurr.next();
                            if (hadCurrency.containsKey(currencyStr)) continue;
                            pstmt.setString(3 + a, currencyStr);
                            hadCurrency.put(currencyStr, null);
                            continue;
                        }
                        pstmt.setString(3 + ab, "#");
                    }
                    for (b = 0; b < elementMap.size() / 50 + 1; ++b) {
                        Iterator iteElem = elementMap.keySet().iterator();
                        for (bb = 0; bb < 50; ++bb) {
                            if (iteElem.hasNext()) {
                                elementStr = (String)iteElem.next();
                                if (hadElement.containsKey(elementStr)) continue;
                                pstmt.setString(53 + b, elementStr);
                                hadElement.put(elementStr, null);
                                continue;
                            }
                            pstmt.setString(53 + b, "#");
                        }
                        for (c = 0; c < perIdNum.size() / 50 + 1; ++c) {
                            Iterator itePeri = perIdNum.keySet().iterator();
                            for (cb = 0; cb < 50; ++cb) {
                                if (itePeri.hasNext()) {
                                    periodStr = (String)itePeri.next();
                                    if (hadPeriod.containsKey(periodStr)) continue;
                                    pstmt.setString(103 + c, periodStr);
                                    hadPeriod.put(periodStr, null);
                                    continue;
                                }
                                pstmt.setString(103 + c, "#");
                            }
                            for (d = 0; d < itemMap.size() / 50 + 1; ++d) {
                                Iterator iteItem = itemMap.keySet().iterator();
                                for (db = 0; db < 50; ++db) {
                                    if (iteItem.hasNext()) {
                                        itemStr = (String)iteItem.next();
                                        if (hadItem.containsKey(itemStr)) continue;
                                        pstmt.setString(153 + d, itemStr);
                                        hadItem.put(itemStr, null);
                                        continue;
                                    }
                                    pstmt.setString(153 + d, "#");
                                }
                                pstmt.addBatch();
                            }
                            hadItem = new HashMap();
                        }
                        hadPeriod = new HashMap();
                    }
                    hadElement = new HashMap();
                }
                hadCurrency = new HashMap();
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static String isHadValue(Map dataMap) {
        String addSql = "";
        if (dataMap.containsKey("FBgValue")) {
            addSql = addSql + " , " + "FBgValue";
        }
        if (dataMap.containsKey("BizActual")) {
            addSql = addSql + " , " + "BizActual";
        }
        if (dataMap.containsKey("FSumPastValue")) {
            addSql = addSql + " , " + "FSumPastValue";
        }
        return addSql;
    }

    public static String isHadValueForData(Map dataMap) {
        String addSql = "";
        if (dataMap.containsKey("FBgValue")) {
            addSql = addSql + " , a.FBgValue";
        }
        if (dataMap.containsKey("BizActual")) {
            addSql = addSql + " , a.BizActual";
        }
        if (dataMap.containsKey("FSumPastValue")) {
            addSql = addSql + " , 0 ";
        }
        return addSql;
    }

    public static String getMaxString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < 50; ++i) {
            if (i == 0) {
                str.append("?");
                continue;
            }
            str.append(",?");
        }
        return str.toString();
    }

    public static void insertAdjust(Context ctx, boolean isBeforeAdjust, String factTableName, Map dataIds) throws Exception {
        String selSql = "select U.Fid FBgDataID, L.FSumPastValue FSumPastValue from t_bg_bgdata U LEFT JOIN (select EE.FBgDataID fid, sum(EE.Fpastvalue) FSumPastValue  from  t_bg_bgpastrecord DD, t_bg_bgpastdata EE  where DD.fid = EE.fpastrecordid and EE.fpastrecordid in (select fid from t_bg_bgpastrecord where fpastSource <> " + BgPastSourceEnum.DECOMPOSER.getValue() + ")group by FBgDataID) L ON U.Fid = L.fid where U.fid in " + BgHelper.tranMap2String((Map)dataIds);
        String upSql = "update " + factTableName + "  set " + "FSumPastValue" + " = (select A.fSumPastValue from (" + selSql + ") A where A.fbgdataId = fdataId)";
        DbUtil.execute((Context)ctx, (String)upSql);
        upSql = "update " + factTableName + "  set " + "FSumPastValue" + " = 0 where " + "FSumPastValue" + " is Null";
        DbUtil.execute((Context)ctx, (String)upSql);
        if (isBeforeAdjust) {
            String upBef = "update " + factTableName + " set " + "BizActual" + " = " + "FBgValue" + " - " + "FSumPastValue";
            DbUtil.execute((Context)ctx, (String)upBef);
        }
    }

    public static String insertLYdata(Context ctx, boolean isLYB, boolean isLYBR, boolean isLYA, boolean isLYAR, boolean isBA, Map perIdNum, String[] periodIds, Connection conn, String factTableName) throws Exception {
        String tmpTablePeriod = null;
        if (isLYB || isLYBR || isLYA || isLYAR || isBA) {
            tmpTablePeriod = BgFormColumnAnalyseServerHelper.createTemPeriodTable(ctx, conn, factTableName, periodIds, perIdNum);
            String upSql = "";
            if (isLYB) {
                upSql = "update " + factTableName + "  set " + "FLYBgValue" + " = (select B.fbgvalue  from (select X.FBgValue fbgvalue, X.FBgItemCombinId, X.forgunitid, X.Fbgschemeid,   X.fbgelementid, X.fcurrencyId, X.Fbgperiodid from t_bg_bgdata X where X.fbgperiodid in (select flastyearid from  " + tmpTablePeriod + " ))B  where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId and FPeriodId = (select top 1 fid from  " + tmpTablePeriod + " where flastyearid = B.Fbgperiodid))";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isLYA) {
                upSql = "update " + factTableName + " set " + "FLYActualValue" + " = (select B.fActual  from (select X.FBizActual fActual, X.FBgItemCombinId, X.forgunitid, X.Fbgschemeid,   X.fbgelementid, X.fcurrencyId, X.Fbgperiodid  from t_bg_bgdata X where  X.fbgperiodid in (select flastyearid from " + tmpTablePeriod + " ) )B  where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid =  fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId and FPeriodId = (select top 1 fid from  " + tmpTablePeriod + " where flastyearid = B.Fbgperiodid))";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isLYBR) {
                upSql = "update " + factTableName + " set " + "LYBgValueRate" + " = (" + "FBgValue" + " - " + "FLYBgValue" + ") /" + "FLYBgValue" + " where " + "FLYBgValue" + " is not null and " + "FLYBgValue" + " <> 0";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isLYAR) {
                upSql = "update " + factTableName + " set " + "LYActualValueRate" + " = (" + "BizActual" + " - " + "FLYActualValue" + ") /" + "FLYActualValue" + " where " + "FLYActualValue" + " is not null and " + "FLYActualValue" + " <> 0";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isBA) {
                upSql = "update " + factTableName + " set " + "LastActualVal" + " = (select B.fActual  from (select X.FBizActual fActual , X.FBgItemCombinId, X.forgunitid, X.Fbgschemeid,   X.fbgelementid, X.fcurrencyId  from t_bg_bgdata X where  X.fbgperiodid in (select fbefid from " + tmpTablePeriod + " ))B  where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId)";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
        }
        return tmpTablePeriod;
    }

    public static String createTemPeriodTable(Context ctx, Connection conn, String factTableName, String[] periodIds, Map perIdNum) throws Exception {
        PreparedStatement pstmtSel = null;
        PreparedStatement pstmtUpdate = null;
        Statement pstmt = null;
        ResultSet rst = null;
        HashMap<String, String> periodLYNum = new HashMap<String, String>();
        HashMap<String, String> periodBNum = new HashMap<String, String>();
        HashMap<String, String> nums = new HashMap<String, String>();
        String num = null;
        String id2 = null;
        String tmpTablePeriod = null;
        try {
            String[] create = new String[]{BgFormColumnAnalyseServerHelper.createPeriodLastIdTable()};
            tmpTablePeriod = BgSqlHelper.addTable(ctx, create);
            if (tmpTablePeriod != null) {
                pstmt = conn.createStatement();
                String insertSql = "insert into " + tmpTablePeriod + " (Fid) select fperiodId from " + factTableName;
                pstmt.execute(insertSql);
                for (String id2 : perIdNum.keySet()) {
                    num = (String)perIdNum.get(id2);
                    num = BgNPeriodHelper.getOffsetBgPeriodNumberForYear(num, -1);
                    nums.put(num, null);
                    periodLYNum.put(id2, num);
                    num = (String)perIdNum.get(id2);
                    num = BgNPeriodHelper.getOffsetBgPeriodNumber(num, -1);
                    periodBNum.put(id2, num);
                    nums.put(num, null);
                }
                String selSql = "select fid, fnumber from t_bg_bgperiod where fnumber in " + BgHelper.tranMap2String(nums) + " order by fnumber;";
                pstmtSel = conn.prepareStatement(selSql);
                rst = pstmtSel.executeQuery();
                while (rst.next()) {
                    nums.put(rst.getString("fnumber"), rst.getString("fid"));
                }
                String lyNum = null;
                String lyId2 = null;
                String upLyId = "update " + tmpTablePeriod + " set FLastYearID = ? where fid = ?";
                pstmtUpdate = conn.prepareStatement(upLyId);
                for (String lyId2 : periodLYNum.keySet()) {
                    lyNum = (String)periodLYNum.get(lyId2);
                    if (!nums.containsKey(lyNum) || nums.get(lyNum) == null) continue;
                    pstmtUpdate.setString(1, (String)nums.get(lyNum));
                    pstmtUpdate.setString(2, lyId2);
                    pstmtUpdate.addBatch();
                }
                pstmtUpdate.executeBatch();
                SQLUtils.cleanup((Statement)pstmtUpdate);
                String beNum = null;
                String beId2 = null;
                String upBeId = "update " + tmpTablePeriod + " set FBefID = ? where fid = ?";
                pstmtUpdate = conn.prepareStatement(upBeId);
                for (String beId2 : periodBNum.keySet()) {
                    beNum = (String)periodBNum.get(lyId2);
                    if (!nums.containsKey(beNum) || nums.get(beNum) == null) continue;
                    pstmtUpdate.setString(1, (String)nums.get(beNum));
                    pstmtUpdate.setString(2, beId2);
                    pstmtUpdate.addBatch();
                }
            } else {
                throw new BgException(BgException.ERROROFCREATETABLE);
            }
            pstmtUpdate.executeBatch();
            SQLUtils.cleanup((Statement)pstmtUpdate);
        }
        catch (SQLException exx) {
            try {
                throw new SQLException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(rst, pstmtUpdate);
                SQLUtils.cleanup(pstmtSel);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtUpdate);
        SQLUtils.cleanup((Statement)pstmtSel);
        return tmpTablePeriod;
    }

    public static String createPeriodLastIdTable() {
        return "Create Table text ( FID VARCHAR(44) NOT NULL ,FLastYearID VARCHAR(44),FBefID VARCHAR(44));";
    }

    public static void insertSumData(Context ctx, boolean isSumBgValue, boolean isSumActral, BgPeriodInfo endPeriodInfo, String factTableName, Date schemeDateTo) throws Exception {
        if (endPeriodInfo != null) {
            String upSql;
            if (isSumBgValue) {
                upSql = "update " + factTableName + " set " + "FBgValueSum" + " = (select B.fbgvalue from (select sum(X.FBgValue) fbgvalue , X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid  from t_bg_bgdata X where X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgFormColumnAnalyseServerHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + " )group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId  and B.fbgperiod)";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
            if (isSumActral) {
                upSql = "update " + factTableName + " set " + "BizActualSum" + " = (select B.factual from (select sum(X.FBizActual) factual , X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid  from t_bg_bgdata X where  X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgFormColumnAnalyseServerHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + " )group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId )";
                DbUtil.execute((Context)ctx, (String)upSql);
            }
        } else if (isSumBgValue || isSumActral) {
            String upSql = "update " + factTableName + " set FSchemeBeginDate = to_date('" + BgFormColumnAnalyseServerHelper.dateToStr(schemeDateTo) + "')";
            DbUtil.execute((Context)ctx, (String)upSql);
            if (isSumBgValue) {
                // empty if block
            }
            if (isSumActral) {
                // empty if block
            }
        }
    }

    public static String dateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd H:mm:ss.mmm");
        return sdf.format(date);
    }

    public static void insertThisYearData(Context ctx, boolean isTYBgValue, boolean isTYActral, BgPeriodInfo endPeriodInfo, String factTableName) throws Exception {
        String upSql;
        if (isTYBgValue) {
            upSql = "update " + factTableName + " set " + "FTYBgValue" + " = (select B.fbgvalue from (select sum(X.FBgValue) fbgvalue, X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid from t_bg_bgdata X  where   X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgFormColumnAnalyseServerHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fbegindate>= to_date('" + BgFormColumnAnalyseServerHelper.dateToStrForYear(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + ") group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId )";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
        if (isTYActral) {
            upSql = "update " + factTableName + " set " + "FTYActualValue" + " = (select B.factual from (select sum(X.FBizActual) factual , X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid  from t_bg_bgdata X where  X.FbgPeriodId in (Select fid from t_bg_bgPeriod where  fenddate<= to_date('" + BgFormColumnAnalyseServerHelper.dateToStr(endPeriodInfo.getEndDate()) + "') and fbegindate>= to_date('" + BgFormColumnAnalyseServerHelper.dateToStrForYear(endPeriodInfo.getEndDate()) + "') and fperiodtype= " + endPeriodInfo.getPeriodType().getValue() + " ) group by X.fbgitemcombinid, X.forgUnitId, X.fbgschemeid, X.fBgElementid, X.fcurrencyid )B where B.FBgItemCombinId = FItemCombinId and B.forgunitid = fcompanyid  and B.Fbgschemeid = fSchemeid and B.fbgelementid = felementId and B.fcurrencyId = fcurrencyId )";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
    }

    public static String dateToStrForYear(Date date) {
        CalendarHelper cal = new CalendarHelper();
        date = cal.getLastDayOfYear(cal.getCurrentlyYear(date) - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd H:mm:ss.mmm");
        return sdf.format(date);
    }

    public static void insertOperationData(Context ctx, boolean isOperPlan, boolean isOperDiff, boolean isOperRate, String factTableName) throws Exception {
        String upSql;
        if (isOperPlan) {
            upSql = "update " + factTableName + " set " + "OperationPlan" + " = " + "BizActual" + " / " + "FBgValue" + " where FbgValue is not null and fbgvalue <> 0";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
        if (isOperDiff) {
            upSql = "update " + factTableName + " set " + "OperationDifference" + " = " + "FBgValue" + " - " + "BizActual";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
        if (isOperRate) {
            upSql = "update " + factTableName + " set " + "OperationDifferRate" + " = " + "OperationDifference" + " / " + "FBgValue" + " where FbgValue is not null and fbgvalue <> 0";
            DbUtil.execute((Context)ctx, (String)upSql);
        }
    }

    public static String getFactData(Map dataMap) {
        String sql = "";
        Iterator ite = dataMap.keySet().iterator();
        while (ite.hasNext()) {
            sql = sql + " , " + ite.next().toString() + " decimal(21,6) ";
        }
        return sql;
    }

    public static BgPeriodCollection getPeriodCol(Context ctx, BgPeriodInfo[] bgPeriodsN, BgPeriodInfo endPeriodInfo) throws Exception {
        BgPeriodCollection period = new BgPeriodCollection();
        if (bgPeriodsN.length > 1) {
            for (int i = 0; i < bgPeriodsN.length; ++i) {
                period.add(bgPeriodsN[i]);
            }
        } else if (bgPeriodsN[0].getId().equals((Object)endPeriodInfo.getId())) {
            period.add(bgPeriodsN[0]);
        } else {
            period = BgPeriodHelper.getPeriodColInfo((int)endPeriodInfo.getPeriodType().getValue(), (Date)bgPeriodsN[0].getBeginDate(), (Date)endPeriodInfo.getEndDate(), (Context)ctx);
        }
        return period;
    }

    public static BgPeriodCollection getPeriodCol(Context ctx, Map periodNum) throws Exception {
        BgPeriodCollection period = new BgPeriodCollection();
        period = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection("select id,name,number where number in " + BgHelper.tranMap2String((Map)periodNum));
        return period;
    }

    public static BgPeriodCollection getPeriodCol(Context ctx, BgPeriodInfo bgPeriodsN, BgPeriodInfo endPeriodInfo) throws Exception {
        BgPeriodCollection period = new BgPeriodCollection();
        if (bgPeriodsN.getId().equals((Object)endPeriodInfo.getId())) {
            period.add(bgPeriodsN);
        } else {
            period = BgPeriodHelper.getPeriodColInfo((int)endPeriodInfo.getPeriodType().getValue(), (Date)bgPeriodsN.getBeginDate(), (Date)endPeriodInfo.getEndDate(), (Context)ctx);
        }
        return period;
    }

    public static Map getData(Context ctx, String orgKey, String tableName) {
        return null;
    }
}

