/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.nbudget.AbstractBgInnerFillDataInfo;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataEntryCollection;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataEntryInfo;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgInnerFillDataControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgInnerFillDataControllerBean
extends AbstractBgInnerFillDataControllerBean {
    private static final long serialVersionUID = 9216100250878142081L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgInnerFillDataControllerBean");

    @Override
    protected boolean _existScheme(Context ctx, String rootId, String orgUnitId) throws BOSException {
        boolean rst = false;
        String sql = "select fid from t_bg_bgScheme where frootId = ? and forgUnitId= ? ";
        ArrayList<String> param = new ArrayList<String>();
        param.add(rootId);
        param.add(orgUnitId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param.toArray());
        if (null != rs) {
            try {
                if (rs.next()) {
                    rst = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rst;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgInnerFillDataInfo info = (BgInnerFillDataInfo)model;
        if (info.getOrgUnit() != null) {
            BgCodeNumberNHelper.applyNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString());
        }
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgInnerFillData_add");
        BgInnerFillDataEntryCollection colls = info.getEntries();
        BgInnerFillDataEntryInfo temp = null;
        for (int index = 0; index < colls.size(); ++index) {
            temp = colls.get(index);
            if (temp.getAmount() != null) continue;
            temp.setAmount(BgConstants.BIGZERO);
        }
        IObjectPK result = super._addnew(ctx, (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return result;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgInnerFillDataInfo info = (BgInnerFillDataInfo)model;
        String bgSchemeId = info.getBgScheme().getId().toString();
        String bgPeriodId = info.getBgPeriod().getId().toString();
        String bgElementId = info.getBgElement().getId().toString();
        String currencyId = info.getCurrency().getId().toString();
        BgDataTypeEnum bgDataTypeEnum = info.getDataType();
        BgElimTypeEnum bgElimTypeEnum = info.getElimType();
        Connection conn = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            BgInnerFillDataEntryCollection entryCol = info.getEntries();
            Map itemMap = new HashMap<String, Object>();
            if (entryCol != null && !entryCol.isEmpty()) {
                for (i = 0; i < entryCol.size(); ++i) {
                    itemMap.put(entryCol.get(i).getBgItemNumber(), null);
                }
                itemMap = BgEliminationHelper.dealWithBgItemCombin(ctx, itemMap);
            }
            for (i = 0; i < entryCol.size(); ++i) {
                BgInnerFillDataEntryInfo entryInfo = null;
                entryInfo = entryCol.get(i);
                if (itemMap != null && !itemMap.isEmpty()) {
                    entryInfo.setBgItemId((String)itemMap.get(entryInfo.getBgItemNumber()));
                }
                entryInfo.setBgSchemeID(bgSchemeId);
                entryInfo.setBgElementID(bgElementId);
                entryInfo.setCurrencyID(currencyId);
                entryInfo.setBgPeriodID(bgPeriodId);
                entryInfo.setDataType(bgDataTypeEnum);
                entryInfo.setElimType(bgElimTypeEnum);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.checkLength(info);
        return super._save(ctx, model);
    }

    private void checkLength(BgInnerFillDataInfo info) {
        String str = null;
        str = info.getNumber();
        if (!StringUtils.isEmpty((String)str) && str.length() > 80) {
            info.setNumber(str.substring(0, 79));
        }
        if (!StringUtils.isEmpty((String)(str = info.getName())) && str.length() > 80) {
            info.setName(str.substring(0, 79));
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        BgInnerFillDataInfo info = this.getBgInnerFillDataInfo(ctx, pk);
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgInnerFillData_remove");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        BgCodeNumberNHelper.recycleNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), info.getNumber());
    }

    @Override
    protected boolean _checkCanDele(Context ctx, String id) throws BOSException {
        boolean rst = true;
        String sql = "select fid from t_bg_bginnerfilldataentry where fstatus <> 1 and fbginnerfilldataid = ? ";
        ArrayList<String> param = new ArrayList<String>();
        param.add(id);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param.toArray());
        if (null != rs) {
            try {
                if (rs.next()) {
                    rst = false;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rst;
    }

    @Override
    protected boolean _existNum(Context ctx, String num, String orgUnitId, String id) throws BOSException {
        boolean rst = false;
        IRowSet rs = null;
        String sql_edit = "select fid from t_bg_bginnerfilldata where fnumber = ? and forgunitid= ? and fid<> ? ";
        String sql_add = "select fid from t_bg_bginnerfilldata where fnumber = ? and forgunitid= ? ";
        ArrayList<String> param = new ArrayList<String>();
        param.add(num);
        param.add(orgUnitId);
        if (id != null) {
            param.add(id);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql_edit, (Object[])param.toArray());
        } else {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql_add, (Object[])param.toArray());
        }
        if (null != rs) {
            try {
                if (rs.next()) {
                    rst = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rst;
    }

    @Override
    protected boolean _batchRemove(Context ctx, List bgDataIds) throws BOSException, EASBizException {
        boolean rst = true;
        Connection conn = null;
        String delIds = "";
        String delId = "";
        Iterator iter = bgDataIds.iterator();
        AbstractBgInnerFillDataInfo info = null;
        while (iter.hasNext()) {
            delId = iter.next().toString();
            if (!this._checkCanDele(ctx, delId)) continue;
            delIds = delIds + "'" + delId + "',";
            this.writerLogin(ctx, delId);
        }
        if (delIds.equals("")) {
            return false;
        }
        String sqlGetNumber = "select fnumber, FOrgUnitID from t_bg_bginnerfilldata where fid in (" + delIds.substring(0, delIds.length() - 1) + ")";
        String sql = "delete from t_bg_bginnerfilldata where fid in (" + delIds.substring(0, delIds.length() - 1) + ")";
        String sqlEntry = "delete from t_bg_bginnerfilldataentry where fbginnerfilldataid in (" + delIds.substring(0, delIds.length() - 1) + ")";
        try {
            conn = this.getConnection(ctx);
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlGetNumber);
            ArrayList<String> numberList = new ArrayList<String>();
            String orgUnitId = null;
            while (row.next()) {
                numberList.add(row.getString(1));
                if (orgUnitId != null) continue;
                orgUnitId = row.getString(2);
            }
            if (numberList.size() > 0) {
                if (info == null && !StringUtils.isEmpty((String)delId)) {
                    info = this.getBgInnerFillDataInfo(ctx, (IObjectPK)new ObjectUuidPK(delId));
                }
                if (info != null && info.getOrgUnit() != null && info.getOrgUnit().getId() != null) {
                    for (int i = 0; i < numberList.size(); ++i) {
                        BgCodeNumberNHelper.recycleNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), (String)numberList.get(i));
                    }
                }
            }
            SQLUtils.execute((Connection)conn, (String)sql);
            SQLUtils.execute((Connection)conn, (String)sqlEntry);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return rst;
    }

    private void writerLogin(Context ctx, String id) throws EASBizException, BOSException {
        BgInnerFillDataInfo info = (BgInnerFillDataInfo)super._getValue(ctx, (IObjectPK)new ObjectUuidPK(id));
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_batchRemove", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgInnerFillData_remove");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgInnerFillDataInfo bgInnerFillDataInfo = (BgInnerFillDataInfo)super._getValue(ctx, pk);
        return bgInnerFillDataInfo.getNumber() + " " + bgInnerFillDataInfo.getName();
    }
}

