/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryCollection;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgFlexibleFilterParam;
import com.kingdee.eas.ma.nbudget.app.AbstractBgNAnalyseFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNAnalyseFacadeControllerBean
extends AbstractBgNAnalyseFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgNAnalyseFacadeControllerBean");

    @Override
    protected Map _getFlexibleData(Context ctx, BgFlexibleFilterParam filterParam) throws BOSException, EASBizException {
        if (filterParam == null || filterParam.getBgItems() == null || filterParam.getBgItems().getResult() == null || filterParam.getBgPeriod() == null || filterParam.getBgScheme() == null || filterParam.getCurrency() == null || filterParam.getCurrOrgUnit() == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> cond = new ArrayList<String>();
        sql.append("SELECT entry.FID entry_FID,entry.FAdjustBillID entry_FAdjustBillID,org.FName_").append(ctx.getLocale()).append(" org_FName,");
        sql.append("entry.FbgItemCmbName entry_bgItemCmbName,entry.FadjustGroup entry_adjustGroup,entry.FadjustPass entry_adjustPass,period.FNumber period_FNumber,entry.FBgElementID entry_FBgElementID,currency.FPrecision currency_FPrecision ");
        sql.append("FROM t_bg_bgadjustbillentry entry ");
        sql.append("LEFT JOIN t_org_baseunit org ON org.FID = entry.FOrgUnitID ");
        sql.append("LEFT JOIN t_bg_bgperiod period ON period.FID = entry.FBgPeriodID ");
        sql.append("LEFT JOIN t_bd_currency currency ON currency.FID = entry.FCurrencyID ");
        sql.append("LEFT JOIN t_bg_bgadjustbill adjust ON adjust.FID = entry.FAdjustBillID ");
        sql.append("LEFT JOIN t_bg_bgadjustbillentry cond  ON cond.FAdjustBillID=entry.FAdjustBillID AND cond.FAdjustGroup=entry.FAdjustGroup ");
        sql.append("WHERE cond.FAdjustType='2' ");
        sql.append("AND cond.FBgSchemeID=? ");
        cond.add(filterParam.getBgScheme().getId().toString());
        sql.append("AND cond.FOrgUnitId=? ");
        cond.add(filterParam.getCurrOrgUnit().getId().toString());
        sql.append("AND cond.FBgPeriodID=? ");
        cond.add(filterParam.getBgPeriod().getId().toString());
        sql.append("AND cond.FCurrencyID=? ");
        cond.add(filterParam.getCurrency().getId().toString());
        BgItemCollection bgItemCol = filterParam.getBgItems().getResult();
        sql.append("AND ( cond.FFormula LIKE ? ");
        cond.add("=BgItem(\"" + bgItemCol.get(0).getNumber() + "\",%");
        for (int i = 1; i < bgItemCol.size(); ++i) {
            sql.append("OR cond.FFormula LIKE ? ");
            cond.add("=BgItem(\"" + bgItemCol.get(i).getNumber() + "\",%");
        }
        sql.append(" ) ");
        sql.append("ORDER BY adjust.FNumber,entry.FAdjustGroup ");
        HashMap<String, BigDecimal> elementParam = new HashMap<String, BigDecimal>();
        if (filterParam.getElementMap() != null && !filterParam.getElementMap().isEmpty()) {
            for (Map.Entry e : filterParam.getElementMap().entrySet()) {
                elementParam.put(((BgElementInfo)e.getKey()).getId().toString(), ((MeasureUnitInfo)e.getValue()).getCoefficient());
            }
        }
        BgAdjustBillEntryCollection col = new BgAdjustBillEntryCollection();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql.toString());
            for (int i = 0; i < cond.size(); ++i) {
                pst.setObject(i + 1, cond.get(i));
            }
            res = pst.executeQuery();
            BgAdjustBillEntryInfo entry = null;
            while (res.next()) {
                entry = new BgAdjustBillEntryInfo();
                entry.setId(BOSUuid.read((String)res.getString("entry_FID")));
                entry.setAdjustBill(new BgAdjustBillInfo());
                entry.getAdjustBill().setId(BOSUuid.read((String)res.getString("entry_FAdjustBillID")));
                entry.setOrgUnit(new FullOrgUnitInfo());
                entry.getOrgUnit().setName(res.getString("org_FName"));
                entry.setBgItemCmbName(res.getString("entry_bgItemCmbName"));
                entry.setAdjustGroup(res.getInt("entry_adjustGroup"));
                entry.setBgPeriod(new BgPeriodInfo());
                entry.getBgPeriod().setNumber(res.getString("period_FNumber"));
                entry.setAdjustPass(res.getBigDecimal("entry_adjustPass"));
                entry.setBgElement(new BgElementInfo());
                entry.getBgElement().setId(BOSUuid.read((String)res.getString("entry_FBgElementID")));
                entry.setCurrency(new CurrencyInfo());
                entry.getCurrency().setPrecision(res.getInt("currency_FPrecision"));
                col.add(entry);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"exec SQL:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
        LinkedHashMap<String, BgAdjustBillEntryCollection> temMap = new LinkedHashMap<String, BgAdjustBillEntryCollection>();
        BgAdjustBillEntryCollection entryCol = null;
        String key = null;
        BgAdjustBillEntryInfo entry = null;
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                entry = col.get(i);
                key = entry.getAdjustBill().getId() + "_" + entry.getAdjustGroup();
                if (temMap.containsKey(key)) {
                    entryCol = (BgAdjustBillEntryCollection)temMap.get(key);
                } else {
                    entryCol = new BgAdjustBillEntryCollection();
                    temMap.put(key, entryCol);
                }
                entryCol.add(entry);
            }
        } else {
            return null;
        }
        Set itemNums = filterParam.getBgItemNumberSet();
        LinkedHashMap<String, BgAdjustBillEntryCollection> resMap = new LinkedHashMap<String, BgAdjustBillEntryCollection>();
        int index = 1;
        Iterator it = temMap.keySet().iterator();
        while (it.hasNext()) {
            entryCol = (BgAdjustBillEntryCollection)temMap.get(it.next());
            StringBuffer itemNames = new StringBuffer();
            BgAdjustBillEntryCollection subCol = new BgAdjustBillEntryCollection();
            BgAdjustBillEntryCollection addCol = new BgAdjustBillEntryCollection();
            for (int i = 0; i < entryCol.size(); ++i) {
                entry = entryCol.get(i);
                if (entry.getAdjustPass().signum() == -1) {
                    subCol.add(entry);
                    itemNames.append(entry.getBgItemCmbName());
                    itemNames.append(",");
                    continue;
                }
                addCol.add(entry);
            }
            resMap.put(index + "_" + itemNames.substring(0, itemNames.length() - 1), addCol);
            ++index;
        }
        if (resMap.isEmpty()) {
            return null;
        }
        return resMap;
    }

    private SelectorItemCollection getFlexibleSelectors() {
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("id");
        sel.add("adjustBill.id");
        sel.add("orgUnit.name");
        sel.add("formula");
        sel.add("bgItemCmbName");
        sel.add("adjustGroup");
        sel.add("adjustPass");
        sel.add("bgPeriod.number");
        return sel;
    }

    private SorterItemCollection getFlexibleSorter() {
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("adjustBill.number"));
        sort.add(new SorterItemInfo("adjustGroup"));
        return sort;
    }
}

