/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateException;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgUpdateAssignDataFrom530Enum;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.app.BgAssignUpdateUtil;
import com.kingdee.eas.ma.budget.app.BgCatchUtil;
import com.kingdee.eas.ma.nbudget.BgAutoEnurameHelper;
import com.kingdee.eas.ma.nbudget.BgExpressionsItemVariableHelper;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.BgRowColIdObject;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNAssignUpdateUtil {
    private static Logger logger = Logger.getLogger((String)BgAssignUpdateUtil.class.getName());
    public static final String BOOK_PROTECT_TAG = "BOOK_PROTECT_TAG";
    public static final String SIGN_ROW_ID = "SIGN_ROW_ID";
    public static final String SIGN_COL_ID = "SIGN_COL_ID";
    public static final String BG_FINAL = "BG_FINAL_";

    public static void UpdateTemplateNewCellToFormCell(Context ctx, int rowIndex, int colIndex, int upRowIndex, int upColIndex, Map formulasMap, Map[] itemExpressionMap, boolean isCheckFormula, IObjectValue obj, boolean isTemplateUpdateToForm, Sheet source, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, boolean isFromSchemeAssign, BgTemFormTypeEnum formType, boolean isSelfDefAnalyseForm, boolean hasItemVariable, String companyNumber) throws Exception {
        boolean isEnumateForm = formType.equals((Object)BgTemFormTypeEnum.ENUMERATEFORM);
        Cell cell = null;
        Cell upCell = null;
        Cell upCellActual = null;
        Cell upCellActualAdd = null;
        cell = source.getMergeBlock(rowIndex, colIndex) != null ? source.getCell(rowIndex, colIndex, false) : source.getCell(rowIndex, colIndex, false);
        boolean isAdjustFormual = BgCatchUtil.isAdjustFormula((Context)ctx);
        upCell = update.getCell(upRowIndex, upColIndex, false);
        if (isAdjustFormual) {
            if (cell != null) {
                upCellActual = updateAcutal.getCell(upRowIndex, upColIndex, true);
                upCellActualAdd = updateActualAdd.getCell(upRowIndex, upColIndex, true);
            } else {
                upCellActual = updateAcutal.getCell(upRowIndex, upColIndex, false);
                upCellActualAdd = updateActualAdd.getCell(upRowIndex, upColIndex, false);
            }
        }
        if (hasItemVariable && cell == null) {
            return;
        }
        if (cell == null && upCell == null) {
            return;
        }
        if (cell == null && upCell == null) {
            return;
        }
        if (cell == null && (upCell != null || upCellActual != null || upCellActualAdd != null)) {
            if (!upCell.getSheet().getRange(upCell).isCellLocked()) {
                BgNTemplateHelper.clearAll(upCell, false);
            }
            if (isAdjustFormual) {
                if (upCellActual != null) {
                    upCellActual.setFormula(null);
                }
                if (upCellActualAdd != null) {
                    upCellActualAdd.setFormula(null);
                }
            }
            return;
        }
        boolean isLocked = cell.getSheet().getRange(cell).isCellLocked();
        if (upCell == null) {
            upCell = update.getCell(upRowIndex, upColIndex, true);
        } else if (upCell.getSheet().getRange(upCell).isCellLocked()) {
            BgNLockProtectHelper.setCellLockedAndProtectionFromSuper(upCell, false, false);
        }
        boolean isUpCellHasForumula = false;
        if (isAdjustFormual) {
            if (upCellActual == null) {
                upCellActual = updateAcutal.getCell(upRowIndex, upColIndex, true);
            }
            if (upCellActualAdd == null) {
                upCellActualAdd = updateActualAdd.getCell(upRowIndex, upColIndex, true);
            }
            isUpCellHasForumula = BgNAssignUpdateUtil.updateFormula(cell, upCell, upCellActual, upCellActualAdd, itemExpressionMap, isTemplateUpdateToForm, obj, isCheckFormula, isLocked, isFromSchemeAssign, formType, companyNumber);
        } else {
            isUpCellHasForumula = BgNAssignUpdateUtil.updateFormula(cell, upCell, itemExpressionMap, isTemplateUpdateToForm, obj, isCheckFormula, isLocked, isFromSchemeAssign, isEnumateForm, companyNumber);
        }
        if (BgNFSHelper.checkHasExpression(cell)) {
            String expression = BgNFSHelper.getExpression(cell);
            BgNFSHelper.setExpression(upCell, expression);
        }
        boolean isUpCellHasItemForumula = BgNAssignUpdateUtil.updateItemForumula(ctx, cell, upCell, formulasMap, isCheckFormula, obj, isTemplateUpdateToForm, isEnumateForm);
        BgNAssignUpdateUtil.updateItemForumulaCtrlMode(cell, upCell, obj);
        boolean isUpCellHasLink = BgNAssignUpdateUtil.updateLink(cell, upCell, isTemplateUpdateToForm, obj);
        BgNAssignUpdateUtil.updateFillType(cell, upCell, isEnumateForm);
        BgNAssignUpdateUtil.updateUserObject(cell, upCell);
        if (isSelfDefAnalyseForm) {
            BgExpressionsItemVariableHelper.updateUserObject(cell, upCell, isLocked);
        } else {
            BgAutoEnurameHelper.updateUserObject(cell, upCell, isLocked);
        }
        BgNAssignUpdateUtil.updateCellStyle(source, update, cell, upCell);
        BgNAssignUpdateUtil.updateCellHasText(cell, upCell);
        BgNAssignUpdateUtil.updateName(cell, upCell, isLocked);
        BgNAssignUpdateUtil.updateName(cell, upCell, isLocked);
        BgNAssignUpdateUtil.updateValue(cell, upCell, isUpCellHasForumula, isUpCellHasItemForumula, isUpCellHasLink, isTemplateUpdateToForm);
        BgNAssignUpdateUtil.updateHyperLink(cell, upCell, isLocked);
        BgNAssignUpdateUtil.updateHyperLink(cell, upCell, isLocked);
        if (isLocked) {
            BgNLockProtectHelper.setCellLockedAndProtectionFromSuper(upCell, true, true);
        }
        String currOrg = ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo().getLongNumber();
        String forceLock = BgNTemplateHelper.getForceLockLongNumber(cell);
        String oldForceLock = BgNTemplateHelper.getForceLockLongNumber(upCell);
        if (forceLock != null) {
            BgNTemplateHelper.setForceLock(upCell, forceLock);
        } else if (currOrg == null || oldForceLock != null && currOrg.indexOf(oldForceLock) == 0) {
            BgNTemplateHelper.removeForceLock(upCell);
        }
    }

    private static void updateHyperLink(Cell cell, Cell upCell, boolean isLocked) {
        if (cell != null && upCell != null && isLocked) {
            upCell.setHyperLink(cell.getHyperLink());
        }
    }

    private static void updateCellHasText(Cell cell, Cell upCell) {
    }

    private static void updateName(Cell source, Cell target, boolean isLocked) throws Exception {
        if (isLocked && source != null && target != null) {
            Range upRange = target.getSheet().getRange(target);
            Range range = source.getSheet().getRange(source);
            String sName = range.getName(false, false, true);
            String upName = upRange.getName(false, false, true);
            if (sName != null && !sName.equals(upName)) {
                Sheet tSheet = target.getSheet();
                String referto = tSheet.getSyntaxName() + '!' + Sheet.getBlocksName((SortedCellBlockArray)upRange, (boolean)tSheet.getBook().getDeps().isA1Style(), (boolean)true);
                upRange.setName(sName, referto);
            } else if (sName == null && upName != null) {
                upRange.setName(upName, null);
            }
        }
    }

    public static void updateUserObject(Cell cell, Cell upCell) {
        SortedUserObjectArray ss = cell.getUserObjects(false);
        UserObject useObj = null;
        boolean isBC = false;
        boolean isEC = false;
        boolean isCB = false;
        boolean isCE = false;
        boolean isIB = false;
        boolean isIE = false;
        if (ss != null && !ss.isEmpty()) {
            int ssSize = ss.size();
            for (int k = 0; k < ssSize; ++k) {
                useObj = ss.getUserObject(k);
                if (useObj == null || useObj.getKey() == null) continue;
                if (useObj.getKey().equals("BeginCell")) {
                    upCell.setUserObject("BeginCell", useObj.getValue());
                    isBC = true;
                }
                if (useObj.getKey().equals("EndCell")) {
                    upCell.setUserObject("EndCell", useObj.getValue());
                    isEC = true;
                }
                if (useObj.getKey().equals("CollBeginCell")) {
                    upCell.setUserObject("CollBeginCell", useObj.getValue());
                    isCB = true;
                }
                if (useObj.getKey().equals("CollEndCell")) {
                    upCell.setUserObject("CollEndCell", useObj.getValue());
                    isCE = true;
                }
                if (useObj.getKey().equals("ItemBeginCell")) {
                    upCell.setUserObject("ItemBeginCell", useObj.getValue());
                    isIB = true;
                }
                if (!useObj.getKey().equals("ItemEndCell")) continue;
                upCell.setUserObject("ItemEndCell", useObj.getValue());
                isIE = true;
            }
            if (!isBC) {
                upCell.removeUserObject("BeginCell");
            }
            if (!isEC) {
                upCell.removeUserObject("EndCell");
            }
            if (!isCB) {
                upCell.removeUserObject("CollBeginCell");
            }
            if (!isCE) {
                upCell.removeUserObject("CollEndCell");
            }
            if (!isIB) {
                upCell.removeUserObject("ItemBeginCell");
            }
            if (!isIE) {
                upCell.removeUserObject("ItemEndCell");
            }
        } else if (upCell != null && upCell.getUserObjects(false) != null) {
            upCell.removeUserObject("BeginCell");
            upCell.removeUserObject("EndCell");
            upCell.removeUserObject("CollBeginCell");
            upCell.removeUserObject("CollEndCell");
            upCell.removeUserObject("ItemBeginCell");
            upCell.removeUserObject("ItemEndCell");
        }
    }

    private static void updateCellStyle(Sheet source, Sheet update, Cell cell, Cell upCell) {
        StyleAttributes sa1 = Styles.getEmptySA();
        StyleAttributes sa2 = Styles.getEmptySA();
        source.getRange(cell).getStyle(sa1, sa2);
        sa1.setDirty(sa1.getAllBits());
        sa2.setDirty(sa2.getAllBits());
        update.getRange(upCell).setStyle(sa1, sa2);
    }

    private static void updateValue(Cell cell, Cell upCell, boolean isUpCellHasForumula, boolean isUpCellHasItemForumula, boolean isUpCellHasLink, boolean isTemplateUpdateToForm) {
        if (isUpCellHasLink) {
            return;
        }
        Object value = BgNFSHelper.getValue(cell);
        if (BgNFSHelper.checkHasExpression(cell) && !BgNFSHelper.checkHasExpression(upCell) && value != null && value instanceof BigDecimal && ((BigDecimal)value).equals(new BigDecimal(0))) {
            return;
        }
        if ((value == null || StringUtils.isEmpty((String)value.toString())) && !isTemplateUpdateToForm) {
            BgNFSHelper.setValue(upCell, null);
            return;
        }
        if (!isUpCellHasForumula && !isUpCellHasItemForumula) {
            BgNFSHelper.setValue(upCell, value);
        }
        upCell.setHyperLink(cell.getHyperLink());
    }

    private static void updateFillType(Cell cell, Cell upCell, boolean isEnumateForm) {
        String fillType = (String)BgNTemplateHelper.getBgFillType(cell);
        String fillValue = (String)BgNTemplateHelper.getBgFillValue(cell);
        if (fillType == null || fillType.trim().length() <= 0 || fillValue == null || fillValue.trim().length() <= 0) {
            if (!(StringUtils.isEmpty((String)((String)BgNTemplateHelper.getBgFillType(upCell))) && StringUtils.isEmpty((String)((String)BgNTemplateHelper.getBgFillValue(upCell))) || isEnumateForm)) {
                BgNTemplateHelper.removeBgFillInfo(upCell, false);
            }
            return;
        }
        BgNTemplateHelper.setBgDataValue(upCell, "bgFillType", fillType, false);
        BgNTemplateHelper.setBgDataValue(upCell, "bgFillValue", fillValue, false);
        BgNFSHelper.setCellLocked(upCell, true);
        if (fillType != null && fillType.equals("bgFillValueType_item")) {
            BgNTemplateHelper.setBgDataValue(upCell, "bgFillValue_itemId", BgNTemplateHelper.getBgDataValue(cell, "bgFillValue_itemId"), false);
        } else if (fillType != null && fillType.equals("bgFillValueType_period")) {
            BgNTemplateHelper.setBgDataValue(upCell, "bgFillValueType_period", BgNTemplateHelper.getBgDataValue(cell, "bgFillValueType_period"), false);
        } else if (fillType != null && fillType.equals("bgFillValueType_element")) {
            BgNTemplateHelper.setBgDataValue(upCell, "isAttachFormula", BgNTemplateHelper.getBgDataValue(cell, "isAttachFormula"), false);
        } else if (!(fillType != null && fillType.equals("bgFillValueType_currency") || isEnumateForm)) {
            BgNTemplateHelper.removeBgFillInfo(upCell, false);
        }
    }

    private static boolean updateLink(Cell cell, Cell upCell, boolean isTemplateUpdateToForm, Object obj) {
        String tempatID = null;
        Object orgid = null;
        String schemeNumber = null;
        boolean isHaveLinked = false;
        if (BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_TEMPLATE_ID") != null) {
            tempatID = BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_TEMPLATE_ID");
            if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_FORM_ID") != null) {
                BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_FORM_ID", false);
            }
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_TEMPLATE_ID", tempatID, false);
            if (cell.getValue() != Variant.nullVariant) {
                upCell.setValue(cell.getValue());
            }
            isHaveLinked = true;
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_TEMPLATE_ID") == null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_TEMPLATE_ID", false);
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_FORM_ID", false);
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_FORM_ID") == null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_FORM_ID", false);
        }
        if (BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_SCHEME_NUMBER") != null) {
            schemeNumber = BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_SCHEME_NUMBER");
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_SCHEME_NUMBER", schemeNumber, false);
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_SCHEME_NUMBER") != null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_SCHEME_NUMBER", false);
        }
        if (BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_TEMPLATE_NUMBER") != null) {
            tempatID = BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_TEMPLATE_NUMBER");
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_TEMPLATE_NUMBER", tempatID, false);
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_TEMPLATE_NUMBER") != null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_TEMPLATE_NUMBER", false);
        }
        if (BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_ORGUNIT_ID") != null) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_ORGUNIT_ID", BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_ORGUNIT_ID"), false);
        } else if (tempatID != null && tempatID.trim().length() > 0) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_ORGUNIT_ID", orgid, false);
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_ORGUNIT_ID") != null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_ORGUNIT_ID", false);
        }
        if (BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_SCHEME_ID") != null) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_SCHEME_ID", BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_SCHEME_ID"), false);
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_SCHEME_ID") != null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_SCHEME_ID", false);
        }
        if (BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_PERIOD_ID") != null) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_PERIOD_ID", BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_PERIOD_ID"), false);
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_PERIOD_ID") != null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_PERIOD_ID", false);
        }
        if (BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_CURRENCY_ID") != null) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_LINK_CURRENCY_ID", BgNTemplateHelper.getBgDataValue(cell, "BG_LINK_CURRENCY_ID"), false);
        } else if (BgNTemplateHelper.getBgDataValue(upCell, "BG_LINK_CURRENCY_ID") != null) {
            BgNTemplateHelper.removeDataValue(upCell, "BG_LINK_CURRENCY_ID", false);
        }
        return isHaveLinked;
    }

    private static void updateItemForumulaCtrlMode(Cell cell, Cell upCell, Object obj) {
        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return;
        }
        ItemFormula sItemFormual = BgNFSHelper.getItemFormula(cell);
        ItemFormula uItemFormual = BgNFSHelper.getItemFormula(upCell);
        uItemFormual.putExt("isctrl_from_super_collection_form", "true");
        if (sItemFormual.getExt("isCtrl") == null) {
            if (uItemFormual.getExt("isCtrl") != null) {
                uItemFormual.removeExt("isCtrl");
            }
            if (uItemFormual.getExt("isFlexCtrl") != null) {
                uItemFormual.removeExt("isFlexCtrl");
            }
            if (uItemFormual.getExt("flexCtrlParam") != null) {
                uItemFormual.removeExt("flexCtrlParam");
            }
            if (uItemFormual.getExt("periodCtrlPolicy") != null) {
                uItemFormual.removeExt("periodCtrlPolicy");
            }
            if (uItemFormual.getExt("groupCtrlNo") != null) {
                uItemFormual.removeExt("groupCtrlNo");
            }
            if (uItemFormual.getExt("isGroupCtrl") != null) {
                uItemFormual.removeExt("isGroupCtrl");
            }
            if (uItemFormual.getExt("isAllowAccess") != null) {
                uItemFormual.removeExt("isAllowAccess");
            }
            return;
        }
        uItemFormual.putExt("isCtrl", sItemFormual.getExt("isCtrl"));
        if (sItemFormual.getExt("isFlexCtrl") != null) {
            uItemFormual.putExt("isFlexCtrl", sItemFormual.getExt("isFlexCtrl"));
        } else if (uItemFormual.getExt("isFlexCtrl") != null) {
            uItemFormual.removeExt("isFlexCtrl");
        }
        if (sItemFormual.getExt("flexCtrlParam") != null) {
            uItemFormual.putExt("flexCtrlParam", sItemFormual.getExt("flexCtrlParam"));
        } else if (uItemFormual.getExt("flexCtrlParam") != null) {
            uItemFormual.removeExt("flexCtrlParam");
        }
        if (sItemFormual.getExt("periodCtrlPolicy") != null) {
            uItemFormual.putExt("periodCtrlPolicy", sItemFormual.getExt("periodCtrlPolicy"));
        } else if (uItemFormual.getExt("periodCtrlPolicy") != null) {
            uItemFormual.removeExt("periodCtrlPolicy");
        }
        if (sItemFormual.getExt("isGroupCtrl") != null) {
            uItemFormual.putExt("isGroupCtrl", sItemFormual.getExt("isGroupCtrl"));
        } else if (uItemFormual.getExt("isGroupCtrl") != null) {
            uItemFormual.removeExt("isGroupCtrl");
        }
        if (sItemFormual.getExt("groupCtrlNo") != null) {
            String groupctrlno = sItemFormual.getExt("groupCtrlNo");
            if (groupctrlno != null && groupctrlno.trim().length() > 0) {
                uItemFormual.putExt("groupCtrlNo", groupctrlno);
            } else {
                uItemFormual.putExt("groupCtrlNo", "-1");
            }
        } else if (uItemFormual.getExt("groupCtrlNo") != null) {
            uItemFormual.removeExt("groupCtrlNo");
        }
        if (sItemFormual.getExt("isAllowAccess") != null) {
            uItemFormual.putExt("isAllowAccess", sItemFormual.getExt("isAllowAccess"));
        } else if (uItemFormual.getExt("isAllowAccess") != null) {
            uItemFormual.removeExt("isAllowAccess");
        }
    }

    private static boolean updateItemForumula(Context ctx, Cell cell, Cell upCell, Map formulasMap, boolean isCheckFormula, IObjectValue obj, boolean isTemplateUpdateToForm, boolean isEnumateForm) throws EASBizException, BOSException {
        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) {
            if (BgNFSHelper.checkHasFormulaOfCell(upCell)) {
                BgNFSHelper.clearFormulaOfCell(upCell);
                BgNFSHelper.setBudgetValue(upCell, null);
                BgNFSHelper.setValue(upCell, null);
            }
            return false;
        }
        String formulaString = BgNFSHelper.getFormulaOfCell(cell);
        if (isCheckFormula && isTemplateUpdateToForm) {
            formulaString = BgNAssignUpdateUtil.reBuildFormula(ctx, obj, formulasMap, formulaString);
        }
        String upFormulaString = BgNFSHelper.getFormulaOfCell(upCell);
        if (formulaString != null && !formulaString.equals(upFormulaString)) {
            BgNFSHelper.setBudgetValue(upCell, null);
            BgNFSHelper.setValue(upCell, null);
        } else if (upFormulaString != null && !upFormulaString.equals(formulaString)) {
            BgNFSHelper.setBudgetValue(upCell, null);
            BgNFSHelper.setValue(upCell, null);
        }
        BgNFSHelper.setFormulaOfCell(upCell, formulaString, true);
        BgNFSHelper.setFormulaEditOfCell(upCell, false);
        return true;
    }

    private static String reBuildFormula(Context ctx, Object obj, Map formulasMap, String formulaString) throws EASBizException, BOSException {
        String[] parameter;
        boolean isRestart = true;
        BgFormInfo bgFormInfo = (BgFormInfo)obj;
        if (formulasMap == null) {
            formulasMap = new HashMap();
        }
        if ((parameter = BgNAssignUpdateUtil.getFormulaInfo(formulasMap, formulaString = BgNTemplateHelper.get6ParematerItemFormula(formulaString))) != null) {
            if (parameter[1] == null || parameter[1].trim().length() == 0) {
                parameter[1] = bgFormInfo.getBgPeriod().getNumber();
            }
            if (parameter[5] == null || parameter[5].trim().length() == 0) {
                parameter[5] = bgFormInfo.getCurrency().getNumber();
            }
        }
        if (parameter[1] != null && parameter[1].trim().length() > 0) {
            boolean isRelativeBgPeriod = false;
            int relativeValue = 0;
            try {
                relativeValue = Integer.parseInt(parameter[1]);
                isRelativeBgPeriod = true;
            }
            catch (NumberFormatException e) {
                isRelativeBgPeriod = false;
            }
            if (isRelativeBgPeriod) {
                parameter[1] = BgNAssignUpdateUtil.getRelativeBgPeriod(ctx, bgFormInfo.getBgPeriod().getNumber(), relativeValue);
            }
            try {
                parameter[1] = BgPeriodNVariableHelper.getBgPeriodByN((String)bgFormInfo.getBgPeriod().getNumber(), (String)parameter[1], (int)bgFormInfo.getBgPeriod().getPeriodType().getValue());
            }
            catch (Exception e) {
                logger.error((Object)"errir", (Throwable)e);
            }
        }
        if (isRestart) {
            formulaString = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")").toString();
            BgNAssignUpdateUtil.getFormulaInfo(formulasMap, formulaString);
        }
        return formulaString;
    }

    public static String getRelativeBgPeriod(Context ctx, String currentBgPeriodNumber, int relativeValue) throws BOSException, EASBizException {
        int year;
        IBgPeriod iPeriod = null;
        iPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodInfo bgPeriod = null;
        try {
            bgPeriod = iPeriod.getBgPeriodInfo("select id, number, periodType, year, halfyear, quarter, month, week  where number = '" + currentBgPeriodNumber + "'");
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e);
        }
        if (bgPeriod == null) {
            throw new BgPeriodException(BgPeriodException.CURRENTPERIODERROR);
        }
        if (relativeValue == 0) {
            return currentBgPeriodNumber;
        }
        String newBgPeriodNumber = null;
        if (bgPeriod.getPeriodType().getValue() == 8) {
            return currentBgPeriodNumber;
        }
        if (bgPeriod.getPeriodType().getValue() == 1) {
            year = bgPeriod.getYear();
            newBgPeriodNumber = year + relativeValue + "Y";
        } else if (bgPeriod.getPeriodType().getValue() == 3) {
            year = bgPeriod.getYear();
            int quarter = bgPeriod.getQuarter();
            int newQuarter = quarter + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newQuarter % 4;
                y = newQuarter / 4;
                if (x == 0) {
                    --y;
                }
            } else if (newQuarter == 0) {
                x = 0;
                y = -1;
            } else if (newQuarter < 0) {
                x = newQuarter % 4 + 4;
                y = newQuarter / 4 - 1;
            } else if (newQuarter > 0) {
                x = newQuarter;
                y = 0;
            }
            x = x == 0 ? 4 : x;
            newBgPeriodNumber = year + y + "Y.0" + x + "Q";
        } else if (bgPeriod.getPeriodType().getValue() == 4) {
            year = bgPeriod.getYear();
            int month = bgPeriod.getMonth();
            int newMonth = month + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newMonth % 12;
                y = newMonth / 12;
                if (x == 0) {
                    --y;
                }
            } else if (newMonth == 0) {
                x = 0;
                y = -1;
            } else if (newMonth < 0) {
                x = newMonth % 12 + 12;
                y = newMonth / 12 - 1;
            } else if (newMonth > 0) {
                x = newMonth;
                y = 0;
            }
            x = x == 0 ? 12 : x;
            newBgPeriodNumber = year + y + "Y." + (x >= 10 ? x + "" : "0" + x) + "M";
        } else if (bgPeriod.getPeriodType().getValue() == 2) {
            year = bgPeriod.getYear();
            int hy = bgPeriod.getHalfYear();
            int newHy = hy + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newHy % 2;
                y = newHy / 2;
                if (x == 0) {
                    --y;
                }
            } else if (newHy == 0) {
                x = 0;
                y = -1;
            } else if (newHy < 0) {
                x = newHy % 2 + 2;
                y = newHy / 2 - 1;
            } else if (newHy > 0) {
                x = newHy;
                y = 0;
            }
            x = x == 0 ? 2 : x;
            newBgPeriodNumber = year + y + "Y.0" + x + "HY";
        } else if (bgPeriod.getPeriodType().getValue() == 7) {
            newBgPeriodNumber = currentBgPeriodNumber;
        } else if (bgPeriod.getPeriodType().getValue() == 6) {
            newBgPeriodNumber = currentBgPeriodNumber;
        } else if (bgPeriod.getPeriodType().getValue() == 5) {
            newBgPeriodNumber = currentBgPeriodNumber;
        }
        try {
            bgPeriod = iPeriod.getBgPeriodInfo("select id where number = '" + newBgPeriodNumber + "'");
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e);
            throw new BgPeriodException(BgPeriodException.RELATIVEPERIODERROR);
        }
        return newBgPeriodNumber;
    }

    public static String[] getFormulaInfo(Map map, String formulaString) {
        if (formulaString == null) {
            return null;
        }
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        if (map != null && map.containsKey(formulaString)) {
            parameter = (String[])map.get(formulaString);
        } else {
            try {
                formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex);
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                if (map != null) {
                    map.put(formulaString, parameter);
                }
                formulaHint.clear();
            }
        }
        return parameter;
    }

    private static boolean updateFormula(Cell cell, Cell upCell, Cell upCellActual, Cell upCellActualAdd, Map[] itemExpressionMap, boolean isTemplateUpdateToForm, IObjectValue obj, boolean isCheckFormula, boolean isLocked, boolean isFromSchemeAssign, BgTemFormTypeEnum formType, String compnayNumber) {
        boolean isHaveUpdateExpression = false;
        String[] expr = new String[]{BgNTemplateHelper.getBgDataValue(cell, "BG_BUDGET_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue(cell, "BG_ACTUAL_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue(cell, "BG_ADD_EXPRESSIONS")};
        String[] exprUp = new String[]{BgNTemplateHelper.getBgDataValue(upCell, "BG_BUDGET_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue(upCellActual, "BG_ACTUAL_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue(upCellActualAdd, "BG_ADD_EXPRESSIONS")};
        if (upCell != null && upCell.hasFormula() && !upCell.getFormula().equals(exprUp[0])) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_BUDGET_EXPRESSIONS", upCell.getFormula(), false);
        }
        if (upCellActual != null && upCellActual.hasFormula() && !upCellActual.getFormula().equals(exprUp[1])) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_ACTUAL_EXPRESSIONS", upCellActual.getFormula(), false);
        }
        if (upCellActualAdd != null && upCellActualAdd.hasFormula() && !upCellActualAdd.getFormula().equals(exprUp[2])) {
            BgNTemplateHelper.setBgDataValue(upCell, "BG_ADD_EXPRESSIONS", upCellActualAdd.getFormula(), false);
        }
        if (isLocked || formType.equals((Object)BgTemFormTypeEnum.FIXEDFORM)) {
            if (!(expr[0] != null && expr[0].trim().length() >= 1 || expr[1] != null && expr[1].trim().length() >= 1 || expr[2] != null && expr[2].trim().length() >= 1)) {
                if (upCell.hasFormula()) {
                    upCell.setFormula(null);
                    BgNFSHelper.setValue(upCell, null);
                    BgNFSHelper.setBudgetValue(upCell, new BigDecimal("0"));
                }
                upCellActual.setFormula(null);
                upCellActualAdd.setFormula(null);
                return false;
            }
            if (isTemplateUpdateToForm) {
                BgNAssignUpdateUtil.reBuildExpression(cell, expr, itemExpressionMap, obj, compnayNumber);
            }
            if (expr[0] == null || expr[0].trim().length() < 1) {
                if (upCell.hasFormula()) {
                    upCell.setFormula(null);
                    BgNFSHelper.setValue(upCell, null);
                    BgNFSHelper.setBudgetValue(upCell, new BigDecimal("0"));
                }
            } else {
                if (upCell.getFormula() == null || !expr[0].replaceAll(" ", "").equalsIgnoreCase(upCell.getFormula().replaceAll(" ", ""))) {
                    BgNFSHelper.setValue(upCell, null);
                    BgNFSHelper.setBudgetValue(upCell, new BigDecimal("0"));
                }
                upCell.setFormula(expr[0]);
            }
            upCellActual.setFormula(expr[1]);
            upCellActualAdd.setFormula(expr[2]);
        }
        if (BgNFSHelper.checkHasExpression(upCell) || BgNFSHelper.checkHasExpression(upCellActual) || BgNFSHelper.checkHasExpression(upCellActualAdd)) {
            isHaveUpdateExpression = true;
        }
        return isHaveUpdateExpression;
    }

    private static boolean updateFormula(Cell cell, Cell upCell, Map[] itemExpressionMap, boolean isTemplateUpdateToForm, IObjectValue obj, boolean isCheckFormula, boolean isLocked, boolean isFromTemplateAssign, boolean isEnumateForm, String companyNumber) {
        boolean isHaveUpdateExpression = false;
        String[] expr = new String[]{BgNTemplateHelper.getBgDataValue(cell, "BG_BUDGET_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue(cell, "BG_ACTUAL_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue(cell, "BG_ADD_EXPRESSIONS")};
        if (isLocked || !isEnumateForm) {
            if (isTemplateUpdateToForm && !isFromTemplateAssign) {
                if (!(expr[0] != null && expr[0].trim().length() >= 1 || expr[1] != null && expr[1].trim().length() >= 1 || expr[2] != null && expr[2].trim().length() >= 1)) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_BUDGET_EXPRESSIONS", false);
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ACTUAL_EXPRESSIONS", false);
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ADD_EXPRESSIONS", false);
                    if (BgNFSHelper.checkHasExpression(upCell)) {
                        upCell.setFormula(null);
                    }
                    return false;
                }
                if (isCheckFormula) {
                    BgNAssignUpdateUtil.reBuildExpression(cell, expr, itemExpressionMap, obj, companyNumber);
                }
                if (expr[0] == null || expr[0].trim().length() < 1) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_BUDGET_EXPRESSIONS", false);
                } else {
                    BgNTemplateHelper.setBgDataValue(upCell, "BG_BUDGET_EXPRESSIONS", expr[0], false);
                }
                if (expr[1] == null || expr[1].trim().length() < 1) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ACTUAL_EXPRESSIONS", false);
                } else {
                    BgNTemplateHelper.setBgDataValue(upCell, "BG_ACTUAL_EXPRESSIONS", expr[1], false);
                }
                if (expr[2] == null || expr[2].trim().length() < 1) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ADD_EXPRESSIONS", false);
                } else {
                    BgNTemplateHelper.setBgDataValue(upCell, "BG_ADD_EXPRESSIONS", expr[2], false);
                }
                if (expr[0] != null && expr[0].toString().trim().length() > 0) {
                    if (isLocked && (upCell.getFormula() == null || !expr[0].replaceAll(" ", "").equalsIgnoreCase(upCell.getFormula().replaceAll(" ", "")))) {
                        BgNFSHelper.setValue(upCell, null);
                        BgNFSHelper.setBudgetValue(upCell, new BigDecimal("0"));
                    }
                    upCell.setFormula(expr[0]);
                } else if (BgNFSHelper.checkHasExpression(upCell)) {
                    upCell.setFormula(null);
                }
            } else if (isLocked) {
                if (!(expr[0] != null && expr[0].trim().length() >= 1 || expr[1] != null && expr[1].trim().length() >= 1 || expr[2] != null && expr[2].trim().length() >= 1)) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_BUDGET_EXPRESSIONS", false);
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ACTUAL_EXPRESSIONS", false);
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ADD_EXPRESSIONS", false);
                    if (BgNFSHelper.checkHasExpression(upCell)) {
                        upCell.setFormula(null);
                        BgNFSHelper.setValue(upCell, null);
                        BgNFSHelper.setBudgetValue(upCell, new BigDecimal("0"));
                    }
                    return false;
                }
                if (isTemplateUpdateToForm && isCheckFormula) {
                    BgNAssignUpdateUtil.reBuildExpression(cell, expr, itemExpressionMap, obj, companyNumber);
                }
                if (expr[0] == null || expr[0].trim().length() < 1) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_BUDGET_EXPRESSIONS", false);
                } else {
                    BgNTemplateHelper.setBgDataValue(upCell, "BG_BUDGET_EXPRESSIONS", expr[0], false);
                }
                if (expr[1] == null || expr[1].trim().length() < 1) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ACTUAL_EXPRESSIONS", false);
                } else {
                    BgNTemplateHelper.setBgDataValue(upCell, "BG_ACTUAL_EXPRESSIONS", expr[1], false);
                }
                if (expr[2] == null || expr[2].trim().length() < 1) {
                    BgNTemplateHelper.removeDataValue(upCell, "BG_ADD_EXPRESSIONS", false);
                } else {
                    BgNTemplateHelper.setBgDataValue(upCell, "BG_ADD_EXPRESSIONS", expr[2], false);
                }
                if (expr[0] != null && expr[0].toString().trim().length() > 0) {
                    if (upCell.getFormula() == null || !expr[0].replaceAll(" ", "").equalsIgnoreCase(upCell.getFormula().replaceAll(" ", ""))) {
                        upCell.setFormula(expr[0]);
                    }
                    BgNFSHelper.setValue(upCell, null);
                    BgNFSHelper.setBudgetValue(upCell, new BigDecimal("0"));
                } else if (BgNFSHelper.checkHasExpression(upCell)) {
                    upCell.setFormula(null);
                }
            }
        }
        if (BgNTemplateHelper.getFormula(upCell) != null && BgNTemplateHelper.getFormula(upCell).length() > 0) {
            isHaveUpdateExpression = true;
        }
        return isHaveUpdateExpression;
    }

    private static void reBuildExpression(Cell cell, String[] expr, Map[] itemExpressionMap, Object obj, String companyNumber) {
        if (!(obj instanceof BgFormInfo) && !(obj instanceof BgActualRecordInfo)) {
            return;
        }
        if (expr == null || expr.length == 0) {
            return;
        }
        if (expr.length == 1) {
            if (itemExpressionMap[0] == null) {
                itemExpressionMap[0] = new HashMap();
            }
            expr[0] = BgNAssignUpdateUtil.getExpressioninfo(cell, itemExpressionMap[0], expr[0], (IObjectValue)obj, companyNumber);
        } else {
            for (int i = 0; i < 3; ++i) {
                if (itemExpressionMap[i] == null) {
                    itemExpressionMap[i] = new HashMap();
                }
                expr[i] = BgNAssignUpdateUtil.getExpressioninfo(cell, itemExpressionMap[i], expr[i], (IObjectValue)obj, companyNumber);
            }
        }
    }

    public static String getExpressioninfo(Cell cell, Map map, String formulaString, IObjectValue info, String companyNumber) {
        if (formulaString == null || formulaString.trim().length() < 1) {
            return null;
        }
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (map.containsKey(formulaString)) {
            return (String)map.get(formulaString);
        }
        String expression = BgNExpressionHelper.checkExpression(cell, formulaString, info, null, companyNumber);
        map.put(formulaString, expression);
        return expression;
    }

    public static Map getDefaultChildTemFormProMap(Book book) {
        HashMap mapPro = new HashMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("2", null);
        mapPro.put(BOOK_PROTECT_TAG, map);
        Sheet sheet = null;
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            sheet = book.getSheet(i);
            if (sheet == null) continue;
            map = new HashMap();
            map.put("8192", null);
            map.put("1024", null);
            mapPro.put(sheet.getID(), map);
        }
        return mapPro;
    }

    public static void updateOnlyActualAddFormula(Book bookInit, Book bookTo) throws EASBizException, BOSException {
        int sheetCountTo = bookTo.getSheetCount();
        Sheet sheetInit = null;
        Sheet sheetTo = null;
        Row rowInit = null;
        Column columnInit = null;
        Cell cellTo = null;
        Cell cellInit = null;
        String rowId = null;
        String colId = null;
        int upRowIndex = -1;
        int upColIndex = -1;
        Map aliasMap = null;
        String formual = null;
        for (int i = 0; i < sheetCountTo; ++i) {
            sheetTo = bookTo.getSheet(i);
            if (sheetTo == null || (sheetInit = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId(BgNFSHelper.getSheetSign(sheetTo), bookInit)) == null && (sheetInit = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID(sheetTo.getID(), bookInit)) == null) continue;
            aliasMap = BgNAssignUpdateUtil.getSuperiorTableInfo(sheetInit, sheetInit.getID(), aliasMap);
            Map tableMap = null;
            Map rowAlias = null;
            Map colAlias = null;
            tableMap = (Map)aliasMap.get(sheetInit.getID());
            if (tableMap.containsKey(SIGN_ROW_ID)) {
                rowAlias = (Map)tableMap.get(SIGN_ROW_ID);
            }
            if (tableMap.containsKey(SIGN_COL_ID)) {
                colAlias = (Map)tableMap.get(SIGN_COL_ID);
            }
            int rowCount = sheetInit.getMaxRowIndex() + 1;
            for (int j = 0; j < rowCount; ++j) {
                rowInit = sheetInit.getRow(j, false);
                if (rowInit == null || BgNFSHelper.getRowSign(rowInit) == null) continue;
                rowId = BgNFSHelper.getRowSign(rowInit);
                int colCount = sheetInit.getMaxColIndex() + 1;
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    columnInit = sheetInit.getColumn(colIndex, false);
                    if (columnInit == null || BgNFSHelper.getColSign(columnInit) == null) continue;
                    colId = BgNFSHelper.getColSign(columnInit);
                    if (rowAlias == null || colAlias == null || !rowAlias.containsKey(rowId) || !colAlias.containsKey(colId)) continue;
                    upRowIndex = (Integer)rowAlias.get(rowId);
                    upColIndex = (Integer)colAlias.get(colId);
                    if (sheetInit.getMergeBlock(j, colIndex) != null) {
                        CellBlock cellBolck = sheetInit.getMergeBlock(j, colIndex);
                        cellInit = sheetInit.getCell(cellBolck.getRow(), cellBolck.getCol(), false);
                    } else {
                        cellInit = sheetInit.getCell(j, colIndex, false);
                    }
                    if (cellInit == null) continue;
                    cellTo = sheetTo.getCell(upRowIndex, upColIndex, true);
                    formual = BgNTemplateHelper.getAuctualAddFormula(cellInit);
                    BgNTemplateHelper.setBgDataValue(cellTo, "BG_ADD_EXPRESSIONS", formual, false);
                }
            }
        }
    }

    public static Map getSuperiorTableInfo(Sheet sheet, String tableId, Map aliasMap) {
        if (sheet == null) {
            return null;
        }
        HashMap tableMap = null;
        if (aliasMap == null) {
            aliasMap = new HashMap();
        }
        if (!aliasMap.containsKey(tableId)) {
            tableMap = new HashMap();
            aliasMap.put(tableId, tableMap);
            String uuid = null;
            Row row = null;
            Column column = null;
            LinkedHashMap<String, Integer> rowAlias = null;
            LinkedHashMap<String, Integer> colAlias = null;
            if (!tableMap.containsKey(SIGN_ROW_ID)) {
                rowAlias = new LinkedHashMap<String, Integer>();
                tableMap.put(SIGN_ROW_ID, rowAlias);
            }
            if (!tableMap.containsKey(SIGN_COL_ID)) {
                colAlias = new LinkedHashMap<String, Integer>();
                tableMap.put(SIGN_COL_ID, colAlias);
            }
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = sheet.getRow(rowIndex, false);
                if (!BgNFSHelper.checkHasSign(row)) continue;
                uuid = BgNFSHelper.getRowSign(row);
                if (rowAlias == null) continue;
                rowAlias.put(uuid, new Integer(rowIndex));
            }
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                column = sheet.getColumn(colIndex, false);
                if (!BgNFSHelper.checkHasSign(column)) continue;
                uuid = BgNFSHelper.getColSign(column);
                if (colAlias == null) continue;
                colAlias.put(uuid, new Integer(colIndex));
            }
        }
        return aliasMap;
    }

    public static void updateAuditorBgFormOnlyActualAddFormula(BgTemplateInfo tem, BgFormInfo form) throws EASBizException, BOSException {
        if (tem == null || form == null) {
            return;
        }
        Book bookTem = null;
        Book bookForm = null;
        try {
            if (tem.getData() == null) {
                return;
            }
            bookTem = tem.getBook();
            bookForm = form.getData() != null ? form.getBook() : Book.Manager.getNewBook((String)bookTem.getName(), (int)bookTem.getSheetCount());
        }
        catch (Exception ex) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR);
        }
        Map aliasMap = null;
        Sheet sheetForm = null;
        Sheet sheetTem = null;
        Map rowMap = null;
        Map colMap = null;
        Row row = null;
        Column column = null;
        String rowId = null;
        String colId = null;
        Cell cellTem = null;
        Cell cellForm = null;
        int upRowIndex = -1;
        int upColIndex = -1;
        BgNFSHelper.disableUndo(bookForm);
        BgNFSHelper.disableUndo(bookTem);
        int size = bookForm.getSheetCount();
        for (int i = 0; i < size; ++i) {
            sheetForm = bookForm.getSheet(i);
            sheetTem = bookTem.getSheetByID(sheetForm.getID());
            if (sheetTem == null || (aliasMap = BgNAssignUpdateUtil.getSuperiorTableInfo(sheetTem, sheetTem.getID(), aliasMap)).get(sheetTem.getID()) == null || (rowMap = (Map)aliasMap.get(sheetTem.getID())).isEmpty()) continue;
            rowMap = (Map)rowMap.get(SIGN_ROW_ID);
            colMap = (Map)aliasMap.get(sheetTem.getID());
            colMap = (Map)colMap.get(SIGN_COL_ID);
            int rowCount = sheetForm.getMaxRowIndex() + 1;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = sheetForm.getRow(rowIndex, false);
                if (row == null || BgNFSHelper.getRowSign(row) == null || !rowMap.containsKey(rowId = BgNFSHelper.getRowSign(row))) continue;
                upRowIndex = (Integer)rowMap.get(rowId);
                int colCount = sheetForm.getMaxColIndex() + 1;
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    column = sheetForm.getColumn(colIndex, false);
                    if (column == null || BgNFSHelper.getColSign(column) == null || !colMap.containsKey(colId = BgNFSHelper.getColSign(column))) continue;
                    upColIndex = (Integer)colMap.get(colId);
                    cellForm = sheetForm.getCell(rowIndex, colIndex, false);
                    if (sheetTem.getMergeBlock(upRowIndex, upColIndex) != null) {
                        CellBlock cellBolck = sheetTem.getMergeBlock(upRowIndex, upColIndex);
                        cellTem = sheetTem.getCell(cellBolck.getRow(), cellBolck.getCol(), false);
                    } else {
                        cellTem = sheetTem.getCell(upRowIndex, upColIndex, false);
                    }
                    if (cellTem == null && cellForm != null) {
                        BgNTemplateHelper.removeDataValue(cellForm, "BG_ADD_EXPRESSIONS", false);
                        continue;
                    }
                    if (cellTem == null) continue;
                    if (cellForm == null) {
                        if (StringUtils.isEmpty((String)BgNTemplateHelper.getBgDataValue(cellTem, "BG_ADD_EXPRESSIONS"))) continue;
                        cellTem = sheetTem.getCell(upRowIndex, upColIndex, true);
                        BgNTemplateHelper.setBgDataValue(cellTem, "BG_ADD_EXPRESSIONS", BgNTemplateHelper.getBgDataValue(cellTem, "BG_ADD_EXPRESSIONS"), false);
                        continue;
                    }
                    BgNTemplateHelper.setBgDataValue(cellTem, "BG_ADD_EXPRESSIONS", BgNTemplateHelper.getBgDataValue(cellTem, "BG_ADD_EXPRESSIONS"), false);
                }
            }
        }
        try {
            form.setBook(bookForm);
        }
        catch (Exception ex) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR);
        }
    }

    public static Book updateBookActualAddFormulaByFormat(Book bookFrom, Book bookTo, boolean isFromActualRecordForm, IObjectValue obj, Map[] itemExpressionMap, String companyNumber) throws EASBizException, BOSException {
        if (bookFrom == null || bookTo == null) {
            return null;
        }
        Sheet sheetFrom = null;
        Sheet sheetTo = null;
        Row rowFrom = null;
        Row rowTo = null;
        Cell cellTo = null;
        Cell cellFrom = null;
        BgNFSHelper.disableUndo(bookTo);
        BgNFSHelper.disableUndo(bookFrom);
        bookTo.setCalculate(false);
        int size = bookFrom.getSheetCount();
        for (int i = 0; i < size; ++i) {
            sheetFrom = bookFrom.getSheet(i);
            sheetTo = bookTo.getSheetByID(sheetFrom.getID());
            if (sheetTo == null) continue;
            int rowCount = sheetFrom.getMaxRowIndex() + 1;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                int colIndex;
                int colCount;
                rowFrom = sheetFrom.getRow(rowIndex, false);
                rowTo = sheetTo.getRow(rowIndex, false);
                if (rowFrom == null) {
                    if (rowTo == null) continue;
                    colCount = sheetFrom.getMaxColIndex() + 1;
                    for (colIndex = 0; colIndex < colCount; ++colIndex) {
                        cellTo = sheetTo.getCell(rowIndex, colIndex, false);
                        if (cellTo == null) continue;
                        if (isFromActualRecordForm) {
                            if (!cellTo.hasFormula()) continue;
                            cellTo.setFormula(null);
                            continue;
                        }
                        if (StringUtils.isEmpty((String)BgNTemplateHelper.getAuctualAddFormula(cellTo))) continue;
                        BgNTemplateHelper.removeDataValue(cellTo, "BG_ADD_EXPRESSIONS", false);
                    }
                    continue;
                }
                if (rowTo == null) {
                    rowTo = sheetTo.getRow(rowIndex, true);
                }
                colCount = sheetFrom.getMaxColIndex() + 1;
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    String formulaExpress;
                    cellTo = sheetTo.getCell(rowIndex, colIndex, false);
                    if (sheetFrom.getMergeBlock(rowIndex, colIndex) != null) {
                        CellBlock cellBolck = sheetFrom.getMergeBlock(rowIndex, colIndex);
                        cellFrom = sheetFrom.getCell(cellBolck.getRow(), cellBolck.getCol(), false);
                    } else {
                        cellFrom = sheetFrom.getCell(rowIndex, colIndex, false);
                    }
                    if (cellFrom == null && cellTo != null) {
                        formulaExpress = BgNTemplateHelper.getAuctualAddFormula(cellTo);
                        BgNTemplateHelper.removeDataValue(cellTo, "BG_ADD_EXPRESSIONS", false);
                        if (isFromActualRecordForm) {
                            if (!cellTo.hasFormula()) continue;
                            cellTo.setFormula("");
                            continue;
                        }
                        if (StringUtils.isEmpty((String)formulaExpress)) continue;
                        BgNTemplateHelper.removeDataValue(cellTo, "BG_ADD_EXPRESSIONS", false);
                        continue;
                    }
                    if (cellFrom == null) continue;
                    formulaExpress = BgNTemplateHelper.getAuctualAddFormula(cellFrom);
                    if (!StringUtils.isEmpty((String)formulaExpress)) {
                        String[] expr = new String[]{formulaExpress};
                        BgNAssignUpdateUtil.reBuildExpression(cellFrom, expr, itemExpressionMap, obj, companyNumber);
                        formulaExpress = expr[0];
                    }
                    if (cellTo == null) {
                        if (StringUtils.isEmpty((String)formulaExpress)) continue;
                        cellTo = sheetTo.getCell(rowIndex, colIndex, true);
                        if (isFromActualRecordForm) {
                            cellTo.setFormula(formulaExpress);
                            continue;
                        }
                        BgNTemplateHelper.setBgDataValue(cellTo, "BG_ADD_EXPRESSIONS", formulaExpress, false);
                        continue;
                    }
                    if (isFromActualRecordForm) {
                        if (!StringUtils.isEmpty((String)formulaExpress)) {
                            cellTo.setFormula(formulaExpress);
                            continue;
                        }
                        if (!cellTo.hasFormula()) continue;
                        cellTo.setFormula("");
                        continue;
                    }
                    if (!StringUtils.isEmpty((String)formulaExpress)) {
                        BgNTemplateHelper.setBgDataValue(cellTo, "BG_ADD_EXPRESSIONS", formulaExpress, false);
                        continue;
                    }
                    if (StringUtils.isEmpty((String)BgNTemplateHelper.getBgDataValue(cellTo, "BG_ADD_EXPRESSIONS"))) continue;
                    BgNTemplateHelper.removeDataValue(cellTo, "BG_ADD_EXPRESSIONS", false);
                }
            }
        }
        return bookTo;
    }

    public static Sheet CopySheet(Sheet sheetFrom, Sheet sheetTo) {
        int k;
        int ssSize;
        StyleAttributes sa2;
        StyleAttributes sa1 = sa2 = Styles.getEmptySA();
        if (sheetFrom == null || sheetTo == null) {
            return null;
        }
        sheetTo.getColRange(0, 0).setColumnWidth(200);
        sheetTo.copyStyleFrom(sheetFrom);
        Row rowFrom = null;
        Row rowTo = null;
        Cell cellFrom = null;
        Cell cellTo = null;
        int rowCount = sheetFrom.getMaxRowIndex() + 1;
        for (int i = 0; i < rowCount; ++i) {
            rowFrom = sheetFrom.getRow(i, false);
            if (rowFrom == null) continue;
            rowTo = sheetTo.getRow(i, true);
            SortedUserObjectArray ss = rowFrom.getUserObjects();
            UserObject useObj = null;
            if (ss != null && !ss.isEmpty()) {
                int ssSize2 = ss.size();
                for (int k2 = 0; k2 < ssSize2; ++k2) {
                    useObj = ss.getUserObject(k2);
                    rowTo.setUserObject(useObj.getKey(), useObj.getValue());
                }
            }
            int colCount = sheetFrom.getMaxColIndex() + 1;
            for (int j = 0; j < colCount; ++j) {
                cellFrom = rowFrom.getCell(j, false);
                sheetFrom.getRange(i, j).getStyle(sa1, sa2);
                sa1.setDirty(sa1.getAllBits());
                sa2.setDirty(sa2.getAllBits());
                sheetTo.getRange(i, j).setStyle(sa1, sa2);
                if (cellFrom == null) continue;
                cellTo = rowTo.getCell(j, true);
                if (cellFrom.getValue() != Variant.nullVariant) {
                    cellTo.setValue(cellFrom.getValue());
                }
                if (cellFrom.hasFormula()) {
                    BgNFSHelper.setExpression(cellTo, cellFrom.getFormula());
                }
                ss = cellFrom.getUserObjects(false);
                useObj = null;
                if (ss != null && !ss.isEmpty()) {
                    ssSize = ss.size();
                    for (k = 0; k < ssSize; ++k) {
                        useObj = ss.getUserObject(k);
                        cellTo.setUserObject(useObj.getKey(), useObj.getValue());
                    }
                }
                cellTo.setHyperLink(cellFrom.getHyperLink());
            }
        }
        Column colFrom = null;
        Column colTo = null;
        int colCount = sheetFrom.getMaxColIndex() + 1;
        for (int j = 0; j < colCount; ++j) {
            colFrom = sheetFrom.getColumn(j, false);
            if (colFrom == null) continue;
            colTo = sheetTo.getColumn(j, true);
            SortedUserObjectArray ss = colFrom.getUserObjects();
            UserObject useObj = null;
            if (ss == null || ss.isEmpty()) continue;
            ssSize = ss.size();
            for (k = 0; k < ssSize; ++k) {
                useObj = ss.getUserObject(k);
                colTo.setUserObject(useObj.getKey(), useObj.getValue());
            }
        }
        sheetTo.clearStyleCache();
        return sheetTo;
    }

    public static Map updateDataFrom530(Context ctx, String temNum) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fname  from t_bg_bgtemplate t \n\r");
        sql.append("  where  t.fid = t.frootid ");
        if (!StringUtils.isEmpty((String)temNum)) {
            sql.append(" and fnumber = '" + temNum + "'  ");
        }
        sql.append(" and exists ( \n\r");
        sql.append("      select fid  from t_bg_bgtemplate tt \n\r");
        sql.append("           where tt.frootid = t.fid and tt.fid <> t.fid)");
        HashMap<String, String> mapRootTem = new HashMap<String, String>();
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                mapRootTem.put(row.getString("fid"), row.getString("fname"));
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        return mapRootTem;
    }

    public static void updateDataOneTemToChildFrom530(Context ctx, String temRootID) throws BOSException, EASBizException {
        BgTemplateInfo tem = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateInfo("select id,rootid,data where id='" + temRootID + "'");
        BgCatchUtil.putObject((Object)(BG_FINAL + temRootID), (Object)tem, (boolean)true);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fname  from t_bg_bgtemplate t \n\r");
        sql.append("  where t.fid <> t.frootid  and frootid = ? ");
        HashMap<String, String> mapChildTem = new HashMap<String, String>();
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{temRootID});
        try {
            while (row.next()) {
                mapChildTem.put(row.getString("fid"), row.getString("fname"));
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        String temid2 = null;
        for (String temid2 : mapChildTem.keySet()) {
            BgNAssignUpdateUtil.updateTemToTem(ctx, temRootID, temid2);
        }
    }

    public static void updateTemToTem(Context ctx, String temIdFrom, String temIdTo) throws BOSException, EASBizException {
        IBgTemplate iBgTem = BgTemplateFactory.getLocalInstance((Context)ctx);
        BgTemplateInfo bgTemFrom = null;
        BgTemplateInfo bgTemTo = null;
        bgTemFrom = iBgTem.getBgTemplateInfo("select id,rootid,data where id='" + temIdFrom + "'");
        bgTemTo = iBgTem.getBgTemplateInfo("select id,rootid,data where id='" + temIdTo + "'");
        Book bookFrom = null;
        Book bookTo = null;
        try {
            bookFrom = bgTemFrom.getBook();
            bookTo = bgTemTo.getBook();
        }
        catch (Exception e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        BgNAssignUpdateUtil.updateBookToBook(ctx, bookFrom, bookTo, BgUpdateAssignDataFrom530Enum.TemToTem, null);
        try {
            bgTemTo.setBook(bookTo);
        }
        catch (IOException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        byte[] data = bgTemTo.getZipData();
        BgNAssignUpdateUtil.insertMapData(ctx, temIdTo, data, "t_bg_bgtemplate");
        BgNAssignUpdateUtil.updateDataOneTemToFormFrom530(ctx, bgTemTo);
    }

    public static Map updateBookToBook(Context ctx, Book bookFrom, Book bookTo, BgUpdateAssignDataFrom530Enum updateType, Map mapSheetIdOldToNew) throws BOSException, EASBizException {
        HashMap<String, String> map;
        block6: {
            String sheetid;
            Sheet sheetTo;
            Sheet sheetFrom;
            block7: {
                block5: {
                    sheetFrom = null;
                    sheetTo = null;
                    sheetid = null;
                    map = new HashMap<String, String>();
                    if (!updateType.equals((Object)BgUpdateAssignDataFrom530Enum.TemToTem)) break block5;
                    int sheetCount = bookFrom.getSheetCount();
                    for (int i = 0; i < sheetCount; ++i) {
                        sheetFrom = bookFrom.getSheet(i);
                        sheetid = sheetFrom.getID();
                        sheetTo = bookTo.getSheetByID(sheetid);
                        BgNFSHelper.setSheetSign(sheetTo, BgNFSHelper.getSheetSign(sheetFrom));
                    }
                    break block6;
                }
                if (!updateType.equals((Object)BgUpdateAssignDataFrom530Enum.TemToForm)) break block7;
                int sheetCount = bookFrom.getSheetCount();
                for (int i = 0; i < sheetCount; ++i) {
                    sheetFrom = bookFrom.getSheet(i);
                    sheetid = sheetFrom.getID();
                    sheetTo = bookTo.getSheetByID(sheetid);
                    if (BgNFSHelper.getSheetSign(sheetTo) != null && BgNFSHelper.getSheetSign(sheetFrom) != null && !BgNFSHelper.getSheetSign(sheetTo).equals(BgNFSHelper.getSheetSign(sheetFrom))) {
                        map.put(BgNFSHelper.getSheetSign(sheetFrom), BgNFSHelper.getSheetSign(sheetTo));
                    }
                    BgNFSHelper.setSheetSign(sheetTo, BgNFSHelper.getSheetSign(sheetFrom));
                }
                break block6;
            }
            if (!updateType.equals((Object)BgUpdateAssignDataFrom530Enum.FormToActualRecord)) break block6;
            int sheetCount = bookFrom.getSheetCount();
            for (int i = 0; i < sheetCount; ++i) {
                sheetFrom = bookFrom.getSheet(i);
                sheetid = sheetFrom.getID();
                sheetTo = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId(BgNFSHelper.getSheetSign(sheetFrom), bookTo);
                if (sheetTo == null) {
                    sheetTo = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)mapSheetIdOldToNew.get(BgNFSHelper.getSheetSign(sheetFrom)), bookTo);
                }
                BgNFSHelper.setSheetSign(sheetTo, BgNFSHelper.getSheetSign(sheetFrom));
            }
        }
        return map;
    }

    public static void updateDataOneTemToFormFrom530(Context ctx, BgTemplateInfo bgTemTo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid  from t_bg_bgform \n\r");
        sql.append("  where fbgtemplateid = ? ");
        HashMap mapForm = new HashMap();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bgTemTo.getId().toString()});
        try {
            while (row.next()) {
                mapForm.put(row.getString("fid"), null);
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        String formid2 = null;
        for (String formid2 : mapForm.keySet()) {
            BgNAssignUpdateUtil.updateDataOneTemToOneForm(ctx, bgTemTo, formid2);
        }
    }

    private static void updateDataOneTemToOneForm(Context ctx, BgTemplateInfo bgTem, String formid) throws BOSException, EASBizException {
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        BgFormInfo form = iBgForm.getBgFormInfo("select id,bgTemplate.fid,data where id ='" + formid + "'");
        Book bookFrom = null;
        Book bookTo = null;
        try {
            bookFrom = bgTem.getBook();
            bookTo = form.getBook();
        }
        catch (Exception e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        Map mapOldIdToNew = BgNAssignUpdateUtil.updateBookToBook(ctx, bookFrom, bookTo, BgUpdateAssignDataFrom530Enum.TemToForm, null);
        try {
            form.setBook(bookTo);
        }
        catch (IOException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        byte[] data = form.getZipData();
        BgNAssignUpdateUtil.insertMapData(ctx, formid, data, "t_bg_bgform");
        BgNAssignUpdateUtil.updateDataOneFormToActualRecord(ctx, form, mapOldIdToNew);
    }

    private static void updateDataOneFormToActualRecord(Context ctx, BgFormInfo form, Map mapIdOldToNew) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid  from T_BG_BgActualRecord \n\r");
        sql.append("  where FBgFormID = ? ");
        HashMap mapForm = new HashMap();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{form.getId().toString()});
        try {
            while (row.next()) {
                mapForm.put(row.getString("fid"), null);
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        String formid2 = null;
        for (String formid2 : mapForm.keySet()) {
            BgNAssignUpdateUtil.updateDataOneFormToOneActualrecord(ctx, form, formid2, mapIdOldToNew);
        }
    }

    private static void updateDataOneFormToOneActualrecord(Context ctx, BgFormInfo form, String formid, Map mapIdOldToNew) throws BOSException, EASBizException {
        IBgActualRecord iBgForm = BgActualRecordFactory.getLocalInstance((Context)ctx);
        BgActualRecordInfo actualRecord = iBgForm.getBgActualRecordInfo("select id,data where id ='" + formid + "'");
        Book bookFrom = null;
        Book bookTo = null;
        try {
            bookFrom = form.getBook();
            bookTo = actualRecord.getBook();
        }
        catch (Exception e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        BgNAssignUpdateUtil.updateBookToBook(ctx, bookFrom, bookTo, BgUpdateAssignDataFrom530Enum.FormToActualRecord, mapIdOldToNew);
        try {
            actualRecord.setBook(bookTo);
        }
        catch (IOException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        byte[] data = actualRecord.getZipData();
        BgNAssignUpdateUtil.insertMapData(ctx, formid, data, "T_BG_BgActualRecord");
    }

    public static void insertMapData(Context ctx, String id, byte[] data, String table) throws BOSException, EASBizException {
        if (data == null) {
            return;
        }
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("update " + table + " set fdata = ? where fid = ? ");
            ps = conn.prepareStatement(strBuffer.toString());
            if (data == null) {
                ps.setBytes(1, null);
            } else {
                BgInfoHelper.setBytes(ps, 1, data);
            }
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static Sheet getUpdateTableOfBgTemplateBySignId(String sheetId, Book book) throws BOSException, EASBizException {
        if (sheetId == null || book == null) {
            throw new BgException(BgTemplateException.ISCANTIDNULL);
        }
        String signID = null;
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            signID = BgNFSHelper.getSheetSign(book.getSheet(i));
            if (signID == null || !signID.equals(sheetId)) continue;
            return book.getSheet(i);
        }
        return null;
    }

    public static Sheet getUpdateTableOfBgTemplateSheetID(String sheetId, Book book) throws BOSException, EASBizException {
        return book.getSheetByID(sheetId);
    }

    private static void insertRow(Sheet sheet, Sheet actualSheet, Sheet actualAddSheet, BgRowColIdObject idObject, String insertRowId, Map rowIds, boolean isTemplateUpdateForm) {
        if (sheet == null || idObject == null || StringUtils.isEmpty((String)insertRowId) || rowIds == null) {
            return;
        }
        int rowIndex = idObject.getCurrIndex() + 1;
        Row row = BgNFSHelper.addRowWithOutMode(sheet, rowIndex);
        BgNFSHelper.addRowWithOutMode(actualSheet, rowIndex);
        BgNFSHelper.addRowWithOutMode(actualAddSheet, rowIndex);
        BgNFSHelper.setRowSign(row, insertRowId);
        BgNFSHelper.setRowSource(row, isTemplateUpdateForm ? "DATA_SOURCE_TEMPLATE" : "DATA_SOURCE_SUPERIOR");
        String nextId = idObject.getNext();
        idObject.setNext(insertRowId);
        BgRowColIdObject curr2 = null;
        for (BgRowColIdObject curr2 : rowIds.values()) {
            if (curr2 == null || curr2.getCurrIndex() < row.getRow()) continue;
            curr2.increaseIndex();
        }
        curr2 = new BgRowColIdObject(idObject.getCurrent(), insertRowId, nextId, row.getRow());
        rowIds.put(insertRowId, curr2);
        if (rowIds.get(nextId) != null) {
            curr2 = (BgRowColIdObject)rowIds.get(nextId);
            curr2.setPrior(insertRowId);
        }
    }

    private static void insertCol(Sheet sheet, Sheet actualSheet, Sheet actualAddSheet, BgRowColIdObject idObject, String insertColId, Map colIds, boolean isTemplateUpdateForm) {
        if (sheet == null || idObject == null || StringUtils.isEmpty((String)insertColId) || colIds == null) {
            return;
        }
        int colIndex = idObject.getCurrIndex() + 1;
        Column col = BgNFSHelper.addColumnWithOutMode(sheet, colIndex);
        BgNFSHelper.addColumnWithOutMode(actualSheet, colIndex);
        BgNFSHelper.addColumnWithOutMode(actualAddSheet, colIndex);
        BgNFSHelper.setColSign(col, insertColId);
        BgNFSHelper.setColSource(col, isTemplateUpdateForm ? "DATA_SOURCE_TEMPLATE" : "DATA_SOURCE_SUPERIOR");
        String nextId = idObject.getNext();
        idObject.setNext(insertColId);
        BgRowColIdObject curr2 = null;
        for (BgRowColIdObject curr2 : colIds.values()) {
            if (curr2 == null || curr2.getCurrIndex() < col.getCol()) continue;
            curr2.increaseIndex();
        }
        curr2 = new BgRowColIdObject(idObject.getCurrent(), insertColId, nextId, col.getCol());
        colIds.put(insertColId, curr2);
        if (colIds.get(nextId) != null) {
            curr2 = (BgRowColIdObject)colIds.get(nextId);
            curr2.setPrior(insertColId);
        }
    }

    public static void insertRows(Sheet superSheet, Sheet transSheet, Sheet actualSheet, Sheet actualAddSheet, Map rowIds, Map superMap, boolean isTemplateUpdateForm) {
        int maxRow = superSheet.getMaxRowIndex();
        Row row = null;
        String superRowId = null;
        String endRowId = null;
        int startRow = -1;
        boolean isBack = false;
        int inserted = 0;
        for (int i = 0; i <= maxRow; ++i) {
            row = superSheet.getRow(i, false);
            superRowId = BgNFSHelper.getRowSign(row);
            if (StringUtils.isEmpty((String)superRowId)) continue;
            if (superMap != null && superMap.get(superRowId) instanceof String) {
                endRowId = (String)superMap.get(superRowId);
                startRow = rowIds.containsKey(superRowId) ? -1 : i;
                inserted = 0;
            }
            if (superRowId.equals(endRowId)) {
                if (!isBack && inserted == 1 && startRow >= 0) {
                    i = startRow;
                    isBack = true;
                    continue;
                }
                isBack = false;
            }
            if (BgNFSHelper.checkHasNullSign(row) && !isBack || rowIds.containsKey(superRowId)) continue;
            BgRowColIdObject nextId = BgNAssignUpdateUtil.getInsertRowSignIdForNext(superSheet, i + 1, rowIds);
            if (nextId != null) {
                ++inserted;
                BgNAssignUpdateUtil.insertRow(transSheet, actualSheet, actualAddSheet, nextId, superRowId, rowIds, isTemplateUpdateForm);
                continue;
            }
            nextId = BgNAssignUpdateUtil.getInsertRowSignIdFormPeriov(superSheet, i - 1, rowIds);
            if (nextId == null) {
                nextId = new BgRowColIdObject(null, null, null, transSheet.getMaxRowIndex());
            }
            ++inserted;
            BgNAssignUpdateUtil.insertRow(transSheet, actualSheet, actualAddSheet, nextId, superRowId, rowIds, isTemplateUpdateForm);
        }
    }

    public static void insertCols(Sheet superSheet, Sheet transSheet, Sheet actualSheet, Sheet actualAddSheet, Map colIds, boolean isTemplateUpdateForm) {
        int maxCol = superSheet.getMaxColIndex();
        Column col = null;
        String superColId = null;
        for (int i = 0; i <= maxCol; ++i) {
            col = superSheet.getColumn(i, false);
            superColId = BgNFSHelper.getColSign(col);
            if (StringUtils.isEmpty((String)superColId) || colIds.containsKey(superColId)) continue;
            BgRowColIdObject nextId = BgNAssignUpdateUtil.getInsertColSignIdForNext(superSheet, i + 1, colIds);
            if (nextId != null) {
                BgNAssignUpdateUtil.insertCol(transSheet, actualSheet, actualAddSheet, nextId, superColId, colIds, isTemplateUpdateForm);
                continue;
            }
            nextId = BgNAssignUpdateUtil.getInsertColSignIdFormPeriov(superSheet, i - 1, colIds);
            if (nextId == null) {
                nextId = new BgRowColIdObject(null, null, null, transSheet.getMaxRowIndex());
            }
            BgNAssignUpdateUtil.insertCol(transSheet, actualSheet, actualAddSheet, nextId, superColId, colIds, isTemplateUpdateForm);
        }
    }

    private static BgRowColIdObject getInsertRowSignIdFormPeriov(Sheet sheet, int rowIndex, Map rowIds) {
        BgRowColIdObject id = null;
        String signId = null;
        for (int i = rowIndex; i >= 0; --i) {
            signId = BgNFSHelper.getRowSign(sheet.getRow(i, false));
            if (StringUtils.isEmpty((String)signId) || !rowIds.containsKey(signId)) continue;
            return (BgRowColIdObject)rowIds.get(signId);
        }
        return id;
    }

    private static BgRowColIdObject getInsertColSignIdForNext(Sheet superSheet, int colIndex, Map colIds) {
        String signId = null;
        int maxCol = superSheet.getMaxColIndex();
        for (int i = colIndex; i <= maxCol; ++i) {
            signId = BgNFSHelper.getColSign(superSheet.getColumn(i, false));
            if (StringUtils.isEmpty((String)signId) || !colIds.containsKey(signId)) continue;
            BgRowColIdObject obj = (BgRowColIdObject)colIds.get(signId);
            if (obj.getPrior() == null) {
                return new BgRowColIdObject(null, null, obj.getCurrent(), -1);
            }
            return (BgRowColIdObject)colIds.get(obj.getPrior());
        }
        return null;
    }

    private static BgRowColIdObject getInsertColSignIdFormPeriov(Sheet sheet, int colIndex, Map colIds) {
        BgRowColIdObject id = null;
        String signId = null;
        for (int i = colIndex; i >= 0; --i) {
            signId = BgNFSHelper.getColSign(sheet.getColumn(i, false));
            if (StringUtils.isEmpty((String)signId) || !colIds.containsKey(signId)) continue;
            return (BgRowColIdObject)colIds.get(signId);
        }
        return id;
    }

    private static BgRowColIdObject getInsertRowSignIdForNext(Sheet superSheet, int rowIndex, Map rowIds) {
        String signId = null;
        int maxRow = superSheet.getMaxRowIndex();
        for (int i = rowIndex; i <= maxRow; ++i) {
            signId = BgNFSHelper.getRowSign(superSheet.getRow(i, false));
            if (StringUtils.isEmpty((String)signId) || !rowIds.containsKey(signId)) continue;
            BgRowColIdObject obj = (BgRowColIdObject)rowIds.get(signId);
            if (obj.getPrior() == null) {
                return new BgRowColIdObject(null, null, obj.getCurrent(), -1);
            }
            return (BgRowColIdObject)rowIds.get(obj.getPrior());
        }
        return null;
    }

    public static Map transSheet(Sheet childSheet, Sheet transSheet, boolean isDivExpress) {
        if (childSheet == null) {
            return null;
        }
        Book book = Book.Manager.getNewBook((String)childSheet.getBook().getName());
        Sheet actual = new Sheet(book, childSheet.getSheetName());
        Sheet actualAdd = new Sheet(book, childSheet.getSheetName());
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        LinkedHashMap<String, BgRowColIdObject> colIds = new LinkedHashMap<String, BgRowColIdObject>();
        LinkedHashMap<String, BgRowColIdObject> rowIds = new LinkedHashMap<String, BgRowColIdObject>();
        int maxCol = childSheet.getMaxColIndex();
        int maxRow = childSheet.getMaxRowIndex();
        BgRowColIdObject id = new BgRowColIdObject(null, null, null, 0);
        String sign = null;
        for (int i = 0; i <= maxCol; ++i) {
            Column col = childSheet.getColumn(i, false);
            if (transSheet != null && col != null) {
                Column transCol = transSheet.getColumn(i, true);
                SortedUserObjectArray ss = col.getUserObjects();
                UserObject useObj = null;
                if (ss != null && !ss.isEmpty()) {
                    int ssSize = ss.size();
                    for (int k = 0; k < ssSize; ++k) {
                        useObj = ss.getUserObject(k);
                        transCol.setUserObject(useObj.getKey(), useObj.getValue());
                    }
                }
            }
            if ((sign = BgNFSHelper.getColSign(col)) == null) continue;
            id.setNext(sign);
            id = new BgRowColIdObject(id.getCurrent(), sign, null, col.getCol());
            colIds.put(sign, id);
        }
        Row actualRow = null;
        Row actualAddRow = null;
        String formExpress = null;
        String actualFormula = null;
        String actualAddFormula = null;
        id = new BgRowColIdObject(null, null, null, 0);
        for (int i = 0; i <= maxRow; ++i) {
            Row row = childSheet.getRow(i, false);
            if (transSheet != null && row != null) {
                Row transRow = transSheet.getRow(i, true);
                SortedUserObjectArray ss = row.getUserObjects();
                UserObject useObj = null;
                if (ss != null && !ss.isEmpty()) {
                    int ssSize = ss.size();
                    for (int k = 0; k < ssSize; ++k) {
                        useObj = ss.getUserObject(k);
                        transRow.setUserObject(useObj.getKey(), useObj.getValue());
                    }
                }
            }
            if ((sign = BgNFSHelper.getRowSign(row)) != null) {
                id.setNext(sign);
                id = new BgRowColIdObject(id.getCurrent(), sign, null, row.getRow());
                rowIds.put(sign, id);
            }
            if (!isDivExpress || row == null) continue;
            actualRow = actual.getRow(i, true);
            actualAddRow = actualAdd.getRow(i, true);
            for (int j = 0; j <= maxCol; ++j) {
                Cell tranCell;
                Cell cell = row.getCell(j, false);
                if (cell == null) continue;
                formExpress = BgNTemplateHelper.getBudgetFormula(cell);
                actualFormula = BgNTemplateHelper.getAuctualFormula(cell);
                actualAddFormula = BgNTemplateHelper.getAuctualAddFormula(cell);
                if (!StringUtils.isEmpty((String)actualFormula)) {
                    BgNFSHelper.setExpression(actualRow.getCell(j, true), actualFormula);
                }
                if (!StringUtils.isEmpty((String)actualAddFormula)) {
                    BgNFSHelper.setExpression(actualAddRow.getCell(j, true), actualAddFormula);
                }
                if (transSheet == null || !(tranCell = transSheet.getCell(i, j, true)).hasFormula() && StringUtils.isEmpty((String)formExpress)) continue;
                BgNFSHelper.setExpression(tranCell, formExpress);
            }
        }
        HashMap<String, LinkedHashMap<String, BgRowColIdObject>> resMap = new HashMap<String, LinkedHashMap<String, BgRowColIdObject>>();
        resMap.put("row_id_map", rowIds);
        resMap.put("col_id_map", colIds);
        if (isDivExpress) {
            resMap.put("BG_ACTUAL_EXPRESSIONS", (LinkedHashMap<String, BgRowColIdObject>)actual);
            resMap.put("BG_ADD_EXPRESSIONS", (LinkedHashMap<String, BgRowColIdObject>)actualAdd);
        }
        return resMap;
    }

    public static void removerCol(Sheet transSheet, Sheet actualSheet, Sheet actualAddSheet, Map superColIds, Map colIds) {
        if (transSheet == null || superColIds == null || colIds == null) {
            return;
        }
        int maxCol = transSheet.getMaxColIndex();
        Column col = null;
        BgRowColIdObject id2 = null;
        String signId = null;
        for (int i = 0; i <= maxCol; ++i) {
            col = transSheet.getColumn(i, false);
            signId = BgNFSHelper.getColSign(col);
            boolean isDel = StringUtils.isEmpty((String)signId);
            if (!isDel) {
                boolean bl = isDel = (BgNTemplateHelper.isDataSourceSuperior(col) || BgNTemplateHelper.isDataSourceTemplate(col)) && !superColIds.containsKey(signId);
            }
            if (!isDel) continue;
            BgNFSHelper.removeColumn(transSheet, i);
            BgNFSHelper.removeColumn(actualSheet, i);
            BgNFSHelper.removeColumn(actualAddSheet, i);
            colIds.remove(signId);
            for (BgRowColIdObject id2 : colIds.values()) {
                if (id2 == null || id2.getCurrIndex() < i) continue;
                id2.decreaseIndex();
            }
            --i;
            --maxCol;
        }
    }

    public static void removerRows(Sheet transSheet, Sheet actualSheet, Sheet actualAddSheet, Map superRowIds, Map rowIds) {
        if (transSheet == null || superRowIds == null || rowIds == null) {
            return;
        }
        int maxRow = transSheet.getMaxRowIndex();
        Row row = null;
        BgRowColIdObject id2 = null;
        String signId = null;
        for (int i = 0; i <= maxRow; ++i) {
            row = transSheet.getRow(i, false);
            signId = BgNFSHelper.getRowSign(row);
            boolean isDel = StringUtils.isEmpty((String)signId);
            if (!isDel) {
                boolean bl = isDel = (BgNTemplateHelper.isDataSourceSuperior(row) || BgNTemplateHelper.isDataSourceTemplate(row) || BgNFSHelper.checkHasEnumerateOfRow(row, transSheet.getMaxColIndex())) && !superRowIds.containsKey(signId);
            }
            if (!isDel) continue;
            BgNFSHelper.removeRow(transSheet, i);
            BgNFSHelper.removeRow(actualSheet, i);
            BgNFSHelper.removeRow(actualAddSheet, i);
            rowIds.remove(signId);
            for (BgRowColIdObject id2 : rowIds.values()) {
                if (id2 == null || id2.getCurrIndex() < i) continue;
                id2.decreaseIndex();
            }
            --i;
            --maxRow;
        }
    }

    public static Map getEnumMap(Map sheetEnumMap) {
        HashMap superEnum = new HashMap();
        if (sheetEnumMap != null && !sheetEnumMap.isEmpty()) {
            Map tem2 = null;
            Map enumItem2 = null;
            for (Map tem2 : sheetEnumMap.values()) {
                if (tem2 == null || !(tem2.get("EnumItemArea") instanceof Map) || (tem2 = (Map)tem2.get("EnumItemArea")) == null || tem2.isEmpty()) continue;
                for (Map enumItem2 : tem2.values()) {
                    if (enumItem2 == null) continue;
                    superEnum.put(enumItem2.get("AreaRowId"), enumItem2.get("AreaRow1Id"));
                }
            }
        }
        return superEnum;
    }

    public static Map getEnumerateMap(Book superBook) {
        Map enumMap = null;
        if (superBook != null && superBook.getUserObjectValue("EnumerAteArea") instanceof String) {
            enumMap = (Map)BgAnalyseHelper.getObject((byte[])Base64.decode((String)((String)superBook.getUserObjectValue("EnumerAteArea"))));
        }
        if (enumMap == null) {
            enumMap = new HashMap();
        }
        return enumMap;
    }
}

